/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.file.FileStore;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kafka.server.BrokerBackpressureConfig;
import kafka.server.BrokerBackpressureConfig$;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientQuotaManagerConfig$;
import kafka.server.DiskThrottleListenerManager;
import kafka.server.DiskUsageBasedThrottleListener;
import kafka.server.DiskUsageBasedThrottler;
import kafka.server.DiskUsageBasedThrottlerTest$;
import kafka.server.DiskUsageBasedThrottlingConfig;
import kafka.server.DiskUsageBasedThrottlingConfig$;
import kafka.server.QuotaType;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\u001da\u0001B&M\u0001ECQ\u0001\u0017\u0001\u0005\u0002eCq\u0001\u0018\u0001C\u0002\u0013%Q\f\u0003\u0004b\u0001\u0001\u0006IA\u0018\u0005\bE\u0002\u0011\r\u0011\"\u0003^\u0011\u0019\u0019\u0007\u0001)A\u0005=\"9A\r\u0001b\u0001\n\u0013i\u0006BB3\u0001A\u0003%a\fC\u0004g\u0001\t\u0007I\u0011B4\t\rY\u0004\u0001\u0015!\u0003i\u0011\u001d9\bA1A\u0005\naDqA!\u0019\u0001A\u0003%\u0011\u0010C\u0005\u0002\u0000\u0002\u0011\r\u0011\"\u0003\u0003d!A!Q\r\u0001!\u0002\u0013\u0011\t\u0001C\u0005\u0003\n\u0001\u0011\r\u0011\"\u0003\u0003h!A!q\u000e\u0001!\u0002\u0013\u0011I\u0007C\u0005\u0003r\u0001\u0011\r\u0011\"\u0003\u0003t!A!q\u000f\u0001!\u0002\u0013\u0011)\bC\u0006\u0003z\u0001\u0001\r\u00111A\u0005\n\tm\u0004b\u0003B@\u0001\u0001\u0007\t\u0019!C\u0005\u0005\u0003C1Ba\"\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0003~!9!\u0011\u0012\u0001\u0005\u0002\u0005E\bb\u0002BQ\u0001\u0011\u0005\u0011\u0011\u001f\u0005\b\u0005W\u0003A\u0011AAy\u0011\u001d\u0011)\f\u0001C\u0001\u0003cDqA!/\u0001\t\u0003\t\t\u0010C\u0004\u0003>\u0002!\t!!=\t\u000f\t\u0005\u0007\u0001\"\u0001\u0002r\"9!Q\u0019\u0001\u0005\u0002\u0005E\bb\u0002Be\u0001\u0011\u0005\u0011\u0011\u001f\u0005\b\u0005\u001b\u0004A\u0011AAy\u0011\u001d\u0011\t\u000e\u0001C\u0001\u0003cDqA!6\u0001\t\u0003\t\t\u0010C\u0004\u0003Z\u0002!\t!!=\t\u000f\tu\u0007\u0001\"\u0001\u0002r\"9!\u0011\u001d\u0001\u0005\u0002\u0005E\bb\u0002Bs\u0001\u0011\u0005\u0011\u0011\u001f\u0005\b\u0005S\u0004A\u0011AAy\u0011\u001d\u0011i\u000f\u0001C\u0001\u0003cDqA!=\u0001\t\u0013\u0011\u0019\u0010C\u0005\u0004\u0002\u0001\t\n\u0011\"\u0003\u0004\u0004\u001d)A\u0010\u0014E\u0001{\u001a)1\n\u0014E\u0001}\")\u0001L\u000bC\u0001\u007f\u001a1\u0011\u0011\u0001\u0016\u0001\u0003\u0007Aa\u0001\u0017\u0017\u0005\u0002\u0005U\u0001\u0002CA\u000eY\t\u0007I\u0011A/\t\u000f\u0005uA\u0006)A\u0005=\"A\u0011q\u0004\u0017C\u0002\u0013\u0005Q\fC\u0004\u0002\"1\u0002\u000b\u0011\u00020\t\u0013\u0005\rBF1A\u0005\n\u0005\u0015\u0002\u0002CA\u001eY\u0001\u0006I!a\n\t\u000f\u0005uB\u0006\"\u0011\u0002@!9\u0011Q\u000b\u0017\u0005B\u0005]\u0003bBA0Y\u0011\u0005\u0011\u0011\r\u0005\b\u0003[bC\u0011AA8\u0011\u001d\t\u0019\b\fC!\u0003kBq!a\u001e-\t\u0003\n)\bC\u0004\u0002z1\"\t%!\u001e\t\u000f\u0005mD\u0006\"\u0011\u0002~!9\u00111\u0010\u0017\u0005B\u0005\u001d\u0006bBAVY\u0011\u0005\u0013Q\u0016\u0005\b\u0003\u0007dC\u0011IAc\u0011\u001d\t\t\t\fC!\u0003\u007f1a!!3+\u0001\u0005-\u0007B\u0002-A\t\u0003\t\u0019\u000e\u0003\u0006\u0002X\u0002\u0013\r\u0011\"\u0015M\u00033D\u0001\"!9AA\u0003%\u00111\u001c\u0005\n\u0003G\u0004%\u0019!C\u0001\u0003KA\u0001\"!:AA\u0003%\u0011q\u0005\u0005\b\u0003O\u0004E\u0011IAu\u0011\u001d\ty\u000f\u0011C!\u0003cDq!a=+\t\u0003\t)\u0010C\u0005\u0003D)\n\n\u0011\"\u0001\u0003F!I!1\f\u0016\u0012\u0002\u0013\u0005!Q\f\u0002\u001c\t&\u001c8.V:bO\u0016\u0014\u0015m]3e)\"\u0014x\u000e\u001e;mKJ$Vm\u001d;\u000b\u00055s\u0015AB:feZ,'OC\u0001P\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001*\u0011\u0005M3V\"\u0001+\u000b\u0003U\u000bQa]2bY\u0006L!a\u0016+\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!\f\u0005\u0002\\\u00015\tA*\u0001\u0006uQJ|Wo\u001a5qkR,\u0012A\u0018\t\u0003'~K!\u0001\u0019+\u0003\t1{gnZ\u0001\fi\"\u0014x.^4iaV$\b%A\u0005uQJ,7\u000f[8mI\u0006QA\u000f\u001b:fg\"|G\u000e\u001a\u0011\u0002\u001b1\f'oZ3GS2,7+\u001b>f\u00039a\u0017M]4f\r&dWmU5{K\u0002\nq\u0001\\8h\t&\u00148/F\u0001i!\rIGN\\\u0007\u0002U*\u00111\u000eV\u0001\u000bG>dG.Z2uS>t\u0017BA7k\u0005\r\u0019V-\u001d\t\u0003_Rl\u0011\u0001\u001d\u0006\u0003cJ\fA\u0001\\1oO*\t1/\u0001\u0003kCZ\f\u0017BA;q\u0005\u0019\u0019FO]5oO\u0006AAn\\4ESJ\u001c\b%\u0001\u0006gS2,7\u000b^8sKN,\u0012!\u001f\t\u0004S2T\bCA>-\u001d\tY\u0016&A\u000eESN\\Wk]1hK\n\u000b7/\u001a3UQJ|G\u000f\u001e7feR+7\u000f\u001e\t\u00037*\u001a\"A\u000b*\u0015\u0003u\u0014a\u0003R3uKJl\u0017N\\5ti&\u001cg)\u001b7f'R|'/Z\n\u0004Y\u0005\u0015\u0001\u0003BA\u0004\u0003#i!!!\u0003\u000b\t\u0005-\u0011QB\u0001\u0005M&dWMC\u0002\u0002\u0010I\f1A\\5p\u0013\u0011\t\u0019\"!\u0003\u0003\u0013\u0019KG.Z*u_J,GCAA\f!\r\tI\u0002L\u0007\u0002U\u0005\u0019Bk\u001c;bY\u00063\u0018-\u001b7bE2,')\u001f;fg\u0006!Bk\u001c;bY\u00063\u0018-\u001b7bE2,')\u001f;fg\u0002\n!#\u00138ji&\fG.V:bE2,')\u001f;fg\u0006\u0019\u0012J\\5uS\u0006dWk]1cY\u0016\u0014\u0015\u0010^3tA\u0005q\u0011M^1jY\u0006\u0014G.\u001a\"zi\u0016\u001cXCAA\u0014!\u0011\tI#a\u000e\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\ta!\u0019;p[&\u001c'\u0002BA\u0019\u0003g\t!bY8oGV\u0014(/\u001a8u\u0015\r\t)D]\u0001\u0005kRLG.\u0003\u0003\u0002:\u0005-\"AC!u_6L7\rT8oO\u0006y\u0011M^1jY\u0006\u0014G.\u001a\"zi\u0016\u001c\b%\u0001\u0003oC6,GCAA!!\u0011\t\u0019%!\u0015\u000f\t\u0005\u0015\u0013Q\n\t\u0004\u0003\u000f\"VBAA%\u0015\r\tY\u0005U\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=C+\u0001\u0004Qe\u0016$WMZ\u0005\u0004k\u0006M#bAA()\u0006Q\u0011n\u001d*fC\u0012|e\u000e\\=\u0015\u0005\u0005e\u0003cA*\u0002\\%\u0019\u0011Q\f+\u0003\u000f\t{w\u000e\\3b]\u0006qqO]5uK2\u000b'oZ3GS2,G\u0003BA2\u0003S\u00022aUA3\u0013\r\t9\u0007\u0016\u0002\u0005+:LG\u000f\u0003\u0004\u0002lY\u0002\rAX\u0001\tM&dWmU5{K\u0006yA-\u001a7fi\u0016d\u0015M]4f\r&dW\r\u0006\u0003\u0002d\u0005E\u0004BBA6o\u0001\u0007a,A\u0007hKR$v\u000e^1m'B\f7-\u001a\u000b\u0002=\u0006qq-\u001a;Vg\u0006\u0014G.Z*qC\u000e,\u0017aE4fiVs\u0017\r\u001c7pG\u0006$X\rZ*qC\u000e,\u0017!G:vaB|'\u000f^:GS2,\u0017\t\u001e;sS\n,H/\u001a,jK^$B!!\u0017\u0002\u0000!9\u0011\u0011Q\u001eA\u0002\u0005\r\u0015\u0001\u0002;za\u0016\u0004D!!\"\u0002\u0010B1\u00111IAD\u0003\u0017KA!!#\u0002T\t)1\t\\1tgB!\u0011QRAH\u0019\u0001!A\"!%\u0002\u0000\u0005\u0005\t\u0011!B\u0001\u0003'\u00131a\u0018\u00132#\u0011\t)*a'\u0011\u0007M\u000b9*C\u0002\u0002\u001aR\u0013qAT8uQ&tw\r\u0005\u0003\u0002\u001e\u0006\rVBAAP\u0015\u0011\t\t+!\u0003\u0002\u0013\u0005$HO]5ckR,\u0017\u0002BAS\u0003?\u0013\u0011CR5mK\u0006#HO]5ckR,g+[3x)\u0011\tI&!+\t\u000f\u0005uB\b1\u0001\u0002B\u0005Ir-\u001a;GS2,7\u000b^8sK\u0006#HO]5ckR,g+[3x+\u0011\ty+a-\u0015\t\u0005E\u0016q\u0018\t\u0005\u0003\u001b\u000b\u0019\fB\u0004\u00026v\u0012\r!a.\u0003\u0003Y\u000bB!!&\u0002:B!\u0011QTA^\u0013\u0011\ti,a(\u0003-\u0019KG.Z*u_J,\u0017\t\u001e;sS\n,H/\u001a,jK^Dq!!!>\u0001\u0004\t\t\r\u0005\u0004\u0002D\u0005\u001d\u0015\u0011W\u0001\rO\u0016$\u0018\t\u001e;sS\n,H/\u001a\u000b\u0004%\u0006\u001d\u0007bBAQ}\u0001\u0007\u0011\u0011\t\u0002')\u0016\u001cH/\u00192mK\u0012K7o[+tC\u001e,')Y:fIRC'o\u001c;uY\u0016d\u0015n\u001d;f]\u0016\u00148\u0003\u0002!S\u0003\u001b\u00042aWAh\u0013\r\t\t\u000e\u0014\u0002\u001f\t&\u001c8.V:bO\u0016\u0014\u0015m]3e)\"\u0014x\u000e\u001e;mK2K7\u000f^3oKJ$\"!!6\u0011\u0007\u0005e\u0001)A\u0005rk>$\u0018\rV=qKV\u0011\u00111\u001c\t\u00047\u0006u\u0017bAAp\u0019\nI\u0011+^8uCRK\b/Z\u0001\u000bcV|G/\u0019+za\u0016\u0004\u0013aB2pk:$XM]\u0001\tG>,h\u000e^3sA\u0005\u0011\u0002.\u00198eY\u0016$\u0015n]6Ta\u0006\u001cW\rT8x)\u0011\t\u0019'a;\t\r\u00055h\t1\u0001_\u0003a\u0019\u0017\r\u001d9fIF+x\u000e^1J]\nKH/Z:QKJ\u001cVmY\u0001\u0019Q\u0006tG\r\\3ESN\\7\u000b]1dKJ+7m\u001c<fe\u0016$GCAA2\u000319W\r\u001e+ie>$H\u000f\\3s))\t90!@\u0003\b\t\u0015\"\u0011\b\t\u00047\u0006e\u0018bAA~\u0019\n9B)[:l+N\fw-\u001a\"bg\u0016$G\u000b\u001b:piRdWM\u001d\u0005\n\u0003\u007fD\u0005\u0013!a\u0001\u0005\u0003\taaY8oM&<\u0007cA.\u0003\u0004%\u0019!Q\u0001'\u0003=\u0011K7o[+tC\u001e,')Y:fIRC'o\u001c;uY&twmQ8oM&<\u0007b\u0002B\u0005\u0011\u0002\u0007!1B\u0001\t[>\u001c7\u000eV5nKB!!Q\u0002B\u0011\u001b\t\u0011yA\u0003\u0003\u0003\u0012\tM\u0011!B;uS2\u001c(\u0002\u0002B\u000b\u0005/\taaY8n[>t'bA(\u0003\u001a)!!1\u0004B\u000f\u0003\u0019\t\u0007/Y2iK*\u0011!qD\u0001\u0004_J<\u0017\u0002\u0002B\u0012\u0005\u001f\u0011A\u0001V5nK\"9!q\u0005%A\u0002\t%\u0012AD7pG.4\u0015\u000e\\3Ti>\u0014Xm\u001d\t\u0007\u0005W\u0011)$!\u0002\u000f\t\t5\"\u0011\u0007\b\u0005\u0003\u000f\u0012y#C\u0001V\u0013\r\u0011\u0019\u0004V\u0001\ba\u0006\u001c7.Y4f\u0013\ri'q\u0007\u0006\u0004\u0005g!\u0006\"\u0003B\u001e\u0011B\u0005\t\u0019\u0001B\u001f\u0003-a\u0017n\u001d;f]\u0016\u0014x\n\u001d;\u0011\u000bM\u0013y$!4\n\u0007\t\u0005CK\u0001\u0004PaRLwN\\\u0001\u0017O\u0016$H\u000b\u001b:piRdWM\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!q\t\u0016\u0005\u0005\u0003\u0011Ie\u000b\u0002\u0003LA!!Q\nB,\u001b\t\u0011yE\u0003\u0003\u0003R\tM\u0013!C;oG\",7m[3e\u0015\r\u0011)\u0006V\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B-\u0005\u001f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Y9W\r\u001e+ie>$H\u000f\\3sI\u0011,g-Y;mi\u0012\"TC\u0001B0U\u0011\u0011iD!\u0013\u0002\u0017\u0019LG.Z*u_J,7\u000fI\u000b\u0003\u0005\u0003\tqaY8oM&<\u0007%\u0006\u0002\u0003jA!!Q\u0002B6\u0013\u0011\u0011iGa\u0004\u0003\u00115{7m\u001b+j[\u0016\f\u0011\"\\8dWRKW.\u001a\u0011\u0002\u00111L7\u000f^3oKJ,\"A!\u001e\u0011\u0005m\u0004\u0015!\u00037jgR,g.\u001a:!\u00031!\bN]8ui2,'o\u00149u+\t\u0011i\bE\u0003T\u0005\u007f\t90\u0001\tuQJ|G\u000f\u001e7fe>\u0003Ho\u0018\u0013fcR!\u00111\rBB\u0011%\u0011)iEA\u0001\u0002\u0004\u0011i(A\u0002yIE\nQ\u0002\u001e5s_R$H.\u001a:PaR\u0004\u0013!B:fiV\u0004\bfA\u000b\u0003\u000eB!!q\u0012BO\u001b\t\u0011\tJ\u0003\u0003\u0003\u0014\nU\u0015aA1qS*!!q\u0013BM\u0003\u001dQW\u000f]5uKJTAAa'\u0003\u001e\u0005)!.\u001e8ji&!!q\u0014BI\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fZ8x]\"\u001aaC!*\u0011\t\t=%qU\u0005\u0005\u0005S\u0013\tJA\u0005BMR,'/R1dQ\u0006\tB/Z:u\t\u00164\u0017-\u001e7u\u0007>tg-[4)\u0007]\u0011y\u000b\u0005\u0003\u0003\u0010\nE\u0016\u0002\u0002BZ\u0005#\u0013A\u0001V3ti\u0006qB/Z:u\u0007>tg-[4SK*,7\r^:JY2,w-\u00197WC2,Xm\u001d\u0015\u00041\t=\u0016a\b;fgR\u001cuN\u001c4jOJ+'.Z2ug:+w-\u0019;jm\u00164\u0016\r\\;fg\"\u001a\u0011Da,\u0002CQ,7\u000f^#naRLHj\\4ESJ\u001cH)[:bE2,G\u000b\u001b:piRd\u0017N\\4)\u0007i\u0011y+\u0001\fuKN$H*[:uK:,'OU3hSN$XM]3eQ\rY\"qV\u0001\u0017i\u0016\u001cH\u000fS1oI2,G)[:l'B\f7-\u001a'po\"\u001aADa,\u00021Q,7\u000f^\"baZ\u000bG.^3t\u001f:d\u0015n\u001d;f]\u0016\u00148\u000fK\u0002\u001e\u0005_\u000bA\u0004^3ti\"\u000bg\u000e\u001a7f\t&\u001c8n\u00159bG\u0016\u0014VmY8wKJ,G\rK\u0002\u001f\u0005_\u000ba\u0003^3ti6Kg\u000eR5tWV\u001b\u0018M\u00197f\u0005f$Xm\u001d\u0015\u0004?\t=\u0016!\u0006;fgRl\u0015N\u001c#jg.$v\u000e^1m\u0005f$Xm\u001d\u0015\u0004A\t=\u0016a\u0005;fgR\u0014\u0015m]5d)\"\u0014x\u000e\u001e;mS:<\u0007fA\u0011\u00030\u00069C/Z:u)\"\u0014x.^4iaV$\u0018j]+qI\u0006$X\r\u001a#ve&tw\r\u00165s_R$H.\u001b8hQ\r\u0011#qV\u0001\u001ai\u0016\u001cH/\u00128bE2,g\t\\1h\u0013N\u0014Vm\u001d9fGR,G\rK\u0002$\u0005_\u000b1\u0003^3tiRKW.Z%t%\u0016\u001c\b/Z2uK\u0012D3\u0001\nBX\u0003Y\"Xm\u001d;ESN\\G\u000b\u001b:piRd\u0017N\\4Jg&sG-\u001a9f]\u0012,g\u000e\u001e$s_6\u0004&o\u001c3vG\u0016\u0014\u0015mY6qe\u0016\u001c8/\u001e:fQ\r)#qV\u0001\u001bi\u0016\u001cH/\u00118z\u0019&\u001cH/\u001a8fe&\u001bH\u000b\u001b:piRdW\r\u001a\u0015\u0004M\t=\u0016\u0001F<ji\"d\u0015M]4f\r&dWm\u0016:jiR,g\u000e\u0006\u0004\u0002d\tU(q \u0005\b\u0005o<\u0003\u0019\u0001B}\u0003\u0015IgN\\3s!\u0019\u0019&1 0\u0002d%\u0019!Q +\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0002CA6OA\u0005\t\u0019\u00010\u0002=]LG\u000f\u001b'be\u001e,g)\u001b7f/JLG\u000f^3oI\u0011,g-Y;mi\u0012\u0012TCAB\u0003U\rq&\u0011\n")
public class DiskUsageBasedThrottlerTest {
    private final long throughput;
    private final long threshold;
    private final long largeFileSize;
    private final Seq<String> logDirs = new .colon.colon((Object)"/some/fileA", (List)new .colon.colon((Object)"/some/fileB", (List)Nil$.MODULE$));
    private final Seq<DeterministicFileStore> kafka$server$DiskUsageBasedThrottlerTest$$fileStores = new .colon.colon((Object)new DeterministicFileStore(), (List)new .colon.colon((Object)new DeterministicFileStore(), (List)Nil$.MODULE$));
    private final DiskUsageBasedThrottlingConfig config = DiskUsageBasedThrottlingConfig$.MODULE$.apply(this.threshold(), this.throughput(), this.logDirs(), true, 500L, DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$6(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$7());
    private final MockTime kafka$server$DiskUsageBasedThrottlerTest$$mockTime = new MockTime();
    private final TestableDiskUsageBasedThrottleListener kafka$server$DiskUsageBasedThrottlerTest$$listener = new TestableDiskUsageBasedThrottleListener();
    private Option<DiskUsageBasedThrottler> throttlerOpt;

    public static Option<DiskUsageBasedThrottleListener> getThrottler$default$4() {
        return DiskUsageBasedThrottlerTest$.MODULE$.getThrottler$default$4();
    }

    public static DiskUsageBasedThrottlingConfig getThrottler$default$1() {
        return DiskUsageBasedThrottlerTest$.MODULE$.getThrottler$default$1();
    }

    public static DiskUsageBasedThrottler getThrottler(DiskUsageBasedThrottlingConfig diskUsageBasedThrottlingConfig, Time time, Seq<FileStore> seq, Option<DiskUsageBasedThrottleListener> option) {
        return DiskUsageBasedThrottlerTest$.MODULE$.getThrottler(diskUsageBasedThrottlingConfig, time, seq, option);
    }

    private long throughput() {
        return this.throughput;
    }

    private long threshold() {
        return this.threshold;
    }

    private long largeFileSize() {
        return this.largeFileSize;
    }

    private Seq<String> logDirs() {
        return this.logDirs;
    }

    public Seq<DeterministicFileStore> kafka$server$DiskUsageBasedThrottlerTest$$fileStores() {
        return this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores;
    }

    private DiskUsageBasedThrottlingConfig config() {
        return this.config;
    }

    public MockTime kafka$server$DiskUsageBasedThrottlerTest$$mockTime() {
        return this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime;
    }

    public TestableDiskUsageBasedThrottleListener kafka$server$DiskUsageBasedThrottlerTest$$listener() {
        return this.kafka$server$DiskUsageBasedThrottlerTest$$listener;
    }

    private Option<DiskUsageBasedThrottler> throttlerOpt() {
        return this.throttlerOpt;
    }

    private void throttlerOpt_$eq(Option<DiskUsageBasedThrottler> x$1) {
        this.throttlerOpt = x$1;
    }

    @BeforeEach
    public void setup() {
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)None$.MODULE$);
    }

    @AfterEach
    public void teardown() {
        this.throttlerOpt().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            DiskUsageBasedThrottlerTest.$anonfun$teardown$1(this, x$1);
            return BoxedUnit.UNIT;
        });
        this.throttlerOpt().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.removeDiskThrottlerMetrics();
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDefaultConfig() {
        DiskUsageBasedThrottlingConfig defaultConfig = DiskUsageBasedThrottlingConfig$.MODULE$.apply(DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$1(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$2(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$3(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$4(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$5(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$6(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$7());
        Assertions.assertFalse((boolean)defaultConfig.enableDiskBasedThrottling());
        Assertions.assertEquals((long)0x500000000L, (long)defaultConfig.freeDiskThresholdBytes());
        Assertions.assertEquals((long)131072L, (long)defaultConfig.throttledProduceThroughput());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)defaultConfig.logDirs());
    }

    @Test
    public void testConfigRejectsIllegalValues() {
        DiskUsageBasedThrottlingConfig configWithIllegalValues = DiskUsageBasedThrottlingConfig$.MODULE$.apply(10L, 42L, DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$3(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$4(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$5(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$6(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$7());
        Assertions.assertEquals((long)DiskUsageBasedThrottlingConfig$.MODULE$.MinDiskThresholdBytes(), (long)configWithIllegalValues.freeDiskThresholdBytes());
        Assertions.assertEquals((long)DiskUsageBasedThrottlingConfig$.MODULE$.MinThroughputBytesPerSec(), (long)configWithIllegalValues.throttledProduceThroughput());
    }

    @Test
    public void testConfigRejectsNegativeValues() {
        DiskUsageBasedThrottlingConfig configWithIllegalValues = DiskUsageBasedThrottlingConfig$.MODULE$.apply(-10L, -42L, DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$3(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$4(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$5(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$6(), DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$7());
        Assertions.assertEquals((long)DiskUsageBasedThrottlingConfig$.MODULE$.MinDiskThresholdBytes(), (long)configWithIllegalValues.freeDiskThresholdBytes());
        Assertions.assertEquals((long)DiskUsageBasedThrottlingConfig$.MODULE$.MinThroughputBytesPerSec(), (long)configWithIllegalValues.throttledProduceThroughput());
    }

    @Test
    public void testEmptyLogDirsDisableThrottling() {
        Nil$ x$1 = Nil$.MODULE$;
        boolean x$2 = true;
        long x$3 = DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$1();
        long x$4 = DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$2();
        long x$5 = DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$5();
        double x$6 = DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$6();
        boolean x$7 = DiskUsageBasedThrottlingConfig$.MODULE$.apply$default$7();
        DiskUsageBasedThrottlingConfig configWithEmptyLogDirs = DiskUsageBasedThrottlingConfig$.MODULE$.apply(x$3, x$4, (Seq)x$1, x$2, x$5, x$6, x$7);
        Assertions.assertFalse((boolean)configWithEmptyLogDirs.enableDiskBasedThrottling());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)configWithEmptyLogDirs.logDirs());
    }

    @Test
    public void testListenerRegistered() {
        TestableDiskUsageBasedThrottleListener newListener = new TestableDiskUsageBasedThrottleListener();
        DiskUsageBasedThrottler throttler = DiskUsageBasedThrottlerTest$.MODULE$.getThrottler(this.config(), (Time)this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores(), DiskUsageBasedThrottlerTest$.MODULE$.getThrottler$default$4());
        throttler.listenerManager().registerListener((DiskUsageBasedThrottleListener)newListener);
        Assertions.assertTrue((boolean)throttler.listenerManager().getListeners().contains((Object)newListener));
        throttler.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)newListener);
        Assertions.assertFalse((boolean)throttler.listenerManager().getListeners().contains((Object)newListener));
    }

    @Test
    public void testHandleDiskSpaceLow() {
        this.kafka$server$DiskUsageBasedThrottlerTest$$listener().handleDiskSpaceLow(this.throughput());
        Assertions.assertEquals((long)this.throughput(), (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
    }

    @Test
    public void testCapValuesOnListeners() {
        TestableDiskUsageBasedThrottleListener produceListener = new TestableDiskUsageBasedThrottleListener();
        TestableDiskUsageBasedThrottleListener followerListener = new TestableDiskUsageBasedThrottleListener(null){
            private final QuotaType quotaType;

            public QuotaType quotaType() {
                return this.quotaType;
            }
            {
                this.quotaType = QuotaType.FollowerReplication$.MODULE$;
            }
        };
        DiskUsageBasedThrottler throttler = DiskUsageBasedThrottlerTest$.MODULE$.getThrottler(this.config(), (Time)this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores(), DiskUsageBasedThrottlerTest$.MODULE$.getThrottler$default$4());
        throttler.listenerManager().registerListener((DiskUsageBasedThrottleListener)produceListener);
        throttler.listenerManager().registerListener((DiskUsageBasedThrottleListener)followerListener);
        Predef$.MODULE$.println((Object)throttler.listenerManager().getListeners());
        throttler.createDiskThrottlerMetrics();
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)throttler));
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        DeterministicFileStore withLargeFileWritten_fileStore = (DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testCapValuesOnListeners$1(this, throttler, produceListener, followerListener, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
        throttler.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)produceListener);
        throttler.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)followerListener);
    }

    @Test
    public void testHandleDiskSpaceRecovered() {
        this.kafka$server$DiskUsageBasedThrottlerTest$$listener().handleDiskSpaceRecovered();
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
    }

    @Test
    public void testMinDiskUsableBytes() {
        DiskUsageBasedThrottler throttler = DiskUsageBasedThrottlerTest$.MODULE$.getThrottler(this.config(), (Time)this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores(), DiskUsageBasedThrottlerTest$.MODULE$.getThrottler$default$4());
        long previousUsableSpaceBytes = throttler.minDiskUsableBytes();
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        DeterministicFileStore withLargeFileWritten_fileStore = (DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testMinDiskUsableBytes$1(this, throttler, previousUsableSpaceBytes, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
    }

    @Test
    public void testMinDiskTotalBytes() {
        DiskUsageBasedThrottler throttler = DiskUsageBasedThrottlerTest$.MODULE$.getThrottler(this.config(), (Time)this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores(), DiskUsageBasedThrottlerTest$.MODULE$.getThrottler$default$4());
        long existingTotalBytes = throttler.minDiskTotalBytes();
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        DeterministicFileStore withLargeFileWritten_fileStore = (DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testMinDiskTotalBytes$1(throttler, existingTotalBytes, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
    }

    @Test
    public void testBasicThrottling() {
        long threshold = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getUsableSpace()), Seq$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$)) - this.largeFileSize() + 1L;
        DiskUsageBasedThrottler throttler = DiskUsageBasedThrottlerTest$.MODULE$.getThrottler(this.config().copy(threshold, this.config().copy$default$2(), this.config().copy$default$3(), this.config().copy$default$4(), this.config().copy$default$5(), this.config().copy$default$6(), this.config().copy$default$7()), (Time)this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores(), (Option<DiskUsageBasedThrottleListener>)new Some((Object)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        throttler.createDiskThrottlerMetrics();
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)throttler));
        throttler.checkAndUpdateQuotaOnDiskUsage(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertFalse((boolean)throttler.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler.producerThrottleRate());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        DeterministicFileStore withLargeFileWritten_fileStore = (DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testBasicThrottling$2(this, throttler, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
        throttler.checkAndUpdateQuotaOnDiskUsage(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertFalse((boolean)throttler.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler.producerThrottleRate());
    }

    @Test
    public void testThroughputIsUpdatedDuringThrottling() {
        long threshold = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.getUsableSpace()), Seq$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$)) - this.largeFileSize() + 1L;
        DiskUsageBasedThrottler throttler = DiskUsageBasedThrottlerTest$.MODULE$.getThrottler(this.config().copy(threshold, this.config().copy$default$2(), this.config().copy$default$3(), this.config().copy$default$4(), this.config().copy$default$5(), this.config().copy$default$6(), this.config().copy$default$7()), (Time)this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores(), (Option<DiskUsageBasedThrottleListener>)new Some((Object)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        throttler.createDiskThrottlerMetrics();
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)throttler));
        throttler.checkAndUpdateQuotaOnDiskUsage(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertFalse((boolean)throttler.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler.producerThrottleRate());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        DeterministicFileStore withLargeFileWritten_fileStore = (DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testThroughputIsUpdatedDuringThrottling$2(this, throttler, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
    }

    @Test
    public void testEnableFlagIsRespected() {
        long threshold = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.getUsableSpace()), Seq$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$)) - this.largeFileSize() + 1L;
        boolean x$2 = false;
        long x$3 = this.config().copy$default$2();
        Seq x$4 = this.config().copy$default$3();
        long x$5 = this.config().copy$default$5();
        double x$6 = this.config().copy$default$6();
        boolean x$7 = this.config().copy$default$7();
        DiskUsageBasedThrottler throttler = DiskUsageBasedThrottlerTest$.MODULE$.getThrottler(this.config().copy(threshold, x$3, x$4, x$2, x$5, x$6, x$7), (Time)this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores(), DiskUsageBasedThrottlerTest$.MODULE$.getThrottler$default$4());
        throttler.createDiskThrottlerMetrics();
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)throttler));
        throttler.checkAndUpdateQuotaOnDiskUsage(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertFalse((boolean)throttler.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler.producerThrottleRate());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        DeterministicFileStore withLargeFileWritten_fileStore = (DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testEnableFlagIsRespected$2(this, throttler, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
    }

    @Test
    public void testTimeIsRespected() {
        long threshold = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.getUsableSpace()), Seq$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$)) - this.largeFileSize() + 1L;
        long x$2 = 1000L;
        long x$3 = this.config().copy$default$2();
        Seq x$4 = this.config().copy$default$3();
        boolean x$5 = this.config().copy$default$4();
        double x$6 = this.config().copy$default$6();
        boolean x$7 = this.config().copy$default$7();
        DiskUsageBasedThrottler throttler = DiskUsageBasedThrottlerTest$.MODULE$.getThrottler(this.config().copy(threshold, x$3, x$4, x$5, x$2, x$6, x$7), (Time)this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores(), (Option<DiskUsageBasedThrottleListener>)new Some((Object)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        throttler.createDiskThrottlerMetrics();
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)throttler));
        throttler.checkAndUpdateQuotaOnDiskUsage(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertFalse((boolean)throttler.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler.producerThrottleRate());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        DeterministicFileStore withLargeFileWritten_fileStore = (DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testTimeIsRespected$2(this, throttler, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
    }

    @Test
    public void testDiskThrottlingIsIndependentFromProduceBackpressure() {
        BrokerBackpressureConfig x$1 = new BrokerBackpressureConfig(BrokerBackpressureConfig$.MODULE$.apply$default$1(), BrokerBackpressureConfig$.MODULE$.apply$default$2(), BrokerBackpressureConfig$.MODULE$.apply$default$3(), BrokerBackpressureConfig$.MODULE$.apply$default$4(), BrokerBackpressureConfig$.MODULE$.apply$default$5(), BrokerBackpressureConfig$.MODULE$.apply$default$6());
        DiskUsageBasedThrottlingConfig x$2 = this.config();
        int x$3 = ClientQuotaManagerConfig$.MODULE$.apply$default$1();
        int x$4 = ClientQuotaManagerConfig$.MODULE$.apply$default$2();
        double x$5 = ClientQuotaManagerConfig$.MODULE$.apply$default$5();
        ClientQuotaManagerConfig quotaManagerConfig = new ClientQuotaManagerConfig(x$3, x$4, x$1, x$2, x$5);
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this, quotaManagerConfig){
            private final DiskThrottleListenerManager listenerManager;
            private final /* synthetic */ DiskUsageBasedThrottlerTest $outer;

            public Seq<FileStore> getFileStores() {
                return this.$outer.kafka$server$DiskUsageBasedThrottlerTest$$fileStores();
            }

            public DiskThrottleListenerManager listenerManager() {
                return this.listenerManager;
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(quotaManagerConfig$1, new Metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)$outer.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), "someThread", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6(), ClientQuotaManager$.MODULE$.$lessinit$greater$default$7());
                DiskThrottleListenerManager manager = new DiskThrottleListenerManager(null){
                    private final ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners;

                    public void registerListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.registerListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public void deRegisterListener(DiskUsageBasedThrottleListener listener) {
                        DiskThrottleListenerManager.deRegisterListener$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public Set<DiskUsageBasedThrottleListener> getListeners() {
                        return DiskThrottleListenerManager.getListeners$((DiskThrottleListenerManager)this);
                    }

                    public boolean anyListenerIsThrottled() {
                        return DiskThrottleListenerManager.anyListenerIsThrottled$((DiskThrottleListenerManager)this);
                    }

                    public boolean diskThrottlingActive(DiskUsageBasedThrottleListener listener) {
                        return DiskThrottleListenerManager.diskThrottlingActive$((DiskThrottleListenerManager)this, (DiskUsageBasedThrottleListener)listener);
                    }

                    public ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> kafka$server$DiskThrottleListenerManager$$listeners() {
                        return this.kafka$server$DiskThrottleListenerManager$$listeners;
                    }

                    public final void kafka$server$DiskThrottleListenerManager$_setter_$kafka$server$DiskThrottleListenerManager$$listeners_$eq(ConcurrentHashMap<DiskUsageBasedThrottleListener, Object> x$1) {
                        this.kafka$server$DiskThrottleListenerManager$$listeners = x$1;
                    }
                    {
                        DiskThrottleListenerManager.$init$((DiskThrottleListenerManager)this);
                    }
                };
                manager.registerListener((DiskUsageBasedThrottleListener)$outer.kafka$server$DiskUsageBasedThrottlerTest$$listener());
                this.listenerManager = var3_3;
            }
        };
        clientQuotaManager.createDiskThrottlerMetrics();
        this.throttlerOpt_$eq((Option<DiskUsageBasedThrottler>)new Some((Object)clientQuotaManager));
        clientQuotaManager.listenerManager().registerListener((DiskUsageBasedThrottleListener)clientQuotaManager);
        clientQuotaManager.updateBrokerQuotaLimit(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertFalse((boolean)clientQuotaManager.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)0L, (long)clientQuotaManager.producerThrottleRate());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        DeterministicFileStore withLargeFileWritten_fileStore = (DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testDiskThrottlingIsIndependentFromProduceBackpressure$1(this, clientQuotaManager, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
        clientQuotaManager.updateBrokerQuotaLimit(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertFalse((boolean)clientQuotaManager.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        clientQuotaManager.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)clientQuotaManager);
        Assertions.assertEquals((long)0L, (long)clientQuotaManager.producerThrottleRate());
    }

    @Test
    public void testAnyListenerIsThrottled() {
        long threshold = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.getUsableSpace()), Seq$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Long$.MODULE$)) - this.largeFileSize() + 1L;
        DiskUsageBasedThrottler throttler = DiskUsageBasedThrottlerTest$.MODULE$.getThrottler(this.config().copy(threshold, this.config().copy$default$2(), this.config().copy$default$3(), this.config().copy$default$4(), this.config().copy$default$5(), this.config().copy$default$6(), this.config().copy$default$7()), (Time)this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime(), this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores(), (Option<DiskUsageBasedThrottleListener>)new Some((Object)this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        throttler.checkAndUpdateQuotaOnDiskUsage(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertFalse((boolean)throttler.listenerManager().anyListenerIsThrottled());
        long withLargeFileWritten_fileSize = this.withLargeFileWritten$default$2();
        DeterministicFileStore withLargeFileWritten_fileStore = (DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        withLargeFileWritten_fileStore.writeLargeFile(withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        DiskUsageBasedThrottlerTest.$anonfun$testAnyListenerIsThrottled$2(this, throttler, withLargeFileWritten_fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        withLargeFileWritten_fileStore.deleteLargeFile(withLargeFileWritten_fileSize);
        throttler.checkAndUpdateQuotaOnDiskUsage(this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertFalse((boolean)throttler.listenerManager().anyListenerIsThrottled());
    }

    private void withLargeFileWritten(Function1<Object, BoxedUnit> inner, long fileSize) {
        DeterministicFileStore fileStore = (DeterministicFileStore)this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().head();
        fileStore.writeLargeFile(fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        inner.apply$mcVJ$sp(fileSize);
        this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        fileStore.deleteLargeFile(fileSize);
    }

    private long withLargeFileWritten$default$2() {
        return this.largeFileSize();
    }

    public static final /* synthetic */ void $anonfun$teardown$1(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler x$1) {
        x$1.listenerManager().deRegisterListener((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener());
    }

    public static final /* synthetic */ void $anonfun$testCapValuesOnListeners$1(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$1, TestableDiskUsageBasedThrottleListener produceListener$1, TestableDiskUsageBasedThrottleListener followerListener$1, long x$3) {
        throttler$1.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)$this.throughput(), (long)produceListener$1.counter().get());
        Assertions.assertEquals((long)$this.throughput(), (long)throttler$1.producerThrottleRate());
        Assertions.assertEquals((long)(2L * $this.throughput()), (long)followerListener$1.counter().get());
        Assertions.assertEquals((long)(2L * $this.throughput()), (long)throttler$1.followerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testMinDiskUsableBytes$1(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$2, long previousUsableSpaceBytes$1, long fileSize) {
        long currentUsableBytes = throttler$2.minDiskUsableBytes();
        Assertions.assertEquals((long)(previousUsableSpaceBytes$1 - fileSize), (long)currentUsableBytes);
        Assertions.assertEquals((long)previousUsableSpaceBytes$1, (long)((DeterministicFileStore)$this.kafka$server$DiskUsageBasedThrottlerTest$$fileStores().apply(1)).getUsableSpace());
    }

    public static final /* synthetic */ void $anonfun$testMinDiskTotalBytes$1(DiskUsageBasedThrottler throttler$3, long existingTotalBytes$1, long x$4) {
        long currentTotalBytes = throttler$3.minDiskTotalBytes();
        Assertions.assertEquals((long)existingTotalBytes$1, (long)currentTotalBytes);
    }

    public static final /* synthetic */ void $anonfun$testBasicThrottling$2(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$4, long x$6) {
        throttler$4.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)$this.throughput(), (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)$this.throughput(), (long)BoxesRunTime.unboxToLong((Object)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().lastSignalledQuotaOptRef().get().get()));
        Assertions.assertTrue((boolean)throttler$4.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)$this.throughput(), (long)throttler$4.producerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testThroughputIsUpdatedDuringThrottling$2(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$5, long x$8) {
        throttler$5.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)$this.throughput(), (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)$this.throughput(), (long)BoxesRunTime.unboxToLong((Object)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().lastSignalledQuotaOptRef().get().get()));
        Assertions.assertTrue((boolean)throttler$5.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)$this.throughput(), (long)throttler$5.producerThrottleRate());
        long updatedThroughput = 10L * $this.throughput();
        DiskUsageBasedThrottlingConfig qual$1 = throttler$5.getCurrentDiskThrottlingConfig();
        long x$2 = qual$1.copy$default$1();
        Seq x$3 = qual$1.copy$default$3();
        boolean x$4 = qual$1.copy$default$4();
        long x$5 = qual$1.copy$default$5();
        double x$6 = qual$1.copy$default$6();
        boolean x$7 = qual$1.copy$default$7();
        DiskUsageBasedThrottlingConfig updatedConfig = qual$1.copy(x$2, updatedThroughput, x$3, x$4, x$5, x$6, x$7);
        $this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(501L);
        throttler$5.updateDiskThrottlingConfig(updatedConfig);
        throttler$5.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)updatedThroughput, (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)updatedThroughput, (long)BoxesRunTime.unboxToLong((Object)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().lastSignalledQuotaOptRef().get().get()));
        Assertions.assertTrue((boolean)throttler$5.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)updatedThroughput, (long)throttler$5.producerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testEnableFlagIsRespected$2(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$6, long x$10) {
        throttler$6.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertFalse((boolean)throttler$6.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler$6.producerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testTimeIsRespected$2(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$7, long x$12) {
        throttler$7.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertFalse((boolean)throttler$7.listenerManager().diskThrottlingActive((DiskUsageBasedThrottleListener)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener()));
        Assertions.assertEquals((long)0L, (long)throttler$7.producerThrottleRate());
        $this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().sleep(500L);
        throttler$7.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)$this.throughput(), (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)$this.throughput(), (long)BoxesRunTime.unboxToLong((Object)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().lastSignalledQuotaOptRef().get().get()));
        Assertions.assertEquals((long)$this.throughput(), (long)throttler$7.producerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testDiskThrottlingIsIndependentFromProduceBackpressure$1(DiskUsageBasedThrottlerTest $this, ClientQuotaManager clientQuotaManager$1, long x$13) {
        clientQuotaManager$1.updateBrokerQuotaLimit($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertEquals((long)$this.throughput(), (long)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().counter().get());
        Assertions.assertEquals((long)$this.throughput(), (long)BoxesRunTime.unboxToLong((Object)$this.kafka$server$DiskUsageBasedThrottlerTest$$listener().lastSignalledQuotaOptRef().get().get()));
        Assertions.assertEquals((long)$this.throughput(), (long)clientQuotaManager$1.producerThrottleRate());
    }

    public static final /* synthetic */ void $anonfun$testAnyListenerIsThrottled$2(DiskUsageBasedThrottlerTest $this, DiskUsageBasedThrottler throttler$8, long x$15) {
        throttler$8.checkAndUpdateQuotaOnDiskUsage($this.kafka$server$DiskUsageBasedThrottlerTest$$mockTime().milliseconds());
        Assertions.assertTrue((boolean)throttler$8.listenerManager().anyListenerIsThrottled());
    }

    public DiskUsageBasedThrottlerTest() {
        this.throughput = 65536L;
        this.threshold = 0x140000000L;
        this.largeFileSize = 0x300000000L;
    }

    public static class DeterministicFileStore
    extends FileStore {
        private final long TotalAvailableBytes;
        private final long InitialUsableBytes;
        private final AtomicLong availableBytes = new AtomicLong(this.InitialUsableBytes());

        public long TotalAvailableBytes() {
            return this.TotalAvailableBytes;
        }

        public long InitialUsableBytes() {
            return this.InitialUsableBytes;
        }

        private AtomicLong availableBytes() {
            return this.availableBytes;
        }

        @Override
        public String name() {
            return this.getClass().getName();
        }

        @Override
        public boolean isReadOnly() {
            return false;
        }

        public void writeLargeFile(long fileSize) {
            if (fileSize > this.availableBytes().get()) {
                throw new IllegalArgumentException(new StringBuilder(48).append("Can't write a file with size ").append(fileSize).append(" > available size: ").append(this.availableBytes().get()).toString());
            }
            this.availableBytes().updateAndGet(x$16 -> x$16 - fileSize);
        }

        public void deleteLargeFile(long fileSize) {
            if (this.availableBytes().get() + fileSize > this.TotalAvailableBytes()) {
                throw new IllegalArgumentException("Can't delete the large file, because the file might not have been written already");
            }
            this.availableBytes().addAndGet(fileSize);
        }

        @Override
        public long getTotalSpace() {
            return this.TotalAvailableBytes();
        }

        @Override
        public long getUsableSpace() {
            return this.availableBytes().get();
        }

        @Override
        public long getUnallocatedSpace() {
            return this.TotalAvailableBytes() - this.availableBytes().get();
        }

        @Override
        public boolean supportsFileAttributeView(Class<? extends FileAttributeView> type) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }

        @Override
        public boolean supportsFileAttributeView(String name) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }

        @Override
        public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> type) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }

        @Override
        public Object getAttribute(String attribute) {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }

        @Override
        public String type() {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }

        public DeterministicFileStore() {
            this.TotalAvailableBytes = 0x500000000L;
            this.InitialUsableBytes = 0x3C0000000L;
        }
    }

    public static class TestableDiskUsageBasedThrottleListener
    implements DiskUsageBasedThrottleListener {
        private final QuotaType quotaType;
        private final AtomicLong counter;
        private final AtomicReference<Option<Object>> lastSignalledQuotaOptRef;

        public AtomicReference<Option<Object>> lastSignalledQuotaOptRef() {
            return this.lastSignalledQuotaOptRef;
        }

        public void kafka$server$DiskUsageBasedThrottleListener$_setter_$lastSignalledQuotaOptRef_$eq(AtomicReference<Option<Object>> x$1) {
            this.lastSignalledQuotaOptRef = x$1;
        }

        public QuotaType quotaType() {
            return this.quotaType;
        }

        public AtomicLong counter() {
            return this.counter;
        }

        public void handleDiskSpaceLow(long cappedQuotaInBytesPerSec) {
            this.counter().set(cappedQuotaInBytesPerSec);
        }

        public void handleDiskSpaceRecovered() {
            this.counter().set(Long.MAX_VALUE);
        }

        public TestableDiskUsageBasedThrottleListener() {
            DiskUsageBasedThrottleListener.$init$((DiskUsageBasedThrottleListener)this);
            this.quotaType = QuotaType.Produce$.MODULE$;
            this.counter = new AtomicLong(Long.MAX_VALUE);
        }
    }
}

