/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import io.confluent.kafka.http.server.KafkaHttpServer;
import io.confluent.kafka.security.auth.plain.DynamicPlainCredential;
import io.confluent.kafka.security.auth.plain.DynamicPlainLoginCallbackHandler;
import io.confluent.kafka.security.auth.plain.DynamicPlainLoginModule;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import kafka.server.BrokerReconfigurable;
import kafka.server.Defaults$;
import kafka.server.DynamicBalancerConfig;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicBrokerConfigTest;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLoginContext;
import kafka.server.DynamicLoginManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.TestDynamicThreadPool;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.LoginManager;
import org.apache.kafka.common.security.plain.PlainLoginModule;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\u0014)\u00015BQ\u0001\u000e\u0001\u0005\u0002UBQ\u0001\u000f\u0001\u0005\u0002eBQA\u0013\u0001\u0005\u0002eBQa\u0014\u0001\u0005\u0002eBQ!\u0015\u0001\u0005\u0002eBQa\u0015\u0001\u0005\u0002eBQ!\u0016\u0001\u0005\u0002eBQa\u0016\u0001\u0005\u0002eBQ!\u0017\u0001\u0005\u0002eBQa\u0017\u0001\u0005\u0002eBQ!\u0018\u0001\u0005\u0002eBQa\u0018\u0001\u0005\u0002eBQ!\u0019\u0001\u0005\u0002eBQa\u0019\u0001\u0005\u0002eBQ!\u001a\u0001\u0005\u0002eBQa\u001a\u0001\u0005\n!Dq!a\u0004\u0001\t\u0013\t\t\u0002\u0003\u0004\u0002B\u0001!\t!\u000f\u0005\u0007\u0003\u000b\u0002A\u0011A\u001d\t\r\u0005%\u0003\u0001\"\u0001:\u0011\u0019\ti\u0005\u0001C\u0001s!1\u0011\u0011\u000b\u0001\u0005\u0002eBa!!\u0016\u0001\t\u0003I\u0004BBA-\u0001\u0011\u0005\u0011\b\u0003\u0004\u0002^\u0001!\t!\u000f\u0005\u0007\u0003C\u0002A\u0011A\u001d\t\r\u0005\u0015\u0004\u0001\"\u0001:\u0011\u0019\tI\u0007\u0001C\u0001s!1\u0011Q\u000e\u0001\u0005\u0002eBa!!\u001d\u0001\t\u0003I\u0004BBA;\u0001\u0011\u0005\u0011\b\u0003\u0004\u0002z\u0001!\t!\u000f\u0005\u0007\u0003{\u0002A\u0011A\u001d\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0002\u0004\"9\u0011Q\u0012\u0001\u0005\n\u0005=\u0005\"CAP\u0001E\u0005I\u0011BAQ\u0011\u001d\t9\f\u0001C\u0005\u0003sCq!a3\u0001\t\u0013\tiMA\fEs:\fW.[2Ce>\\WM]\"p]\u001aLw\rV3ti*\u0011\u0011FK\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003-\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001]A\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u001c\u0011\u0005]\u0002Q\"\u0001\u0015\u0002\u0011Q,\u0017M\u001d#po:$\u0012A\u000f\t\u0003_mJ!\u0001\u0010\u0019\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005y\u0002\"a\u0010%\u000e\u0003\u0001S!!\u0011\"\u0002\u0007\u0005\u0004\u0018N\u0003\u0002D\t\u00069!.\u001e9ji\u0016\u0014(BA#G\u0003\u0015QWO\\5u\u0015\u00059\u0015aA8sO&\u0011\u0011\n\u0011\u0002\n\u0003\u001a$XM]#bG\"\f\u0001\u0003^3ti\u000e{gNZ5h+B$\u0017\r^3)\u0005\ra\u0005CA N\u0013\tq\u0005I\u0001\u0003UKN$\u0018A\n;fgR\u001cuN\u001c4jOV\u0003H-\u0019;f/&$\bnU8nK&sg/\u00197jI\u000e{gNZ5hg\"\u0012A\u0001T\u00014i\u0016\u001cHoQ8oM&<W\u000b\u001d3bi\u0016<\u0016\u000e\u001e5SK\u000e|gNZ5hkJ\f'\r\\3WC2LG-\u0019;j_:4\u0015-\u001b7ve\u0016D#!\u0002'\u00029Q,7\u000f\u001e*fG>tg-[4ve\u0006\u0014G.\u001a,bY&$\u0017\r^5p]\"\u0012a\u0001T\u0001\u0014i\u0016\u001cHoU3dkJLG/_\"p]\u001aLwm\u001d\u0015\u0003\u000f1\u000b1\u0003^3ti\u000e{gN\\3di&|g.U;pi\u0006D#\u0001\u0003'\u0002)Q,7\u000f\u001e'pO6\u000bg.Y4fe\u000e{gNZ5hQ\tIA*\u0001\u0016uKN$H+[3s\t\u0016dW\r^3e!\u0006\u0014H/\u001b;j_:\u001c8i\\8sI&t\u0017\r^8s\u0007>tg-[4)\u0005)a\u0015a\u0005;fgR\u0014\u0015\r\\1oG\u0016\u00148i\u001c8gS\u001e\u001c\bFA\u0006M\u0003\r\"Xm\u001d;CC2\fgnY3s-\u0006d\u0017\u000eZ1uKJ+7m\u001c8gS\u001e,(/\u0019;j_:D#\u0001\u0004'\u0002OQ,7\u000f\u001e\"bY\u0006t7-\u001a:SK\u000e|gNZ5hkJ,g*Z4bi&4X\r\u00165s_R$H.\u001a\u0015\u0003\u001b1\u000bq\u0003^3ti\u000e{gN\\3di&|gNU1uKF+x\u000e^1)\u00059a\u0015\u0001\b;fgR\u001cuN\u001c8fGRLwN\u001c*bi\u0016\fVo\u001c;b\r2|wN\u001d\u0015\u0003\u001f1\u000b!C^3sS\u001aL8i\u001c8gS\u001e,\u0006\u000fZ1uKR9!(\u001b<\u0002\u0002\u0005-\u0001\"\u00026\u0011\u0001\u0004Y\u0017\u0001\u00028b[\u0016\u0004\"\u0001\\:\u000f\u00055\f\bC\u000181\u001b\u0005y'B\u00019-\u0003\u0019a$o\\8u}%\u0011!\u000fM\u0001\u0007!J,G-\u001a4\n\u0005Q,(AB*ue&twM\u0003\u0002sa!)q\u000f\u0005a\u0001q\u0006)a/\u00197vKB\u0011\u0011P`\u0007\u0002u*\u00111\u0010`\u0001\u0005Y\u0006twMC\u0001~\u0003\u0011Q\u0017M^1\n\u0005}T(AB(cU\u0016\u001cG\u000fC\u0004\u0002\u0004A\u0001\r!!\u0002\u0002\u001fA,'O\u0011:pW\u0016\u00148i\u001c8gS\u001e\u00042aLA\u0004\u0013\r\tI\u0001\r\u0002\b\u0005>|G.Z1o\u0011\u001d\ti\u0001\u0005a\u0001\u0003\u000b\tQ\"\u001a=qK\u000e$h)Y5mkJ,\u0017a\t<fe&4\u0017pQ8oM&<W\u000b\u001d3bi\u0016<\u0016\u000e\u001e5J]Z\fG.\u001b3D_:4\u0017n\u001a\u000b\nu\u0005M\u0011QDA\u0017\u0003{Aq!!\u0006\u0012\u0001\u0004\t9\"\u0001\u0004d_:4\u0017n\u001a\t\u0004o\u0005e\u0011bAA\u000eQ\tY1*\u00194lC\u000e{gNZ5h\u0011\u001d\ty\"\u0005a\u0001\u0003C\t\u0011b\u001c:jOB\u0013x\u000e]:\u0011\t\u0005\r\u0012\u0011F\u0007\u0003\u0003KQ1!a\n}\u0003\u0011)H/\u001b7\n\t\u0005-\u0012Q\u0005\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBA\u0018#\u0001\u0007\u0011\u0011G\u0001\u000bm\u0006d\u0017\u000e\u001a)s_B\u001c\bCBA\u001a\u0003sY7.\u0004\u0002\u00026)\u0019\u0011q\u0007\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002<\u0005U\"aA'ba\"9\u0011qH\tA\u0002\u0005E\u0012\u0001D5om\u0006d\u0017\u000e\u001a)s_B\u001c\u0018\u0001\b;fgR\u0004\u0016m]:x_J$7i\u001c8gS\u001e,en\u0019:zaRLwN\u001c\u0015\u0003%1\u000bQ\u0005^3tiB\u000b7o]<pe\u0012\u001cuN\u001c4jO\u0016s7m\u001c3feN+7M]3u\u0007\"\fgnZ3)\u0005Ma\u0015!\u0007;fgR$\u0015P\\1nS\u000ed\u0015n\u001d;f]\u0016\u00148i\u001c8gS\u001eD#\u0001\u0006'\u0002)Q,7\u000f^!vi\"|'/\u001b>fe\u000e{gNZ5hQ\t)B*\u0001\u000buKN$\b\n\u001e;q'\u0016\u0014h/\u001a:D_:4\u0017n\u001a\u0015\u0003-1\u000bA\u0002^3tiNKhn\u001c8z[ND#a\u0006'\u0002cQ,7\u000f\u001e#z]\u0006l\u0017nY\"p]\u001aLw-\u00138ji&\fG.\u001b>bi&|gnV5uQ>,HoQ8oM&<7/\u00138[\u0017\"\u0012\u0001\u0004T\u0001&i\u0016\u001cHOU3qY&\u001c\u0017-T1oC\u001e,'OR3uG\"l\u0015\r\u001f\"zi\u0016\u001c8\t[1oO\u0016D#!\u0007'\u0002iQ,7\u000f\u001e*fa2L7-Y'b]\u0006<WM\u001d+jKJl\u0015\r\u001f)beRLG/[8o\r\u0016$8\r\u001b\"zi\u0016\u001cxJ^3se&$W\r\u000b\u0002\u001b\u0019\u0006iB/Z:u\u00136\u0004(o\u001c9fe\u000e{gNZ5hg\u0006\u0013XMU3n_Z,G\r\u000b\u0002\u001c\u0019\u0006!B/Z:u\u00072LWM\u001c;KC\u0006\u001c8i\u001c8gS\u001eD#\u0001\b'\u0002+Q,7\u000f\u001e'pO&t7i\u001c8gS\u001e\u001c\u0005.\u00198hK\"\u0012Q\u0004T\u00012i\u0016\u001cHoU1tY\u000e\u0013X\rZ3oi&\fGNU8uCRLwN\\,ji\"\u0004&/\u001a4jq\u0016$7I]3eK:$\u0018.\u00197tQ\tqB*A\u001auKN$8+Y:m\u0007J,G-\u001a8uS\u0006d'k\u001c;bi&|gnV5uQVs\u0007O]3gSb,Gm\u0011:fI\u0016tG/[1mg\"\u0012q\u0004T\u0001/i\u0016\u001cHoU1tY\u000e\u0013X\rZ3oi&\fGNU8uCRLwN\\,ji\"\u001c\u0006.\u0019:fI*\u000b\u0017m]\"p]\u001aLw\r\u000b\u0002!\u0019\u00061B/Z:u\u001d\u0016<8+Y:m\u0007J,G-\u001a8uS\u0006d7\u000f\u000b\u0002\"\u0019\u0006Ab/\u001a:jMf\u001c%/\u001a3f]RL\u0017\r\u001c*pi\u0006$\u0018n\u001c8\u0015\u000bi\n))!#\t\r\u0005\u001d%\u00051\u0001l\u00039)8/\u001a:oC6,7i\u001c8gS\u001eDa!a##\u0001\u0004Y\u0017A\u00049bgN<xN\u001d3D_:4\u0017nZ\u0001\u001bW\u000647.\u0019)s_B\u001cx+\u001b;i\tft\u0017-\\5d\u0019><\u0017N\u001c\u000b\t\u0003C\t\t*a%\u0002\u0016\"1\u0011qQ\u0012A\u0002-Da!a#$\u0001\u0004Y\u0007\"CALGA\u0005\t\u0019AAM\u00039\u0001H.^4j]B\u0013XMZ5yKN\u0004R!a\r\u0002\u001c.LA!!(\u00026\t\u00191+\u001a;\u0002I-\fgm[1Qe>\u00048oV5uQ\u0012Kh.Y7jG2{w-\u001b8%I\u00164\u0017-\u001e7uIM*\"!a)+\t\u0005e\u0015QU\u0016\u0003\u0003O\u0003B!!+\u000246\u0011\u00111\u0016\u0006\u0005\u0003[\u000by+A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u0017\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00026\u0006-&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\t3M]3bi\u0016\\\u0015MZ6b\u0007>tg-[4XSRDG)\u001f8b[&\u001cGj\\4j]R!\u00111XAd!\u001dy\u0013QXA\f\u0003\u0003L1!a01\u0005\u0019!V\u000f\u001d7feA\u0019q'a1\n\u0007\u0005\u0015\u0007FA\nEs:\fW.[2M_\u001eLg.T1oC\u001e,'\u000fC\u0004\u0002J\u0016\u0002\r!!\t\u0002\u000bA\u0014x\u000e]:\u0002!Y,'/\u001b4z\u0007J,G-\u001a8uS\u0006dGc\u0002\u001e\u0002P\u0006e\u0017Q\u001c\u0005\b\u0003#4\u0003\u0019AAj\u0003\u001d\u0019wN\u001c;fqR\u00042aNAk\u0013\r\t9\u000e\u000b\u0002\u0014\tft\u0017-\\5d\u0019><\u0017N\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u000374\u0003\u0019A6\u0002\u0011U\u001cXM\u001d8b[\u0016Da!a8'\u0001\u0004Y\u0017\u0001\u00039bgN<xN\u001d3")
public class DynamicBrokerConfigTest {
    @AfterEach
    public void tearDown() {
        LoginManager.closeAll();
    }

    @Test
    public void testConfigUpdate() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        String oldKeystore = "oldKs.jks";
        props.put("ssl.keystore.location", oldKeystore);
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props);
        DynamicBrokerConfig dynamicConfig = config.dynamicConfig();
        Assertions.assertSame((Object)config, (Object)dynamicConfig.currentKafkaConfig());
        Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Properties props1 = new Properties();
            String newKeystore = new StringBuilder(6).append("ks").append(i).append(".jks").toString();
            props1.put(new StringBuilder(44).append("listener.name.external.").append("ssl.keystore.location").toString(), newKeystore);
            dynamicConfig.updateBrokerConfig(0, props1);
            Assertions.assertNotSame((Object)config, (Object)dynamicConfig.currentKafkaConfig());
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, (Object)config.getString(KafkaConfig$.MODULE$.SslKeystoreLocationProp()));
            Assertions.assertEquals((Object)oldKeystore, config.originals().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsStrings().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
        });
    }

    @Test
    public void testConfigUpdateWithSomeInvalidConfigs() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put("ssl.keystore.type", "JKS");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps);
        Map validProps = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(44).append("listener.name.external.").append("ssl.keystore.location").toString()), (Object)"ks.p12")}));
        Map securityPropsWithoutListenerPrefix = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.type"), (Object)"PKCS12")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)securityPropsWithoutListenerPrefix);
        Map nonDynamicProps = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkConnectProp()), (Object)"somehost:2181")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)nonDynamicProps);
        Map invalidProps = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerThreadsProp()), (Object)"invalid")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)invalidProps);
        Map excludedTopicConfig = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogMessageFormatVersionProp()), (Object)"0.10.2")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)excludedTopicConfig);
    }

    @Test
    public void testConfigUpdateWithReconfigurableValidationFailure() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "100000000");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps);
        scala.collection.immutable.Map validProps = Map$.MODULE$.empty();
        Map invalidProps = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerThreadsProp()), (Object)"20")}));
        Reconfigurable reconfigurable = new Reconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(configs);
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addReconfigurable(reconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)invalidProps);
        config.dynamicConfig().removeReconfigurable(reconfigurable);
        BrokerReconfigurable brokerReconfigurable = new BrokerReconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public Set<String> reconfigurableConfigs() {
                return (Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}));
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(newConfig.originals());
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addBrokerReconfigurable(brokerReconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (Map<String, String>)validProps, (Map<String, String>)invalidProps);
    }

    @Test
    public void testReconfigurableValidation() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps);
        Set invalidReconfigurableProps = (Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.BrokerIdProp(), "some.prop"}));
        Set validReconfigurableProps = (Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "some.prop"}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addReconfigurable(DynamicBrokerConfigTest.createReconfigurable$1(invalidReconfigurableProps)));
        config.dynamicConfig().addReconfigurable(DynamicBrokerConfigTest.createReconfigurable$1(validReconfigurableProps));
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addBrokerReconfigurable(DynamicBrokerConfigTest.createBrokerReconfigurable$1(invalidReconfigurableProps)));
        config.dynamicConfig().addBrokerReconfigurable(DynamicBrokerConfigTest.createBrokerReconfigurable$1(validReconfigurableProps));
    }

    @Test
    public void testSecurityConfigs() {
        this.verifyUpdate$1("ssl.keystore.location", "ks.jks");
        this.verifyUpdate$1("ssl.keystore.type", "JKS");
        this.verifyUpdate$1("ssl.keystore.password", "password");
        this.verifyUpdate$1("ssl.key.password", "password");
    }

    @Test
    public void testConnectionQuota() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "0", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName#:100", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", false, false);
        String listenerMaxConnectionsProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionsProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", false, false);
    }

    @Test
    public void testLogManagerConfig() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "-1", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "-1", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "0", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "0", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "100", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.LogDeletionMaxSegmentsPerRunProp(), "100", true, false);
    }

    @Test
    public void testTierDeletedPartitionsCoordinatorConfig() {
        ((IterableLike)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.TierTopicDeleteCheckIntervalMsProp(), KafkaConfig$.MODULE$.TierTopicDeleteMaxInprogressPartitionsProp()}))).foreach((Function1 & Serializable & scala.Serializable)config -> {
            DynamicBrokerConfigTest.$anonfun$testTierDeletedPartitionsCoordinatorConfig$1(this, config);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testBalancerConfigs() {
        this.verifyConfigUpdate("confluent.balancer.throttle.bytes.per.second", "200", false, false);
        this.verifyConfigUpdate("confluent.balancer.enable", Boolean.toString(true), false, false);
        this.verifyConfigUpdate("confluent.balancer.enable", "PAUSED", false, true);
    }

    @Test
    public void testBalancerValidateReconfiguration() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer kafkaServer = (KafkaServer)EasyMock.createMock(KafkaServer.class);
        EasyMock.expect((Object)kafkaServer.config()).andReturn((Object)oldConfig).anyTimes();
        EasyMock.replay((Object[])new Object[]{kafkaServer});
        props.put("confluent.balancer.throttle.bytes.per.second", "200");
        KafkaConfig newConfig = KafkaConfig$.MODULE$.apply((java.util.Map)props);
        new DynamicBalancerConfig((KafkaBroker)kafkaServer).validateReconfiguration(newConfig);
    }

    @Test
    public void testBalancerReconfigureNegativeThrottle() {
        this.verifyConfigUpdate("confluent.balancer.throttle.bytes.per.second", ConfluentConfigs.BALANCER_THROTTLE_AUTO_THROTTLE.toString(), false, false);
        this.verifyConfigUpdate("confluent.balancer.throttle.bytes.per.second", ConfluentConfigs.BALANCER_THROTTLE_MIN.toString(), false, false);
    }

    @Test
    public void testConnectionRateQuota() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), "110", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), "120", false, false);
        String listenerMaxConnectionsProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "20", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "30", false, false);
    }

    @Test
    public void testConnectionRateQuotaFloor() {
        String listenerMaxConnectionCreationFloorProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionCreationRateFloorProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionCreationFloorProp, "20", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionCreationFloorProp, "30", false, false);
    }

    private void verifyConfigUpdate(String name, Object value, boolean perBrokerConfig, boolean expectFailure) {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties configProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        configProps.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "broker.secret");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)configProps);
        Properties props = new Properties();
        props.put(name, value);
        Object oldValue = config.originals().get(name);
        if (!expectFailure) {
            config.dynamicConfig().validate(props, perBrokerConfig);
            DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
            Assertions.assertEquals((Object)value, config.originals().get(name));
            return;
        }
        Assertions.assertThrows(Exception.class, () -> config.dynamicConfig().validate(props, perBrokerConfig));
        DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
        Assertions.assertEquals(oldValue, config.originals().get(name));
    }

    private void verifyConfigUpdateWithInvalidConfig(KafkaConfig config, Properties origProps, Map<String, String> validProps, Map<String, String> invalidProps) {
        Properties props = new Properties();
        validProps.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = props.put(k, v);
            return object;
        });
        invalidProps.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$2._1();
            String v = (String)x0$2._2();
            Object object = props.put(k, v);
            return object;
        });
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, true));
        config.dynamicConfig().updateBrokerConfig(0, props);
        validProps.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$4(config, x0$3);
            return BoxedUnit.UNIT;
        });
        invalidProps.keySet().foreach((Function1 & Serializable & scala.Serializable)name -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$5(origProps, config, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPasswordConfigEncryption() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig configWithoutSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props);
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        KafkaConfig configWithSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "myLoginModule required;");
        try {
            configWithoutSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        }
        catch (ConfigException configException) {}
        Properties persistedProps = configWithSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assertions.assertFalse((boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("myLoginModule"), (String)"Password not encoded");
        Properties decodedProps = configWithSecret.dynamicConfig().fromPersistentProps(persistedProps, true);
        Assertions.assertEquals((Object)"myLoginModule required;", (Object)decodedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()));
    }

    @Test
    public void testPasswordConfigEncoderSecretChange() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "staticLoginModule required;");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "dynamicLoginModule required;");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assertions.assertFalse((boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("LoginModule"), (String)"Password not encoded");
        config.dynamicConfig().updateBrokerConfig(0, persistedProps);
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)config.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        KafkaConfig newConfigWithSameSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props);
        newConfigWithSameSecret.dynamicConfig().updateBrokerConfig(0, persistedProps);
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "new-encoder-secret");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), "config-encoder-secret");
        KafkaConfig$.MODULE$.apply((java.util.Map)props).dynamicConfig().updateBrokerConfig(0, persistedProps);
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "another-new-encoder-secret");
        KafkaConfig newConfigWithNewSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props);
        newConfigWithNewSecret.dynamicConfig().updateBrokerConfig(0, persistedProps);
        Assertions.assertEquals((Object)"staticLoginModule required;", (Object)((Password)newConfigWithNewSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
    }

    @Test
    public void testDynamicListenerConfig() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer kafkaServer = (KafkaServer)EasyMock.createMock(KafkaServer.class);
        EasyMock.expect((Object)kafkaServer.config()).andReturn((Object)oldConfig).anyTimes();
        EasyMock.replay((Object[])new Object[]{kafkaServer});
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://hostname:9092,SASL_PLAINTEXT://hostname:9093");
        new DynamicListenerConfig((KafkaBroker)kafkaServer).validateReconfiguration(KafkaConfig$.MODULE$.apply((java.util.Map)props));
        props.put("listener.name.plaintext.you.should.not.pass", "failure");
        DynamicListenerConfig dynamicListenerConfig = new DynamicListenerConfig((KafkaBroker)kafkaServer);
        Assertions.assertThrows(ConfigException.class, () -> dynamicListenerConfig.validateReconfiguration(KafkaConfig$.MODULE$.apply((java.util.Map)props)));
    }

    @Test
    public void testAuthorizerConfig() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer kafkaServer = (KafkaServer)EasyMock.createMock(KafkaServer.class);
        public class Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1
        implements Authorizer,
        Reconfigurable {
            private volatile String superUsers;

            public java.util.List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext x$1, java.util.List<AclBinding> x$2, Optional<String> x$3) {
                return super.createAcls(x$1, x$2, x$3);
            }

            public java.util.List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext x$1, java.util.List<AclBindingFilter> x$2, Optional<String> x$3) {
                return super.deleteAcls(x$1, x$2, x$3);
            }

            public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext x$1, AclOperation x$2, ResourceType x$3) {
                return super.authorizeByResourceType(x$1, x$2, x$3);
            }

            public String superUsers() {
                return this.superUsers;
            }

            public void superUsers_$eq(String x$1) {
                this.superUsers = x$1;
            }

            public java.util.Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
                return (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.empty()).asJava();
            }

            public java.util.List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, java.util.List<Action> actions) {
                return null;
            }

            public java.util.List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, java.util.List<AclBinding> aclBindings) {
                return null;
            }

            public java.util.List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, java.util.List<AclBindingFilter> aclBindingFilters) {
                return null;
            }

            public Iterable<AclBinding> acls(AclBindingFilter filter) {
                return null;
            }

            public void close() {
            }

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"super.users"}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
                this.superUsers_$eq(configs.get("super.users").toString());
            }

            public Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1(DynamicBrokerConfigTest $outer) {
                this.superUsers = "";
            }
        }
        Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1 authorizer = new Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1(null);
        EasyMock.expect((Object)kafkaServer.config()).andReturn((Object)oldConfig).anyTimes();
        EasyMock.expect((Object)kafkaServer.authorizer()).andReturn((Object)new Some((Object)authorizer)).anyTimes();
        EasyMock.replay((Object[])new Object[]{kafkaServer});
        Assertions.assertThrows(Throwable.class, () -> kafkaServer.config().dynamicConfig().addReconfigurables((KafkaBroker)kafkaServer));
        props.put("super.users", "User:admin");
        kafkaServer.config().dynamicConfig().updateBrokerConfig(0, props);
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    @Test
    public void testHttpServerConfig() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer kafkaServer = (KafkaServer)EasyMock.createMock(KafkaServer.class);
        public class Kafka_server_DynamicBrokerConfigTest$TestKafkaHttpServer$1
        implements KafkaHttpServer,
        Reconfigurable {
            private volatile String foobar;

            public boolean isNew() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean isStarting() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean isRunning() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean isStopping() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean isTerminated() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean isFailed() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void start() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void stop() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public Optional<Throwable> getError() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void awaitStarted() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean awaitStarted(Duration timeout) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public void awaitStopped() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public boolean awaitStopped(Duration timeout) {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }

            public String foobar() {
                return this.foobar;
            }

            public void foobar_$eq(String x$1) {
                this.foobar = x$1;
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo.bar"}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
                this.foobar_$eq(configs.get("foo.bar").toString());
            }

            public void configure(java.util.Map<String, ?> configs) {
            }

            public Kafka_server_DynamicBrokerConfigTest$TestKafkaHttpServer$1(DynamicBrokerConfigTest $outer) {
                this.foobar = "";
            }
        }
        Kafka_server_DynamicBrokerConfigTest$TestKafkaHttpServer$1 httpServer = new Kafka_server_DynamicBrokerConfigTest$TestKafkaHttpServer$1(null);
        EasyMock.expect((Object)kafkaServer.config()).andReturn((Object)oldConfig).anyTimes();
        EasyMock.expect((Object)kafkaServer.authorizer()).andReturn((Object)None$.MODULE$).anyTimes();
        EasyMock.expect((Object)kafkaServer.httpServer()).andReturn((Object)new Some((Object)httpServer)).anyTimes();
        EasyMock.replay((Object[])new Object[]{kafkaServer});
        try {
            kafkaServer.config().dynamicConfig().addReconfigurables((KafkaBroker)kafkaServer);
        }
        catch (Throwable throwable) {}
        props.put("foo.bar", "fozbaz");
        kafkaServer.config().dynamicConfig().updateBrokerConfig(0, props);
        Assertions.assertEquals((Object)"fozbaz", (Object)httpServer.foobar());
    }

    @Test
    public void testSynonyms() {
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.secure.ssl.keystore.type", (List)new .colon.colon((Object)"ssl.keystore.type", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.secure.ssl.keystore.type", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.sasl_ssl.plain.sasl.jaas.config", (List)new .colon.colon((Object)"sasl.jaas.config", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.sasl_ssl.plain.sasl.jaas.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"some.config", (List)Nil$.MODULE$), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("some.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeMillisProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeHoursProp(), (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(KafkaConfig$.MODULE$.LogRollTimeMillisProp(), true));
    }

    @Test
    public void testDynamicConfigInitializationWithoutConfigsInZK() {
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
        EasyMock.expect((Object)zkClient.getEntityConfigs(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)new Properties()).anyTimes();
        EasyMock.replay((Object[])new Object[]{zkClient});
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
        DynamicBrokerConfig dynamicBrokerConfig = new DynamicBrokerConfig(oldConfig);
        dynamicBrokerConfig.initialize(zkClient);
        dynamicBrokerConfig.addBrokerReconfigurable((BrokerReconfigurable)new TestDynamicThreadPool());
        Properties newprops = new Properties();
        newprops.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "10");
        newprops.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "100");
        dynamicBrokerConfig.updateBrokerConfig(0, newprops);
    }

    @Test
    public void testReplicaManagerFetchMaxBytesChange() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.FetchMaxBytes(), "1024");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.FetchMaxBytes(), "2048");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        config.dynamicConfig().updateBrokerConfig(0, persistedProps);
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)2048), config.values().get(KafkaConfig$.MODULE$.FetchMaxBytes()));
    }

    @Test
    public void testReplicaManagerTierMaxPartitionFetchBytesOverride() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.TierMaxPartitionFetchBytesOverrideProp(), "1024000");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.TierMaxPartitionFetchBytesOverrideProp(), "2048000");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        config.dynamicConfig().updateBrokerConfig(0, persistedProps);
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)2048000), config.values().get(KafkaConfig$.MODULE$.TierMaxPartitionFetchBytesOverrideProp()));
    }

    @Test
    public void testImproperConfigsAreRemoved() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        KafkaConfig configs = KafkaConfig$.MODULE$.apply((java.util.Map)props);
        Assertions.assertEquals((int)Defaults$.MODULE$.MaxConnections(), (Integer)configs.maxConnections());
        Assertions.assertEquals((int)Defaults$.MODULE$.MessageMaxBytes(), (Integer)configs.messageMaxBytes());
        Properties newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "9999");
        newProps.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), "2222");
        configs.dynamicConfig().updateDefaultConfig(newProps);
        Assertions.assertEquals((int)9999, (Integer)configs.maxConnections());
        Assertions.assertEquals((int)2222, (Integer)configs.messageMaxBytes());
        newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "INVALID_INT");
        newProps.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), "1111");
        configs.dynamicConfig().updateDefaultConfig(newProps);
        Assertions.assertEquals((int)Defaults$.MODULE$.MaxConnections(), (Integer)configs.maxConnections());
        Assertions.assertEquals((int)1111, (Integer)configs.messageMaxBytes());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClientJaasConfig() {
        void var3_3;
        Properties props = this.kafkaPropsWithDynamicLogin("test.dynamic.login.username", "test.dynamic.login.password", this.kafkaPropsWithDynamicLogin$default$3());
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        Assertions.assertFalse((boolean)var3_3.isClientSaslJaasConfig("sasl.jaas.config"));
        Assertions.assertFalse((boolean)var3_3.isClientSaslJaasConfig("listener.name.sasl_ssl.sasl.jaas.config"));
        Assertions.assertTrue((boolean)var3_3.isClientSaslJaasConfig("test.dynamic.login.sasl.jaas.config"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLoginConfigChange() {
        void var3_3;
        Properties props = this.kafkaPropsWithDynamicLogin("test.dynamic.login.username", "test.dynamic.login.password", this.kafkaPropsWithDynamicLogin$default$3());
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        DynamicLoginContext context = (DynamicLoginContext)var3_3.reconfigurableContexts().head();
        HashMap<String, String> oldConfigs = new HashMap<String, String>();
        HashMap<String, String> newConfigs = new HashMap<String, String>();
        oldConfigs.put("test.dynamic.login.username", "alice");
        oldConfigs.put("test.dynamic.login.password", "alice-password");
        newConfigs.put("test.dynamic.login.username", "alice");
        newConfigs.put("test.dynamic.login.password", "alice-password");
        Assertions.assertFalse((boolean)context.needsReconfigure(oldConfigs, newConfigs));
        Assertions.assertFalse((boolean)context.needsReconfigure(Collections.emptyMap(), Collections.emptyMap()));
        Assertions.assertTrue((boolean)context.needsReconfigure(Collections.emptyMap(), newConfigs));
        Assertions.assertTrue((boolean)context.needsReconfigure(oldConfigs, Collections.emptyMap()));
        newConfigs.put("test.dynamic.login.password", "alice-new-password");
        Assertions.assertTrue((boolean)context.needsReconfigure(oldConfigs, newConfigs));
        newConfigs.put("test.dynamic.login.username", "bob");
        newConfigs.put("test.dynamic.login.password", "bob-password");
        Assertions.assertTrue((boolean)context.needsReconfigure(oldConfigs, newConfigs));
        Assertions.assertTrue((boolean)context.needsReconfigure(oldConfigs, Collections.singletonMap("test.dynamic.login.username", "alice")));
        Assertions.assertTrue((boolean)context.needsReconfigure(Collections.singletonMap("test.dynamic.login.username", "alice"), newConfigs));
    }

    @Test
    public void testSaslCredentialRotationWithPrefixedCredentials() {
        this.verifyCredentialRotation("test.dynamic.login.username", "test.dynamic.login.password");
    }

    @Test
    public void testSaslCredentialRotationWithUnprefixedCredentials() {
        this.verifyCredentialRotation("login.username", "login.password");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSaslCredentialRotationWithSharedJaasConfig() {
        void var7_7;
        void var6_6;
        String usernameConfig = "login.username";
        String passwordConfig = "login.password";
        Set pluginPrefixes = (Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test.plugin1.", "test.plugin2."}));
        Properties props = this.kafkaPropsWithDynamicLogin(usernameConfig, passwordConfig, (Set<String>)pluginPrefixes);
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig config = (KafkaConfig)tuple2._1();
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        void config2 = var6_6;
        void dynamicLogin2 = var7_7;
        Set credentialConfigs = (Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{usernameConfig, passwordConfig}));
        Assertions.assertEquals((Object)credentialConfigs, (Object)dynamicLogin2.reconfigurableConfigNames().toSet());
        Assertions.assertEquals((int)2, (int)dynamicLogin2.reconfigurableContexts().size());
        scala.collection.mutable.Set contexts = dynamicLogin2.reconfigurableContexts();
        Assertions.assertEquals((Object)pluginPrefixes, (Object)((TraversableOnce)contexts.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.prefix(), Set$.MODULE$.canBuildFrom())).toSet());
        Assertions.assertEquals((Object)pluginPrefixes.map((Function1 & Serializable & scala.Serializable)x$3 -> new StringBuilder(16).append((String)x$3).append("sasl.jaas.config").toString(), scala.collection.Set$.MODULE$.canBuildFrom()), (Object)contexts.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.saslJaasConfigName(), Set$.MODULE$.canBuildFrom()));
        contexts.foreach((Function1 & Serializable & scala.Serializable)context -> {
            DynamicBrokerConfigTest.$anonfun$testSaslCredentialRotationWithSharedJaasConfig$4(this, credentialConfigs, context);
            return BoxedUnit.UNIT;
        });
        Properties dynamicProps = new Properties();
        dynamicProps.setProperty(usernameConfig, "alice");
        dynamicProps.setProperty(passwordConfig, "alice-new-password");
        DynamicBrokerConfigTest.updateConfig$2((KafkaConfig)config2, dynamicProps);
        contexts.foreach((Function1 & Serializable & scala.Serializable)context -> {
            this.verifyCredential(context, "alice", "alice-new-password");
            return BoxedUnit.UNIT;
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> DynamicBrokerConfigTest.$anonfun$testSaslCredentialRotationWithSharedJaasConfig$6(this, dynamicProps, usernameConfig, passwordConfig, contexts, (KafkaConfig)config2, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNewSaslCredentials() {
        void var4_4;
        void var3_3;
        Properties props = this.kafkaPropsWithDynamicLogin("test.dynamic.login.username", "test.dynamic.login.password", this.kafkaPropsWithDynamicLogin$default$3());
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig config = (KafkaConfig)tuple2._1();
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        void config2 = var3_3;
        void dynamicLogin2 = var4_4;
        this.verifyCredential((DynamicLoginContext)dynamicLogin2.reconfigurableContexts().head(), "alice", "alice-password");
        Properties dynamicProps = new Properties();
        dynamicProps.setProperty("test.another.login.security.protocol", "SASL_PLAINTEXT");
        dynamicProps.setProperty("test.another.login.sasl.mechanism", "PLAIN");
        dynamicProps.setProperty("test.another.login.username", "another");
        dynamicProps.setProperty(new StringBuilder(35).append("test.another.login.").append("sasl.jaas.config").toString(), new StringBuilder(64).append(DynamicPlainLoginModule.class.getName()).append(" required username_config=\"username\" password_config=\"password\";").toString());
        dynamicProps.setProperty(new StringBuilder(52).append("test.another.login.").append("sasl.login.callback.handler.class").toString(), DynamicPlainLoginCallbackHandler.class.getName());
        dynamicProps.setProperty("test.another.login.password", "another-password");
        DynamicBrokerConfigTest.updateConfig$3((KafkaConfig)config2, dynamicProps);
        Assertions.assertEquals((int)2, (int)dynamicLogin2.reconfigurableContexts().size());
        DynamicLoginContext oldContext = (DynamicLoginContext)((IterableLike)dynamicLogin2.reconfigurableContexts().filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfigTest.$anonfun$testNewSaslCredentials$1(x$7)))).head();
        this.verifyCredential(oldContext, "alice", "alice-password");
        DynamicLoginContext newContext = (DynamicLoginContext)((IterableLike)dynamicLogin2.reconfigurableContexts().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfigTest.$anonfun$testNewSaslCredentials$2(x$8)))).head();
        this.verifyCredential(newContext, "another", "another-password");
        dynamicProps.remove("test.another.login.password");
        Assertions$.MODULE$.intercept((Function0)((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DynamicBrokerConfigTest.$anonfun$testNewSaslCredentials$3((KafkaConfig)config2, dynamicProps)), ClassTag$.MODULE$.apply(ConfigException.class), new Position("DynamicBrokerConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 673));
    }

    /*
     * WARNING - void declaration
     */
    private void verifyCredentialRotation(String usernameConfig, String passwordConfig) {
        void var6_6;
        void var5_5;
        Properties props = this.kafkaPropsWithDynamicLogin(usernameConfig, passwordConfig, this.kafkaPropsWithDynamicLogin$default$3());
        props.setProperty("test.static.login.security.protocol", "SASL_SSL");
        props.setProperty("test.static.login.sasl.mechanism", "PLAIN");
        props.setProperty(new StringBuilder(34).append("test.static.login.").append("sasl.jaas.config").toString(), new StringBuilder(55).append(PlainLoginModule.class.getName()).append(" required username=\"static\" password=\"static-password\";").toString());
        Tuple2<KafkaConfig, DynamicLoginManager> tuple2 = this.createKafkaConfigWithDynamicLogin(props);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        KafkaConfig config = (KafkaConfig)tuple2._1();
        DynamicLoginManager dynamicLogin = (DynamicLoginManager)tuple2._2();
        void config2 = var5_5;
        void dynamicLogin2 = var6_6;
        Set credentialConfigs = (Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{usernameConfig, passwordConfig}));
        Assertions.assertEquals((Object)credentialConfigs, (Object)dynamicLogin2.reconfigurableConfigNames().toSet());
        Assertions.assertEquals((int)1, (int)dynamicLogin2.reconfigurableContexts().size());
        DynamicLoginContext context = (DynamicLoginContext)dynamicLogin2.reconfigurableContexts().head();
        Assertions.assertEquals((Object)"test.dynamic.login.", (Object)context.prefix());
        Assertions.assertEquals((Object)"test.dynamic.login.sasl.jaas.config", (Object)context.saslJaasConfigName());
        Assertions.assertEquals((Object)credentialConfigs, (Object)context.dynamicConfigs());
        this.verifyCredential(context, "alice", "alice-password");
        Properties dynamicProps = new Properties();
        dynamicProps.setProperty(usernameConfig, "alice");
        dynamicProps.setProperty(passwordConfig, "alice-new-password");
        DynamicBrokerConfigTest.updateConfig$4((KafkaConfig)config2, dynamicProps);
        this.verifyCredential(context, "alice", "alice-new-password");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)((JFunction1.mcVI.sp & Serializable & scala.Serializable)arg_0 -> DynamicBrokerConfigTest.$anonfun$verifyCredentialRotation$1(this, dynamicProps, usernameConfig, passwordConfig, context, (KafkaConfig)config2, arg_0)));
    }

    private Properties kafkaPropsWithDynamicLogin(String usernameConfig, String passwordConfig, Set<String> pluginPrefixes) {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.setProperty(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "encoder-secret");
        props.setProperty(usernameConfig, "alice");
        props.setProperty(passwordConfig, "alice-password");
        pluginPrefixes.foreach((Function1 & Serializable & scala.Serializable)prefix -> {
            props.setProperty(new StringBuilder(17).append((String)prefix).append("security.protocol").toString(), "SASL_SSL");
            props.setProperty(new StringBuilder(14).append((String)prefix).append("sasl.mechanism").toString(), "PLAIN");
            props.setProperty(new StringBuilder(16).append((String)prefix).append("sasl.jaas.config").toString(), new StringBuilder(48).append(DynamicPlainLoginModule.class.getName()).append(" required username_config=\"").append(usernameConfig).append("\" password_config=\"").append(passwordConfig).append("\";").toString());
            return props.setProperty(new StringBuilder(33).append((String)prefix).append("sasl.login.callback.handler.class").toString(), DynamicPlainLoginCallbackHandler.class.getName());
        });
        return props;
    }

    private Set<String> kafkaPropsWithDynamicLogin$default$3() {
        return (Set)scala.collection.Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test.dynamic.login."}));
    }

    private Tuple2<KafkaConfig, DynamicLoginManager> createKafkaConfigWithDynamicLogin(Properties props) {
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props);
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createMock(KafkaZkClient.class);
        EasyMock.expect((Object)zkClient.getEntityConfigs(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)new Properties()).anyTimes();
        EasyMock.replay((Object[])new Object[]{zkClient});
        config.dynamicConfig().initialize(zkClient);
        return new Tuple2((Object)config, (Object)config.dynamicConfig().dynamicLoginManager());
    }

    private void verifyCredential(DynamicLoginContext context, String username, String password) {
        Assertions.assertEquals((Object)new DynamicPlainCredential(username, password.toCharArray()), (Object)context.loginManager().subject().getPrivateCredentials().iterator().next());
    }

    public static final void kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(java.util.Map configs) {
        int cleanerThreads = new StringOps(Predef$.MODULE$.augmentString(configs.get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).toString())).toInt();
        if (cleanerThreads <= 0 || cleanerThreads >= 5) {
            throw new ConfigException(new StringBuilder(24).append("Invalid cleaner threads ").append(cleanerThreads).toString());
        }
    }

    private static final Reconfigurable createReconfigurable$1(Set configs) {
        return new Reconfigurable(null, configs){
            private final Set configs$1;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(this.configs$1).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                this.configs$1 = configs$1;
            }
        };
    }

    private static final BrokerReconfigurable createBrokerReconfigurable$1(Set configs) {
        return new BrokerReconfigurable(null, configs){
            private final Set configs$2;

            public Set<String> reconfigurableConfigs() {
                return this.configs$2;
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                this.configs$2 = configs$2;
            }
        };
    }

    private final void verifyUpdate$1(String name, Object value) {
        this.verifyConfigUpdate(name, value, true, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, true, false);
        this.verifyConfigUpdate(name, value, false, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, false, true);
    }

    public static final /* synthetic */ void $anonfun$testTierDeletedPartitionsCoordinatorConfig$1(DynamicBrokerConfigTest $this, String config) {
        $this.verifyConfigUpdate(config, "-1", true, true);
        $this.verifyConfigUpdate(config, "-1", false, true);
        $this.verifyConfigUpdate(config, "0", true, true);
        $this.verifyConfigUpdate(config, "0", false, true);
        $this.verifyConfigUpdate(config, "10000", false, false);
        $this.verifyConfigUpdate(config, "20000", true, false);
    }

    private static final void updateConfig$1(boolean perBrokerConfig$1, KafkaConfig config$3, Properties props$1) {
        if (perBrokerConfig$1) {
            config$3.dynamicConfig().updateBrokerConfig(0, config$3.dynamicConfig().toPersistentProps(props$1, perBrokerConfig$1));
            return;
        }
        config$3.dynamicConfig().updateDefaultConfig(props$1);
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$4(KafkaConfig config$4, Tuple2 x0$3) {
        if (x0$3 != null) {
            String name = (String)x0$3._1();
            Assertions.assertEquals((Object)((String)x0$3._2()), config$4.originals().get(name));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$5(Properties origProps$1, KafkaConfig config$4, String name) {
        Assertions.assertEquals((Object)origProps$1.get(name), config$4.originals().get(name));
    }

    public static final /* synthetic */ void $anonfun$testSaslCredentialRotationWithSharedJaasConfig$4(DynamicBrokerConfigTest $this, Set credentialConfigs$1, DynamicLoginContext context) {
        Assertions.assertEquals((Object)credentialConfigs$1, (Object)context.dynamicConfigs());
        $this.verifyCredential(context, "alice", "alice-password");
    }

    private static final void updateConfig$2(KafkaConfig config$5, Properties dynamicProps$1) {
        config$5.dynamicConfig().updateBrokerConfig(0, config$5.dynamicConfig().toPersistentProps(dynamicProps$1, true));
    }

    public static final /* synthetic */ void $anonfun$testSaslCredentialRotationWithSharedJaasConfig$6(DynamicBrokerConfigTest $this, Properties dynamicProps$1, String usernameConfig$1, String passwordConfig$1, scala.collection.mutable.Set contexts$1, KafkaConfig config$5, int x$5) {
        dynamicProps$1.setProperty(usernameConfig$1, "bob");
        dynamicProps$1.setProperty(passwordConfig$1, "bob-password");
        DynamicBrokerConfigTest.updateConfig$2(config$5, dynamicProps$1);
        contexts$1.foreach((Function1 & Serializable & scala.Serializable)context -> {
            $this.verifyCredential(context, "bob", "bob-password");
            return BoxedUnit.UNIT;
        });
    }

    private static final void updateConfig$3(KafkaConfig config$6, Properties dynamicProps$2) {
        config$6.dynamicConfig().updateBrokerConfig(0, config$6.dynamicConfig().toPersistentProps(dynamicProps$2, true));
    }

    public static final /* synthetic */ boolean $anonfun$testNewSaslCredentials$1(DynamicLoginContext x$7) {
        String string = x$7.saslJaasConfigName();
        String string2 = "test.dynamic.login.sasl.jaas.config";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testNewSaslCredentials$2(DynamicLoginContext x$8) {
        String string = x$8.saslJaasConfigName();
        String string2 = "test.another.login.sasl.jaas.config";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$testNewSaslCredentials$3(KafkaConfig config$6, Properties dynamicProps$2) {
        config$6.dynamicConfig().validate(dynamicProps$2, true);
    }

    private static final void updateConfig$4(KafkaConfig config$7, Properties dynamicProps$3) {
        config$7.dynamicConfig().updateBrokerConfig(0, config$7.dynamicConfig().toPersistentProps(dynamicProps$3, true));
    }

    public static final /* synthetic */ void $anonfun$verifyCredentialRotation$1(DynamicBrokerConfigTest $this, Properties dynamicProps$3, String usernameConfig$2, String passwordConfig$2, DynamicLoginContext context$1, KafkaConfig config$7, int x$10) {
        dynamicProps$3.setProperty(usernameConfig$2, "bob");
        dynamicProps$3.setProperty(passwordConfig$2, "bob-password");
        DynamicBrokerConfigTest.updateConfig$4(config$7, dynamicProps$3);
        $this.verifyCredential(context$1, "bob", "bob-password");
    }
}

