/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.KAFKA_3_0_IV1$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.network.ConnectionQuotas;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.Constants$;
import kafka.server.DynamicConfigManager;
import kafka.server.DynamicConfigManager$;
import kafka.server.IpConfigHandler;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.TopicConfigHandler;
import kafka.utils.CoreUtils$;
import kafka.utils.Json$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.RecordVersion;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u000e\u001d\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%BQ\u0001\f\u0001\u0005\u00025BQa\u000f\u0001\u0005\u0002qBQA\u0014\u0001\u0005\u0002qBQ\u0001\u0015\u0001\u0005\u0002qBQA\u0015\u0001\u0005\nMCQa\u001a\u0001\u0005\u0002qBQ!\u001b\u0001\u0005\u0002qBQa\u001b\u0001\u0005\u0002qBQ!\u001c\u0001\u0005\u0002qBQa\u001c\u0001\u0005\u0002qBQ!\u001d\u0001\u0005\u0002qBQa\u001d\u0001\u0005\u0002qBQ!\u001e\u0001\u0005\u0002qBQa\u001e\u0001\u0005\u0002qBQ!\u001f\u0001\u0005\u0002qBQa\u001f\u0001\u0005\u0002qBQ! \u0001\u0005\u0002qBQa \u0001\u0005\u0002qBa!a\u0001\u0001\t\u0003a\u0004BBA\u0004\u0001\u0011\u0005A\b\u0003\u0004\u0002\f\u0001!\t\u0001\u0010\u0005\u0007\u0003\u001f\u0001A\u0011\u0001\u001f\t\r\u0005M\u0001\u0001\"\u0001=\u0011\u001d\t9\u0002\u0001C\u0001\u00033Aq!a\u000e\u0001\t\u0013\tIDA\fEs:\fW.[2D_:4\u0017nZ\"iC:<W\rV3ti*\u0011QDH\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003}\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001EA\u00111EJ\u0007\u0002I)\u0011QEH\u0001\fS:$Xm\u001a:bi&|g.\u0003\u0002(I\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8/\u0001\u0004=S:LGO\u0010\u000b\u0002UA\u00111\u0006A\u0007\u00029\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001/!\ryc\u0007O\u0007\u0002a)\u0011\u0011GM\u0001\nS6lW\u000f^1cY\u0016T!a\r\u001b\u0002\u0015\r|G\u000e\\3di&|gNC\u00016\u0003\u0015\u00198-\u00197b\u0013\t9\u0004G\u0001\u0003MSN$\bCA\u0016:\u0013\tQDDA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001\u0005;fgR\u001cuN\u001c4jO\u000eC\u0017M\\4f)\u0005i\u0004C\u0001 @\u001b\u0005!\u0014B\u0001!5\u0005\u0011)f.\u001b;)\u0005\r\u0011\u0005CA\"M\u001b\u0005!%BA#G\u0003\r\t\u0007/\u001b\u0006\u0003\u000f\"\u000bqA[;qSR,'O\u0003\u0002J\u0015\u0006)!.\u001e8ji*\t1*A\u0002pe\u001eL!!\u0014#\u0003\tQ+7\u000f^\u0001\u001di\u0016\u001cH\u000fR=oC6L7\rV8qS\u000e\u001cuN\u001c4jO\u000eC\u0017M\\4fQ\t!!)\u0001\u0010uKN$X*Z:tC\u001e,gi\u001c:nCR4VM]:j_:\u001c\u0005.\u00198hK\"\u0012QAQ\u0001\u0016i\u0016\u001cH/U;pi\u0006\u001cuN\u001c4jO\u000eC\u0017M\\4f)\u0015iD+Y2f\u0011\u0015)f\u00011\u0001W\u0003\u0011)8/\u001a:\u0011\u0005]sfB\u0001-]!\tIF'D\u0001[\u0015\tY\u0006%\u0001\u0004=e>|GOP\u0005\u0003;R\na\u0001\u0015:fI\u00164\u0017BA0a\u0005\u0019\u0019FO]5oO*\u0011Q\f\u000e\u0005\u0006E\u001a\u0001\rAV\u0001\tG2LWM\u001c;JI\")AM\u0002a\u0001-\u0006q!o\\8u\u000b:$\u0018\u000e^=UsB,\u0007\"\u00024\u0007\u0001\u00041\u0016\u0001E2p]\u001aLw-\u00128uSRLh*Y7f\u0003u!Xm\u001d;DY&,g\u000e^%e#V|G/Y\"p]\u001aLwm\u00115b]\u001e,\u0007FA\u0004C\u0003e!Xm\u001d;Vg\u0016\u0014\u0018+^8uC\u000e{gNZ5h\u0007\"\fgnZ3)\u0005!\u0011\u0015a\u0007;fgR,6/\u001a:DY&,g\u000e^%e#V|G/Y\"iC:<W\r\u000b\u0002\n\u0005\u0006!C/Z:u\t\u00164\u0017-\u001e7u\u00072LWM\u001c;JIF+x\u000e^1D_:4\u0017nZ\"iC:<W\r\u000b\u0002\u000b\u0005\u0006\u0001C/Z:u\t\u00164\u0017-\u001e7u+N,'/U;pi\u0006\u001cuN\u001c4jO\u000eC\u0017M\\4fQ\tY!)\u0001\u0015uKN$H)\u001a4bk2$Xk]3s\u00072LWM\u001c;JIF+x\u000e^1D_:4\u0017nZ\"iC:<W\r\u000b\u0002\r\u0005\u00069B/Z:u#V|G/Y%oSRL\u0017\r\\5{CRLwN\u001c\u0015\u0003\u001b\t\u000b\u0001\u0005^3ti&\u0003\b*\u00198eY\u0016\u0014XK\u001c:fg>dg/\u00192mK\u0006#GM]3tg\"\u0012aBQ\u0001\u001ai\u0016\u001cH/\u00139Rk>$\u0018-\u00138ji&\fG.\u001b>bi&|g\u000e\u000b\u0002\u0010\u0005\u00069B/Z:u\u0013B\fVo\u001c;b\u0007>tg-[4DQ\u0006tw-\u001a\u0015\u0003!\t\u000b!\u0005^3ti\u000e{gNZ5h\u0007\"\fgnZ3P]:{g.\u0012=jgRLgn\u001a+pa&\u001c\u0007FA\tC\u0003E\"Xm\u001d;D_:4\u0017nZ\"iC:<Wm\u00148O_:,\u00050[:uS:<Gk\u001c9jG^KG\u000f[!e[&t7\t\\5f]RD#A\u0005\"\u0002/Q,7\u000f\u001e)s_\u000e,7o\u001d(pi&4\u0017nY1uS>t\u0007FA\nC\u0003\u0015\u001a\bn\\;mIB\u000b'o]3SKBd\u0017nY1uS>t\u0017+^8uCB\u0013x\u000e]3si&,7\u000f\u000b\u0002\u0015\u0005\u0006i3\u000f[8vY\u0012\u0004\u0016M]:f/&dGmY1sIJ+\u0007\u000f\\5dCRLwN\\)v_R\f\u0007K]8qKJ$\u0018.Z:)\u0005U\u0011\u0015!K:i_VdG\rU1sg\u0016tuN\\3SKBd\u0017nY1uS>t\u0017+^8uCB\u0013x\u000e]3si&,7\u000f\u000b\u0002\u0017\u0005\u0006\u00013\u000f[8vY\u0012\u0004\u0016M]:f%\u0016\u0004H.[2bi&|g.U;pi\u0006\u0014Vm]3uQ\t9\")A\u0017tQ>,H\u000e\u001a)beN,'+Z4be\u0012dWm]:PM^C\u0017\u000e^3ta\u0006\u001cW-\u0011:pk:$g+\u00197vKND#\u0001\u0007\"\u0002\u000bA\f'o]3\u0015\r\u0005m\u0011\u0011FA\u001a!\u0019\ti\"a\b\u0002$5\t!'C\u0002\u0002\"I\u00121aU3r!\rq\u0014QE\u0005\u0004\u0003O!$aA%oi\"9\u00111F\rA\u0002\u00055\u0012!D2p]\u001aLw\rS1oI2,'\u000fE\u0002,\u0003_I1!!\r\u001d\u0005I!v\u000e]5d\u0007>tg-[4IC:$G.\u001a:\t\r\u0005U\u0012\u00041\u0001W\u0003\u00151\u0018\r\\;f\u0003E\u0019'/Z1uK\u0006#W.\u001b8DY&,g\u000e\u001e\u000b\u0003\u0003w\u0001B!!\u0010\u0002N5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%A\u0003bI6LgN\u0003\u0003\u0002F\u0005\u001d\u0013aB2mS\u0016tGo\u001d\u0006\u0004?\u0005%#bAA&\u0015\u00061\u0011\r]1dQ\u0016LA!a\u0014\u0002@\t)\u0011\tZ7j]\u0002")
public class DynamicConfigChangeTest
extends KafkaServerTestHarness {
    public List<KafkaConfig> generateConfigs() {
        return new .colon.colon((Object)KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), (List)Nil$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConfigChange() {
        Assertions.assertTrue((boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)ConfigType$.MODULE$.Topic()), (String)"Should contain a ConfigHandler for topics");
        Long oldVal = Predef$.MODULE$.long2Long(100000L);
        Long newVal = Predef$.MODULE$.long2Long(200000L);
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), oldVal.toString());
        this.createTopic(tp.topic(), 1, 1, logProps);
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$1(this, tp, oldVal);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), newVal.toString());
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        TestUtils$ testUtils$2 = TestUtils$.MODULE$;
        long l2 = 10000L;
        if (testUtils$2 == null) {
            throw null;
        }
        TestUtils$ retry_this2 = testUtils$2;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testConfigChange$2(this, newVal, tp);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicTopicConfigChange() {
        TopicPartition tp = new TopicPartition("test", 0);
        int oldSegmentSize = 1000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(oldSegmentSize));
        this.createTopic(tp.topic(), 1, 1, logProps);
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$1(this, tp, oldSegmentSize);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        LogManager qual$2 = ((KafkaServer)this.servers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$2.getLog(tp, x$4).get();
        int newSegmentSize = 2000;
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(newSegmentSize));
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        TestUtils$ testUtils$2 = TestUtils$.MODULE$;
        long l2 = 10000L;
        if (testUtils$2 == null) {
            throw null;
        }
        TestUtils$ retry_this2 = testUtils$2;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$2(newSegmentSize, log);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> TestUtils$.MODULE$.produceMessage((Seq<KafkaServer>)this.servers(), tp.topic(), Integer.toString(i), TestUtils$.MODULE$.produceMessage$default$4(), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6()));
        Assertions.assertTrue((boolean)log.localLogSegments().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicConfigChangeTest.$anonfun$testDynamicTopicConfigChange$4(x$1))), (String)"Log segment size change not applied");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMessageFormatVersionChange() {
        TopicPartition tp = new TopicPartition("test", 0);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.10.2");
        this.createTopic(tp.topic(), 1, 1, logProps);
        KafkaServer server = (KafkaServer)this.servers().head();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$1(server, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LogManager qual$2 = server.logManager();
        boolean x$4 = qual$2.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$2.getLog(tp, x$4).get();
        Assertions.assertEquals((Object)KAFKA_3_0_IV1$.MODULE$, (Object)log.config().messageFormatVersion());
        Assertions.assertEquals((Object)RecordVersion.V2, (Object)log.config().recordVersion());
        String compressionType = CompressionType.LZ4.name;
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.11.0");
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), compressionType);
        this.adminZkClient().changeTopicConfig(tp.topic(), logProps);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$3(server, tp, compressionType)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DynamicConfigChangeTest.$anonfun$testMessageFormatVersionChange$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)KAFKA_3_0_IV1$.MODULE$, (Object)log.config().messageFormatVersion());
        Assertions.assertEquals((Object)RecordVersion.V2, (Object)log.config().recordVersion());
    }

    /*
     * WARNING - void declaration
     */
    private void testQuotaConfigChange(String user, String clientId, String rootEntityType, String configEntityName) {
        Assertions.assertTrue((boolean)((KafkaServer)this.servers().head()).dynamicConfigHandlers().contains((Object)rootEntityType), (String)new StringBuilder(35).append("Should contain a ConfigHandler for ").append(rootEntityType).toString());
        Properties props = new Properties();
        props.put("producer_byte_rate", "1000");
        props.put("consumer_byte_rate", "2000");
        QuotaFactory.QuotaManagers quotaManagers = ((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().quotas();
        String string = ConfigType$.MODULE$.Client();
        if (!(string != null ? !string.equals(rootEntityType) : rootEntityType != null)) {
            this.adminZkClient().changeClientIdConfig(configEntityName, props);
        } else {
            this.adminZkClient().changeUserOrUserClientIdConfig(configEntityName, props);
        }
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$1(quotaManagers, user, clientId);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        double defaultProducerQuota = Long.MAX_VALUE;
        double defaultConsumerQuota = Long.MAX_VALUE;
        Properties emptyProps = new Properties();
        String string2 = ConfigType$.MODULE$.Client();
        if (!(string2 != null ? !string2.equals(rootEntityType) : rootEntityType != null)) {
            this.adminZkClient().changeClientIdConfig(configEntityName, emptyProps);
        } else {
            this.adminZkClient().changeUserOrUserClientIdConfig(configEntityName, emptyProps);
        }
        TestUtils$ testUtils$2 = TestUtils$.MODULE$;
        long l2 = 10000L;
        if (testUtils$2 == null) {
            throw null;
        }
        TestUtils$ retry_this2 = testUtils$2;
        LongRef retry_wait2 = LongRef.create((long)1L);
        long retry_startTime2 = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testQuotaConfigChange$2(quotaManagers, user, clientId, defaultProducerQuota, defaultConsumerQuota);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this2.logger().underlying().isInfoEnabled()) {
                    retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                }
                Thread.sleep(retry_wait2.elem);
                retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                continue;
            }
            break;
        }
    }

    @Test
    public void testClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.Client(), "testClient");
    }

    @Test
    public void testUserQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "ANONYMOUS");
    }

    @Test
    public void testUserClientIdQuotaChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "ANONYMOUS/clients/testClient");
    }

    @Test
    public void testDefaultClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.Client(), "<default>");
    }

    @Test
    public void testDefaultUserQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "<default>");
    }

    @Test
    public void testDefaultUserClientIdQuotaConfigChange() {
        this.testQuotaConfigChange("ANONYMOUS", "testClient", ConfigType$.MODULE$.User(), "<default>/clients/<default>");
    }

    @Test
    public void testQuotaInitialization() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties clientIdProps = new Properties();
        server.shutdown();
        clientIdProps.put("producer_byte_rate", "1000");
        clientIdProps.put("consumer_byte_rate", "2000");
        Properties userProps = new Properties();
        userProps.put("producer_byte_rate", "10000");
        userProps.put("consumer_byte_rate", "20000");
        Properties userClientIdProps = new Properties();
        userClientIdProps.put("producer_byte_rate", "100000");
        userClientIdProps.put("consumer_byte_rate", "200000");
        this.adminZkClient().changeClientIdConfig("overriddenClientId", clientIdProps);
        this.adminZkClient().changeUserOrUserClientIdConfig("overriddenUser", userProps);
        this.adminZkClient().changeUserOrUserClientIdConfig("ANONYMOUS/clients/overriddenUserClientId", userClientIdProps);
        this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1 & Serializable & scala.Serializable)p -> {
            DynamicConfigChangeTest.$anonfun$testQuotaInitialization$1(this, p);
            return BoxedUnit.UNIT;
        });
        server.startup();
        QuotaFactory.QuotaManagers quotaManagers = server.dataPlaneRequestProcessor().quotas();
        Assertions.assertEquals((Object)Quota.upperBound((double)1000.0), (Object)quotaManagers.produce().quota("someuser", "overriddenClientId"));
        Assertions.assertEquals((Object)Quota.upperBound((double)2000.0), (Object)quotaManagers.fetch().quota("someuser", "overriddenClientId"));
        Assertions.assertEquals((Object)Quota.upperBound((double)10000.0), (Object)quotaManagers.produce().quota("overriddenUser", "someclientId"));
        Assertions.assertEquals((Object)Quota.upperBound((double)20000.0), (Object)quotaManagers.fetch().quota("overriddenUser", "someclientId"));
        Assertions.assertEquals((Object)Quota.upperBound((double)100000.0), (Object)quotaManagers.produce().quota("ANONYMOUS", "overriddenUserClientId"));
        Assertions.assertEquals((Object)Quota.upperBound((double)200000.0), (Object)quotaManagers.fetch().quota("ANONYMOUS", "overriddenUserClientId"));
    }

    @Test
    public void testIpHandlerUnresolvableAddress() {
        IpConfigHandler configHandler = new IpConfigHandler(null);
        Properties props = new Properties();
        props.put("connection_creation_rate", "1");
        Assertions.assertThrows(IllegalArgumentException.class, () -> configHandler.processConfigChanges("illegal-hostname", props));
    }

    @Test
    public void testIpQuotaInitialization() {
        KafkaServer server = (KafkaServer)this.servers().head();
        Properties ipOverrideProps = new Properties();
        ipOverrideProps.put("connection_creation_rate", "10");
        Properties ipDefaultProps = new Properties();
        ipDefaultProps.put("connection_creation_rate", "20");
        server.shutdown();
        this.adminZkClient().changeIpConfig(ConfigEntityName$.MODULE$.Default(), ipDefaultProps);
        this.adminZkClient().changeIpConfig("1.2.3.4", ipOverrideProps);
        this.zkClient().getChildren(ConfigEntityChangeNotificationZNode$.MODULE$.path()).foreach((Function1 & Serializable & scala.Serializable)p -> {
            DynamicConfigChangeTest.$anonfun$testIpQuotaInitialization$1(this, p);
            return BoxedUnit.UNIT;
        });
        server.startup();
        ConnectionQuotas connectionQuotas = server.socketServer().connectionQuotas();
        Assertions.assertEquals((long)10L, (long)connectionQuotas.connectionRateForIp(InetAddress.getByName("1.2.3.4")));
        Assertions.assertEquals((long)20L, (long)connectionQuotas.connectionRateForIp(InetAddress.getByName("2.4.6.8")));
    }

    @Test
    public void testIpQuotaConfigChange() {
        Properties ipOverrideProps = new Properties();
        ipOverrideProps.put("connection_creation_rate", "10");
        Properties ipDefaultProps = new Properties();
        ipDefaultProps.put("connection_creation_rate", "20");
        InetAddress overrideQuotaIp = InetAddress.getByName("1.2.3.4");
        InetAddress defaultQuotaIp = InetAddress.getByName("2.3.4.5");
        this.adminZkClient().changeIpConfig(ConfigEntityName$.MODULE$.Default(), ipDefaultProps);
        this.adminZkClient().changeIpConfig(overrideQuotaIp.getHostAddress(), ipOverrideProps);
        ConnectionQuotas connectionQuotas = ((KafkaServer)this.servers().head()).socketServer().connectionQuotas();
        DynamicConfigChangeTest.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(10), connectionQuotas);
        DynamicConfigChangeTest.verifyConnectionQuota$1(defaultQuotaIp, Predef$.MODULE$.int2Integer(20), connectionQuotas);
        Properties emptyProps = new Properties();
        this.adminZkClient().changeIpConfig(overrideQuotaIp.getHostAddress(), emptyProps);
        DynamicConfigChangeTest.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(20), connectionQuotas);
        this.adminZkClient().changeIpConfig(ConfigEntityName$.MODULE$.Default(), emptyProps);
        DynamicConfigChangeTest.verifyConnectionQuota$1(overrideQuotaIp, Predef$.MODULE$.int2Integer(Integer.MAX_VALUE), connectionQuotas);
    }

    @Test
    public void testConfigChangeOnNonExistingTopic() {
        String topic = TestUtils$.MODULE$.tempTopic();
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), Predef$.MODULE$.int2Integer(10000));
        Assertions.assertThrows(UnknownTopicOrPartitionException.class, () -> this.adminZkClient().changeTopicConfig(topic, logProps));
    }

    @Test
    public void testConfigChangeOnNonExistingTopicWithAdminClient() {
        String topic = TestUtils$.MODULE$.tempTopic();
        try (Admin admin = this.createAdminClient();){
            try {
                ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
                AlterConfigOp op = new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.FlushMessagesProp(), "10000"), AlterConfigOp.OpType.SET);
                admin.incrementalAlterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)op, (List)Nil$.MODULE$)).asJavaCollection())}))).asJava()).all().get();
                Assertions.fail((String)"Should fail with UnknownTopicOrPartitionException for topic doesn't exist");
            }
            catch (ExecutionException executionException) {
                Assertions.assertTrue((boolean)(executionException.getCause() instanceof UnknownTopicOrPartitionException));
            }
        }
    }

    @Test
    public void testProcessNotification() {
        new Properties().put("a.b", "10");
        Capture entityArgument = EasyMock.newCapture();
        Capture propertiesArgument = EasyMock.newCapture();
        ConfigHandler handler = (ConfigHandler)EasyMock.createNiceMock(ConfigHandler.class);
        handler.processConfigChanges((String)EasyMock.and((Object)EasyMock.capture((Capture)entityArgument), (Object)EasyMock.isA(String.class)), (Properties)EasyMock.and((Object)EasyMock.capture((Capture)propertiesArgument), (Object)EasyMock.isA(Properties.class)));
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{handler});
        DynamicConfigManager configManager = new DynamicConfigManager(this.zkClient(), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ConfigType$.MODULE$.Topic()), (Object)handler)})), DynamicConfigManager$.MODULE$.$lessinit$greater$default$3(), DynamicConfigManager$.MODULE$.$lessinit$greater$default$4());
        configManager.ConfigChangedNotificationHandler().processNotification("not json".getBytes(StandardCharsets.UTF_8));
        ObjectRef jsonMap = ObjectRef.create((Object)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)BoxesRunTime.boxToInteger((int)2))}))));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)"garbage"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)ConfigType$.MODULE$.Topic())}));
        Assertions.assertThrows(Throwable.class, () -> configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)jsonMap$1.elem).asJava())));
        jsonMap.elem = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_type"), (Object)ConfigType$.MODULE$.Topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"entity_name"), (Object)"x")}));
        configManager.ConfigChangedNotificationHandler().processNotification(Json$.MODULE$.encodeAsBytes(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)jsonMap.elem).asJava()));
        EasyMock.verify((Object[])new Object[]{handler});
    }

    @Test
    public void shouldParseReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class), null, null, null);
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:101,0:102,1:101,1:102");
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)configHandler.parseThrottledPartitions(props, 102, KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)configHandler.parseThrottledPartitions(props, 103, KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()));
    }

    @Test
    public void shouldParseWildcardReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class), null, null, null);
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "*");
        Seq result = configHandler.parseThrottledPartitions(props, 102, KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
        Assertions.assertEquals((Object)Constants$.MODULE$.AllReplicas(), (Object)result);
    }

    @Test
    public void shouldParseNoneReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class), null, null, null);
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "none");
        Seq result = configHandler.parseThrottledPartitions(props, 102, KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
        Assertions.assertEquals((Object)Constants$.MODULE$.NoReplicas(), (Object)result);
    }

    @Test
    public void shouldParseReplicationQuotaReset() {
        TopicConfigHandler configHandler = new TopicConfigHandler((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class), null, null, null);
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "");
        Seq result = configHandler.parseThrottledPartitions(props, 102, KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)result);
    }

    @Test
    public void shouldParseRegardlessOfWhitespaceAroundValues() {
        TopicConfigHandler configHandler = new TopicConfigHandler((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class), null, null, null);
        Assertions.assertEquals((Object)Constants$.MODULE$.AllReplicas(), this.parse(configHandler, "* "));
        Assertions.assertEquals((Object)Constants$.MODULE$.NoReplicas(), this.parse(configHandler, "none "));
        Assertions.assertEquals((Object)Nil$.MODULE$, this.parse(configHandler, " "));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, "6:102"));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, "6:102 "));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), this.parse(configHandler, " 6:102"));
    }

    public Seq<Object> parse(TopicConfigHandler configHandler, String value) {
        return configHandler.parseThrottledPartitions(CoreUtils$.MODULE$.propsWith(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), value), 102, KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
    }

    private Admin createAdminClient() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList());
        return Admin.create((Properties)props);
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$1, Long oldVal$1) {
        LogManager qual$1 = ((KafkaServer)$this.servers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$1, x$2);
        Assertions.assertTrue((boolean)logOpt.isDefined());
        Assertions.assertEquals((Long)oldVal$1, (Long)((AbstractLog)logOpt.get()).config().flushInterval());
    }

    public static final /* synthetic */ void $anonfun$testConfigChange$2(DynamicConfigChangeTest $this, Long newVal$1, TopicPartition tp$1) {
        LogManager qual$2 = ((KafkaServer)$this.servers().head()).logManager();
        boolean x$4 = qual$2.getLog$default$2();
        Assertions.assertEquals((Long)newVal$1, (Long)((AbstractLog)qual$2.getLog(tp$1, x$4).get()).config().flushInterval());
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$1(DynamicConfigChangeTest $this, TopicPartition tp$2, int oldSegmentSize$1) {
        LogManager qual$1 = ((KafkaServer)$this.servers().head()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option logOpt = qual$1.getLog(tp$2, x$2);
        Assertions.assertTrue((boolean)logOpt.isDefined());
        Assertions.assertEquals((int)oldSegmentSize$1, (Integer)((AbstractLog)logOpt.get()).config().segmentSize());
    }

    public static final /* synthetic */ void $anonfun$testDynamicTopicConfigChange$2(int newSegmentSize$1, AbstractLog log$1) {
        Assertions.assertEquals((int)newSegmentSize$1, (Integer)log$1.config().segmentSize());
    }

    public static final /* synthetic */ boolean $anonfun$testDynamicTopicConfigChange$4(LogSegment x$1) {
        return x$1.size() > 1000;
    }

    public static final /* synthetic */ boolean $anonfun$testMessageFormatVersionChange$1(KafkaServer server$1, TopicPartition tp$3) {
        LogManager qual$1 = server$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(tp$3, x$2).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testMessageFormatVersionChange$2() {
        return "Topic metadata propagation failed";
    }

    public static final /* synthetic */ boolean $anonfun$testMessageFormatVersionChange$3(KafkaServer server$1, TopicPartition tp$3, String compressionType$1) {
        LogManager qual$3 = server$1.logManager();
        boolean x$6 = qual$3.getLog$default$2();
        String string = ((AbstractLog)qual$3.getLog(tp$3, x$6).get()).config().compressionType();
        return !(string != null ? !string.equals(compressionType$1) : compressionType$1 != null);
    }

    public static final /* synthetic */ String $anonfun$testMessageFormatVersionChange$4() {
        return "Topic config change propagation failed";
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$1(QuotaFactory.QuotaManagers quotaManagers$1, String user$1, String clientId$1) {
        Quota overrideProducerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota overrideConsumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        Assertions.assertEquals((Object)Quota.upperBound((double)1000.0), (Object)overrideProducerQuota, (String)new StringBuilder(59).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have overridden producer quota of 1000").toString());
        Assertions.assertEquals((Object)Quota.upperBound((double)2000.0), (Object)overrideConsumerQuota, (String)new StringBuilder(59).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have overridden consumer quota of 2000").toString());
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigChange$2(QuotaFactory.QuotaManagers quotaManagers$1, String user$1, String clientId$1, double defaultProducerQuota$1, double defaultConsumerQuota$1) {
        Quota producerQuota = quotaManagers$1.produce().quota(user$1, clientId$1);
        Quota consumerQuota = quotaManagers$1.fetch().quota(user$1, clientId$1);
        Assertions.assertEquals((Object)Quota.upperBound((double)defaultProducerQuota$1), (Object)producerQuota, (String)new StringBuilder(50).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have reset producer quota to ").append(defaultProducerQuota$1).toString());
        Assertions.assertEquals((Object)Quota.upperBound((double)defaultConsumerQuota$1), (Object)consumerQuota, (String)new StringBuilder(50).append("User ").append(user$1).append(" clientId ").append(clientId$1).append(" must have reset consumer quota to ").append(defaultConsumerQuota$1).toString());
    }

    public static final /* synthetic */ void $anonfun$testQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        KafkaZkClient qual$1 = $this.zkClient();
        String x$1 = new StringBuilder(1).append(ConfigEntityChangeNotificationZNode$.MODULE$.path()).append("/").append(p).toString();
        int x$2 = qual$1.deletePath$default$2();
        boolean x$3 = qual$1.deletePath$default$3();
        qual$1.deletePath(x$1, x$2, x$3);
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaInitialization$1(DynamicConfigChangeTest $this, String p) {
        KafkaZkClient qual$1 = $this.zkClient();
        String x$1 = new StringBuilder(1).append(ConfigEntityChangeNotificationZNode$.MODULE$.path()).append("/").append(p).toString();
        int x$2 = qual$1.deletePath$default$2();
        boolean x$3 = qual$1.deletePath$default$3();
        qual$1.deletePath(x$1, x$2, x$3);
    }

    public static final /* synthetic */ void $anonfun$testIpQuotaConfigChange$1(ConnectionQuotas connectionQuotas$1, InetAddress ip$1, Integer expectedQuota$1) {
        int quota = connectionQuotas$1.connectionRateForIp(ip$1);
        Assertions.assertEquals((Integer)expectedQuota$1, (int)quota, (String)new StringBuilder(24).append("Unexpected quota for IP ").append(ip$1).toString());
    }

    /*
     * WARNING - void declaration
     */
    private static final void verifyConnectionQuota$1(InetAddress ip, Integer expectedQuota, ConnectionQuotas connectionQuotas$1) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 10000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                DynamicConfigChangeTest.$anonfun$testIpQuotaConfigChange$1(connectionQuotas$1, ip, expectedQuota);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }
}

