/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.Socket;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.log.LogConfig$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.ProducerCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import kafka.server.BaseFetchRequestTest;
import kafka.server.FetchRequestTest$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.SetLike;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0005\n\u0001/!)A\u0004\u0001C\u0001;!)q\u0004\u0001C\u0001A!)A\u0007\u0001C\u0001A!)a\u0007\u0001C\u0001A!)\u0001\b\u0001C\u0001A!)!\b\u0001C\u0001A!)A\b\u0001C\u0001A!)a\b\u0001C\u0001A!)\u0001\t\u0001C\u0005\u0003\")A\u000b\u0001C\u0001A!)a\u000b\u0001C\u0001A!)\u0001\f\u0001C\u0001A!)!\f\u0001C\u0001A!)A\f\u0001C\u0001A!)a\f\u0001C\u0001A!)\u0001\r\u0001C\u0005C\n\u0001b)\u001a;dQJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003'Q\taa]3sm\u0016\u0014(\"A\u000b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00033ii\u0011AE\u0005\u00037I\u0011ACQ1tK\u001a+Go\u00195SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u001f!\tI\u0002!\u0001\u0018uKN$(I]8lKJ\u0014Vm\u001d9fGR\u001c\b+\u0019:uSRLwN\\:Pe\u0012,'/\u00118e'&TX\rT5nSR\u001cH#A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005!\u0002\"!\u000b\u001a\u000e\u0003)R!a\u000b\u0017\u0002\u0007\u0005\u0004\u0018N\u0003\u0002.]\u00059!.\u001e9ji\u0016\u0014(BA\u00181\u0003\u0015QWO\\5u\u0015\u0005\t\u0014aA8sO&\u00111G\u000b\u0002\u0005)\u0016\u001cH/A\u0012uKN$h)\u001a;dQJ+\u0017/^3tiZ#t+\u001b;i%\u0016\fGmQ8n[&$H/\u001a3)\u0005\rA\u0013\u0001\b;fgR4U\r^2i%\u0016\fX/Z:u)>tuN\u001c*fa2L7-\u0019\u0015\u0003\t!\na\u0004^3ti2\u000b7\u000f\u001e$fi\u000eDW\rZ#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8)\u0005\u0015A\u0013A\u0007;fgR\u001cUO\u001d:f]R,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>t\u0007F\u0001\u0004)\u0003\u0015\"Xm\u001d;Fa>\u001c\u0007NV1mS\u0012\fG/[8o/&$\b.\u001b8GKR\u001c\u0007nU3tg&|g\u000e\u000b\u0002\bQ\u0005\tE/Z:u\r\u0016$8\r\u001b*fcV,7\u000f\u001e#ve&tw\rU1si&$\u0018n\u001c8SK\u000e|g/\u001a:z\u0003\u001a$XM]+oG2,\u0017M\u001c'fC\u0012,'/\u00127fGRLwN\u001c\u0015\u0003\u0011!\n\u0001D^3sS\u001aLh)\u001a;dQN+7o]5p]\u0016\u0013(o\u001c:t)\u0011\t#)\u0014*\t\u000b\rK\u0001\u0019\u0001#\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B\u0011QiS\u0007\u0002\r*\u0011q\tS\u0001\u0007G>lWn\u001c8\u000b\u0005UI%B\u0001&1\u0003\u0019\t\u0007/Y2iK&\u0011AJ\u0012\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0015q\u0015\u00021\u0001P\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u0011\u0005\t\u0002\u0016BA)$\u0005\rIe\u000e\u001e\u0005\u0006'&\u0001\raT\u0001\u0014I\u0016\u001cH/\u001b8bi&|gN\u0011:pW\u0016\u0014\u0018\nZ\u0001(i\u0016\u001cH\u000fR8x]\u000e{gN^3sg&|gnV5uQ\u000e{gN\\3di&|gNR1jYV\u0014X\r\u000b\u0002\u000bQ\u00051D/Z:u\t><hnQ8om\u0016\u00148/[8o\rJ|WNQ1uG\",G\rV8V]\n\fGo\u00195fIJ+7\u000f]3diN|eMZ:fi\"\u00121\u0002K\u00010i\u0016\u001cHo\u0011:fCR,\u0017J\\2sK6,g\u000e^1m\r\u0016$8\r[,ji\"\u0004\u0016M\u001d;ji&|gn]%o\u000bJ\u0014xN\u001d\u0015\u0003\u0019!\nq\u0003^3tij\u001bF\u000fZ\"p[B\u0014Xm]:fIR{\u0007/[2)\u00055A\u0013a\u0006;fgR\u0004\u0016M\u001d;ji&|g\u000eR1uC\u0016\u000bX/\u00197tQ\tq\u0001&A\ruKN$(l\u0015;e\u0007>l\u0007O]3tg\u0016$'+Z2pe\u0012\u001c\bFA\b)\u0003I\u0019\u0007.Z2l\r\u0016$8\r\u001b*fgB|gn]3\u0015\r\u0005\u0012'N\u001d;w\u0011\u0015\u0019\u0007\u00031\u0001e\u0003I)\u0007\u0010]3di\u0016$\u0007+\u0019:uSRLwN\\:\u0011\u0007\u0015DG)D\u0001g\u0015\t97%\u0001\u0006d_2dWm\u0019;j_:L!!\u001b4\u0003\u0007M+\u0017\u000fC\u0003l!\u0001\u0007A.A\u0007gKR\u001c\u0007NU3ta>t7/\u001a\t\u0003[Bl\u0011A\u001c\u0006\u0003_\u001a\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0003c:\u0014QBR3uG\"\u0014Vm\u001d9p]N,\u0007\"B:\u0011\u0001\u0004y\u0015!E7bqB\u000b'\u000f^5uS>t')\u001f;fg\")Q\u000f\u0005a\u0001\u001f\u0006\u0001R.\u0019=SKN\u0004xN\\:f\u0005f$Xm\u001d\u0005\u0006oB\u0001\raT\u0001\u0018]VlW*Z:tC\u001e,7\u000fU3s!\u0006\u0014H/\u001b;j_:\u0004")
public class FetchRequestTest
extends BaseFetchRequestTest {
    @Test
    public void testBrokerRespectsPartitionsOrderAndSizeLimits() {
        this.initProducer();
        int messagesPerPartition = 9;
        int maxResponseBytes = 800;
        int maxPartitionBytes = 190;
        scala.collection.immutable.Map<TopicPartition, Object> topicPartitionToLeader = this.createTopics(5, 6, this.createTopics$default$3());
        Random random = new Random(0);
        Set topicPartitions = topicPartitionToLeader.keySet();
        this.produceData((Iterable<TopicPartition>)topicPartitions, messagesPerPartition);
        int leaderId = ((KafkaServer)this.servers().head()).config().brokerId();
        Vector partitionsForLeader = (Vector)topicPartitionToLeader.toVector().collect((PartialFunction)new scala.Serializable(null, leaderId){
            public static final long serialVersionUID = 0L;
            private final int leaderId$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    TopicPartition tp = (TopicPartition)x1._1();
                    if (x1._2$mcI$sp() == this.leaderId$1) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, Object> x1) {
                boolean bl = x1 != null && x1._2$mcI$sp() == this.leaderId$1;
                return bl;
            }
            {
                this.leaderId$1 = leaderId$1;
            }
        }, Vector$.MODULE$.canBuildFrom());
        Vector partitionsWithLargeMessages = partitionsForLeader.takeRight(2);
        TopicPartition partitionWithLargeMessage1 = (TopicPartition)partitionsWithLargeMessages.head();
        TopicPartition partitionWithLargeMessage2 = (TopicPartition)partitionsWithLargeMessages.apply(1);
        this.producer().send(new ProducerRecord(partitionWithLargeMessage1.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage1.partition()), (Object)"larger than partition limit", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        this.producer().send(new ProducerRecord(partitionWithLargeMessage2.topic(), Predef$.MODULE$.int2Integer(partitionWithLargeMessage2.partition()), (Object)"larger than response limit", (Object)new String(new byte[maxResponseBytes + 1]))).get();
        Vector partitionsWithoutLargeMessages = (Vector)partitionsForLeader.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionsWithLargeMessages.contains(elem)));
        Vector shuffledTopicPartitions1 = (Vector)((Vector)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLargeMessages, Vector$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest1 = this.createFetchRequest$1((Seq)shuffledTopicPartitions1, FetchRequestTest.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse1 = this.sendFetchRequest(leaderId, fetchRequest1);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions1, fetchResponse1, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        Vector shuffledTopicPartitions2 = (Vector)((Vector)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)partitionsWithLargeMessages, Vector$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest2 = this.createFetchRequest$1((Seq)shuffledTopicPartitions2, FetchRequestTest.createFetchRequest$default$2$1(), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse2 = this.sendFetchRequest(leaderId, fetchRequest2);
        this.checkFetchResponse((Seq<TopicPartition>)shuffledTopicPartitions2, fetchResponse2, maxPartitionBytes, maxResponseBytes, messagesPerPartition);
        Seq shuffledTopicPartitions3 = (Seq)new .colon.colon((Object)partitionWithLargeMessage1, (List)new .colon.colon((Object)partitionWithLargeMessage2, (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest3 = this.createFetchRequest$1(shuffledTopicPartitions3, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage1), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse3 = this.sendFetchRequest(leaderId, fetchRequest3);
        Assertions.assertEquals((Object)shuffledTopicPartitions3, (Object)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(fetchResponse3.responseData().keySet()).asScala()).toSeq());
        Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)((TraversableOnce)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse3.responseData()).asScala()).values().map((Function1 & Serializable & scala.Serializable)partitionData -> BoxesRunTime.boxToInteger((int)FetchRequestTest.$anonfun$testBrokerRespectsPartitionsOrderAndSizeLimits$2(this, partitionData)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) <= maxResponseBytes ? 1 : 0) != 0);
        FetchResponseData.PartitionData partitionData3 = (FetchResponseData.PartitionData)fetchResponse3.responseData().get(partitionWithLargeMessage1);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData3.errorCode());
        Assertions.assertTrue((partitionData3.highWatermark() > 0L ? 1 : 0) != 0);
        int size3 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.records(partitionData3).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((size3 <= maxResponseBytes ? 1 : 0) != 0, (String)new StringBuilder(29).append("Expected ").append(size3).append(" to be smaller than ").append(maxResponseBytes).toString());
        Assertions.assertTrue((size3 > maxPartitionBytes ? 1 : 0) != 0, (String)new StringBuilder(28).append("Expected ").append(size3).append(" to be larger than ").append(maxPartitionBytes).toString());
        Assertions.assertTrue((maxPartitionBytes < FetchResponse.recordsSize((FetchResponseData.PartitionData)partitionData3) ? 1 : 0) != 0);
        Seq shuffledTopicPartitions4 = (Seq)new .colon.colon((Object)partitionWithLargeMessage2, (List)new .colon.colon((Object)partitionWithLargeMessage1, (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)random.shuffle((TraversableOnce)partitionsWithoutLargeMessages, Vector$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        FetchRequest fetchRequest4 = this.createFetchRequest$1(shuffledTopicPartitions4, (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partitionWithLargeMessage2), (Object)BoxesRunTime.boxToLong((long)messagesPerPartition))})), maxResponseBytes, maxPartitionBytes);
        FetchResponse fetchResponse4 = this.sendFetchRequest(leaderId, fetchRequest4);
        Assertions.assertEquals((Object)shuffledTopicPartitions4, (Object)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(fetchResponse4.responseData().keySet()).asScala()).toSeq());
        Seq nonEmptyPartitions4 = (Seq)((scala.collection.mutable.MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse4.responseData()).asScala()).toSeq().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FetchRequestTest $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, FetchResponseData.PartitionData>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                if (x2 != null) {
                    TopicPartition tp = (TopicPartition)x2._1();
                    FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)x2._2();
                    if (BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.records(partitionData).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)$anonfun$2.$anonfun$applyOrElse$1(x$3)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0) {
                        object = tp;
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, FetchResponseData.PartitionData> x2) {
                FetchResponseData.PartitionData partitionData;
                boolean bl = x2 != null && BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.$outer.records(partitionData = (FetchResponseData.PartitionData)x2._2()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)$anonfun$2.$anonfun$isDefinedAt$1(x$3)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0;
                return bl;
            }

            public static final /* synthetic */ int $anonfun$applyOrElse$1(Record x$3) {
                return x$3.sizeInBytes();
            }

            public static final /* synthetic */ int $anonfun$isDefinedAt$1(Record x$3) {
                return x$3.sizeInBytes();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.kafka.common.record.Record ), $anonfun$isDefinedAt$1$adapted(org.apache.kafka.common.record.Record )}, serializedLambda);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)new .colon.colon((Object)partitionWithLargeMessage2, (List)Nil$.MODULE$), (Object)nonEmptyPartitions4);
        FetchResponseData.PartitionData partitionData4 = (FetchResponseData.PartitionData)fetchResponse4.responseData().get(partitionWithLargeMessage2);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData4.errorCode());
        Assertions.assertTrue((partitionData4.highWatermark() > 0L ? 1 : 0) != 0);
        int size4 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.records(partitionData4).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assertions.assertTrue((size4 > maxResponseBytes ? 1 : 0) != 0, (String)new StringBuilder(28).append("Expected ").append(size4).append(" to be larger than ").append(maxResponseBytes).toString());
        Assertions.assertTrue((maxResponseBytes < FetchResponse.recordsSize((FetchResponseData.PartitionData)partitionData4) ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchRequestV4WithReadCommitted() {
        void var3_3;
        this.initProducer();
        int maxPartitionBytes = 200;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        this.producer().send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key", (Object)new String(new byte[maxPartitionBytes + 1]))).get();
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), this.createPartitionMap$default$3())).isolationLevel(IsolationLevel.READ_COMMITTED).build((short)4);
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(n, fetchRequest).responseData().get(var3_3);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Assertions.assertTrue((partitionData.lastStableOffset() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.records(partitionData).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFetchRequestToNonReplica() {
        String topic = "topic";
        int partition = 0;
        TopicPartition topicPartition = new TopicPartition(topic, partition);
        int leader = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        Option nonReplicaOpt = this.servers().find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)FetchRequestTest.$anonfun$testFetchRequestToNonReplica$1(leader, x$7)));
        Assertions.assertTrue((boolean)nonReplicaOpt.isDefined());
        int nonReplicaId = ((KafkaServer)nonReplicaOpt.get()).config().brokerId();
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), this.createPartitionMap$default$3())).build();
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(nonReplicaId, fetchRequest).responseData().get(topicPartition);
        Assertions.assertEquals((short)Errors.NOT_LEADER_OR_FOLLOWER.code(), (short)partitionData.errorCode());
    }

    @Test
    public void testLastFetchedEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        int firstLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(firstLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.initProducer();
        long firstEpochEndOffset = ((RecordMetadata)this.produceData((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), 100).lastOption().get()).offset() + 1L;
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        long secondEpochEndOffset = ((RecordMetadata)this.produceData((Iterable<TopicPartition>)new .colon.colon((Object)topicPartition, (List)Nil$.MODULE$), 100).lastOption().get()).offset() + 1L;
        long fetchOffset = secondEpochEndOffset + (secondEpochEndOffset - firstEpochEndOffset) / 2L;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition, new FetchRequest.PartitionData(fetchOffset, 0L, 1024, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), Optional.of(Predef$.MODULE$.int2Integer(firstLeaderEpoch))));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, partitionMap).build();
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(secondLeaderId, fetchRequest).responseData().get(topicPartition);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Assertions.assertEquals((long)0L, (long)FetchResponse.recordsSize((FetchResponseData.PartitionData)partitionData));
        Assertions.assertTrue((boolean)FetchResponse.isDivergingEpoch((FetchResponseData.PartitionData)partitionData));
        FetchResponseData.EpochEndOffset divergingEpoch = partitionData.divergingEpoch();
        Assertions.assertEquals((int)firstLeaderEpoch, (int)divergingEpoch.epoch());
        Assertions.assertEquals((long)firstEpochEndOffset, (long)divergingEpoch.endOffset());
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, followerId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
    }

    @Test
    public void testEpochValidationWithinFetchSession() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6()).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, TestUtils$.MODULE$.awaitLeaderChange$default$4());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.verifyFetchSessionErrors(topicPartition, secondLeaderEpoch, secondLeaderId);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaServer>)this.servers());
        this.verifyFetchSessionErrors(topicPartition, secondLeaderEpoch, followerId);
    }

    @Test
    public void testFetchRequestDuringPartitionRecoveryAfterUncleanLeaderElection() {
        String topic = "topic";
        TopicPartition partition = new TopicPartition(topic, 0);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        Set replicas = this.zkClient().getReplicasForPartition(partition).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition.partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$8 -> x$8 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableLike)this.servers().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)FetchRequestTest.$anonfun$testFetchRequestDuringPartitionRecoveryAfterUncleanLeaderElection$2(x$9)), Buffer$.MODULE$.canBuildFrom())).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$10 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$10))).get());
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), topic, 1024, -1);
        ((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)FetchRequestTest.$anonfun$testFetchRequestDuringPartitionRecoveryAfterUncleanLeaderElection$4(leader, x$11))).get()).replicaManager().getPartitionOrException(partition).setUncleanLeaderFlagTo(false);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)ApiKeys.FETCH.oldestVersion()), (int)ApiKeys.FETCH.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)ver -> {
            this.createFetchRequestsAndValidateResponses$1((short)ver, leader, Errors.NONE, Errors.NONE, partition, follower);
            Errors consumerError = ver >= 11 ? Errors.NONE : Errors.NOT_LEADER_OR_FOLLOWER;
            this.createFetchRequestsAndValidateResponses$1((short)ver, follower, consumerError, Errors.NOT_LEADER_OR_FOLLOWER, partition, follower);
            this.createFetchRequestsAndValidateResponses$1((short)ver, nonReplica, Errors.NOT_LEADER_OR_FOLLOWER, Errors.NOT_LEADER_OR_FOLLOWER, partition, follower);
        });
        ((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)FetchRequestTest.$anonfun$testFetchRequestDuringPartitionRecoveryAfterUncleanLeaderElection$6(leader, x$12))).get()).replicaManager().getPartitionOrException(partition).setUncleanLeaderFlagTo(true);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)ApiKeys.FETCH.oldestVersion()), (int)ApiKeys.FETCH.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)ver -> {
            this.createFetchRequestsAndValidateResponses$1((short)ver, leader, Errors.NOT_LEADER_OR_FOLLOWER, Errors.NOT_LEADER_OR_FOLLOWER, partition, follower);
            Errors consumerError = ver >= 11 ? Errors.NONE : Errors.NOT_LEADER_OR_FOLLOWER;
            this.createFetchRequestsAndValidateResponses$1((short)ver, follower, consumerError, Errors.NOT_LEADER_OR_FOLLOWER, partition, follower);
            this.createFetchRequestsAndValidateResponses$1((short)ver, nonReplica, Errors.NOT_LEADER_OR_FOLLOWER, Errors.NOT_LEADER_OR_FOLLOWER, partition, follower);
        });
        ((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)FetchRequestTest.$anonfun$testFetchRequestDuringPartitionRecoveryAfterUncleanLeaderElection$8(leader, x$13))).get()).replicaManager().getPartitionOrException(partition).setUncleanLeaderFlagTo(false);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)ApiKeys.FETCH.oldestVersion()), (int)ApiKeys.FETCH.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)ver -> {
            this.createFetchRequestsAndValidateResponses$1((short)ver, leader, Errors.NONE, Errors.NONE, partition, follower);
            Errors consumerError = ver >= 11 ? Errors.NONE : Errors.NOT_LEADER_OR_FOLLOWER;
            this.createFetchRequestsAndValidateResponses$1((short)ver, follower, consumerError, Errors.NOT_LEADER_OR_FOLLOWER, partition, follower);
            this.createFetchRequestsAndValidateResponses$1((short)ver, nonReplica, Errors.NOT_LEADER_OR_FOLLOWER, Errors.NOT_LEADER_OR_FOLLOWER, partition, follower);
        });
    }

    private void verifyFetchSessionErrors(TopicPartition topicPartition, int leaderEpoch, int destinationBrokerId) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition, new FetchRequest.PartitionData(0L, 0L, 1024, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch))));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, partitionMap).metadata(FetchMetadata.INITIAL).build();
        int sessionId = this.sendFetchRequest(destinationBrokerId, fetchRequest).sessionId();
        this.assertResponseErrorForEpoch$2(Errors.FENCED_LEADER_EPOCH, 1, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), topicPartition, sessionId, destinationBrokerId);
        this.assertResponseErrorForEpoch$2(Errors.UNKNOWN_LEADER_EPOCH, 2, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), topicPartition, sessionId, destinationBrokerId);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDownConversionWithConnectionFailure() {
        IndexedSeq indexedSeq;
        void var2_2;
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        int msgValueLen = 100000;
        int batchSize = 4 * msgValueLen;
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$2 = Integer.MAX_VALUE;
        int x$3 = Integer.MAX_VALUE;
        StringSerializer x$5 = new StringSerializer();
        ByteArraySerializer x$6 = new ByteArraySerializer();
        int x$7 = TestUtils$.MODULE$.createProducer$default$2();
        long x$8 = TestUtils$.MODULE$.createProducer$default$3();
        long x$9 = TestUtils$.MODULE$.createProducer$default$4();
        int x$10 = TestUtils$.MODULE$.createProducer$default$5();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        int x$12 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$162 = TestUtils$.MODULE$.createProducer$default$16();
        byte[] bytes = new byte[msgValueLen];
        try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$1, x$7, x$8, x$9, x$10, x$3, x$2, batchSize, x$11, x$12, x$13, x$14, x$15, x$5, x$6, x$162);){
            indexedSeq = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1000).map(arg_0 -> FetchRequestTest.$anonfun$testDownConversionWithConnectionFailure$1$adapted(producer, (TopicPartition)var2_2, bytes, arg_0), IndexedSeq$.MODULE$.canBuildFrom());
        }
        indexedSeq.foreach((Function1 & Serializable & scala.Serializable)x$16 -> (RecordMetadata)x$16.get());
        short version = (short)1;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 15).foreach(arg_0 -> FetchRequestTest.$anonfun$testDownConversionWithConnectionFailure$3$adapted(this, version, msgValueLen, (TopicPartition)var2_2, n, batchSize, arg_0));
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)((FetchResponse)this.fetch$1(version, batchSize, false, (TopicPartition)var2_2, n, batchSize).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("No fetch response");
        })).responseData().get(var2_2);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Buffer batches = ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData).batches()).asScala()).toBuffer();
        Assertions.assertEquals((int)3, (int)batches.size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDownConversionFromBatchedToUnbatchedRespectsOffset() {
        void var20_18;
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$2 = 5;
        StringSerializer x$3 = new StringSerializer();
        StringSerializer x$4 = new StringSerializer();
        int x$5 = 30000;
        int x$6 = 60000;
        int x$7 = TestUtils$.MODULE$.createProducer$default$2();
        long x$8 = TestUtils$.MODULE$.createProducer$default$3();
        long x$9 = TestUtils$.MODULE$.createProducer$default$4();
        int x$10 = TestUtils$.MODULE$.createProducer$default$8();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        int x$12 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$7, x$8, x$9, x$2, x$6, x$5, x$10, x$11, x$12, x$13, x$14, x$15, x$3, x$4, x$16));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, this.createTopics$default$3()).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        String topic = var20_18.topic();
        IndexedSeq firstBatchFutures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable & scala.Serializable)i -> FetchRequestTest.$anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$1(this, topic, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.producer().flush();
        IndexedSeq secondBatchFutures = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(10), 25).map((Function1 & Serializable & scala.Serializable)i -> FetchRequestTest.$anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$2(this, topic, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.producer().flush();
        firstBatchFutures.foreach((Function1 & Serializable & scala.Serializable)x$19 -> (RecordMetadata)x$19.get());
        secondBatchFutures.foreach((Function1 & Serializable & scala.Serializable)x$20 -> (RecordMetadata)x$20.get());
        long x$17 = 3L;
        long x$18 = 3L;
        short x$192 = 1;
        int x$202 = 22;
        byte x$21 = 0;
        this.check$1(x$17, x$192, x$18, x$202, x$21, (TopicPartition)var20_18, n);
        long x$22 = 15L;
        long x$23 = 15L;
        short x$24 = 1;
        int x$25 = 10;
        byte x$26 = 0;
        this.check$1(x$22, x$24, x$23, x$25, x$26, (TopicPartition)var20_18, n);
        long x$27 = 3L;
        long x$28 = 3L;
        short x$29 = 3;
        int x$30 = 22;
        byte x$31 = 1;
        this.check$1(x$27, x$29, x$28, x$30, x$31, (TopicPartition)var20_18, n);
        long x$32 = 15L;
        long x$33 = 15L;
        short x$34 = 3;
        int x$35 = 10;
        byte x$36 = 1;
        this.check$1(x$32, x$34, x$33, x$35, x$36, (TopicPartition)var20_18, n);
        long x$37 = 3L;
        long x$38 = 0L;
        short x$39 = 4;
        int x$40 = 2;
        byte x$41 = 2;
        this.check$1(x$37, x$39, x$38, x$40, x$41, (TopicPartition)var20_18, n);
        long x$42 = 15L;
        long x$43 = 10L;
        short x$44 = 4;
        int x$45 = 1;
        byte x$46 = 2;
        this.check$1(x$42, x$44, x$43, x$45, x$46, (TopicPartition)var20_18, n);
        long x$47 = 10L;
        long x$48 = 10L;
        short x$49 = 4;
        int x$50 = 1;
        byte x$51 = 2;
        this.check$1(x$47, x$49, x$48, x$50, x$51, (TopicPartition)var20_18, n);
    }

    @Test
    public void testCreateIncrementalFetchWithPartitionsInError() {
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        this.createTopic("foo", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2})))}))));
        TopicPartition bar0 = new TopicPartition("bar", 0);
        FetchRequest req1 = this.createFetchRequest$2((Seq)new .colon.colon((Object)foo0, (List)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)bar0, (List)Nil$.MODULE$))), FetchMetadata.INITIAL, (Seq)Nil$.MODULE$);
        FetchResponse resp1 = this.sendFetchRequest(0, req1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() > 0 ? 1 : 0) != 0, (String)"Expected the broker to create a new incremental fetch session");
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Test created an incremental fetch session ").append(resp1.sessionId()).toString());
        Assertions.assertTrue((boolean)resp1.responseData().containsKey(foo0));
        Assertions.assertTrue((boolean)resp1.responseData().containsKey(foo1));
        Assertions.assertTrue((boolean)resp1.responseData().containsKey(bar0));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((FetchResponseData.PartitionData)resp1.responseData().get(foo0)).errorCode());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((FetchResponseData.PartitionData)resp1.responseData().get(foo1)).errorCode());
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)((FetchResponseData.PartitionData)resp1.responseData().get(bar0)).errorCode());
        FetchRequest req2 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 1), (Seq)Nil$.MODULE$);
        FetchResponse resp2 = this.sendFetchRequest(0, req2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp2.sessionId(), (String)"Expected the broker to continue the incremental fetch session");
        Assertions.assertFalse((boolean)resp2.responseData().containsKey(foo0));
        Assertions.assertFalse((boolean)resp2.responseData().containsKey(foo1));
        Assertions.assertTrue((boolean)resp2.responseData().containsKey(bar0));
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)((FetchResponseData.PartitionData)resp2.responseData().get(bar0)).errorCode());
        this.createTopic("bar", (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))));
        FetchRequest req3 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 2), (Seq)Nil$.MODULE$);
        FetchResponse resp3 = this.sendFetchRequest(0, req3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assertions.assertFalse((boolean)resp3.responseData().containsKey(foo0));
        Assertions.assertFalse((boolean)resp3.responseData().containsKey(foo1));
        Assertions.assertTrue((boolean)resp3.responseData().containsKey(bar0));
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((FetchResponseData.PartitionData)resp3.responseData().get(bar0)).errorCode());
        FetchRequest req4 = this.createFetchRequest$2((Seq)Nil$.MODULE$, new FetchMetadata(resp1.sessionId(), 3), (Seq)Nil$.MODULE$);
        FetchResponse resp4 = this.sendFetchRequest(0, req4);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp4.error());
        Assertions.assertFalse((boolean)resp4.responseData().containsKey(foo0));
        Assertions.assertFalse((boolean)resp4.responseData().containsKey(foo1));
        Assertions.assertFalse((boolean)resp4.responseData().containsKey(bar0));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZStdCompressedTopic() {
        void var3_3;
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp()), (Object)ZStdCompressionCodec$.MODULE$.name())}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        StringSerializer x$2 = new StringSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = TestUtils$.MODULE$.createProducer$default$2();
        long x$5 = TestUtils$.MODULE$.createProducer$default$3();
        long x$6 = TestUtils$.MODULE$.createProducer$default$4();
        int x$7 = TestUtils$.MODULE$.createProducer$default$5();
        int x$8 = TestUtils$.MODULE$.createProducer$default$6();
        int x$9 = TestUtils$.MODULE$.createProducer$default$7();
        int x$10 = TestUtils$.MODULE$.createProducer$default$8();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        int x$12 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$2, x$3, x$16));
        this.producer().send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key1", (Object)"value1")).get();
        this.producer().send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key2", (Object)"value2")).get();
        this.producer().send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key3", (Object)"value3")).get();
        this.producer().close();
        FetchRequest req0 = (FetchRequest)new FetchRequest.Builder(0, 9, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data0 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req0).responseData().get(var3_3);
        Assertions.assertEquals((short)Errors.UNSUPPORTED_COMPRESSION_TYPE.code(), (short)data0.errorCode());
        FetchRequest req1 = (FetchRequest)new FetchRequest.Builder(0, 10, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data1 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req1).responseData().get(var3_3);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data1.errorCode());
        Assertions.assertEquals((int)3, (int)this.records(data1).size());
    }

    @Test
    public void testPartitionDataEquals() {
        Assertions.assertEquals((Object)new FetchRequest.PartitionData(300L, 0L, 300, Optional.of(Predef$.MODULE$.int2Integer(300))), (Object)new FetchRequest.PartitionData(300L, 0L, 300, Optional.of(Predef$.MODULE$.int2Integer(300))));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZStdCompressedRecords() {
        void var3_3;
        scala.collection.immutable.Map topicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CompressionTypeProp()), (Object)ProducerCompressionCodec$.MODULE$.name())}));
        Tuple2 tuple2 = (Tuple2)this.createTopics(1, 1, (scala.collection.immutable.Map<String, String>)topicConfig).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        int n = tuple2._2$mcI$sp();
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        String x$2 = GZIPCompressionCodec$.MODULE$.name();
        StringSerializer x$3 = new StringSerializer();
        StringSerializer x$4 = new StringSerializer();
        int x$5 = TestUtils$.MODULE$.createProducer$default$2();
        long x$6 = TestUtils$.MODULE$.createProducer$default$3();
        long x$7 = TestUtils$.MODULE$.createProducer$default$4();
        int x$8 = TestUtils$.MODULE$.createProducer$default$5();
        int x$9 = TestUtils$.MODULE$.createProducer$default$6();
        int x$10 = TestUtils$.MODULE$.createProducer$default$7();
        int x$11 = TestUtils$.MODULE$.createProducer$default$8();
        int x$12 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        KafkaProducer producer1 = TestUtils$.MODULE$.createProducer(x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$2, x$12, x$13, x$14, x$15, x$3, x$4, x$16);
        producer1.send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key1", (Object)"value1")).get();
        producer1.close();
        String x$17 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        String x$18 = ZStdCompressionCodec$.MODULE$.name();
        StringSerializer x$19 = new StringSerializer();
        StringSerializer x$20 = new StringSerializer();
        int x$21 = TestUtils$.MODULE$.createProducer$default$2();
        long x$22 = TestUtils$.MODULE$.createProducer$default$3();
        long x$23 = TestUtils$.MODULE$.createProducer$default$4();
        int x$24 = TestUtils$.MODULE$.createProducer$default$5();
        int x$25 = TestUtils$.MODULE$.createProducer$default$6();
        int x$26 = TestUtils$.MODULE$.createProducer$default$7();
        int x$27 = TestUtils$.MODULE$.createProducer$default$8();
        int x$28 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$29 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$30 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$31 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$32 = TestUtils$.MODULE$.createProducer$default$16();
        KafkaProducer producer2 = TestUtils$.MODULE$.createProducer(x$17, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$18, x$28, x$29, x$30, x$31, x$19, x$20, x$32);
        producer2.send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key2", (Object)"value2")).get();
        producer2.send(new ProducerRecord(var3_3.topic(), Predef$.MODULE$.int2Integer(var3_3.partition()), (Object)"key3", (Object)"value3")).get();
        producer2.close();
        FetchRequest req0 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data0 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req0).responseData().get(var3_3);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data0.errorCode());
        Assertions.assertEquals((int)1, (int)this.records(data0).size());
        FetchRequest req1 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)var3_3), (Object)BoxesRunTime.boxToLong((long)1L))}))))).setMaxBytes(800).build();
        FetchResponseData.PartitionData data1 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req1).responseData().get(var3_3);
        Assertions.assertEquals((short)Errors.UNSUPPORTED_COMPRESSION_TYPE.code(), (short)data1.errorCode());
        FetchRequest req2 = (FetchRequest)new FetchRequest.Builder(2, 3, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data2 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req2).responseData().get(var3_3);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data2.errorCode());
        Assertions.assertEquals((int)1, (int)this.records(data2).size());
        FetchRequest req3 = (FetchRequest)new FetchRequest.Builder(0, 1, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)var3_3), (Object)BoxesRunTime.boxToLong((long)1L))}))))).setMaxBytes(800).build();
        FetchResponseData.PartitionData data3 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req3).responseData().get(var3_3);
        Assertions.assertEquals((short)Errors.UNSUPPORTED_COMPRESSION_TYPE.code(), (short)data3.errorCode());
        FetchRequest req4 = (FetchRequest)new FetchRequest.Builder(0, 10, -1, Integer.MAX_VALUE, 0, this.createPartitionMap(300, (Seq<TopicPartition>)new .colon.colon((Object)var3_3, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).setMaxBytes(800).build();
        FetchResponseData.PartitionData data4 = (FetchResponseData.PartitionData)this.sendFetchRequest(n, req4).responseData().get(var3_3);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)data4.errorCode());
        Assertions.assertEquals((int)3, (int)this.records(data4).size());
    }

    private void checkFetchResponse(Seq<TopicPartition> expectedPartitions, FetchResponse fetchResponse, int maxPartitionBytes, int maxResponseBytes, int numMessagesPerPartition) {
        Assertions.assertEquals(expectedPartitions, (Object)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter(fetchResponse.responseData().keySet()).asScala()).toSeq());
        BooleanRef emptyResponseSeen = BooleanRef.create((boolean)false);
        IntRef responseSize = IntRef.create((int)0);
        IntRef responseBufferSize = IntRef.create((int)0);
        expectedPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            FetchRequestTest.$anonfun$checkFetchResponse$1(fetchResponse, responseBufferSize, numMessagesPerPartition, responseSize, emptyResponseSeen, maxPartitionBytes, tp);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)(maxResponseBytes - maxResponseBytes % maxPartitionBytes), (int)responseBufferSize.elem);
        Assertions.assertTrue((responseSize.elem <= maxResponseBytes ? 1 : 0) != 0);
    }

    private final FetchRequest createFetchRequest$1(Seq topicPartitions, scala.collection.immutable.Map offsetMap, int maxResponseBytes$1, int maxPartitionBytes$1) {
        return this.createFetchRequest(maxResponseBytes$1, maxPartitionBytes$1, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)offsetMap);
    }

    private static final scala.collection.immutable.Map createFetchRequest$default$2$1() {
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ int $anonfun$testBrokerRespectsPartitionsOrderAndSizeLimits$2(FetchRequestTest $this, FetchResponseData.PartitionData partitionData) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)$this.records(partitionData).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.sizeInBytes()), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRequestToNonReplica$1(int leader$1, KafkaServer x$7) {
        return x$7.config().brokerId() != leader$1;
    }

    private final void assertResponseErrorForEpoch$1(Errors error, int brokerId, Optional leaderEpoch, TopicPartition topicPartition$1) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition$1, new FetchRequest.PartitionData(0L, 0L, 1024, leaderEpoch));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, partitionMap).build();
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(brokerId, fetchRequest).responseData().get(topicPartition$1);
        Assertions.assertEquals((short)error.code(), (short)partitionData.errorCode());
    }

    public static final /* synthetic */ int $anonfun$testFetchRequestDuringPartitionRecoveryAfterUncleanLeaderElection$2(KafkaServer x$9) {
        return x$9.config().brokerId();
    }

    private final void createFetchRequestsAndValidateResponses$1(short ver, int brokerId, Errors consumerError, Errors replicaError, TopicPartition partition$1, int follower$1) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(partition$1, new FetchRequest.PartitionData(0L, 0L, 1024, Optional.of(Predef$.MODULE$.int2Integer(0))));
        FetchRequest consumerFetchRequest = FetchRequest.Builder.forConsumer((int)0, (int)0, partitionMap).build(ver);
        FetchResponseData.PartitionData consumerResponsePartitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(brokerId, consumerFetchRequest).responseData().get(partition$1);
        Assertions.assertEquals((short)consumerError.code(), (short)consumerResponsePartitionData.errorCode(), (String)new StringBuilder(68).append("Unexpected error in response to fetch request by consumer (version ").append(ver).append(")").toString());
        FetchRequest replicaFetchRequest = FetchRequest.Builder.forReplica((short)ver, (int)follower$1, (int)0, (int)1024, partitionMap).build(ver);
        FetchResponseData.PartitionData replicaResponsePartitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(brokerId, replicaFetchRequest).responseData().get(partition$1);
        Assertions.assertEquals((short)replicaError.code(), (short)replicaResponsePartitionData.errorCode(), (String)new StringBuilder(67).append("Unexpected error in response to fetch request by replica (version ").append(ver).append(")").toString());
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRequestDuringPartitionRecoveryAfterUncleanLeaderElection$4(int leader$2, KafkaServer x$11) {
        return x$11.config().brokerId() == leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRequestDuringPartitionRecoveryAfterUncleanLeaderElection$6(int leader$2, KafkaServer x$12) {
        return x$12.config().brokerId() == leader$2;
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRequestDuringPartitionRecoveryAfterUncleanLeaderElection$8(int leader$2, KafkaServer x$13) {
        return x$13.config().brokerId() == leader$2;
    }

    private final void assertResponseErrorForEpoch$2(Errors expectedError, int sessionFetchEpoch, Optional leaderEpoch, TopicPartition topicPartition$2, int sessionId$1, int destinationBrokerId$1) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.put(topicPartition$2, new FetchRequest.PartitionData(0L, 0L, 1024, leaderEpoch));
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, partitionMap).metadata(new FetchMetadata(sessionId$1, sessionFetchEpoch)).build();
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(destinationBrokerId$1, fetchRequest).responseData().get(topicPartition$2);
        Assertions.assertEquals((short)expectedError.code(), (short)partitionData.errorCode());
    }

    private final Option fetch$1(short version, int maxPartitionBytes, boolean closeAfterPartialResponse, TopicPartition topicPartition$3, int leaderId$2, int batchSize$1) {
        Some some;
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition$3, (List)Nil$.MODULE$), this.createPartitionMap$default$3())).build(version);
        try (Socket socket = this.connect(this.brokerSocketServer(leaderId$2), this.connect$default$2());){
            this.send((AbstractRequest)fetchRequest, socket, this.send$default$3(), this.send$default$4());
            if (closeAfterPartialResponse) {
                int size = new DataInputStream(socket.getInputStream()).readInt();
                Assertions.assertTrue((size > maxPartitionBytes - batchSize$1 ? 1 : 0) != 0, (String)new StringBuilder(56).append("Fetch size too small ").append(size).append(", broker may have run out of memory").toString());
                some = None$.MODULE$;
            } else {
                some = new Some(this.receive(socket, ApiKeys.FETCH, version, ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals())));
            }
        }
        return some;
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$1(FetchRequestTest $this, String topic$1, int i) {
        return $this.producer().send(new ProducerRecord(topic$1, (Object)new StringBuilder(4).append("key-").append(i).toString(), (Object)new StringBuilder(6).append("value-").append(i).toString()));
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionFromBatchedToUnbatchedRespectsOffset$2(FetchRequestTest $this, String topic$1, int i) {
        return $this.producer().send(new ProducerRecord(topic$1, (Object)new StringBuilder(4).append("key-").append(i).toString(), (Object)new StringBuilder(6).append("value-").append(i).toString()));
    }

    private final void check$1(long fetchOffset, short requestVersion, long expectedOffset, int expectedNumBatches, byte expectedMagic, TopicPartition topicPartition$4, int leaderId$3) {
        int batchesReceived;
        Buffer batches;
        long currentFetchOffset = fetchOffset;
        long currentExpectedOffset = expectedOffset;
        for (batchesReceived = 0; batchesReceived < expectedNumBatches; batchesReceived += batches.size()) {
            FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)new .colon.colon((Object)topicPartition$4, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition$4), (Object)BoxesRunTime.boxToLong((long)currentFetchOffset))}))))).build(requestVersion);
            FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)this.sendFetchRequest(leaderId$3, fetchRequest).responseData().get(topicPartition$4);
            Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
            Assertions.assertTrue((partitionData.highWatermark() > 0L ? 1 : 0) != 0);
            batches = ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData).batches()).asScala()).toBuffer();
            RecordBatch batch = (RecordBatch)batches.head();
            Assertions.assertEquals((byte)expectedMagic, (byte)batch.magic());
            Assertions.assertEquals((long)currentExpectedOffset, (long)batch.baseOffset());
            currentFetchOffset = ((RecordBatch)batches.last()).lastOffset() + 1L;
            currentExpectedOffset += ((RecordBatch)batches.last()).lastOffset() - ((RecordBatch)batches.head()).baseOffset() + 1L;
        }
        Assertions.assertEquals((int)expectedNumBatches, (int)batchesReceived);
    }

    private final FetchRequest createFetchRequest$2(Seq topicPartitions, FetchMetadata metadata, Seq toForget) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(Integer.MAX_VALUE, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty())).toForget((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(toForget).asJava()).metadata(metadata).build();
    }

    public static final /* synthetic */ void $anonfun$checkFetchResponse$1(FetchResponse fetchResponse$1, IntRef responseBufferSize$1, int numMessagesPerPartition$1, IntRef responseSize$1, BooleanRef emptyResponseSeen$1, int maxPartitionBytes$2, TopicPartition tp) {
        FetchResponseData.PartitionData partitionData = (FetchResponseData.PartitionData)fetchResponse$1.responseData().get(tp);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionData.errorCode());
        Assertions.assertTrue((partitionData.highWatermark() > 0L ? 1 : 0) != 0);
        Records records = FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData);
        responseBufferSize$1.elem += records.sizeInBytes();
        Buffer batches = ((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).toBuffer();
        Assertions.assertTrue((batches.size() < numMessagesPerPartition$1 ? 1 : 0) != 0);
        int batchesSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)batches.map((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToInteger((int)x$23.sizeInBytes()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        responseSize$1.elem += batchesSize;
        if (batchesSize == 0 && !emptyResponseSeen$1.elem) {
            Assertions.assertEquals((int)0, (int)records.sizeInBytes());
            emptyResponseSeen$1.elem = true;
            return;
        }
        if (batchesSize != 0 && !emptyResponseSeen$1.elem) {
            Assertions.assertTrue((batchesSize <= maxPartitionBytes$2 ? 1 : 0) != 0);
            Assertions.assertEquals((int)maxPartitionBytes$2, (int)records.sizeInBytes());
            return;
        }
        if (batchesSize != 0 && emptyResponseSeen$1.elem) {
            Assertions.fail((String)new StringBuilder(53).append("Expected partition with size 0, but found ").append(tp).append(" with size ").append(batchesSize).toString());
            return;
        }
        if (records.sizeInBytes() != 0 && emptyResponseSeen$1.elem) {
            Assertions.fail((String)new StringBuilder(60).append("Expected partition buffer with size 0, but found ").append(tp).append(" with size ").append(records.sizeInBytes()).toString());
        }
    }

    public static final /* synthetic */ Future $anonfun$testDownConversionWithConnectionFailure$1$adapted(KafkaProducer producer$1, TopicPartition topicPartition$3, byte[] bytes$1, Object x$15) {
        return producer$1.send(new ProducerRecord(topicPartition$3.topic(), Predef$.MODULE$.int2Integer(topicPartition$3.partition()), (Object)"key", (Object)bytes$1));
    }

    public static final /* synthetic */ Option $anonfun$testDownConversionWithConnectionFailure$3$adapted(FetchRequestTest $this, short version$1, int msgValueLen$1, TopicPartition topicPartition$3, int leaderId$2, int batchSize$1, Object x$17) {
        return $this.fetch$1(version$1, msgValueLen$1 * 1000, true, topicPartition$3, leaderId$2, batchSize$1);
    }
}

