/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Optional;
import kafka.cluster.PartitionListener;
import kafka.server.FetchContext;
import kafka.server.FetchManager;
import kafka.server.FetchSession;
import kafka.server.FetchSessionCache;
import kafka.server.FullFetchContext;
import kafka.server.IncrementalFetchContext;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.server.PartitionFetchMetadata;
import kafka.server.ReplicaManager;
import kafka.server.SessionErrorContext;
import kafka.server.SessionlessFetchContext;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Builder;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0001\t=c\u0001\u0002\u0016,\u0001ABQa\u000e\u0001\u0005\u0002aBQa\u000f\u0001\u0005\u0002qBQ!\u0014\u0001\u0005\u00029CQ\u0001\u0018\u0001\u0005\nuCQa\u001a\u0001\u0005\u0002qBQ!\u001b\u0001\u0005\u0002qBQa\u001b\u0001\u0005\u0002qBQ!\u001c\u0001\u0005\u0002qBQa\u001c\u0001\u0005\u0002qBQ!\u001d\u0001\u0005\u0002qBQa\u001d\u0001\u0005\u0002qBQ!\u001e\u0001\u0005\u0002qBQa\u001e\u0001\u0005\naDa!a\u0006\u0001\t\u0003a\u0004BBA\u000e\u0001\u0011\u0005A\b\u0003\u0004\u0002 \u0001!\t\u0001\u0010\u0005\u0007\u0003G\u0001A\u0011\u0001\u001f\t\r\u0005\u001d\u0002\u0001\"\u0001=\u0011\u0019\tY\u0003\u0001C\u0001y!1\u0011q\u0006\u0001\u0005\u0002qBq!a\r\u0001\t\u0013\t)\u0004\u0003\u0004\u0002^\u0001!\t\u0001\u0010\u0005\u0007\u0003C\u0002A\u0011\u0001\u001f\t\u000f\u0005\u0015\u0004\u0001\"\u0003\u0002h!I\u0011Q\u0015\u0001\u0012\u0002\u0013%\u0011q\u0015\u0005\n\u0003{\u0003\u0011\u0013!C\u0005\u0003OC\u0011\"a0\u0001#\u0003%I!!1\t\u0013\u0005\u0015\u0007!%A\u0005\n\u0005\u001d\u0007bBAf\u0001\u0011%\u0011Q\u001a\u0005\n\u0003[\u0004\u0011\u0013!C\u0005\u0003_D\u0011\"a=\u0001#\u0003%I!a*\t\u0013\u0005U\b!%A\u0005\n\u0005\u001d\u0006\"CA|\u0001E\u0005I\u0011BAT\u0011\u001d\tI\u0010\u0001C\u0005\u0003wDqAa\u0007\u0001\t\u0013\u0011i\u0002C\u0005\u0003.\u0001\t\n\u0011\"\u0003\u0002p\"I!q\u0006\u0001\u0012\u0002\u0013%\u0011q\u0015\u0005\n\u0005c\u0001\u0011\u0013!C\u0005\u0003OC\u0011Ba\r\u0001#\u0003%I!a*\t\u000f\tU\u0002\u0001\"\u0003\u00038!9!Q\u0007\u0001\u0005\n\tm\"\u0001\u0005$fi\u000eD7+Z:tS>tG+Z:u\u0015\taS&\u0001\u0004tKJ4XM\u001d\u0006\u0002]\u0005)1.\u00194lC\u000e\u00011C\u0001\u00012!\t\u0011T'D\u00014\u0015\u0005!\u0014!B:dC2\f\u0017B\u0001\u001c4\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u000f\t\u0003u\u0001i\u0011aK\u0001\u0011i\u0016\u001cHOT3x'\u0016\u001c8/[8o\u0013\u0012$\u0012!\u0010\t\u0003eyJ!aP\u001a\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\u0005\u0003\"AQ&\u000e\u0003\rS!\u0001R#\u0002\u0007\u0005\u0004\u0018N\u0003\u0002G\u000f\u00069!.\u001e9ji\u0016\u0014(B\u0001%J\u0003\u0015QWO\\5u\u0015\u0005Q\u0015aA8sO&\u0011Aj\u0011\u0002\u0005)\u0016\u001cH/A\nbgN,'\u000f^\"bG\",7i\u001c8uC&t7\u000fF\u0002>\u001fRCQ\u0001U\u0002A\u0002E\u000bQaY1dQ\u0016\u0004\"A\u000f*\n\u0005M[#!\u0005$fi\u000eD7+Z:tS>t7)Y2iK\")Qk\u0001a\u0001-\u0006Q1/Z:tS>t\u0017\nZ:\u0011\u0007I:\u0016,\u0003\u0002Yg\tQAH]3qK\u0006$X\r\u001a \u0011\u0005IR\u0016BA.4\u0005\rIe\u000e^\u0001\fIVlW._\"sK\u0006$X\r\u0006\u0002_KB\u0011qL\u0019\b\u0003u\u0001L!!Y\u0016\u0002\u0019\u0019+Go\u00195TKN\u001c\u0018n\u001c8\n\u0005\r$'!C\"B\u0007\"+u,T!Q\u0015\t\t7\u0006C\u0003g\t\u0001\u0007\u0011,\u0001\u0003tSj,\u0017\u0001\u0005;fgR\u001cVm]:j_:\u001c\u0015m\u00195fQ\t)\u0011)A\u0014uKN$8+Z:tS>t7)Y2iK\u000ecwn]3TKN\u001c\u0018n\u001c8XQ\u0016t'+Z7pm\u0016$\u0007F\u0001\u0004B\u0003u!Xm\u001d;TKN\u001c\u0018n\u001c8DC\u000eDW-\u0012<jGRLwN\u001c*vY\u0016\u001c\bFA\u0004B\u0003m!Xm\u001d;TC6,7+\u001b>f'\u0016\u001c8/[8o\u000bZL7\r^5p]\"\u0012\u0001\"Q\u0001 i\u0016\u001cH/Q2uSZ,7+Z:tS>tWI^5di&|gn]'fi\u0016\u0014\bFA\u0005B\u0003a!Xm\u001d;SKNL'0Z\"bG\",GmU3tg&|gn\u001d\u0015\u0003\u0015\u0005\u000bQ\u0003^3ti\u000e\u000b7\r[3e\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u000b\u0002\f\u0003\u0006!B/Z:u\u0019\u0006\u001cHOR3uG\",G-\u00129pG\"D#\u0001D!\u00023\u0005\u001c8/\u001a:u!\u0006\u0014H/\u001b;j_:\u001c\u0018J\\\"p]R,\u0007\u0010\u001e\u000b\u0005{e\fi\u0001C\u0003{\u001b\u0001\u000710\u0001\u000bfqB,7\r^3e\r\u0016$8\r\u001b*fcV,7\u000f\u001e\t\u0004y\u0006%Q\"A?\u000b\u0005y|\u0018aB7fgN\fw-\u001a\u0006\u0005\u0003\u0003\t\u0019!\u0001\u0004d_6lwN\u001c\u0006\u0004]\u0005\u0015!bAA\u0004\u0013\u00061\u0011\r]1dQ\u0016L1!a\u0003~\u0005A1U\r^2i%\u0016\fX/Z:u\t\u0006$\u0018\rC\u0004\u0002\u00105\u0001\r!!\u0005\u0002\u000f\r|g\u000e^3yiB\u0019!(a\u0005\n\u0007\u0005U1F\u0001\u0007GKR\u001c\u0007nQ8oi\u0016DH/A\tuKN$h)\u001a;dQJ+\u0017/^3tiND#AD!\u00027Q,7\u000f^%oGJ,W.\u001a8uC24U\r^2i'\u0016\u001c8/[8oQ\ty\u0011)\u0001\u000euKN$h)\u001a;dQN+7o]5p]\u0016C\b/\u001b:bi&|g\u000e\u000b\u0002\u0011\u0003\u0006iB/Z:u!JLg/\u001b7fO\u0016$7+Z:tS>t\u0007*\u00198eY&tw\r\u000b\u0002\u0012\u0003\u0006AB/Z:u5\u0016\u0014xnU5{K\u001a+Go\u00195TKN\u001c\u0018n\u001c8)\u0005I\t\u0015A\u0005;fgR$\u0015N^3sO&tw-\u00129pG\"D#aE!\u0002UQ,7\u000f\u001e#faJLwN]5uSj,7\u000fU1si&$\u0018n\u001c8t/&$\bNU3d_J$7o\u00148ms\"\u0012A#Q\u0001\u0016CN\u001cXM\u001d;QCJ$\u0018\u000e^5p]N|%\u000fZ3s)\u0015i\u0014qGA\u001d\u0011\u001d\ty!\u0006a\u0001\u0003#Aq!a\u000f\u0016\u0001\u0004\ti$\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004b!a\u0010\u0002P\u0005Uc\u0002BA!\u0003\u0017rA!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000fz\u0013A\u0002\u001fs_>$h(C\u00015\u0013\r\tieM\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t&a\u0015\u0003\u0007M+\u0017OC\u0002\u0002NM\u0002B!a\u0016\u0002Z5\tq0C\u0002\u0002\\}\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\tuKN$8+Z:tS>tW\u000b\u001d3bi\u0016D#AF!\u0002!Q,7\u000f^*fgNLwN\\\"m_N,\u0007FA\fB\u0003Ai\u0017m[3GKR\u001c\u0007NU3rk\u0016\u001cH\u000fF\u0005|\u0003S\ni'!\u001d\u0002\u001a\"A\u00111\u000e\r\u0011\u0002\u0003\u0007\u0011,A\u0005tKN\u001c\u0018n\u001c8JI\"A\u0011q\u000e\r\u0011\u0002\u0003\u0007\u0011,\u0001\u0007tKN\u001c\u0018n\u001c8Fa>\u001c\u0007\u000eC\u0005\u0002ta\u0001\n\u00111\u0001\u0002v\u00051Ao\u001c9jGN\u0004b!a\u0010\u0002P\u0005]\u0004\u0003BA=\u0003'sA!a\u001f\u0002\u0010:!\u0011QPAG\u001d\u0011\ty(a#\u000f\t\u0005\u0005\u0015\u0011\u0012\b\u0005\u0003\u0007\u000b9I\u0004\u0003\u0002D\u0005\u0015\u0015\"\u0001&\n\u0007\u0005\u001d\u0011*C\u0002/\u0003\u000bIA!!\u0001\u0002\u0004%\u0011ap`\u0005\u0004\u0003#k\u0018\u0001\u0005$fi\u000eD'+Z9vKN$H)\u0019;b\u0013\u0011\t)*a&\u0003\u0015\u0019+Go\u00195U_BL7MC\u0002\u0002\u0012vD\u0011\"a'\u0019!\u0003\u0005\r!!(\u0002\u001f\u0019|'oZ8ui\u0016tGk\u001c9jGN\u0004b!a\u0010\u0002P\u0005}\u0005\u0003BA=\u0003CKA!a)\u0002\u0018\nqai\u001c:h_R$XM\u001c+pa&\u001c\u0017AG7bW\u00164U\r^2i%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\nTCAAUU\rI\u00161V\u0016\u0003\u0003[\u0003B!a,\u0002:6\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000b),A\u0005v]\u000eDWmY6fI*\u0019\u0011qW\u001a\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002<\u0006E&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006QR.Y6f\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%e\u0005QR.Y6f\r\u0016$8\r\u001b*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0019\u0016\u0005\u0003k\nY+\u0001\u000enC.,g)\u001a;dQJ+\u0017/^3ti\u0012\"WMZ1vYR$C'\u0006\u0002\u0002J*\"\u0011QTAV\u0003]i\u0017m[3GKR\u001c\u0007\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0006\b\u0002x\u0005=\u00171[Ao\u0003C\f)/!;\t\u000f\u0005EW\u00041\u0001\u0002V\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAk;\u0001\u0007\u0011q[\u0001\fM\u0016$8\r[(gMN,G\u000fE\u00023\u00033L1!a74\u0005\u0011auN\\4\t\u0013\u0005}W\u0004%AA\u0002\u0005]\u0017A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0005\t\u0003Gl\u0002\u0013!a\u00013\u0006AQ.\u0019=CsR,7\u000f\u0003\u0005\u0002hv\u0001\n\u00111\u0001Z\u0003I\u0019WO\u001d:f]RdU-\u00193fe\u0016\u0003xn\u00195\t\u0011\u0005-X\u0004%AA\u0002e\u000b\u0001\u0003\\1ti\u001a+Go\u00195fI\u0016\u0003xn\u00195\u0002C5\f7.\u001a$fi\u000eDGk\u001c9jGB\u000b'\u000f^5uS>tG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005E(\u0006BAl\u0003W\u000b\u0011%\\1lK\u001a+Go\u00195U_BL7\rU1si&$\u0018n\u001c8%I\u00164\u0017-\u001e7uIQ\n\u0011%\\1lK\u001a+Go\u00195U_BL7\rU1si&$\u0018n\u001c8%I\u00164\u0017-\u001e7uIU\n\u0011%\\1lK\u001a+Go\u00195U_BL7\rU1si&$\u0018n\u001c8%I\u00164\u0017-\u001e7uIY\na\"\\1lK\u001a+Go\u00195U_BL7\r\u0006\u0004\u0002x\u0005u(\u0011\u0003\u0005\b\u0003\u007f\u0014\u0003\u0019\u0001B\u0001\u0003\u0015!x\u000e]5d!\u0011\u0011\u0019Aa\u0003\u000f\t\t\u0015!q\u0001\t\u0004\u0003\u0007\u001a\u0014b\u0001B\u0005g\u00051\u0001K]3eK\u001aLAA!\u0004\u0003\u0010\t11\u000b\u001e:j]\u001eT1A!\u00034\u0011\u001d\tYD\ta\u0001\u0005'\u0001b!a\u0010\u0002P\tU\u0001\u0003BA=\u0005/IAA!\u0007\u0002\u0018\nqa)\u001a;dQB\u000b'\u000f^5uS>t\u0017AE7bW\u00164U\r^2i!\u0006\u0014H/\u001b;j_:$bB!\u0006\u0003 \t\r\"Q\u0005B\u0014\u0005S\u0011Y\u0003\u0003\u0004\u0003\"\r\u0002\r!W\u0001\na\u0006\u0014H/\u001b;j_:Dq!!6$\u0001\u0004\t9\u000eC\u0005\u0002`\u000e\u0002\n\u00111\u0001\u0002X\"A\u00111]\u0012\u0011\u0002\u0003\u0007\u0011\f\u0003\u0005\u0002h\u000e\u0002\n\u00111\u0001Z\u0011!\tYo\tI\u0001\u0002\u0004I\u0016\u0001H7bW\u00164U\r^2i!\u0006\u0014H/\u001b;j_:$C-\u001a4bk2$HeM\u0001\u001d[\u0006\\WMR3uG\"\u0004\u0016M\u001d;ji&|g\u000e\n3fM\u0006,H\u000e\u001e\u00135\u0003qi\u0017m[3GKR\u001c\u0007\u000eU1si&$\u0018n\u001c8%I\u00164\u0017-\u001e7uIU\nA$\\1lK\u001a+Go\u00195QCJ$\u0018\u000e^5p]\u0012\"WMZ1vYR$c'\u0001\nnC.,gi\u001c:h_R$XM\u001c+pa&\u001cG\u0003BAP\u0005sAq!!5)\u0001\u0004\t)\u0006\u0006\u0004\u0002 \nu\"q\b\u0005\b\u0003\u007fL\u0003\u0019\u0001B\u0001\u0011\u001d\tY$\u000ba\u0001\u0005\u0003\u0002R!a\u0010\u0002PeCs\u0001\u0001B#\u0005\u0017\u0012i\u0005E\u0002C\u0005\u000fJ1A!\u0013D\u0005\u001d!\u0016.\\3pkR\fQA^1mk\u0016t\u0012\u0001\u001f")
public class FetchSessionTest {
    @Test
    public void testNewSessionId() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 10000).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> Assertions.assertTrue((cache.newSessionId() > 0 ? 1 : 0) != 0));
    }

    public void assertCacheContains(FetchSessionCache cache, Seq<Object> sessionIds) {
        IntRef i = IntRef.create((int)0);
        sessionIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)sessionId -> {
            ++i$1.elem;
            Assertions.assertTrue((boolean)cache.get(sessionId).isDefined(), (String)new StringBuilder(26).append("Missing session ").append(i$1.elem).append(" out of ").append(sessionIds.size()).append("(").append(sessionId).append(")").toString());
        });
        Assertions.assertEquals((int)sessionIds.size(), (int)cache.size());
    }

    /*
     * WARNING - void declaration
     */
    private ImplicitLinkedHashCollection<IncrementalPartitionFetchMetadata> dummyCreate(int size) {
        void var2_2;
        ImplicitLinkedHashCollection cacheMap = new ImplicitLinkedHashCollection(size);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> cacheMap.add((ImplicitLinkedHashCollection.Element)new IncrementalPartitionFetchMetadata("test", i)));
        return var2_2;
    }

    @Test
    public void testSessionCache() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        Assertions.assertEquals((int)0, (int)cache.size());
        int id1 = cache.maybeCreateSession(0L, false, 10, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10));
        int id2 = cache.maybeCreateSession(10L, false, 20, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(20));
        int id3 = cache.maybeCreateSession(20L, false, 30, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(30));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(30L, false, 40, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(40)));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(40L, false, 5, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5)));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id2, id3}));
        cache.touch((FetchSession)cache.get(id1).get(), 200L);
        int id4 = cache.maybeCreateSession(210L, false, 11, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(11));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id3, id4}));
        cache.touch((FetchSession)cache.get(id1).get(), 400L);
        cache.touch((FetchSession)cache.get(id3).get(), 390L);
        cache.touch((FetchSession)cache.get(id4).get(), 400L);
        int id5 = cache.maybeCreateSession(410L, false, 50, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(50));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id3, id4, id5}));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(410L, false, 5, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5)));
        int id6 = cache.maybeCreateSession(410L, true, 5, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id3, id5, id6}));
    }

    @Test
    public void testSessionCacheCloseSessionWhenRemoved() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        ImplicitLinkedHashCollection cacheMap = new ImplicitLinkedHashCollection();
        IncrementalPartitionFetchMetadata partition1 = (IncrementalPartitionFetchMetadata)Mockito.spy((Object)new IncrementalPartitionFetchMetadata("foo", 0));
        cacheMap.add((ImplicitLinkedHashCollection.Element)partition1);
        IncrementalPartitionFetchMetadata partition2 = (IncrementalPartitionFetchMetadata)Mockito.spy((Object)new IncrementalPartitionFetchMetadata("bar", 0));
        cacheMap.add((ImplicitLinkedHashCollection.Element)partition2);
        int sessionId = cache.maybeCreateSession(0L, false, 10, (Function0 & Serializable & scala.Serializable)() -> cacheMap);
        Assertions.assertTrue((boolean)cache.get(sessionId).isDefined());
        Assertions.assertTrue((boolean)cache.remove(sessionId).isDefined());
        ((IncrementalPartitionFetchMetadata)Mockito.verify((Object)partition1)).close();
        ((IncrementalPartitionFetchMetadata)Mockito.verify((Object)partition2)).close();
    }

    @Test
    public void testSessionCacheEvictionRules() {
        FetchSessionCache cache = new FetchSessionCache(3, 100L);
        int id1 = cache.maybeCreateSession(0L, false, 20, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(20));
        int id2 = cache.maybeCreateSession(0L, false, 10, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10));
        int id3 = cache.maybeCreateSession(0L, false, 30, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(30));
        cache.touch((FetchSession)cache.get(id1).get(), 101L);
        cache.touch((FetchSession)cache.get(id2).get(), 101L);
        cache.touch((FetchSession)cache.get(id3).get(), 101L);
        int id4 = cache.maybeCreateSession(102L, false, 31, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(31));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id3, id4}));
        cache.touch((FetchSession)cache.get(id1).get(), 102L);
        cache.touch((FetchSession)cache.get(id3).get(), 102L);
        int id5 = cache.maybeCreateSession(203L, false, 9, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(9));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id3, id5}));
        int id6 = cache.maybeCreateSession(204L, true, 10, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id3, id5, id6}));
        int id7 = cache.maybeCreateSession(204L, true, 20, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(20));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id5, id6, id7}));
        int id8 = cache.maybeCreateSession(204L, true, 30, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(30));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id6, id7, id8}));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(40L, false, 40, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(40)));
        cache.touch((FetchSession)cache.get(id6).get(), 205L);
        cache.touch((FetchSession)cache.get(id8).get(), 305L);
        int id9 = cache.maybeCreateSession(305L, false, 5, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id6, id8, id9}));
        cache.touch((FetchSession)cache.get(id6).get(), 305L);
        int id10 = cache.maybeCreateSession(305L, true, 5, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id6, id8, id10}));
        Assertions.assertEquals((int)0, (int)cache.maybeCreateSession(306L, true, 6, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(6)));
        cache.touch((FetchSession)cache.get(id6).get(), 406L);
        cache.touch((FetchSession)cache.get(id8).get(), 406L);
        cache.touch((FetchSession)cache.get(id10).get(), 406L);
        int id11 = cache.maybeCreateSession(407L, true, 40, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(40));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id6, id8, id11}));
        cache.touch((FetchSession)cache.get(id6).get(), 407L);
        int id12 = cache.maybeCreateSession(508L, true, 50, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(50));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id6, id11, id12}));
    }

    @Test
    public void testSameSizeSessionEviction() {
        FetchSessionCache privilegedCache = new FetchSessionCache(2, 100L);
        int id1 = privilegedCache.maybeCreateSession(0L, true, 10, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10));
        int id2 = privilegedCache.maybeCreateSession(0L, true, 20, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(20));
        FetchSessionCache unprivilegedCache = new FetchSessionCache(2, 100L);
        int id3 = unprivilegedCache.maybeCreateSession(0L, false, 10, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10));
        int id4 = unprivilegedCache.maybeCreateSession(0L, false, 20, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(20));
        Assertions.assertEquals((int)0, (int)privilegedCache.maybeCreateSession(99L, true, 10, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10)));
        Assertions.assertEquals((int)0, (int)unprivilegedCache.maybeCreateSession(99L, false, 10, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10)));
        privilegedCache.touch((FetchSession)privilegedCache.get(id1).get(), 101L);
        privilegedCache.touch((FetchSession)privilegedCache.get(id2).get(), 101L);
        Assertions.assertEquals((int)0, (int)privilegedCache.maybeCreateSession(102L, true, 10, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10)));
        unprivilegedCache.touch((FetchSession)unprivilegedCache.get(id3).get(), 101L);
        unprivilegedCache.touch((FetchSession)unprivilegedCache.get(id4).get(), 101L);
        Assertions.assertEquals((int)0, (int)unprivilegedCache.maybeCreateSession(102L, false, 10, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10)));
        FetchSessionCache privilegedCache2 = new FetchSessionCache(2, 100L);
        int id5 = privilegedCache2.maybeCreateSession(0L, true, 10, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10));
        int id6 = privilegedCache2.maybeCreateSession(0L, true, 20, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(20));
        FetchSessionCache unprivilegedCache2 = new FetchSessionCache(2, 100L);
        int id7 = unprivilegedCache2.maybeCreateSession(0L, false, 10, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10));
        int id8 = unprivilegedCache2.maybeCreateSession(0L, false, 20, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(20));
        privilegedCache2.touch((FetchSession)privilegedCache2.get(id5).get(), 98L);
        privilegedCache2.touch((FetchSession)privilegedCache2.get(id6).get(), 98L);
        Assertions.assertEquals((int)0, (int)privilegedCache2.maybeCreateSession(99L, true, 10, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10)));
        Assertions.assertEquals((int)0, (int)privilegedCache2.maybeCreateSession(101L, true, 10, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10)));
        unprivilegedCache2.touch((FetchSession)unprivilegedCache2.get(id7).get(), 98L);
        unprivilegedCache2.touch((FetchSession)unprivilegedCache2.get(id8).get(), 98L);
        Assertions.assertEquals((int)0, (int)unprivilegedCache2.maybeCreateSession(99L, false, 10, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10)));
        Assertions.assertEquals((int)0, (int)unprivilegedCache2.maybeCreateSession(101L, false, 10, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(10)));
    }

    @Test
    public void testActiveSessionEvictionsMeter() {
        FetchSessionCache cache = new FetchSessionCache(2, 100L);
        Assertions.assertEquals((long)0L, (long)cache.activeSessionEvictionsMeter().count());
        int id1 = cache.maybeCreateSession(0L, false, 2, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(2));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1}));
        FetchSession session1 = (FetchSession)cache.get(id1).get();
        Assertions.assertEquals((long)0L, (long)cache.activeSessionEvictionsMeter().count());
        int id2 = cache.maybeCreateSession(0L, false, 4, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(4));
        FetchSession session2 = (FetchSession)cache.get(id2).get();
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id2}));
        Assertions.assertEquals((long)0L, (long)cache.activeSessionEvictionsMeter().count());
        cache.touch(session1, 200L);
        cache.touch(session2, 200L);
        int id3 = cache.maybeCreateSession(301L, false, 2, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(2));
        FetchSession session3 = (FetchSession)cache.get(id3).get();
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id2, id3}));
        Assertions.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        Assertions.assertEquals((long)0L, (long)cache.activeSessionEvictionsMeter().count());
        cache.touch(session2, 402L);
        cache.touch(session3, 402L);
        int id4 = cache.maybeCreateSession(402L, false, 5, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5));
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id2, id4}));
        Assertions.assertEquals((long)2L, (long)cache.evictionsMeter().count());
        Assertions.assertEquals((long)1L, (long)cache.activeSessionEvictionsMeter().count());
    }

    @Test
    public void testResizeCachedSessions() {
        FetchSessionCache cache = new FetchSessionCache(2, 100L);
        Assertions.assertEquals((long)0L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)0, (int)cache.size());
        Assertions.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        int id1 = cache.maybeCreateSession(0L, false, 2, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(2));
        Assertions.assertTrue((id1 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1}));
        FetchSession session1 = (FetchSession)cache.get(id1).get();
        Assertions.assertEquals((int)2, (int)session1.size());
        Assertions.assertEquals((long)2L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)1, (int)cache.size());
        Assertions.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        int id2 = cache.maybeCreateSession(0L, false, 4, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(4));
        FetchSession session2 = (FetchSession)cache.get(id2).get();
        Assertions.assertTrue((id2 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id1, id2}));
        Assertions.assertEquals((long)6L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)2, (int)cache.size());
        Assertions.assertEquals((long)0L, (long)cache.evictionsMeter().count());
        cache.touch(session1, 200L);
        cache.touch(session2, 200L);
        int id3 = cache.maybeCreateSession(200L, false, 5, (Function0 & Serializable & scala.Serializable)() -> this.dummyCreate(5));
        Assertions.assertTrue((id3 > 0 ? 1 : 0) != 0);
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id2, id3}));
        Assertions.assertEquals((long)9L, (long)cache.totalPartitions());
        Assertions.assertEquals((int)2, (int)cache.size());
        Assertions.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        cache.remove(id3);
        this.assertCacheContains(cache, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{id2}));
        Assertions.assertEquals((int)1, (int)cache.size());
        Assertions.assertEquals((long)1L, (long)cache.evictionsMeter().count());
        Assertions.assertEquals((long)4L, (long)cache.totalPartitions());
        java.util.Iterator iter = session2.partitionMap().iterator();
        iter.next();
        iter.remove();
        Assertions.assertEquals((int)3, (int)session2.size());
        Assertions.assertEquals((int)4, (int)session2.cachedSize());
        cache.touch(session2, session2.lastUsedMs());
        Assertions.assertEquals((long)3L, (long)cache.totalPartitions());
    }

    @Test
    public void testCachedLeaderEpoch() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        TopicPartition bar1 = new TopicPartition("bar", 1);
        int x$1 = foo1.partition();
        long x$2 = 10L;
        int x$3 = 1;
        long x$4 = this.makeFetchPartition$default$3();
        int x$5 = this.makeFetchPartition$default$4();
        int x$6 = this.makeFetchPartition$default$6();
        int x$7 = bar1.partition();
        long x$8 = 10L;
        int x$9 = 2;
        long x$10 = this.makeFetchPartition$default$3();
        int x$11 = this.makeFetchPartition$default$4();
        int x$12 = this.makeFetchPartition$default$6();
        .colon.colon x$13 = new .colon.colon((Object)this.makeFetchTopic(foo0.topic(), (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(foo0.partition(), 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(x$1, x$2, x$4, x$5, x$3, x$6), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)this.makeFetchTopic(bar1.topic(), (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(x$7, x$8, x$10, x$11, x$9, x$12), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        int x$14 = this.makeFetchRequest$default$1();
        int x$15 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$16 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest1 = this.makeFetchRequest(x$14, x$15, (Seq<FetchRequestData.FetchTopic>)x$13, x$16);
        FetchContext context1 = fetchManager.newContext(fetchRequest1, false);
        Map epochs1 = FetchSessionTest.cachedLeaderEpochs$1(context1);
        Assertions.assertEquals(Optional.empty(), (Object)epochs1.apply((Object)foo0));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), (Object)epochs1.apply((Object)foo1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)2)), (Object)epochs1.apply((Object)bar1));
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> response = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        response.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(foo0.partition()).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        response.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(foo1.partition()).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        response.put(bar1, new FetchResponseData.PartitionData().setPartitionIndex(bar1.partition()).setHighWatermark(5L).setLastStableOffset(5L).setLogStartOffset(5L));
        int sessionId = context1.updateAndGenerateResponseData(response).sessionId();
        FetchRequestData fetchRequest2 = this.makeFetchRequest(sessionId, 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4());
        FetchContext context2 = fetchManager.newContext(fetchRequest2, false);
        Map epochs2 = FetchSessionTest.cachedLeaderEpochs$1(context2);
        Assertions.assertEquals(Optional.empty(), (Object)epochs2.apply((Object)foo0));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), (Object)epochs2.apply((Object)foo1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)2)), (Object)epochs2.apply((Object)bar1));
        context2.updateAndGenerateResponseData(response).sessionId();
        int x$17 = foo0.partition();
        long x$18 = 0L;
        int x$19 = 6;
        long x$20 = this.makeFetchPartition$default$3();
        int x$21 = this.makeFetchPartition$default$4();
        int x$22 = this.makeFetchPartition$default$6();
        int x$23 = bar1.partition();
        long x$24 = 10L;
        int x$25 = 3;
        long x$26 = this.makeFetchPartition$default$3();
        int x$27 = this.makeFetchPartition$default$4();
        int x$28 = this.makeFetchPartition$default$6();
        FetchRequestData fetchRequest3 = this.makeFetchRequest(sessionId, 2, (Seq<FetchRequestData.FetchTopic>)new .colon.colon((Object)this.makeFetchTopic(foo0.topic(), (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(x$17, x$18, x$20, x$21, x$19, x$22), (List)new .colon.colon((Object)this.makeFetchPartition(foo1.partition(), 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)this.makeFetchTopic(bar1.topic(), (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(x$23, x$24, x$26, x$27, x$25, x$28), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)), this.makeFetchRequest$default$4());
        Map epochs3 = FetchSessionTest.cachedLeaderEpochs$1(fetchManager.newContext(fetchRequest3, false));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)6)), (Object)epochs3.apply((Object)foo0));
        Assertions.assertEquals(Optional.empty(), (Object)epochs3.apply((Object)foo1));
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)3)), (Object)epochs3.apply((Object)bar1));
    }

    @Test
    public void testLastFetchedEpoch() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        TopicPartition bar1 = new TopicPartition("bar", 1);
        int x$1 = foo1.partition();
        long x$2 = 10L;
        int x$3 = 1;
        long x$4 = this.makeFetchPartition$default$3();
        int x$5 = this.makeFetchPartition$default$4();
        int x$6 = this.makeFetchPartition$default$6();
        int x$7 = bar1.partition();
        long x$8 = 10L;
        int x$9 = 2;
        int x$10 = 1;
        long x$11 = this.makeFetchPartition$default$3();
        int x$12 = this.makeFetchPartition$default$4();
        .colon.colon x$13 = new .colon.colon((Object)this.makeFetchTopic(foo0.topic(), (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(foo0.partition(), 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(x$1, x$2, x$4, x$5, x$3, x$6), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)this.makeFetchTopic(bar1.topic(), (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(x$7, x$8, x$11, x$12, x$9, x$10), (List)Nil$.MODULE$)), (List)Nil$.MODULE$));
        int x$14 = this.makeFetchRequest$default$1();
        int x$15 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$16 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest1 = this.makeFetchRequest(x$14, x$15, (Seq<FetchRequestData.FetchTopic>)x$13, x$16);
        FetchContext context1 = fetchManager.newContext(fetchRequest1, false);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), Optional.of(BoxesRunTime.boxToInteger((int)1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), Optional.of(BoxesRunTime.boxToInteger((int)2)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context1));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), Optional.of(BoxesRunTime.boxToInteger((int)1)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context1));
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> response = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        response.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(foo0.partition()).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        response.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(foo1.partition()).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        response.put(bar1, new FetchResponseData.PartitionData().setPartitionIndex(bar1.partition()).setHighWatermark(5L).setLastStableOffset(5L).setLogStartOffset(5L));
        int sessionId = context1.updateAndGenerateResponseData(response).sessionId();
        FetchRequestData fetchRequest2 = this.makeFetchRequest(sessionId, 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4());
        FetchContext context2 = fetchManager.newContext(fetchRequest2, false);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), Optional.of(BoxesRunTime.boxToInteger((int)1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), Optional.of(BoxesRunTime.boxToInteger((int)2)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), Optional.of(BoxesRunTime.boxToInteger((int)1)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context2));
        context2.updateAndGenerateResponseData(response).sessionId();
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> request3 = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        request3.put(foo0, new FetchRequest.PartitionData(0L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(6)), Optional.of(Predef$.MODULE$.int2Integer(5))));
        request3.put(foo1, new FetchRequest.PartitionData(10L, 0L, 100, Optional.empty(), Optional.empty()));
        request3.put(bar1, new FetchRequest.PartitionData(10L, 0L, 100, Optional.of(Predef$.MODULE$.int2Integer(3)), Optional.of(Predef$.MODULE$.int2Integer(3))));
        int x$17 = foo0.partition();
        long x$18 = 0L;
        int x$19 = 6;
        int x$20 = 5;
        long x$21 = this.makeFetchPartition$default$3();
        int x$22 = this.makeFetchPartition$default$4();
        int x$23 = bar1.partition();
        long x$24 = 10L;
        int x$25 = 3;
        int x$26 = 3;
        long x$27 = this.makeFetchPartition$default$3();
        int x$28 = this.makeFetchPartition$default$4();
        FetchRequestData fetchRequest3 = this.makeFetchRequest(sessionId, 2, (Seq<FetchRequestData.FetchTopic>)new .colon.colon((Object)this.makeFetchTopic(foo0.topic(), (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(x$17, x$18, x$21, x$22, x$19, x$20), (List)new .colon.colon((Object)this.makeFetchPartition(foo1.partition(), 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)this.makeFetchTopic(bar1.topic(), (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(x$23, x$24, x$27, x$28, x$25, x$26), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)), this.makeFetchRequest$default$4());
        FetchContext context3 = fetchManager.newContext(fetchRequest3, false);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), Optional.of(BoxesRunTime.boxToInteger((int)6))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), Optional.of(BoxesRunTime.boxToInteger((int)3)))})), (Object)FetchSessionTest.cachedLeaderEpochs$2(context3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo0), Optional.of(BoxesRunTime.boxToInteger((int)5))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)foo1), Optional.empty()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bar1), Optional.of(BoxesRunTime.boxToInteger((int)3)))})), (Object)FetchSessionTest.cachedLastFetchedEpochs$1(context2));
    }

    private void assertPartitionsInContext(FetchRequestData expectedFetchRequest, FetchContext context) {
        Iterator iterator = ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(expectedFetchRequest.topics()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)topic -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topic.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)partition -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic.topic(), partition.partition())), partition), Buffer$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom())).iterator();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(topicPartition, data) -> {
            FetchSessionTest.$anonfun$assertPartitionsInContext$3(iterator, topicPartition, data);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFetchRequests() {
        FetchResponse resp8;
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        int x$1 = -1;
        int x$2 = this.makeFetchRequest$default$1();
        Seq<FetchRequestData.FetchTopic> x$3 = this.makeFetchRequest$default$3();
        Seq<FetchRequestData.ForgottenTopic> x$4 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest1 = this.makeFetchRequest(x$2, x$1, x$3, x$4);
        FetchContext context = fetchManager.newContext(fetchRequest1, true);
        Assertions.assertEquals(SessionlessFetchContext.class, context.getClass());
        .colon.colon x$5 = new .colon.colon((Object)this.makeFetchTopic("foo", (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$))), (List)Nil$.MODULE$);
        int x$6 = this.makeFetchRequest$default$1();
        int x$7 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$8 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest2 = this.makeFetchRequest(x$6, x$7, (Seq<FetchRequestData.FetchTopic>)x$5, x$8);
        FetchContext context2 = fetchManager.newContext(fetchRequest2, false);
        Assertions.assertEquals(FullFetchContext.class, context2.getClass());
        this.assertPartitionsInContext(fetchRequest2, context2);
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("foo", 0)).get()));
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(new TopicPartition("foo", 1)).get()));
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData2.put(new TopicPartition("foo", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData2.put(new TopicPartition("foo", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertTrue((resp2.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals(respData2, (Object)resp2.responseData());
        FetchContext context3 = fetchManager.newContext(this.makeFetchRequest(resp2.sessionId(), 5, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false);
        Assertions.assertEquals(SessionErrorContext.class, context3.getClass());
        Assertions.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)context3.updateAndGenerateResponseData(respData2).error());
        fetchRequest2.setSessionId(resp2.sessionId() + 1).setSessionEpoch(1);
        FetchContext context4 = fetchManager.newContext(this.makeFetchRequest(resp2.sessionId() + 1, 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false);
        Assertions.assertEquals(SessionErrorContext.class, context4.getClass());
        Assertions.assertEquals((Object)Errors.FETCH_SESSION_ID_NOT_FOUND, (Object)context4.updateAndGenerateResponseData(respData2).error());
        FetchRequestData fetchRequest3 = this.makeFetchRequest(resp2.sessionId(), 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4());
        FetchContext context5 = fetchManager.newContext(fetchRequest3, false);
        Assertions.assertEquals(IncrementalFetchContext.class, context5.getClass());
        this.assertPartitionsInContext(fetchRequest2, context5);
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context5.getFetchOffset(new TopicPartition("foo", 1)).get()));
        FetchResponse resp5 = context5.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp5.error());
        Assertions.assertEquals((int)resp2.sessionId(), (int)resp5.sessionId());
        Assertions.assertEquals((int)0, (int)resp5.responseData().size());
        FetchContext context6 = fetchManager.newContext(this.makeFetchRequest(resp2.sessionId(), 5, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false);
        Assertions.assertEquals(SessionErrorContext.class, context6.getClass());
        Assertions.assertEquals((Object)Errors.INVALID_FETCH_SESSION_EPOCH, (Object)context6.updateAndGenerateResponseData(respData2).error());
        FetchResponse resp7 = fetchManager.newContext(this.makeFetchRequest(resp2.sessionId(), 2, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false).getThrottledResponse(100);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp7.error());
        Assertions.assertEquals((int)resp2.sessionId(), (int)resp7.sessionId());
        Assertions.assertEquals((int)100, (int)resp7.throttleTimeMs());
        int prevSessionId = resp5.sessionId();
        do {
            FetchRequestData fetchRequest8 = this.makeFetchRequest(prevSessionId, -1, (Seq<FetchRequestData.FetchTopic>)new .colon.colon((Object)this.makeFetchTopic("bar", (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$))), (List)Nil$.MODULE$), this.makeFetchRequest$default$4());
            FetchContext context8 = fetchManager.newContext(fetchRequest8, false);
            Assertions.assertEquals(SessionlessFetchContext.class, context8.getClass());
            Assertions.assertEquals((int)0, (int)cache.size());
            LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData8 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
            respData8.put(new TopicPartition("bar", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
            respData8.put(new TopicPartition("bar", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
            resp8 = context8.updateAndGenerateResponseData(respData8);
            Assertions.assertEquals((Object)Errors.NONE, (Object)resp8.error());
        } while (resp8.sessionId() == prevSessionId);
    }

    @Test
    public void testIncrementalFetchSession() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        TopicPartition bar0 = new TopicPartition("bar", 0);
        TopicPartition bar2 = new TopicPartition("bar", 2);
        .colon.colon x$1 = new .colon.colon((Object)this.makeFetchTopic(foo0.topic(), (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(foo0.partition(), 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(foo1.partition(), 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$))), (List)Nil$.MODULE$);
        int x$22 = this.makeFetchRequest$default$1();
        int x$3 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$4 = this.makeFetchRequest$default$4();
        FetchRequestData fetchRequest0 = this.makeFetchRequest(x$22, x$3, (Seq<FetchRequestData.FetchTopic>)x$1, x$4);
        FetchContext context1 = fetchManager.newContext(fetchRequest0, false);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData1.put(foo0, new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData().size());
        FetchRequestData fetchRequest2 = this.makeFetchRequest(resp1.sessionId(), 1, (Seq<FetchRequestData.FetchTopic>)new .colon.colon((Object)this.makeFetchTopicPartition(bar0, 15L, this.makeFetchTopicPartition$default$3(), this.makeFetchTopicPartition$default$4(), this.makeFetchTopicPartition$default$5(), this.makeFetchTopicPartition$default$6()), (List)Nil$.MODULE$), (Seq<FetchRequestData.ForgottenTopic>)new .colon.colon((Object)this.makeForgottenTopic(foo0), (List)Nil$.MODULE$));
        FetchContext context2 = fetchManager.newContext(fetchRequest2, false);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        Iterator reqData2Iter = ((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo1, bar0}))).iterator();
        context2.foreachPartition((Function2 & Serializable & scala.Serializable)(topicPart, x$2) -> {
            FetchSessionTest.$anonfun$testIncrementalFetchSession$1(reqData2Iter, topicPart, x$2);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)None$.MODULE$, (Object)context2.getFetchOffset(foo0));
        Assertions.assertEquals((long)10L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(foo1).get()));
        Assertions.assertEquals((long)15L, (long)BoxesRunTime.unboxToLong((Object)context2.getFetchOffset(bar0).get()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)context2.getFetchOffset(bar2));
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData2 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData2.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(foo1.partition()).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        respData2.put(bar0, new FetchResponseData.PartitionData().setPartitionIndex(bar0.partition()).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)1, (int)resp2.responseData().size());
        Assertions.assertTrue((resp2.sessionId() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testFetchSessionExpiration() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(2, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        .colon.colon x$1 = new .colon.colon((Object)this.makeFetchTopic("foo", (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$))), (List)Nil$.MODULE$);
        int x$2 = this.makeFetchRequest$default$1();
        int x$3 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$4 = this.makeFetchRequest$default$4();
        FetchRequestData session1req = this.makeFetchRequest(x$2, x$3, (Seq<FetchRequestData.FetchTopic>)x$1, x$4);
        FetchContext session1context1 = fetchManager.newContext(session1req, false);
        Assertions.assertEquals(FullFetchContext.class, session1context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData1.put(new TopicPartition("foo", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(new TopicPartition("foo", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session1resp = session1context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session1resp.error());
        Assertions.assertTrue((session1resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session1resp.responseData().size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        time.sleep(500L);
        .colon.colon x$5 = new .colon.colon((Object)this.makeFetchTopic("foo", (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$))), (List)Nil$.MODULE$);
        int x$6 = this.makeFetchRequest$default$1();
        int x$7 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$8 = this.makeFetchRequest$default$4();
        FetchRequestData session2req = this.makeFetchRequest(x$6, x$7, (Seq<FetchRequestData.FetchTopic>)x$5, x$8);
        FetchContext session2context = fetchManager.newContext(session2req, false);
        Assertions.assertEquals(FullFetchContext.class, session2context.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> session2RespData = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        session2RespData.put(new TopicPartition("foo", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        session2RespData.put(new TopicPartition("foo", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session2resp = session2context.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session2resp.error());
        Assertions.assertTrue((session2resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session2resp.responseData().size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cache.get(session2resp.sessionId()).isDefined());
        time.sleep(500L);
        FetchContext context1v2 = fetchManager.newContext(this.makeFetchRequest(session1resp.sessionId(), 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false);
        Assertions.assertEquals(IncrementalFetchContext.class, context1v2.getClass());
        time.sleep(501L);
        .colon.colon x$9 = new .colon.colon((Object)this.makeFetchTopic("foo", (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$))), (List)Nil$.MODULE$);
        int x$10 = this.makeFetchRequest$default$1();
        int x$11 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$12 = this.makeFetchRequest$default$4();
        FetchRequestData session3req = this.makeFetchRequest(x$10, x$11, (Seq<FetchRequestData.FetchTopic>)x$9, x$12);
        FetchContext session3context = fetchManager.newContext(session3req, false);
        Assertions.assertEquals(FullFetchContext.class, session3context.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData3 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData3.put(new TopicPartition("foo", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData3.put(new TopicPartition("foo", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session3resp = session3context.updateAndGenerateResponseData(respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session3resp.error());
        Assertions.assertTrue((session3resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session3resp.responseData().size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertFalse((boolean)cache.get(session2resp.sessionId()).isDefined(), (String)"session 2 should have been evicted by latest session, as session 1 was used more recently");
        Assertions.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
    }

    @Test
    public void testPrivilegedSessionHandling() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(2, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        .colon.colon x$1 = new .colon.colon((Object)this.makeFetchTopic("foo", (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$))), (List)Nil$.MODULE$);
        int x$2 = this.makeFetchRequest$default$1();
        int x$3 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$4 = this.makeFetchRequest$default$4();
        FetchRequestData session1req = this.makeFetchRequest(x$2, x$3, (Seq<FetchRequestData.FetchTopic>)x$1, x$4);
        FetchContext session1context = fetchManager.newContext(session1req, true);
        Assertions.assertEquals(FullFetchContext.class, session1context.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData1.put(new TopicPartition("foo", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(new TopicPartition("foo", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session1resp = session1context.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session1resp.error());
        Assertions.assertTrue((session1resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session1resp.responseData().size());
        Assertions.assertEquals((int)1, (int)cache.size());
        time.sleep(500L);
        .colon.colon x$5 = new .colon.colon((Object)this.makeFetchTopic("foo", (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$))), (List)Nil$.MODULE$);
        int x$6 = this.makeFetchRequest$default$1();
        int x$7 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$8 = this.makeFetchRequest$default$4();
        FetchRequestData session2req = this.makeFetchRequest(x$6, x$7, (Seq<FetchRequestData.FetchTopic>)x$5, x$8);
        FetchContext session2context = fetchManager.newContext(session2req, false);
        Assertions.assertEquals(FullFetchContext.class, session2context.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> session2RespData = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        session2RespData.put(new TopicPartition("foo", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        session2RespData.put(new TopicPartition("foo", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session2resp = session2context.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session2resp.error());
        Assertions.assertTrue((session2resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session2resp.responseData().size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cache.get(session2resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cache.size());
        time.sleep(500L);
        .colon.colon x$9 = new .colon.colon((Object)this.makeFetchTopic("foo", (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$))), (List)Nil$.MODULE$);
        int x$10 = this.makeFetchRequest$default$1();
        int x$11 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$12 = this.makeFetchRequest$default$4();
        FetchRequestData session3req = this.makeFetchRequest(x$10, x$11, (Seq<FetchRequestData.FetchTopic>)x$9, x$12);
        FetchContext session3context = fetchManager.newContext(session3req, true);
        Assertions.assertEquals(FullFetchContext.class, session3context.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData3 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData3.put(new TopicPartition("foo", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData3.put(new TopicPartition("foo", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session3resp = session3context.updateAndGenerateResponseData(respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session3resp.error());
        Assertions.assertTrue((session3resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session3resp.responseData().size());
        Assertions.assertTrue((boolean)cache.get(session1resp.sessionId()).isDefined());
        Assertions.assertFalse((boolean)cache.get(session2resp.sessionId()).isDefined(), (String)"session 2 should have been evicted by session 3");
        Assertions.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cache.size());
        time.sleep(501L);
        .colon.colon x$13 = new .colon.colon((Object)this.makeFetchTopic("foo", (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$))), (List)Nil$.MODULE$);
        int x$14 = this.makeFetchRequest$default$1();
        int x$15 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$16 = this.makeFetchRequest$default$4();
        FetchRequestData session4req = this.makeFetchRequest(x$14, x$15, (Seq<FetchRequestData.FetchTopic>)x$13, x$16);
        FetchContext session4context = fetchManager.newContext(session4req, true);
        Assertions.assertEquals(FullFetchContext.class, session4context.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData4 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData4.put(new TopicPartition("foo", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData4.put(new TopicPartition("foo", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse session4resp = session3context.updateAndGenerateResponseData(respData4);
        Assertions.assertEquals((Object)Errors.NONE, (Object)session4resp.error());
        Assertions.assertTrue((session4resp.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)session4resp.responseData().size());
        Assertions.assertFalse((boolean)cache.get(session1resp.sessionId()).isDefined(), (String)"session 1 should have been evicted by session 4 even though it is privileged as it has hit eviction time");
        Assertions.assertTrue((boolean)cache.get(session3resp.sessionId()).isDefined());
        Assertions.assertTrue((boolean)cache.get(session4resp.sessionId()).isDefined());
        Assertions.assertEquals((int)2, (int)cache.size());
    }

    @Test
    public void testZeroSizeFetchSession() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        .colon.colon x$1 = new .colon.colon((Object)this.makeFetchTopic("foo", (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(0, 0L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchPartition(1, 10L, this.makeFetchPartition$default$3(), this.makeFetchPartition$default$4(), this.makeFetchPartition$default$5(), this.makeFetchPartition$default$6()), (List)Nil$.MODULE$))), (List)Nil$.MODULE$);
        int x$2 = this.makeFetchRequest$default$1();
        int x$3 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$4 = this.makeFetchRequest$default$4();
        FetchRequestData reqData1 = this.makeFetchRequest(x$2, x$3, (Seq<FetchRequestData.FetchTopic>)x$1, x$4);
        FetchContext context1 = fetchManager.newContext(reqData1, false);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData1.put(new TopicPartition("foo", 0), new FetchResponseData.PartitionData().setPartitionIndex(0).setHighWatermark(100L).setLastStableOffset(100L).setLogStartOffset(100L));
        respData1.put(new TopicPartition("foo", 1), new FetchResponseData.PartitionData().setPartitionIndex(1).setHighWatermark(10L).setLastStableOffset(10L).setLogStartOffset(10L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertTrue((resp1.sessionId() != 0 ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)resp1.responseData().size());
        int x$5 = resp1.sessionId();
        int x$6 = 1;
        .colon.colon x$7 = new .colon.colon((Object)this.makeForgottenTopic("foo", (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))), (List)Nil$.MODULE$);
        Seq<FetchRequestData.FetchTopic> x$8 = this.makeFetchRequest$default$3();
        FetchRequestData reqData2 = this.makeFetchRequest(x$5, x$6, x$8, (Seq<FetchRequestData.ForgottenTopic>)x$7);
        FetchContext context2 = fetchManager.newContext(reqData2, false);
        Assertions.assertEquals(SessionlessFetchContext.class, context2.getClass());
        LinkedHashMap respData2 = new LinkedHashMap();
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((int)0, (int)resp2.sessionId());
        Assertions.assertTrue((boolean)resp2.responseData().isEmpty());
        Assertions.assertEquals((int)0, (int)cache.size());
    }

    @Test
    public void testDivergingEpoch() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        TopicPartition bar2 = new TopicPartition("bar", 2);
        long x$2 = 0L;
        int x$3 = 5;
        int x$4 = 4;
        long x$5 = this.makeFetchTopicPartition$default$3();
        int x$6 = this.makeFetchTopicPartition$default$4();
        long x$8 = 0L;
        int x$9 = 5;
        int x$10 = 4;
        long x$11 = this.makeFetchTopicPartition$default$3();
        int x$12 = this.makeFetchTopicPartition$default$4();
        .colon.colon x$13 = new .colon.colon((Object)this.makeFetchTopicPartition(foo1, x$2, x$5, x$6, x$3, x$4), (List)new .colon.colon((Object)this.makeFetchTopicPartition(bar2, x$8, x$11, x$12, x$9, x$10), (List)Nil$.MODULE$));
        int x$14 = this.makeFetchRequest$default$1();
        int x$15 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$16 = this.makeFetchRequest$default$4();
        FetchRequestData reqData = this.makeFetchRequest(x$14, x$15, (Seq<FetchRequestData.FetchTopic>)x$13, x$16);
        FetchContext context1 = fetchManager.newContext(reqData, false);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(foo1.partition()).setHighWatermark(105L).setLastStableOffset(105L).setLogStartOffset(0L));
        FetchResponseData.EpochEndOffset divergingEpoch = new FetchResponseData.EpochEndOffset().setEpoch(3).setEndOffset(90L);
        respData.put(bar2, new FetchResponseData.PartitionData().setPartitionIndex(bar2.partition()).setHighWatermark(105L).setLastStableOffset(105L).setLogStartOffset(0L).setDivergingEpoch(divergingEpoch));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertNotEquals((int)0, (int)resp1.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{foo1, bar2}), resp1.responseData().keySet());
        FetchContext context2 = fetchManager.newContext(this.makeFetchRequest(resp1.sessionId(), 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp2.sessionId());
        Assertions.assertEquals(Collections.singleton(bar2), resp2.responseData().keySet());
        respData.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(foo1.partition()).setHighWatermark(105L).setLastStableOffset(105L).setLogStartOffset(0L).setDivergingEpoch(divergingEpoch));
        FetchResponse resp3 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp3.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{foo1, bar2}), resp3.responseData().keySet());
        respData.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(foo1.partition()).setHighWatermark(110L).setLastStableOffset(110L).setLogStartOffset(0L));
        FetchResponse resp4 = context2.updateAndGenerateResponseData(respData);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp4.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp4.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{foo1, bar2}), resp4.responseData().keySet());
    }

    @Test
    public void testDeprioritizesPartitionsWithRecordsOnly() {
        MockTime time = new MockTime();
        FetchSessionCache cache = new FetchSessionCache(10, 1000L);
        FetchManager fetchManager = new FetchManager((Time)time, cache);
        TopicPartition foo1 = new TopicPartition("foo", 1);
        TopicPartition bar2 = new TopicPartition("bar", 2);
        TopicPartition zar3 = new TopicPartition("zar", 3);
        long x$2 = 0L;
        int x$3 = 5;
        int x$4 = 4;
        long x$5 = this.makeFetchTopicPartition$default$3();
        int x$6 = this.makeFetchTopicPartition$default$4();
        long x$8 = 0L;
        int x$9 = 5;
        int x$10 = 4;
        long x$11 = this.makeFetchTopicPartition$default$3();
        int x$12 = this.makeFetchTopicPartition$default$4();
        long x$14 = 0L;
        int x$15 = 5;
        int x$16 = 4;
        long x$17 = this.makeFetchTopicPartition$default$3();
        int x$18 = this.makeFetchTopicPartition$default$4();
        .colon.colon x$19 = new .colon.colon((Object)this.makeFetchTopicPartition(foo1, x$2, x$5, x$6, x$3, x$4), (List)new .colon.colon((Object)this.makeFetchTopicPartition(bar2, x$8, x$11, x$12, x$9, x$10), (List)new .colon.colon((Object)this.makeFetchTopicPartition(zar3, x$14, x$17, x$18, x$15, x$16), (List)Nil$.MODULE$)));
        int x$20 = this.makeFetchRequest$default$1();
        int x$21 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$22 = this.makeFetchRequest$default$4();
        FetchRequestData reqData = this.makeFetchRequest(x$20, x$21, (Seq<FetchRequestData.FetchTopic>)x$19, x$22);
        FetchContext context1 = fetchManager.newContext(reqData, false);
        Assertions.assertEquals(FullFetchContext.class, context1.getClass());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData1 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData1.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(foo1.partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        respData1.put(bar2, new FetchResponseData.PartitionData().setPartitionIndex(bar2.partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        respData1.put(zar3, new FetchResponseData.PartitionData().setPartitionIndex(zar3.partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        FetchResponse resp1 = context1.updateAndGenerateResponseData(respData1);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp1.error());
        Assertions.assertNotEquals((int)0, (int)resp1.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{foo1, bar2, zar3}), resp1.responseData().keySet());
        FetchContext context2 = fetchManager.newContext(this.makeFetchRequest(resp1.sessionId(), 1, this.makeFetchRequest$default$3(), this.makeFetchRequest$default$4()), false);
        Assertions.assertEquals(IncrementalFetchContext.class, context2.getClass());
        this.assertPartitionsOrder(context2, (Seq<TopicPartition>)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)bar2, (List)new .colon.colon((Object)zar3, (List)Nil$.MODULE$))));
        LinkedHashMap respData2 = new LinkedHashMap();
        FetchResponse resp2 = context2.updateAndGenerateResponseData(respData2);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp2.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp2.sessionId());
        Assertions.assertEquals(Collections.emptySet(), resp2.responseData().keySet());
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> respData3 = new LinkedHashMap<TopicPartition, FetchResponseData.PartitionData>();
        respData3.put(foo1, new FetchResponseData.PartitionData().setPartitionIndex(foo1.partition()).setHighWatermark(60L).setLastStableOffset(50L).setLogStartOffset(0L));
        respData3.put(bar2, new FetchResponseData.PartitionData().setPartitionIndex(bar2.partition()).setHighWatermark(60L).setLastStableOffset(50L).setLogStartOffset(0L).setRecords((BaseRecords)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(100L, null)})));
        respData3.put(zar3, new FetchResponseData.PartitionData().setPartitionIndex(zar3.partition()).setHighWatermark(50L).setLastStableOffset(50L).setLogStartOffset(0L));
        FetchResponse resp3 = context2.updateAndGenerateResponseData(respData3);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp3.error());
        Assertions.assertEquals((int)resp1.sessionId(), (int)resp3.sessionId());
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new TopicPartition[]{foo1, bar2}), resp3.responseData().keySet());
        this.assertPartitionsOrder(context2, (Seq<TopicPartition>)new .colon.colon((Object)foo1, (List)new .colon.colon((Object)zar3, (List)new .colon.colon((Object)bar2, (List)Nil$.MODULE$))));
    }

    private void assertPartitionsOrder(FetchContext context, Seq<TopicPartition> partitions) {
        ArrayBuffer partitionsInContext = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(tp, x$3) -> {
            partitionsInContext.$plus$eq((Object)tp);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(partitions, (Object)partitionsInContext.toSeq());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSessionUpdate() {
        void var38_38;
        void var37_37;
        void var36_36;
        void var26_26;
        void var25_25;
        void var24_24;
        void var13_13;
        void var12_12;
        void var11_11;
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.maybeAddListener((TopicPartition)ArgumentMatchers.any(), (PartitionListener)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        FetchSession session = new FetchSession(0, false, new ImplicitLinkedHashCollection(), 0L, 0L, 0);
        TopicPartition foo0 = new TopicPartition("foo", 0);
        TopicPartition bar1 = new TopicPartition("bar", 1);
        TopicPartition zar2 = new TopicPartition("zar", 2);
        .colon.colon x$1 = new .colon.colon((Object)this.makeFetchTopicPartition(foo0, 10L, 1L, this.makeFetchTopicPartition$default$4(), this.makeFetchTopicPartition$default$5(), this.makeFetchTopicPartition$default$6()), (List)new .colon.colon((Object)this.makeFetchTopicPartition(bar1, 20L, 2L, 200, this.makeFetchTopicPartition$default$5(), this.makeFetchTopicPartition$default$6()), (List)Nil$.MODULE$));
        int x$2 = this.makeFetchRequest$default$1();
        int x$3 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$4 = this.makeFetchRequest$default$4();
        Tuple3 tuple3 = session.update(this.makeFetchRequest(x$2, x$3, (Seq<FetchRequestData.FetchTopic>)x$1, x$4));
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        ArrayList added1 = (ArrayList)tuple3._1();
        ArrayList updated1 = (ArrayList)tuple3._2();
        ArrayList removed1 = (ArrayList)tuple3._3();
        void added12 = var11_11;
        void updated12 = var12_12;
        void removed12 = var13_13;
        FetchSessionTest.maybeRegisterListeners$1(session, replicaManager);
        Assertions.assertEquals((int)2, (int)session.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0, bar1})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)added12).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)updated12).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)removed12).asScala()).toSet());
        IncrementalPartitionFetchMetadata foo0Metadata = FetchSessionTest.assertPartitionState$1(foo0, 10L, 1L, 100, Optional.empty(), Optional.empty(), session);
        IncrementalPartitionFetchMetadata bar1Metadata = FetchSessionTest.assertPartitionState$1(bar1, 20L, 2L, 200, Optional.empty(), Optional.empty(), session);
        .colon.colon x$5 = new .colon.colon((Object)this.makeFetchTopicPartition(foo0, 30L, 3L, 300, 2, 1), (List)new .colon.colon((Object)this.makeFetchTopicPartition(zar2, 50L, 5L, 500, this.makeFetchTopicPartition$default$5(), this.makeFetchTopicPartition$default$6()), (List)Nil$.MODULE$));
        int x$6 = this.makeFetchRequest$default$1();
        int x$7 = this.makeFetchRequest$default$2();
        Seq<FetchRequestData.ForgottenTopic> x$8 = this.makeFetchRequest$default$4();
        Tuple3 tuple32 = session.update(this.makeFetchRequest(x$6, x$7, (Seq<FetchRequestData.FetchTopic>)x$5, x$8));
        if (tuple32 == null) {
            throw new MatchError(null);
        }
        ArrayList added2 = (ArrayList)tuple32._1();
        ArrayList updated2 = (ArrayList)tuple32._2();
        ArrayList removed2 = (ArrayList)tuple32._3();
        void added22 = var24_24;
        void updated22 = var25_25;
        void removed22 = var26_26;
        FetchSessionTest.maybeRegisterListeners$1(session, replicaManager);
        Assertions.assertEquals((int)3, (int)session.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{zar2})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)added22).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{foo0})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)updated22).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)removed22).asScala()).toSet());
        FetchSessionTest.assertPartitionState$1(foo0, 30L, 3L, 300, Optional.of(Predef$.MODULE$.int2Integer(2)), Optional.of(Predef$.MODULE$.int2Integer(1)), session);
        FetchSessionTest.assertPartitionState$1(bar1, 20L, 2L, 200, Optional.empty(), Optional.empty(), session);
        IncrementalPartitionFetchMetadata zar2Metadata = FetchSessionTest.assertPartitionState$1(zar2, 50L, 5L, 500, Optional.empty(), Optional.empty(), session);
        .colon.colon x$9 = new .colon.colon((Object)this.makeFetchTopicPartition(zar2, 100L, 55L, this.makeFetchTopicPartition$default$4(), this.makeFetchTopicPartition$default$5(), this.makeFetchTopicPartition$default$6()), (List)Nil$.MODULE$);
        .colon.colon x$10 = new .colon.colon((Object)this.makeForgottenTopic(bar1), (List)Nil$.MODULE$);
        int x$11 = this.makeFetchRequest$default$1();
        int x$12 = this.makeFetchRequest$default$2();
        Tuple3 tuple33 = session.update(this.makeFetchRequest(x$11, x$12, (Seq<FetchRequestData.FetchTopic>)x$9, (Seq<FetchRequestData.ForgottenTopic>)x$10));
        if (tuple33 == null) {
            throw new MatchError(null);
        }
        ArrayList added3 = (ArrayList)tuple33._1();
        ArrayList updated3 = (ArrayList)tuple33._2();
        ArrayList removed3 = (ArrayList)tuple33._3();
        void added32 = var36_36;
        void updated32 = var37_37;
        void removed32 = var38_38;
        FetchSessionTest.maybeRegisterListeners$1(session, replicaManager);
        Assertions.assertEquals((int)2, (int)session.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)added32).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{zar2})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)updated32).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{bar1})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)removed32).asScala()).toSet());
        FetchSessionTest.assertPartitionState$1(foo0, 30L, 3L, 300, Optional.of(Predef$.MODULE$.int2Integer(2)), Optional.of(Predef$.MODULE$.int2Integer(1)), session);
        FetchSessionTest.assertPartitionRemoved$1(bar1, session);
        FetchSessionTest.assertPartitionState$1(zar2, 100L, 55L, 100, Optional.empty(), Optional.empty(), session);
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).maybeAddListener(foo0, (PartitionListener)foo0Metadata);
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).maybeAddListener(bar1, (PartitionListener)bar1Metadata);
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).maybeAddListener(zar2, (PartitionListener)zar2Metadata);
        ((ReplicaManager)Mockito.verify((Object)replicaManager)).removeListener(bar1, (PartitionListener)bar1Metadata);
    }

    @Test
    public void testSessionClose() {
        ImplicitLinkedHashCollection cacheMap = new ImplicitLinkedHashCollection();
        IncrementalPartitionFetchMetadata partition1 = (IncrementalPartitionFetchMetadata)Mockito.spy((Object)new IncrementalPartitionFetchMetadata("foo", 0));
        cacheMap.add((ImplicitLinkedHashCollection.Element)partition1);
        IncrementalPartitionFetchMetadata partition2 = (IncrementalPartitionFetchMetadata)Mockito.spy((Object)new IncrementalPartitionFetchMetadata("bar", 0));
        cacheMap.add((ImplicitLinkedHashCollection.Element)partition2);
        new FetchSession(0, false, cacheMap, 0L, 0L, 0).close();
        ((IncrementalPartitionFetchMetadata)Mockito.verify((Object)partition1)).close();
        ((IncrementalPartitionFetchMetadata)Mockito.verify((Object)partition2)).close();
    }

    private FetchRequestData makeFetchRequest(int sessionId, int sessionEpoch, Seq<FetchRequestData.FetchTopic> topics, Seq<FetchRequestData.ForgottenTopic> forgottenTopics) {
        return new FetchRequestData().setSessionId(sessionId).setSessionEpoch(sessionEpoch).setTopics((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).setForgottenTopicsData((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(forgottenTopics).asJava());
    }

    private int makeFetchRequest$default$1() {
        return 0;
    }

    private int makeFetchRequest$default$2() {
        return 0;
    }

    private Seq<FetchRequestData.FetchTopic> makeFetchRequest$default$3() {
        return Nil$.MODULE$;
    }

    private Seq<FetchRequestData.ForgottenTopic> makeFetchRequest$default$4() {
        return Nil$.MODULE$;
    }

    private FetchRequestData.FetchTopic makeFetchTopicPartition(TopicPartition topicPartition, long fetchOffset, long logStartOffset, int maxBytes, int currentLeaderEpoch, int lastFetchedEpoch) {
        return this.makeFetchTopic(topicPartition.topic(), (Seq<FetchRequestData.FetchPartition>)new .colon.colon((Object)this.makeFetchPartition(topicPartition.partition(), fetchOffset, logStartOffset, maxBytes, currentLeaderEpoch, lastFetchedEpoch), (List)Nil$.MODULE$));
    }

    private FetchRequestData.FetchTopic makeFetchTopic(String topic, Seq<FetchRequestData.FetchPartition> partitions) {
        return new FetchRequestData.FetchTopic().setTopic(topic).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(partitions).asJava());
    }

    private long makeFetchTopicPartition$default$3() {
        return 0L;
    }

    private int makeFetchTopicPartition$default$4() {
        return 100;
    }

    private int makeFetchTopicPartition$default$5() {
        return -1;
    }

    private int makeFetchTopicPartition$default$6() {
        return -1;
    }

    private FetchRequestData.FetchPartition makeFetchPartition(int partition, long fetchOffset, long logStartOffset, int maxBytes, int currentLeaderEpoch, int lastFetchedEpoch) {
        return new FetchRequestData.FetchPartition().setPartition(partition).setFetchOffset(fetchOffset).setLogStartOffset(logStartOffset).setPartitionMaxBytes(maxBytes).setCurrentLeaderEpoch(currentLeaderEpoch).setLastFetchedEpoch(lastFetchedEpoch);
    }

    private long makeFetchPartition$default$3() {
        return 0L;
    }

    private int makeFetchPartition$default$4() {
        return 100;
    }

    private int makeFetchPartition$default$5() {
        return -1;
    }

    private int makeFetchPartition$default$6() {
        return -1;
    }

    private FetchRequestData.ForgottenTopic makeForgottenTopic(TopicPartition topicPartition) {
        return this.makeForgottenTopic(topicPartition.topic(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{topicPartition.partition()}))));
    }

    private FetchRequestData.ForgottenTopic makeForgottenTopic(String topic, Seq<Object> partitions) {
        return new FetchRequestData.ForgottenTopic().setTopic(topic).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitions.map((Function1 & Serializable & scala.Serializable)x -> FetchSessionTest.$anonfun$makeForgottenTopic$1(BoxesRunTime.unboxToInt((Object)x)), Seq$.MODULE$.canBuildFrom())).asJava());
    }

    private static final Map cachedLeaderEpochs$1(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.currentLeaderEpoch()));
            return BoxedUnit.UNIT;
        });
        return (Map)mapBuilder.result();
    }

    private static final Map cachedLeaderEpochs$2(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.currentLeaderEpoch()));
            return BoxedUnit.UNIT;
        });
        return (Map)mapBuilder.result();
    }

    private static final Map cachedLastFetchedEpochs$1(FetchContext context) {
        Builder mapBuilder = Predef$.MODULE$.Map().newBuilder();
        context.foreachPartition((Function2 & Serializable & scala.Serializable)(tp, data) -> {
            mapBuilder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)data.lastFetchedEpoch()));
            return BoxedUnit.UNIT;
        });
        return (Map)mapBuilder.result();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$assertPartitionsInContext$3(Iterator iterator$1, TopicPartition topicPartition, PartitionFetchMetadata data) {
        void var5_5;
        void var4_4;
        Assertions.assertTrue((boolean)iterator$1.hasNext());
        Tuple2 tuple2 = (Tuple2)iterator$1.next();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        TopicPartition expectedTopicPartition = (TopicPartition)tuple2._1();
        FetchRequestData.FetchPartition expectedPartition = (FetchRequestData.FetchPartition)tuple2._2();
        void expectedTopicPartition2 = var4_4;
        void expectedPartition2 = var5_5;
        Assertions.assertEquals((Object)expectedTopicPartition2, (Object)topicPartition);
        Assertions.assertEquals((long)expectedPartition2.fetchOffset(), (long)data.fetchOffset());
        Assertions.assertEquals((long)expectedPartition2.logStartOffset(), (long)data.startOffset());
        Assertions.assertEquals((int)expectedPartition2.partitionMaxBytes(), (int)data.maxBytes());
        Assertions.assertEquals((Object)RequestUtils.getLeaderEpoch((int)expectedPartition2.currentLeaderEpoch()), (Object)data.currentLeaderEpoch());
        Assertions.assertEquals((Object)RequestUtils.getLeaderEpoch((int)expectedPartition2.lastFetchedEpoch()), (Object)data.lastFetchedEpoch());
    }

    public static final /* synthetic */ void $anonfun$testIncrementalFetchSession$1(Iterator reqData2Iter$1, TopicPartition topicPart, PartitionFetchMetadata x$2) {
        Assertions.assertEquals((Object)reqData2Iter$1.next(), (Object)topicPart);
    }

    private static final IncrementalPartitionFetchMetadata assertPartitionState$1(TopicPartition tp, long fetchOffset, long startOffset, int maxBytes, Optional currentLeaderEpoch, Optional lastFetchedEpoch, FetchSession session$1) {
        IncrementalPartitionFetchMetadata partitionMetadata = (IncrementalPartitionFetchMetadata)session$1.partitionMap().find((ImplicitLinkedHashCollection.Element)new IncrementalPartitionFetchMetadata(tp.topic(), tp.partition()));
        Assertions.assertNotNull((Object)partitionMetadata, (String)new StringBuilder(23).append("Metadata of ").append(tp).append(" not found.").toString());
        Assertions.assertEquals((long)fetchOffset, (long)partitionMetadata.fetchOffset());
        Assertions.assertEquals((long)startOffset, (long)partitionMetadata.startOffset());
        Assertions.assertEquals((int)maxBytes, (int)partitionMetadata.maxBytes());
        Assertions.assertEquals((Object)currentLeaderEpoch, (Object)partitionMetadata.currentLeaderEpoch());
        Assertions.assertEquals((Object)lastFetchedEpoch, (Object)partitionMetadata.lastFetchedEpoch());
        return partitionMetadata;
    }

    private static final void assertPartitionRemoved$1(TopicPartition tp, FetchSession session$1) {
        Assertions.assertNull((Object)((IncrementalPartitionFetchMetadata)session$1.partitionMap().find((ImplicitLinkedHashCollection.Element)new IncrementalPartitionFetchMetadata(tp.topic(), tp.partition()))), (String)new StringBuilder(25).append("Metadata of ").append(tp).append(" not deleted.").toString());
    }

    private static final void maybeRegisterListeners$1(FetchSession session$1, ReplicaManager replicaManager$1) {
        session$1.partitionMap().forEach(partitionMetadata -> partitionMetadata.maybeRegisterAsListener(replicaManager$1));
    }

    public static final /* synthetic */ Integer $anonfun$makeForgottenTopic$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }
}

