/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Optional;
import kafka.cluster.PartitionListener;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.server.ReplicaManager;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e3A\u0001E\t\u0001-!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001b\u0001\n\u0003\u0011\u0003B\u0002\u0018\u0001A\u0003%1\u0005C\u00040\u0001\t\u0007I\u0011\u0001\u0019\t\rQ\u0002\u0001\u0015!\u00032\u0011\u001d)\u0004A1A\u0005\u0002YBaA\u000f\u0001!\u0002\u00139\u0004\"B\u001e\u0001\t\u0003a\u0004\"B&\u0001\t\u0003a\u0004\"B'\u0001\t\u0003a\u0004\"B(\u0001\t\u0003a\u0004\"B)\u0001\t\u0003a\u0004\"B*\u0001\t\u0003a\u0004\"B+\u0001\t\u0003a\u0004\"B,\u0001\t\u0003a$!J%oGJ,W.\u001a8uC2\u0004\u0016M\u001d;ji&|gNR3uG\"lU\r^1eCR\fG+Z:u\u0015\t\u00112#\u0001\u0004tKJ4XM\u001d\u0006\u0002)\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\u0005Q\u0012!B:dC2\f\u0017B\u0001\u000f\u001a\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011!E\u0001\u0003iB,\u0012a\t\t\u0003I1j\u0011!\n\u0006\u0003M\u001d\naaY8n[>t'B\u0001\u000b)\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\n\u00055*#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0004iB\u0004\u0013!\u00039beRLG/[8o+\u0005\t\u0004C\u0001\u00113\u0013\t\u0019\u0014CA\u0011J]\u000e\u0014X-\\3oi\u0006d\u0007+\u0019:uSRLwN\u001c$fi\u000eDW*\u001a;bI\u0006$\u0018-\u0001\u0006qCJ$\u0018\u000e^5p]\u0002\naB]3qY&\u001c\u0017-T1oC\u001e,'/F\u00018!\t\u0001\u0003(\u0003\u0002:#\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002!Q,7\u000f^%oSRL\u0017\r\\*uCR,G#A\u001f\u0011\u0005aq\u0014BA \u001a\u0005\u0011)f.\u001b;)\u0005!\t\u0005C\u0001\"J\u001b\u0005\u0019%B\u0001#F\u0003\r\t\u0007/\u001b\u0006\u0003\r\u001e\u000bqA[;qSR,'O\u0003\u0002IU\u0005)!.\u001e8ji&\u0011!j\u0011\u0002\u0005)\u0016\u001cH/A\u000euKN$X*Y=cKJ+w-[:uKJ\f5\u000fT5ti\u0016tWM\u001d\u0015\u0003\u0013\u0005\u000b\u0011\u0002^3ti\u000ecwn]3)\u0005)\t\u0015a\u0006;fgR,\u0006\u000fZ1uKJ+\u0017/^3tiB\u000b'/Y7tQ\tY\u0011)\u0001\buKN$\u0018j]\"bk\u001eDG/\u00169)\u00051\t\u0015a\u0007;fgRl\u0015-\u001f2f+B$\u0017\r^3SKN\u0004xN\\:f\t\u0006$\u0018\r\u000b\u0002\u000e\u0003\u00069B/Z:u\u000b2,W.\u001a8u\u0017\u0016L8/\u0011:f\u000bF,\u0018\r\u001c\u0015\u0003\u001d\u0005\u000b!\u0002^3ti\u0016\u000bX/\u00197tQ\ty\u0011\t")
public class IncrementalPartitionFetchMetadataTest {
    private final TopicPartition tp = new TopicPartition("foo", 0);
    private final IncrementalPartitionFetchMetadata partition = new IncrementalPartitionFetchMetadata(this.tp().topic(), this.tp().partition());
    private final ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);

    public TopicPartition tp() {
        return this.tp;
    }

    public IncrementalPartitionFetchMetadata partition() {
        return this.partition;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    @Test
    public void testInitialState() {
        Assertions.assertEquals((long)-1L, (long)this.partition().fetchOffset());
        Assertions.assertEquals((long)-1L, (long)this.partition().startOffset());
        Assertions.assertEquals((int)-1, (int)this.partition().maxBytes());
        Assertions.assertEquals(Optional.empty(), (Object)this.partition().currentLeaderEpoch());
        Assertions.assertEquals(Optional.empty(), (Object)this.partition().lastFetchedEpoch());
        Assertions.assertFalse((boolean)this.partition().fetchMetadataUpdated());
        Assertions.assertFalse((boolean)this.partition().isCaughtUp());
    }

    @Test
    public void testMaybeRegisterAsListener() {
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().maybeAddListener(this.tp(), (PartitionListener)this.partition()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.partition().maybeRegisterAsListener(this.replicaManager());
        this.partition().maybeRegisterAsListener(this.replicaManager());
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).maybeAddListener(this.tp(), (PartitionListener)this.partition());
    }

    @Test
    public void testClose() {
        this.partition().close();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().maybeAddListener(this.tp(), (PartitionListener)this.partition()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.partition().maybeRegisterAsListener(this.replicaManager());
        this.partition().close();
        this.partition().close();
        ((ReplicaManager)Mockito.verify((Object)this.replicaManager())).removeListener(this.tp(), (PartitionListener)this.partition());
    }

    @Test
    public void testUpdateRequestParams() {
        FetchResponseData.PartitionData fetchResponse = new FetchResponseData.PartitionData();
        FetchRequestData.FetchPartition fetchPartition = new FetchRequestData.FetchPartition().setFetchOffset(-1L).setLogStartOffset(-1L).setPartitionMaxBytes(-1).setCurrentLeaderEpoch(-1).setLastFetchedEpoch(-1);
        this.updateAndVerify$1(fetchPartition.duplicate().setFetchOffset(20L), fetchResponse);
        this.updateAndVerify$1(fetchPartition.duplicate().setLogStartOffset(10L), fetchResponse);
        this.updateAndVerify$1(fetchPartition.duplicate().setPartitionMaxBytes(200), fetchResponse);
        this.updateAndVerify$1(fetchPartition.duplicate().setCurrentLeaderEpoch(1), fetchResponse);
        this.updateAndVerify$1(fetchPartition.duplicate().setLastFetchedEpoch(2), fetchResponse);
    }

    @Test
    public void testIsCaughtUp() {
        Assertions.assertFalse((boolean)this.partition().isCaughtUp());
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)this.replicaManager().maybeAddListener(this.tp(), (PartitionListener)this.partition()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        this.partition().maybeRegisterAsListener(this.replicaManager());
        this.partition().onStartOffsetUpdated(this.tp(), 0L);
        this.partition().onEndOffsetUpdated(this.tp(), 0L);
        this.partition().onHighWatermarkUpdated(this.tp(), 0L);
        Assertions.assertFalse((boolean)this.partition().isCaughtUp());
        this.partition().updateRequestParams(new FetchRequestData.FetchPartition().setFetchOffset(0L));
        this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L), true);
        Assertions.assertTrue((boolean)this.partition().isCaughtUp());
        this.partition().onEndOffsetUpdated(this.tp(), 10L);
        Assertions.assertFalse((boolean)this.partition().isCaughtUp());
        this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L), true);
        this.partition().updateRequestParams(new FetchRequestData.FetchPartition().setFetchOffset(10L));
        Assertions.assertTrue((boolean)this.partition().isCaughtUp());
        this.partition().onHighWatermarkUpdated(this.tp(), 10L);
        this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(10L), true);
        Assertions.assertTrue((boolean)this.partition().isCaughtUp());
        this.partition().onStartOffsetUpdated(this.tp(), 5L);
        Assertions.assertFalse((boolean)this.partition().isCaughtUp());
        this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(5L).setHighWatermark(10L), true);
        Assertions.assertTrue((boolean)this.partition().isCaughtUp());
        this.partition().onFailed(this.tp());
        Assertions.assertFalse((boolean)this.partition().isCaughtUp());
    }

    @Test
    public void testMaybeUpdateResponseData() {
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L), true));
        Assertions.assertFalse((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L), true));
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L).setRecords((BaseRecords)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(100L, null)})), true));
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L).setPreferredReadReplica(10).setDivergingEpoch(new FetchResponseData.EpochEndOffset().setEpoch(-1)), true));
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(0L).setPreferredReadReplica(-1).setDivergingEpoch(new FetchResponseData.EpochEndOffset().setEpoch(10)), true));
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(0L).setHighWatermark(10L), true));
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(1L).setHighWatermark(10L), true));
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()), true));
        Assertions.assertTrue((boolean)this.partition().maybeUpdateResponseData(new FetchResponseData.PartitionData().setLogStartOffset(1L).setHighWatermark(10L), true));
    }

    @Test
    public void testElementKeysAreEqual() {
        Assertions.assertTrue((boolean)this.partition().elementKeysAreEqual((Object)this.partition()));
        Assertions.assertTrue((boolean)this.partition().elementKeysAreEqual((Object)new IncrementalPartitionFetchMetadata(this.tp().topic(), this.tp().partition())));
        Assertions.assertFalse((boolean)this.partition().elementKeysAreEqual((Object)new IncrementalPartitionFetchMetadata("bar", 0)));
    }

    @Test
    public void testEquals() {
        Assertions.assertTrue((boolean)this.partition().equals((Object)this.partition()));
        Assertions.assertFalse((boolean)this.partition().equals((Object)new IncrementalPartitionFetchMetadata(this.tp().topic(), this.tp().partition())));
        Assertions.assertFalse((boolean)this.partition().equals((Object)new IncrementalPartitionFetchMetadata("bar", 0)));
    }

    private final void updateAndVerify$1(FetchRequestData.FetchPartition fetchPartition, FetchResponseData.PartitionData fetchResponse$1) {
        Assertions.assertFalse((boolean)this.partition().fetchMetadataUpdated());
        this.partition().updateRequestParams(fetchPartition);
        Assertions.assertEquals((long)fetchPartition.fetchOffset(), (long)this.partition().fetchOffset());
        Assertions.assertEquals((long)fetchPartition.logStartOffset(), (long)this.partition().startOffset());
        Assertions.assertEquals((int)fetchPartition.partitionMaxBytes(), (int)this.partition().maxBytes());
        Assertions.assertEquals((int)fetchPartition.currentLeaderEpoch(), (Integer)this.partition().currentLeaderEpoch().orElse(Predef$.MODULE$.int2Integer(-1)));
        Assertions.assertEquals((int)fetchPartition.lastFetchedEpoch(), (Integer)this.partition().lastFetchedEpoch().orElse(Predef$.MODULE$.int2Integer(-1)));
        Assertions.assertTrue((boolean)this.partition().fetchMetadataUpdated());
        this.partition().maybeUpdateResponseData(fetchResponse$1, true);
        Assertions.assertFalse((boolean)this.partition().fetchMetadataUpdated());
    }
}

