/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.admin.BrokerMetadata;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogOffsetsListener;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.MetadataCache$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.TierReplicaComponents$;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%h\u0001B\u0015+\u0001=BQA\u000e\u0001\u0005\u0002]BqA\u000f\u0001C\u0002\u0013\u00051\b\u0003\u0004@\u0001\u0001\u0006I\u0001\u0010\u0005\b\u0001\u0002\u0011\r\u0011\"\u0001B\u0011\u0019)\u0005\u0001)A\u0005\u0005\"9a\t\u0001b\u0001\n\u0003Y\u0004BB$\u0001A\u0003%A\bC\u0004I\u0001\u0001\u0007I\u0011A\u001e\t\u000f%\u0003\u0001\u0019!C\u0001\u0015\"1\u0001\u000b\u0001Q!\nqBq!\u0015\u0001C\u0002\u0013\u00051\b\u0003\u0004S\u0001\u0001\u0006I\u0001\u0010\u0005\b'\u0002\u0011\r\u0011\"\u0001U\u0011\u0019i\u0006\u0001)A\u0005+\"9a\f\u0001b\u0001\n\u0003y\u0006BB5\u0001A\u0003%\u0001\rC\u0004k\u0001\t\u0007I\u0011A6\t\rI\u0004\u0001\u0015!\u0003m\u0011\u001d\u0019\bA1A\u0005\u0002QDaa\u001f\u0001!\u0002\u0013)\bb\u0002?\u0001\u0005\u0004%\t! \u0005\b\u0003+\u0001\u0001\u0015!\u0003\u007f\u0011-\t9\u0002\u0001a\u0001\u0002\u0004%\t!!\u0007\t\u0017\u0005]\u0002\u00011AA\u0002\u0013\u0005\u0011\u0011\b\u0005\f\u0003{\u0001\u0001\u0019!A!B\u0013\tY\u0002C\u0006\u0002@\u0001\u0001\r\u00111A\u0005\u0002\u0005\u0005\u0003bCA%\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0017B1\"a\u0014\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002D!Y\u0011\u0011\u000b\u0001A\u0002\u0003\u0007I\u0011AA*\u0011-\t9\u0007\u0001a\u0001\u0002\u0004%\t!!\u001b\t\u0017\u00055\u0004\u00011A\u0001B\u0003&\u0011Q\u000b\u0005\b\u0003_\u0002A\u0011AA9\u0011\u001d\tI\t\u0001C\u0001\u0003cBq!a%\u0001\t\u0003\t\t\bC\u0004\u0002\u001e\u0002!\t!!\u001d\t\u000f\u0005\u0005\u0006\u0001\"\u0001\u0002r!9\u0011Q\u0015\u0001\u0005\u0002\u0005E\u0004bBAU\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003[\u0003A\u0011BAX\u0011\u001d\t)\u000f\u0001C\u0005\u0003O\u0014\u0011#S:s\u000bb\u0004\u0018N]1uS>tG+Z:u\u0015\tYC&\u0001\u0004tKJ4XM\u001d\u0006\u0002[\u0005)1.\u00194lC\u000e\u00011C\u0001\u00011!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u000f\t\u0003s\u0001i\u0011AK\u0001\u0014%\u0016\u0004H.[2b\u0019\u0006<G+[7f\u001b\u0006DXj]\u000b\u0002yA\u0011\u0011'P\u0005\u0003}I\u0012A\u0001T8oO\u0006!\"+\u001a9mS\u000e\fG*Y4US6,W*\u0019=Ng\u0002\nQCU3qY&\u001c\u0017MR3uG\"<\u0016-\u001b;NCbl5/F\u0001C!\t\t4)\u0003\u0002Ee\t\u0019\u0011J\u001c;\u0002-I+\u0007\u000f\\5dC\u001a+Go\u00195XC&$X*\u0019=Ng\u0002\nA\u0003T3bI\u0016\u0014Hj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\u0018!\u0006'fC\u0012,'\u000fT8h'R\f'\u000f^(gMN,G\u000fI\u0001\u0013\u0019\u0016\fG-\u001a:M_\u001e,e\u000eZ(gMN,G/\u0001\fMK\u0006$WM\u001d'pO\u0016sGm\u00144gg\u0016$x\fJ3r)\tYe\n\u0005\u00022\u0019&\u0011QJ\r\u0002\u0005+:LG\u000fC\u0004P\u0013\u0005\u0005\t\u0019\u0001\u001f\u0002\u0007a$\u0013'A\nMK\u0006$WM\u001d'pO\u0016sGm\u00144gg\u0016$\b%\u0001\fMK\u0006$WM\u001d'pO\"Kw\r[,bi\u0016\u0014X.\u0019:l\u0003]aU-\u00193fe2{w\rS5hQ^\u000bG/\u001a:nCJ\\\u0007%A\bpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9t+\u0005)\u0006C\u0001,\\\u001b\u00059&B\u0001-Z\u0003\u0011)H/\u001b7\u000b\u0003i\u000bAA[1wC&\u0011Al\u0016\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018\u0001E8wKJ\u0014\u0018\u000eZ5oOB\u0013x\u000e]:!\u0003\u001d\u0019wN\u001c4jON,\u0012\u0001\u0019\t\u0004C\u00124W\"\u00012\u000b\u0005\r\u0014\u0014AC2pY2,7\r^5p]&\u0011QM\u0019\u0002\u0004'\u0016\f\bCA\u001dh\u0013\tA'FA\u0006LC\u001a\\\u0017mQ8oM&<\u0017\u0001C2p]\u001aLwm\u001d\u0011\u0002\u000bQ|\u0007/[2\u0016\u00031\u0004\"!\u001c9\u000e\u00039T!a\\-\u0002\t1\fgnZ\u0005\u0003c:\u0014aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%\u0001\u0003uS6,W#A;\u0011\u0005YLX\"A<\u000b\u0005ad\u0013!B;uS2\u001c\u0018B\u0001>x\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013aB7fiJL7m]\u000b\u0002}B\u0019q0!\u0005\u000e\u0005\u0005\u0005!b\u0001?\u0002\u0004)!\u0011QAA\u0004\u0003\u0019\u0019w.\\7p]*\u0019Q&!\u0003\u000b\t\u0005-\u0011QB\u0001\u0007CB\f7\r[3\u000b\u0005\u0005=\u0011aA8sO&!\u00111CA\u0001\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\rcV|G/Y'b]\u0006<WM]\u000b\u0003\u00037\u0001B!!\b\u000229!\u0011qDA\u0017\u001d\u0011\t\t#a\u000b\u000f\t\u0005\r\u0012\u0011F\u0007\u0003\u0003KQ1!a\n/\u0003\u0019a$o\\8u}%\tQ&\u0003\u0002,Y%\u0019\u0011q\u0006\u0016\u0002\u0019E+x\u000e^1GC\u000e$xN]=\n\t\u0005M\u0012Q\u0007\u0002\u000e#V|G/Y'b]\u0006<WM]:\u000b\u0007\u0005=\"&\u0001\trk>$\u0018-T1oC\u001e,'o\u0018\u0013fcR\u00191*a\u000f\t\u0011=C\u0012\u0011!a\u0001\u00037\tQ\"];pi\u0006l\u0015M\\1hKJ\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0003\u0003\u0007\u00022!OA#\u0013\r\t9E\u000b\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003I\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ|F%Z9\u0015\u0007-\u000bi\u0005\u0003\u0005P7\u0005\u0005\t\u0019AA\"\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013aD1mi\u0016\u0014\u0018j\u001d:NC:\fw-\u001a:\u0016\u0005\u0005U\u0003\u0003BA,\u0003CrA!!\u0017\u0002^9!\u0011\u0011EA.\u0013\tAH&C\u0002\u0002`]\f\u0011\u0002V3tiV#\u0018\u000e\\:\n\t\u0005\r\u0014Q\r\u0002\u0014\u001b>\u001c7.\u00117uKJL5O]'b]\u0006<WM\u001d\u0006\u0004\u0003?:\u0018aE1mi\u0016\u0014\u0018j\u001d:NC:\fw-\u001a:`I\u0015\fHcA&\u0002l!AqJHA\u0001\u0002\u0004\t)&\u0001\tbYR,'/S:s\u001b\u0006t\u0017mZ3sA\u0005)1/\u001a;VaR\t1\nK\u0002!\u0003k\u0002B!a\u001e\u0002\u00066\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(A\u0002ba&TA!a \u0002\u0002\u00069!.\u001e9ji\u0016\u0014(\u0002BAB\u0003\u001b\tQA[;oSRLA!a\"\u0002z\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3!IAG!\u0011\t9(a$\n\t\u0005E\u0015\u0011\u0010\u0002\n\u0003\u001a$XM]#bG\"\f!\u0005^3ti&\u001b(/\u0012=qSJ\fG/[8o\r>\u00148\u000b^;dW\u001a{G\u000e\\8xKJ\u001c\bf\u0001\u0012\u0002\u0018B!\u0011qOAM\u0013\u0011\tY*!\u001f\u0003\tQ+7\u000f^\u0001&i\u0016\u001cH/S:s\u000bb\u0004\u0018N]1uS>t\u0017J\u001a(p\r\u0016$8\r\u001b*fcV,7\u000f^'bI\u0016D3aIAL\u0003\u0005\"Xm\u001d;JgJ,\u0005\u0010]5sCRLwN\u001c$peNcwn\u001e$pY2|w/\u001a:tQ\r!\u0013qS\u0001&i\u0016\u001cH/S:s\u000bb\u0004\u0018N]1uS>tgi\u001c:DCV<\u0007\u000e^+q\r>dGn\\<feND3!JAL\u0003m\"Xm\u001d;JgJ,\u0005\u0010]5sCRLwN\u001c$pe\u000e\u000bWo\u001a5u+B4u\u000e\u001c7po\u0016\u00148o\u00165f]2+\u0017\rZ3s\u0003B\u0004XM\u001c3t)>dun\u001a\u0015\u0004M\u0005]\u0015\u0001I4fiB\u000b'\u000f^5uS>tw+\u001b;i\u00032d'+\u001a9mS\u000e\f7/\u00138JgJ$\"\"!-\u0002>\u00065\u0017\u0011[Ak!\u0011\t\u0019,!/\u000e\u0005\u0005U&bAA\\Y\u000591\r\\;ti\u0016\u0014\u0018\u0002BA^\u0003k\u0013\u0011\u0002U1si&$\u0018n\u001c8\t\r)<\u0003\u0019AA`!\u0011\t\t-!3\u000f\t\u0005\r\u0017Q\u0019\t\u0004\u0003G\u0011\u0014bAAde\u00051\u0001K]3eK\u001aL1!]Af\u0015\r\t9M\r\u0005\u0007\u0003\u001f<\u0003\u0019\u0001\"\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\u0007\u0003'<\u0003\u0019\u00014\u0002\r\r|gNZ5h\u0011\u001d\t9n\na\u0001\u00033\f\u0001\u0002\\8dC2dun\u001a\t\u0005\u00037\f\t/\u0004\u0002\u0002^*\u0019\u0011q\u001c\u0017\u0002\u00071|w-\u0003\u0003\u0002d\u0006u'aC!cgR\u0014\u0018m\u0019;M_\u001e\fq\u0001\\8h\u001b>\u001c7.\u0006\u0002\u0002Z\u0002")
public class IsrExpirationTest {
    private final long ReplicaLagTimeMaxMs;
    private final int ReplicaFetchWaitMaxMs;
    private final long LeaderLogStartOffset;
    private long LeaderLogEndOffset = 20L;
    private final long LeaderLogHighWatermark;
    private final Properties overridingProps = new Properties();
    private final Seq<KafkaConfig> configs;
    private final String topic;
    private final MockTime time;
    private final Metrics metrics;
    private QuotaFactory.QuotaManagers quotaManager;
    private ReplicaManager replicaManager;
    private TestUtils.MockAlterIsrManager alterIsrManager;

    public long ReplicaLagTimeMaxMs() {
        return this.ReplicaLagTimeMaxMs;
    }

    public int ReplicaFetchWaitMaxMs() {
        return this.ReplicaFetchWaitMaxMs;
    }

    public long LeaderLogStartOffset() {
        return this.LeaderLogStartOffset;
    }

    public long LeaderLogEndOffset() {
        return this.LeaderLogEndOffset;
    }

    public void LeaderLogEndOffset_$eq(long x$1) {
        this.LeaderLogEndOffset = x$1;
    }

    public long LeaderLogHighWatermark() {
        return this.LeaderLogHighWatermark;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    public void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public TestUtils.MockAlterIsrManager alterIsrManager() {
        return this.alterIsrManager;
    }

    public void alterIsrManager_$eq(TestUtils.MockAlterIsrManager x$1) {
        this.alterIsrManager = x$1;
    }

    @BeforeEach
    public void setUp() {
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        Seq aliveBrokers = (Seq)this.configs().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.brokerId()), Seq$.MODULE$.canBuildFrom());
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn(aliveBrokers.map((Function1 & Serializable & scala.Serializable)id -> IsrExpirationTest.$anonfun$setUp$2(BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom())).anyTimes();
        aliveBrokers.foreach((Function1 & Serializable & scala.Serializable)id -> IsrExpirationTest.$anonfun$setUp$3(metadataCache, BoxesRunTime.unboxToInt((Object)id)));
        EasyMock.replay((Object[])new Object[]{metadataCache});
        this.alterIsrManager_$eq(TestUtils$.MODULE$.createAlterIsrManager());
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""));
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), (Option)None$.MODULE$, null, logManager, new AtomicBoolean(false), this.quotaManager(), new BrokerTopicStats(), (MetadataCache)MetadataCache$.MODULE$.zkMetadataCache(((KafkaConfig)this.configs().head()).brokerId(), MetadataCache$.MODULE$.zkMetadataCache$default$2()), new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size()), TierReplicaComponents$.MODULE$.EMPTY(), (Option)None$.MODULE$, (AlterIsrManager)this.alterIsrManager(), ReplicaManager$.MODULE$.$lessinit$greater$default$15()));
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.replicaManager()).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.shutdown(false);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    @Test
    public void testIsrExpirationForStuckFollowers() {
        AbstractLog log = this.logMock();
        Partition partition = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((TraversableOnce)this.configs().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.brokerId()), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition.remoteReplicas().foreach((Function1 & Serializable & scala.Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata(this.LeaderLogEndOffset() - 1L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), this.LeaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        this.time().sleep(this.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"Replica 1 should be out of sync");
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testIsrExpirationIfNoFetchRequestMade() {
        AbstractLog log = this.logMock();
        Partition partition = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((TraversableOnce)this.configs().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.brokerId()), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        this.time().sleep(this.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"Replica 1 should be out of sync");
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testIsrExpirationForSlowFollowers() {
        AbstractLog log = this.logMock();
        Partition partition = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((TraversableOnce)this.configs().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.brokerId()), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition.remoteReplicas().foreach((Function1 & Serializable & scala.Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata(this.LeaderLogEndOffset() - 2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), this.LeaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        this.time().sleep(75L);
        partition.remoteReplicas().foreach((Function1 & Serializable & scala.Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata(this.LeaderLogEndOffset() - 1L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), this.LeaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        this.time().sleep(75L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"Replica 1 should be out of sync");
        partition.remoteReplicas().foreach((Function1 & Serializable & scala.Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata(this.LeaderLogEndOffset(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), this.LeaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testIsrExpirationForCaughtUpFollowers() {
        AbstractLog log = this.logMock();
        Partition partition = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((TraversableOnce)this.configs().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.brokerId()), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition.remoteReplicas().foreach((Function1 & Serializable & scala.Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata(this.LeaderLogEndOffset(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), this.LeaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        this.time().sleep(this.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testIsrExpirationForCaughtUpFollowersWhenLeaderAppendsToLog() {
        AbstractLog log = this.logMock();
        Partition partition = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (KafkaConfig)this.configs().head(), log);
        Assertions.assertEquals((Object)((TraversableOnce)this.configs().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.brokerId()), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition.inSyncReplicaIds(), (String)"All replicas should be in ISR");
        partition.remoteReplicas().foreach((Function1 & Serializable & scala.Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata(this.LeaderLogEndOffset(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), this.LeaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        this.time().sleep(this.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        this.LeaderLogEndOffset_$eq(this.LeaderLogEndOffset() + 1L);
        partition.remoteReplicas().foreach((Function1 & Serializable & scala.Serializable)replica -> {
            replica.maybeResetLastCaughtUpTime(this.time().milliseconds(), this.LeaderLogEndOffset());
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"No replica should be out of sync");
        this.time().sleep(this.ReplicaLagTimeMaxMs() + 1L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition.getOutOfSyncReplicas(this.time().milliseconds(), Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs())), (String)"Replica 1 should be out of sync");
        EasyMock.verify((Object[])new Object[]{log});
    }

    private Partition getPartitionWithAllReplicasInIsr(String topic, int partitionId, KafkaConfig config, AbstractLog localLog) {
        int leaderId = config.brokerId();
        TopicPartition tp = new TopicPartition(topic, partitionId);
        Partition partition = this.replicaManager().createPartition(tp);
        partition.setLog(localLog, false);
        OffsetCheckpoints highWatermarkCheckpoints = (OffsetCheckpoints)EasyMock.createMock(OffsetCheckpoints.class);
        partition.makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setPartitionIndex(partitionId).setLeader(leaderId).setReplicas((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)this.configs().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.brokerId()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> IsrExpirationTest.$anonfun$getPartitionWithAllReplicasInIsr$2(BoxesRunTime.unboxToInt((Object)x)), Seq$.MODULE$.canBuildFrom())).toList()).asJava()).setIsr((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)this.configs().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.brokerId()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> IsrExpirationTest.$anonfun$getPartitionWithAllReplicasInIsr$4(BoxesRunTime.unboxToInt((Object)x)), Seq$.MODULE$.canBuildFrom())).toList()).asJava()), highWatermarkCheckpoints, (Option)None$.MODULE$);
        return partition;
    }

    /*
     * WARNING - void declaration
     */
    private AbstractLog logMock() {
        void var1_1;
        AbstractLog log = (AbstractLog)EasyMock.createMock(AbstractLog.class);
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.$lessinit$greater$default$2());
        EasyMock.expect((Object)log.dir()).andReturn((Object)TestUtils$.MODULE$.tempDir()).anyTimes();
        log.maybeAssignEpochStartOffset(0, this.LeaderLogEndOffset());
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.expect((Object)log.maybeIncrementHighWatermark((LogOffsetMetadata)EasyMock.anyObject())).andReturn((Object)None$.MODULE$).once();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)this.LeaderLogStartOffset())).anyTimes();
        EasyMock.expect((Object)log.logEndOffsetMetadata()).andAnswer(() -> new LogOffsetMetadata(this.LeaderLogEndOffset(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andAnswer(() -> BoxesRunTime.boxToLong((long)this.LeaderLogEndOffset())).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).andReturn((Object)BoxesRunTime.boxToLong((long)this.LeaderLogHighWatermark())).anyTimes();
        EasyMock.expect((Object)log.config()).andReturn((Object)logConfig).anyTimes();
        log.setLogOffsetsListener((LogOffsetsListener)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)log.topicId()).andReturn((Object)None$.MODULE$).anyTimes();
        EasyMock.replay((Object[])new Object[]{log});
        return var1_1;
    }

    public static final /* synthetic */ BrokerMetadata $anonfun$setUp$2(int id) {
        return new BrokerMetadata(id, (Option)None$.MODULE$);
    }

    public static final /* synthetic */ IExpectationSetters $anonfun$setUp$3(MetadataCache metadataCache$1, int id) {
        return EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)metadataCache$1.hasAliveBroker(id))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
    }

    public static final /* synthetic */ Integer $anonfun$getPartitionWithAllReplicasInIsr$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$getPartitionWithAllReplicasInIsr$4(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public IsrExpirationTest() {
        this.ReplicaLagTimeMaxMs = 100L;
        this.ReplicaFetchWaitMaxMs = 100;
        this.LeaderLogStartOffset = 0L;
        this.LeaderLogHighWatermark = 20L;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), Long.toString(this.ReplicaLagTimeMaxMs()));
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), Integer.toString(this.ReplicaFetchWaitMaxMs()));
        this.configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
        this.topic = "foo";
        this.time = new MockTime();
        this.metrics = new Metrics();
    }
}

