/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Meter;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.server.ApiRequestHandler;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaRequestHandler$;
import kafka.server.RequestLocal;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestLogFilter;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogAction;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000193A\u0001C\u0005\u0001\u001d!)Q\u0003\u0001C\u0001-!9\u0011\u0004\u0001b\u0001\n\u0003Q\u0002B\u0002\u0015\u0001A\u0003%1\u0004C\u0003*\u0001\u0011\u0005!\u0006C\u0003:\u0001\u0011\u0005!\u0006C\u0003<\u0001\u0011%A\bC\u0003C\u0001\u0011%1IA\fLC\u001a\\\u0017MU3rk\u0016\u001cH\u000fS1oI2,'\u000fV3ti*\u0011!bC\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00031\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001fA\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\f\u0011\u0005a\u0001Q\"A\u0005\u0002\tQLW.Z\u000b\u00027A\u0011ADJ\u0007\u0002;)\u0011adH\u0001\u0006kRLGn\u001d\u0006\u0003A\u0005\naaY8n[>t'B\u0001\u0007#\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\n\u0005\u001dj\"\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002'Q,7\u000f\u001e*fcV,7\u000f\u001e$jYR,'/\u001a3\u0015\u0003-\u0002\"\u0001\u0005\u0017\n\u00055\n\"\u0001B+oSRD#\u0001B\u0018\u0011\u0005A:T\"A\u0019\u000b\u0005I\u001a\u0014aA1qS*\u0011A'N\u0001\bUV\u0004\u0018\u000e^3s\u0015\t1D%A\u0003kk:LG/\u0003\u00029c\t!A+Z:u\u0003Y!Xm\u001d;SKF,Xm\u001d;O_R4\u0015\u000e\u001c;fe\u0016$\u0007FA\u00030\u0003Q!Xm\u001d;SKF,Xm\u001d;GS2$XM]5oOR\u00111&\u0010\u0005\u0006}\u0019\u0001\raP\u0001\u0012SN\u0014V-];fgR4\u0015\u000e\u001c;fe\u0016$\u0007C\u0001\tA\u0013\t\t\u0015CA\u0004C_>dW-\u00198\u0002!\t,\u0018\u000e\u001c3UKN$(+Z9vKN$H#\u0001#\u0011\u0005\u0015[eB\u0001$J\u001b\u00059%B\u0001%\f\u0003\u001dqW\r^<pe.L!AS$\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&\u0011A*\u0014\u0002\b%\u0016\fX/Z:u\u0015\tQu\t")
public class KafkaRequestHandlerTest {
    private final MockTime time = new MockTime();

    public MockTime time() {
        return this.time;
    }

    @Test
    public void testRequestFiltered() {
        this.testRequestFiltering(true);
    }

    @Test
    public void testRequestNotFiltered() {
        this.testRequestFiltering(false);
    }

    private void testRequestFiltering(boolean isRequestFiltered) {
        Meter aggregateIdleMeter = (Meter)Mockito.mock(Meter.class);
        RequestChannel requestChannel = (RequestChannel)Mockito.mock(RequestChannel.class);
        RequestLogFilter requestLogFilter = (RequestLogFilter)Mockito.mock(RequestLogFilter.class);
        ApiRequestHandler apiHandler = (ApiRequestHandler)Mockito.mock(ApiRequestHandler.class);
        KafkaRequestHandler handler = new KafkaRequestHandler(0, "cluster", 0, aggregateIdleMeter, new AtomicInteger(1), requestChannel, requestLogFilter, apiHandler, (Time)this.time(), KafkaRequestHandler$.MODULE$.$lessinit$greater$default$10());
        RequestChannel.Request request = this.buildTestRequest();
        LogAction logAction = isRequestFiltered ? LogAction.LOGGED : LogAction.NOT_LOGGED;
        Mockito.when((Object)requestChannel.receiveRequest(0L)).thenReturn((Object)request);
        Mockito.when((Object)requestLogFilter.processRequest((RequestContext)ArgumentMatchers.eq((Object)request.context()), ArgumentMatchers.anyLong())).thenReturn((Object)logAction);
        handler.poll(0);
        ((ApiRequestHandler)Mockito.verify((Object)apiHandler)).handle((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (RequestLocal)ArgumentMatchers.any());
        Assertions.assertEquals((Object)logAction, (Object)request.logAction());
    }

    private RequestChannel.Request buildTestRequest() {
        RequestHeader requestHeader = new RequestHeader(ApiKeys.METADATA, ApiKeys.METADATA.latestVersion(), "clientId", 1379);
        RequestContext requestContext = new RequestContext(requestHeader, "connectionId", InetAddress.getLoopbackAddress(), KafkaPrincipal.ANONYMOUS, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false);
        ByteBuffer buffer = ((MetadataRequest)MetadataRequest.Builder.allTopics().build()).serialize();
        RequestChannel.Metrics requestMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
        return new RequestChannel.Request(0, requestContext, this.time().nanoseconds(), MemoryPool.NONE, buffer, requestMetrics, (Option)None$.MODULE$, RequestChannel.Request$.MODULE$.$lessinit$greater$default$8());
    }
}

