/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.DefaultAlterIsrManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.ZkIsrManager;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.utils.Exit;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4A\u0001E\t\u0001-!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001b\u0001\n\u0003\u0011\u0003BB\u0018\u0001A\u0003%1\u0005C\u00031\u0001\u0011\u0005\u0013\u0007C\u0003F\u0001\u0011\u0005\u0013\u0007C\u0003K\u0001\u0011\u0005\u0011\u0007C\u0003P\u0001\u0011\u0005\u0011\u0007C\u0003R\u0001\u0011%!\u000bC\u0003d\u0001\u0011\u0005\u0011\u0007C\u0003f\u0001\u0011\u0005\u0011\u0007C\u0003h\u0001\u0011\u0005\u0011\u0007C\u0003j\u0001\u0011\u0005\u0011\u0007C\u0003l\u0001\u0011\u0005\u0011\u0007C\u0003n\u0001\u0011\u0005\u0011\u0007C\u0003p\u0001\u0011\u0005\u0001OA\bLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0015\t\u00112#\u0001\u0004tKJ4XM\u001d\u0006\u0002)\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\tQ2#\u0001\u0002{W&\u0011A$\u0007\u0002\u00155>|7*Z3qKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005\t\u0012AB3ySR,G-F\u0001$!\t!S&D\u0001&\u0015\t1s%\u0001\u0004bi>l\u0017n\u0019\u0006\u0003Q%\n!bY8oGV\u0014(/\u001a8u\u0015\tQ3&\u0001\u0003vi&d'\"\u0001\u0017\u0002\t)\fg/Y\u0005\u0003]\u0015\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017aB3ySR,G\rI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002eA\u00111GN\u0007\u0002i)\tQ'A\u0003tG\u0006d\u0017-\u0003\u00028i\t!QK\\5uQ\t!\u0011\b\u0005\u0002;\u00076\t1H\u0003\u0002={\u0005\u0019\u0011\r]5\u000b\u0005yz\u0014a\u00026va&$XM\u001d\u0006\u0003\u0001\u0006\u000bQA[;oSRT\u0011AQ\u0001\u0004_J<\u0017B\u0001#<\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u0012Qa\u0012\t\u0003u!K!!S\u001e\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017\u0001\u0004;fgR\u001c\u0006.\u001e;e_^t\u0007F\u0001\u0004M!\tQT*\u0003\u0002Ow\t!A+Z:u\u0003\u001d\"Xm\u001d;Uo>\u001cuN\\:fGV$\u0018N^3TQV$Hm\\<o\u0007\u0006dG.\u0012=jiR;\u0018nY3)\u0005\u001da\u0015aC7fiJL7MV1mk\u0016$\"a\u0015,\u0011\u0005M\"\u0016BA+5\u0005\u0011auN\\4\t\u000b]C\u0001\u0019\u0001-\u0002\t9\fW.\u001a\t\u00033\u0002t!A\u00170\u0011\u0005m#T\"\u0001/\u000b\u0005u+\u0012A\u0002\u001fs_>$h(\u0003\u0002`i\u00051\u0001K]3eK\u001aL!!\u00192\u0003\rM#(/\u001b8h\u0015\tyF'\u0001\u0015uKN$\u0018\t\u001c:fC\u0012L(+Z4jgR,'/\u001a3BIZ,'\u000f^5tK\u0012d\u0015n\u001d;f]\u0016\u00148\u000f\u000b\u0002\n\u0019\u0006AC/Z:u\u0007J,\u0017\r^3t!J|\u0007/\u001a:[WRc7oQ8oM&<w\u000b[3o\t&\u001c\u0018M\u00197fI\"\u0012!\u0002T\u0001+i\u0016\u001cHo\u0011:fCR,7\u000f\u0015:pa\u0016\u0014(l\u001b+mg\u000e{gNZ5h/&$\b\u000e\u0016:vKZ\u000bG.^3tQ\tYA*\u0001\u001auKN$8I]3bi\u0016\u001c\bK]8qKJT6\u000e\u00167t\u0007>tg-[4XSRDg)\u00197tK\u0006sG\rT5tiZ\u000bG.^3tQ\taA*\u0001\tuKN$(l[%te6\u000bg.Y4fe\"\u0012Q\u0002T\u0001\u0014i\u0016\u001cH/\u00117uKJL5O]'b]\u0006<WM\u001d\u0015\u0003\u001d1\u000bAb\u0019:fCR,7+\u001a:wKJ$B!\u001d;zwB\u0011\u0001E]\u0005\u0003gF\u00111bS1gW\u0006\u001cVM\u001d<fe\")Qo\u0004a\u0001m\u00061an\u001c3f\u0013\u0012\u0004\"aM<\n\u0005a$$aA%oi\")!p\u0004a\u00011\u0006A\u0001n\\:u\u001d\u0006lW\rC\u0003}\u001f\u0001\u0007a/\u0001\u0003q_J$\b")
public class KafkaServerTest
extends ZooKeeperTestHarness {
    private final AtomicBoolean exited = new AtomicBoolean(false);

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp() {
        KafkaServer$.MODULE$.externalShutdownInitiations().set(0L);
        Exit.setExitProcedure((x$1, x$2) -> {
            this.exited().set(true);
            throw new Exception();
        });
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Exit.resetExitProcedure();
        KafkaServer$.MODULE$.externalShutdownInitiations().set(0L);
    }

    @Test
    public void testShutdown() {
        new KafkaServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
        Assertions.assertFalse((boolean)this.exited().get(), (String)"Exit produce should not have been executed yet");
        KafkaServer$.MODULE$.initiateShutdown().join();
        Assertions.assertTrue((boolean)this.exited().get(), (String)"Exit produce should have been executed");
        Assertions.assertEquals((long)1L, (long)KafkaServer$.MODULE$.externalShutdownInitiations().get());
        Assertions.assertEquals((long)1L, (long)this.metricValue("ExternalShutdownInitiations"));
    }

    @Test
    public void testTwoConsecutiveShutdownCallExitTwice() {
        new KafkaServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), KafkaServer$.MODULE$.$lessinit$greater$default$2(), KafkaServer$.MODULE$.$lessinit$greater$default$3(), KafkaServer$.MODULE$.$lessinit$greater$default$4());
        Assertions.assertFalse((boolean)this.exited().get(), (String)"Exit produce should not have been executed yet");
        Thread th1 = KafkaServer$.MODULE$.initiateShutdown();
        Thread th2 = KafkaServer$.MODULE$.initiateShutdown();
        th1.join();
        th2.join();
        Assertions.assertTrue((boolean)this.exited().get(), (String)"Exit produce should have been executed");
        Assertions.assertEquals((long)2L, (long)KafkaServer$.MODULE$.externalShutdownInitiations().get());
        Assertions.assertEquals((long)2L, (long)this.metricValue("ExternalShutdownInitiations"));
    }

    private long metricValue(String name) {
        return BoxesRunTime.unboxToLong((Object)((Gauge)((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTest.$anonfun$metricValue$1(name, x$3)))).values().headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception(new StringBuilder(22).append("Could not find metric ").append(name).toString());
        })).value());
    }

    @Test
    public void testAlreadyRegisteredAdvertisedListeners() {
        KafkaServer server1 = this.createServer(1, "myhost", TestUtils$.MODULE$.RandomPort());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.createServer(2, "myhost", TestUtils$.MODULE$.boundPort(server1, TestUtils$.MODULE$.boundPort$default$2())));
        KafkaServer server2 = this.createServer(2, "myhost", TestUtils$.MODULE$.RandomPort());
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)new .colon.colon((Object)server2, (List)Nil$.MODULE$)));
    }

    @Test
    public void testCreatesProperZkTlsConfigWhenDisabled() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        props.put(KafkaConfig$.MODULE$.ZkSslClientEnableProp(), "false");
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig$default$2());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)propName -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWhenDisabled$1(zkClientConfig, propName);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreatesProperZkTlsConfigWithTrueValues() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        String someValue = "some_value";
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)kafkaProp -> props.put(kafkaProp, KafkaServerTest.kafkaConfigValueToSet$1(kafkaProp, someValue)));
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig$default$2());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)kafkaProp -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWithTrueValues$2(zkClientConfig, someValue, kafkaProp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreatesProperZkTlsConfigWithFalseAndListValues() {
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.ZkConnectProp(), this.zkConnect());
        String someValue = "some_value";
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)kafkaProp -> props.put(kafkaProp, KafkaServerTest.kafkaConfigValueToSet$2(kafkaProp, someValue)));
        ZKClientConfig zkClientConfig = KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig(KafkaConfig$.MODULE$.fromProps(props), KafkaServer$.MODULE$.zkClientConfigFromKafkaConfig$default$2());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable & scala.Serializable)kafkaProp -> {
            KafkaServerTest.$anonfun$testCreatesProperZkTlsConfigWithFalseAndListValues$2(zkClientConfig, someValue, kafkaProp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testZkIsrManager() {
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).head();
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.7-IV1");
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2());
        if (!(server.replicaManager().alterIsrManager() instanceof ZkIsrManager)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Should use ZK for ISR manager in versions before 2.7-IV2");
        }
        server.shutdown();
    }

    @Test
    public void testAlterIsrManager() {
        Properties props = (Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).head();
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), ApiVersion$.MODULE$.latestVersion().toString());
        KafkaServer server = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2());
        if (!(server.replicaManager().alterIsrManager() instanceof DefaultAlterIsrManager)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Should use AlterIsr for ISR manager in versions after 2.7-IV2");
        }
        server.shutdown();
    }

    public KafkaServer createServer(int nodeId, String hostName, int port) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(nodeId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.AdvertisedListenersProp(), new StringBuilder(13).append("PLAINTEXT://").append(hostName).append(":").append(port).toString());
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        return TestUtils$.MODULE$.createServer(kafkaConfig, TestUtils$.MODULE$.createServer$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$metricValue$1(String name$1, Tuple2 x$3) {
        String string = ((MetricName)x$3._1()).getName();
        return !(string != null ? !string.equals(name$1) : name$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWhenDisabled$1(ZKClientConfig zkClientConfig$1, String propName) {
        Assertions.assertNull((Object)zkClientConfig$1.getProperty(propName));
    }

    private static final String kafkaConfigValueToSet$1(String kafkaProp, String someValue$1) {
        String string;
        boolean bl;
        String string2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null);
            }
        }
        if (bl) {
            string = "true";
        } else {
            String string5 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            string = !(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null) ? "HTTPS" : someValue$1;
        }
        return string;
    }

    private static final String zkClientValueToExpect$1(String kafkaProp, String someValue$1) {
        String string;
        boolean bl;
        String string2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            bl = true;
        } else {
            String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null);
            }
        }
        if (bl) {
            string = "true";
        } else {
            String string5 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            string = !(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null) ? "true" : someValue$1;
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWithTrueValues$2(ZKClientConfig zkClientConfig$2, String someValue$1, String kafkaProp) {
        Assertions.assertEquals((Object)KafkaServerTest.zkClientValueToExpect$1(kafkaProp, someValue$1), (Object)zkClientConfig$2.getProperty((String)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().apply((Object)kafkaProp)));
    }

    private static final String kafkaConfigValueToSet$2(String kafkaProp, String someValue$2) {
        String string;
        String string2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            string = "true";
        } else {
            boolean bl;
            String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null);
            }
            if (bl) {
                string = "false";
            } else {
                String string5 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
                if (!(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null)) {
                    string = "";
                } else {
                    boolean bl2;
                    String string6 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
                    if (!(string6 != null ? !string6.equals(kafkaProp) : kafkaProp != null)) {
                        bl2 = true;
                    } else {
                        String string7 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
                        bl2 = !(string7 != null ? !string7.equals(kafkaProp) : kafkaProp != null);
                    }
                    string = bl2 ? "A,B" : someValue$2;
                }
            }
        }
        return string;
    }

    private static final String zkClientValueToExpect$2(String kafkaProp, String someValue$2) {
        String string;
        String string2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string2 != null ? !string2.equals(kafkaProp) : kafkaProp != null)) {
            string = "true";
        } else {
            boolean bl;
            String string3 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string3 != null ? !string3.equals(kafkaProp) : kafkaProp != null)) {
                bl = true;
            } else {
                String string4 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string4 != null ? !string4.equals(kafkaProp) : kafkaProp != null);
            }
            if (bl) {
                string = "false";
            } else {
                String string5 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
                if (!(string5 != null ? !string5.equals(kafkaProp) : kafkaProp != null)) {
                    string = "false";
                } else {
                    boolean bl2;
                    String string6 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
                    if (!(string6 != null ? !string6.equals(kafkaProp) : kafkaProp != null)) {
                        bl2 = true;
                    } else {
                        String string7 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
                        bl2 = !(string7 != null ? !string7.equals(kafkaProp) : kafkaProp != null);
                    }
                    string = bl2 ? "A,B" : someValue$2;
                }
            }
        }
        return string;
    }

    public static final /* synthetic */ void $anonfun$testCreatesProperZkTlsConfigWithFalseAndListValues$2(ZKClientConfig zkClientConfig$3, String someValue$2, String kafkaProp) {
        Assertions.assertEquals((Object)KafkaServerTest.zkClientValueToExpect$2(kafkaProp, someValue$2), (Object)zkClientConfig$3.getProperty((String)KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().apply((Object)kafkaProp)));
    }
}

