/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.stream.Stream;
import kafka.api.LeaderAndIsr$;
import kafka.common.TenantHelpers;
import kafka.server.MetadataCache;
import kafka.server.MetadataCache$;
import kafka.server.ZkMetadataCache;
import kafka.server.metadata.KRaftMetadataCache;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.metadata.RemoveTopicRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.metadata.BrokerRegistration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;

public final class MetadataCacheTest$ {
    public static MetadataCacheTest$ MODULE$;

    static {
        new MetadataCacheTest$();
    }

    public Stream<MetadataCache> zkCacheProvider() {
        return Stream.of(MetadataCache$.MODULE$.zkMetadataCache(1, MetadataCache$.MODULE$.zkMetadataCache$default$2()));
    }

    public Stream<MetadataCache> cacheProvider() {
        return Stream.of((Object[])new MetadataCache[]{MetadataCache$.MODULE$.zkMetadataCache(1, MetadataCache$.MODULE$.zkMetadataCache$default$2()), MetadataCache$.MODULE$.kRaftMetadataCache(1)});
    }

    public Stream<MetadataCache> multiTenantCacheProvider() {
        return Stream.of((Object[])new MetadataCache[]{MetadataCache$.MODULE$.zkMetadataCache(1, true), MetadataCache$.MODULE$.kRaftMetadataCache(1)});
    }

    public void updateCache(MetadataCache cache, UpdateMetadataRequest request) {
        if (cache instanceof ZkMetadataCache) {
            ((ZkMetadataCache)cache).updateMetadata(0, request);
            return;
        }
        if (cache instanceof KRaftMetadataCache) {
            KRaftMetadataCache kRaftMetadataCache = (KRaftMetadataCache)cache;
            MetadataImage image = kRaftMetadataCache.currentImage();
            MetadataImage partialImage = new MetadataImage(image.features(), ClusterImage.EMPTY, image.topics(), image.configs(), image.clientQuotas());
            MetadataDelta delta = new MetadataDelta(partialImage, TenantHelpers.NAME_TO_TENANT_CALLBACK);
            ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(request.liveBrokers().iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)brokerInfo -> {
                delta.replay(MetadataCacheTest$.toRecord$1(brokerInfo, image));
                return BoxedUnit.UNIT;
            });
            request.topicStates().forEach(topic -> MetadataCacheTest$.toRecords$1(topic).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                delta.replay(x$1);
                return BoxedUnit.UNIT;
            }));
            kRaftMetadataCache.setImage(delta.apply());
            return;
        }
        throw new RuntimeException("Unsupported cache type");
    }

    private static final RegisterBrokerRecord toRecord$1(UpdateMetadataRequestData.UpdateMetadataBroker broker, MetadataImage image$1) {
        long l;
        Uuid uuid;
        boolean bl;
        RegisterBrokerRecord.BrokerEndpointCollection endpoints = new RegisterBrokerRecord.BrokerEndpointCollection();
        broker.endpoints().forEach(e -> endpoints.add((ImplicitLinkedHashCollection.Element)new RegisterBrokerRecord.BrokerEndpoint().setName(e.listener()).setHost(e.host()).setPort(e.port()).setSecurityProtocol(e.securityProtocol())));
        Option prevBroker = Option$.MODULE$.apply((Object)image$1.cluster().broker(broker.id()));
        if (None$.MODULE$.equals(prevBroker)) {
            bl = false;
            uuid = Uuid.ZERO_UUID;
            l = 0L;
        } else if (prevBroker instanceof Some) {
            BrokerRegistration b = (BrokerRegistration)((Some)prevBroker).value();
            bl = b.fenced();
            uuid = b.incarnationId();
            l = b.epoch();
        } else {
            throw new MatchError((Object)prevBroker);
        }
        return new RegisterBrokerRecord().setBrokerId(broker.id()).setBrokerEpoch(l).setIncarnationId(uuid).setEndPoints(endpoints).setRack(broker.rack()).setFenced(bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final Seq toRecords$1(UpdateMetadataRequestData.UpdateMetadataTopicState topic) {
        void var1_1;
        ArrayBuffer results = new ArrayBuffer();
        HashSet deletedTopicIds = new HashSet();
        results.$plus$eq((Object)new TopicRecord().setName(topic.topicName()).setTopicId(topic.topicId()));
        topic.partitionStates().forEach(partition -> {
            if (partition.leader() == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                if (deletedTopicIds.add(topic.topicId())) {
                    results.$plus$eq((Object)new RemoveTopicRecord().setTopicId(topic.topicId()));
                    return;
                }
            } else {
                results.$plus$eq((Object)new PartitionRecord().setPartitionId(partition.partitionIndex()).setTopicId(topic.topicId()).setReplicas(partition.replicas()).setIsr(partition.isr()).setRemovingReplicas(Collections.emptyList()).setAddingReplicas(Collections.emptyList()).setLeader(partition.leader()).setLeaderEpoch(partition.leaderEpoch()).setPartitionEpoch(partition.zkVersion()));
            }
        });
        return var1_1;
    }

    private MetadataCacheTest$() {
        MODULE$ = this;
    }
}

