/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.MockTopicCreatePolicy;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001m4A!\u0003\u0006\u0001\u001f!)A\u0003\u0001C\u0001+!)q\u0003\u0001C!1!)\u0011\u0006\u0001C!U!)\u0001\b\u0001C\u0001U!)Q\b\u0001C\u0005}!)\u0011\f\u0001C\u00055\")Q\f\u0001C\u0005=\"9q\u000eAI\u0001\n\u0013\u0001(!H'fi\u0006$\u0017\r^1SKF,Xm\u001d;XSRD\u0007k\u001c7jGf$Vm\u001d;\u000b\u0005-a\u0011AB:feZ,'OC\u0001\u000e\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0006\n\u0005MQ!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u00051\u0002CA\t\u0001\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000f\u0006\u0002\u001a?A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t!QK\\5u\u0011\u0015\u0001#\u00011\u0001\"\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0003E\u001dj\u0011a\t\u0006\u0003I\u0015\nA!\u001e;jY*\ta%\u0001\u0003kCZ\f\u0017B\u0001\u0015$\u0005)\u0001&o\u001c9feRLWm]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u00023!\u00121\u0001\f\t\u0003[Yj\u0011A\f\u0006\u0003_A\n1!\u00199j\u0015\t\t$'A\u0004kkBLG/\u001a:\u000b\u0005M\"\u0014!\u00026v]&$(\"A\u001b\u0002\u0007=\u0014x-\u0003\u00028]\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002QQ,7\u000f^'fi\u0006$\u0017\r^1XSRD\u0017)\u001e;p\u0007J,\u0017\r^3SKN\u0004Xm\u0019;t!>d\u0017nY=)\u0005\u0011Q\u0004CA\u0017<\u0013\tadF\u0001\u0003UKN$\u0018a\b<fe&4\u0017pU;dG\u0016\u001c8OZ;m\u0003V$xn\u0011:fCR,Gk\u001c9jGR\u0019\u0011d\u0010'\t\u000b\u0001+\u0001\u0019A!\u0002!\u0005,Ho\\\"sK\u0006$X\r\u001a+pa&\u001c\u0007C\u0001\"J\u001d\t\u0019u\t\u0005\u0002E75\tQI\u0003\u0002G\u001d\u00051AH]8pizJ!\u0001S\u000e\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u0011nAQ!T\u0003A\u00029\u000b\u0001B]3ta>t7/\u001a\t\u0003\u001f^k\u0011\u0001\u0015\u0006\u0003#J\u000b\u0001B]3rk\u0016\u001cHo\u001d\u0006\u0003'R\u000baaY8n[>t'BA\u0007V\u0015\t1F'\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u00031B\u0013\u0001#T3uC\u0012\fG/\u0019*fgB|gn]3\u0002CY,'/\u001b4z+:\u001cXoY2fgN4W\u000f\\!vi>\u001c%/Z1uKR{\u0007/[2\u0015\u0007eYF\fC\u0003A\r\u0001\u0007\u0011\tC\u0003N\r\u0001\u0007a*A\ntK:$W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fF\u0002O?\u0012DQ\u0001Y\u0004A\u0002\u0005\fqA]3rk\u0016\u001cH\u000f\u0005\u0002PE&\u00111\r\u0015\u0002\u0010\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\"9Qm\u0002I\u0001\u0002\u00041\u0017a\u00033fgRLg.\u0019;j_:\u00042AG4j\u0013\tA7D\u0001\u0004PaRLwN\u001c\t\u0003U6l\u0011a\u001b\u0006\u0003Y2\tqA\\3uo>\u00148.\u0003\u0002oW\na1k\\2lKR\u001cVM\u001d<fe\u0006i2/\u001a8e\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0012\"WMZ1vYR$#'F\u0001rU\t1'oK\u0001t!\t!\u00180D\u0001v\u0015\t1x/A\u0005v]\u000eDWmY6fI*\u0011\u0001pG\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001>v\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class MetadataRequestWithPolicyTest
extends BaseRequestTest {
    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "2");
        properties.setProperty(KafkaConfig$.MODULE$.RackProp(), new StringBuilder(5).append("rack/").append(properties.getProperty(KafkaConfig$.MODULE$.BrokerIdProp())).toString());
        properties.setProperty(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), MockTopicCreatePolicy.class.getName());
    }

    @Override
    @BeforeEach
    public void setUp() {
        this.doSetup(false);
    }

    @Test
    public void testMetadataWithAutoCreateRespectsPolicy() {
        String testAllowedTopic = "random-auto-created-topic";
        MetadataResponse responseForValidCreationPolicy = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)testAllowedTopic, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        this.verifySuccessfulAutoCreateTopic(testAllowedTopic, responseForValidCreationPolicy);
        String testDisallowedTopic = "disallowed-topic";
        MetadataResponse responseForInvalidCreationPolicy = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)testDisallowedTopic, (List)Nil$.MODULE$)).asJava(), true).build(), this.sendMetadataRequest$default$2());
        this.verifyUnsuccessfulAutoCreateTopic(testDisallowedTopic, responseForInvalidCreationPolicy);
    }

    private void verifySuccessfulAutoCreateTopic(String autoCreatedTopic, MetadataResponse response) {
        Assertions.assertEquals((Object)Errors.LEADER_NOT_AVAILABLE, response.errors().get(autoCreatedTopic));
        Assertions.assertEquals((Object)new Some((Object)((KafkaServer)this.servers().head()).config().numPartitions()), (Object)this.zkClient().getTopicPartitionCount(autoCreatedTopic));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(((KafkaServer)this.servers().head()).config().numPartitions())).foreach((Function1 & Serializable & scala.Serializable)i -> TestUtils$.MODULE$.waitForPartitionMetadata((Seq<KafkaServer>)this.servers(), autoCreatedTopic, BoxesRunTime.unboxToInt((Object)i), TestUtils$.MODULE$.waitForPartitionMetadata$default$4()));
    }

    private void verifyUnsuccessfulAutoCreateTopic(String autoCreatedTopic, MetadataResponse response) {
        Assertions.assertEquals((Object)Errors.TOPIC_AUTHORIZATION_FAILED, response.errors().get(autoCreatedTopic));
        Assertions.assertFalse((boolean)this.zkClient().topicExists(autoCreatedTopic));
    }

    private MetadataResponse sendMetadataRequest(MetadataRequest request, Option<SocketServer> destination) {
        return (MetadataResponse)this.connectAndReceive((AbstractRequest)request, (SocketServer)destination.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.anySocketServer()), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private Option<SocketServer> sendMetadataRequest$default$2() {
        return None$.MODULE$;
    }
}

