/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.log.LogConfig$;
import kafka.server.ConfluentObserverTest;
import kafka.server.ConfluentObserverTest$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00014A\u0001E\t\u0001-!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001a\u0001\n\u0003\u0011\u0003b\u0002\u0018\u0001\u0001\u0004%\ta\f\u0005\u0007m\u0001\u0001\u000b\u0015B\u0012\t\u000f]\u0002!\u0019!C\u0001q!1A\b\u0001Q\u0001\neBq!\u0010\u0001C\u0002\u0013\u0005\u0001\b\u0003\u0004?\u0001\u0001\u0006I!\u000f\u0005\u0006\u007f\u0001!\t\u0005\u0011\u0005\u0006\u001d\u0002!\t\u0005\u0011\u0005\u0006'\u0002!\t\u0001\u0011\u0005\u00061\u0002!\t\u0001\u0011\u0005\u00065\u0002!\t\u0001\u0011\u0005\u00069\u0002!\t\u0001\u0011\u0005\u0006=\u0002!\t\u0001\u0011\u0002\u001a\u001f\n\u001cXM\u001d<fe\u000e{W\u000e]1uS\nLG.\u001b;z)\u0016\u001cHO\u0003\u0002\u0013'\u000511/\u001a:wKJT\u0011\u0001F\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b'\u0005\u0011!p[\u0005\u00039e\u0011ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\u0012\u0003\u001d\u0019XM\u001d<feN,\u0012a\t\t\u0004I%ZS\"A\u0013\u000b\u0005\u0019:\u0013AC2pY2,7\r^5p]*\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+K\t\u00191+Z9\u0011\u0005\u0001b\u0013BA\u0017\u0012\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003aQ\u0002\"!\r\u001a\u000e\u0003\u001dJ!aM\u0014\u0003\tUs\u0017\u000e\u001e\u0005\bk\r\t\t\u00111\u0001$\u0003\rAH%M\u0001\tg\u0016\u0014h/\u001a:tA\u00059!M]8lKJ\fT#A\u001d\u0011\u0005ER\u0014BA\u001e(\u0005\rIe\u000e^\u0001\tEJ|7.\u001a:2A\u00059!M]8lKJ\u0014\u0014\u0001\u00032s_.,'O\r\u0011\u0002\u000bM,G/\u00169\u0015\u0003AB#!\u0003\"\u0011\u0005\rcU\"\u0001#\u000b\u0005\u00153\u0015aA1qS*\u0011q\tS\u0001\bUV\u0004\u0018\u000e^3s\u0015\tI%*A\u0003kk:LGOC\u0001L\u0003\ry'oZ\u0005\u0003\u001b\u0012\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007F\u0001\u0006Q!\t\u0019\u0015+\u0003\u0002S\t\nI\u0011I\u001a;fe\u0016\u000b7\r[\u00015i\u0016\u001cHoQ1o+N,'+\u001a9mS\u000e\f\u0007\u000b\\1dK6,g\u000e^\"p]N$(/Y5oi^KG\u000f[8vi>\u00137/\u001a:wKJ\u001c\bFA\u0006V!\t\u0019e+\u0003\u0002X\t\n!A+Z:u\u0003}!Xm\u001d;DC:\u0014V-Y:tS\u001etGk\\#naRLxJY:feZ,'o\u001d\u0015\u0003\u0019U\u000bA\u0007^3ti\u000e\u000bgN\\8u+N,'+\u001a9mS\u000e\f\u0007\u000b\\1dK6,g\u000e^\"p]N$(/Y5oi^KG\u000f[(cg\u0016\u0014h/\u001a:tQ\tiQ+A\u000fuKN$8)\u00198o_R\u0014V-Y:tS\u001etGk\\(cg\u0016\u0014h/\u001a:tQ\tqQ+A\u0018uKN$8)\u00198o_R,e.\u00192mK>\u00137/\u001a:wKJ\u001cH\u000b\u001b:pk\u001eD\u0017\t\u001c;fe\u000e{gNZ5h\u0003BK5\u000f\u000b\u0002\u0010+\u0002")
public class ObserverCompatibilityTest
extends ZooKeeperTestHarness {
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private final int broker1;
    private final int broker2;

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int broker1() {
        return this.broker1;
    }

    public int broker2() {
        return this.broker2;
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        scala.collection.immutable.Map rack = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker1())), (Object)"a"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker2())), (Object)"b")}));
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17());
        this.servers_$eq((Seq<KafkaServer>)((Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)config -> {
            config.setProperty(KafkaConfig$.MODULE$.RackProp(), (String)rack.apply((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(config.getProperty(KafkaConfig$.MODULE$.BrokerIdProp()))).toInt())));
            config.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.3");
            return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
        }, Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCanUseReplicaPlacementConstraintWithoutObservers() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ObserverCompatibilityTest.$anonfun$testCanUseReplicaPlacementConstraintWithoutObservers$1((AdminClient)resource_resource);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCanReassignToEmptyObservers() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ObserverCompatibilityTest.$anonfun$testCanReassignToEmptyObservers$1((AdminClient)resource_resource);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCannotUseReplicaPlacementConstraintWithObservers() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ObserverCompatibilityTest.$anonfun$testCannotUseReplicaPlacementConstraintWithObservers$1((AdminClient)resource_resource);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCannotReassignToObservers() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ObserverCompatibilityTest.$anonfun$testCannotReassignToObservers$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCannotEnableObserversThroughAlterConfigAPIs() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(ConfluentObserverTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            ObserverCompatibilityTest.$anonfun$testCannotEnableObserversThroughAlterConfigAPIs$1((AdminClient)resource_resource);
        }
        finally {
            resource_resource.close();
        }
    }

    public static final /* synthetic */ Void $anonfun$testCanUseReplicaPlacementConstraintWithoutObservers$1(AdminClient client) {
        String topic = "observer-topic";
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new ConfluentObserverTest.BasicConstraint(1, "a"), (Option<ConfluentObserverTest.BasicConstraint>)None$.MODULE$))}))).asJava());
        return (Void)client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
    }

    public static final /* synthetic */ void $anonfun$testCanReassignToEmptyObservers$1(AdminClient client) {
        String topic = "observer-topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.of(Predef$.MODULE$.short2Short((short)2)));
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        Seq replicas = ((TraversableOnce)((TraversableLike)((scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)client.describeTopics((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava()).all().get()).asScala()).values().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(x$1.partitions()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(x$2.replicas()).asScala(), Buffer$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Iterable$.MODULE$.canBuildFrom())).toSeq();
        Seq swappedBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)replicas.apply(1)), BoxesRunTime.unboxToInt((Object)replicas.apply(0))}));
        client.alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)swappedBrokers, (Seq<Object>)Nil$.MODULE$))}))).asJava()).all().get();
        TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)swappedBrokers);
    }

    public static final /* synthetic */ Throwable $anonfun$testCannotUseReplicaPlacementConstraintWithObservers$1(AdminClient client) {
        String topic = "observer-topic";
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        newTopic.configs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.TopicPlacementConstraintsProp()), (Object)ConfluentObserverTest$.MODULE$.basicTopicPlacement(new ConfluentObserverTest.BasicConstraint(1, "a"), (Option<ConfluentObserverTest.BasicConstraint>)new Some((Object)new ConfluentObserverTest.BasicConstraint(1, "b"))))}))).asJava());
        return TestUtils.assertFutureError((Future)client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all(), InvalidReplicaAssignmentException.class);
    }

    public static final /* synthetic */ Throwable $anonfun$testCannotReassignToObservers$1(ObserverCompatibilityTest $this, AdminClient client) {
        String topic = "observer-topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        return TestUtils.assertFutureError((Future)client.alterPartitionReassignments((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), ConfluentObserverTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1()}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker2()})))))}))).asJava()).all(), InvalidReplicaAssignmentException.class);
    }

    public static final /* synthetic */ Throwable $anonfun$testCannotEnableObserversThroughAlterConfigAPIs$1(AdminClient client) {
        String topic = "observer-topic";
        NewTopic newTopic = new NewTopic(topic, Optional.of(Predef$.MODULE$.int2Integer(1)), Optional.empty());
        client.createTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)newTopic, (List)Nil$.MODULE$)).asJava()).all().get();
        Properties configUpdate = new Properties();
        configUpdate.setProperty(LogConfig$.MODULE$.TopicPlacementConstraintsProp(), ConfluentObserverTest$.MODULE$.basicTopicPlacement(new ConfluentObserverTest.BasicConstraint(1, "a"), (Option<ConfluentObserverTest.BasicConstraint>)new Some((Object)new ConfluentObserverTest.BasicConstraint(1, "b"))));
        TestUtils.assertFutureError((Future)ConfluentObserverTest$.MODULE$.alterTopicConfigs((Admin)client, topic, configUpdate).all(), InvalidConfigurationException.class);
        return TestUtils.assertFutureError((Future)TestUtils$.MODULE$.incrementalAlterTopicConfigs((Admin)client, topic, configUpdate, TestUtils$.MODULE$.incrementalAlterTopicConfigs$default$4()).all(), InvalidConfigurationException.class);
    }

    public ObserverCompatibilityTest() {
        this.broker1 = 0;
        this.broker2 = 1;
    }

    public static final /* synthetic */ Object $anonfun$testCanReassignToEmptyObservers$1$adapted(AdminClient client) {
        ObserverCompatibilityTest.$anonfun$testCanReassignToEmptyObservers$1(client);
        return BoxedUnit.UNIT;
    }
}

