/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.FetchPartitionData;
import kafka.server.Fetching$;
import kafka.server.FullPartitionFetchMetadata;
import kafka.server.InitialFetchState;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.OffsetAndEpoch;
import kafka.server.PartitionFetchMetadata;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionFetchState$;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaAlterLogDirsThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicaState;
import kafka.server.ReplicationQuotaManager;
import kafka.server.Truncating$;
import kafka.utils.DelayedItem;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013%1\u0006\u0003\u00048\u0001\u0001\u0006I\u0001\f\u0005\bq\u0001\u0011\r\u0011\"\u0003,\u0011\u0019I\u0004\u0001)A\u0005Y!9!\b\u0001b\u0001\n\u0013Y\u0004BB \u0001A\u0003%A\bC\u0003A\u0001\u0011%\u0011\tC\u0004P\u0001E\u0005I\u0011\u0002)\t\u000bm\u0003A\u0011\u0001/\t\u000b-\u0004A\u0011\u0001/\t\u000b5\u0004A\u0011\u0001/\t\u000b=\u0004A\u0011\u00029\t\r\u0005=\u0001\u0001\"\u0001]\u0011\u0019\t\u0019\u0002\u0001C\u00019\"1\u0011q\u0003\u0001\u0005\u0002qCa!a\u0007\u0001\t\u0003a\u0006BBA\u0010\u0001\u0011\u0005A\f\u0003\u0004\u0002$\u0001!\t\u0001\u0018\u0005\u0007\u0003O\u0001A\u0011\u0001/\t\r\u0005-\u0002\u0001\"\u0001]\u0011\u0019\ty\u0003\u0001C\u00019\"9\u00111\u0007\u0001\u0005\u0002\u0005U\u0002bBA:\u0001\u0011\u0005\u0011Q\u000f\u0002\u001e%\u0016\u0004H.[2b\u00032$XM\u001d'pO\u0012K'o\u001d+ie\u0016\fG\rV3ti*\u00111\u0004H\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003u\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001AA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0015\u0011\u0005%\u0002Q\"\u0001\u000e\u0002\tQ\f\u0004\u000fM\u000b\u0002YA\u0011Q&N\u0007\u0002])\u0011q\u0006M\u0001\u0007G>lWn\u001c8\u000b\u0005u\t$B\u0001\u001a4\u0003\u0019\t\u0007/Y2iK*\tA'A\u0002pe\u001eL!A\u000e\u0018\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006)A/\r91A\u0005!A/\r92\u0003\u0015!\u0018\u0007]\u0019!\u0003A1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7/F\u0001=!\tIS(\u0003\u0002?5\t\u0001b)Y5mK\u0012\u0004\u0016M\u001d;ji&|gn]\u0001\u0012M\u0006LG.\u001a3QCJ$\u0018\u000e^5p]N\u0004\u0013!E5oSRL\u0017\r\u001c$fi\u000eD7\u000b^1uKR\u0019!)\u0012&\u0011\u0005%\u001a\u0015B\u0001#\u001b\u0005EIe.\u001b;jC24U\r^2i'R\fG/\u001a\u0005\u0006\r\"\u0001\raR\u0001\fM\u0016$8\r[(gMN,G\u000f\u0005\u0002\"\u0011&\u0011\u0011J\t\u0002\u0005\u0019>tw\rC\u0004L\u0011A\u0005\t\u0019\u0001'\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\t\u0003C5K!A\u0014\u0012\u0003\u0007%sG/A\u000ej]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016$C-\u001a4bk2$HEM\u000b\u0002#*\u0012AJU\u0016\u0002'B\u0011A+W\u0007\u0002+*\u0011akV\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001\u0017\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002[+\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002YMDw.\u001e7e\u001d>$\u0018\t\u001a3QCJ$\u0018\u000e^5p]&3g)\u001e;ve\u0016dunZ%t\u001d>$H)\u001a4j]\u0016$G#A/\u0011\u0005\u0005r\u0016BA0#\u0005\u0011)f.\u001b;)\u0005)\t\u0007C\u00012j\u001b\u0005\u0019'B\u00013f\u0003\r\t\u0007/\u001b\u0006\u0003M\u001e\fqA[;qSR,'O\u0003\u0002ig\u0005)!.\u001e8ji&\u0011!n\u0019\u0002\u0005)\u0016\u001cH/\u0001\u0017tQ>,H\u000eZ+qI\u0006$X\rT3bI\u0016\u0014X\t]8dQ\u00063G/\u001a:GK:\u001cW\rZ#q_\u000eDWI\u001d:pe\"\u00121\"Y\u0001'g\"|W\u000f\u001c3SKBd\u0017mY3DkJ\u0014XM\u001c;M_\u001e$\u0015N],iK:\u001c\u0015-^4iiV\u0003\bF\u0001\u0007b\u0003]iwnY6GKR\u001c\u0007N\u0012:p[\u000e+(O]3oi2{w\rF\u0004^cNDX0!\u0002\t\u000bIl\u0001\u0019\u0001\u0017\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\")A/\u0004a\u0001k\u0006Y!/Z9vKN$H)\u0019;b!\tIc/\u0003\u0002x5\t1\u0002+\u0019:uSRLwN\u001c$fi\u000eDW*\u001a;bI\u0006$\u0018\rC\u0003z\u001b\u0001\u0007!0\u0001\u0004d_:4\u0017n\u001a\t\u0003SmL!\u0001 \u000e\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\u0006}6\u0001\ra`\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\rI\u0013\u0011A\u0005\u0004\u0003\u0007Q\"A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\b\u0003\u000fi\u0001\u0019AA\u0005\u00031\u0011Xm\u001d9p]N,G)\u0019;b!\rI\u00131B\u0005\u0004\u0003\u001bQ\"A\u0005$fi\u000eD\u0007+\u0019:uSRLwN\u001c#bi\u0006\f!%[:tk\u0016\u001cX\t]8dQJ+\u0017/^3ti\u001a\u0013x.\u001c'pG\u0006d'+\u001a9mS\u000e\f\u0007F\u0001\bb\u0003u2W\r^2i\u000bB|7\r[:Ge>lG*Z1eKJ\u001c\u0006n\\;mI\"\u000bg\u000e\u001a7f\u000bb\u001cW\r\u001d;j_:4%o\\7HKRdunY1m%\u0016\u0004H.[2bQ\ty\u0011-A\u000ftQ>,H\u000e\u001a+sk:\u001c\u0017\r^3U_J+\u0007\u000f\\5dC>3gm]3uQ\t\u0001\u0012-A\u0017tQ>,H\u000e\u001a+sk:\u001c\u0017\r^3U_\u0016sGm\u00144gg\u0016$xJ\u001a'be\u001e,7\u000f^\"p[6|g.\u00129pG\"D#!E1\u0002\u0003NDw.\u001e7e)J,hnY1uKR{\u0017J\\5uS\u0006dg)\u001a;dQ>3gm]3u\u0013\u001a\u0014V\r\u001d7jG\u0006\u0014V\r^;s]N,f\u000eZ3gS:,Gm\u00144gg\u0016$\bF\u0001\nb\u0003-\u001a\bn\\;mIB{G\u000e\\%oI\u00164\u0017N\\5uK2L\u0018J\u001a*fa2L7-\u0019(pi\u00063\u0018-\u001b7bE2,\u0007FA\nb\u0003\u0019\u001a\bn\\;mI\u001a+Go\u00195MK\u0006$WM]#q_\u000eDwJ\u001c$jeN$h)\u001a;dQ>sG.\u001f\u0015\u0003)\u0005\fAd\u001d5pk2$g)\u001a;dQ>sWMU3qY&\u001c\u0017-\u0011;B)&lW\r\u000b\u0002\u0016C\u0006i3\u000f[8vY\u00124U\r^2i\u001d>tG)\u001a7bs\u0016$\u0017I\u001c3O_:$&/\u001e8dCRLgn\u001a*fa2L7-Y:)\u0005Y\t\u0017\u0001B:uk\n$B\"a\u000e\u0002V\u0005\u0015\u0014\u0011NA7\u0003c\u0002b!!\u000f\u0002@\u0005\rSBAA\u001e\u0015\r\tidM\u0001\tK\u0006\u001c\u00180\\8dW&!\u0011\u0011IA\u001e\u0005MIU\t\u001f9fGR\fG/[8o'\u0016$H/\u001a:t!\u0015\t\u0013QIA%\u0013\r\t9E\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014\u001d\u0003\u001d\u0019G.^:uKJLA!a\u0015\u0002N\tI\u0001+\u0019:uSRLwN\u001c\u0005\b\u0003/:\u0002\u0019AA-\u0003\u001dawn\u001a+2aB\u0002B!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0004\u0003?b\u0012a\u00017pO&!\u00111MA/\u0005-\t%m\u001d;sC\u000e$Hj\\4\t\u000f\u0005\u001dt\u00031\u0001\u0002Z\u00059An\\4UcA\f\u0004bBA6/\u0001\u0007\u0011\u0011L\u0001\nMV$XO]3M_\u001eDq!a\u001c\u0018\u0001\u0004\tI%A\u0005qCJ$\u0018\u000e^5p]\")ap\u0006a\u0001\u007f\u0006)2\u000f^;c/&$\bNR3uG\"lUm]:bO\u0016\u001cHCDA<\u0003s\nY(! \u0002\u0000\u0005\u0005\u00151\u0011\t\u0006\u0003s\ty$\u0018\u0005\b\u0003/B\u0002\u0019AA-\u0011\u001d\t9\u0007\u0007a\u0001\u00033Bq!a\u001b\u0019\u0001\u0004\tI\u0006C\u0004\u0002pa\u0001\r!!\u0013\t\u000byD\u0002\u0019A@\t\u000f\u0005\u0015\u0005\u00041\u0001\u0002\b\u0006\u0001\"/Z:q_:\u001cXmQ1mY\n\f7m\u001b\t\u0007\u0003s\tI)!$\n\t\u0005-\u00151\b\u0002\b\u0007\u0006\u0004H/\u001e:f!\u0019\t\u0013qRAJ;&\u0019\u0011\u0011\u0013\u0012\u0003\u0013\u0019+hn\u0019;j_:\f\u0004CBAK\u00037\u000by*\u0004\u0002\u0002\u0018*\u0019\u0011\u0011\u0014\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001e\u0006]%aA*fcB1\u0011%!)-\u0003\u0013I1!a)#\u0005\u0019!V\u000f\u001d7fe\u0001")
public class ReplicaAlterLogDirsThreadTest {
    private final TopicPartition t1p0 = new TopicPartition("topic1", 0);
    private final TopicPartition t1p1 = new TopicPartition("topic1", 1);
    private final FailedPartitions failedPartitions = new FailedPartitions();

    private TopicPartition t1p0() {
        return this.t1p0;
    }

    private TopicPartition t1p1() {
        return this.t1p1;
    }

    private FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    private InitialFetchState initialFetchState(long fetchOffset, int leaderEpoch) {
        BrokerEndPoint x$1 = new BrokerEndPoint(0, "localhost", 9092);
        return new InitialFetchState(x$1, leaderEpoch, fetchOffset);
    }

    private int initialFetchState$default$2() {
        return 1;
    }

    @Test
    public void shouldNotAddPartitionIfFutureLogIsNotDefined() {
        int brokerId = 1;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, new BrokerTopicStats());
        Set addedPartitions = thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, this.initialFetchState$default$2()))})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)addedPartitions);
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
    }

    @Test
    public void shouldUpdateLeaderEpochAfterFencedEpochError() {
        int brokerId = 1;
        int partitionId = 0;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        AbstractLog futureLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        int leaderEpoch = 5;
        int logEndOffset = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)logEndOffset));
        Mockito.when((Object)partition.futureLocalLogOrException()).thenReturn((Object)futureLog);
        ((Partition)Mockito.doNothing().when((Object)partition)).truncateTo(0L, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.maybeReplaceCurrentWithFutureReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        FullPartitionFetchMetadata fencedRequestData = new FullPartitionFetchMetadata(0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), Optional.empty());
        FetchPartitionData fencedResponseData = new FetchPartitionData(Errors.FENCED_LEADER_EPOCH, -1L, -1L, (Records)MemoryRecords.EMPTY, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        this.mockFetchFromCurrentLog(this.t1p0(), (PartitionFetchMetadata)fencedRequestData, config, replicaManager, fencedResponseData);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, new BrokerTopicStats());
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch - 1))})));
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        thread.doWork();
        Assertions.assertTrue((boolean)this.failedPartitions().contains(this.t1p0()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)), (Object)thread.fetchState(this.t1p0()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.currentLeaderEpoch())));
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        FullPartitionFetchMetadata requestData = new FullPartitionFetchMetadata(0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), Optional.empty());
        FetchPartitionData responseData = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        this.mockFetchFromCurrentLog(this.t1p0(), (PartitionFetchMetadata)requestData, config, replicaManager, responseData);
        thread.doWork();
        Assertions.assertFalse((boolean)this.failedPartitions().contains(this.t1p0()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
    }

    @Test
    public void shouldReplaceCurrentLogDirWhenCaughtUp() {
        int brokerId = 1;
        int partitionId = 0;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(brokerId, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        Partition partition = (Partition)Mockito.mock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
        AbstractLog futureLog = (AbstractLog)Mockito.mock(AbstractLog.class);
        int leaderEpoch = 5;
        int logEndOffset = 0;
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).thenReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        Mockito.when((Object)replicaManager.futureLocalLogOrException(this.t1p0())).thenReturn((Object)futureLog);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(this.t1p0())).thenReturn((Object)new Some((Object)partition));
        Mockito.when((Object)replicaManager.getPartitionOrException(this.t1p0())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quotaManager.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)partition.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).thenReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)logEndOffset));
        Mockito.when((Object)partition.futureLocalLogOrException()).thenReturn((Object)futureLog);
        ((Partition)Mockito.doNothing().when((Object)partition)).truncateTo(0L, true);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.maybeReplaceCurrentWithFutureReplica())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)futureLog.latestEpoch()).thenReturn((Object)None$.MODULE$);
        FullPartitionFetchMetadata requestData = new FullPartitionFetchMetadata(0L, 0L, Predef$.MODULE$.Integer2int(config.replicaFetchMaxBytes()), Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), Optional.empty());
        FetchPartitionData responseData = new FetchPartitionData(Errors.NONE, 0L, 0L, (Records)MemoryRecords.EMPTY, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        this.mockFetchFromCurrentLog(this.t1p0(), (PartitionFetchMetadata)requestData, config, replicaManager, responseData);
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, new BrokerTopicStats());
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        Assertions.assertTrue((boolean)thread.fetchState(this.t1p0()).isDefined());
        Assertions.assertEquals((int)1, (int)thread.partitionCount());
        thread.doWork();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)thread.fetchState(this.t1p0()));
        Assertions.assertEquals((int)0, (int)thread.partitionCount());
    }

    private void mockFetchFromCurrentLog(TopicPartition topicPartition, PartitionFetchMetadata requestData, KafkaConfig config, ReplicaManager replicaManager, FetchPartitionData responseData) {
        ArgumentCaptor callbackCaptor = ArgumentCaptor.forClass(Function1.class);
        ArgumentMatcher<Seq<Tuple2<TopicPartition, PartitionFetchMetadata>>> argumentMatcher = new ArgumentMatcher<Seq<Tuple2<TopicPartition, PartitionFetchMetadata>>>(null, topicPartition, requestData){
            private final TopicPartition topicPartition$1;
            private final PartitionFetchMetadata requestData$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean matches(Seq<Tuple2<TopicPartition, PartitionFetchMetadata>> argument) {
                Option option = package$.MODULE$.$plus$colon().unapply(argument);
                if (option.isEmpty()) return false;
                Tuple2 tuple2 = (Tuple2)((Tuple2)option.get())._1();
                Seq seq = (Seq)((Tuple2)option.get())._2();
                if (tuple2 == null) return false;
                TopicPartition tp = (TopicPartition)tuple2._1();
                PartitionFetchMetadata partitionData = (PartitionFetchMetadata)tuple2._2();
                Some some = Seq$.MODULE$.unapplySeq(seq);
                if (some.isEmpty()) return false;
                if (some.get() == null) return false;
                if (((SeqLike)some.get()).lengthCompare(0) != 0) return false;
                TopicPartition topicPartition = tp;
                TopicPartition topicPartition2 = this.topicPartition$1;
                if (topicPartition == null) {
                    if (topicPartition2 != null) {
                        return false;
                    }
                } else if (!topicPartition.equals(topicPartition2)) return false;
                if (partitionData.fetchOffset() != this.requestData$1.fetchOffset()) return false;
                Optional optional = partitionData.currentLeaderEpoch();
                Optional optional2 = this.requestData$1.currentLeaderEpoch();
                if (optional == null) {
                    if (optional2 != null) {
                        return false;
                    }
                } else if (!((Object)optional).equals(optional2)) return false;
                Optional optional3 = partitionData.lastFetchedEpoch();
                Optional optional4 = this.requestData$1.lastFetchedEpoch();
                if (optional3 == null) {
                    if (optional4 != null) {
                        return false;
                    }
                } else if (!((Object)optional3).equals(optional4)) return false;
                if (partitionData.startOffset() != this.requestData$1.startOffset()) return false;
                if (partitionData.maxBytes() != this.requestData$1.maxBytes()) return false;
                return true;
            }
            {
                this.topicPartition$1 = topicPartition$1;
                this.requestData$1 = requestData$1;
            }
        };
        replicaManager.fetchMessages(ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((int)Request$.MODULE$.FutureLocalReplicaId()), ArgumentMatchers.eq((int)0), BoxesRunTime.unboxToInt((Object)ArgumentMatchers.eq((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(config.replicaFetchResponseMaxBytes())))), ArgumentMatchers.eq((boolean)false), (Seq)ArgumentMatchers.argThat((ArgumentMatcher)argumentMatcher), (ReplicaQuota)ArgumentMatchers.eq((Object)QuotaFactory.UnboundedQuota$.MODULE$), (Function1)callbackCaptor.capture(), (IsolationLevel)ArgumentMatchers.eq((Object)IsolationLevel.READ_UNCOMMITTED), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(x$2 -> {
            ReplicaAlterLogDirsThreadTest.$anonfun$mockFetchFromCurrentLog$1(callbackCaptor, topicPartition, responseData, x$2);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void issuesEpochRequestFromLocalReplica() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        Partition partitionT1p0 = (Partition)EasyMock.createMock(Partition.class);
        Partition partitionT1p1 = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int partitionT1p0Id = 0;
        int partitionT1p1Id = 1;
        int leaderEpochT1p0 = 2;
        int leaderEpochT1p1 = 5;
        int leoT1p0 = 13;
        int leoT1p1 = 232;
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)partitionT1p0.partitionId())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)partitionT1p0Id));
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)partitionT1p0.partitionId())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)partitionT1p1Id));
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0())).andStubReturn((Object)partitionT1p0);
        EasyMock.expect((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpochT1p0, false)).andReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionT1p0Id).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpochT1p0).setEndOffset((long)leoT1p0)).anyTimes();
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p1())).andStubReturn((Object)partitionT1p1);
        EasyMock.expect((Object)partitionT1p1.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpochT1p1, false)).andReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionT1p1Id).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpochT1p1).setEndOffset((long)leoT1p1)).anyTimes();
        EasyMock.replay((Object[])new Object[]{partitionT1p0, partitionT1p1, replicaManager});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        Map result = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, null, null).fetchEpochEndOffsets((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p0().partition()).setLeaderEpoch(leaderEpochT1p0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p1().partition()).setLeaderEpoch(leaderEpochT1p1))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.t1p0().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpochT1p0).setEndOffset((long)leoT1p0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.t1p1().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpochT1p1).setEndOffset((long)leoT1p1))}))), (Object)result, (String)"results from leader epoch request should have offset from local replica");
    }

    @Test
    public void fetchEpochsFromLeaderShouldHandleExceptionFromGetLocalReplica() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        Partition partitionT1p0 = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int partitionId = 0;
        int leaderEpoch = 2;
        int leo = 13;
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)partitionT1p0.partitionId())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0())).andStubReturn((Object)partitionT1p0);
        EasyMock.expect((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.empty(), leaderEpoch, false)).andReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)leo)).anyTimes();
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p1())).andThrow((Throwable)new KafkaStorageException()).once();
        EasyMock.replay((Object[])new Object[]{partitionT1p0, replicaManager});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        Map result = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, null, null).fetchEpochEndOffsets((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p0().partition()).setLeaderEpoch(leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.t1p1().partition()).setLeaderEpoch(leaderEpoch))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.t1p0().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)leo)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.t1p1().partition()).setErrorCode(Errors.KAFKA_STORAGE_ERROR.code()))}))), (Object)result);
    }

    @Test
    public void shouldTruncateToReplicaOffset() {
        Capture truncateCaptureT1p0 = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        Capture truncateCaptureT1p1 = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        AbstractLog logT1p0 = (AbstractLog)EasyMock.createNiceMock(AbstractLog.class);
        AbstractLog logT1p1 = (AbstractLog)EasyMock.createNiceMock(AbstractLog.class);
        AbstractLog futureLogT1p0 = (AbstractLog)EasyMock.createNiceMock(AbstractLog.class);
        AbstractLog futureLogT1p1 = (AbstractLog)EasyMock.createNiceMock(AbstractLog.class);
        Partition partitionT1p0 = (Partition)EasyMock.createMock(Partition.class);
        Partition partitionT1p1 = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int partitionT1p0Id = 0;
        int partitionT1p1Id = 1;
        int leaderEpoch = 2;
        int futureReplicaLEO = 191;
        int replicaT1p0LEO = 190;
        int replicaT1p1LEO = 192;
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)partitionT1p0.partitionId())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)partitionT1p0Id));
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)partitionT1p1.partitionId())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)partitionT1p1Id));
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0())).andStubReturn((Object)partitionT1p0);
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p1())).andStubReturn((Object)partitionT1p1);
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p0())).andStubReturn((Object)futureLogT1p0);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).andStubReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p1())).andStubReturn((Object)futureLogT1p1);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p1()))).andStubReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        partitionT1p0.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateCaptureT1p0)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        partitionT1p1.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateCaptureT1p1)), EasyMock.anyBoolean());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureLogT1p0.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureLogT1p1.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)futureLogT1p0.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).anyTimes();
        EasyMock.expect((Object)futureLogT1p0.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch))).anyTimes();
        EasyMock.expect((Object)partitionT1p0.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).andReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionT1p0Id).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)replicaT1p0LEO)).anyTimes();
        EasyMock.expect((Object)futureLogT1p1.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).anyTimes();
        EasyMock.expect((Object)futureLogT1p1.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch))).anyTimes();
        EasyMock.expect((Object)partitionT1p1.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).andReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionT1p1Id).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)replicaT1p1LEO)).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stubWithFetchMessages(logT1p0, logT1p1, futureLogT1p0, partitionT1p0, replicaManager, (Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partitionT1p0, partitionT1p1, logT1p0, logT1p1, futureLogT1p0, futureLogT1p1});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, this.initialFetchState$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState(0L, this.initialFetchState$default$2()))})));
        thread.doWork();
        Assertions.assertEquals((long)replicaT1p0LEO, (long)BoxesRunTime.unboxToLong((Object)truncateCaptureT1p0.getValue()));
        Assertions.assertEquals((long)futureReplicaLEO, (long)BoxesRunTime.unboxToLong((Object)truncateCaptureT1p1.getValue()));
    }

    @Test
    public void shouldTruncateToEndOffsetOfLargestCommonEpoch() {
        Capture truncateToCapture = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        AbstractLog log = (AbstractLog)EasyMock.createNiceMock(AbstractLog.class);
        AbstractLog futureLog = (AbstractLog)EasyMock.createNiceMock(AbstractLog.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int partitionId = 0;
        int leaderEpoch = 5;
        int futureReplicaLEO = 195;
        int replicaLEO = 200;
        int replicaEpochEndOffset = 190;
        int futureReplicaEpochEndOffset = 191;
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0())).andStubReturn((Object)partition);
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p0())).andStubReturn((Object)futureLog);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).andStubReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncateToCapture)), EasyMock.eq((boolean)true));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)futureLog.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch))).once();
        EasyMock.expect((Object)futureLog.latestEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(leaderEpoch - 2)))).times(3);
        EasyMock.expect((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).andReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch - 1).setEndOffset((long)replicaLEO)).anyTimes();
        EasyMock.expect((Object)futureLog.endOffsetForEpoch(leaderEpoch - 1)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch - 2))).anyTimes();
        EasyMock.expect((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch - 2, false)).andReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch - 2).setEndOffset((long)replicaEpochEndOffset)).anyTimes();
        EasyMock.expect((Object)futureLog.endOffsetForEpoch(leaderEpoch - 2)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaEpochEndOffset, leaderEpoch - 2))).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partition, log, futureLog});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, this.initialFetchState$default$2()))})));
        thread.doWork();
        thread.doWork();
        Assertions.assertTrue((boolean)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(truncateToCapture.getValues()).asScala()).contains((Object)BoxesRunTime.boxToInteger((int)replicaEpochEndOffset)), (String)new StringBuilder(48).append("Expected offset ").append(replicaEpochEndOffset).append(" in captured truncation offsets ").append(truncateToCapture.getValues()).toString());
    }

    @Test
    public void shouldTruncateToInitialFetchOffsetIfReplicaReturnsUndefinedOffset() {
        Capture truncated = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        AbstractLog log = (AbstractLog)EasyMock.createNiceMock(AbstractLog.class);
        AbstractLog futureLog = (AbstractLog)EasyMock.createNiceMock(AbstractLog.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int initialFetchOffset = 100;
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0())).andStubReturn((Object)partition);
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncated)), EasyMock.eq((boolean)true));
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p0())).andStubReturn((Object)futureLog);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).andStubReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        EasyMock.expect((Object)futureLog.latestEpoch()).andReturn((Object)None$.MODULE$).anyTimes();
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partition, log, futureLog});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(initialFetchOffset, this.initialFetchState$default$2()))})));
        thread.doWork();
        Assertions.assertEquals((long)initialFetchOffset, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()), (String)"Expected future replica to truncate to initial fetch offset if replica returns UNDEFINED_EPOCH_OFFSET");
    }

    @Test
    public void shouldPollIndefinitelyIfReplicaNotAvailable() {
        Capture truncated = EasyMock.newCapture((CaptureType)CaptureType.ALL);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        AbstractLog log = (AbstractLog)EasyMock.createNiceMock(AbstractLog.class);
        AbstractLog futureLog = (AbstractLog)EasyMock.createNiceMock(AbstractLog.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int partitionId = 0;
        int futureReplicaLeaderEpoch = 1;
        int futureReplicaLEO = 290;
        int replicaLEO = 300;
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0())).andStubReturn((Object)partition);
        partition.truncateTo(BoxesRunTime.unboxToLong((Object)EasyMock.capture((Capture)truncated)), EasyMock.eq((boolean)true));
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p0())).andStubReturn((Object)futureLog);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).andStubReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO)).anyTimes();
        EasyMock.expect((Object)futureLog.latestEpoch()).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)futureReplicaLeaderEpoch)));
        EasyMock.expect((Object)futureLog.endOffsetForEpoch(futureReplicaLeaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, futureReplicaLeaderEpoch)));
        EasyMock.expect((Object)replicaManager.localLog(this.t1p0())).andReturn((Object)new Some((Object)log)).anyTimes();
        EasyMock.expect((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), futureReplicaLeaderEpoch, false)).andReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.REPLICA_NOT_AVAILABLE.code())).times(3).andReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(futureReplicaLeaderEpoch).setEndOffset((long)replicaLEO));
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        replicaManager.fetchMessages(EasyMock.anyLong(), EasyMock.anyInt(), EasyMock.anyInt(), EasyMock.anyInt(), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()), (Seq)EasyMock.anyObject(), (ReplicaQuota)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)responseCallback), (IsolationLevel)EasyMock.anyObject(), (Option)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
            ReplicaAlterLogDirsThreadTest.$anonfun$shouldPollIndefinitelyIfReplicaNotAvailable$1(responseCallback);
            return BoxedUnit.UNIT;
        }).anyTimes();
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partition, log, futureLog});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, this.initialFetchState$default$2()))})));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> thread.doWork());
        Assertions.assertEquals((int)0, (int)truncated.getValues().size());
        thread.doWork();
        Assertions.assertEquals((long)futureReplicaLEO, (long)BoxesRunTime.unboxToLong((Object)truncated.getValue()));
    }

    @Test
    public void shouldFetchLeaderEpochOnFirstFetchOnly() {
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        AbstractLog log = (AbstractLog)EasyMock.createNiceMock(AbstractLog.class);
        AbstractLog futureLog = (AbstractLog)EasyMock.createNiceMock(AbstractLog.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        Capture responseCallback = EasyMock.newCapture();
        int partitionId = 0;
        int leaderEpoch = 5;
        int futureReplicaLEO = 190;
        int replicaLEO = 213;
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)partition.partitionId())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)partitionId));
        EasyMock.expect((Object)replicaManager.getPartitionOrException(this.t1p0())).andStubReturn((Object)partition);
        EasyMock.expect((Object)partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(1)), leaderEpoch, false)).andReturn((Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(partitionId).setErrorCode(Errors.NONE.code()).setLeaderEpoch(leaderEpoch).setEndOffset((long)replicaLEO));
        partition.truncateTo((long)futureReplicaLEO, true);
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p0())).andStubReturn((Object)futureLog);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).andStubReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)futureLog.latestEpoch()).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)leaderEpoch)));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureLog.logEndOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)futureReplicaLEO));
        EasyMock.expect((Object)futureLog.endOffsetForEpoch(leaderEpoch)).andReturn((Object)new Some((Object)new OffsetAndEpoch((long)futureReplicaLEO, leaderEpoch)));
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stubWithFetchMessages(log, null, futureLog, partition, replicaManager, (Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>>)responseCallback);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partition, log, futureLog});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, this.initialFetchState$default$2()))})));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> thread.doWork());
        EasyMock.verify((Object[])new Object[]{partition});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldFetchOneReplicaAtATime() {
        void var13_13;
        void var12_12;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        AbstractLog log = (AbstractLog)EasyMock.createNiceMock(AbstractLog.class);
        AbstractLog futureLog = (AbstractLog)EasyMock.createNiceMock(AbstractLog.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stub(log, null, futureLog, partition, replicaManager);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partition, log});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        int leaderEpoch = 1;
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new PartitionFetchState(150L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState(160L, (Option)None$.MODULE$, leaderEpoch, (Option)None$.MODULE$, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$))})));
        if (resultWithPartitions == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt = (Option)resultWithPartitions.result();
        Map partitionsWithError = resultWithPartitions.partitionsWithError();
        void fetchRequestOpt2 = var12_12;
        void partitionsWithError2 = var13_13;
        Assertions.assertTrue((boolean)fetchRequestOpt2.isDefined());
        FetchRequest.Builder fetchRequest = ((AbstractFetcherThread.ReplicaFetch)fetchRequestOpt2.get()).fetchRequest();
        Assertions.assertFalse((boolean)fetchRequest.fetchData().isEmpty());
        Assertions.assertFalse((boolean)partitionsWithError2.nonEmpty());
        FetchRequest request = (FetchRequest)fetchRequest.build();
        Assertions.assertEquals((int)0, (int)request.minBytes());
        Assertions.assertEquals((int)1, (int)request.data().topics().size());
        FetchRequestData.FetchTopic topic = (FetchRequestData.FetchTopic)request.data().topics().get(0);
        Assertions.assertEquals((Object)this.t1p0().topic(), (Object)topic.topic(), (String)"Expected fetch request for first partition");
        Assertions.assertEquals((int)1, (int)topic.partitions().size());
        Assertions.assertEquals((int)this.t1p0().partition(), (int)((FetchRequestData.FetchPartition)topic.partitions().get(0)).partition(), (String)"Expected fetch request for first partition");
        Assertions.assertEquals((long)150L, (long)((FetchRequestData.FetchPartition)topic.partitions().get(0)).fetchOffset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldFetchNonDelayedAndNonTruncatingReplicas() {
        void var30_30;
        void var29_29;
        void var22_22;
        void var21_21;
        void var14_14;
        void var13_13;
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
        ReplicationQuotaManager quotaManager = (ReplicationQuotaManager)EasyMock.createNiceMock(ReplicationQuotaManager.class);
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        AbstractLog log = (AbstractLog)EasyMock.createNiceMock(AbstractLog.class);
        AbstractLog futureLog = (AbstractLog)EasyMock.createNiceMock(AbstractLog.class);
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        int startOffset = 123;
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)futureLog.logStartOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)startOffset)).anyTimes();
        EasyMock.expect((Object)replicaManager.logManager()).andReturn((Object)logManager).anyTimes();
        this.stub(log, null, futureLog, partition, replicaManager);
        EasyMock.replay((Object[])new Object[]{replicaManager, logManager, quotaManager, partition, log, futureLog});
        BrokerEndPoint endPoint = new BrokerEndPoint(0, "localhost", 1000);
        int leaderEpoch = 1;
        ReplicaAlterLogDirsThread thread = new ReplicaAlterLogDirsThread("alter-logs-dirs-thread-test1", endPoint, config, this.failedPartitions(), replicaManager, quotaManager, null);
        thread.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)this.initialFetchState(0L, leaderEpoch)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)this.initialFetchState(0L, leaderEpoch))})));
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions = thread.buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)PartitionFetchState$.MODULE$.apply(150L, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)PartitionFetchState$.MODULE$.apply(160L, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Truncating$.MODULE$, (Option)None$.MODULE$))})));
        if (resultWithPartitions == null) {
            throw new MatchError(null);
        }
        Option fetchRequestOpt = (Option)resultWithPartitions.result();
        Map partitionsWithError = resultWithPartitions.partitionsWithError();
        void fetchRequestOpt2 = var13_13;
        void partitionsWithError2 = var14_14;
        Assertions.assertTrue((boolean)fetchRequestOpt2.isDefined());
        AbstractFetcherThread.ReplicaFetch fetchRequest = (AbstractFetcherThread.ReplicaFetch)fetchRequestOpt2.get();
        Assertions.assertFalse((boolean)fetchRequest.partitionData().isEmpty());
        Assertions.assertFalse((boolean)partitionsWithError2.nonEmpty());
        FetchRequest request = (FetchRequest)fetchRequest.fetchRequest().build();
        Assertions.assertEquals((int)1, (int)request.data().topics().size());
        FetchRequestData.FetchTopic topic = (FetchRequestData.FetchTopic)request.data().topics().get(0);
        Assertions.assertEquals((Object)this.t1p0().topic(), (Object)topic.topic(), (String)"Expected fetch request for non-truncating partition");
        Assertions.assertEquals((int)1, (int)topic.partitions().size());
        Assertions.assertEquals((int)this.t1p0().partition(), (int)((FetchRequestData.FetchPartition)topic.partitions().get(0)).partition(), (String)"Expected fetch request for non-truncating partition");
        Assertions.assertEquals((long)150L, (long)((FetchRequestData.FetchPartition)topic.partitions().get(0)).fetchOffset());
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions2 = thread.buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)PartitionFetchState$.MODULE$.apply(140L, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState(160L, (Option)None$.MODULE$, leaderEpoch, (Option)new Some((Object)new DelayedItem(5000L)), (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$))})));
        if (resultWithPartitions2 == null) {
            throw new MatchError(null);
        }
        Option fetchRequest2Opt = (Option)resultWithPartitions2.result();
        Map partitionsWithError22 = resultWithPartitions2.partitionsWithError();
        void fetchRequest2Opt2 = var21_21;
        void partitionsWithError23 = var22_22;
        Assertions.assertTrue((boolean)fetchRequest2Opt2.isDefined());
        AbstractFetcherThread.ReplicaFetch fetchRequest2 = (AbstractFetcherThread.ReplicaFetch)fetchRequest2Opt2.get();
        Assertions.assertFalse((boolean)fetchRequest2.partitionData().isEmpty());
        Assertions.assertFalse((boolean)partitionsWithError23.nonEmpty());
        FetchRequest request2 = (FetchRequest)fetchRequest2.fetchRequest().build();
        Assertions.assertEquals((int)1, (int)request2.data().topics().size());
        FetchRequestData.FetchTopic topic2 = (FetchRequestData.FetchTopic)request2.data().topics().get(0);
        Assertions.assertEquals((Object)this.t1p0().topic(), (Object)topic2.topic(), (String)"Expected fetch request for non-delayed partition");
        Assertions.assertEquals((int)1, (int)topic2.partitions().size());
        Assertions.assertEquals((int)this.t1p0().partition(), (int)((FetchRequestData.FetchPartition)topic2.partitions().get(0)).partition(), (String)"Expected fetch request for non-delayed partition");
        Assertions.assertEquals((long)140L, (long)((FetchRequestData.FetchPartition)topic2.partitions().get(0)).fetchOffset());
        AbstractFetcherThread.ResultWithPartitions resultWithPartitions3 = thread.buildFetch((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p0()), (Object)new PartitionFetchState(140L, (Option)None$.MODULE$, leaderEpoch, (Option)new Some((Object)new DelayedItem(5000L)), (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.t1p1()), (Object)new PartitionFetchState(160L, (Option)None$.MODULE$, leaderEpoch, (Option)new Some((Object)new DelayedItem(5000L)), (ReplicaState)Fetching$.MODULE$, (Option)None$.MODULE$))})));
        if (resultWithPartitions3 == null) {
            throw new MatchError(null);
        }
        Option fetchRequest3Opt = (Option)resultWithPartitions3.result();
        Map partitionsWithError3 = resultWithPartitions3.partitionsWithError();
        void fetchRequest3Opt2 = var29_29;
        void partitionsWithError32 = var30_30;
        Assertions.assertTrue((boolean)fetchRequest3Opt2.isEmpty(), (String)"Expected no fetch requests since all partitions are delayed");
        Assertions.assertFalse((boolean)partitionsWithError32.nonEmpty());
    }

    public IExpectationSetters<Option<Partition>> stub(AbstractLog logT1p0, AbstractLog logT1p1, AbstractLog futureLog, Partition partition, ReplicaManager replicaManager) {
        EasyMock.expect((Object)replicaManager.localLog(this.t1p0())).andReturn((Object)new Some((Object)logT1p0)).anyTimes();
        EasyMock.expect((Object)replicaManager.localLogOrException(this.t1p0())).andReturn((Object)logT1p0).anyTimes();
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p0())).andReturn((Object)futureLog).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p0()))).andStubReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)replicaManager.onlinePartition(this.t1p0())).andReturn((Object)new Some((Object)partition)).anyTimes();
        EasyMock.expect((Object)replicaManager.localLog(this.t1p1())).andReturn((Object)new Some((Object)logT1p1)).anyTimes();
        EasyMock.expect((Object)replicaManager.localLogOrException(this.t1p1())).andReturn((Object)logT1p1).anyTimes();
        EasyMock.expect((Object)replicaManager.futureLocalLogOrException(this.t1p1())).andReturn((Object)futureLog).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.futureLogExists(this.t1p1()))).andStubReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        return EasyMock.expect((Object)replicaManager.onlinePartition(this.t1p1())).andReturn((Object)new Some((Object)partition)).anyTimes();
    }

    public IExpectationSetters<BoxedUnit> stubWithFetchMessages(AbstractLog logT1p0, AbstractLog logT1p1, AbstractLog futureLog, Partition partition, ReplicaManager replicaManager, Capture<Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>> responseCallback) {
        this.stub(logT1p0, logT1p1, futureLog, partition, replicaManager);
        replicaManager.fetchMessages(EasyMock.anyLong(), EasyMock.anyInt(), EasyMock.anyInt(), EasyMock.anyInt(), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()), (Seq)EasyMock.anyObject(), (ReplicaQuota)EasyMock.anyObject(), (Function1)EasyMock.capture(responseCallback), (IsolationLevel)EasyMock.anyObject(), (Option)EasyMock.anyObject());
        return EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
            ReplicaAlterLogDirsThreadTest.$anonfun$stubWithFetchMessages$1(responseCallback);
            return BoxedUnit.UNIT;
        }).anyTimes();
    }

    public static final /* synthetic */ void $anonfun$mockFetchFromCurrentLog$1(ArgumentCaptor callbackCaptor$1, TopicPartition topicPartition$1, FetchPartitionData responseData$1, InvocationOnMock x$2) {
        ((Function1)callbackCaptor$1.getValue()).apply((Object)new .colon.colon((Object)new Tuple2((Object)topicPartition$1, (Object)responseData$1), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$shouldPollIndefinitelyIfReplicaNotAvailable$1(Capture responseCallback$1) {
        ((Function1)responseCallback$1.getValue()).apply((Object)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$stubWithFetchMessages$1(Capture responseCallback$2) {
        ((Function1)responseCallback$2.getValue()).apply((Object)Nil$.MODULE$);
    }
}

