/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.config.ConfigResource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001e4A\u0001D\u0007\u0001%!)q\u0004\u0001C\u0001A!91\u0005\u0001b\u0001\n\u0003!\u0003BB\u0016\u0001A\u0003%Q\u0005C\u0005-\u0001\u0001\u0007\t\u0019!C\u0001[!I1\b\u0001a\u0001\u0002\u0004%\t\u0001\u0010\u0005\n\u0005\u0002\u0001\r\u0011!Q!\n9BQa\u0011\u0001\u0005B\u0011CQ\u0001\u0016\u0001\u0005\u0002UCQ!\u0019\u0001\u0005\u0002UCQA\u001a\u0001\u0005\u0002UCQa\u001b\u0001\u0005\n1\u00141EU3qY&\u001c\u0017-T1oC\u001e,'oQ8oM&<\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u000f\u001f\u000511/\u001a:wKJT\u0011\u0001E\u0001\u0006W\u000647.Y\u0002\u0001'\r\u00011#\u0007\t\u0003)]i\u0011!\u0006\u0006\u0003-=\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011\u0001$\u0006\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tgB\u0011!$H\u0007\u00027)\u0011AdD\u0001\u0006kRLGn]\u0005\u0003=m\u0011q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002CA\u0011!\u0005A\u0007\u0002\u001b\u0005Qa.^7TKJ4XM]:\u0016\u0003\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u00121!\u00138u\u0003-qW/\\*feZ,'o\u001d\u0011\u0002\u0017\u0005$W.\u001b8DY&,g\u000e^\u000b\u0002]A\u0011q&O\u0007\u0002a)\u0011\u0011GM\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003gQ\nqa\u00197jK:$8O\u0003\u0002\u0011k)\u0011agN\u0001\u0007CB\f7\r[3\u000b\u0003a\n1a\u001c:h\u0013\tQ\u0004GA\u0003BI6Lg.A\bbI6Lgn\u00117jK:$x\fJ3r)\ti\u0004\t\u0005\u0002'}%\u0011qh\n\u0002\u0005+:LG\u000fC\u0004B\u000b\u0005\u0005\t\u0019\u0001\u0018\u0002\u0007a$\u0013'\u0001\u0007bI6Lgn\u00117jK:$\b%A\bhK:,'/\u0019;f\u0007>tg-[4t+\u0005)\u0005c\u0001$O#:\u0011q\t\u0014\b\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015F\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0015\n\u00055;\u0013a\u00029bG.\fw-Z\u0005\u0003\u001fB\u00131aU3r\u0015\tiu\u0005\u0005\u0002#%&\u00111+\u0004\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0003tKR,\b\u000fF\u0001>Q\tAq\u000b\u0005\u0002Y?6\t\u0011L\u0003\u0002[7\u0006\u0019\u0011\r]5\u000b\u0005qk\u0016a\u00026va&$XM\u001d\u0006\u0003=^\nQA[;oSRL!\u0001Y-\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0003dY>\u001cX\r\u000b\u0002\nGB\u0011\u0001\fZ\u0005\u0003Kf\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002MQ,7\u000f\u001e$fi\u000eD\u0007+\u0019:uSRLwN\u001c)sk:Lgn\u001a#z]\u0006l\u0017nY\"p]\u001aLw\r\u000b\u0002\u000bQB\u0011\u0001,[\u0005\u0003Uf\u0013A\u0001V3ti\u0006Y\u0011\r\u001c;fe\u000e{gNZ5h)\riTn\u001e\u0005\u0006].\u0001\ra\\\u0001\u0005]\u0006lW\r\u0005\u0002qi:\u0011\u0011O\u001d\t\u0003\u0011\u001eJ!a]\u0014\u0002\rA\u0013X\rZ3g\u0013\t)hO\u0001\u0004TiJLgn\u001a\u0006\u0003g\u001eBQ\u0001_\u0006A\u0002=\fQA^1mk\u0016\u0004")
public class ReplicaManagerConfigIntegrationTest
extends KafkaServerTestHarness {
    private final int numServers;
    private Admin adminClient;

    public int numServers() {
        return this.numServers;
    }

    public Admin adminClient() {
        return this.adminClient;
    }

    public void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numServers()).map((Function1 & Serializable & scala.Serializable)brokerId -> TestUtils$.MODULE$.createBrokerConfig(BoxesRunTime.unboxToInt((Object)brokerId), this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), IndexedSeq$.MODULE$.canBuildFrom());
    }

    @BeforeEach
    public void setup() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList());
        this.adminClient_$eq(Admin.create((Properties)props));
    }

    @AfterEach
    public void close() {
        if (this.adminClient() != null) {
            this.adminClient().close();
        }
    }

    @Test
    public void testFetchPartitionPruningDynamicConfig() {
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            ReplicaManagerConfigIntegrationTest.$anonfun$testFetchPartitionPruningDynamicConfig$1(server);
            return BoxedUnit.UNIT;
        });
        this.alterConfig("confluent.fetch.partition.pruning.enable", "false");
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            ReplicaManagerConfigIntegrationTest.$anonfun$testFetchPartitionPruningDynamicConfig$2(server);
            return BoxedUnit.UNIT;
        });
        this.alterConfig("confluent.fetch.partition.pruning.enable", "true");
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            ReplicaManagerConfigIntegrationTest.$anonfun$testFetchPartitionPruningDynamicConfig$4(server);
            return BoxedUnit.UNIT;
        });
    }

    private void alterConfig(String name, String value) {
        this.adminClient().incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singletonList(new AlterConfigOp(new ConfigEntry(name, value), AlterConfigOp.OpType.SET)))).all().get();
    }

    public static final /* synthetic */ void $anonfun$testFetchPartitionPruningDynamicConfig$1(KafkaServer server) {
        Assertions.assertTrue((boolean)server.replicaManager().fetchPartitionPruningEnabled(), (String)"Optimization should be enabled by default");
    }

    public static final /* synthetic */ void $anonfun$testFetchPartitionPruningDynamicConfig$3(KafkaServer server$1) {
        Assertions.assertFalse((boolean)server$1.replicaManager().fetchPartitionPruningEnabled(), (String)"Optimization should be disabled");
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testFetchPartitionPruningDynamicConfig$2(KafkaServer server) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 15000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ReplicaManagerConfigIntegrationTest.$anonfun$testFetchPartitionPruningDynamicConfig$3(server);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testFetchPartitionPruningDynamicConfig$5(KafkaServer server$2) {
        Assertions.assertTrue((boolean)server$2.replicaManager().fetchPartitionPruningEnabled(), (String)"Optimization should be enabled");
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testFetchPartitionPruningDynamicConfig$4(KafkaServer server) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 15000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                ReplicaManagerConfigIntegrationTest.$anonfun$testFetchPartitionPruningDynamicConfig$5(server);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public ReplicaManagerConfigIntegrationTest() {
        this.numServers = 3;
    }
}

