/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogOffsetSnapshot;
import kafka.server.AbstractLogReadResult;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchMetadata;
import kafka.server.FullPartitionFetchMetadata;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.MetadataCache;
import kafka.server.MetadataCache$;
import kafka.server.PartitionFetchMetadata;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.server.TierReplicaComponents$;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mh\u0001B\u0011#\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013\u00051\u0007\u0003\u0004>\u0001\u0001\u0006I\u0001\u000e\u0005\b}\u0001\u0011\r\u0011\"\u0001@\u0011\u00191\u0005\u0001)A\u0005\u0001\"9q\t\u0001b\u0001\n\u0003A\u0005BB+\u0001A\u0003%\u0011\nC\u0004W\u0001\t\u0007I\u0011A,\t\ru\u0003\u0001\u0015!\u0003Y\u0011\u001dq\u0006A1A\u0005\u0002}Ca\u0001\u001a\u0001!\u0002\u0013\u0001\u0007bB3\u0001\u0005\u0004%\ta\u0018\u0005\u0007M\u0002\u0001\u000b\u0011\u00021\t\u000f\u001d\u0004!\u0019!C\u0001Q\"1\u0001\u000f\u0001Q\u0001\n%D\u0011\"\u001d\u0001A\u0002\u0003\u0007I\u0011\u0001:\t\u0017\u0005\r\u0001\u00011AA\u0002\u0013\u0005\u0011Q\u0001\u0005\u000b\u0003#\u0001\u0001\u0019!A!B\u0013\u0019\bbCA\n\u0001\u0001\u0007\t\u0019!C\u0001\u0003+A1\"!\b\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002 !Y\u00111\u0005\u0001A\u0002\u0003\u0005\u000b\u0015BA\f\u0011\u001d\t)\u0003\u0001C\u0001\u0003OAq!a\u0010\u0001\t\u0003\t9\u0003C\u0004\u0002D\u0001!\t!a\n\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002(!9\u00111\n\u0001\u0005\u0002\u0005\u001d\u0002bBA(\u0001\u0011\u0005\u0011\u0011\u000b\u0005\n\u0003W\u0002\u0011\u0013!C\u0001\u0003[B\u0011\"a!\u0001#\u0003%\t!!\"\t\u000f\u0005%\u0005\u0001\"\u0001\u0002(!9\u00111\u0013\u0001\u0005\u0002\u0005U\u0005bBAT\u0001\u0011%\u0011\u0011\u0016\u0002\u0019%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s#V|G/Y:UKN$(BA\u0012%\u0003\u0019\u0019XM\u001d<fe*\tQ%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0003CA\u0015-\u001b\u0005Q#\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002aA\u0011\u0011\u0007A\u0007\u0002E\u000591m\u001c8gS\u001e\u001cX#\u0001\u001b\u0011\u0007UB$(D\u00017\u0015\t9$&\u0001\u0006d_2dWm\u0019;j_:L!!\u000f\u001c\u0003\u0007M+\u0017\u000f\u0005\u00022w%\u0011AH\t\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0005d_:4\u0017nZ:!\u0003\u0011!\u0018.\\3\u0016\u0003\u0001\u0003\"!\u0011#\u000e\u0003\tS!a\u0011\u0013\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0015\u0013%\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u000f5,GO]5dgV\t\u0011\n\u0005\u0002K'6\t1J\u0003\u0002H\u0019*\u0011QJT\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015z%B\u0001)R\u0003\u0019\t\u0007/Y2iK*\t!+A\u0002pe\u001eL!\u0001V&\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0004sK\u000e|'\u000fZ\u000b\u00021B\u0011\u0011lW\u0007\u00025*\u0011a\u000bT\u0005\u00039j\u0013AbU5na2,'+Z2pe\u0012\fqA]3d_J$\u0007%A\bu_BL7\rU1si&$\u0018n\u001c82+\u0005\u0001\u0007CA1c\u001b\u0005a\u0015BA2M\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|g.\r\u0011\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]J\n\u0001\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gN\r\u0011\u0002\u0013\u0019,Go\u00195J]\u001a|W#A5\u0011\u0007UB$\u000e\u0005\u0003*W\u0002l\u0017B\u00017+\u0005\u0019!V\u000f\u001d7feA\u0011\u0011G\\\u0005\u0003_\n\u0012!DR;mYB\u000b'\u000f^5uS>tg)\u001a;dQ6+G/\u00193bi\u0006\f!BZ3uG\"LeNZ8!\u00031\tXo\u001c;b\u001b\u0006t\u0017mZ3s+\u0005\u0019\bC\u0001;\u007f\u001d\t)HP\u0004\u0002ww:\u0011qO_\u0007\u0002q*\u0011\u0011PJ\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015J!a\t\u0013\n\u0005u\u0014\u0013\u0001D)v_R\fg)Y2u_JL\u0018bA@\u0002\u0002\ti\u0011+^8uC6\u000bg.Y4feNT!! \u0012\u0002!E,x\u000e^1NC:\fw-\u001a:`I\u0015\fH\u0003BA\u0004\u0003\u001b\u00012!KA\u0005\u0013\r\tYA\u000b\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0010E\t\t\u00111\u0001t\u0003\rAH%M\u0001\u000ecV|G/Y'b]\u0006<WM\u001d\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\u0011\u0011q\u0003\t\u0004c\u0005e\u0011bAA\u000eE\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018A\u0005:fa2L7-Y'b]\u0006<WM]0%KF$B!a\u0002\u0002\"!I\u0011q\u0002\u000b\u0002\u0002\u0003\u0007\u0011qC\u0001\u0010e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3sA\u0005Q3\u000f[8vY\u0012,\u0005p\u00197vI\u0016\u001cVOY:fcV,g\u000e\u001e+ie>$H\u000f\\3e!\u0006\u0014H/\u001b;j_:\u001cHCAA\u0004Q\r1\u00121\u0006\t\u0005\u0003[\tY$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003\r\t\u0007/\u001b\u0006\u0005\u0003k\t9$A\u0004kkBLG/\u001a:\u000b\u0007\u0005e\u0012+A\u0003kk:LG/\u0003\u0003\u0002>\u0005=\"\u0001\u0002+fgR\f\u0011h\u001d5pk2$w)\u001a;O_6+7o]1hKNLe-U;pi\u0006\u001cX\t_2fK\u0012,Gm\u00148Tk\n\u001cX-];f]R\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004/\u0005-\u0012AI:i_VdGmR3u\u0005>$\b.T3tg\u0006<Wm]%g#V|G/Y:BY2|w\u000fK\u0002\u0019\u0003W\tAe\u001d5pk2$\u0017J\\2mk\u0012,\u0017J\\*z]\u000e$\u0006N]8ui2,GMU3qY&\u001c\u0017m\u001d\u0015\u00043\u0005-\u0012a\f;fgR\u001cu.\u001c9mKR,\u0017J\u001c#fY\u0006LX\r\u001a$fi\u000eDw+\u001b;i%\u0016\u0004H.[2b)\"\u0014x\u000e\u001e;mS:<\u0007f\u0001\u000e\u0002,\u0005Q1/\u001a;Va6{7m[:\u0015\u0011\u0005\u001d\u00111KA0\u0003CBaaZ\u000eA\u0002\u0005U\u0003\u0003B\u001b9\u0003/\u0002R!K6a\u00033\u00022!MA.\u0013\r\tiF\t\u0002\u0017!\u0006\u0014H/\u001b;j_:4U\r^2i\u001b\u0016$\u0018\rZ1uC\"9ak\u0007I\u0001\u0002\u0004A\u0006\"CA27A\u0005\t\u0019AA3\u0003I\u0011w\u000e\u001e5SKBd\u0017nY1t\u0013:\u001c\u0016P\\2\u0011\u0007%\n9'C\u0002\u0002j)\u0012qAQ8pY\u0016\fg.\u0001\u000btKR,\u0006/T8dWN$C-\u001a4bk2$HEM\u000b\u0003\u0003_R3\u0001WA9W\t\t\u0019\b\u0005\u0003\u0002v\u0005}TBAA<\u0015\u0011\tI(a\u001f\u0002\u0013Ut7\r[3dW\u0016$'bAA?U\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0015q\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001F:fiV\u0003Xj\\2lg\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\b*\"\u0011QMA9\u0003!!X-\u0019:E_^t\u0007f\u0001\u0010\u0002\u000eB!\u0011QFAH\u0013\u0011\t\t*a\f\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017!C7pG.\fVo\u001c;b)\u0011\t9*!(\u0011\u0007E\nI*C\u0002\u0002\u001c\n\u0012ABU3qY&\u001c\u0017-U;pi\u0006Dq!a( \u0001\u0004\t\t+A\u0003c_VtG\rE\u0002*\u0003GK1!!*+\u0005\u0011auN\\4\u0002!I,\u0017\r\u001a$s_6dunY1m\u0019><GCEAV\u0003k\u000by,a1\u0002N\u0006E\u0017Q[Am\u0003;\u0004B!\u000e\u001d\u0002.B)\u0011f\u001b1\u00020B\u0019\u0011'!-\n\u0007\u0005M&EA\u0007M_\u001e\u0014V-\u00193SKN,H\u000e\u001e\u0005\b\u0003o\u0003\u0003\u0019AA]\u0003%\u0011X\r\u001d7jG\u0006LE\rE\u0002*\u0003wK1!!0+\u0005\rIe\u000e\u001e\u0005\b\u0003\u0003\u0004\u0003\u0019AA3\u0003M1W\r^2i\u001f:d\u0017P\u0012:p[2+\u0017\rZ3s\u0011\u001d\t)\r\ta\u0001\u0003\u000f\faBZ3uG\"L5o\u001c7bi&|g\u000eE\u00022\u0003\u0013L1!a3#\u000591U\r^2i\u0013N|G.\u0019;j_:Dq!a4!\u0001\u0004\tI,A\u0007gKR\u001c\u0007.T1y\u0005f$Xm\u001d\u0005\b\u0003'\u0004\u0003\u0019AA3\u0003EA\u0017M\u001d3NCb\u0014\u0015\u0010^3t\u0019&l\u0017\u000e\u001e\u0005\b\u0003/\u0004\u0003\u0019AA+\u0003E\u0011X-\u00193QCJ$\u0018\u000e^5p]&sgm\u001c\u0005\b\u00037\u0004\u0003\u0019AAL\u0003\u0015\tXo\u001c;b\u0011\u001d\ty\u000e\ta\u0001\u0003C\fab\u00197jK:$X*\u001a;bI\u0006$\u0018\rE\u0003*\u0003G\f9/C\u0002\u0002f*\u0012aa\u00149uS>t\u0007\u0003BAu\u0003_l!!a;\u000b\u0007\u00055H*A\u0004sKBd\u0017nY1\n\t\u0005E\u00181\u001e\u0002\u000f\u00072LWM\u001c;NKR\fG-\u0019;b\u0001")
public class ReplicaManagerQuotasTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, new Properties()), Seq$.MODULE$.canBuildFrom());
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final SimpleRecord record = new SimpleRecord("some-data-in-a-message".getBytes());
    private final TopicPartition topicPartition1 = new TopicPartition("test-topic", 1);
    private final TopicPartition topicPartition2 = new TopicPartition("test-topic", 2);
    private final Seq<Tuple2<TopicPartition, FullPartitionFetchMetadata>> fetchInfo = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition1()), (Object)new FullPartitionFetchMetadata(0L, 0L, 100, Optional.empty(), Optional.empty())), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition2()), (Object)new FullPartitionFetchMetadata(0L, 0L, 100, Optional.empty(), Optional.empty())), (List)Nil$.MODULE$));
    private QuotaFactory.QuotaManagers quotaManager;
    private ReplicaManager replicaManager;

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public SimpleRecord record() {
        return this.record;
    }

    public TopicPartition topicPartition1() {
        return this.topicPartition1;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Seq<Tuple2<TopicPartition, FullPartitionFetchMetadata>> fetchInfo() {
        return this.fetchInfo;
    }

    public QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    public void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Test
    public void shouldExcludeSubsequentThrottledPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq<Tuple2<TopicPartition, LogReadResult>> fetch = this.readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option<ClientMetadata>)None$.MODULE$);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$1(this, x$2))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with only one throttled, we should get the first");
        Assertions.assertEquals((int)0, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$2(this, x$3))).get())._2()).info().records().batches()).asScala()).size(), (String)"But we shouldn't get the second");
    }

    @Test
    public void shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq<Tuple2<TopicPartition, LogReadResult>> fetch = this.readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option<ClientMetadata>)None$.MODULE$);
        Assertions.assertEquals((int)0, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(this, x$4))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with both throttled, we should get no messages");
        Assertions.assertEquals((int)0, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(this, x$5))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with both throttled, we should get no messages");
        Assertions.assertEquals((long)0L, (long)this.replicaManager().throttledFollowerReplicasRate().count());
        Assertions.assertEquals((long)2L, (long)this.replicaManager().throttledLeaderReplicasRate().count());
    }

    @Test
    public void shouldGetBothMessagesIfQuotasAllow() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq<Tuple2<TopicPartition, LogReadResult>> fetch = this.readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option<ClientMetadata>)None$.MODULE$);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$1(this, x$6))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with both non-throttled, we should get both messages");
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$2(this, x$7))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with both non-throttled, we should get both messages");
    }

    @Test
    public void shouldIncludeInSyncThrottledReplicas() {
        Seq<Tuple2<TopicPartition, FullPartitionFetchMetadata>> x$1 = this.fetchInfo();
        boolean x$2 = true;
        SimpleRecord x$3 = this.setUpMocks$default$2();
        this.setUpMocks(x$1, x$3, x$2);
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq<Tuple2<TopicPartition, LogReadResult>> fetch = this.readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option<ClientMetadata>)None$.MODULE$);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$1(this, x$8))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with only one throttled, we should get the first");
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$2(this, x$9))).get())._2()).info().records().batches()).asScala()).size(), (String)"But we should get the second too since it's throttled but in sync");
    }

    @Test
    public void testCompleteInDelayedFetchWithReplicaThrottling() {
        Assertions.assertTrue((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$1(true).tryComplete(), (String)"In sync replica should complete");
        Assertions.assertFalse((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$1(false).tryComplete(), (String)"Out of sync replica should not complete");
    }

    public void setUpMocks(Seq<Tuple2<TopicPartition, PartitionFetchMetadata>> fetchInfo, SimpleRecord record, boolean bothReplicasInSync) {
        KafkaScheduler scheduler = (KafkaScheduler)EasyMock.createNiceMock(KafkaScheduler.class);
        AbstractLog log = (AbstractLog)EasyMock.createNiceMock(AbstractLog.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)0L)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)20L)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).andReturn((Object)BoxesRunTime.boxToLong((long)5L)).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.lastStableOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)5L)).anyTimes();
        EasyMock.expect((Object)log.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata(20L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())).anyTimes();
        EasyMock.expect((Object)log.read(BoxesRunTime.unboxToLong((Object)EasyMock.anyObject()), EasyMock.geq((int)1), (FetchIsolation)EasyMock.anyObject(), EasyMock.anyBoolean(), EasyMock.anyBoolean())).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{record}), FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4())).anyTimes();
        EasyMock.expect((Object)log.read(BoxesRunTime.unboxToLong((Object)EasyMock.anyObject()), EasyMock.eq((int)0), (FetchIsolation)EasyMock.anyObject(), EasyMock.anyBoolean(), EasyMock.anyBoolean())).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4())).anyTimes();
        EasyMock.replay((Object[])new Object[]{log});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog((TopicPartition)EasyMock.anyObject(), EasyMock.anyBoolean())).andReturn((Object)new Some((Object)log)).anyTimes();
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        AlterIsrManager alterIsrManager = (AlterIsrManager)EasyMock.createMock(AlterIsrManager.class);
        int leaderBrokerId = ((KafkaConfig)this.configs().head()).brokerId();
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""));
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), (Option)None$.MODULE$, (Scheduler)scheduler, logManager, new AtomicBoolean(false), this.quotaManager(), new BrokerTopicStats(), (MetadataCache)MetadataCache$.MODULE$.zkMetadataCache(((KafkaConfig)this.configs().head()).brokerId(), MetadataCache$.MODULE$.zkMetadataCache$default$2()), new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size()), TierReplicaComponents$.MODULE$.EMPTY(), (Option)None$.MODULE$, alterIsrManager, ReplicaManager$.MODULE$.$lessinit$greater$default$15()));
        fetchInfo.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            ReplicaManagerQuotasTest.$anonfun$setUpMocks$2(this, log, leaderBrokerId, bothReplicasInSync, x$10);
            return BoxedUnit.UNIT;
        });
    }

    public SimpleRecord setUpMocks$default$2() {
        return this.record();
    }

    public boolean setUpMocks$default$3() {
        return false;
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.replicaManager()).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
            x$11.shutdown(false);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaQuota mockQuota(long bound) {
        void var3_2;
        ReplicaQuota quota = (ReplicaQuota)EasyMock.createMock(ReplicaQuota.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isThrottled((TopicPartition)EasyMock.anyObject()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        return var3_2;
    }

    private Seq<Tuple2<TopicPartition, LogReadResult>> readFromLocalLog(int replicaId, boolean fetchOnlyFromLeader, FetchIsolation fetchIsolation, int fetchMaxBytes, boolean hardMaxBytesLimit, Seq<Tuple2<TopicPartition, PartitionFetchMetadata>> readPartitionInfo, ReplicaQuota quota, Option<ClientMetadata> clientMetadata) {
        return (Seq)this.replicaManager().readFromLocalLog(replicaId, fetchOnlyFromLeader, fetchIsolation, fetchMaxBytes, hardMaxBytesLimit, readPartitionInfo, quota, clientMetadata).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<TopicPartition, AbstractLogReadResult>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                if (x1 != null) {
                    TopicPartition topicPartition = (TopicPartition)x1._1();
                    AbstractLogReadResult result = (AbstractLogReadResult)x1._2();
                    if (result instanceof LogReadResult) {
                        LogReadResult logReadResult = (LogReadResult)result;
                        object = new Tuple2((Object)topicPartition, (Object)logReadResult);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<TopicPartition, AbstractLogReadResult> x1) {
                boolean bl = x1 != null && (AbstractLogReadResult)x1._2() instanceof LogReadResult;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$2) {
        Object object = x$2._1();
        TopicPartition topicPartition = $this.topicPartition1();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$3) {
        Object object = x$3._1();
        TopicPartition topicPartition = $this.topicPartition2();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$4) {
        Object object = x$4._1();
        TopicPartition topicPartition = $this.topicPartition1();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$5) {
        Object object = x$5._1();
        TopicPartition topicPartition = $this.topicPartition2();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$1(ReplicaManagerQuotasTest $this, Tuple2 x$6) {
        Object object = x$6._1();
        TopicPartition topicPartition = $this.topicPartition1();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$2(ReplicaManagerQuotasTest $this, Tuple2 x$7) {
        Object object = x$7._1();
        TopicPartition topicPartition = $this.topicPartition2();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$1(ReplicaManagerQuotasTest $this, Tuple2 x$8) {
        Object object = x$8._1();
        TopicPartition topicPartition = $this.topicPartition1();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$2(ReplicaManagerQuotasTest $this, Tuple2 x$9) {
        Object object = x$9._1();
        TopicPartition topicPartition = $this.topicPartition2();
        return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
    }

    private static final DelayedFetch setupDelayedFetch$1(boolean isReplicaInSync) {
        TopicPartition tp = new TopicPartition("t1", 0);
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(100L, 0L, 500);
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        Partition partition = (Partition)EasyMock.createMock(Partition.class);
        EasyMock.expect((Object)partition.topicPartition()).andReturn((Object)tp);
        LogOffsetSnapshot offsetSnapshot = new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata);
        EasyMock.expect((Object)partition.fetchOffsetSnapshot(Optional.empty(), true)).andReturn((Object)offsetSnapshot);
        ReplicaManager replicaManager = (ReplicaManager)EasyMock.createMock(ReplicaManager.class);
        EasyMock.expect((Object)replicaManager.getPartitionOrException((TopicPartition)EasyMock.anyObject())).andReturn((Object)partition).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.shouldLeaderThrottle((ReplicaQuota)EasyMock.anyObject(), (Partition)EasyMock.anyObject(), BoxesRunTime.unboxToInt((Object)EasyMock.anyObject())))).andReturn((Object)BoxesRunTime.boxToBoolean((!isReplicaInSync ? 1 : 0) != 0)).anyTimes();
        EasyMock.expect((Object)partition.getReplica(1)).andReturn((Object)None$.MODULE$);
        EasyMock.replay((Object[])new Object[]{replicaManager, partition});
        FullPartitionFetchMetadata fetchInfo = new FullPartitionFetchMetadata(50L, 0L, 1, Optional.empty(), Optional.empty());
        FetchMetadata fetchMetadata = new FetchMetadata(1, 1000, true, true, (FetchIsolation)FetchLogEnd$.MODULE$, true, 1, true, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)fetchInfo), (List)Nil$.MODULE$), (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new LogOffsetMetadata(50L, 0L, 250))})));
        return new DelayedFetch(null, fetchMetadata, replicaManager, brokerTopicStats){

            public boolean forceComplete() {
                return true;
            }
            {
                long x$1 = 600L;
                None$ x$5 = None$.MODULE$;
                None$ x$8 = None$.MODULE$;
                super(x$1, fetchMetadata$1, replicaManager$1, null, (Option)x$8, (Option)x$5, brokerTopicStats$1, null);
            }
        };
    }

    public static final /* synthetic */ void $anonfun$setUpMocks$2(ReplicaManagerQuotasTest $this, AbstractLog log$1, int leaderBrokerId$1, boolean bothReplicasInSync$1, Tuple2 x$10) {
        if (x$10 != null) {
            TopicPartition p = (TopicPartition)x$10._1();
            Partition partition = $this.replicaManager().createPartition(p);
            log$1.updateHighWatermark(5L);
            partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderBrokerId$1)));
            partition.setLog(log$1, false);
            partition.updateAssignmentAndIsr((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()})), bothReplicasInSync$1 ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()})) : (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, Predef$.MODULE$.Set().empty(), false, (Option)None$.MODULE$);
            return;
        }
        throw new MatchError(null);
    }
}

