/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import kafka.log.LogManager;
import kafka.server.BrokerConfigHandler;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig;
import kafka.server.DynamicConfigManager;
import kafka.server.DynamicConfigManager$;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ReplicationQuotaManagerConfig$;
import kafka.server.ReplicationQuotasTest$ReplicationResults$;
import kafka.server.ReplicationQuotasTest$ReplicationTestSettings$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r=f\u0001\u0002/^\u0001\tDQ!\u001b\u0001\u0005\u0002)DQ!\u001c\u0001\u0005\u00029Dq\u0001 \u0001C\u0002\u0013\u0005Q\u0010C\u0004\u0002\n\u0001\u0001\u000b\u0011\u0002@\t\u0013\u0005-\u0001\u00011A\u0005\u0002\u00055\u0001\"CA\u0017\u0001\u0001\u0007I\u0011AA\u0018\u0011!\tY\u0004\u0001Q!\n\u0005=\u0001\"CA\u001f\u0001\t\u0007I\u0011AA \u0011!\t\t\u0006\u0001Q\u0001\n\u0005\u0005\u0003\"CA*\u0001\u0001\u0007I\u0011AA+\u0011%\ty\u0007\u0001a\u0001\n\u0003\t\t\b\u0003\u0005\u0002v\u0001\u0001\u000b\u0015BA,\u0011\u001d\t9\b\u0001C!\u0003sBq!!%\u0001\t\u0003\tI\bC\u0004\u0002\u001c\u0002!\t!!\u001f\t\u000f\u0005}\u0005\u0001\"\u0001\u0002z!9\u00111\u0015\u0001\u0005\u0002\u0005e\u0004bBAT\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0005\u0013\u0003A\u0011\u0001BF\u0011\u001d\u0011\t\n\u0001C\u0001\u0005'CqAa&\u0001\t\u0003\tI\bC\u0004\u0003\u001c\u0002!\t!!\u001f\t\u000f\t}\u0005\u0001\"\u0001\u0002z!9!1\u0015\u0001\u0005\u0002\t\u0015\u0006b\u0002BV\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0005_\u0003A\u0011AA=\u0011\u001d\u0011\u0019\f\u0001C\u0001\u0005kCqA!/\u0001\t\u0003\u0011Y\fC\u0004\u0003N\u0002!\tAa4\t\u000f\tU\u0007\u0001\"\u0003\u0003X\"9!1\u001d\u0001\u0005\n\t\u0015hA\u0002B1\u0001\u0001\u0013\u0019\u0007\u0003\u0006\u0003f\u0001\u0012)\u001a!C\u0001\u0003#D\u0011Ba\u001a!\u0005#\u0005\u000b\u0011B8\t\u0015\t%\u0004E!f\u0001\n\u0003\t\t\u000eC\u0005\u0003l\u0001\u0012\t\u0012)A\u0005_\"1\u0011\u000e\tC\u0001\u0005[B\u0011\"!>!\u0003\u0003%\tAa\u001d\t\u0013\t\u0005\u0001%%A\u0005\u0002\t\r\u0001\"\u0003B\rAE\u0005I\u0011\u0001B\u0002\u0011%\u0011Y\u0003IA\u0001\n\u0003\ny\u0004C\u0005\u0003.\u0001\n\t\u0011\"\u0001\u0002X\"I!q\u0006\u0011\u0002\u0002\u0013\u0005!\u0011\u0010\u0005\n\u0005w\u0001\u0013\u0011!C!\u0005{A\u0011Ba\u0013!\u0003\u0003%\tA! \t\u0013\tE\u0003%!A\u0005B\tM\u0003\"\u0003B+A\u0005\u0005I\u0011\tB,\u0011%\u0011I\u0006IA\u0001\n\u0003\u0012\tiB\u0005\u0003l\u0002\t\t\u0011#\u0001\u0003n\u001aI!\u0011\r\u0001\u0002\u0002#\u0005!q\u001e\u0005\u0007SJ\"\tA!@\t\u0013\tU#'!A\u0005F\t]\u0003\"\u0003B\u0000e\u0005\u0005I\u0011QB\u0001\u0011%\u00199AMA\u0001\n\u0003\u001bIA\u0002\u0004\u0002:\u0002\u0001\u00151\u0018\u0005\u000b\u0003\u001f<$Q3A\u0005\u0002\u0005E\u0007\"CAjo\tE\t\u0015!\u0003p\u0011)\t)n\u000eBK\u0002\u0013\u0005\u0011q\u001b\u0005\n\u00033<$\u0011#Q\u0001\n]D\u0011\"a78\u0005+\u0007I\u0011A?\t\u0013\u0005uwG!E!\u0002\u0013q\bBCApo\tU\r\u0011\"\u0001\u0002b\"Q\u0011\u0011^\u001c\u0003\u0012\u0003\u0006I!a9\t\r%<D\u0011AAv\u0011%\t)pNA\u0001\n\u0003\t9\u0010C\u0005\u0003\u0002]\n\n\u0011\"\u0001\u0003\u0004!I!\u0011D\u001c\u0012\u0002\u0013\u0005!1\u0004\u0005\n\u0005?9\u0014\u0013!C\u0001\u0005CA\u0011B!\n8#\u0003%\tAa\n\t\u0013\t-r'!A\u0005B\u0005}\u0002\"\u0003B\u0017o\u0005\u0005I\u0011AAl\u0011%\u0011ycNA\u0001\n\u0003\u0011\t\u0004C\u0005\u0003<]\n\t\u0011\"\u0011\u0003>!I!1J\u001c\u0002\u0002\u0013\u0005!Q\n\u0005\n\u0005#:\u0014\u0011!C!\u0005'B\u0011B!\u00168\u0003\u0003%\tEa\u0016\t\u0013\tes'!A\u0005B\tms!CB\f\u0001\u0005\u0005\t\u0012AB\r\r%\tI\fAA\u0001\u0012\u0003\u0019Y\u0002\u0003\u0004j\u001f\u0012\u000511\u0005\u0005\n\u0005+z\u0015\u0011!C#\u0005/B\u0011Ba@P\u0003\u0003%\ti!\n\t\u0013\r\u001dq*!A\u0005\u0002\u000e=\u0002bBB\u001e\u0001\u0011\u00051Q\b\u0005\b\u0007\u001f\u0002A\u0011AB)\u0011%\u0019)\u0007AI\u0001\n\u0003\u00119\u0003C\u0005\u0004h\u0001\t\n\u0011\"\u0001\u0003(!91\u0011\u000e\u0001\u0005\u0002\r-\u0004bBB@\u0001\u0011%1\u0011\u0011\u0005\b\u0007+\u0003A\u0011BBL\u0011\u001d\u0019\t\u000b\u0001C\u0001\u0007G\u0013QCU3qY&\u001c\u0017\r^5p]F+x\u000e^1t)\u0016\u001cHO\u0003\u0002_?\u000611/\u001a:wKJT\u0011\u0001Y\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\r\u0005\u0002eO6\tQM\u0003\u0002g?\u0006\u0011!p[\u0005\u0003Q\u0016\u0014ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001l!\ta\u0007!D\u0001^\u00031\u0001XM]2f]R,%O]8s)\ryWO\u001f\t\u0003aNl\u0011!\u001d\u0006\u0002e\u0006)1oY1mC&\u0011A/\u001d\u0002\u0005\u0019>tw\rC\u0003w\u0005\u0001\u0007q/A\u0004qKJ\u001cWM\u001c;\u0011\u0005AD\u0018BA=r\u0005\rIe\u000e\u001e\u0005\u0006w\n\u0001\ra\\\u0001\u0006m\u0006dW/Z\u0001\t[N<\u0017\u0007\r\u0019L\u0005V\ta\u0010\u0005\u0003q\u007f\u0006\r\u0011bAA\u0001c\n)\u0011I\u001d:bsB\u0019\u0001/!\u0002\n\u0007\u0005\u001d\u0011O\u0001\u0003CsR,\u0017!C7tOF\u0002\u0004g\u0013\"!\u0003\u001d\u0011'o\\6feN,\"!a\u0004\u0011\r\u0005E\u0011\u0011EA\u0014\u001d\u0011\t\u0019\"!\b\u000f\t\u0005U\u00111D\u0007\u0003\u0003/Q1!!\u0007b\u0003\u0019a$o\\8u}%\t!/C\u0002\u0002 E\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002$\u0005\u0015\"aA*fc*\u0019\u0011qD9\u0011\u00071\fI#C\u0002\u0002,u\u00131bS1gW\u0006\u001cVM\u001d<fe\u0006Y!M]8lKJ\u001cx\fJ3r)\u0011\t\t$a\u000e\u0011\u0007A\f\u0019$C\u0002\u00026E\u0014A!\u00168ji\"I\u0011\u0011\b\u0004\u0002\u0002\u0003\u0007\u0011qB\u0001\u0004q\u0012\n\u0014\u0001\u00032s_.,'o\u001d\u0011\u0002\u000bQ|\u0007/[2\u0016\u0005\u0005\u0005\u0003\u0003BA\"\u0003\u001bj!!!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\u0005Y\u0006twM\u0003\u0002\u0002L\u0005!!.\u0019<b\u0013\u0011\ty%!\u0012\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005A\u0001O]8ek\u000e,'/\u0006\u0002\u0002XA1\u0011\u0011LA6}zl!!a\u0017\u000b\t\u0005M\u0013Q\f\u0006\u0005\u0003?\n\t'A\u0004dY&,g\u000e^:\u000b\u0007\u0001\f\u0019G\u0003\u0003\u0002f\u0005\u001d\u0014AB1qC\u000eDWM\u0003\u0002\u0002j\u0005\u0019qN]4\n\t\u00055\u00141\f\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0002\u0019A\u0014x\u000eZ;dKJ|F%Z9\u0015\t\u0005E\u00121\u000f\u0005\n\u0003sY\u0011\u0011!a\u0001\u0003/\n\u0011\u0002\u001d:pIV\u001cWM\u001d\u0011\u0002\u0011Q,\u0017M\u001d#po:$\"!!\r)\u00075\ti\b\u0005\u0003\u0002\u0000\u00055UBAAA\u0015\u0011\t\u0019)!\"\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\b\u0006%\u0015a\u00026va&$XM\u001d\u0006\u0005\u0003\u0017\u000b9'A\u0003kk:LG/\u0003\u0003\u0002\u0010\u0006\u0005%!C!gi\u0016\u0014X)Y2i\u0003-\u001a\bn\\;mI\n{w\u000e^:ue\u0006\u0004Hk^8Ce>\\WM]:XSRDG*Z1eKJ$\u0006N]8ui2,\u0007f\u0001\b\u0002\u0016B!\u0011qPAL\u0013\u0011\tI*!!\u0003\tQ+7\u000f^\u0001.g\"|W\u000f\u001c3C_>$8\u000f\u001e:baR;xN\u0011:pW\u0016\u00148oV5uQ\u001a{G\u000e\\8xKJ$\u0006N]8ui2,\u0007fA\b\u0002\u0016\u0006Y4\u000f[8vY\u0012\u0014un\u001c;tiJ\f\u0007\u000fV<p\u0005J|7.\u001a:t/&$\bN\u0011:pW\u0016\u0014(+\u001a9mS\u000e\f7OR8mY><XM\u001d+ie>$H\u000f\\3)\u0007A\t)*A\u001dtQ>,H\u000e\u001a\"p_R\u001cHO]1q)^|'I]8lKJ\u001cx+\u001b;i\u0005J|7.\u001a:SKBd\u0017nY1t\u0019\u0016\fG-\u001a:UQJ|G\u000f\u001e7fQ\r\t\u0012QS\u0001\u0011g\"|W\u000f\u001c3NCR\u001c\u0007.U;pi\u0006$b!!\r\u0002,\n\u0015\u0005bBAW%\u0001\u0007\u0011qV\u0001\u0010e\u0016\u0004H.[2bi&|g\u000eV3tiB9\u0001/!-\u00026\n}\u0013bAAZc\nIa)\u001e8di&|g.\r\t\u0004\u0003o;T\"\u0001\u0001\u0003/I+\u0007\u000f\\5dCRLwN\u001c+fgR\u001cV\r\u001e;j]\u001e\u001c8cB\u001c\u0002>\u0006\r\u0017\u0011\u001a\t\u0004a\u0006}\u0016bAAac\n1\u0011I\\=SK\u001a\u00042\u0001]Ac\u0013\r\t9-\u001d\u0002\b!J|G-^2u!\r\u0001\u00181Z\u0005\u0004\u0003\u001b\f(\u0001D*fe&\fG.\u001b>bE2,\u0017!\u0004;ie>$H\u000f\\3CsR,7/F\u0001p\u00039!\bN]8ui2,')\u001f;fg\u0002\n\u0001\"\\:h\u0007>,h\u000e^\u000b\u0002o\u0006IQn]4D_VtG\u000fI\u0001\u0004[N<\u0017\u0001B7tO\u0002\na\u0002\u001e5s_R$H.\u001a'fC\u0012,'/\u0006\u0002\u0002dB\u0019\u0001/!:\n\u0007\u0005\u001d\u0018OA\u0004C_>dW-\u00198\u0002\u001fQD'o\u001c;uY\u0016dU-\u00193fe\u0002\"\"\"!.\u0002n\u0006=\u0018\u0011_Az\u0011\u0019\ty\r\u0011a\u0001_\"1\u0011Q\u001b!A\u0002]Da!a7A\u0001\u0004q\bbBAp\u0001\u0002\u0007\u00111]\u0001\u0005G>\u0004\u0018\u0010\u0006\u0006\u00026\u0006e\u00181`A\u007f\u0003\u007fD\u0001\"a4B!\u0003\u0005\ra\u001c\u0005\t\u0003+\f\u0005\u0013!a\u0001o\"A\u00111\\!\u0011\u0002\u0003\u0007a\u0010C\u0005\u0002`\u0006\u0003\n\u00111\u0001\u0002d\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001B\u0003U\ry'qA\u0016\u0003\u0005\u0013\u0001BAa\u0003\u0003\u00165\u0011!Q\u0002\u0006\u0005\u0005\u001f\u0011\t\"A\u0005v]\u000eDWmY6fI*\u0019!1C9\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0018\t5!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u000fU\r9(qA\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\u0019CK\u0002\u007f\u0005\u000f\tabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0003*)\"\u00111\u001dB\u0004\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003\u0002B\u001a\u0005s\u00012\u0001\u001dB\u001b\u0013\r\u00119$\u001d\u0002\u0004\u0003:L\b\u0002CA\u001d\u0011\u0006\u0005\t\u0019A<\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0010\u0011\r\t\u0005#q\tB\u001a\u001b\t\u0011\u0019EC\u0002\u0003FE\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011IEa\u0011\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003G\u0014y\u0005C\u0005\u0002:)\u000b\t\u00111\u0001\u00034\u0005A\u0001.Y:i\u0007>$W\rF\u0001x\u0003!!xn\u0015;sS:<GCAA!\u0003\u0019)\u0017/^1mgR!\u00111\u001dB/\u0011%\tI$TA\u0001\u0002\u0004\u0011\u0019\u0004E\u0002\u00028\u0002\u0012!CU3qY&\u001c\u0017\r^5p]J+7/\u001e7ugN9\u0001%!0\u0002D\u0006%\u0017aD;oi\"\u0014x\u000e\u001e;mK\u0012$\u0016.\\3\u0002!UtG\u000f\u001b:piRdW\r\u001a+j[\u0016\u0004\u0013!\u0004;ie>$H\u000f\\3e)&lW-\u0001\buQJ|G\u000f\u001e7fIRKW.\u001a\u0011\u0015\r\t}#q\u000eB9\u0011\u0019\u0011)'\na\u0001_\"1!\u0011N\u0013A\u0002=$bAa\u0018\u0003v\t]\u0004\u0002\u0003B3MA\u0005\t\u0019A8\t\u0011\t%d\u0005%AA\u0002=$BAa\r\u0003|!A\u0011\u0011H\u0016\u0002\u0002\u0003\u0007q\u000f\u0006\u0003\u0002d\n}\u0004\"CA\u001d[\u0005\u0005\t\u0019\u0001B\u001a)\u0011\t\u0019Oa!\t\u0013\u0005e\u0002'!AA\u0002\tM\u0002b\u0002BD%\u0001\u0007\u00111]\u0001\u0013i\u0016\u001cH\u000fT3bI\u0016\u0014H\u000b\u001b:piRdW-\u0001\u0013sKBd\u0017nY1uK^KG\u000f[*uCRL7\r\u00165s_R$H.\u001a3SKBd\u0017nY1t)\u0011\u0011yF!$\t\u000f\t=5\u00031\u0001\u00026\u0006A1/\u001a;uS:<7/\u0001!sKBd\u0017nY1uK^KG\u000f\u001b#z]\u0006l\u0017n\u0019+ie>$H\u000f\\3e%\u0016\u0004H.[2bgRC'o\\;hQ\u0006s\u0017i]=n[\u0016$(/[2U_B|Gn\\4z)\u0011\u0011yF!&\t\u000f\t=E\u00031\u0001\u00026\u0006I2\u000f[8vY\u0012$\u0006N]8ui2,w\n\u001c3TK\u001elWM\u001c;tQ\r)\u0012QS\u0001!i\u0016\u001cHOR8mY><XM]%t)\"\u0014x\u000e\u001e;mK\u0012|en\u0015;beR,\b\u000fK\u0002\u0017\u0003+\u000b!\u0007^3ti\u001a{G\u000e\\8xKJL5\u000f\u00165s_R$H.\u001a3P]N#\u0018M\u001d;va^KG\u000f[\"mkN$XM\u001d'j].Lgn\u001a\u0015\u0004/\u0005U\u0015A\t<fe&4\u0017PR8mY><XM]%t)\"\u0014x\u000e\u001e;mK\u0012|en\u0015;beR,\b\u000f\u0006\u0003\u00022\t\u001d\u0006b\u0002BU1\u0001\u0007\u00111]\u0001\u0012G2,8\u000f^3s\u0019&t7.\u00128bE2,\u0017a\r;fgR4u\u000e\u001c7po\u0016\u00148i\u001c8gS\u001eL5/\u00168dQ\u0006tw-\u001a3P]\u0006\u001bG/\u001b<f\t&\u001c8\u000e\u00165s_R$H.\u001b8hQ\rI\u0012QS\u0001Fi\u0016\u001cHOR8mY><XM]\"p]\u001aLw-S:V]\u000eD\u0017M\\4fI>s\u0017i\u0019;jm\u0016$\u0015n]6UQJ|G\u000f\u001e7j]\u001e<\u0016\u000e\u001e5DYV\u001cH/\u001a:MS:\\\u0017N\\4)\u0007i\t)*A\u001bwKJLg-\u001f$pY2|w/\u001a:D_:4\u0017nZ%t+:\u001c\u0007.\u00198hK\u0012|e.Q2uSZ,G)[:l)\"\u0014x\u000e\u001e;mS:<G\u0003BA\u0019\u0005oCqA!+\u001c\u0001\u0004\t\u0019/A\u0017de\u0016\fG/\u001a\"s_.,'oV5uQ\u0012K7o[+tC\u001e,')Y:fIRC'o\u001c;uY&tw-T1zE\u0016$\u0002\"a\n\u0003>\n\u0005'1\u001a\u0005\u0007\u0005\u007fc\u0002\u0019A<\u0002\u0011\t\u0014xn[3s\u0013\u0012DqAa1\u001d\u0001\u0004\u0011)-A\u0006uQJ|G\u000f\u001e7f\u001fB$\b\u0003\u00029\u0003H>L1A!3r\u0005\u0019y\u0005\u000f^5p]\"9!\u0011\u0016\u000fA\u0002\u0005\r\u0018aB1eI\u0012\u000bG/\u0019\u000b\u0007\u0003c\u0011\tNa5\t\r\u0005UW\u00041\u0001x\u0011\u0019\tY.\ba\u0001}\u0006)r/Y5u\r>\u0014xJ\u001a4tKR\u001cHk\\'bi\u000eDG\u0003CA\u0019\u00053\u0014iN!9\t\r\tmg\u00041\u0001x\u0003\u0019ygMZ:fi\"1!q\u001c\u0010A\u0002]\f1\u0002]1si&$\u0018n\u001c8JI\"1!q\u0018\u0010A\u0002]\f\u0011B\u0019:pW\u0016\u0014hi\u001c:\u0015\t\u0005\u001d\"q\u001d\u0005\u0007\u0005S|\u0002\u0019A<\u0002\u0005%$\u0017A\u0005*fa2L7-\u0019;j_:\u0014Vm];miN\u00042!a.3'\u0015\u0011$\u0011_Ae!!\u0011\u0019P!?p_\n}SB\u0001B{\u0015\r\u001190]\u0001\beVtG/[7f\u0013\u0011\u0011YP!>\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0003n\u0006)\u0011\r\u001d9msR1!qLB\u0002\u0007\u000bAaA!\u001a6\u0001\u0004y\u0007B\u0002B5k\u0001\u0007q.A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r-11\u0003\t\u0006a\n\u001d7Q\u0002\t\u0006a\u000e=qn\\\u0005\u0004\u0007#\t(A\u0002+va2,'\u0007C\u0005\u0004\u0016Y\n\t\u00111\u0001\u0003`\u0005\u0019\u0001\u0010\n\u0019\u0002/I+\u0007\u000f\\5dCRLwN\u001c+fgR\u001cV\r\u001e;j]\u001e\u001c\bcAA\\\u001fN)qj!\b\u0002JBY!1_B\u0010_^t\u00181]A[\u0013\u0011\u0019\tC!>\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0006\u0002\u0004\u001aQQ\u0011QWB\u0014\u0007S\u0019Yc!\f\t\r\u0005='\u000b1\u0001p\u0011\u0019\t)N\u0015a\u0001o\"1\u00111\u001c*A\u0002yDq!a8S\u0001\u0004\t\u0019\u000f\u0006\u0003\u00042\re\u0002#\u00029\u0003H\u000eM\u0002\u0003\u00039\u00046=<h0a9\n\u0007\r]\u0012O\u0001\u0004UkBdW\r\u000e\u0005\n\u0007+\u0019\u0016\u0011!a\u0001\u0003k\u000b!\u0001\u001e9\u0015\t\r}21\n\t\u0005\u0007\u0003\u001a9%\u0004\u0002\u0004D)!1QIA1\u0003\u0019\u0019w.\\7p]&!1\u0011JB\"\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Daa!\u0014U\u0001\u00049\u0018!\u00039beRLG/[8o\u00035\u0019'/Z1uK\n\u0013xn[3sgRQ\u0011\u0011GB*\u00073\u001aif!\u0019\t\u000f\rUS\u000b1\u0001\u0004X\u0005I!M]8lKJLEm\u001d\t\u0006\u0003#\t\tc\u001e\u0005\u0007\u00077*\u0006\u0019A8\u0002\u0011QD'o\u001c;uY\u0016D\u0011ba\u0018V!\u0003\u0005\r!a9\u0002?QD'o\u001c;uY\u0016\fE\u000e\u001c\"s_.,'\u000fT3bI\u0016\u0014(+\u001a9mS\u000e\f7\u000fC\u0005\u0004dU\u0003\n\u00111\u0001\u0002d\u0006\tC\u000f\u001b:piRdW-\u00117m\u0005J|7.\u001a:G_2dwn^3s%\u0016\u0004H.[2bg\u000692M]3bi\u0016\u0014%o\\6feN$C-\u001a4bk2$HeM\u0001\u0018GJ,\u0017\r^3Ce>\\WM]:%I\u00164\u0017-\u001e7uIQ\nq\u0003\u001e5s_R$H.\u001a3SKBd\u0017nY1t\u0007>tg-[4\u0015\t\r541\u0010\t\u0005\u0007_\u001a9H\u0004\u0003\u0004r\rM\u0004cAA\u000bc&\u00191QO9\u0002\rA\u0013X\rZ3g\u0013\u0011\tye!\u001f\u000b\u0007\rU\u0014\u000fC\u0004\u0004~a\u0003\r!a9\u00023MDw.\u001e7e)\"\u0014x\u000e\u001e;mK\u0006cGNU3qY&\u001c\u0017m]\u0001\u0007CZ\u0014\u0016\r^3\u0015\r\r\r5\u0011RBJ!\r\u00018QQ\u0005\u0004\u0007\u000f\u000b(A\u0002#pk\ndW\rC\u0004\u0004\ff\u0003\ra!$\u0002\u001fI,\u0007\u000f\\5dCRLwN\u001c+za\u0016\u00042\u0001\\BH\u0013\r\u0019\t*\u0018\u0002\n#V|G/\u0019+za\u0016Dq!a\u0003Z\u0001\u0004\u00199&\u0001\u0007nK\u0006\u001cXO]3e%\u0006$X\r\u0006\u0004\u0004\u0004\u000ee5Q\u0014\u0005\b\u00077S\u0006\u0019AA\u0014\u0003\u0019\u0011'o\\6fe\"91q\u0014.A\u0002\r5\u0015a\u0002:faRK\b/Z\u0001\u001cg\u0016$\u0018I\u001c3V]N,G\u000fR=oC6L7\r\u00165s_R$H.Z:\u0015\u0011\u0005E2QUBT\u0007WCq!a\u0003\\\u0001\u0004\u00199\u0006\u0003\u0004\u0004*n\u0003\ra\\\u0001\u0014gR\fG/[2UQJ|G\u000f\u001e7f\u0005f$Xm\u001d\u0005\u0007\u0007[[\u0006\u0019A8\u0002)\u0011Lh.Y7jGRC'o\u001c;uY\u0016\u0014\u0015\u0010^3t\u0001")
public class ReplicationQuotasTest
extends ZooKeeperTestHarness {
    private volatile ReplicationQuotasTest$ReplicationResults$ ReplicationResults$module;
    private volatile ReplicationQuotasTest$ReplicationTestSettings$ ReplicationTestSettings$module;
    private final byte[] msg100KB = new byte[100000];
    private Seq<KafkaServer> brokers = Nil$.MODULE$;
    private final String topic;
    private KafkaProducer<byte[], byte[]> producer = null;

    public ReplicationQuotasTest$ReplicationResults$ ReplicationResults() {
        if (this.ReplicationResults$module == null) {
            this.ReplicationResults$lzycompute$1();
        }
        return this.ReplicationResults$module;
    }

    public ReplicationQuotasTest$ReplicationTestSettings$ ReplicationTestSettings() {
        if (this.ReplicationTestSettings$module == null) {
            this.ReplicationTestSettings$lzycompute$1();
        }
        return this.ReplicationTestSettings$module;
    }

    public long percentError(int percent, long value) {
        return Math.round((double)(value * (long)percent) / 100.0);
    }

    public byte[] msg100KB() {
        return this.msg100KB;
    }

    public Seq<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    @Override
    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply(this.producer()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.shutdownServers(this.brokers());
        super.tearDown();
    }

    @Test
    public void shouldBootstrapTwoBrokersWithLeaderThrottle() {
        this.shouldMatchQuota((Function1<ReplicationTestSettings, ReplicationResults>)(Function1 & Serializable & scala.Serializable)settings -> this.replicateWithDynamicThrottledReplicasThroughAnAsymmetricTopology((ReplicationTestSettings)settings), true);
    }

    @Test
    public void shouldBootstrapTwoBrokersWithFollowerThrottle() {
        this.shouldMatchQuota((Function1<ReplicationTestSettings, ReplicationResults>)(Function1 & Serializable & scala.Serializable)settings -> this.replicateWithDynamicThrottledReplicasThroughAnAsymmetricTopology((ReplicationTestSettings)settings), false);
    }

    @Test
    public void shouldBootstrapTwoBrokersWithBrokerReplicasFollowerThrottle() {
        this.shouldMatchQuota((Function1<ReplicationTestSettings, ReplicationResults>)(Function1 & Serializable & scala.Serializable)settings -> this.replicateWithStaticThrottledReplicas((ReplicationTestSettings)settings), false);
    }

    @Test
    public void shouldBootstrapTwoBrokersWithBrokerReplicasLeaderThrottle() {
        this.shouldMatchQuota((Function1<ReplicationTestSettings, ReplicationResults>)(Function1 & Serializable & scala.Serializable)settings -> this.replicateWithStaticThrottledReplicas((ReplicationTestSettings)settings), true);
    }

    public void shouldMatchQuota(Function1<ReplicationTestSettings, ReplicationResults> replicationTest, boolean testLeaderThrottle) {
        byte[] msg = this.msg100KB();
        int msgCount = 100;
        int expectedDuration = 10;
        long throttle = msgCount * msg.length / expectedDuration;
        if (!testLeaderThrottle) {
            throttle *= 3L;
        }
        ReplicationResults replicationResults = (ReplicationResults)replicationTest.apply((Object)new ReplicationTestSettings(this, throttle, msgCount, msg, testLeaderThrottle));
        double throttledLowerBound = (double)(expectedDuration * 1000) * 0.9;
        int throttledUpperBound = expectedDuration * 1000 * 3;
        Assertions.assertTrue(((double)replicationResults.unthrottledTime() < throttledLowerBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(replicationResults.unthrottledTime()).append(" < ").append(throttledLowerBound).toString());
        Assertions.assertTrue(((double)replicationResults.throttledTime() > throttledLowerBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(replicationResults.throttledTime()).append(" > ").append(throttledLowerBound).toString());
        Assertions.assertTrue((replicationResults.throttledTime() < (long)throttledUpperBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(replicationResults.throttledTime()).append(" < ").append(throttledUpperBound).toString());
        double rateUpperBound = (double)throttle * 1.1;
        double rateLowerBound = (double)throttle * 0.5;
        double rate = testLeaderThrottle ? this.avRate((QuotaType)QuotaType.LeaderReplication$.MODULE$, (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 105)) : this.avRate((QuotaType)QuotaType.FollowerReplication$.MODULE$, (Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(106), 107));
        Assertions.assertTrue((rate < rateUpperBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(rate).append(" < ").append(rateUpperBound).toString());
        Assertions.assertTrue((rate > rateLowerBound ? 1 : 0) != 0, (String)new StringBuilder(12).append("Expected ").append(rate).append(" > ").append(rateLowerBound).toString());
    }

    public ReplicationResults replicateWithStaticThrottledReplicas(ReplicationTestSettings settings) {
        Range.Inclusive initialBrokers = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 105);
        this.createBrokers((Seq<Object>)initialBrokers, settings.throttleBytes(), settings.throttleLeader(), !settings.throttleLeader());
        this.createBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{108}))), settings.throttleBytes(), this.createBrokers$default$3(), this.createBrokers$default$4());
        this.setAndUnsetDynamicThrottles((Seq<Object>)initialBrokers, settings.throttleBytes(), 100L);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{104, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{105, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{108, 109})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)assignment, this.brokers());
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), settings.msgCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1 & Serializable & scala.Serializable)partition -> ReplicationQuotasTest.$anonfun$replicateWithStaticThrottledReplicas$2(this, settings, BoxesRunTime.unboxToInt((Object)partition))));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 100 + id));
        this.waitForOffsetsToMatch(settings.msgCount(), 6, 108);
        long start = System.currentTimeMillis();
        this.createBrokers((Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(106), 107), settings.throttleBytes(), settings.throttleLeader(), !settings.throttleLeader());
        this.createBrokers((Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(109), 109), settings.throttleBytes(), this.createBrokers$default$3(), this.createBrokers$default$4());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 107).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> {
            void var5_6;
            void var4_5;
            String string;
            ReplicationQuotaManager replicationQuotaManager;
            KafkaServer broker = this.brokerFor(brokerId);
            if (settings.throttleLeader()) {
                replicationQuotaManager = broker.quotaManagers().leader();
                string = "leader";
            } else {
                replicationQuotaManager = broker.quotaManagers().follower();
                string = "follower";
            }
            String string2 = string;
            ReplicationQuotaManager quotaManager = replicationQuotaManager;
            String quotaName = string2;
            void quotaManager2 = var4_5;
            void quotaName2 = var5_6;
            Assertions.assertTrue((boolean)quotaManager2.isThrottled(this.tp(0)), (String)new StringBuilder(33).append("Expected all ").append((String)quotaName2).append(" replicas on broker ").append(brokerId).toString());
        });
        this.waitForOffsetsToMatch(settings.msgCount(), 6, 109);
        long unthrottledTime = System.currentTimeMillis() - start;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 106));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 107));
        long throttledTime = System.currentTimeMillis() - start;
        return new ReplicationResults(this, unthrottledTime, throttledTime);
    }

    public ReplicationResults replicateWithDynamicThrottledReplicasThroughAnAsymmetricTopology(ReplicationTestSettings settings) {
        this.createBrokers((Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 105), settings.throttleBytes(), this.createBrokers$default$3(), this.createBrokers$default$4());
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{104, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{105, 107}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)6)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 106}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)7)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 107})))}));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)assignment, this.brokers());
        if (settings.throttleLeader()) {
            this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:100,1:101,2:102,3:103,4:104,5:105"));
        } else {
            this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "0:106,1:106,2:106,3:107,4:107,5:107"));
        }
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), settings.msgCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$4 -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable & scala.Serializable)partition -> ReplicationQuotasTest.$anonfun$replicateWithDynamicThrottledReplicasThroughAnAsymmetricTopology$2(this, settings, BoxesRunTime.unboxToInt((Object)partition))));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 100 + id));
        this.waitForOffsetsToMatch(settings.msgCount(), 6, 100);
        this.waitForOffsetsToMatch(settings.msgCount(), 7, 101);
        long start = System.currentTimeMillis();
        this.createBrokers((Seq<Object>)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(106), 107), settings.throttleBytes(), this.createBrokers$default$3(), this.createBrokers$default$4());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(106), 107).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> Assertions.assertEquals((long)settings.throttleBytes(), (long)this.brokerFor(brokerId).quotaManagers().follower().upperBound()));
        if (!settings.throttleLeader()) {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> Assertions.assertTrue((boolean)this.brokerFor(106).quotaManagers().follower().isThrottled(this.tp(partition))));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> Assertions.assertTrue((boolean)this.brokerFor(107).quotaManagers().follower().isThrottled(this.tp(partition))));
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(6), 7).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 100 + id));
        long unthrottledTook = System.currentTimeMillis() - start;
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 106));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> this.waitForOffsetsToMatch(settings.msgCount(), id, 107));
        long throttledTook = System.currentTimeMillis() - start;
        return new ReplicationResults(this, unthrottledTook, throttledTook);
    }

    @Test
    public void shouldThrottleOldSegments() {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(100, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        config.put("log.segment.bytes", Integer.toString(0x100000));
        this.brokers_$eq((Seq<KafkaServer>)new .colon.colon((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2()), (List)Nil$.MODULE$));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        byte[] msg = this.msg100KB();
        int msgCount = 200;
        int expectedDuration = 4;
        long throttle = msg.length * msgCount / expectedDuration;
        this.adminZkClient().changeBrokerConfig((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})), CoreUtils$.MODULE$.propsWith(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), Long.toString(throttle)));
        this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:100"));
        this.addData(msgCount, msg);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting new broker");
        this.brokers_$eq((Seq<KafkaServer>)((Seq)this.brokers().$colon$plus((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(101, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
        long start = System.currentTimeMillis();
        this.waitForOffsetsToMatch(msgCount, 0, 101);
        long throttledTook = System.currentTimeMillis() - start;
        Assertions.assertTrue(((double)throttledTook > (double)(expectedDuration * 1000) * 0.9 ? 1 : 0) != 0, (String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be > ").append((double)(expectedDuration * 1000) * 0.9).append("ms").toString());
        Assertions.assertTrue(((double)throttledTook < (double)(expectedDuration * 1000) * 1.5 ? 1 : 0) != 0, (String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be < ").append(expectedDuration * 1500).append("ms").toString());
    }

    @Test
    public void testFollowerIsThrottledOnStartup() {
        this.verifyFollowerIsThrottledOnStartup(false);
    }

    @Test
    public void testFollowerIsThrottledOnStartupWithClusterLinking() {
        this.verifyFollowerIsThrottledOnStartup(true);
    }

    public void verifyFollowerIsThrottledOnStartup(boolean clusterLinkEnable) {
        byte[] msg = this.msg100KB();
        int msgCount = 20;
        int expectedDuration = 4;
        int multiplier = clusterLinkEnable ? 4 : 2;
        long throttle = msg.length * msgCount / (multiplier * expectedDuration);
        this.brokers_$eq((Seq<KafkaServer>)new .colon.colon((Object)this.createBrokerWithDiskUsageBasedThrottlingMaybe(100, (Option<Object>)None$.MODULE$, clusterLinkEnable), (List)Nil$.MODULE$));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        this.addData(msgCount, msg);
        this.brokers_$eq((Seq<KafkaServer>)((Seq)this.brokers().$colon$plus((Object)this.createBrokerWithDiskUsageBasedThrottlingMaybe(101, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)throttle)), clusterLinkEnable), Seq$.MODULE$.canBuildFrom())));
        long start = System.currentTimeMillis();
        this.waitForOffsetsToMatch(msgCount, 0, 101);
        long throttledTook = System.currentTimeMillis() - start;
        Assertions.assertTrue(((double)throttledTook > (double)(expectedDuration * 1000) * 0.9 ? 1 : 0) != 0, (String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be > ").append((double)(expectedDuration * 1000) * 0.9).append("ms").toString());
        Assertions.assertTrue(((double)throttledTook < (double)(expectedDuration * 1000) * 1.5 ? 1 : 0) != 0, (String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be < ").append(expectedDuration * 1500).append("ms").toString());
    }

    @Test
    public void testFollowerConfigIsUnchangedOnActiveDiskThrottling() {
        this.verifyFollowerConfigIsUnchangedOnActiveDiskThrottling(false);
    }

    @Test
    public void testFollowerConfigIsUnchangedOnActiveDiskThrottlingWithClusterLinking() {
        this.verifyFollowerConfigIsUnchangedOnActiveDiskThrottling(true);
    }

    /*
     * WARNING - void declaration
     */
    public void verifyFollowerConfigIsUnchangedOnActiveDiskThrottling(boolean clusterLinkEnable) {
        long throttle = 131072L;
        KafkaServer throttledBroker = this.createBrokerWithDiskUsageBasedThrottlingMaybe(100, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)throttle)), clusterLinkEnable);
        this.brokers_$eq((Seq<KafkaServer>)new .colon.colon((Object)throttledBroker, (List)Nil$.MODULE$));
        AtomicReference<None$> lastUpdatedThrottleOptRef = new AtomicReference<None$>(None$.MODULE$);
        AtomicReference<None$> lastUpdatedClusterLinkThrottleOptRef = new AtomicReference<None$>(None$.MODULE$);
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> throttledBroker.dynamicConfigManager().shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
        throttledBroker.dynamicConfigHandlers_$eq(throttledBroker.dynamicConfigHandlers().$plus$plus((GenTraversableOnce)new .colon.colon((Object)new Tuple2((Object)ConfigType$.MODULE$.Broker(), (Object)new BrokerConfigHandler(null, throttledBroker, lastUpdatedThrottleOptRef, lastUpdatedClusterLinkThrottleOptRef){
            private final AtomicReference lastUpdatedThrottleOptRef$1;
            private final AtomicReference lastUpdatedClusterLinkThrottleOptRef$1;

            public void processConfigChanges(String brokerId, Properties properties) {
                super.processConfigChanges(brokerId, properties);
                this.lastUpdatedThrottleOptRef$1.set(this.quotaManagers().follower().lastSignalledQuotaOptRef().get());
                this.lastUpdatedClusterLinkThrottleOptRef$1.set(this.quotaManagers().clusterLink().lastSignalledQuotaOptRef().get());
            }
            {
                this.lastUpdatedThrottleOptRef$1 = lastUpdatedThrottleOptRef$1;
                this.lastUpdatedClusterLinkThrottleOptRef$1 = lastUpdatedClusterLinkThrottleOptRef$1;
                super(throttledBroker$1.config(), throttledBroker$1.quotaManagers());
            }
        }), (List)Nil$.MODULE$).toMap(Predef$.MODULE$.$conforms())));
        throttledBroker.dynamicConfigManager_$eq(new DynamicConfigManager(throttledBroker.zkClient(), throttledBroker.dynamicConfigHandlers(), DynamicConfigManager$.MODULE$.$lessinit$greater$default$3(), DynamicConfigManager$.MODULE$.$lessinit$greater$default$4()));
        throttledBroker.dynamicConfigManager().startup();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$2(throttledBroker, throttle)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        lastUpdatedThrottleOptRef.set(None$.MODULE$);
        lastUpdatedClusterLinkThrottleOptRef.set(None$.MODULE$);
        this.adminZkClient().changeBrokerConfig((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})), CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)Long.toString(throttle + 1L)), new Tuple2((Object)KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), (Object)"*"), new Tuple2((Object)KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)"1000"), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), (Object)"1001"), new Tuple2((Object)KafkaConfig$.MODULE$.ClusterLinkIoMaxBytesPerSecondProp(), (Object)"1002")})));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$4(lastUpdatedThrottleOptRef)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((long)throttle, (long)BoxesRunTime.unboxToLong((Object)((Option)lastUpdatedThrottleOptRef.get()).get()));
        if (clusterLinkEnable) {
            long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$6(lastUpdatedClusterLinkThrottleOptRef)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$7());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Assertions.assertEquals((long)throttle, (long)BoxesRunTime.unboxToLong((Object)((Option)lastUpdatedClusterLinkThrottleOptRef.get()).get()));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$8(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$10(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicationQuotasTest.$anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$11());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public KafkaServer createBrokerWithDiskUsageBasedThrottlingMaybe(int brokerId, Option<Object> throttleOpt, boolean clusterLinkEnable) {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(brokerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        config.put("log.segment.bytes", Integer.toString(0x100000));
        config.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), Boolean.toString(clusterLinkEnable));
        throttleOpt.foreach((Function1 & Serializable & scala.Serializable)throttle -> ReplicationQuotasTest.$anonfun$createBrokerWithDiskUsageBasedThrottlingMaybe$1(config, BoxesRunTime.unboxToLong((Object)throttle)));
        return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
    }

    public void addData(int msgCount, byte[] msg) {
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 0, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16()));
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), msgCount).map((Function1 & Serializable & scala.Serializable)x$5 -> ReplicationQuotasTest.$anonfun$addData$1(this, msg, BoxesRunTime.unboxToInt((Object)x$5)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$6 -> (RecordMetadata)x$6.get());
        this.waitForOffsetsToMatch(msgCount, 0, 100);
    }

    /*
     * WARNING - void declaration
     */
    private void waitForOffsetsToMatch(int offset, int partitionId, int brokerId) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReplicationQuotasTest.$anonfun$waitForOffsetsToMatch$1(this, offset, brokerId, partitionId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicationQuotasTest.$anonfun$waitForOffsetsToMatch$4(partitionId, brokerId));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private KafkaServer brokerFor(int id) {
        return (KafkaServer)((IterableLike)this.brokers().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ReplicationQuotasTest.$anonfun$brokerFor$1(id, x$8)))).head();
    }

    public TopicPartition tp(int partition) {
        return new TopicPartition(this.topic(), partition);
    }

    public void createBrokers(Seq<Object> brokerIds, long throttle, boolean throttleAllBrokerLeaderReplicas, boolean throttleAllBrokerFollowerReplicas) {
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)id -> {
            Properties props = TestUtils$.MODULE$.createBrokerConfig(id, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
            props.setProperty(KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), Long.toString(throttle));
            props.setProperty(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), Long.toString(throttle));
            props.setProperty(KafkaConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), this.throttledReplicasConfig(throttleAllBrokerLeaderReplicas));
            props.setProperty(KafkaConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), this.throttledReplicasConfig(throttleAllBrokerFollowerReplicas));
            this.brokers_$eq((Seq<KafkaServer>)((Seq)this.brokers().$colon$plus((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
            Assertions.assertEquals((long)throttle, (long)this.brokerFor(id).quotaManagers().leader().upperBound());
            Assertions.assertEquals((long)throttle, (long)this.brokerFor(id).quotaManagers().follower().upperBound());
        });
    }

    public boolean createBrokers$default$3() {
        return false;
    }

    public boolean createBrokers$default$4() {
        return false;
    }

    public String throttledReplicasConfig(boolean shouldThrottleAllReplicas) {
        if (shouldThrottleAllReplicas) {
            return ReplicationQuotaManagerConfig$.MODULE$.AllThrottledReplicasValue();
        }
        return ReplicationQuotaManagerConfig$.MODULE$.NoThrottledReplicasValue();
    }

    private double avRate(QuotaType replicationType, Seq<Object> brokers) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)brokers.map((Function1 & Serializable & scala.Serializable)id -> this.brokerFor(BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToDouble((double)this.measuredRate(x$9, replicationType)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)brokers.length();
    }

    private double measuredRate(KafkaServer broker, QuotaType repType) {
        MetricName metricName = broker.metrics().metricName("byte-rate", repType.toString());
        return BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(broker.metrics().metrics()).asScala()).apply((Object)metricName)).metricValue());
    }

    /*
     * WARNING - void declaration
     */
    public void setAndUnsetDynamicThrottles(Seq<Object> brokers, long staticThrottleBytes, long dynamicThrottleBytes) {
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> this.adminZkClient().changeBrokerConfig((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerId})), CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)Long.toString(dynamicThrottleBytes)), new Tuple2((Object)KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)Long.toString(dynamicThrottleBytes))}))));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!brokers.forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)brokerId -> dynamicThrottleBytes$1 == $this.brokerFor(brokerId).quotaManagers().leader().upperBound() && dynamicThrottleBytes$1 == $this.brokerFor(brokerId).quotaManagers().follower().upperBound())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicationQuotasTest.$anonfun$setAndUnsetDynamicThrottles$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)brokerId -> this.adminZkClient().changeBrokerConfig((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerId})), CoreUtils$.MODULE$.propsWith((Seq)Nil$.MODULE$)));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!brokers.forall((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)brokerId -> staticThrottleBytes$1 == $this.brokerFor(brokerId).quotaManagers().leader().upperBound() && staticThrottleBytes$1 == $this.brokerFor(brokerId).quotaManagers().follower().upperBound())) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicationQuotasTest.$anonfun$setAndUnsetDynamicThrottles$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private final void ReplicationResults$lzycompute$1() {
        synchronized (this) {
            if (this.ReplicationResults$module == null) {
                this.ReplicationResults$module = new ReplicationQuotasTest$ReplicationResults$(this);
            }
            return;
        }
    }

    private final void ReplicationTestSettings$lzycompute$1() {
        synchronized (this) {
            if (this.ReplicationTestSettings$module == null) {
                this.ReplicationTestSettings$module = new ReplicationQuotasTest$ReplicationTestSettings$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ Future $anonfun$replicateWithStaticThrottledReplicas$2(ReplicationQuotasTest $this, ReplicationTestSettings settings$1, int partition) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)settings$1.msg()));
    }

    public static final /* synthetic */ Future $anonfun$replicateWithDynamicThrottledReplicasThroughAnAsymmetricTopology$2(ReplicationQuotasTest $this, ReplicationTestSettings settings$2, int partition) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(partition), null, (Object)settings$2.msg()));
    }

    public static final /* synthetic */ boolean $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$2(KafkaServer throttledBroker$1, long throttle$1) {
        return BoxesRunTime.unboxToLong((Object)((Option)throttledBroker$1.quotaManagers().follower().lastSignalledQuotaOptRef().get()).get()) == throttle$1;
    }

    public static final /* synthetic */ String $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$3() {
        return "Follower throttle couldn't be applied within timeout";
    }

    public static final /* synthetic */ boolean $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$4(AtomicReference lastUpdatedThrottleOptRef$1) {
        return ((Option)lastUpdatedThrottleOptRef$1.get()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$5() {
        return new StringBuilder(41).append("updateReplicationConfig() incomplete for ").append(KafkaConfig$.MODULE$.FollowerReplicationThrottledRateProp()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$6(AtomicReference lastUpdatedClusterLinkThrottleOptRef$1) {
        return ((Option)lastUpdatedClusterLinkThrottleOptRef$1.get()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$7() {
        return "Cluster link throttle not updated";
    }

    public static final /* synthetic */ boolean $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$8(ReplicationQuotasTest $this) {
        return ((KafkaServer)$this.brokers().head()).quotaManagers().leader().upperBound() == 1000L;
    }

    public static final /* synthetic */ String $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$9() {
        return "Leader replication not updated";
    }

    public static final /* synthetic */ boolean $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$10(ReplicationQuotasTest $this) {
        return ((KafkaServer)$this.brokers().head()).quotaManagers().alterLogDirs().upperBound() == 1001L;
    }

    public static final /* synthetic */ String $anonfun$verifyFollowerConfigIsUnchangedOnActiveDiskThrottling$11() {
        return "alterLogDirs not updated";
    }

    public static final /* synthetic */ Object $anonfun$createBrokerWithDiskUsageBasedThrottlingMaybe$1(Properties config$1, long throttle) {
        config$1.setProperty(KafkaConfig$.MODULE$.ReplicaFetchMaxBytesProp(), "16384");
        config$1.setProperty("confluent.backpressure.disk.enable", Boolean.toString(true));
        config$1.setProperty("confluent.backpressure.disk.produce.bytes.per.second", Long.toString(throttle));
        return config$1.setProperty("confluent.backpressure.disk.free.threshold.bytes", Long.toString(Long.MAX_VALUE));
    }

    public static final /* synthetic */ Future $anonfun$addData$1(ReplicationQuotasTest $this, byte[] msg$1, int x$5) {
        return $this.producer().send(new ProducerRecord($this.topic(), (Object)msg$1));
    }

    public static final /* synthetic */ boolean $anonfun$waitForOffsetsToMatch$1(ReplicationQuotasTest $this, int offset$1, int brokerId$1, int partitionId$1) {
        LogManager qual$1 = $this.brokerFor(brokerId$1).getLogManager();
        TopicPartition x$1 = new TopicPartition($this.topic(), partitionId$1);
        boolean x$2 = qual$1.getLog$default$2();
        return BoxesRunTime.equals((Object)BoxesRunTime.boxToInteger((int)offset$1), (Object)qual$1.getLog(x$1, x$2).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.logEndOffset())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public static final /* synthetic */ String $anonfun$waitForOffsetsToMatch$4(int partitionId$1, int brokerId$1) {
        return new StringBuilder(47).append("Offsets did not match for partition ").append(partitionId$1).append(" on broker ").append(brokerId$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$brokerFor$1(int id$1, KafkaServer x$8) {
        return x$8.config().brokerId() == id$1;
    }

    public static final /* synthetic */ String $anonfun$setAndUnsetDynamicThrottles$4() {
        return "Dynamically set throttles weren't as expected";
    }

    public static final /* synthetic */ String $anonfun$setAndUnsetDynamicThrottles$8() {
        return "Throttles weren't reverted to the statically set ones as expected";
    }

    public ReplicationQuotasTest() {
        this.topic = "topic1";
    }

    public class ReplicationResults
    implements Product,
    scala.Serializable {
        private final long unthrottledTime;
        private final long throttledTime;
        public final /* synthetic */ ReplicationQuotasTest $outer;

        public long unthrottledTime() {
            return this.unthrottledTime;
        }

        public long throttledTime() {
            return this.throttledTime;
        }

        public ReplicationResults copy(long unthrottledTime, long throttledTime) {
            return new ReplicationResults(this.kafka$server$ReplicationQuotasTest$ReplicationResults$$$outer(), unthrottledTime, throttledTime);
        }

        public long copy$default$1() {
            return this.unthrottledTime();
        }

        public long copy$default$2() {
            return this.throttledTime();
        }

        public String productPrefix() {
            return "ReplicationResults";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.unthrottledTime());
                }
                case 1: {
                    return BoxesRunTime.boxToLong((long)this.throttledTime());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ReplicationResults;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.longHash((long)this.unthrottledTime())), (int)Statics.longHash((long)this.throttledTime())), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    boolean bl = x$1 instanceof ReplicationResults && ((ReplicationResults)x$1).kafka$server$ReplicationQuotasTest$ReplicationResults$$$outer() == this.kafka$server$ReplicationQuotasTest$ReplicationResults$$$outer();
                    if (!bl) break block3;
                    ReplicationResults replicationResults = (ReplicationResults)x$1;
                    if (!(this.unthrottledTime() == replicationResults.unthrottledTime() && this.throttledTime() == replicationResults.throttledTime() && replicationResults.canEqual(this))) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ ReplicationQuotasTest kafka$server$ReplicationQuotasTest$ReplicationResults$$$outer() {
            return this.$outer;
        }

        public ReplicationResults(ReplicationQuotasTest $outer, long unthrottledTime, long throttledTime) {
            this.unthrottledTime = unthrottledTime;
            this.throttledTime = throttledTime;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class ReplicationTestSettings
    implements Product,
    scala.Serializable {
        private final long throttleBytes;
        private final int msgCount;
        private final byte[] msg;
        private final boolean throttleLeader;
        public final /* synthetic */ ReplicationQuotasTest $outer;

        public long throttleBytes() {
            return this.throttleBytes;
        }

        public int msgCount() {
            return this.msgCount;
        }

        public byte[] msg() {
            return this.msg;
        }

        public boolean throttleLeader() {
            return this.throttleLeader;
        }

        public ReplicationTestSettings copy(long throttleBytes, int msgCount, byte[] msg, boolean throttleLeader) {
            return new ReplicationTestSettings(this.kafka$server$ReplicationQuotasTest$ReplicationTestSettings$$$outer(), throttleBytes, msgCount, msg, throttleLeader);
        }

        public long copy$default$1() {
            return this.throttleBytes();
        }

        public int copy$default$2() {
            return this.msgCount();
        }

        public byte[] copy$default$3() {
            return this.msg();
        }

        public boolean copy$default$4() {
            return this.throttleLeader();
        }

        public String productPrefix() {
            return "ReplicationTestSettings";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return BoxesRunTime.boxToLong((long)this.throttleBytes());
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.msgCount());
                }
                case 2: {
                    return this.msg();
                }
                case 3: {
                    return BoxesRunTime.boxToBoolean((boolean)this.throttleLeader());
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ReplicationTestSettings;
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)Statics.longHash((long)this.throttleBytes())), (int)this.msgCount()), (int)Statics.anyHash((Object)this.msg())), (int)(this.throttleLeader() ? 1231 : 1237)), (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    boolean bl = x$1 instanceof ReplicationTestSettings && ((ReplicationTestSettings)x$1).kafka$server$ReplicationQuotasTest$ReplicationTestSettings$$$outer() == this.kafka$server$ReplicationQuotasTest$ReplicationTestSettings$$$outer();
                    if (!bl) break block3;
                    ReplicationTestSettings replicationTestSettings = (ReplicationTestSettings)x$1;
                    if (!(this.throttleBytes() == replicationTestSettings.throttleBytes() && this.msgCount() == replicationTestSettings.msgCount() && this.msg() == replicationTestSettings.msg() && this.throttleLeader() == replicationTestSettings.throttleLeader() && replicationTestSettings.canEqual(this))) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ ReplicationQuotasTest kafka$server$ReplicationQuotasTest$ReplicationTestSettings$$$outer() {
            return this.$outer;
        }

        public ReplicationTestSettings(ReplicationQuotasTest $outer, long throttleBytes, int msgCount, byte[] msg, boolean throttleLeader) {
            this.throttleBytes = throttleBytes;
            this.msgCount = msgCount;
            this.msg = msg;
            this.throttleLeader = throttleLeader;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

