/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.TimestampType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001\u0002\n\u0014\u0001aAQa\b\u0001\u0005\u0002\u0001Bqa\t\u0001C\u0002\u0013%A\u0005\u0003\u0004,\u0001\u0001\u0006I!\n\u0005\bY\u0001\u0011\r\u0011\"\u0003.\u0011\u00191\u0004\u0001)A\u0005]!9q\u0007\u0001b\u0001\n\u0013A\u0004B\u0002#\u0001A\u0003%\u0011\bC\u0003F\u0001\u0011EC\u0005C\u0003G\u0001\u0011\u0005s\tC\u0003G\u0001\u0011\u0005Q\u000bC\u0003]\u0001\u0011\u0005q\tC\u0003b\u0001\u0011\u0005q\tC\u0003d\u0001\u0011\u0005q\tC\u0003f\u0001\u0011\u0005q\tC\u0003h\u0001\u0011%\u0001\u000eC\u0003q\u0001\u0011%\u0011\u000fC\u0003z\u0001\u0011%!PA\u000fTiJ\f\u0017\u0010U1si&$\u0018n\u001c8J]R,wM]1uS>tG+Z:u\u0015\t!R#\u0001\u0004tKJ4XM\u001d\u0006\u0002-\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001a!\tQR$D\u0001\u001c\u0015\taR#A\u0002ba&L!AH\u000e\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A\u0011\u0011\u0005\t\u0002Q\"A\n\u0002\u00159,XN\u0011:pW\u0016\u00148/F\u0001&!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\rIe\u000e^\u0001\f]Vl'I]8lKJ\u001c\b%A\u0003u_BL7-F\u0001/!\tyC'D\u00011\u0015\t\t$'\u0001\u0003mC:<'\"A\u001a\u0002\t)\fg/Y\u0005\u0003kA\u0012aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0003e\u0002\"A\u000f\"\u000e\u0003mR!\u0001P\u001f\u0002\r\r|W.\\8o\u0015\t1bH\u0003\u0002@\u0001\u00061\u0011\r]1dQ\u0016T\u0011!Q\u0001\u0004_J<\u0017BA\"<\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\fEJ|7.\u001a:D_VtG/A\u0003tKR,\u0006\u000fF\u0001I!\t1\u0013*\u0003\u0002KO\t!QK\\5uQ\tIA\n\u0005\u0002N'6\taJ\u0003\u0002\u001d\u001f*\u0011\u0001+U\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0011\u0006)A\u0003kk:LG/\u0003\u0002U\u001d\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0015\u0005!3\u0006\"B,\u000b\u0001\u0004A\u0016\u0001\u0003;fgRLeNZ8\u0011\u00055K\u0016B\u0001.O\u0005!!Vm\u001d;J]\u001a|\u0007F\u0001\u0006M\u0003%\"Xm\u001d;TiJ\f\u0017\u0010U1si&$\u0018n\u001c8EK2,G/[8o\u001f:\u0014%o\\6feN#\u0018M\u001d;va\"\u00121B\u0018\t\u0003\u001b~K!\u0001\u0019(\u0003\tQ+7\u000f^\u0001/i\u0016\u001cHo\u0015;sCf\u0004\u0016M\u001d;ji&|g\u000eR3mKRLwN\\(o\u0007>tGO]8mY\u0016\u0014h)Y5m_Z,'\u000f\u000b\u0002\r=\u00069C/Z:u!\u0006\u0014H/\u001b;j_:tu\u000e^*ue\u0006LH)\u001e:j]\u001e\u0014V-Y:tS\u001etW.\u001a8uQ\tia,\u0001 uKN$8\u000b\u001e:bsB\u000b'\u000f^5uS>tG)\u001a;fGRLwN\\(o\u0005J|7.\u001a:Ti\u0006\u0014H/\u001e9XSRDG)\u001a7fi&|g\u000eR5tC\ndW\r\u001a\u0015\u0003\u001dy\u000bQb\u0019:fCR,7+Z4nK:$HC\u0001%j\u0011\u0015Qw\u00021\u0001l\u0003\rawn\u001a\t\u0003Y:l\u0011!\u001c\u0006\u0003UVI!a\\7\u0003\u0017\u0005\u00137\u000f\u001e:bGRdunZ\u0001\u001cm\u0016\u0014\u0018NZ=TiJ\f\u0017\u0010U1si&$\u0018n\u001c8NKR\u0014\u0018nY:\u0015\u0007!\u0013H\u000fC\u0003t!\u0001\u0007Q%A\ntiJ\f\u0017\u0010U1si&$\u0018n\u001c8D_VtG\u000fC\u0003v!\u0001\u0007a/A\ftiJ\f\u0017\u0010U1si&$\u0018n\u001c8U_R\fGnU5{KB\u0011ae^\u0005\u0003q\u001e\u0012A\u0001T8oO\u00061An\\4PaR$Ba\u001f@\u0002\u0002A\u0019a\u0005`6\n\u0005u<#AB(qi&|g\u000eC\u0003\u0000#\u0001\u0007Q%\u0001\u0004ce>\\WM\u001d\u0005\u0006oE\u0001\r!\u000f")
public class StrayPartitionIntegrationTest
extends IntegrationTestHarness {
    private final int numBrokers;
    private final String topic;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), 0);

    private int numBrokers() {
        return this.numBrokers;
    }

    private String topic() {
        return this.topic;
    }

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @Override
    public int brokerCount() {
        return this.numBrokers();
    }

    @Override
    @BeforeEach
    public void setUp() {
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        String string = ((Method)testInfo.getTestMethod().get()).getName();
        String string2 = "testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled";
        if (string != null && string.equals(string2)) {
            this.serverConfig().setProperty("confluent.enable.stray.partition.deletion", "false");
        } else {
            this.serverConfig().setProperty("confluent.enable.stray.partition.deletion", "true");
        }
        super.setUp();
    }

    @Test
    public void testStrayPartitionDeletionOnBrokerStartup() {
        String validTopic_1 = "valid-1";
        String validTopic_2 = "valid-2";
        this.createTopic(validTopic_1, 3, 3, this.createTopic$default$4());
        this.createTopic(validTopic_2, 5, 3, this.createTopic$default$4());
        String strayTopic_1 = "stray-1";
        String strayTopic_2 = "stray-2";
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            LogManager logManager = server.logManager();
            TopicPartition x$1 = new TopicPartition(strayTopic_1, Random$.MODULE$.nextInt(10));
            None$ x$2 = None$.MODULE$;
            boolean x$3 = logManager.getOrCreateLog$default$2();
            boolean x$4 = logManager.getOrCreateLog$default$3();
            logManager.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            TopicPartition x$5 = new TopicPartition(strayTopic_2, Random$.MODULE$.nextInt(10));
            None$ x$6 = None$.MODULE$;
            boolean x$7 = logManager.getOrCreateLog$default$2();
            boolean x$8 = logManager.getOrCreateLog$default$3();
            return logManager.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerStartup$2(this, strayTopic_1, strayTopic_2, validTopic_1, validTopic_2, server);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStrayPartitionDeletionOnControllerFailover() {
        String validTopic_1 = "valid-1";
        String validTopic_2 = "valid-2";
        this.createTopic(validTopic_1, 3, 3, this.createTopic$default$4());
        this.createTopic(validTopic_2, 5, 3, this.createTopic$default$4());
        String strayTopic_1 = "stray-1";
        String strayTopic_2 = "stray-2";
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            LogManager logManager = server.logManager();
            TopicPartition x$1 = new TopicPartition(strayTopic_1, Random$.MODULE$.nextInt(10));
            None$ x$2 = None$.MODULE$;
            boolean x$3 = logManager.getOrCreateLog$default$2();
            boolean x$4 = logManager.getOrCreateLog$default$3();
            logManager.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
            TopicPartition x$5 = new TopicPartition(strayTopic_2, Random$.MODULE$.nextInt(10));
            None$ x$6 = None$.MODULE$;
            boolean x$7 = logManager.getOrCreateLog$default$2();
            boolean x$8 = logManager.getOrCreateLog$default$3();
            return logManager.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
        });
        this.zkClient().deleteController(((Tuple2)this.zkClient().getControllerEpoch().get())._1$mcI$sp());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnControllerFailover$2(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnControllerFailover$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int controllerId = BoxesRunTime.unboxToInt((Object)this.zkClient().getControllerId().get());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnControllerFailover$4(this, controllerId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnControllerFailover$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnControllerFailover$6(this, strayTopic_1, strayTopic_2, validTopic_1, validTopic_2, server);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testPartitionNotStrayDuringReassignment() {
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.SegmentBytesProp(), Integer.toString(100));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), (Seq<KafkaServer>)this.servers(), topicConfig);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"message".getBytes());
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)_ -> StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$1(producer, record, BoxesRunTime.unboxToInt((Object)_)));
        ConfluentAdmin adminClient = this.createAdminClient(this.createAdminClient$default$1());
        int newLeader = 2;
        Seq newReplicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1}));
        NewPartitionReassignment newAssignment = new NewPartitionReassignment((List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newReplicas.map((Function1 & Serializable & scala.Serializable)x -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)x)), Seq$.MODULE$.canBuildFrom())).asJava());
        adminClient.alterPartitionReassignments(Collections.singletonMap(this.topicPartition(), Optional.of(newAssignment))).all().get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$3(this, newLeader)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$5(this, newLeader)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((LogSegment)((AbstractLog)this.logOpt(newLeader, this.topicPartition()).get()).localLogSegments().head()).lastModified_$eq(System.currentTimeMillis() + 100000L);
        Iterable lastModified = (Iterable)((TraversableLike)((AbstractLog)this.logOpt(newLeader, this.topicPartition()).get()).localLogSegments().dropRight(1)).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.lastModified()), Iterable$.MODULE$.canBuildFrom());
        this.killBroker(newLeader);
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1 & Serializable & scala.Serializable)_ -> StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$8(producer, record, BoxesRunTime.unboxToInt((Object)_)));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$9(this, server);
            return BoxedUnit.UNIT;
        });
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$10(this, adminClient)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$11());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$12(this, newLeader)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)StrayPartitionIntegrationTest.$anonfun$testPartitionNotStrayDuringReassignment$14(this, newLeader));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((Object)lastModified, (Object)((TraversableLike)((AbstractLog)this.logOpt(newLeader, this.topicPartition()).get()).localLogSegments().take(lastModified.size())).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.lastModified()), Iterable$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled() {
        String validTopic_1 = "valid-1";
        String validTopic_2 = "valid-2";
        this.createTopic(validTopic_1, 3, 3, this.createTopic$default$4());
        this.createTopic(validTopic_2, 5, 3, this.createTopic$default$4());
        String strayTopic_1 = "stray-1";
        String strayTopic_2 = "stray-2";
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$1(this, strayTopic_1, strayTopic_2, server);
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$2(this, strayTopic_1, strayTopic_2, validTopic_1, validTopic_2, server);
            return BoxedUnit.UNIT;
        });
    }

    private void createSegment(AbstractLog log) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(System.currentTimeMillis(), (byte[])Array$.MODULE$.fill(3, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 32, ClassTag$.MODULE$.Byte()), (byte[])Array$.MODULE$.fill(10, (Function0)(JFunction0.mcB.sp & Serializable & scala.Serializable)() -> 31, ClassTag$.MODULE$.Byte()));
        log.appendAsLeader(builder.build(), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
    }

    private void verifyStrayPartitionMetrics(int strayPartitionCount, long strayPartitionTotalSize) {
        Assertions.assertEquals((int)strayPartitionCount, (int)BoxesRunTime.unboxToInt((Object)((Gauge)StrayPartitionIntegrationTest.replicaMetric$1("StrayPartitionsCount")).value()));
        Assertions.assertEquals((long)strayPartitionTotalSize, (long)BoxesRunTime.unboxToLong((Object)((Gauge)StrayPartitionIntegrationTest.replicaMetric$1("StrayPartitionsTotalSize")).value()));
    }

    private Option<AbstractLog> logOpt(int broker, TopicPartition topicPartition) {
        LogManager qual$1 = ((KafkaServer)this.servers().apply(broker)).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return qual$1.getLog(topicPartition, x$2);
    }

    private static final Iterable allLogs$1(KafkaServer server$1) {
        return (Iterable)server$1.logManager().allLogs().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.topicPartition(), Iterable$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnBrokerStartup$5(String strayTopic_1$1, TopicPartition x$2) {
        String string = x$2.topic();
        return !(string != null ? !string.equals(strayTopic_1$1) : strayTopic_1$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnBrokerStartup$4(String strayTopic_1$1, KafkaServer server$1) {
        return ((TraversableOnce)StrayPartitionIntegrationTest.allLogs$1(server$1).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerStartup$5(strayTopic_1$1, x$2)))).size() == 0;
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDeletionOnBrokerStartup$6() {
        return "Timed out waiting for stray topic deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnBrokerStartup$8(String strayTopic_2$1, TopicPartition x$3) {
        String string = x$3.topic();
        return !(string != null ? !string.equals(strayTopic_2$1) : strayTopic_2$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnBrokerStartup$7(String strayTopic_2$1, KafkaServer server$1) {
        return ((TraversableOnce)StrayPartitionIntegrationTest.allLogs$1(server$1).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerStartup$8(strayTopic_2$1, x$3)))).size() == 0;
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDeletionOnBrokerStartup$9() {
        return "Timed out waiting for stray topic deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnBrokerStartup$10(String validTopic_1$1, TopicPartition x$4) {
        String string = x$4.topic();
        return !(string != null ? !string.equals(validTopic_1$1) : validTopic_1$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnBrokerStartup$11(String validTopic_2$1, TopicPartition x$5) {
        String string = x$5.topic();
        return !(string != null ? !string.equals(validTopic_2$1) : validTopic_2$1 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testStrayPartitionDeletionOnBrokerStartup$2(StrayPartitionIntegrationTest $this, String strayTopic_1$1, String strayTopic_2$1, String validTopic_1$1, String validTopic_2$1, KafkaServer server) {
        $this.killBroker(server.config().brokerId());
        $this.restartDeadBrokers($this.restartDeadBrokers$default$1());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerStartup$4(strayTopic_1$1, server)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerStartup$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerStartup$7(strayTopic_2$1, server)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerStartup$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)0, (int)server.replicaManager().strayPartitionsCount());
        Assertions.assertEquals((long)0L, (long)server.replicaManager().strayPartitionsTotalSize());
        $this.verifyStrayPartitionMetrics(0, 0L);
        Assertions.assertEquals((int)3, (int)((TraversableOnce)StrayPartitionIntegrationTest.allLogs$1(server).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerStartup$10(validTopic_1$1, x$4)))).size());
        Assertions.assertEquals((int)5, (int)((TraversableOnce)StrayPartitionIntegrationTest.allLogs$1(server).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnBrokerStartup$11(validTopic_2$1, x$5)))).size());
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnControllerFailover$2(StrayPartitionIntegrationTest $this) {
        return $this.zkClient().getControllerId().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDeletionOnControllerFailover$3() {
        return "Timed out waiting for controller election";
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnControllerFailover$4(StrayPartitionIntegrationTest $this, int controllerId$1) {
        return ((KafkaServer)$this.servers().apply(controllerId$1)).kafkaController().isActive();
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDeletionOnControllerFailover$5() {
        return "Timed out waiting for controller initialization";
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnControllerFailover$9(String strayTopic_1$2, TopicPartition x$7) {
        String string = x$7.topic();
        return !(string != null ? !string.equals(strayTopic_1$2) : strayTopic_1$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnControllerFailover$8(Iterable allLogs$2, String strayTopic_1$2) {
        return ((TraversableOnce)allLogs$2.filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnControllerFailover$9(strayTopic_1$2, x$7)))).size() == 0;
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDeletionOnControllerFailover$10() {
        return "Timed out waiting for stray topic deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnControllerFailover$12(String strayTopic_2$2, TopicPartition x$8) {
        String string = x$8.topic();
        return !(string != null ? !string.equals(strayTopic_2$2) : strayTopic_2$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnControllerFailover$11(Iterable allLogs$2, String strayTopic_2$2) {
        return ((TraversableOnce)allLogs$2.filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnControllerFailover$12(strayTopic_2$2, x$8)))).size() == 0;
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDeletionOnControllerFailover$13() {
        return "Timed out waiting for stray topic deletion";
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnControllerFailover$14(String validTopic_1$2, TopicPartition x$9) {
        String string = x$9.topic();
        return !(string != null ? !string.equals(validTopic_1$2) : validTopic_1$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDeletionOnControllerFailover$15(String validTopic_2$2, TopicPartition x$10) {
        String string = x$10.topic();
        return !(string != null ? !string.equals(validTopic_2$2) : validTopic_2$2 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testStrayPartitionDeletionOnControllerFailover$6(StrayPartitionIntegrationTest $this, String strayTopic_1$2, String strayTopic_2$2, String validTopic_1$2, String validTopic_2$2, KafkaServer server) {
        Iterable allLogs = (Iterable)server.logManager().allLogs().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.topicPartition(), Iterable$.MODULE$.canBuildFrom());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnControllerFailover$8(allLogs, strayTopic_1$2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnControllerFailover$10());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnControllerFailover$11(allLogs, strayTopic_2$2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnControllerFailover$13());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)0, (int)server.replicaManager().strayPartitionsCount());
        Assertions.assertEquals((long)0L, (long)server.replicaManager().strayPartitionsTotalSize());
        $this.verifyStrayPartitionMetrics(0, 0L);
        Assertions.assertEquals((int)3, (int)((TraversableOnce)allLogs.filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnControllerFailover$14(validTopic_1$2, x$9)))).size());
        Assertions.assertEquals((int)5, (int)((TraversableOnce)allLogs.filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDeletionOnControllerFailover$15(validTopic_2$2, x$10)))).size());
    }

    public static final /* synthetic */ RecordMetadata $anonfun$testPartitionNotStrayDuringReassignment$1(KafkaProducer producer$1, ProducerRecord record$1, int _) {
        return (RecordMetadata)producer$1.send(record$1).get();
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionNotStrayDuringReassignment$3(StrayPartitionIntegrationTest $this, int newLeader$1) {
        return $this.logOpt(newLeader$1, $this.topicPartition()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testPartitionNotStrayDuringReassignment$4() {
        return "Timed out waiting for reassignment to initiate";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionNotStrayDuringReassignment$5(StrayPartitionIntegrationTest $this, int newLeader$1) {
        return ((AbstractLog)$this.logOpt(newLeader$1, $this.topicPartition()).get()).numberOfSegments() > 1;
    }

    public static final /* synthetic */ String $anonfun$testPartitionNotStrayDuringReassignment$6() {
        return "Timed out waiting for segments to roll";
    }

    public static final /* synthetic */ RecordMetadata $anonfun$testPartitionNotStrayDuringReassignment$8(KafkaProducer producer$1, ProducerRecord record$1, int _) {
        return (RecordMetadata)producer$1.send(record$1).get();
    }

    public static final /* synthetic */ void $anonfun$testPartitionNotStrayDuringReassignment$9(StrayPartitionIntegrationTest $this, KafkaServer server) {
        Assertions.assertEquals((int)0, (int)server.replicaManager().strayPartitionsCount());
        Assertions.assertEquals((long)0L, (long)server.replicaManager().strayPartitionsTotalSize());
        $this.verifyStrayPartitionMetrics(0, 0L);
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionNotStrayDuringReassignment$10(StrayPartitionIntegrationTest $this, ConfluentAdmin adminClient$1) {
        return ((java.util.Map)adminClient$1.listPartitionReassignments((java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{$this.topicPartition()}))).asJava()).reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testPartitionNotStrayDuringReassignment$11() {
        return "Timed out waiting for reassignment to complete";
    }

    public static final /* synthetic */ boolean $anonfun$testPartitionNotStrayDuringReassignment$12(StrayPartitionIntegrationTest $this, int newLeader$1) {
        return ((KafkaServer)$this.servers().apply(newLeader$1)).replicaManager().leaderPartitionsIterator().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.topicPartition()).contains((Object)$this.topicPartition());
    }

    public static final /* synthetic */ String $anonfun$testPartitionNotStrayDuringReassignment$14(StrayPartitionIntegrationTest $this, int newLeader$1) {
        return new StringBuilder(75).append("Timed out waiting for ").append(newLeader$1).append(" to become the new leader of ").append($this.topicPartition()).append(" after it was reassigned").toString();
    }

    public static final /* synthetic */ void $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$1(StrayPartitionIntegrationTest $this, String strayTopic_1$3, String strayTopic_2$3, KafkaServer server) {
        LogManager logManager = server.logManager();
        TopicPartition x$1 = new TopicPartition(strayTopic_1$3, server.config().brokerId() * 2);
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        AbstractLog strayLog1 = logManager.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        TopicPartition x$5 = new TopicPartition(strayTopic_2$3, server.config().brokerId() * 2 + 1);
        None$ x$6 = None$.MODULE$;
        boolean x$7 = logManager.getOrCreateLog$default$2();
        boolean x$8 = logManager.getOrCreateLog$default$3();
        AbstractLog strayLog2 = logManager.getOrCreateLog(x$5, x$7, x$8, (Option)x$6);
        $this.createSegment(strayLog1);
        $this.createSegment(strayLog2);
    }

    private static final Iterable allLogs$3(KafkaServer server$2) {
        return (Iterable)server$2.logManager().allLogs().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.topicPartition(), Iterable$.MODULE$.canBuildFrom());
    }

    private static final long logSize$1(TopicPartition topicPartition, KafkaServer server$2) {
        LogManager qual$1 = server$2.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        return BoxesRunTime.unboxToLong((Object)qual$1.getLog(topicPartition, x$2).map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)x$15.size())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$6(KafkaServer server$2) {
        return server$2.replicaManager().strayPartitionsCount() == 2;
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$7() {
        return "Timed out waiting for stray partition detection";
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$8(KafkaServer server$2, long totalLogSize$1) {
        return server$2.replicaManager().strayPartitionsTotalSize() == totalLogSize$1;
    }

    public static final /* synthetic */ String $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$9() {
        return "Timed out waiting for stray partition total size detection";
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$10(String validTopic_1$3, TopicPartition x$16) {
        String string = x$16.topic();
        return !(string != null ? !string.equals(validTopic_1$3) : validTopic_1$3 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$11(String validTopic_2$3, TopicPartition x$17) {
        String string = x$17.topic();
        return !(string != null ? !string.equals(validTopic_2$3) : validTopic_2$3 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$2(StrayPartitionIntegrationTest $this, String strayTopic_1$3, String strayTopic_2$3, String validTopic_1$3, String validTopic_2$3, KafkaServer server) {
        $this.killBroker(server.config().brokerId());
        $this.restartDeadBrokers($this.restartDeadBrokers$default$1());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$6(server)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long totalLogSize = StrayPartitionIntegrationTest.logSize$1(new TopicPartition(strayTopic_1$3, server.config().brokerId() * 2), server) + StrayPartitionIntegrationTest.logSize$1(new TopicPartition(strayTopic_2$3, server.config().brokerId() * 2 + 1), server);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$8(server, totalLogSize)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        $this.verifyStrayPartitionMetrics(2, totalLogSize);
        Assertions.assertEquals((int)3, (int)((TraversableOnce)StrayPartitionIntegrationTest.allLogs$3(server).filter((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$10(validTopic_1$3, x$16)))).size());
        Assertions.assertEquals((int)5, (int)((TraversableOnce)StrayPartitionIntegrationTest.allLogs$3(server).filter((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$testStrayPartitionDetectionOnBrokerStartupWithDeletionDisabled$11(validTopic_2$3, x$17)))).size());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$verifyStrayPartitionMetrics$1(String metricName$1, Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError(null);
        MetricName m = (MetricName)x0$1._1();
        String string = m.getName();
        if (string == null) {
            if (metricName$1 != null) {
                return false;
            }
        } else if (!string.equals(metricName$1)) return false;
        String string2 = m.getType();
        String string3 = "ReplicaManager";
        if (string2 == null) return false;
        if (!string2.equals(string3)) return false;
        return true;
    }

    private static final Metric replicaMetric$1(String metricName) {
        return (Metric)((Tuple2)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)StrayPartitionIntegrationTest.$anonfun$verifyStrayPartitionMetrics$1(metricName, x0$1)))).head())._2();
    }

    public StrayPartitionIntegrationTest() {
        this.numBrokers = 3;
        this.topic = "topic_1";
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LeaderImbalancePerBrokerPercentageProp(), "0");
        Predef$.MODULE$.locally(this.serverConfig().setProperty(KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp(), "1"));
    }
}

