/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u00194AAC\u0006\u0001!!)q\u0003\u0001C\u00011!91\u0004\u0001b\u0001\n\u0003a\u0002BB\u0013\u0001A\u0003%Q\u0004C\u0004'\u0001\t\u0007I\u0011A\u0014\t\r9\u0002\u0001\u0015!\u0003)\u0011\u0015y\u0003\u0001\"\u00111\u0011\u0015a\u0004\u0001\"\u0001>\u0011\u0015y\u0005\u0001\"\u0001Q\u0011\u0015)\u0007\u0001\"\u0003>\u0005}!\u0016.\u001a:U_BL7-T1oC\u001e,'/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u00195\taa]3sm\u0016\u0014(\"\u0001\b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u0005\t\u0003%Ui\u0011a\u0005\u0006\u0003)5\t1\"\u001b8uK\u001e\u0014\u0018\r^5p]&\u0011ac\u0005\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011aC\u0001\u0010_Z,'O]5eS:<\u0007K]8qgV\tQ\u0004\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u0005!Q\u000f^5m\u0015\u0005\u0011\u0013\u0001\u00026bm\u0006L!\u0001J\u0010\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\tpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9tA\u00051An\\4ESJ,\u0012\u0001\u000b\t\u0003S1j\u0011A\u000b\u0006\u0003W\u0005\n!![8\n\u00055R#\u0001\u0002$jY\u0016\fq\u0001\\8h\t&\u0014\b%A\bhK:,'/\u0019;f\u0007>tg-[4t+\u0005\t\u0004c\u0001\u001a8s5\t1G\u0003\u00025k\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001a\u0003\u0007M+\u0017\u000f\u0005\u0002\u001bu%\u00111h\u0003\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u000buKN$H+[3s)>\u0004\u0018nY'b]\u0006<WM\u001d\u000b\u0002}A\u0011q\bQ\u0007\u0002k%\u0011\u0011)\u000e\u0002\u0005+:LG\u000f\u000b\u0002\b\u0007B\u0011A)T\u0007\u0002\u000b*\u0011aiR\u0001\u0004CBL'B\u0001%J\u0003\u001dQW\u000f]5uKJT!AS&\u0002\u000b),h.\u001b;\u000b\u00031\u000b1a\u001c:h\u0013\tqUI\u0001\u0003UKN$\u0018aF2sK\u0006$X-\u00113nS:\u001cE.[3oi\u000e{gNZ5h)\u0005\t\u0006\u0003\u0002\u0010S)~K!aU\u0010\u0003\u00075\u000b\u0007\u000f\u0005\u0002V9:\u0011aK\u0017\t\u0003/Vj\u0011\u0001\u0017\u0006\u00033>\ta\u0001\u0010:p_Rt\u0014BA.6\u0003\u0019\u0001&/\u001a3fM&\u0011QL\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005m+\u0004C\u00011d\u001b\u0005\t'B\u00012\"\u0003\u0011a\u0017M\\4\n\u0005\u0011\f'AB(cU\u0016\u001cG/A\u000ebgN,'\u000f\u001e+jKJ\u001cF/\u0019;f)>\u0004\u0018nY\"p]\u001aLwm\u001d")
public class TierTopicManagerIntegrationTest
extends KafkaServerTestHarness {
    private final Properties overridingProps = new Properties();
    private final File logDir;

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public File logDir() {
        return this.logDir;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTierTopicManager() {
        TierTopicManager tierTopicManager = (TierTopicManager)((KafkaBroker)this.servers().last()).tierTopicManagerOpt().get();
        LogManager logManager = ((KafkaServer)this.servers().last()).logManager();
        Properties properties = new Properties();
        properties.put("confluent.tier.enable", "true");
        properties.put("cleanup.policy", "delete");
        while (!tierTopicManager.isReady()) {
            Thread.sleep(5L);
        }
        this.assertTierStateTopicConfigs();
        String topic1 = "foo";
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic1, 2, 1, (Seq<KafkaServer>)this.servers(), properties);
        TopicPartition topicPartition = new TopicPartition(topic1, 0);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicManagerIntegrationTest.$anonfun$testTierTopicManager$1(logManager, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerIntegrationTest.$anonfun$testTierTopicManager$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        TierPartitionState tierPartitionState1 = ((AbstractLog)logManager.getLog(topicPartition, logManager.getLog$default$2()).get()).tierPartitionState();
        TopicIdPartition topicIdPartition1 = (TopicIdPartition)tierPartitionState1.topicIdPartition().get();
        CompletableFuture<TierPartitionState.AppendResult> result1 = TierTestUtils$.MODULE$.uploadWithMetadata(tierTopicManager, topicIdPartition1, 0, UUID.randomUUID(), 0L, 1000L, 15000L, 0L, 100, false, true, false, tierPartitionState1.lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)result1.get());
        tierPartitionState1.flush();
        Assertions.assertEquals((long)1000L, (long)tierPartitionState1.committedEndOffset());
        CompletableFuture<TierPartitionState.AppendResult> result2 = TierTestUtils$.MODULE$.uploadWithMetadata(tierTopicManager, topicIdPartition1, 0, UUID.randomUUID(), 0L, 1000L, 15000L, 0L, 200, false, true, false, tierPartitionState1.lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, (Object)result2.get());
        tierPartitionState1.flush();
        Assertions.assertEquals((long)1000L, (long)tierPartitionState1.committedEndOffset());
        Assertions.assertEquals((int)1, (int)tierPartitionState1.numSegments());
        String topic2 = "topic2";
        TopicPartition topicPartition2 = new TopicPartition(topic2, 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), topicPartition2.topic(), 1, 1, (Seq<KafkaServer>)this.servers(), properties);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierTopicManagerIntegrationTest.$anonfun$testTierTopicManager$4(logManager, topicPartition2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerIntegrationTest.$anonfun$testTierTopicManager$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        TierPartitionState tierPartitionState2 = ((AbstractLog)logManager.getLog(topicPartition2, logManager.getLog$default$2()).get()).tierPartitionState();
        Assertions.assertTrue((boolean)tierPartitionState2.topicIdPartition().isPresent());
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = 500L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TierTopicManagerIntegrationTest.$anonfun$testTierTopicManager$7(tierPartitionState1, tierPartitionState2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicManagerIntegrationTest.$anonfun$testTierTopicManager$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        TierPartitionState originalState = ((AbstractLog)logManager.getLog(topicPartition, logManager.getLog$default$2()).get()).tierPartitionState();
        Assertions.assertEquals((int)1, (int)originalState.numSegments());
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> createAdminClientConfig() {
        void var1_1;
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("bootstrap.servers", this.brokerList());
        config.put("request.timeout.ms", "20000");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void assertTierStateTopicConfigs() {
        ObjectRef result = ObjectRef.create(null);
        try (AdminClient client = AdminClient.create(this.createAdminClientConfig());){
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierTopicManagerIntegrationTest.$anonfun$assertTierStateTopicConfigs$1(result, client)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TierTopicManagerIntegrationTest.$anonfun$assertTierStateTopicConfigs$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        Assertions.assertEquals((Object)"-1", (Object)((ConfigEntry)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)result.elem).entries()).asScala()).find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TierTopicManagerIntegrationTest.$anonfun$assertTierStateTopicConfigs$3(x$4))).get()).value());
        Assertions.assertEquals((Object)"-1", (Object)((ConfigEntry)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)result.elem).entries()).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TierTopicManagerIntegrationTest.$anonfun$assertTierStateTopicConfigs$4(x$5))).get()).value());
        Assertions.assertEquals((Object)"delete", (Object)((ConfigEntry)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)result.elem).entries()).asScala()).find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TierTopicManagerIntegrationTest.$anonfun$assertTierStateTopicConfigs$5(x$6))).get()).value());
        Assertions.assertEquals((Object)"false", (Object)((ConfigEntry)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)result.elem).entries()).asScala()).find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TierTopicManagerIntegrationTest.$anonfun$assertTierStateTopicConfigs$6(x$7))).get()).value());
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicManager$1(LogManager logManager$1, TopicPartition topicPartition$1) {
        Option partitionState = logManager$1.getLog(topicPartition$1, logManager$1.getLog$default$2()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.tierPartitionState());
        return partitionState.isDefined() && ((TierPartitionState)partitionState.get()).topicIdPartition().isPresent() && ((TierPartitionState)partitionState.get()).tierEpoch() == 0;
    }

    public static final /* synthetic */ String $anonfun$testTierTopicManager$3() {
        return "Did not become leader for TierPartitionState.";
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicManager$4(LogManager logManager$1, TopicPartition topicPartition2$1) {
        Option partitionState = logManager$1.getLog(topicPartition2$1, logManager$1.getLog$default$2()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.tierPartitionState());
        return partitionState.isDefined() && ((TierPartitionState)partitionState.get()).topicIdPartition().isPresent() && ((TierPartitionState)partitionState.get()).tierEpoch() == 0;
    }

    public static final /* synthetic */ String $anonfun$testTierTopicManager$6() {
        return "Did not become leader for TierPartitionState topic2.";
    }

    public static final /* synthetic */ boolean $anonfun$testTierTopicManager$7(TierPartitionState tierPartitionState1$1, TierPartitionState tierPartitionState2$1) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState1$1.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        if (!(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null)) {
            TierPartitionStatus tierPartitionStatus3 = tierPartitionState2$1.status();
            TierPartitionStatus tierPartitionStatus4 = TierPartitionStatus.ONLINE;
            if (!(tierPartitionStatus3 != null ? !tierPartitionStatus3.equals(tierPartitionStatus4) : tierPartitionStatus4 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testTierTopicManager$8() {
        return "tierTopicManager consumers catchingUp timed out";
    }

    public static final /* synthetic */ boolean $anonfun$assertTierStateTopicConfigs$1(ObjectRef result$1, AdminClient client$1) {
        try {
            ConfigResource existingTopic = new ConfigResource(ConfigResource.Type.TOPIC, "_confluent-tier-state");
            result$1.elem = (Config)((KafkaFuture)client$1.describeConfigs(Collections.singletonList(existingTopic)).values().get(existingTopic)).get();
            return true;
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof UnknownTopicOrPartitionException) {
                return false;
            }
            throw ee.getCause();
        }
    }

    public static final /* synthetic */ String $anonfun$assertTierStateTopicConfigs$2() {
        return "timed waiting to find tier state topic";
    }

    public static final /* synthetic */ boolean $anonfun$assertTierStateTopicConfigs$3(ConfigEntry x$4) {
        String string = x$4.name();
        String string2 = "retention.bytes";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$assertTierStateTopicConfigs$4(ConfigEntry x$5) {
        String string = x$5.name();
        String string2 = "retention.ms";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$assertTierStateTopicConfigs$5(ConfigEntry x$6) {
        String string = x$6.name();
        String string2 = "cleanup.policy";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$assertTierStateTopicConfigs$6(ConfigEntry x$7) {
        String string = x$7.name();
        String string2 = "unclean.leader.election.enable";
        return string != null && string.equals(string2);
    }

    public TierTopicManagerIntegrationTest() {
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "2");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.LogCleanupPolicyProp(), "compact");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "1000000");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.LogRetentionTimeMillisProp(), "1000000");
        this.overridingProps().setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        this.logDir = TestUtils$.MODULE$.tempDir();
    }
}

