/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import kafka.api.KAFKA_2_7_IV0$;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0006\r\u0001EAQA\u0006\u0001\u0005\u0002]AQ!\u0007\u0001\u0005BiAQa\u000b\u0001\u0005B1BQA\u000f\u0001\u0005\u00021BQa\u0010\u0001\u0005\u00021BQ!\u0011\u0001\u0005\u00021BQa\u0011\u0001\u0005\n\u0011CQ\u0001\u0019\u0001\u0005\n\u0005Dqa\u001b\u0001\u0012\u0002\u0013%A\u000eC\u0003x\u0001\u0011%\u0001PA\u0013U_BL7-\u00133XSRDw\n\u001c3J]R,'O\u0011:pW\u0016\u0014\bK]8u_\u000e|G\u000eV3ti*\u0011QBD\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003=\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001%A\u00111\u0003F\u0007\u0002\u0019%\u0011Q\u0003\u0004\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012\u0001\u0007\t\u0003'\u0001\tqC\u0019:pW\u0016\u0014\bK]8qKJ$\u0018p\u0014<feJLG-Z:\u0015\u0005m\t\u0003C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"\u0001B+oSRDQA\t\u0002A\u0002\r\n!\u0002\u001d:pa\u0016\u0014H/[3t!\t!\u0013&D\u0001&\u0015\t1s%\u0001\u0003vi&d'\"\u0001\u0015\u0002\t)\fg/Y\u0005\u0003U\u0015\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0003\u0015\u0019X\r^+q)\u0005Y\u0002FA\u0002/!\ty\u0003(D\u00011\u0015\t\t$'A\u0002ba&T!a\r\u001b\u0002\u000f),\b/\u001b;fe*\u0011QGN\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002o\u0005\u0019qN]4\n\u0005e\u0002$A\u0003\"fM>\u0014X-R1dQ\u0006qB/Z:u\u001b\u0016$\u0018\rZ1uCR{\u0007/[2JIN<\u0016\u000e\u001e5PY\u0012L%\t\u0015\u0015\u0003\tq\u0002\"aL\u001f\n\u0005y\u0002$\u0001\u0002+fgR\f!\u0004^3ti\u0012+G.\u001a;f)>\u0004\u0018nY:XSRDw\n\u001c3J\u0005BC#!\u0002\u001f\u0002EQ,7\u000f\u001e#fY\u0016$X\rV8qS\u000e\u001cx+\u001b;i\u001f2$\u0017J\u0011)Vg&tw-\u0013#tQ\t1A(A\ntK:$W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fF\u0002F!V\u0003\"A\u0012(\u000e\u0003\u001dS!\u0001S%\u0002\u0011I,\u0017/^3tiNT!AS&\u0002\r\r|W.\\8o\u0015\tyAJ\u0003\u0002Nm\u00051\u0011\r]1dQ\u0016L!aT$\u0003!5+G/\u00193bi\u0006\u0014Vm\u001d9p]N,\u0007\"B)\b\u0001\u0004\u0011\u0016a\u0002:fcV,7\u000f\u001e\t\u0003\rNK!\u0001V$\u0003\u001f5+G/\u00193bi\u0006\u0014V-];fgRDQAV\u0004A\u0002]\u000b1\u0002Z3ti&t\u0017\r^5p]B\u0019A\u0004\u0017.\n\u0005ek\"AB(qi&|g\u000e\u0005\u0002\\=6\tAL\u0003\u0002^\u001d\u00059a.\u001a;x_J\\\u0017BA0]\u00051\u0019vnY6fiN+'O^3s\u0003]\u0019XM\u001c3EK2,G/\u001a+pa&\u001c7OU3rk\u0016\u001cH\u000fF\u0002cK&\u0004\"AR2\n\u0005\u0011<%\u0001\u0006#fY\u0016$X\rV8qS\u000e\u001c(+Z:q_:\u001cX\rC\u0003R\u0011\u0001\u0007a\r\u0005\u0002GO&\u0011\u0001n\u0012\u0002\u0014\t\u0016dW\r^3U_BL7m\u001d*fcV,7\u000f\u001e\u0005\bU\"\u0001\n\u00111\u0001[\u00031\u0019xnY6fiN+'O^3s\u0003\u0005\u001aXM\u001c3EK2,G/\u001a+pa&\u001c7OU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005i'F\u0001.oW\u0005y\u0007C\u00019v\u001b\u0005\t(B\u0001:t\u0003%)hn\u00195fG.,GM\u0003\u0002u;\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Y\f(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u00061b/\u00197jI\u0006$X\rV8qS\u000eL5\u000fR3mKR,G\r\u0006\u0002\u001cs\")!P\u0003a\u0001w\u0006)Ao\u001c9jGB\u0019A0a\u0002\u000f\u0007u\f\u0019\u0001\u0005\u0002\u007f;5\tqPC\u0002\u0002\u0002A\ta\u0001\u0010:p_Rt\u0014bAA\u0003;\u00051\u0001K]3eK\u001aLA!!\u0003\u0002\f\t11\u000b\u001e:j]\u001eT1!!\u0002\u001e\u0001")
public class TopicIdWithOldInterBrokerProtocolTest
extends BaseRequestTest {
    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), KAFKA_2_7_IV0$.MODULE$.toString());
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "2");
        properties.setProperty(KafkaConfig$.MODULE$.RackProp(), new StringBuilder(5).append("rack/").append(properties.getProperty(KafkaConfig$.MODULE$.BrokerIdProp())).toString());
    }

    @Override
    @BeforeEach
    public void setUp() {
        this.doSetup(false);
    }

    @Test
    public void testMetadataTopicIdsWithOldIBP() {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        String topic1 = "topic1";
        this.createTopic(topic1, (Map<Object, Seq<Object>>)replicaAssignment);
        MetadataResponse resp = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$))).asJava(), true, 10, 10).build(), (Option<SocketServer>)new Some((Object)this.notControllerSocketServer()));
        Assertions.assertEquals((int)1, (int)resp.topicMetadata().size());
        resp.topicMetadata().forEach(topicMetadata -> {
            Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
            Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)topicMetadata.topicId());
        });
    }

    @Test
    public void testDeleteTopicsWithOldIBP() {
        int timeout = 10000;
        this.createTopic("topic-3", 5, 2, this.createTopic$default$4());
        this.createTopic("topic-4", 1, 2, this.createTopic$default$4());
        DeleteTopicsRequest request = (DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList((Object[])new String[]{"topic-3", "topic-4"})).setTimeoutMs(timeout)).build();
        DeleteTopicsResponse resp = this.sendDeleteTopicsRequest(request, this.sendDeleteTopicsRequest$default$2());
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(resp.errorCounts()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TopicIdWithOldInterBrokerProtocolTest.$anonfun$testDeleteTopicsWithOldIBP$1(x$1))).isEmpty(), (String)new StringBuilder(33).append("There should be no errors, found ").append(CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)resp.data().responses()).asScala()).toString());
        request.data().topicNames().forEach(topic -> this.validateTopicIsDeleted((String)topic));
        resp.data().responses().forEach(response -> Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)response.topicId()));
    }

    @Test
    public void testDeleteTopicsWithOldIBPUsingIDs() {
        int timeout = 10000;
        this.createTopic("topic-7", 3, 2, this.createTopic$default$4());
        this.createTopic("topic-6", 1, 2, this.createTopic$default$4());
        scala.collection.immutable.Map ids = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-7"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-6"), (Object)Uuid.randomUuid())}));
        DeleteTopicsRequest request = (DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopics(Arrays.asList((Object[])new DeleteTopicsRequestData.DeleteTopicState[]{new DeleteTopicsRequestData.DeleteTopicState().setTopicId((Uuid)ids.apply((Object)"topic-7")), new DeleteTopicsRequestData.DeleteTopicState().setTopicId((Uuid)ids.apply((Object)"topic-6"))})).setTimeoutMs(timeout)).build();
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.sendDeleteTopicsRequest$default$2());
        scala.collection.mutable.Map error = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(response.errorCounts()).asScala();
        Assertions.assertEquals((int)2, (Integer)((Integer)error.apply((Object)Errors.UNKNOWN_TOPIC_ID)));
    }

    private MetadataResponse sendMetadataRequest(MetadataRequest request, Option<SocketServer> destination) {
        return (MetadataResponse)this.connectAndReceive((AbstractRequest)request, (SocketServer)destination.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.anySocketServer()), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private DeleteTopicsResponse sendDeleteTopicsRequest(DeleteTopicsRequest request, SocketServer socketServer) {
        return (DeleteTopicsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteTopicsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private SocketServer sendDeleteTopicsRequest$default$2() {
        return this.controllerSocketServer();
    }

    /*
     * WARNING - void declaration
     */
    private void validateTopicIsDeleted(String topic) {
        Iterable metadata = (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava(), true).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()))).topicMetadata()).asScala();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicIdWithOldInterBrokerProtocolTest.$anonfun$validateTopicIsDeleted$1(metadata, topic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TopicIdWithOldInterBrokerProtocolTest.$anonfun$validateTopicIsDeleted$3(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicsWithOldIBP$1(Tuple2 x$1) {
        Object object = x$1._1();
        Errors errors = Errors.NONE;
        return object == null ? errors != null : !object.equals(errors);
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicIsDeleted$2(String topic$1, MetadataResponse.TopicMetadata p) {
        if (p.topic().equals(topic$1)) {
            Errors errors = p.error();
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicIsDeleted$1(Iterable metadata$1, String topic$1) {
        return !metadata$1.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TopicIdWithOldInterBrokerProtocolTest.$anonfun$validateTopicIsDeleted$2(topic$1, p)));
    }

    public static final /* synthetic */ String $anonfun$validateTopicIsDeleted$3(String topic$1) {
        return new StringBuilder(27).append("The topic ").append(topic$1).append(" should not exist").toString();
    }
}

