/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Serializable;
import kafka.server.checkpoints.LeaderEpochCheckpoint;
import kafka.server.checkpoints.LeaderEpochCheckpointBuffer;
import kafka.server.checkpoints.LeaderEpochCheckpointFile;
import kafka.server.checkpoints.LeaderEpochCheckpointFile$;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u001c9\u0001}BQA\u0012\u0001\u0005\u0002\u001dCqA\u0013\u0001C\u0002\u0013\u00051\n\u0003\u0004X\u0001\u0001\u0006I\u0001\u0014\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u0011\u0019\u0001\u0007\u0001)A\u00055\"9\u0011\r\u0001b\u0001\n\u0013\u0011\u0007B\u00024\u0001A\u0003%1\rC\u0003h\u0001\u0011\u0005\u0001\u000eC\u0003x\u0001\u0011\u0005\u0001\u000eC\u0003}\u0001\u0011\u0005\u0001\u000eC\u0003\u007f\u0001\u0011\u0005\u0001\u000e\u0003\u0004\u0002\u0002\u0001!\t\u0001\u001b\u0005\u0007\u0003\u000b\u0001A\u0011\u00015\t\r\u0005%\u0001\u0001\"\u0001i\u0011\u0019\ti\u0001\u0001C\u0001Q\"1\u0011\u0011\u0003\u0001\u0005\u0002!Da!!\u0006\u0001\t\u0003A\u0007BBA\r\u0001\u0011\u0005\u0001\u000e\u0003\u0004\u0002\u001e\u0001!\t\u0001\u001b\u0005\u0007\u0003C\u0001A\u0011\u00015\t\r\u0005\u0015\u0002\u0001\"\u0001i\u0011\u0019\tI\u0003\u0001C\u0001Q\"1\u0011Q\u0006\u0001\u0005\u0002!Da!!\r\u0001\t\u0003A\u0007BBA\u001b\u0001\u0011\u0005\u0001\u000e\u0003\u0004\u0002:\u0001!\t\u0001\u001b\u0005\u0007\u0003{\u0001A\u0011\u00015\t\r\u0005\u0005\u0003\u0001\"\u0001i\u0011\u0019\t)\u0005\u0001C\u0001Q\"1\u0011\u0011\n\u0001\u0005\u0002!Da!!\u0014\u0001\t\u0003A\u0007BBA)\u0001\u0011\u0005\u0001\u000e\u0003\u0004\u0002V\u0001!\t\u0001\u001b\u0005\u0007\u00033\u0002A\u0011\u00015\t\r\u0005u\u0003\u0001\"\u0001i\u0011\u0019\t\t\u0007\u0001C\u0001Q\"1\u0011Q\r\u0001\u0005\u0002!Da!!\u001b\u0001\t\u0003A\u0007BBA7\u0001\u0011\u0005\u0001\u000e\u0003\u0004\u0002r\u0001!\t\u0001\u001b\u0005\u0007\u0003k\u0002A\u0011\u00015\t\r\u0005e\u0004\u0001\"\u0001i\u0011\u0019\ti\b\u0001C\u0001Q\"1\u0011\u0011\u0011\u0001\u0005\u0002!Da!!\"\u0001\t\u0003A\u0007BBAE\u0001\u0011\u0005\u0001\u000e\u0003\u0004\u0002\u000e\u0002!\t\u0001\u001b\u0005\u0007\u0003#\u0003A\u0011\u00015\t\r\u0005U\u0005\u0001\"\u0001i\u0011\u0019\tI\n\u0001C\u0001Q\"1\u0011Q\u0014\u0001\u0005\u0002!Da!!)\u0001\t\u0003A\u0007BBAS\u0001\u0011\u0005\u0001\u000e\u0003\u0004\u0002*\u0002!\t\u0001\u001b\u0002\u0019\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NR5mK\u000e\u000b7\r[3UKN$(BA\u001d;\u0003\u0015)\u0007o\\2i\u0015\tYD(\u0001\u0004tKJ4XM\u001d\u0006\u0002{\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001A!\t\tE)D\u0001C\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u0013\t\u0003\u0013\u0002i\u0011\u0001O\u0001\u0003iB,\u0012\u0001\u0014\t\u0003\u001bVk\u0011A\u0014\u0006\u0003\u001fB\u000baaY8n[>t'BA\u001fR\u0015\t\u00116+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002)\u0006\u0019qN]4\n\u0005Ys%A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0004iB\u0004\u0013AC2iK\u000e\\\u0007o\\5oiV\t!\f\u0005\u0002\\=6\tAL\u0003\u0002^u\u0005Y1\r[3dWB|\u0017N\u001c;t\u0013\tyFLA\u000bMK\u0006$WM]#q_\u000eD7\t[3dWB|\u0017N\u001c;\u0002\u0017\rDWmY6q_&tG\u000fI\u0001\u0006G\u0006\u001c\u0007.Z\u000b\u0002GB\u0011\u0011\nZ\u0005\u0003Kb\u0012A\u0003T3bI\u0016\u0014X\t]8dQ\u001aKG.Z\"bG\",\u0017AB2bG\",\u0007%\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005I\u0007CA!k\u0013\tY'I\u0001\u0003V]&$\bF\u0001\u0005n!\tqW/D\u0001p\u0015\t\u0001\u0018/A\u0002ba&T!A]:\u0002\u000f),\b/\u001b;fe*\u0011AoU\u0001\u0006UVt\u0017\u000e^\u0005\u0003m>\u0014\u0011\"\u00114uKJ,\u0015m\u00195\u0002#Q,7\u000f\u001e)sKZLw.^:Fa>\u001c\u0007\u000e\u000b\u0002\nsB\u0011aN_\u0005\u0003w>\u0014A\u0001V3ti\u0006)3\u000f[8vY\u0012\fE\rZ#q_\u000eD\u0017I\u001c3NKN\u001c\u0018mZ3PM\u001a\u001cX\r\u001e+p\u0007\u0006\u001c\u0007.\u001a\u0015\u0003\u0015e\fqd\u001d5pk2$7+\u001a;SKN,GO\u00127bO\u0012K'\u000f^=P]\u0006\u001b8/[4oQ\tY\u00110\u0001\u0018tQ>,H\u000e\u001a*fiV\u0014h\u000eT8h\u000b:$wJ\u001a4tKRLe\rT1uKN$X\t]8dQJ+\u0017/^3ti\u0016$\u0007F\u0001\u0007z\u0003Q\u001a\bn\\;mIJ+G/\u001e:o+:$WMZ5oK\u0012|eMZ:fi&3WK\u001c3fM&tW\rZ#q_\u000eD'+Z9vKN$X\r\u001a\u0015\u0003\u001be\f!i\u001d5pk2$gj\u001c;Pm\u0016\u0014xO]5uK2{w-\u00128e\u001f\u001a47/\u001a;G_J\fE*Z1eKJ,\u0005o\\2i\u001f:\u001cW-\u0013;ICN\u0014U-\u001a8BgNLwM\\3eQ\tq\u00110\u0001\u0019tQ>,H\u000eZ#oM>\u00148-Z'p]>$xN\\5dC2d\u00170\u00138de\u0016\f7/\u001b8h'R\f'\u000f^(gMN,Go\u001d\u0015\u0003\u001fe\fAh\u001d5pk2$gj\u001c;Pm\u0016\u0014xO]5uK>3gm]3u\r>\u0014\u0018\tT3bI\u0016\u0014X\t]8dQ>s7-Z%u\u0011\u0006\u001c()Z3o\u0003N\u001c\u0018n\u001a8fI\"\u0012\u0001#_\u0001)g\"|W\u000f\u001c3SKR,(O\\+ogV\u0004\bo\u001c:uK\u0012LeMT8Fa>\u001c\u0007NU3d_J$W\r\u001a\u0015\u0003#e\f!i\u001d5pk2$'+\u001a;ve:,fn];qa>\u0014H/\u001a3JM:{W\t]8dQJ+7m\u001c:eK\u0012\fe\u000eZ+oI\u00164\u0017N\\3e\u000bB|7\r\u001b*fcV,7\u000f^3eQ\t\u0011\u00120\u0001\u001dtQ>,H\u000e\u001a*fiV\u0014hNR5sgR,\u0005o\\2i\u0013\u001a\u0014V-];fgR,G-\u00129pG\"dUm]:UQ\u0006tg)\u001b:ti\u0016\u0003xn\u00195)\u0005MI\u0018!N:i_VdG\r\u0016:v]\u000e\fG/Z%g\u001b\u0006$8\r[5oO\u0016\u0003xn\u00195CkR,\u0015M\u001d7jKJ\u001cF/\u0019:uS:<wJ\u001a4tKRD#\u0001F=\u0002\u0011NDw.\u001e7e\u000f\u0016$h)\u001b:ti>3gm]3u\u001f\u001a\u001cVOY:fcV,g\u000e^#q_\u000eDw\u000b[3o\u001f\u001a47/\u001a;SKF,Xm\u001d;fI\u001a{'\u000f\u0015:fm&|Wo]#q_\u000eD\u0007FA\u000bz\u0003\u0015\u001b\bn\\;mIJ+G/\u001e:o\u001d\u0016DH/\u0011<bS2\f'\r\\3Fa>\u001c\u0007.\u00134UQ\u0016\u0014X-S:O_\u0016C\u0018m\u0019;Fa>\u001c\u0007NR8s)\",wJ\\3SKF,Xm\u001d;fI\"\u0012a#_\u00013g\"|W\u000f\u001c3O_R,\u0006\u000fZ1uK\u0016\u0003xn\u00195B]\u0012\u001cF/\u0019:u\u001f\u001a47/\u001a;JM&#H)\u001b3O_R\u001c\u0005.\u00198hK\"\u0012q#_\u0001Fg\"|W\u000f\u001c3SKR,(O\\%om\u0006d\u0017\u000eZ(gMN,G/\u00134Fa>\u001c\u0007.S:SKF,Xm\u001d;fI^C\u0017n\u00195Jg:{GoQ;se\u0016tG\u000f\\=Ue\u0006\u001c7.\u001a3)\u0005aI\u0018!K:i_VdGmU;qa>\u0014H/\u00129pG\"\u001cH\u000b[1u\t>tu\u000e^*uCJ$hI]8n5\u0016\u0014x\u000e\u000b\u0002\u001as\u0006\u00193\u000f[8vY\u0012\u0004VM]:jgR,\u0005o\\2ig\n+Go^3f]&s7\u000f^1oG\u0016\u001c\bF\u0001\u000ez\u0003)\u001a\bn\\;mI\u0016sgm\u001c:dK6{gn\u001c;p]&\u001c\u0017\r\u001c7z\u0013:\u001c'/Z1tS:<W\t]8dQND#aG=\u0002SMDw.\u001e7e\u000b:4wN]2f\u001f\u001a47/\u001a;t\u0013:\u001c'/Z1tK6{gn\u001c;p]&\u001c\u0017\r\u001c7zQ\ta\u00120\u0001\u001btQ>,H\u000eZ%oGJ,\u0017m]3B]\u0012$&/Y2l\u000bB|7\r[:Bg2+\u0017\rZ3sg\u000eC\u0017M\\4f\u001b\u0006t\u0017\u0010V5nKND#!H=\u0002uMDw.\u001e7e\u0013:\u001c'/Z1tK\u0006sG\r\u0016:bG.,\u0005o\\2ig\u0006\u001bhi\u001c7m_^,'OU3dK&4Xm]'b]flUm]:bO\u0016\u001c\bF\u0001\u0010z\u0003e\u001a\bn\\;mI\u0012\u0013x\u000e]#oiJLWm](o\u000bB|7\r\u001b\"pk:$\u0017M]=XQ\u0016t'+Z7pm&tw\rT1uKN$XI\u001c;sS\u0016\u001c\bFA\u0010z\u0003M\u001a\bn\\;mIB\u0013Xm]3sm\u0016\u0014Vm]3u\u001f\u001a47/\u001a;P]\u000ecW-\u0019:FCJd\u0017.Z:u\u0013\u001a|e.Z#ySN$8\u000f\u000b\u0002!s\u0006I4\u000f[8vY\u0012,\u0006\u000fZ1uKN\u000bg/\u001a3PM\u001a\u001cX\r^,iK:|eMZ:fiR{7\t\\3beR{\u0017j\u001d\"fi^,WM\\#q_\u000eD7\u000f\u000b\u0002\"s\u0006)3\u000f[8vY\u0012tu\u000e^\"mK\u0006\u0014\u0018I\\=uQ&tw-\u00134PM\u001a\u001cX\r\u001e+p\u000b\u0006\u0014H.\u001f\u0015\u0003Ee\f1f\u001d5pk2$gj\u001c;DY\u0016\f'/\u00118zi\"LgnZ%g\u001f\u001a47/\u001a;U_\u001aK'o\u001d;PM\u001a\u001cX\r\u001e\u0015\u0003Ge\f\u0011f\u001d5pk2$'+\u001a;bS:d\u0015\r^3ti\u0016\u0003xn\u00195P]\u000ecW-\u0019:BY2,\u0015M\u001d7jKN$\bF\u0001\u0013z\u0003]\u001a\bn\\;mIV\u0003H-\u0019;f\u001f\u001a47/\u001a;CKR<X-\u001a8Fa>\u001c\u0007NQ8v]\u0012\f'/[3t\u001f:\u001cE.Z1s\u000b\u0006\u0014H.[3ti\"\u0012Q%_\u00019g\"|W\u000f\u001c3Va\u0012\fG/Z(gMN,GOQ3uo\u0016,g.\u00129pG\"\u0014u.\u001e8eCJLWm](o\u00072,\u0017M]#be2LWm\u001d;3Q\t1\u00130A\u001etQ>,H\u000e\u001a*fi\u0006Lg\u000eT1uKN$X\t]8dQ>s7\t\\3be\u0006cG.R1sY&,7\u000f^!oIV\u0003H-\u0019;f\u0013R\u001cxJ\u001a4tKRD#aJ=\u0002AQ,7\u000f\u001e+sk:\u001c\u0017\r^3Ge>l7\u000b^1si^KG\u000f\u001b(p\r2,8\u000f\u001b\u0015\u0003Qe\fqg\u001d5pk2$GI]8q\u000b:$(/[3t\u0005\u0016$x/Z3o\u000bB|7\r\u001b\"pk:$\u0017M]=XQ\u0016t'+Z7pm&twMT3xKN$\bFA\u0015z\u0003u\u0019\bn\\;mI\u000ecW-\u0019:B]\u00124E.^:i\u00032dWI\u001c;sS\u0016\u001c\bF\u0001\u0016z\u0003U\u0019\bn\\;mI\u000ecW-\u0019:BY2,e\u000e\u001e:jKND#aK=\u0002_MDw.\u001e7e\u001d>$(+Z:fi\u0016\u0003xn\u00195ISN$xN]=IK\u0006$\u0017JZ+oI\u00164\u0017N\\3e!\u0006\u001c8/\u001a3)\u00051J\u0018aL:i_VdGMT8u%\u0016\u001cX\r^#q_\u000eD\u0007*[:u_JLH+Y5m\u0013\u001a,f\u000eZ3gS:,G\rU1tg\u0016$\u0007FA\u0017z\u0003\t\u001a\bn\\;mI\u000e{'O]3di2L(+Z:u_J,g)\u001e7m':\f\u0007o\u001d5pi\"\u0012a&_\u0001#g\"|W\u000f\u001c3GKR\u001c\u0007\u000eT1uKN$X\t]8dQ>3W)\u001c9us\u000e\u000b7\r[3)\u0005=J\u0018\u0001I:i_VdGMR3uG\",e\u000eZ(gMN,Go\u00144F[B$\u0018pQ1dQ\u0016D#\u0001M=\u0002?MDw.\u001e7e\u00072,\u0017M]#be2LWm\u001d;P]\u0016k\u0007\u000f^=DC\u000eDW\r\u000b\u00022s\u0006i2\u000f[8vY\u0012\u001cE.Z1s\u0019\u0006$Xm\u001d;P]\u0016k\u0007\u000f^=DC\u000eDW\r\u000b\u00023s\u000613\u000f[8vY\u0012\u0014V\r^;s]\u000e{'O]3diN#\u0018M\u001d;PM\u001a\u001cX\r\u001e$pe\u0016\u0003xn\u00195)\u0005MJ\u0018\u0001\u0007;jKJ,G-\u00129pG\"\u001c\u0015m\u00195f':\f\u0007o\u001d5pi\"\u0012A'_\u0001*g\"|W\u000f\u001c3O_R\u0014V\r]8si\u0012Kg/\u001a:hK:\u001cWm\u00165f]:{G)\u001b<fe\u001e,gnY3)\u0005UJ\u0018aI:i_VdGMU3q_J$H)\u001b<fe\u001e,gnY3XQ\u0016tG)\u001b<fe\u001eLgn\u001a\u0015\u0003me\u0004")
public class LeaderEpochFileCacheTest {
    private final TopicPartition tp = new TopicPartition("TestTopic", 5);
    private final LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
        private Seq<EpochEntry> epochs;
        private final File file;

        private Seq<EpochEntry> epochs() {
            return this.epochs;
        }

        private void epochs_$eq(Seq<EpochEntry> x$1) {
            this.epochs = x$1;
        }

        public File file() {
            return this.file;
        }

        public void write(Iterable<EpochEntry> epochs) {
            this.epochs_$eq((Seq<EpochEntry>)epochs.toSeq());
        }

        public byte[] toByteArray(Seq<EpochEntry> epochs) {
            throw new UnsupportedOperationException("toByteArray is currently unused and is not implemented for the test checkpoint implementation");
        }

        public Seq<EpochEntry> read() {
            return this.epochs();
        }
        {
            this.epochs = Nil$.MODULE$;
            this.file = TestUtils$.MODULE$.tempFile();
        }
    };
    private final LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), this.checkpoint());

    public TopicPartition tp() {
        return this.tp;
    }

    private LeaderEpochCheckpoint checkpoint() {
        return this.checkpoint;
    }

    private LeaderEpochFileCache cache() {
        return this.cache;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.checkpoint().file());
    }

    @Test
    public void testPreviousEpoch() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.cache().previousEpoch());
        this.cache().assign(2, 10L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.cache().previousEpoch());
        this.cache().assign(4, 15L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.cache().previousEpoch());
        this.cache().assign(10, 20L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)this.cache().previousEpoch());
        this.cache().truncateFromEnd(18L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.cache().previousEpoch());
    }

    @Test
    public void shouldAddEpochAndMessageOffsetToCache() {
        this.cache().assign(2, 10L);
        int logEndOffset = 11;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new EpochEntry(2, 10L), (Object)this.cache().epochEntries().apply(0));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), (Object)this.cache().endOffsetFor(2, (long)logEndOffset));
    }

    @Test
    public void shouldSetResetFlagDirtyOnAssign() {
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.cache().isDirty()));
        this.cache().assign(2, 10L);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)this.cache().isDirty()));
        this.cache().maybeFlush();
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToBoolean((boolean)this.cache().isDirty()));
    }

    @Test
    public void shouldReturnLogEndOffsetIfLatestEpochRequested() {
        this.cache().assign(2, 11L);
        this.cache().assign(2, 12L);
        int logEndOffset = 14;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), (Object)this.cache().endOffsetFor(2, (long)logEndOffset));
    }

    @Test
    public void shouldReturnUndefinedOffsetIfUndefinedEpochRequested() {
        Tuple2.mcIJ.sp expectedEpochEndOffset = new Tuple2.mcIJ.sp(-1, -1L);
        this.cache().assign(2, 11L);
        this.cache().assign(3, 12L);
        Tuple2 epochAndOffsetFor = this.cache().endOffsetFor(-1, 0L);
        Assertions.assertEquals((Object)expectedEpochEndOffset, (Object)epochAndOffsetFor, (String)"Expected undefined epoch and offset if undefined epoch requested. Cache not empty.");
    }

    @Test
    public void shouldNotOverwriteLogEndOffsetForALeaderEpochOnceItHasBeenAssigned() {
        int logEndOffset = 9;
        this.cache().assign(2, (long)logEndOffset);
        this.cache().assign(2, 10L);
        Assertions.assertEquals((long)logEndOffset, (long)((EpochEntry)this.cache().epochEntries().apply(0)).startOffset());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 9L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingStartOffsets() {
        this.cache().assign(2, 9L);
        this.cache().assign(3, 9L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotOverwriteOffsetForALeaderEpochOnceItHasBeenAssigned() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 10L);
        Assertions.assertEquals((long)6L, (long)((EpochEntry)this.cache().epochEntries().apply(0)).startOffset());
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecorded() {
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(0, 0L));
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecordedAndUndefinedEpochRequested() {
        Tuple2 offsetFor = this.cache().endOffsetFor(-1, 73L);
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)offsetFor, (String)"Expected undefined epoch and offset if undefined epoch requested. Empty cache.");
    }

    @Test
    public void shouldReturnFirstEpochIfRequestedEpochLessThanFirstEpoch() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        Tuple2 epochAndOffset = this.cache().endOffsetFor(4, 0L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(4, 11), (Object)epochAndOffset);
    }

    @Test
    public void shouldTruncateIfMatchingEpochButEarlierStartingOffset() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        this.cache().assign(7, 12L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(5, 12), (Object)this.cache().endOffsetFor(5, 0L));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(5, 12), (Object)this.cache().endOffsetFor(6, 0L));
    }

    @Test
    public void shouldGetFirstOffsetOfSubsequentEpochWhenOffsetRequestedForPreviousEpoch() {
        this.cache().assign(1, 11L);
        this.cache().assign(1, 12L);
        this.cache().assign(2, 13L);
        this.cache().assign(2, 14L);
        this.cache().assign(3, 15L);
        this.cache().assign(3, 16L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 15), (Object)this.cache().endOffsetFor(2, 17L));
    }

    @Test
    public void shouldReturnNextAvailableEpochIfThereIsNoExactEpochForTheOneRequested() {
        this.cache().assign(0, 10L);
        this.cache().assign(2, 13L);
        this.cache().assign(4, 17L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 13), (Object)this.cache().endOffsetFor(1, 0L));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 17), (Object)this.cache().endOffsetFor(2, 0L));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 17), (Object)this.cache().endOffsetFor(3, 0L));
    }

    @Test
    public void shouldNotUpdateEpochAndStartOffsetIfItDidNotChange() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        Assertions.assertEquals((int)1, (int)this.cache().epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), (Object)this.cache().epochEntries().toList().apply(0));
    }

    @Test
    public void shouldReturnInvalidOffsetIfEpochIsRequestedWhichIsNotCurrentlyTracked() {
        int logEndOffset = 100;
        this.cache().assign(2, 100L);
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(3, (long)logEndOffset));
    }

    @Test
    public void shouldSupportEpochsThatDoNotStartFromZero() {
        this.cache().assign(2, 6L);
        int logEndOffset = 7;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), (Object)this.cache().endOffsetFor(2, (long)logEndOffset));
        Assertions.assertEquals((int)1, (int)this.cache().epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), (Object)this.cache().epochEntries().apply(0));
    }

    @Test
    public void shouldPersistEpochsBetweenInstances() {
        String checkpointPath = TestUtils$.MODULE$.tempFile().getAbsolutePath();
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(new File(checkpointPath), LeaderEpochCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), (LeaderEpochCheckpoint)checkpoint);
        cache.assign(2, 6L);
        cache.maybeFlush();
        LeaderEpochCheckpointFile checkpoint2 = new LeaderEpochCheckpointFile(new File(checkpointPath), LeaderEpochCheckpointFile$.MODULE$.$lessinit$greater$default$2());
        LeaderEpochFileCache cache2 = new LeaderEpochFileCache(this.tp(), (LeaderEpochCheckpoint)checkpoint2);
        Assertions.assertEquals((int)1, (int)cache2.epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), (Object)cache2.epochEntries().toList().apply(0));
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingEpochs() {
        this.cache().assign(1, 5L);
        this.cache().assign(2, 6L);
        this.cache().assign(1, 7L);
        int logEndOffset = 8;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 8), (Object)this.cache().endOffsetFor(1, (long)logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(2, (long)logEndOffset));
        Assertions.assertEquals((Object)new EpochEntry(1, 7L), (Object)this.cache().epochEntries().apply(0));
    }

    @Test
    public void shouldEnforceOffsetsIncreaseMonotonically() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 5L);
        Assertions.assertEquals((Object)new EpochEntry(3, 5L), (Object)this.cache().epochEntries().toList().apply(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsLeadersChangeManyTimes() {
        long logEndOffset = 0L;
        this.cache().assign(0, 0L);
        this.cache().assign(1, 0L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 0), (Object)this.cache().endOffsetFor(1, logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0, logEndOffset));
        logEndOffset = 5L;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 5), (Object)this.cache().endOffsetFor(1, logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0, logEndOffset));
        this.cache().assign(2, 5L);
        logEndOffset = 10L;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 10), (Object)this.cache().endOffsetFor(2, logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 5), (Object)this.cache().endOffsetFor(1, logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), (Object)this.cache().endOffsetFor(0, logEndOffset));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsFollowerReceivesManyMessages() {
        this.cache().assign(0, 0L);
        this.cache().assign(0, 1L);
        this.cache().assign(0, 2L);
        int logEndOffset = 3;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, logEndOffset), (Object)this.cache().endOffsetFor(0, (long)logEndOffset));
        this.cache().assign(1, 3L);
        this.cache().assign(1, 4L);
        this.cache().assign(1, 5L);
        logEndOffset = 6;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, logEndOffset), (Object)this.cache().endOffsetFor(1, (long)logEndOffset));
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        this.cache().assign(2, 8L);
        logEndOffset = 9;
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), (Object)this.cache().endOffsetFor(2, (long)logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 3), (Object)this.cache().endOffsetFor(0, (long)logEndOffset));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 6), (Object)this.cache().endOffsetFor(1, (long)logEndOffset));
    }

    @Test
    public void shouldDropEntriesOnEpochBoundaryWhenRemovingLatestEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(8L);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldPreserveResetOffsetOnClearEarliestIfOneExists() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(8L, this.cache().truncateFromStart$default$2());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldUpdateSavedOffsetWhenOffsetToClearToIsBetweenEpochs() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L, this.cache().truncateFromStart$default$2());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToEarly() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        Assertions.assertTrue((boolean)this.cache().isDirty());
        this.cache().truncateFromStart(1L, this.cache().truncateFromStart$default$2());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
        Assertions.assertTrue((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToFirstOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(6L, this.cache().truncateFromStart$default$2());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(11L, this.cache().truncateFromStart$default$2());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L, this.cache().truncateFromStart$default$2());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)})), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest2() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 7L);
        this.cache().assign(2, 10L);
        this.cache().truncateFromStart(5L, this.cache().truncateFromStart$default$2());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 5L), new EpochEntry(1, 7L), new EpochEntry(2, 10L)})), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliestAndUpdateItsOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(15L, this.cache().truncateFromStart$default$2());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(4, 15L)})), (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
    }

    @Test
    public void testTruncateFromStartWithNoFlush() {
        .colon.colon epochs = new .colon.colon((Object)new EpochEntry(2, 6L), (List)new .colon.colon((Object)new EpochEntry(3, 8L), (List)new .colon.colon((Object)new EpochEntry(4, 11L), (List)Nil$.MODULE$)));
        epochs.foreach((Function1 & Serializable & scala.Serializable)epoch -> {
            LeaderEpochFileCacheTest.$anonfun$testTruncateFromStartWithNoFlush$1(this, epoch);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.cache().isDirty());
        this.cache().maybeFlush();
        Assertions.assertFalse((boolean)this.cache().isDirty());
        this.cache().truncateFromStart(8L, false);
        Seq updatedEpochs = (Seq)epochs.tail();
        Assertions.assertTrue((boolean)this.cache().isDirty());
        Assertions.assertEquals((Object)updatedEpochs, (Object)this.cache().epochEntries());
        Assertions.assertEquals((Object)epochs, (Object)new LeaderEpochFileCache(this.tp(), this.checkpoint()).epochEntries());
        this.cache().maybeFlush();
        Assertions.assertFalse((boolean)this.cache().isDirty());
        Assertions.assertEquals((Object)updatedEpochs, (Object)this.cache().epochEntries());
        Assertions.assertEquals((Object)updatedEpochs, (Object)new LeaderEpochFileCache(this.tp(), this.checkpoint()).epochEntries());
    }

    @Test
    public void shouldDropEntriesBetweenEpochBoundaryWhenRemovingNewest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(9L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)3)), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L)})), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldClearAndFlushAllEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().clearAndFlush();
        Assertions.assertEquals((int)0, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldClearAllEntries() {
        .colon.colon epochs = new .colon.colon((Object)new EpochEntry(2, 6L), (List)new .colon.colon((Object)new EpochEntry(3, 8L), (List)new .colon.colon((Object)new EpochEntry(4, 11L), (List)Nil$.MODULE$)));
        epochs.foreach((Function1 & Serializable & scala.Serializable)epoch -> {
            LeaderEpochFileCacheTest.$anonfun$shouldClearAllEntries$1(this, epoch);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.cache().isDirty());
        this.cache().maybeFlush();
        Assertions.assertFalse((boolean)this.cache().isDirty());
        this.cache().clear();
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)this.cache().epochEntries());
        Assertions.assertTrue((boolean)this.cache().isDirty());
        Assertions.assertEquals((Object)epochs, (Object)new LeaderEpochFileCache(this.tp(), this.checkpoint()).epochEntries());
        this.cache().maybeFlush();
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)this.cache().epochEntries());
        Assertions.assertFalse((boolean)this.cache().isDirty());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)new LeaderEpochFileCache(this.tp(), this.checkpoint()).epochEntries());
    }

    @Test
    public void shouldNotResetEpochHistoryHeadIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(-1L, this.cache().truncateFromStart$default$2());
        Assertions.assertEquals((int)3, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryTailIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(-1L);
        Assertions.assertEquals((int)3, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldCorrectlyRestoreFullSnapshot() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        .colon.colon snapshot = new .colon.colon((Object)new EpochEntry(3, 8L), (List)new .colon.colon((Object)new EpochEntry(4, 11L), (List)new .colon.colon((Object)new EpochEntry(5, 14L), (List)Nil$.MODULE$)));
        this.cache().restore((List)snapshot);
        Assertions.assertEquals((Object)snapshot, (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldFetchLatestEpochOfEmptyCache() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.cache().latestEpoch());
    }

    @Test
    public void shouldFetchEndOffsetOfEmptyCache() {
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), (Object)this.cache().endOffsetFor(7, 0L));
    }

    @Test
    public void shouldClearEarliestOnEmptyCache() {
        this.cache().truncateFromStart(7L, this.cache().truncateFromStart$default$2());
    }

    @Test
    public void shouldClearLatestOnEmptyCache() {
        this.cache().truncateFromEnd(7L);
    }

    @Test
    public void shouldReturnCorrectStartOffsetForEpoch() {
        this.cache().assign(1, 10L);
        this.cache().assign(2, 20L);
        this.cache().assign(3, 30L);
        int requestedEpoch = 0;
        Assertions.assertEquals((long)-1L, (long)this.cache().offsetForEpoch(requestedEpoch), (String)new StringBuilder(39).append("Returned wrong start offset for epoch: ").append(requestedEpoch).toString());
        requestedEpoch = 4;
        Assertions.assertEquals((long)-1L, (long)this.cache().offsetForEpoch(requestedEpoch), (String)new StringBuilder(39).append("Returned wrong start offset for epoch: ").append(requestedEpoch).toString());
        requestedEpoch = 1;
        Assertions.assertEquals((long)10L, (long)this.cache().offsetForEpoch(requestedEpoch), (String)new StringBuilder(39).append("Returned wrong start offset for epoch: ").append(requestedEpoch).toString());
        this.cache().clearAndFlush();
        Assertions.assertEquals((long)-1L, (long)this.cache().offsetForEpoch(requestedEpoch), (String)new StringBuilder(39).append("Returned wrong start offset for epoch: ").append(requestedEpoch).toString());
    }

    @Test
    public void tieredEpochCacheSnapshot() {
        File checkpointFile = TestUtils$.MODULE$.tempFile();
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(checkpointFile, null);
        LeaderEpochFileCache newCache = new LeaderEpochFileCache(this.tp(), (LeaderEpochCheckpoint)checkpoint);
        newCache.assign(3, 43L);
        newCache.assign(5, 50L);
        newCache.assign(7, 70L);
        newCache.assign(8, 80L);
        byte[] bytesOut = newCache.snapshotForSegment(70L);
        LeaderEpochCheckpointBuffer checkPointBuffer = new LeaderEpochCheckpointBuffer("frombuffer", new BufferedReader(new InputStreamReader(new ByteArrayInputStream(bytesOut))));
        Assertions.assertEquals((Object)new .colon.colon((Object)new EpochEntry(3, 43L), (List)new .colon.colon((Object)new EpochEntry(5, 50L), (List)new .colon.colon((Object)new EpochEntry(7, 70L), (List)Nil$.MODULE$))), (Object)checkPointBuffer.read().toList());
    }

    @Test
    public void shouldNotReportDivergenceWhenNoDivergence() {
        this.cache().assign(5, 50L);
        this.cache().assign(6, 60L);
        this.cache().assign(7, 70L);
        this.cache().assign(8, 80L);
        List tieredEpochState = this.cache().epochEntries().toList();
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 50L, 89L, 50L, 89L), (String)"False positive for divergence while comparing with identical tier state");
        this.cache().clearAndFlush();
        this.cache().assign(6, 60L);
        this.cache().assign(7, 70L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 50L, 89L, 60L, 79L), (String)"False positive for divergence while comparing with an identical but superset tier state");
        this.cache().clearAndFlush();
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 50L, 89L, 0L, -1L), (String)"False positive for divergence when epoch cache is empty");
        tieredEpochState = Nil$.MODULE$;
        this.cache().clearAndFlush();
        this.cache().assign(10, 100L);
        this.cache().assign(11, 110L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, -1L, 100L, 119L), (String)"False positive for divergence when epoch cache is empty");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(5, 50L), (List)new .colon.colon((Object)new EpochEntry(6, 60L), (List)new .colon.colon((Object)new EpochEntry(7, 70L), (List)new .colon.colon((Object)new EpochEntry(8, 80L), (List)Nil$.MODULE$))));
        this.cache().clearAndFlush();
        this.cache().assign(10, 100L);
        this.cache().assign(11, 110L);
        this.cache().assign(12, 120L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 50L, 89L, 100L, 129L), (String)"False positive for divergence while comparing with a disjointed epoch cache");
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        this.cache().assign(1, 10L);
        this.cache().assign(2, 20L);
        this.cache().assign(3, 30L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 50L, 89L, 0L, 39L), (String)"False positive for divergence while comparing with a disjointed epoch cache");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)new .colon.colon((Object)new EpochEntry(1, 10L), (List)new .colon.colon((Object)new EpochEntry(2, 20L), (List)new .colon.colon((Object)new EpochEntry(3, 30L), (List)new .colon.colon((Object)new EpochEntry(4, 40L), (List)new .colon.colon((Object)new EpochEntry(5, 40L), (List)new .colon.colon((Object)new EpochEntry(6, 40L), (List)Nil$.MODULE$)))))));
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        this.cache().assign(1, 10L);
        this.cache().assign(2, 20L);
        this.cache().assign(3, 30L);
        this.cache().assign(6, 40L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 49L, 0L, 49L), (String)"False positive for divergence when follower had not recorded leader with no messages");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)new .colon.colon((Object)new EpochEntry(1, 10L), (List)new .colon.colon((Object)new EpochEntry(2, 20L), (List)new .colon.colon((Object)new EpochEntry(3, 30L), (List)Nil$.MODULE$))));
        this.cache().clearAndFlush();
        this.cache().assign(0, 5L);
        this.cache().assign(1, 10L);
        this.cache().assign(2, 20L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 39L, 5L, 29L), (String)"False positive for divergence when local log had been incremented");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)Nil$.MODULE$);
        this.cache().clearAndFlush();
        this.cache().assign(0, 100L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 899L, 100L, 999L), (String)"False positive for divergence when single entry in leaderCache, local log incremented and lastLocalOffset != lastTieredOffset");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)Nil$.MODULE$);
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 899L, 0L, 999L), (String)"False positive for divergence when end offset for an epoch mismatch due to lastLocalOffset != lastTieredOffset");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)Nil$.MODULE$);
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        this.cache().assign(1, 100L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 49L, 0L, 149L), (String)"False negative when end offset for an epoch mismatches");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)new .colon.colon((Object)new EpochEntry(1, 100L), (List)Nil$.MODULE$));
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        Assertions.assertEquals((long)-1L, (long)this.cache().findDivergenceInEpochCache(tieredEpochState, 0L, 199L, 0L, 49L), (String)"False negative when end offset for an epoch mismatches");
    }

    @Test
    public void shouldReportDivergenceWhenDiverging() {
        .colon.colon tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)new .colon.colon((Object)new EpochEntry(1, 10L), (List)new .colon.colon((Object)new EpochEntry(2, 20L), (List)new .colon.colon((Object)new EpochEntry(3, 30L), (List)Nil$.MODULE$))));
        this.cache().assign(2, 20L);
        this.cache().assign(3, 25L);
        this.cache().assign(4, 40L);
        this.cache().assign(5, 50L);
        Assertions.assertEquals((long)25L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 0L, 39L, 20L, 59L), (String)"False negative for an overlapping but diverging tier state");
        this.cache().clearAndFlush();
        this.cache().assign(2, 20L);
        this.cache().assign(3, 35L);
        this.cache().assign(4, 40L);
        this.cache().assign(5, 50L);
        Assertions.assertEquals((long)30L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 0L, 39L, 20L, 59L), (String)"False negative for an overlapping but diverging tier state");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(1, 10L), (List)new .colon.colon((Object)new EpochEntry(2, 20L), (List)new .colon.colon((Object)new EpochEntry(3, 30L), (List)Nil$.MODULE$)));
        this.cache().clearAndFlush();
        this.cache().assign(1, 5L);
        this.cache().assign(2, 20L);
        this.cache().assign(3, 30L);
        Assertions.assertEquals((long)5L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 10L, 39L, 5L, 39L), (String)"False negative when first local epoch has offset lower than tiered offset for the same epoch");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)new .colon.colon((Object)new EpochEntry(1, 10L), (List)new .colon.colon((Object)new EpochEntry(2, 20L), (List)new .colon.colon((Object)new EpochEntry(3, 30L), (List)Nil$.MODULE$))));
        this.cache().clearAndFlush();
        this.cache().assign(3, 25L);
        this.cache().assign(4, 40L);
        this.cache().assign(5, 50L);
        Assertions.assertEquals((long)20L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 0L, 39L, 25L, 59L), (String)"False negative when local cache misses an epoch but includes the corresponding offset");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(3, 30L), (List)new .colon.colon((Object)new EpochEntry(4, 40L), (List)new .colon.colon((Object)new EpochEntry(5, 50L), (List)Nil$.MODULE$)));
        this.cache().clearAndFlush();
        this.cache().assign(2, 20L);
        this.cache().assign(3, 35L);
        this.cache().assign(4, 40L);
        Assertions.assertEquals((long)30L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 30L, 59L, 20L, 49L), (String)"False negative when divergence at first matching epoch but it is not the first local epoch");
        this.cache().clearAndFlush();
        this.cache().assign(2, 20L);
        this.cache().assign(3, 25L);
        this.cache().assign(4, 40L);
        Assertions.assertEquals((long)25L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 30L, 59L, 20L, 49L), (String)"False negative when divergence at first matching epoch but it is not the first local epoch");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(5, 50L), (List)new .colon.colon((Object)new EpochEntry(6, 60L), (List)new .colon.colon((Object)new EpochEntry(7, 70L), (List)Nil$.MODULE$)));
        this.cache().clearAndFlush();
        this.cache().assign(2, 60L);
        this.cache().assign(3, 70L);
        this.cache().assign(4, 80L);
        Assertions.assertEquals((long)60L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 50L, 79L, 60L, 89L), (String)"False negative when offsets at tieredEpochState and localCache do not increase monotonically");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(1, 100L), (List)new .colon.colon((Object)new EpochEntry(2, 150L), (List)Nil$.MODULE$));
        this.cache().clearAndFlush();
        this.cache().assign(1, 100L);
        Assertions.assertEquals((long)150L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 100L, 179L, 100L, 199L), (String)"False negative when localCache is missing an epoch but the corresponding offsets are written to by a different epoch");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)new .colon.colon((Object)new EpochEntry(1, 100L), (List)Nil$.MODULE$));
        this.cache().clearAndFlush();
        this.cache().assign(0, 50L);
        this.cache().assign(1, 75L);
        Assertions.assertEquals((long)75L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 0L, 199L, 50L, 199L), (String)"False negative when end offset for start epoch mismatches");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)new .colon.colon((Object)new EpochEntry(1, 100L), (List)Nil$.MODULE$));
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        Assertions.assertEquals((long)100L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 0L, 149L, 0L, 149L), (String)"False negative when end offset for an epoch mismatches");
        tieredEpochState = new .colon.colon((Object)new EpochEntry(0, 0L), (List)Nil$.MODULE$);
        this.cache().clearAndFlush();
        this.cache().assign(0, 0L);
        this.cache().assign(1, 50L);
        Assertions.assertEquals((long)50L, (long)this.cache().findDivergenceInEpochCache((List)tieredEpochState, 0L, 99L, 0L, 199L), (String)"False negative when end offset for an epoch mismatches");
    }

    public static final /* synthetic */ void $anonfun$testTruncateFromStartWithNoFlush$1(LeaderEpochFileCacheTest $this, EpochEntry epoch) {
        $this.cache().assign(epoch.epoch(), epoch.startOffset());
    }

    public static final /* synthetic */ void $anonfun$shouldClearAllEntries$1(LeaderEpochFileCacheTest $this, EpochEntry epoch) {
        $this.cache().assign(epoch.epoch(), epoch.startOffset());
    }
}

