/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.server.link.ClusterLinkAutoMirroring;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.LinkMode;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Metrics;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t5g\u0001\u0002#F\u00011CQa\u0015\u0001\u0005\u0002QCqa\u0016\u0001C\u0002\u0013%\u0001\f\u0003\u0004g\u0001\u0001\u0006I!\u0017\u0005\bO\u0002\u0011\r\u0011\"\u0003i\u0011\u0019a\u0007\u0001)A\u0005S\"9Q\u000e\u0001b\u0001\n\u0013q\u0007BB;\u0001A\u0003%q\u000eC\u0004s\u0001\t\u0007I\u0011\u0002<\t\ri\u0004\u0001\u0015!\u0003x\u0011\u001dY\bA1A\u0005\nqDq!!\u0001\u0001A\u0003%Q\u0010C\u0005\u0002\u0004\u0001\u0011\r\u0011\"\u0003\u0002\u0006!A\u0011Q\u0004\u0001!\u0002\u0013\t9\u0001C\u0005\u0002 \u0001\u0011\r\u0011\"\u0003\u0002\"!A\u00111\u0007\u0001!\u0002\u0013\t\u0019\u0003C\u0005\u00026\u0001\u0011\r\u0011\"\u0003\u00028!A\u0011Q\t\u0001!\u0002\u0013\tI\u0004C\u0005\u0002H\u0001\u0011\r\u0011\"\u0003\u0002J!A\u0011q\u000b\u0001!\u0002\u0013\tY\u0005C\u0005\u0002Z\u0001\u0011\r\u0011\"\u0003\u0002\\!A\u00111\r\u0001!\u0002\u0013\ti\u0006C\u0005\u0002f\u0001\u0011\r\u0011\"\u0003\u0002h!A\u0011q\u000e\u0001!\u0002\u0013\tI\u0007C\u0005\u0002r\u0001\u0011\r\u0011\"\u0003\u0002t!A\u0011Q\u0012\u0001!\u0002\u0013\t)\bC\u0005\u0002\u0010\u0002\u0011\r\u0011\"\u0003\u0002t!A\u0011\u0011\u0013\u0001!\u0002\u0013\t)\bC\u0004\u0002\u0014\u0002!\t!!&\t\u000f\u0005M\u0006\u0001\"\u0001\u0002\u0016\"9\u0011Q\u0018\u0001\u0005\n\u0005U\u0005bBA`\u0001\u0011%\u0011Q\u0013\u0005\b\u0003\u0003\u0004A\u0011BAK\u0011\u001d\t\u0019\r\u0001C\u0005\u0003\u000bDq!a6\u0001\t\u0013\tI\u000eC\u0004\u0002l\u0002!I!!<\t\u0013\t\u001d\u0001!%A\u0005\n\t%\u0001b\u0002B\u0010\u0001\u0011%!\u0011\u0005\u0005\n\u0005[\u0001\u0011\u0013!C\u0005\u0005\u0013AqAa\f\u0001\t\u0013\u0011\t\u0004C\u0005\u0003B\u0001\t\n\u0011\"\u0003\u0003\n!9!1\t\u0001\u0005\n\t\u0015\u0003b\u0002B&\u0001\u0011%!Q\n\u0005\b\u0005?\u0002A\u0011\u0002B1\u0011%\u0011Y\u0007AI\u0001\n\u0013\u0011I\u0001C\u0005\u0003n\u0001\t\n\u0011\"\u0003\u0003\n!9!q\u000e\u0001\u0005\u0002\u0005U\u0005b\u0002B=\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0005{\u0002A\u0011AAK\u0011\u001d\u0011\t\t\u0001C\u0001\u0003+CqA!\"\u0001\t\u0003\t)\nC\u0004\u0003\n\u0002!\t!!&\t\u000f\t5\u0005\u0001\"\u0001\u0002\u0016\"9!\u0011\u0013\u0001\u0005\u0002\u0005U\u0005b\u0002BK\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u00053\u0003A\u0011AAK\u0011\u001d\u0011i\n\u0001C\u0001\u0003+CqA!)\u0001\t\u0003\t)\nC\u0004\u0003&\u0002!\t!!&\t\u000f\t%\u0006\u0001\"\u0001\u0002\u0016\"9!Q\u0016\u0001\u0005\u0002\u0005U\u0005b\u0002BY\u0001\u0011\u0005\u0011Q\u0013\u0005\b\u0005k\u0003A\u0011AAK\u0011\u001d\u0011I\f\u0001C\u0001\u0003+CqA!0\u0001\t\u0003\t)\nC\u0004\u0003B\u0002!\t!!&\t\u000f\t\u0015\u0007\u0001\"\u0001\u0002\u0016\"9!\u0011\u001a\u0001\u0005\u0002\u0005U%\u0001H\"mkN$XM\u001d'j].\fU\u000f^8NSJ\u0014xN]5oOR+7\u000f\u001e\u0006\u0003\r\u001e\u000bA\u0001\\5oW*\u0011\u0001*S\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003)\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u001bB\u0011a*U\u0007\u0002\u001f*\t\u0001+A\u0003tG\u0006d\u0017-\u0003\u0002S\u001f\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A+\u0011\u0005Y\u0003Q\"A#\u0002\u0017M|WO]2f\u0003\u0012l\u0017N\\\u000b\u00023B\u0011!\fZ\u0007\u00027*\u0011A,X\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003=~\u000bqa\u00197jK:$8O\u0003\u0002KA*\u0011\u0011MY\u0001\u0007CB\f7\r[3\u000b\u0003\r\f1a\u001c:h\u0013\t)7L\u0001\bD_:4G.^3oi\u0006#W.\u001b8\u0002\u0019M|WO]2f\u0003\u0012l\u0017N\u001c\u0011\u0002\u0013\u0011,7\u000f^!e[&tW#A5\u0011\u0005iS\u0017BA6\\\u0005\u0015\tE-\\5o\u0003)!Wm\u001d;BI6Lg\u000eI\u0001\u0012G>tGO]8mY\u0016\u00148i\u001c8uKb$X#A8\u0011\u0005A\u001cX\"A9\u000b\u0005IL\u0015AC2p]R\u0014x\u000e\u001c7fe&\u0011A/\u001d\u0002\u0012\u0007>tGO]8mY\u0016\u00148i\u001c8uKb$\u0018AE2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yi\u0002*\u0012a\u001e\t\u0003abL!!_9\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJ\f1bY8oiJ|G\u000e\\3sA\u0005i1\r\\5f]Rl\u0015M\\1hKJ,\u0012! \t\u0003-zL!a`#\u00031\rcWo\u001d;fe2Kgn[\"mS\u0016tG/T1oC\u001e,'/\u0001\bdY&,g\u000e^'b]\u0006<WM\u001d\u0011\u0002!%t7\r\\;eK\u0006cGNR5mi\u0016\u0014XCAA\u0004!\u0011\tI!a\u0006\u000f\t\u0005-\u00111\u0003\t\u0004\u0003\u001byUBAA\b\u0015\r\t\tbS\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005Uq*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00033\tYB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003+y\u0015!E5oG2,H-Z!mY\u001aKG\u000e^3sA\u00051A.\u001b8l\u0013\u0012,\"!a\t\u0011\t\u0005\u0015\u0012qF\u0007\u0003\u0003OQA!!\u000b\u0002,\u0005!Q\u000f^5m\u0015\t\ti#\u0001\u0003kCZ\f\u0017\u0002BA\u0019\u0003O\u0011A!V+J\t\u00069A.\u001b8l\u0013\u0012\u0004\u0013!D:pkJ\u001cW\rV8qS\u000eLE-\u0006\u0002\u0002:A!\u00111HA!\u001b\t\tiDC\u0002\u0002@}\u000baaY8n[>t\u0017\u0002BA\"\u0003{\u0011A!V;jI\u0006q1o\\;sG\u0016$v\u000e]5d\u0013\u0012\u0004\u0013\u0001\u00037j].$\u0015\r^1\u0016\u0005\u0005-\u0003\u0003BA'\u0003'j!!a\u0014\u000b\u0007\u0005E\u0013*\u0001\u0002{W&!\u0011QKA(\u0005=\u0019E.^:uKJd\u0015N\\6ECR\f\u0017!\u00037j].$\u0015\r^1!\u0003\u001diW\r\u001e:jGN,\"!!\u0018\u0011\u0007Y\u000by&C\u0002\u0002b\u0015\u0013!c\u00117vgR,'\u000fT5oW6+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%A\u0005tG\",G-\u001e7feV\u0011\u0011\u0011\u000e\t\u0004-\u0006-\u0014bAA7\u000b\n!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003Q!x\u000e]5d\u000bbL7\u000f^:Fq\u000e,\u0007\u000f^5p]V\u0011\u0011Q\u000f\t\u0006\u001d\u0006]\u00141P\u0005\u0004\u0003sz%AB(qi&|g\u000e\u0005\u0003\u0002~\u0005\u001de\u0002BA@\u0003\u0007sA!!\u0004\u0002\u0002&\t\u0001+C\u0002\u0002\u0006>\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002\n\u0006-%!\u0003+ie><\u0018M\u00197f\u0015\r\t)iT\u0001\u0016i>\u0004\u0018nY#ySN$8/\u0012=dKB$\u0018n\u001c8!\u0003Y\tW\u000f\u001e5pe&T\u0018\r^5p]\u0016C8-\u001a9uS>t\u0017aF1vi\"|'/\u001b>bi&|g.\u0012=dKB$\u0018n\u001c8!\u0003\u0015\u0019X\r^+q)\t\t9\nE\u0002O\u00033K1!a'P\u0005\u0011)f.\u001b;)\u0007q\ty\n\u0005\u0003\u0002\"\u0006=VBAAR\u0015\u0011\t)+a*\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002*\u0006-\u0016a\u00026va&$XM\u001d\u0006\u0004\u0003[\u0013\u0017!\u00026v]&$\u0018\u0002BAY\u0003G\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007fA\u000f\u00028B!\u0011\u0011UA]\u0013\u0011\tY,a)\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017!\u0003:fg\u0016$Xj\\2l\u0003%\u0019X\r^;q\u001b>\u001c7.\u0001\u0006wKJLg-_'pG.\fQ#\\5se>\u0014Hk\u001c9jGN\fe\u000e\u001a,fe&4\u0017\u0010\u0006\u0003\u0002H\u00065\u0007c\u0001,\u0002J&\u0019\u00111Z#\u00031\rcWo\u001d;fe2Kgn[!vi>l\u0015N\u001d:pe&tw\rC\u0004\u0002P\u0006\u0002\r!!5\u0002#\rdWo\u001d;fe2Kgn[\"p]\u001aLw\rE\u0002W\u0003'L1!!6F\u0005E\u0019E.^:uKJd\u0015N\\6D_:4\u0017nZ\u0001\u0011[>\u001c7n\u0011:fCR,Gk\u001c9jGN$B!a7\u0002bB\u0019!,!8\n\u0007\u0005}7L\u0001\nDe\u0016\fG/\u001a+pa&\u001c7OU3tk2$\bbBArE\u0001\u0007\u0011Q]\u0001\u000bi>\u0004\u0018nY:U_\u0016C\b\u0003CA\u0005\u0003O\f9!!\u001e\n\t\u0005%\u00181\u0004\u0002\u0004\u001b\u0006\u0004\u0018AG7pG.\u001c%/Z1uKR{\u0007/[2t'\u0006lWMU3tk2$HCBAn\u0003_\u0014\u0019\u0001C\u0004\u0002r\u000e\u0002\r!a=\u0002\rQ|\u0007/[2t!\u0019\t)0a@\u0002\b5\u0011\u0011q\u001f\u0006\u0005\u0003s\fY0A\u0004nkR\f'\r\\3\u000b\u0007\u0005ux*\u0001\u0006d_2dWm\u0019;j_:LAA!\u0001\u0002x\n\u00191+\u001a;\t\u0013\t\u00151\u0005%AA\u0002\u0005U\u0014AA3y\u0003\u0011jwnY6De\u0016\fG/\u001a+pa&\u001c7oU1nKJ+7/\u001e7uI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u0006U\u0011\t)H!\u0004,\u0005\t=\u0001\u0003\u0002B\t\u00057i!Aa\u0005\u000b\t\tU!qC\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!\u0007P\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005;\u0011\u0019BA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001$\\8dW:{\u0017J\u001c;fe:\fG\u000eT5tiR{\u0007/[2t)\u0019\u0011\u0019C!\u000b\u0003,A\u0019!L!\n\n\u0007\t\u001d2L\u0001\tMSN$Hk\u001c9jGN\u0014Vm];mi\"9\u0011\u0011_\u0013A\u0002\u0005M\b\"\u0003B\u0003KA\u0005\t\u0019AA;\u0003\tjwnY6O_&sG/\u001a:oC2d\u0015n\u001d;U_BL7m\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005qQn\\2l\u0019&\u001cH\u000fV8qS\u000e\u001cHC\u0002B\u0012\u0005g\u0011y\u0004C\u0004\u00036\u001d\u0002\rAa\u000e\u0002\u001f9\fW.Z:U_2K7\u000f^5oON\u0004\u0002\"!\u0003\u0002h\u0006\u001d!\u0011\b\t\u00045\nm\u0012b\u0001B\u001f7\naAk\u001c9jG2K7\u000f^5oO\"I!QA\u0014\u0011\u0002\u0003\u0007\u0011QO\u0001\u0019[>\u001c7\u000eT5tiR{\u0007/[2tI\u0011,g-Y;mi\u0012\u0012\u0014AB2p]\u001aLw\r\u0006\u0003\u0002R\n\u001d\u0003b\u0002B%S\u0001\u0007\u0011qA\u0001\fi>\u0004\u0018n\u0019$jYR,'/\u0001\tuKN$X*\u001b:s_J$v\u000e]5dgRQ\u0011q\u0013B(\u0005'\u00129Fa\u0017\t\u000f\tE#\u00061\u0001\u0002t\u0006a1o\\;sG\u0016$v\u000e]5dg\"9!Q\u000b\u0016A\u0002\u0005M\u0018A\u00033fgR$v\u000e]5dg\"9!\u0011\f\u0016A\u0002\u0005M\u0018aD3ya\u0016\u001cG/\u001a3NSJ\u0014xN]:\t\u000f\tu#\u00061\u0001\u0002\b\u00051a-\u001b7uKJ\f\u0011\u0004^3ti6K'O]8s)>\u0004\u0018nY:Fq\u000e,\u0007\u000f^5p]R1\u0011q\u0013B2\u0005OB\u0011B!\u001a,!\u0003\u0005\r!!\u001e\u0002+\r\u0014X-\u0019;f)>\u0004\u0018nY:Fq\u000e,\u0007\u000f^5p]\"I!\u0011N\u0016\u0011\u0002\u0003\u0007\u0011QO\u0001\u0014Y&\u001cH\u000fV8qS\u000e\u001cX\t_2faRLwN\\\u0001$i\u0016\u001cH/T5se>\u0014Hk\u001c9jGN,\u0005pY3qi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00132\u0003\r\"Xm\u001d;NSJ\u0014xN\u001d+pa&\u001c7/\u0012=dKB$\u0018n\u001c8%I\u00164\u0017-\u001e7uII\n!\u0003^3ti6K'O]8s\u001f:,Gk\u001c9jG\"\u001aaFa\u001d\u0011\t\u0005\u0005&QO\u0005\u0005\u0005o\n\u0019K\u0001\u0003UKN$\u0018a\b;fgRtun\u0011:fCR,Gk\u001c9jGNLe\rV8qS\u000e,\u00050[:ug\"\u001aqFa\u001d\u00021Q,7\u000f^%oG2,H-\u001a'ji\u0016\u0014\u0018\r\u001c$jYR,'\u000fK\u00021\u0005g\n\u0011\u0004^3ti&s7\r\\;eKB\u0013XMZ5yK\u00124\u0015\u000e\u001c;fe\"\u001a\u0011Ga\u001d\u00021Q,7\u000f^#yG2,H-\u001a'ji\u0016\u0014\u0018\r\u001c$jYR,'\u000fK\u00023\u0005g\n\u0011\u0004^3ti\u0016C8\r\\;eKB\u0013XMZ5yK\u00124\u0015\u000e\u001c;fe\"\u001a1Ga\u001d\u0002%Q,7\u000f\u001e\"bi\u000eDW*\u001b:s_JLgn\u001a\u0015\u0004i\tM\u0014a\u0007;fgRd\u0015n\u001d;U_BL7m]!vi\",\u0005pY3qi&|g\u000eK\u00026\u0005g\nQ\u0004^3ti\u000e\u0013X-\u0019;f)>\u0004\u0018nY:BkRDW\t_2faRLwN\u001c\u0015\u0004m\tM\u0014a\b;fgR\u001c%/Z1uKR{\u0007/[2t\u000bbL7\u000f^:Fq\u000e,\u0007\u000f^5p]\"\u001aqGa\u001d\u00027Q,7\u000f\u001e#fgRd\u0015n\u001d;U_BL7m]#yG\u0016\u0004H/[8oQ\rA$1O\u0001\u0016i\u0016\u001cH/R7qif$v\u000e]5d\r&dG/\u001a:tQ\rI$1O\u0001\u001di\u0016\u001cHOU3nSJ\u0014xN\u001d#fY\u0016$X\r\u001a#fgR$v\u000e]5dQ\rQ$1O\u0001\u0019i\u0016\u001cH/T5se>\u0014h*Z<T_V\u00148-\u001a+pa&\u001c\u0007fA\u001e\u0003t\u0005!B/Z:u\u0003\u0012$\u0017J\\2mk\u0012,g)\u001b7uKJD3\u0001\u0010B:\u0003]!Xm\u001d;EK2,G/Z#yG2,H-\u001a$jYR,'\u000fK\u0002>\u0005g\nq\u0003^3ti\u0012+G.\u001a;f\u0013:\u001cG.\u001e3f\r&dG/\u001a:)\u0007y\u0012\u0019(A\u0018uKN$hj\u001c#va2L7-\u0019;f\u0007J,\u0017\r^3U_BL7m]\"bY24uN]#ySN$\u0018N\\4U_BL7\rK\u0002@\u0005g\n!\u0007^3tiR{\u0007/[2DC:\u0014Um\u0011:fCR,G-\u00114uKJ\u001cuN\u001c4mS\u000e$\u0018N\\4U_BL7\rR3mKRLwN\u001c\u0015\u0004\u0001\nM\u0014A\n;fgRtun\u0011:fCR,Gk\u001c9jGN\u001c\u0015\r\u001c7G_JLe\u000e^3s]\u0006dGk\u001c9jG\"\u001a\u0011Ia\u001d\u0002=Q,7\u000f^\"p]\u001ad\u0017n\u0019;j]\u001e$Um\u001d;DC\u000eDWMV1mk\u0016\u001c\bf\u0001\"\u0003t\u0005IC/Z:u\u001d>\u001c%/Z1uKR{\u0007/[2XSRD\u0017J\\1di&4X-T5se>\u0014Hk\u001c9jGND3a\u0011B:\u0001")
public class ClusterLinkAutoMirroringTest {
    private final ConfluentAdmin sourceAdmin = (ConfluentAdmin)EasyMock.mock(ConfluentAdmin.class);
    private final Admin destAdmin = (Admin)EasyMock.mock(Admin.class);
    private final ControllerContext controllerContext = (ControllerContext)EasyMock.mock(ControllerContext.class);
    private final KafkaController controller = (KafkaController)EasyMock.mock(KafkaController.class);
    private final ClusterLinkClientManager clientManager = (ClusterLinkClientManager)EasyMock.mock(ClusterLinkClientManager.class);
    private final String includeAllFilter;
    private final UUID linkId = UUID.randomUUID();
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final ClusterLinkData linkData = new ClusterLinkData("testLink", this.linkId(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
    private final ClusterLinkMetrics metrics = new ClusterLinkMetrics("test-link", this.linkId(), (LinkMode)LinkMode.Destination$.MODULE$, (ClusterLinkManager)EasyMock.mock(ClusterLinkManager.class), (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$);
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final Option<Throwable> topicExistsException = new Some((Object)new TopicExistsException(""));
    private final Option<Throwable> authorizationException = new Some((Object)new AuthorizationException(""));

    private ConfluentAdmin sourceAdmin() {
        return this.sourceAdmin;
    }

    private Admin destAdmin() {
        return this.destAdmin;
    }

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private ClusterLinkClientManager clientManager() {
        return this.clientManager;
    }

    private String includeAllFilter() {
        return this.includeAllFilter;
    }

    private UUID linkId() {
        return this.linkId;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private ClusterLinkData linkData() {
        return this.linkData;
    }

    private ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private Option<Throwable> topicExistsException() {
        return this.topicExistsException;
    }

    private Option<Throwable> authorizationException() {
        return this.authorizationException;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
        this.metrics().startup();
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
        this.metrics().shutdown();
    }

    private void resetMock() {
        EasyMock.reset((Object[])new Object[]{this.sourceAdmin()});
        EasyMock.reset((Object[])new Object[]{this.destAdmin()});
        EasyMock.reset((Object[])new Object[]{this.controller()});
        EasyMock.reset((Object[])new Object[]{this.clientManager()});
        EasyMock.reset((Object[])new Object[]{this.controllerContext()});
    }

    private void setupMock() {
        this.resetMock();
        EasyMock.expect((Object)this.clientManager().scheduler()).andReturn((Object)this.scheduler()).anyTimes();
        EasyMock.expect((Object)this.clientManager().getAdmin()).andReturn((Object)this.sourceAdmin()).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        EasyMock.expect((Object)this.controller().controllerContext()).andReturn((Object)this.controllerContext()).anyTimes();
        EasyMock.expect((Object)this.controllerContext().linkedTopics()).andReturn(CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.controller(), this.controllerContext()});
    }

    private void verifyMock() {
        EasyMock.verify((Object[])new Object[]{this.clientManager()});
        EasyMock.verify((Object[])new Object[]{this.sourceAdmin()});
        EasyMock.verify((Object[])new Object[]{this.controller()});
        EasyMock.verify((Object[])new Object[]{this.controllerContext()});
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkAutoMirroring mirrorTopicsAndVerify(ClusterLinkConfig clusterLinkConfig) {
        void var2_2;
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)clusterLinkConfig).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager(), this.sourceAdmin(), this.destAdmin()});
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.linkData(), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        return var2_2;
    }

    private CreateTopicsResult mockCreateTopics(scala.collection.immutable.Map<String, Option<Throwable>> topicsToEx) {
        HashMap futures = new HashMap();
        KafkaFutureImpl allFuture = new KafkaFutureImpl();
        IntRef numExceptions = IntRef.create((int)0);
        topicsToEx.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            KafkaFutureImpl future;
            String topicName;
            if (x0$1 != null) {
                topicName = (String)x0$1._1();
                Option ex = (Option)x0$1._2();
                future = new KafkaFutureImpl();
                if (ex instanceof Some) {
                    Throwable e = (Throwable)((Some)ex).value();
                    future.completeExceptionally(e);
                    ++numExceptions$1.elem;
                } else {
                    future.complete((Object)new CreateTopicsResult.TopicMetadataAndConfig(Uuid.randomUuid(), 1, 1, new Config(Collections.emptyList())));
                }
            } else {
                throw new MatchError(null);
            }
            KafkaFuture kafkaFuture = (KafkaFuture)futures.put(topicName, future);
            return kafkaFuture;
        });
        if (numExceptions.elem > 0) {
            allFuture.completeExceptionally((Throwable)((Option)((Tuple2)topicsToEx.head())._2()).get());
        } else {
            allFuture.complete(null);
        }
        CreateTopicsResult result = (CreateTopicsResult)EasyMock.mock(CreateTopicsResult.class);
        EasyMock.expect((Object)result.values()).andReturn(futures).anyTimes();
        EasyMock.expect((Object)result.all()).andReturn((Object)allFuture).anyTimes();
        EasyMock.replay((Object[])new Object[]{result});
        return result;
    }

    private CreateTopicsResult mockCreateTopicsSameResult(Set<String> topics, Option<Throwable> ex) {
        return this.mockCreateTopics((scala.collection.immutable.Map<String, Option<Throwable>>)((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)ex), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    private Option<Throwable> mockCreateTopicsSameResult$default$2() {
        return Option$.MODULE$.empty();
    }

    private ListTopicsResult mockNoInternalListTopics(Set<String> topics, Option<Throwable> ex) {
        scala.collection.immutable.Map namesToListings = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)topicName -> new Tuple2(topicName, (Object)new TopicListing(topicName, false)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return this.mockListTopics((scala.collection.immutable.Map<String, TopicListing>)namesToListings, ex);
    }

    private Option<Throwable> mockNoInternalListTopics$default$2() {
        return Option$.MODULE$.empty();
    }

    private ListTopicsResult mockListTopics(scala.collection.immutable.Map<String, TopicListing> namesToListings, Option<Throwable> ex) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        if (ex instanceof Some) {
            Throwable e = (Throwable)((Some)ex).value();
            future.completeExceptionally(e);
        } else {
            future.complete(CollectionConverters$.MODULE$.mapAsJavaMapConverter(namesToListings).asJava());
        }
        ListTopicsResult result = (ListTopicsResult)EasyMock.mock(ListTopicsResult.class);
        EasyMock.expect((Object)result.namesToListings()).andReturn((Object)future).anyTimes();
        KafkaFutureImpl namesFuture = new KafkaFutureImpl();
        namesFuture.complete(((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(namesToListings).asJava()).keySet());
        EasyMock.expect((Object)result.names()).andReturn((Object)namesFuture).anyTimes();
        EasyMock.replay((Object[])new Object[]{result});
        return result;
    }

    private Option<Throwable> mockListTopics$default$2() {
        return Option$.MODULE$.empty();
    }

    private ClusterLinkConfig config(String topicFilter) {
        return ClusterLinkConfig$.MODULE$.create((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.TopicFiltersProp()), (Object)topicFilter)}))).asJava());
    }

    private void testMirrorTopics(Set<String> sourceTopics, Set<String> destTopics, Set<String> expectedMirrors, String filter) {
        this.setupMock();
        EasyMock.expect((Object)this.sourceAdmin().listTopics()).andReturn((Object)this.mockNoInternalListTopics(sourceTopics, this.mockNoInternalListTopics$default$2())).anyTimes();
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn(destTopics).anyTimes();
        if (expectedMirrors.nonEmpty()) {
            expectedMirrors.grouped(100).foreach((Function1 & Serializable & scala.Serializable)expectedMirrorBatch -> EasyMock.expect((Object)this.destAdmin().createTopics((Collection)EasyMock.anyObject())).andReturn((Object)this.mockCreateTopicsSameResult((Set<String>)expectedMirrorBatch, this.mockCreateTopicsSameResult$default$2())).once());
        }
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = this.mirrorTopicsAndVerify(this.config(filter));
        Assertions.assertEquals(expectedMirrors, (Object)clusterLinkAutoMirroring.getMirrorTopics());
    }

    private void testMirrorTopicsException(Option<Throwable> createTopicsException, Option<Throwable> listTopicsException) {
        this.setupMock();
        Set sampleSet = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set emptySet = Set$.MODULE$.empty();
        EasyMock.expect((Object)this.sourceAdmin().listTopics()).andReturn((Object)this.mockNoInternalListTopics((Set<String>)sampleSet, listTopicsException)).once();
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)emptySet).anyTimes();
        EasyMock.expect((Object)this.destAdmin().createTopics((Collection)EasyMock.anyObject())).andReturn((Object)this.mockCreateTopicsSameResult((Set<String>)sampleSet, createTopicsException)).anyTimes();
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = this.mirrorTopicsAndVerify(this.config(this.includeAllFilter()));
        Assertions.assertEquals((Object)emptySet, (Object)clusterLinkAutoMirroring.getMirrorTopics());
    }

    private Option<Throwable> testMirrorTopicsException$default$1() {
        return Option$.MODULE$.empty();
    }

    private Option<Throwable> testMirrorTopicsException$default$2() {
        return Option$.MODULE$.empty();
    }

    @Test
    public void testMirrorOneTopic() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set destTopics = Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, this.includeAllFilter());
    }

    @Test
    public void testNoCreateTopicsIfTopicExists() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set destTopics = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set expectedMirrors = Set$.MODULE$.empty();
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, this.includeAllFilter());
    }

    @Test
    public void testIncludeLiteralFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "exclude-topic"}));
        Set destTopics = Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}));
        String filter = "{\"topicFilters\":[{\"name\":\"include-topic\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"}]}";
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, filter);
    }

    @Test
    public void testIncludePrefixedFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "exclude-topic"}));
        Set destTopics = Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}));
        String filter = "{\"topicFilters\":[{\"name\":\"include\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, filter);
    }

    @Test
    public void testExcludeLiteralFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "exclude-topic"}));
        Set destTopics = Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}));
        String filter = "{\"topicFilters\":[{\"name\":\"*\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"},{\"name\":\"exclude-topic\",\"filterType\":\"EXCLUDE\",\"patternType\":\"LITERAL\"}]}";
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, filter);
    }

    @Test
    public void testExcludePrefixedFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "exclude-topic"}));
        Set destTopics = Set$.MODULE$.empty();
        Set expectedMirrors = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}));
        String filter = "{\"topicFilters\":[{\"name\":\"*\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"},{\"name\":\"exclude\",\"filterType\":\"EXCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, filter);
    }

    @Test
    public void testBatchMirroring() {
        Set sourceTopics = Set$.MODULE$.empty();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> sourceTopics.add((Object)new StringBuilder(6).append("topic-").append(i).toString()));
        Set destTopics = Set$.MODULE$.empty();
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)sourceTopics, this.includeAllFilter());
    }

    @Test
    public void testListTopicsAuthException() {
        Option<Throwable> x$1 = this.authorizationException();
        Option<Throwable> x$2 = this.testMirrorTopicsException$default$1();
        this.testMirrorTopicsException(x$2, x$1);
    }

    @Test
    public void testCreateTopicsAuthException() {
        this.testMirrorTopicsException(this.authorizationException(), this.testMirrorTopicsException$default$2());
    }

    @Test
    public void testCreateTopicsExistsException() {
        this.testMirrorTopicsException(this.topicExistsException(), this.testMirrorTopicsException$default$2());
    }

    @Test
    public void testDestListTopicsException() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set destTopics = Set$.MODULE$.empty();
        this.setupMock();
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)this.config(this.includeAllFilter())).anyTimes();
        EasyMock.expect((Object)this.sourceAdmin().listTopics()).andReturn((Object)this.mockNoInternalListTopics((Set<String>)sourceTopics, this.mockNoInternalListTopics$default$2())).anyTimes();
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)destTopics).anyTimes();
        EasyMock.expect((Object)this.destAdmin().createTopics((Collection)EasyMock.anyObject())).andReturn((Object)this.mockCreateTopicsSameResult((Set<String>)sourceTopics, this.topicExistsException())).times(2);
        EasyMock.expect((Object)this.destAdmin().listTopics()).andReturn((Object)this.mockNoInternalListTopics((Set<String>)sourceTopics, this.authorizationException())).once();
        EasyMock.replay((Object[])new Object[]{this.clientManager(), this.sourceAdmin(), this.destAdmin()});
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.linkData(), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        this.verifyMock();
    }

    @Test
    public void testEmptyTopicFilters() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set destTopics = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set expectedMirrors = Set$.MODULE$.empty();
        String filter = "";
        this.testMirrorTopics((Set<String>)sourceTopics, (Set<String>)destTopics, (Set<String>)expectedMirrors, filter);
    }

    @Test
    public void testRemirrorDeletedDestTopic() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set destTopics = Set$.MODULE$.empty();
        this.setupMock();
        EasyMock.expect((Object)this.sourceAdmin().listTopics()).andReturn((Object)this.mockNoInternalListTopics((Set<String>)sourceTopics, this.mockNoInternalListTopics$default$2())).times(2);
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)destTopics).times(2);
        EasyMock.expect((Object)this.destAdmin().createTopics((Collection)EasyMock.anyObject())).andReturn((Object)this.mockCreateTopicsSameResult((Set<String>)sourceTopics, this.mockCreateTopicsSameResult$default$2())).times(2);
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)this.config(this.includeAllFilter())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager(), this.sourceAdmin(), this.destAdmin()});
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.linkData(), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        this.verifyMock();
    }

    @Test
    public void testMirrorNewSourceTopic() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set sourceTopicsNew = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic", "test-topic-2"}));
        Set destTopics = Set$.MODULE$.empty();
        Set destTopicsNew = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        this.setupMock();
        EasyMock.expect((Object)this.sourceAdmin().listTopics()).andReturn((Object)this.mockNoInternalListTopics((Set<String>)sourceTopics, this.mockNoInternalListTopics$default$2())).once().andReturn((Object)this.mockNoInternalListTopics((Set<String>)sourceTopicsNew, this.mockNoInternalListTopics$default$2())).once();
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)destTopics).once().andReturn((Object)destTopicsNew).once();
        EasyMock.expect((Object)this.destAdmin().createTopics((Collection)EasyMock.anyObject())).andReturn((Object)this.mockCreateTopicsSameResult((Set<String>)sourceTopics, this.mockCreateTopicsSameResult$default$2())).once().andReturn((Object)this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-2"}))), this.mockCreateTopicsSameResult$default$2())).once();
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)this.config(this.includeAllFilter())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager(), this.sourceAdmin(), this.destAdmin()});
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.linkData(), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-2"})), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        this.verifyMock();
    }

    @Test
    public void testAddIncludeFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"old-topic", "new-topic"}));
        Set destTopics = Set$.MODULE$.empty();
        Set destTopicsNew = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"old-topic"}));
        String filterOne = "{\"topicFilters\":[{\"name\":\"old\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        String filterTwo = "{\"topicFilters\":[{\"name\":\"old\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"},{\"name\":\"new\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        this.setupMock();
        EasyMock.expect((Object)this.sourceAdmin().listTopics()).andReturn((Object)this.mockNoInternalListTopics((Set<String>)sourceTopics, this.mockNoInternalListTopics$default$2())).times(2);
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)destTopics).once().andReturn((Object)destTopicsNew).once();
        EasyMock.expect((Object)this.destAdmin().createTopics((Collection)EasyMock.anyObject())).andReturn((Object)this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"old-topic"}))), this.mockCreateTopicsSameResult$default$2())).once().andReturn((Object)this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"new-topic"}))), this.mockCreateTopicsSameResult$default$2())).once();
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)this.config(filterOne)).times(2).andReturn((Object)this.config(filterTwo)).times(2);
        EasyMock.replay((Object[])new Object[]{this.clientManager(), this.sourceAdmin(), this.destAdmin()});
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.linkData(), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)destTopicsNew, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"new-topic"})), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        this.verifyMock();
    }

    @Test
    public void testDeleteExcludeFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "exclude-topic"}));
        Set destTopics = Set$.MODULE$.empty();
        Set destTopicsNew = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}));
        String filterOne = "{\"topicFilters\":[{\"name\":\"*\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"},{\"name\":\"exclude\",\"filterType\":\"EXCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        String filterTwo = "{\"topicFilters\":[{\"name\":\"*\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"}]}";
        this.setupMock();
        EasyMock.expect((Object)this.sourceAdmin().listTopics()).andReturn((Object)this.mockNoInternalListTopics((Set<String>)sourceTopics, this.mockNoInternalListTopics$default$2())).times(2);
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)destTopics).once().andReturn((Object)destTopicsNew).once();
        EasyMock.expect((Object)this.destAdmin().createTopics((Collection)EasyMock.anyObject())).andReturn((Object)this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic"}))), this.mockCreateTopicsSameResult$default$2())).once().andReturn((Object)this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exclude-topic"}))), this.mockCreateTopicsSameResult$default$2())).once();
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)this.config(filterOne)).times(2).andReturn((Object)this.config(filterTwo)).times(2);
        EasyMock.replay((Object[])new Object[]{this.clientManager(), this.sourceAdmin(), this.destAdmin()});
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.linkData(), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)destTopicsNew, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exclude-topic"})), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        this.verifyMock();
    }

    @Test
    public void testDeleteIncludeFilter() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "test-topic-2"}));
        Set sourceTopicsNew = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "test-topic-2", "test-topic-3"}));
        Set destTopics = Set$.MODULE$.empty();
        Set destTopicsNew = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "test-topic-2"}));
        String filterOne = "{\"topicFilters\":[{\"name\":\"test\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"},{\"name\":\"include\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        String filterTwo = "{\"topicFilters\":[{\"name\":\"include\",\"filterType\":\"INCLUDE\",\"patternType\":\"PREFIXED\"}]}";
        this.setupMock();
        EasyMock.expect((Object)this.sourceAdmin().listTopics()).andReturn((Object)this.mockNoInternalListTopics((Set<String>)sourceTopics, this.mockNoInternalListTopics$default$2())).once().andReturn((Object)this.mockNoInternalListTopics((Set<String>)sourceTopicsNew, this.mockNoInternalListTopics$default$2())).once();
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)destTopics).once().andReturn((Object)destTopicsNew).once();
        EasyMock.expect((Object)this.destAdmin().createTopics((Collection)EasyMock.anyObject())).andReturn((Object)this.mockCreateTopicsSameResult((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"include-topic", "test-topic-2"}))), this.mockCreateTopicsSameResult$default$2())).once();
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)this.config(filterOne)).times(2).andReturn((Object)this.config(filterTwo)).times(2);
        EasyMock.replay((Object[])new Object[]{this.clientManager(), this.sourceAdmin(), this.destAdmin()});
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.linkData(), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)destTopicsNew, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        this.verifyMock();
    }

    @Test
    public void testNoDuplicateCreateTopicsCallForExistingTopic() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set destTopics = Set$.MODULE$.empty();
        Set nonMirrorDestTopics = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set expectedMirrors = Set$.MODULE$.empty();
        this.setupMock();
        EasyMock.expect((Object)this.sourceAdmin().listTopics()).andReturn((Object)this.mockNoInternalListTopics((Set<String>)sourceTopics, this.mockNoInternalListTopics$default$2())).anyTimes();
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)destTopics).anyTimes();
        EasyMock.expect((Object)this.destAdmin().createTopics((Collection)EasyMock.anyObject())).andReturn((Object)this.mockCreateTopicsSameResult((Set<String>)sourceTopics, this.topicExistsException())).once();
        EasyMock.expect((Object)this.destAdmin().listTopics()).andReturn((Object)this.mockNoInternalListTopics((Set<String>)nonMirrorDestTopics, this.mockNoInternalListTopics$default$2())).once();
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)this.config(this.includeAllFilter())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager(), this.sourceAdmin(), this.destAdmin()});
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.linkData(), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)expectedMirrors, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)expectedMirrors, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        this.verifyMock();
    }

    @Test
    public void testTopicCanBeCreatedAfterConflictingTopicDeletion() {
        Set sourceTopics = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic"}));
        Set destTopics = Set$.MODULE$.empty();
        Set nonMirrorDestTopics = Set$.MODULE$.empty();
        this.setupMock();
        EasyMock.expect((Object)this.sourceAdmin().listTopics()).andReturn((Object)this.mockNoInternalListTopics((Set<String>)sourceTopics, this.mockNoInternalListTopics$default$2())).anyTimes();
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)destTopics).anyTimes();
        EasyMock.expect((Object)this.destAdmin().createTopics((Collection)EasyMock.anyObject())).andReturn((Object)this.mockCreateTopicsSameResult((Set<String>)sourceTopics, this.topicExistsException())).once().andReturn((Object)this.mockCreateTopicsSameResult((Set<String>)sourceTopics, this.mockCreateTopicsSameResult$default$2())).once();
        EasyMock.expect((Object)this.destAdmin().listTopics()).andReturn((Object)this.mockNoInternalListTopics((Set<String>)nonMirrorDestTopics, this.mockNoInternalListTopics$default$2())).once();
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)this.config(this.includeAllFilter())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager(), this.sourceAdmin(), this.destAdmin()});
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.linkData(), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)sourceTopics, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        this.verifyMock();
    }

    @Test
    public void testNoCreateTopicsCallForInternalTopic() {
        String internalTopic = "_mock_internal_topic";
        scala.collection.immutable.Map nameToListing = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)internalTopic), (Object)new TopicListing(internalTopic, true))}));
        this.setupMock();
        EasyMock.expect((Object)this.sourceAdmin().listTopics()).andReturn((Object)this.mockListTopics((scala.collection.immutable.Map<String, TopicListing>)nameToListing, this.mockListTopics$default$2())).anyTimes();
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{internalTopic}))).anyTimes();
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)this.config(this.includeAllFilter())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager(), this.sourceAdmin(), this.destAdmin()});
        new ClusterLinkAutoMirroring(this.clientManager(), this.linkData(), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics()).runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
    }

    @Test
    public void testConflictingDestCacheValues() {
        Set sourceTopicsOld = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-1"}));
        Set sourceTopicsNew = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-1", "test-topic-2"}));
        Set destTopicsNew = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"test-topic-2"}));
        this.setupMock();
        EasyMock.expect((Object)this.sourceAdmin().listTopics()).andReturn((Object)this.mockNoInternalListTopics((Set<String>)sourceTopicsOld, this.mockNoInternalListTopics$default$2())).once().andReturn((Object)this.mockNoInternalListTopics((Set<String>)sourceTopicsNew, this.mockNoInternalListTopics$default$2())).once();
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Set$.MODULE$.empty()).anyTimes();
        EasyMock.expect((Object)this.destAdmin().listTopics()).andReturn((Object)this.mockNoInternalListTopics((Set<String>)destTopicsNew, this.mockNoInternalListTopics$default$2())).once();
        EasyMock.expect((Object)this.destAdmin().createTopics((Collection)EasyMock.anyObject())).andReturn((Object)this.mockCreateTopicsSameResult((Set<String>)sourceTopicsOld, this.topicExistsException())).once().andReturn((Object)this.mockCreateTopics((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test-topic-2"), this.topicExistsException()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test-topic-1"), (Object)Option$.MODULE$.empty())}))))).once();
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)this.config(this.includeAllFilter())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager(), this.sourceAdmin(), this.destAdmin()});
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.linkData(), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)sourceTopicsOld, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)sourceTopicsOld, (Object)clusterLinkAutoMirroring.getMirrorTopics());
        Assertions.assertEquals((Object)destTopicsNew, (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        this.verifyMock();
    }

    @Test
    public void testNoCreateTopicWithInactiveMirrorTopics() {
        this.resetMock();
        EasyMock.expect((Object)this.clientManager().scheduler()).andReturn((Object)this.scheduler()).anyTimes();
        EasyMock.expect((Object)this.clientManager().getAdmin()).andReturn((Object)this.sourceAdmin()).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        EasyMock.expect((Object)this.controller().controllerContext()).andReturn((Object)this.controllerContext()).anyTimes();
        ClusterLinkTopicState.Mirror testActiveTopicState = new ClusterLinkTopicState.Mirror("testLink", this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4());
        ClusterLinkTopicState.PendingStoppedMirror testPendingStopTopicState = new ClusterLinkTopicState.PendingStoppedMirror("testLink", this.linkId(), this.sourceTopicId(), false, ClusterLinkTopicState.PendingStoppedMirror$.MODULE$.apply$default$5());
        ClusterLinkTopicState.FailedMirror testFailedTopicState = new ClusterLinkTopicState.FailedMirror("testLink", this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.FailedMirror$.MODULE$.apply$default$4());
        ClusterLinkTopicState.StoppedMirror testStoppedTopicState = new ClusterLinkTopicState.StoppedMirror("testLink", this.linkId(), this.sourceTopicId(), (Seq)Nil$.MODULE$, ClusterLinkTopicState.StoppedMirror$.MODULE$.apply$default$5());
        ClusterLinkTopicState.PausedMirror testPausedTopicState = new ClusterLinkTopicState.PausedMirror("testLink", this.linkId(), this.sourceTopicId(), false, true, false, ClusterLinkTopicState.PausedMirror$.MODULE$.apply$default$7());
        ConcurrentHashMap<String, Object> linkedTopics = new ConcurrentHashMap<String, Object>();
        linkedTopics.put("testTopic", testActiveTopicState);
        linkedTopics.put("testTopicPendingStopped", testPendingStopTopicState);
        linkedTopics.put("testTopicFailed", testFailedTopicState);
        linkedTopics.put("testTopicPaused", testPausedTopicState);
        linkedTopics.put("testTopicStopped", testStoppedTopicState);
        EasyMock.expect((Object)this.controllerContext().linkedTopics()).andReturn(CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(linkedTopics).asScala()).anyTimes();
        EasyMock.expect((Object)this.sourceAdmin().listTopics()).andReturn((Object)this.mockNoInternalListTopics((Set<String>)((Set)CollectionConverters$.MODULE$.asScalaSetConverter(linkedTopics.keySet()).asScala()), this.mockNoInternalListTopics$default$2())).anyTimes();
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"testTopic"}))).anyTimes();
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)this.config(this.includeAllFilter())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager(), this.sourceAdmin(), this.destAdmin(), this.controller(), this.controllerContext()});
        ClusterLinkAutoMirroring clusterLinkAutoMirroring = new ClusterLinkAutoMirroring(this.clientManager(), this.linkData(), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics());
        clusterLinkAutoMirroring.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)Set$.MODULE$.empty(), (Object)clusterLinkAutoMirroring.getConflictingDestTopics());
        this.verifyMock();
    }

    public ClusterLinkAutoMirroringTest() {
        this.includeAllFilter = "{\"topicFilters\":[{\"name\":\"*\",\"filterType\":\"INCLUDE\",\"patternType\":\"LITERAL\"}]}";
    }
}

