/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kafka.controller.KafkaController;
import kafka.server.link.ClusterLinkClearMirrorTopics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0010!\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001C\u0002\u0013%1\u0007\u0003\u0004=\u0001\u0001\u0006I\u0001\u000e\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019)\u0005\u0001)A\u0005\u007f!9a\t\u0001b\u0001\n\u00139\u0005BB*\u0001A\u0003%\u0001\nC\u0004U\u0001\t\u0007I\u0011B+\t\re\u0003\u0001\u0015!\u0003W\u0011\u001dQ\u0006A1A\u0005\nmCaa\u0019\u0001!\u0002\u0013a\u0006b\u00023\u0001\u0005\u0004%I!\u001a\u0005\u0007Y\u0002\u0001\u000b\u0011\u00024\t\u000f5\u0004!\u0019!C\u0005]\"1A\u000f\u0001Q\u0001\n=DQ!\u001e\u0001\u0005\u0002YDa!a\u0003\u0001\t\u00031\bBBA\u000b\u0001\u0011\u0005a\u000f\u0003\u0004\u0002 \u0001!\tA\u001e\u0005\u0007\u0003G\u0001A\u0011\u0001<\t\r\u0005\u001d\u0002\u0001\"\u0001w\u0011\u0019\tY\u0003\u0001C\u0001m\"1\u0011q\u0006\u0001\u0005\u0002YDa!a\r\u0001\t\u00031\bBBA\u001c\u0001\u0011\u0005a\u000f\u0003\u0004\u0002<\u0001!\tA\u001e\u0005\u0007\u0003\u007f\u0001A\u0011\u0001<\t\u000f\u0005\r\u0003\u0001\"\u0003\u0002F!9\u0011q\u000f\u0001\u0005\n\u0005e\u0004\"CAK\u0001E\u0005I\u0011BAL\u0005\u0001\u001aE.^:uKJd\u0015N\\6DY\u0016\f'/T5se>\u0014Hk\u001c9jGN$Vm\u001d;\u000b\u0005\u0005\u0012\u0013\u0001\u00027j].T!a\t\u0013\u0002\rM,'O^3s\u0015\u0005)\u0013!B6bM.\f7\u0001A\n\u0003\u0001!\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00011!\t\t\u0004!D\u0001!\u0003!a\u0017N\\6OC6,W#\u0001\u001b\u0011\u0005URT\"\u0001\u001c\u000b\u0005]B\u0014\u0001\u00027b]\u001eT\u0011!O\u0001\u0005U\u00064\u0018-\u0003\u0002<m\t11\u000b\u001e:j]\u001e\f\u0011\u0002\\5oW:\u000bW.\u001a\u0011\u0002\r1Lgn[%e+\u0005y\u0004C\u0001!D\u001b\u0005\t%B\u0001\"9\u0003\u0011)H/\u001b7\n\u0005\u0011\u000b%\u0001B+V\u0013\u0012\u000bq\u0001\\5oW&#\u0007%A\u0007t_V\u00148-\u001a+pa&\u001c\u0017\nZ\u000b\u0002\u0011B\u0011\u0011*U\u0007\u0002\u0015*\u00111\nT\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015j%B\u0001(P\u0003\u0019\t\u0007/Y2iK*\t\u0001+A\u0002pe\u001eL!A\u0015&\u0003\tU+\u0018\u000eZ\u0001\u000fg>,(oY3U_BL7-\u00133!\u0003%\u00198\r[3ek2,'/F\u0001W!\t\tt+\u0003\u0002YA\t!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003\u0015\tG-\\5o+\u0005a\u0006CA/b\u001b\u0005q&B\u0001.`\u0015\t\u0001G*A\u0004dY&,g\u000e^:\n\u0005\tt&AD\"p]\u001adW/\u001a8u\u0003\u0012l\u0017N\\\u0001\u0007C\u0012l\u0017N\u001c\u0011\u0002\u0011i\\7\t\\5f]R,\u0012A\u001a\t\u0003O*l\u0011\u0001\u001b\u0006\u0003S\u0012\n!A_6\n\u0005-D'!D&bM.\f'l[\"mS\u0016tG/A\u0005{W\u000ec\u0017.\u001a8uA\u0005Q1m\u001c8ue>dG.\u001a:\u0016\u0003=\u0004\"\u0001\u001d:\u000e\u0003ET!!\u001c\u0013\n\u0005M\f(aD&bM.\f7i\u001c8ue>dG.\u001a:\u0002\u0017\r|g\u000e\u001e:pY2,'\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002oB\u0011\u0011\u0006_\u0005\u0003s*\u0012A!\u00168ji\"\u0012\u0001c\u001f\t\u0004y\u0006\u001dQ\"A?\u000b\u0005y|\u0018aA1qS*!\u0011\u0011AA\u0002\u0003\u001dQW\u000f]5uKJT1!!\u0002P\u0003\u0015QWO\\5u\u0013\r\tI! \u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007E\ty\u0001E\u0002}\u0003#I1!a\u0005~\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u000euKN$8\t\\3be6K'O]8s)>\u0004\u0018nY:F[B$\u0018\u0010K\u0002\u0013\u00033\u00012\u0001`A\u000e\u0013\r\ti\" \u0002\u0005)\u0016\u001cH/A\u000fuKN$8\t\\3be6K'O]8s)>\u0004\u0018nY:Jg6K'O]8sQ\r\u0019\u0012\u0011D\u0001-i\u0016\u001cHo\u00117fCJl\u0015N\u001d:peR{\u0007/[2t\u0013Nl\u0015N\u001d:pe\u0012KgMZ3sK:$H*\u001b8l\u0013\u0012D3\u0001FA\r\u0003\u001d\"Xm\u001d;DY\u0016\f'/T5se>\u0014Hk\u001c9jGNL5/T5se>\u0014XI\u001d:peJ+GO]=)\u0007U\tI\"\u0001\u0014uKN$8\t\\3be6K'O]8s)>\u0004\u0018nY:Jg6K'O]8s\u000bJ\u0014xN]*lSBD3AFA\r\u0003y!Xm\u001d;DY\u0016\f'/T5se>\u0014Hk\u001c9jGNtu\u000e^'jeJ|'\u000fK\u0002\u0018\u00033\tA\u0005^3ti\u000ecW-\u0019:NSJ\u0014xN\u001d+pa&\u001c7\u000fT5oW\u0012{Wm\u001d8u\u000bbL7\u000f\u001e\u0015\u00041\u0005e\u0011A\n;fgR\u001cE.Z1s\u001b&\u0014(o\u001c:U_BL7m\u001d(pi\u000e{g\u000e\u001e:pY2,'oV1ji\"\u001a\u0011$!\u0007\u0002MQ,7\u000f^\"mK\u0006\u0014X*\u001b:s_J$v\u000e]5dg\u000e{g\u000e\u001e:pY2,'/\u00127fGR,G\rK\u0002\u001b\u00033\t!\u0006^3ti\u000ecW-\u0019:NSJ\u0014xN\u001d+pa&\u001c7oQ8oiJ|G\u000e\\3s\u001b\u0006t\u00170\u00128ue&,7\u000fK\u0002\u001c\u00033\tQC\\3x\u00032$XM]'jeJ|'o\u001d*fgVdG\u000f\u0006\u0003\u0002H\u00055\u0003cA/\u0002J%\u0019\u00111\n0\u0003%\u0005cG/\u001a:NSJ\u0014xN]:SKN,H\u000e\u001e\u0005\b\u0003\u001fb\u0002\u0019AA)\u0003\u0019!x\u000e]5dgB1\u00111KA2\u0003SrA!!\u0016\u0002`9!\u0011qKA/\u001b\t\tIFC\u0002\u0002\\\u0019\na\u0001\u0010:p_Rt\u0014\"A\u0016\n\u0007\u0005\u0005$&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0014q\r\u0002\u0004'\u0016\f(bAA1UA!\u00111NA:\u001d\u0011\ti'a\u001c\u0011\u0007\u0005]#&C\u0002\u0002r)\na\u0001\u0015:fI\u00164\u0017bA\u001e\u0002v)\u0019\u0011\u0011\u000f\u0016\u0002)9,wo\u00117fCJl\u0015N\u001d:peR{\u0007/[2t)\u0019\tY(!!\u0002\fB\u0019\u0011'! \n\u0007\u0005}\u0004E\u0001\u000fDYV\u001cH/\u001a:MS:\\7\t\\3be6K'O]8s)>\u0004\u0018nY:\t\u000f\u0005\rU\u00041\u0001\u0002\u0006\u0006\u00112m\\7qY\u0016$\u0018n\u001c8DC2d'-Y2l!\u0011I\u0013qQ<\n\u0007\u0005%%FA\u0005Gk:\u001cG/[8oa!I\u0011QR\u000f\u0011\u0002\u0003\u0007\u0011qR\u0001\u000fi>\u0004\u0018nY$s_V\u00048+\u001b>f!\rI\u0013\u0011S\u0005\u0004\u0003'S#aA%oi\u0006qb.Z<DY\u0016\f'/T5se>\u0014Hk\u001c9jGN$C-\u001a4bk2$HEM\u000b\u0003\u00033SC!a$\u0002\u001c.\u0012\u0011Q\u0014\t\u0005\u0003?\u000bI+\u0004\u0002\u0002\"*!\u00111UAS\u0003%)hn\u00195fG.,GMC\u0002\u0002(*\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY+!)\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class ClusterLinkClearMirrorTopicsTest {
    private final String linkName;
    private final UUID linkId = UUID.randomUUID();
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final ConfluentAdmin admin = (ConfluentAdmin)EasyMock.mock(ConfluentAdmin.class);
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.mock(KafkaZkClient.class);
    private final KafkaController controller = (KafkaController)EasyMock.mock(KafkaController.class);

    private String linkName() {
        return this.linkName;
    }

    private UUID linkId() {
        return this.linkId;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConfluentAdmin admin() {
        return this.admin;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private KafkaController controller() {
        return this.controller;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
    }

    @Test
    public void testClearMirrorTopicsEmpty() {
        EasyMock.reset((Object[])new Object[]{this.controller()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.replay((Object[])new Object[]{this.controller()});
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(this.linkId()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.zkClient().getAllTopicsInCluster(false)).andReturn((Object)Predef$.MODULE$.Set().empty());
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        CompletableFuture done = new CompletableFuture();
        int newClearMirrorTopics_topicGroupSize = this.newClearMirrorTopics$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearMirrorTopics_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearMirrorTopics(this.linkId(), this.scheduler(), this.zkClient(), this.controller(), this.admin(), (Function0)newClearMirrorTopics_completionCallback, newClearMirrorTopics_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        EasyMock.verify((Object[])new Object[]{this.controller()});
        EasyMock.verify((Object[])new Object[]{this.zkClient()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsIsMirror() {
        void newClearMirrorTopics_topicGroupSize;
        String topic = "topic";
        EasyMock.reset((Object[])new Object[]{this.controller()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.replay((Object[])new Object[]{this.controller()});
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(this.linkId()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.zkClient().getAllTopicsInCluster(false)).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        EasyMock.expect((Object)this.zkClient().getClusterLinkForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4()))})));
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        KafkaFuture future = KafkaFuture.completedFuture(null);
        AlterMirrorsResult ret = new AlterMirrorsResult((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)future)}))).asJava());
        EasyMock.reset((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.admin().alterMirrors((java.util.Map)EasyMock.eq(Collections.singletonMap(topic, AlterMirrorOp.CLEAR)), (AlterMirrorsOptions)EasyMock.anyObject())).andReturn((Object)ret);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        CompletableFuture done = new CompletableFuture();
        int n = this.newClearMirrorTopics$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearMirrorTopics_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearMirrorTopics(this.linkId(), this.scheduler(), this.zkClient(), this.controller(), this.admin(), (Function0)newClearMirrorTopics_completionCallback, (int)newClearMirrorTopics_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        EasyMock.verify((Object[])new Object[]{this.admin()});
        EasyMock.verify((Object[])new Object[]{this.controller()});
        EasyMock.verify((Object[])new Object[]{this.zkClient()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsIsMirrorDifferentLinkId() {
        void newClearMirrorTopics_topicGroupSize;
        String topic = "topic";
        String otherLinkName = "other-link-name";
        UUID otherLinkId = UUID.randomUUID();
        EasyMock.reset((Object[])new Object[]{this.controller()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.replay((Object[])new Object[]{this.controller()});
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(this.linkId()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.zkClient().getAllTopicsInCluster(false)).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        EasyMock.expect((Object)this.zkClient().getClusterLinkForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new ClusterLinkTopicState.Mirror(otherLinkName, otherLinkId, this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4()))})));
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        CompletableFuture done = new CompletableFuture();
        int n = this.newClearMirrorTopics$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearMirrorTopics_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearMirrorTopics(this.linkId(), this.scheduler(), this.zkClient(), this.controller(), this.admin(), (Function0)newClearMirrorTopics_completionCallback, (int)newClearMirrorTopics_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        EasyMock.verify((Object[])new Object[]{this.controller()});
        EasyMock.verify((Object[])new Object[]{this.zkClient()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsIsMirrorErrorRetry() {
        void newClearMirrorTopics_topicGroupSize;
        String topic = "topic";
        EasyMock.reset((Object[])new Object[]{this.controller()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.replay((Object[])new Object[]{this.controller()});
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(this.linkId()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.zkClient().getAllTopicsInCluster(false)).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        EasyMock.expect((Object)this.zkClient().getClusterLinkForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4()))}))).times(2);
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        scala.collection.immutable.Map expectedOps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)AlterMirrorOp.CLEAR)}));
        KafkaFutureImpl future1 = new KafkaFutureImpl();
        future1.completeExceptionally((Throwable)new TimeoutException());
        AlterMirrorsResult ret1 = new AlterMirrorsResult((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)future1)}))).asJava());
        AlterMirrorsResult ret2 = this.newAlterMirrorsResult((Seq<String>)new .colon.colon((Object)topic, (List)Nil$.MODULE$));
        EasyMock.reset((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.admin().alterMirrors((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)expectedOps).asJava()), (AlterMirrorsOptions)EasyMock.anyObject())).andReturn((Object)ret1).andReturn((Object)ret2);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        CompletableFuture done = new CompletableFuture();
        int n = this.newClearMirrorTopics$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearMirrorTopics_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearMirrorTopics(this.linkId(), this.scheduler(), this.zkClient(), this.controller(), this.admin(), (Function0)newClearMirrorTopics_completionCallback, (int)newClearMirrorTopics_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        EasyMock.verify((Object[])new Object[]{this.admin()});
        EasyMock.verify((Object[])new Object[]{this.controller()});
        EasyMock.verify((Object[])new Object[]{this.zkClient()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsIsMirrorErrorSkip() {
        void newClearMirrorTopics_topicGroupSize;
        String topic = "topic";
        EasyMock.reset((Object[])new Object[]{this.controller()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.replay((Object[])new Object[]{this.controller()});
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(this.linkId()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.zkClient().getAllTopicsInCluster(false)).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        EasyMock.expect((Object)this.zkClient().getClusterLinkForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4()))})));
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        scala.collection.immutable.Map expectedOps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)AlterMirrorOp.CLEAR)}));
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally((Throwable)new UnknownTopicOrPartitionException());
        AlterMirrorsResult ret = new AlterMirrorsResult((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)future)}))).asJava());
        EasyMock.reset((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.admin().alterMirrors((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)expectedOps).asJava()), (AlterMirrorsOptions)EasyMock.anyObject())).andReturn((Object)ret);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        CompletableFuture done = new CompletableFuture();
        int n = this.newClearMirrorTopics$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearMirrorTopics_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearMirrorTopics(this.linkId(), this.scheduler(), this.zkClient(), this.controller(), this.admin(), (Function0)newClearMirrorTopics_completionCallback, (int)newClearMirrorTopics_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        EasyMock.verify((Object[])new Object[]{this.admin()});
        EasyMock.verify((Object[])new Object[]{this.controller()});
        EasyMock.verify((Object[])new Object[]{this.zkClient()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsNotMirror() {
        void newClearMirrorTopics_topicGroupSize;
        String topic = "topic";
        EasyMock.reset((Object[])new Object[]{this.controller()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.replay((Object[])new Object[]{this.controller()});
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(this.linkId()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.zkClient().getAllTopicsInCluster(false)).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        EasyMock.expect((Object)this.zkClient().getClusterLinkForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).andReturn((Object)Predef$.MODULE$.Map().empty());
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        CompletableFuture done = new CompletableFuture();
        int n = this.newClearMirrorTopics$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearMirrorTopics_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearMirrorTopics(this.linkId(), this.scheduler(), this.zkClient(), this.controller(), this.admin(), (Function0)newClearMirrorTopics_completionCallback, (int)newClearMirrorTopics_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        EasyMock.verify((Object[])new Object[]{this.controller()});
        EasyMock.verify((Object[])new Object[]{this.zkClient()});
    }

    @Test
    public void testClearMirrorTopicsLinkDoesntExist() {
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(this.linkId()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).times(1);
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        CompletableFuture done = new CompletableFuture();
        int newClearMirrorTopics_topicGroupSize = this.newClearMirrorTopics$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearMirrorTopics_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearMirrorTopics(this.linkId(), this.scheduler(), this.zkClient(), this.controller(), this.admin(), (Function0)newClearMirrorTopics_completionCallback, newClearMirrorTopics_topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        EasyMock.verify((Object[])new Object[]{this.zkClient()});
    }

    @Test
    public void testClearMirrorTopicsNotControllerWait() {
        EasyMock.reset((Object[])new Object[]{this.controller()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).times(2);
        EasyMock.replay((Object[])new Object[]{this.controller()});
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(this.linkId()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        CompletableFuture done = new CompletableFuture();
        int newClearMirrorTopics_topicGroupSize = this.newClearMirrorTopics$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearMirrorTopics_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        ClusterLinkClearMirrorTopics clusterLinkClearMirrorTopics = new ClusterLinkClearMirrorTopics(this.linkId(), this.scheduler(), this.zkClient(), this.controller(), this.admin(), (Function0)newClearMirrorTopics_completionCallback, newClearMirrorTopics_topicGroupSize, 10, 10);
        clusterLinkClearMirrorTopics.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)done.isDone());
        clusterLinkClearMirrorTopics.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)done.isDone());
        clusterLinkClearMirrorTopics.runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        EasyMock.verify((Object[])new Object[]{this.controller()});
        EasyMock.verify((Object[])new Object[]{this.zkClient()});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearMirrorTopicsControllerElected() {
        void newClearMirrorTopics_topicGroupSize;
        String topic = "topic";
        EasyMock.reset((Object[])new Object[]{this.controller()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).times(2).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.replay((Object[])new Object[]{this.controller()});
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(this.linkId()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(3);
        EasyMock.expect((Object)this.zkClient().getAllTopicsInCluster(false)).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        EasyMock.expect((Object)this.zkClient().getClusterLinkForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).andReturn((Object)Predef$.MODULE$.Map().empty());
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        CompletableFuture done = new CompletableFuture();
        int n = this.newClearMirrorTopics$default$2();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearMirrorTopics_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        ClusterLinkClearMirrorTopics clusterLinkClearMirrorTopics = new ClusterLinkClearMirrorTopics(this.linkId(), this.scheduler(), this.zkClient(), this.controller(), this.admin(), (Function0)newClearMirrorTopics_completionCallback, (int)newClearMirrorTopics_topicGroupSize, 10, 10);
        clusterLinkClearMirrorTopics.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)done.isDone());
        clusterLinkClearMirrorTopics.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)done.isDone());
        clusterLinkClearMirrorTopics.runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        EasyMock.verify((Object[])new Object[]{this.controller()});
        EasyMock.verify((Object[])new Object[]{this.zkClient()});
    }

    @Test
    public void testClearMirrorTopicsControllerManyEntries() {
        String otherLinkName = "other-link-name";
        UUID otherLinkId = UUID.randomUUID();
        int topicGroupSize = 2;
        Set topics = ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)idx -> ClusterLinkClearMirrorTopicsTest.$anonfun$testClearMirrorTopicsControllerManyEntries$1(BoxesRunTime.unboxToInt((Object)idx)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        List topicGroups = topics.grouped(topicGroupSize).toList();
        Assertions.assertEquals((int)3, (int)topicGroups.size());
        Assertions.assertEquals((int)2, (int)((TraversableOnce)topicGroups.apply(0)).size());
        Assertions.assertEquals((int)2, (int)((TraversableOnce)topicGroups.apply(1)).size());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)topicGroups.apply(2)).size());
        EasyMock.reset((Object[])new Object[]{this.controller()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.replay((Object[])new Object[]{this.controller()});
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(this.linkId()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        EasyMock.expect((Object)this.zkClient().getAllTopicsInCluster(false)).andReturn((Object)topics);
        EasyMock.expect((Object)this.zkClient().getClusterLinkForTopics((Set)topicGroups.apply(0))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableLike)topicGroups.apply(0)).head()), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((TraversableLike)topicGroups.apply(0)).last()), (Object)new ClusterLinkTopicState.Mirror(otherLinkName, otherLinkId, this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4()))})));
        EasyMock.expect((Object)this.zkClient().getClusterLinkForTopics((Set)topicGroups.apply(1))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableLike)topicGroups.apply(1)).head()), (Object)new ClusterLinkTopicState.Mirror(this.linkName(), this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((TraversableLike)topicGroups.apply(1)).last()), (Object)new ClusterLinkTopicState.FailedMirror(this.linkName(), this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.FailedMirror$.MODULE$.apply$default$4()))})));
        EasyMock.expect((Object)this.zkClient().getClusterLinkForTopics((Set)topicGroups.apply(2))).andReturn((Object)Predef$.MODULE$.Map().empty());
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        scala.collection.immutable.Map expectedOps1 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableLike)topicGroups.apply(0)).head()), (Object)AlterMirrorOp.CLEAR)}));
        scala.collection.immutable.Map expectedOps2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((IterableLike)topicGroups.apply(1)).head()), (Object)AlterMirrorOp.CLEAR), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(((TraversableLike)topicGroups.apply(1)).last()), (Object)AlterMirrorOp.CLEAR)}));
        AlterMirrorsResult ret1 = this.newAlterMirrorsResult((Seq<String>)new .colon.colon((Object)((String)((IterableLike)topicGroups.apply(0)).head()), (List)Nil$.MODULE$));
        AlterMirrorsResult ret2 = this.newAlterMirrorsResult((Seq<String>)new .colon.colon((Object)((String)((IterableLike)topicGroups.apply(1)).head()), (List)new .colon.colon((Object)((String)((TraversableLike)topicGroups.apply(1)).last()), (List)Nil$.MODULE$)));
        EasyMock.reset((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.admin().alterMirrors((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)expectedOps1).asJava()), (AlterMirrorsOptions)EasyMock.anyObject())).andReturn((Object)ret1);
        EasyMock.expect((Object)this.admin().alterMirrors((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)expectedOps2).asJava()), (AlterMirrorsOptions)EasyMock.anyObject())).andReturn((Object)ret2);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        CompletableFuture done = new CompletableFuture();
        JFunction0.mcV.sp & Serializable & scala.Serializable newClearMirrorTopics_completionCallback = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> done.complete(null);
        new ClusterLinkClearMirrorTopics(this.linkId(), this.scheduler(), this.zkClient(), this.controller(), this.admin(), (Function0)newClearMirrorTopics_completionCallback, topicGroupSize, 10, 10).runOnce().get(5L, TimeUnit.SECONDS);
        done.get();
        EasyMock.verify((Object[])new Object[]{this.admin()});
        EasyMock.verify((Object[])new Object[]{this.controller()});
        EasyMock.verify((Object[])new Object[]{this.zkClient()});
    }

    private AlterMirrorsResult newAlterMirrorsResult(Seq<String> topics) {
        return new AlterMirrorsResult((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)KafkaFuture.completedFuture(null)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava());
    }

    private ClusterLinkClearMirrorTopics newClearMirrorTopics(Function0<BoxedUnit> completionCallback, int topicGroupSize) {
        return new ClusterLinkClearMirrorTopics(this.linkId(), this.scheduler(), this.zkClient(), this.controller(), this.admin(), completionCallback, topicGroupSize, 10, 10);
    }

    private int newClearMirrorTopics$default$2() {
        return 10;
    }

    public static final /* synthetic */ String $anonfun$testClearMirrorTopicsControllerManyEntries$1(int idx) {
        return new StringBuilder(6).append("topic-").append(idx).toString();
    }

    public ClusterLinkClearMirrorTopicsTest() {
        this.linkName = "link-name";
    }
}

