/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kafka.controller.KafkaController;
import kafka.server.KafkaConfig;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTestUtils$;
import kafka.utils.Implicits$;
import kafka.utils.TestUtils$;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.common.errors.ClusterLinkPausedException;
import org.apache.kafka.server.authorizer.Authorizer;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001\u0002\r\u001a\u0001\u0001BQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013\u0005A\u0006\u0003\u00041\u0001\u0001\u0006I!\f\u0005\bc\u0001\u0011\r\u0011\"\u00013\u0011\u0019I\u0004\u0001)A\u0005g!I!\b\u0001a\u0001\u0002\u0004%\ta\u000f\u0005\n\u007f\u0001\u0001\r\u00111A\u0005\u0002\u0001C\u0011B\u0012\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u001f\t\u000f\u001d\u0003!\u0019!C\u0001\u0011\"1A\u000b\u0001Q\u0001\n%Cq!\u0016\u0001C\u0002\u0013\u0005a\u000b\u0003\u0004]\u0001\u0001\u0006Ia\u0016\u0005\b;\u0002\u0011\r\u0011\"\u0001_\u0011\u00199\u0007\u0001)A\u0005?\"9\u0001\u000e\u0001b\u0001\n\u0003I\u0007BB7\u0001A\u0003%!\u000eC\u0003o\u0001\u0011\u0005q\u000eC\u0003|\u0001\u0011\u0005q\u000eC\u0003~\u0001\u0011\u0005q\u000eC\u0003\u0000\u0001\u0011\u0005q\u000e\u0003\u0004\u0002\u0004\u0001!\ta\u001c\u0005\b\u0003\u000f\u0001A\u0011BA\u0005\u0011\u001d\tI\u0005\u0001C\u0005\u0003\u0017\u0012Ad\u00117vgR,'\u000fT5oW\u000ec\u0017.\u001a8u\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u001b7\u0005!A.\u001b8l\u0015\taR$\u0001\u0004tKJ4XM\u001d\u0006\u0002=\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\"!\t\u0011S%D\u0001$\u0015\u0005!\u0013!B:dC2\f\u0017B\u0001\u0014$\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\u000b\t\u0003U\u0001i\u0011!G\u0001\ng\u000eDW\rZ;mKJ,\u0012!\f\t\u0003U9J!aL\r\u0003)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\tu.\u001cE.[3oiV\t1\u0007\u0005\u00025o5\tQG\u0003\u00027;\u0005\u0011!p[\u0005\u0003qU\u0012QbS1gW\u0006T6n\u00117jK:$\u0018!\u0003>l\u00072LWM\u001c;!\u00035\u0019G.[3oi6\u000bg.Y4feV\tA\b\u0005\u0002+{%\u0011a(\u0007\u0002\u0019\u00072,8\u000f^3s\u0019&t7n\u00117jK:$X*\u00198bO\u0016\u0014\u0018!E2mS\u0016tG/T1oC\u001e,'o\u0018\u0013fcR\u0011\u0011\t\u0012\t\u0003E\tK!aQ\u0012\u0003\tUs\u0017\u000e\u001e\u0005\b\u000b\u001e\t\t\u00111\u0001=\u0003\rAH%M\u0001\u000fG2LWM\u001c;NC:\fw-\u001a:!\u0003)\tW\u000f\u001e5pe&TXM]\u000b\u0002\u0013B\u0011!JU\u0007\u0002\u0017*\u0011q\t\u0014\u0006\u000395S!A\b(\u000b\u0005=\u0003\u0016AB1qC\u000eDWMC\u0001R\u0003\ry'oZ\u0005\u0003'.\u0013!\"Q;uQ>\u0014\u0018N_3s\u0003-\tW\u000f\u001e5pe&TXM\u001d\u0011\u0002\u0015\r|g\u000e\u001e:pY2,'/F\u0001X!\tA&,D\u0001Z\u0015\t)V$\u0003\u0002\\3\ny1*\u00194lC\u000e{g\u000e\u001e:pY2,'/A\u0006d_:$(o\u001c7mKJ\u0004\u0013!\u00033fgR\fE-\\5o+\u0005y\u0006C\u00011f\u001b\u0005\t'B\u00012d\u0003\u0015\tG-\\5o\u0015\t!W*A\u0004dY&,g\u000e^:\n\u0005\u0019\f'!B!e[&t\u0017A\u00033fgR\fE-\\5oA\u00059Q.\u001a;sS\u000e\u001cX#\u00016\u0011\u0005)Z\u0017B\u00017\u001a\u0005I\u0019E.^:uKJd\u0015N\\6NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\nq\u0002^3tiJ+7m\u001c8gS\u001e,(/\u001a\u000b\u0002\u0003\"\u0012\u0011#\u001d\t\u0003efl\u0011a\u001d\u0006\u0003iV\f1!\u00199j\u0015\t1x/A\u0004kkBLG/\u001a:\u000b\u0005a\u0004\u0016!\u00026v]&$\u0018B\u0001>t\u0005\u0011!Vm\u001d;\u0002\u0015Q,7\u000f\u001e+pa&\u001c7\u000f\u000b\u0002\u0013c\u00061B/Z:u\u0003\u000ed7+\u001f8d)\u0006\u001c8n\u0015;beR,\b\u000f\u000b\u0002\u0014c\u00061C/Z:u\u0003\u000ed7+\u001f8d)\u0006\u001c8n\u0015;beR,\boV5uQ:{\u0017)\u001e;i_JL'0\u001a:)\u0005Q\t\u0018\u0001\u0007;fgR\f5\r\\*z]\u000e$\u0016m]6O_N#\u0018M\u001d;va\"\u0012Q#]\u0001\u0011]\u0016<8\t\\5f]Rl\u0015M\\1hKJ$2\u0002PA\u0006\u0003K\ty#a\u0010\u0002H!9\u0011Q\u0002\fA\u0002\u0005=\u0011\u0001\u00037j].t\u0015-\\3\u0011\t\u0005E\u0011q\u0004\b\u0005\u0003'\tY\u0002E\u0002\u0002\u0016\rj!!a\u0006\u000b\u0007\u0005eq$\u0001\u0004=e>|GOP\u0005\u0004\u0003;\u0019\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\"\u0005\r\"AB*ue&twMC\u0002\u0002\u001e\rBq!a\n\u0017\u0001\u0004\tI#\u0001\u0004d_:4\u0017n\u001a\t\u0004U\u0005-\u0012bAA\u00173\t\t2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4\t\u000f\u0005Eb\u00031\u0001\u00024\u0005a\u0011\rZ7j]\u001a\u000b7\r^8ssB9!%!\u000e\u0002*\u0005e\u0012bAA\u001cG\tIa)\u001e8di&|g.\r\t\u0004U\u0005m\u0012bAA\u001f3\t12\t\\;ti\u0016\u0014H*\u001b8l\u0003\u0012l\u0017N\\\"mS\u0016tG\u000f\u0003\u0004H-\u0001\u0007\u0011\u0011\t\t\u0005E\u0005\r\u0013*C\u0002\u0002F\r\u0012aa\u00149uS>t\u0007\"B+\u0017\u0001\u00049\u0016!\u00038fo\u000e{gNZ5h)\u0011\tI#!\u0014\t\u000f\u0005=s\u00031\u0001\u0002R\u000591m\u001c8gS\u001e\u001c\b\u0003CA\t\u0003'\ny!a\u0004\n\t\u0005U\u00131\u0005\u0002\u0004\u001b\u0006\u0004\b")
public class ClusterLinkClientManagerTest {
    private final ClusterLinkScheduler scheduler = (ClusterLinkScheduler)EasyMock.createNiceMock(ClusterLinkScheduler.class);
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private ClusterLinkClientManager clientManager;
    private final Authorizer authorizer = (Authorizer)EasyMock.createNiceMock(Authorizer.class);
    private final KafkaController controller = (KafkaController)EasyMock.createNiceMock(KafkaController.class);
    private final Admin destAdmin = (Admin)EasyMock.createNiceMock(Admin.class);
    private final ClusterLinkMetrics metrics = (ClusterLinkMetrics)EasyMock.createNiceMock(ClusterLinkMetrics.class);

    public ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public ClusterLinkClientManager clientManager() {
        return this.clientManager;
    }

    public void clientManager_$eq(ClusterLinkClientManager x$1) {
        this.clientManager = x$1;
    }

    public Authorizer authorizer() {
        return this.authorizer;
    }

    public KafkaController controller() {
        return this.controller;
    }

    public Admin destAdmin() {
        return this.destAdmin;
    }

    public ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReconfigure() {
        void newClientManager_adminFactory;
        void newClientManager_controller;
        void newClientManager_authorizer;
        String linkName = "test-link";
        IntRef factoryCalled = IntRef.create((int)0);
        ObjectRef factoryConfig = ObjectRef.create((Object)this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234")})))));
        ObjectRef factoryAdmin = ObjectRef.create((Object)((KafkaAdminClient)EasyMock.createNiceMock(KafkaAdminClient.class)));
        KafkaController kafkaController = this.controller();
        Some some = new Some((Object)this.authorizer());
        Function1 & Serializable & scala.Serializable intersect = (Function1 & Serializable & scala.Serializable)config -> ClusterLinkClientManagerTest.adminFactory$1(config, factoryCalled, factoryConfig, factoryAdmin);
        ClusterLinkConfig newClientManager_config = (ClusterLinkConfig)factoryConfig.elem;
        EasyMock.expect((Object)this.scheduler().schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.anyLong(), EasyMock.anyLong(), (TimeUnit)((Object)EasyMock.anyObject()))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.scheduler()});
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, UUID.randomUUID(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)EasyMock.createNiceMock(ClusterLinkFetcherManager.class);
        ClusterLinkClientManager clusterLinkClientManager = new ClusterLinkClientManager(ClusterLinkTestUtils$.MODULE$.createClusterLinkManager(), new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), newClientManager_linkData, newClientManager_fetcherManager, this.scheduler(), this.zkClient(), newClientManager_config, (Option)newClientManager_authorizer, (KafkaController)newClientManager_controller, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable & scala.Serializable)() -> this.destAdmin());
        Assertions.assertEquals((int)0, (int)factoryCalled.elem);
        clusterLinkClientManager.startup();
        try {
            Assertions.assertEquals((int)1, (int)factoryCalled.elem);
            Assertions.assertTrue(((KafkaAdminClient)factoryAdmin.elem == clusterLinkClientManager.getAdmin() ? 1 : 0) != 0);
            factoryAdmin.elem = (KafkaAdminClient)EasyMock.createNiceMock(KafkaAdminClient.class);
            factoryConfig.elem = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:2345")}))));
            clusterLinkClientManager.reconfigure((ClusterLinkConfig)factoryConfig.elem, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bootstrap.servers"})));
            Assertions.assertEquals((int)2, (int)factoryCalled.elem);
            Assertions.assertTrue(((KafkaAdminClient)factoryAdmin.elem == clusterLinkClientManager.getAdmin() ? 1 : 0) != 0);
            factoryConfig.elem = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:2345"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.NumClusterLinkFetchersProp()), (Object)"5")}))));
            clusterLinkClientManager.reconfigure((ClusterLinkConfig)factoryConfig.elem, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.NumClusterLinkFetchersProp()})));
            Assertions.assertEquals((int)2, (int)factoryCalled.elem);
            factoryConfig.elem = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:3456"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
            clusterLinkClientManager.reconfigure((ClusterLinkConfig)factoryConfig.elem, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.NumClusterLinkFetchersProp(), "bootstrap.servers", ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()})));
            Assertions.assertEquals((int)2, (int)factoryCalled.elem);
            Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> clusterLinkClientManager.getAdmin(), ClassTag$.MODULE$.apply(ClusterLinkPausedException.class), new Position("ClusterLinkClientManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 76));
            factoryConfig.elem = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:4567"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()), (Object)"true")}))));
            clusterLinkClientManager.reconfigure((ClusterLinkConfig)factoryConfig.elem, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bootstrap.servers"})));
            Assertions.assertEquals((int)2, (int)factoryCalled.elem);
            Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> clusterLinkClientManager.getAdmin(), ClassTag$.MODULE$.apply(ClusterLinkPausedException.class), new Position("ClusterLinkClientManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            factoryAdmin.elem = (KafkaAdminClient)EasyMock.createNiceMock(KafkaAdminClient.class);
            factoryConfig.elem = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:4567")}))));
            clusterLinkClientManager.reconfigure((ClusterLinkConfig)factoryConfig.elem, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()})));
            Assertions.assertEquals((int)3, (int)factoryCalled.elem);
            Assertions.assertTrue(((KafkaAdminClient)factoryAdmin.elem == clusterLinkClientManager.getAdmin() ? 1 : 0) != 0);
        }
        finally {
            clusterLinkClientManager.shutdown();
        }
        Assertions.assertEquals((int)3, (int)factoryCalled.elem);
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> clusterLinkClientManager.getAdmin(), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkClientManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopics() {
        void newClientManager_controller;
        void newClientManager_authorizer;
        String linkName = "test-link";
        ClusterLinkConfig config2 = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234")}))));
        KafkaController kafkaController = this.controller();
        Some some = new Some((Object)this.authorizer());
        Function1 & Serializable & scala.Serializable newClientManager_adminFactory = (Function1 & Serializable & scala.Serializable)config -> ClusterLinkClientManagerTest.adminFactory$2(config);
        EasyMock.expect((Object)this.scheduler().schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.anyLong(), EasyMock.anyLong(), (TimeUnit)((Object)EasyMock.anyObject()))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.scheduler()});
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, UUID.randomUUID(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)EasyMock.createNiceMock(ClusterLinkFetcherManager.class);
        ClusterLinkClientManager clusterLinkClientManager = new ClusterLinkClientManager(ClusterLinkTestUtils$.MODULE$.createClusterLinkManager(), new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), newClientManager_linkData, newClientManager_fetcherManager, this.scheduler(), this.zkClient(), config2, (Option)newClientManager_authorizer, (KafkaController)newClientManager_controller, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable & scala.Serializable)() -> this.destAdmin());
        .colon.colon topics = new .colon.colon((Object)"topic0", (List)new .colon.colon((Object)"topic1", (List)new .colon.colon((Object)"topic2", (List)Nil$.MODULE$)));
        clusterLinkClientManager.startup();
        try {
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)clusterLinkClientManager.getTopics());
            clusterLinkClientManager.addTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(0), (String)topics.apply(1)})));
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(0), (String)topics.apply(1)})), (Object)clusterLinkClientManager.getTopics());
            clusterLinkClientManager.addTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(1), (String)topics.apply(2)})));
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(0), (String)topics.apply(1), (String)topics.apply(2)})), (Object)clusterLinkClientManager.getTopics());
            clusterLinkClientManager.removeTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(2), (String)topics.apply(0)})));
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(1)})), (Object)clusterLinkClientManager.getTopics());
            clusterLinkClientManager.removeTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(1), "unknown"})));
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)clusterLinkClientManager.getTopics());
        }
        finally {
            clusterLinkClientManager.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclSyncTaskStartup() {
        void newClientManager_controller;
        void newClientManager_authorizer;
        String linkName = "test-link";
        String migrateAllAclsJson = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [{\n        |  \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        |  }]\n        | }")).stripMargin();
        ClusterLinkConfig config2 = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)migrateAllAclsJson)}))));
        KafkaController kafkaController = this.controller();
        Some some = new Some((Object)this.authorizer());
        Function1 & Serializable & scala.Serializable newClientManager_adminFactory = (Function1 & Serializable & scala.Serializable)config -> ClusterLinkClientManagerTest.adminFactory$3(config);
        EasyMock.expect((Object)this.scheduler().schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.anyLong(), EasyMock.anyLong(), (TimeUnit)((Object)EasyMock.anyObject()))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.scheduler()});
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, UUID.randomUUID(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)EasyMock.createNiceMock(ClusterLinkFetcherManager.class);
        ClusterLinkClientManager clusterLinkClientManager = new ClusterLinkClientManager(ClusterLinkTestUtils$.MODULE$.createClusterLinkManager(), new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), newClientManager_linkData, newClientManager_fetcherManager, this.scheduler(), this.zkClient(), config2, (Option)newClientManager_authorizer, (KafkaController)newClientManager_controller, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable & scala.Serializable)() -> this.destAdmin());
        clusterLinkClientManager.startup();
        try {
            Predef$.MODULE$.assert(clusterLinkClientManager.getSyncAclTask().isDefined());
        }
        finally {
            clusterLinkClientManager.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclSyncTaskStartupWithNoAuthorizer() {
        void newClientManager_controller;
        void newClientManager_authorizer;
        String linkName = "test-link";
        String migrateAllAclsJson = new StringOps(Predef$.MODULE$.augmentString("{\n        | \"aclFilters\": [{\n        |  \"resourceFilter\": {\n        |      \"resourceType\": \"any\",\n        |      \"patternType\": \"any\"\n        |    },\n        |  \"accessFilter\": {\n        |     \"operation\": \"any\",\n        |     \"permissionType\": \"any\"\n        |    }\n        |  }]\n        | }")).stripMargin();
        ClusterLinkConfig config2 = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)migrateAllAclsJson)}))));
        KafkaController kafkaController = this.controller();
        None$ none$ = None$.MODULE$;
        Function1 & Serializable & scala.Serializable newClientManager_adminFactory = (Function1 & Serializable & scala.Serializable)config -> ClusterLinkClientManagerTest.adminFactory$4(config);
        EasyMock.expect((Object)this.scheduler().schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.anyLong(), EasyMock.anyLong(), (TimeUnit)((Object)EasyMock.anyObject()))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.scheduler()});
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, UUID.randomUUID(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)EasyMock.createNiceMock(ClusterLinkFetcherManager.class);
        ClusterLinkClientManager clusterLinkClientManager = new ClusterLinkClientManager(ClusterLinkTestUtils$.MODULE$.createClusterLinkManager(), new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), newClientManager_linkData, newClientManager_fetcherManager, this.scheduler(), this.zkClient(), config2, (Option)newClientManager_authorizer, (KafkaController)newClientManager_controller, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable & scala.Serializable)() -> this.destAdmin());
        try {
            try {
                clusterLinkClientManager.startup();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Assertions.assertEquals((Object)illegalArgumentException.getMessage(), (Object)"ACL migration is enabled but authorizer.class.name is not set. Please set authorizer.class.name to proceed with ACL migration.");
            }
        }
        finally {
            clusterLinkClientManager.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclSyncTaskNoStartup() {
        void newClientManager_controller;
        void newClientManager_authorizer;
        String linkName = "test-link";
        ClusterLinkConfig config2 = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"false")}))));
        KafkaController kafkaController = this.controller();
        Some some = new Some((Object)this.authorizer());
        Function1 & Serializable & scala.Serializable newClientManager_adminFactory = (Function1 & Serializable & scala.Serializable)config -> ClusterLinkClientManagerTest.adminFactory$5(config);
        EasyMock.expect((Object)this.scheduler().schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.anyLong(), EasyMock.anyLong(), (TimeUnit)((Object)EasyMock.anyObject()))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.scheduler()});
        ClusterLinkData newClientManager_linkData = new ClusterLinkData(linkName, UUID.randomUUID(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager newClientManager_fetcherManager = (ClusterLinkFetcherManager)EasyMock.createNiceMock(ClusterLinkFetcherManager.class);
        ClusterLinkClientManager clusterLinkClientManager = new ClusterLinkClientManager(ClusterLinkTestUtils$.MODULE$.createClusterLinkManager(), new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), newClientManager_linkData, newClientManager_fetcherManager, this.scheduler(), this.zkClient(), config2, (Option)newClientManager_authorizer, (KafkaController)newClientManager_controller, (Option)None$.MODULE$, this.metrics(), (Function1)newClientManager_adminFactory, (Function0 & Serializable & scala.Serializable)() -> this.destAdmin());
        clusterLinkClientManager.startup();
        try {
            Predef$.MODULE$.assert(clusterLinkClientManager.getSyncAclTask().isEmpty());
        }
        finally {
            clusterLinkClientManager.shutdown();
        }
    }

    private ClusterLinkClientManager newClientManager(String linkName, ClusterLinkConfig config, Function1<ClusterLinkConfig, ClusterLinkAdminClient> adminFactory, Option<Authorizer> authorizer, KafkaController controller) {
        EasyMock.expect((Object)this.scheduler().schedule(EasyMock.anyString(), (Function0)EasyMock.anyObject(), EasyMock.anyLong(), EasyMock.anyLong(), (TimeUnit)((Object)EasyMock.anyObject()))).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.scheduler()});
        ClusterLinkData linkData = new ClusterLinkData(linkName, UUID.randomUUID(), (Option)None$.MODULE$, (Option)None$.MODULE$, false);
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)EasyMock.createNiceMock(ClusterLinkFetcherManager.class);
        return new ClusterLinkClientManager(ClusterLinkTestUtils$.MODULE$.createClusterLinkManager(), new KafkaConfig((Map)TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), linkData, fetcherManager, this.scheduler(), this.zkClient(), config, authorizer, controller, (Option)None$.MODULE$, this.metrics(), adminFactory, (Function0 & Serializable & scala.Serializable)() -> this.destAdmin());
    }

    private ClusterLinkConfig newConfig(scala.collection.immutable.Map<String, String> configs) {
        Properties props = new Properties();
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(configs);
        return ClusterLinkConfig$.MODULE$.create((Map)props);
    }

    private static final ClusterLinkAdminClient adminFactory$1(ClusterLinkConfig config, IntRef factoryCalled$1, ObjectRef factoryConfig$1, ObjectRef factoryAdmin$1) {
        ++factoryCalled$1.elem;
        Assertions.assertTrue(((ClusterLinkConfig)factoryConfig$1.elem == config ? 1 : 0) != 0);
        return new ClusterLinkAdminClient((ConfluentAdmin)((KafkaAdminClient)factoryAdmin$1.elem), null, null, "");
    }

    private static final ClusterLinkAdminClient adminFactory$2(ClusterLinkConfig config) {
        return (ClusterLinkAdminClient)EasyMock.createNiceMock(ClusterLinkAdminClient.class);
    }

    private static final ClusterLinkAdminClient adminFactory$3(ClusterLinkConfig config) {
        return (ClusterLinkAdminClient)EasyMock.createNiceMock(ClusterLinkAdminClient.class);
    }

    private static final ClusterLinkAdminClient adminFactory$4(ClusterLinkConfig config) {
        return (ClusterLinkAdminClient)EasyMock.createNiceMock(ClusterLinkAdminClient.class);
    }

    private static final ClusterLinkAdminClient adminFactory$5(ClusterLinkConfig config) {
        return (ClusterLinkAdminClient)EasyMock.createNiceMock(ClusterLinkAdminClient.class);
    }
}

