/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.util.Map;
import java.util.Properties;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConfigDefaults$;
import kafka.server.link.LinkMode;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Option$;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000192A!\u0002\u0004\u0001\u001b!)A\u0003\u0001C\u0001+!)\u0001\u0004\u0001C\u00013!)!\u0006\u0001C\u00013!)A\u0006\u0001C\u00013\t)2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4UKN$(BA\u0004\t\u0003\u0011a\u0017N\\6\u000b\u0005%Q\u0011AB:feZ,'OC\u0001\f\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0003\u0005\u0002\u0018\u00015\ta!\u0001\u000buKN$8i\u001c8gS\u001e\u001c\u0015\r^3h_JLWm\u001d\u000b\u00025A\u0011qbG\u0005\u00039A\u0011A!\u00168ji\"\u0012!A\b\t\u0003?!j\u0011\u0001\t\u0006\u0003C\t\n1!\u00199j\u0015\t\u0019C%A\u0004kkBLG/\u001a:\u000b\u0005\u00152\u0013!\u00026v]&$(\"A\u0014\u0002\u0007=\u0014x-\u0003\u0002*A\t!A+Z:u\u00031!Xm\u001d;EK\u001a\fW\u000f\u001c;tQ\t\u0019a$\u0001\nuKN$X*[4sCRLwN\u001c)s_B\u001c\bF\u0001\u0003\u001f\u0001")
public class ClusterLinkConfigTest {
    @Test
    public void testConfigCategories() {
        Set allProps = ClusterLinkConfig$.MODULE$.configNames().toSet();
        Set replicationProps = ClusterLinkConfig$.MODULE$.ReplicationProps();
        Set migrationProps = ClusterLinkConfig$.MODULE$.PeriodicTaskProps();
        Set linkProps = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.LinkModeProp(), ClusterLinkConfig$.MODULE$.ConnectionModeProp(), ClusterLinkConfig$.MODULE$.ClusterLinkPausedProp()}));
        Set reverseConnectionProps = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{ClusterLinkConfig$.MODULE$.LocalListenerNameProp(), ClusterLinkConfig$.MODULE$.ReverseConnectionSetupTimeoutMsProp()}));
        Set notCategorizedProps = (Set)allProps.$minus$minus((GenTraversableOnce)replicationProps).$minus$minus((GenTraversableOnce)migrationProps).$minus$minus((GenTraversableOnce)linkProps).$minus$minus((GenTraversableOnce)reverseConnectionProps).$minus$minus((GenTraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(AdminClientConfig.configNames()).asScala());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)notCategorizedProps);
    }

    @Test
    public void testDefaults() {
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:1234");
        ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)props);
        Assertions.assertEquals((Object)LinkMode.Destination$.MODULE$, (Object)linkConfig.linkMode());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.NumClusterLinkFetchers(), (Integer)linkConfig.numClusterLinkFetchers());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.ReplicaFetchMaxBytes(), (Integer)linkConfig.replicaFetchMaxBytes());
        Assertions.assertEquals((long)ClusterLinkConfigDefaults$.MODULE$.RetryBackoffMs(), (Long)linkConfig.metadataRefreshBackoffMs());
        Assertions.assertEquals((long)ClusterLinkConfigDefaults$.MODULE$.MetadataMaxAgeMs(), (Long)linkConfig.metadataMaxAgeMs());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.ReverseConnectionSetupTimeoutMs(), (Integer)linkConfig.reverseConnectionSetupTimeoutMs());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.RetryTimeoutMs(), (int)linkConfig.retryTimeoutMs());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.OffsetSyncMsDefault(), (Integer)linkConfig.consumerOffsetSyncMs());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.AclSyncMsDefault(), (Integer)linkConfig.aclSyncMs());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.TopicConfigSyncMsDefault(), (Integer)linkConfig.topicConfigSyncMs());
        Assertions.assertEquals((int)ClusterLinkConfigDefaults$.MODULE$.AvailabilityCheckMsDefault(), (Integer)linkConfig.availabilityCheckMs());
    }

    @Test
    public void testMigrationProps() {
        Properties props = new Properties();
        String aclFilter = new StringOps(Predef$.MODULE$.augmentString("|{\n         | \"aclFilters\": [{\n         |  \"resourceFilter\": {\n         |      \"resourceType\": \"any\",\n         |      \"patternType\": \"any\"\n         |    },\n         |  \"accessFilter\": {\n         |     \"operation\": \"any\",\n         |     \"permissionType\": \"any\"\n         |    }\n         |  }]\n         | }")).stripMargin();
        String groupFilter = new StringOps(Predef$.MODULE$.augmentString("|{\n         |\"groupFilters\": [\n         |  {\n         |     \"name\": \"*\",\n         |     \"patternType\": \"literal\",\n         |     \"filterType\": \"include\"\n         |  }\n         |]}")).stripMargin();
        String topicFilter = groupFilter.replaceAll("groupFilters", "topicFilters");
        props.setProperty("bootstrap.servers", "localhost:1234");
        props.setProperty(ClusterLinkConfig$.MODULE$.AutoMirroringEnableProp(), "true");
        props.setProperty(ClusterLinkConfig$.MODULE$.TopicFiltersProp(), topicFilter);
        props.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp(), "true");
        props.setProperty(ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp(), groupFilter);
        props.setProperty(ClusterLinkConfig$.MODULE$.AclSyncEnableProp(), "true");
        props.setProperty(ClusterLinkConfig$.MODULE$.AclFiltersProp(), aclFilter);
        ClusterLinkConfig destLinkConfig = ClusterLinkConfig$.MODULE$.create((Map)props);
        Assertions.assertTrue((boolean)destLinkConfig.autoMirroringEnable());
        Assertions.assertTrue((boolean)destLinkConfig.consumerOffsetSyncEnable());
        Assertions.assertTrue((boolean)destLinkConfig.aclSyncEnable());
        Assertions.assertNotEquals((Object)Option$.MODULE$.empty(), (Object)destLinkConfig.topicFilters());
        Assertions.assertNotEquals((Object)Option$.MODULE$.empty(), (Object)destLinkConfig.consumerGroupFilters());
        Assertions.assertNotEquals((Object)Option$.MODULE$.empty(), (Object)destLinkConfig.aclFilters());
        props.setProperty(ClusterLinkConfig$.MODULE$.LinkModeProp(), LinkMode.Source$.MODULE$.name());
        ClusterLinkConfig sourceLinkConfig = ClusterLinkConfig$.MODULE$.create((Map)props);
        Assertions.assertFalse((boolean)sourceLinkConfig.autoMirroringEnable());
        Assertions.assertFalse((boolean)sourceLinkConfig.consumerOffsetSyncEnable());
        Assertions.assertFalse((boolean)sourceLinkConfig.aclSyncEnable());
        Assertions.assertEquals((Object)Option$.MODULE$.empty(), (Object)sourceLinkConfig.topicFilters());
        Assertions.assertEquals((Object)Option$.MODULE$.empty(), (Object)sourceLinkConfig.consumerGroupFilters());
        Assertions.assertEquals((Object)Option$.MODULE$.empty(), (Object)sourceLinkConfig.aclFilters());
    }
}

