/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import kafka.controller.KafkaController;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ConnectionMode;
import kafka.server.link.LinkMode;
import kafka.utils.LogCaptureAppender;
import kafka.utils.LogCaptureAppender$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NetworkException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ReverseChannel;
import org.apache.kafka.common.network.ReverseNode;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tef\u0001B\u001c9\u0001}BQA\u0012\u0001\u0005\u0002\u001dCqA\u0013\u0001C\u0002\u0013%1\n\u0003\u0004Q\u0001\u0001\u0006I\u0001\u0014\u0005\b#\u0002\u0011\r\u0011\"\u0003S\u0011\u0019Y\u0006\u0001)A\u0005'\"9A\f\u0001b\u0001\n\u0013i\u0006B\u00023\u0001A\u0003%a\fC\u0004f\u0001\t\u0007I\u0011\u0002*\t\r\u0019\u0004\u0001\u0015!\u0003T\u0011\u001d9\u0007A1A\u0005\nICa\u0001\u001b\u0001!\u0002\u0013\u0019\u0006bB5\u0001\u0005\u0004%IA\u001b\u0005\u0007c\u0002\u0001\u000b\u0011B6\t\u000fI\u0004!\u0019!C\u0005g\"1q\u000f\u0001Q\u0001\nQDq\u0001\u001f\u0001C\u0002\u0013%\u0011\u0010\u0003\u0004\u0000\u0001\u0001\u0006IA\u001f\u0005\n\u0003\u0003\u0001!\u0019!C\u0005\u0003\u0007A\u0001\"a\u0003\u0001A\u0003%\u0011Q\u0001\u0005\n\u0003\u001b\u0001!\u0019!C\u0005\u0003\u001fA\u0001\"a\u000b\u0001A\u0003%\u0011\u0011\u0003\u0005\n\u0003[\u0001!\u0019!C\u0005\u0003_A\u0001\"!\u000f\u0001A\u0003%\u0011\u0011\u0007\u0005\n\u0003w\u0001!\u0019!C\u0005\u0003{A\u0001\"a\u0013\u0001A\u0003%\u0011q\b\u0005\n\u0003\u001b\u0002!\u0019!C\u0005\u0003\u001fB\u0001\"a\u0018\u0001A\u0003%\u0011\u0011\u000b\u0005\n\u0003C\u0002!\u0019!C\u0005\u0003GB\u0001\"a\u001f\u0001A\u0003%\u0011Q\r\u0005\f\u0003{\u0002\u0001\u0019!a\u0001\n\u0013\ty\bC\u0006\u0002\b\u0002\u0001\r\u00111A\u0005\n\u0005%\u0005bCAK\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0003C1\"a&\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001a\"Y\u0011\u0011\u0015\u0001A\u0002\u0003\u0007I\u0011BAR\u0011-\t9\u000b\u0001a\u0001\u0002\u0003\u0006K!a'\t\u0017\u0005%\u0006\u00011AA\u0002\u0013%\u00111\u0016\u0005\f\u0003g\u0003\u0001\u0019!a\u0001\n\u0013\t)\fC\u0006\u0002:\u0002\u0001\r\u0011!Q!\n\u00055\u0006bCA^\u0001\u0001\u0007\t\u0019!C\u0005\u0003{C1\"a0\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002B\"Y\u0011Q\u0019\u0001A\u0002\u0003\u0005\u000b\u0015BA;\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013Dq!!9\u0001\t\u0003\tI\rC\u0004\u0002l\u0002!\t!!3\t\u000f\u0005U\b\u0001\"\u0001\u0002J\"9\u0011\u0011 \u0001\u0005\u0002\u0005%\u0007bBA\u007f\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0005\u0003\u0001A\u0011AAe\u0011\u001d\u0011)\u0001\u0001C\u0005\u0005\u000fAqA!\u001a\u0001\t\u0013\u00119\u0007C\u0004\u0003j\u0001!IAa\u001b\t\u000f\t]\u0004\u0001\"\u0003\u0003z!9!1\u0011\u0001\u0005\n\t\u0015\u0005\"\u0003BQ\u0001E\u0005I\u0011\u0002BR\u0005\u0011\u001aE.^:uKJd\u0015N\\6EKN$8i\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:UKN$(BA\u001d;\u0003\u0011a\u0017N\\6\u000b\u0005mb\u0014AB:feZ,'OC\u0001>\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001!\u0011\u0005\u0005#U\"\u0001\"\u000b\u0003\r\u000bQa]2bY\u0006L!!\u0012\"\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001\n\u0005\u0002J\u00015\t\u0001(\u0001\u0007ce>\\WM]\"p]\u001aLw-F\u0001M!\tie*D\u0001;\u0013\ty%HA\u0006LC\u001a\\\u0017mQ8oM&<\u0017!\u00042s_.,'oQ8oM&<\u0007%\u0001\u0005mS:\\g*Y7f+\u0005\u0019\u0006C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\u0011a\u0017M\\4\u000b\u0003a\u000bAA[1wC&\u0011!,\u0016\u0002\u0007'R\u0014\u0018N\\4\u0002\u00131Lgn\u001b(b[\u0016\u0004\u0013A\u00027j].LE-F\u0001_!\ty&-D\u0001a\u0015\t\tw+\u0001\u0003vi&d\u0017BA2a\u0005\u0011)V+\u0013#\u0002\u000f1Lgn[%eA\u0005y1o\\;sG\u0016\u001cE.^:uKJLE-\u0001\tt_V\u00148-Z\"mkN$XM]%eA\u0005iA-Z:u\u00072,8\u000f^3s\u0013\u0012\fa\u0002Z3ti\u000ecWo\u001d;fe&#\u0007%\u0001\u0005mS:\\G)\u0019;b+\u0005Y\u0007C\u00017p\u001b\u0005i'B\u00018=\u0003\tQ8.\u0003\u0002q[\ny1\t\\;ti\u0016\u0014H*\u001b8l\t\u0006$\u0018-A\u0005mS:\\G)\u0019;bA\u0005IA.\u001b8l!J|\u0007o]\u000b\u0002iB\u0011q,^\u0005\u0003m\u0002\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0003)a\u0017N\\6Qe>\u00048\u000fI\u0001\u000bG>tGO]8mY\u0016\u0014X#\u0001>\u0011\u0005mlX\"\u0001?\u000b\u0005ad\u0014B\u0001@}\u0005=Y\u0015MZ6b\u0007>tGO]8mY\u0016\u0014\u0018aC2p]R\u0014x\u000e\u001c7fe\u0002\n1\u0002\\5oW6\u000bg.Y4feV\u0011\u0011Q\u0001\t\u0004\u0013\u0006\u001d\u0011bAA\u0005q\t\u00112\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0006t\u0017mZ3s\u00031a\u0017N\\6NC:\fw-\u001a:!\u0003)awnY1m\u0003\u0012l\u0017N\\\u000b\u0003\u0003#\u0001B!a\u0005\u0002(5\u0011\u0011Q\u0003\u0006\u0005\u0003/\tI\"A\u0003bI6LgN\u0003\u0003\u0002\u001c\u0005u\u0011aB2mS\u0016tGo\u001d\u0006\u0004{\u0005}!\u0002BA\u0011\u0003G\ta!\u00199bG\",'BAA\u0013\u0003\ry'oZ\u0005\u0005\u0003S\t)BA\bN_\u000e\\\u0017\tZ7j]\u000ec\u0017.\u001a8u\u0003-awnY1m\u0003\u0012l\u0017N\u001c\u0011\u0002\u001b9,Go^8sW\u000ec\u0017.\u001a8u+\t\t\t\u0004\u0005\u0003\u00024\u0005URBAA\r\u0013\u0011\t9$!\u0007\u0003\u001b9+Go^8sW\u000ec\u0017.\u001a8u\u00039qW\r^<pe.\u001cE.[3oi\u0002\nA#\u00193nS:lU\r^1eCR\fW*\u00198bO\u0016\u0014XCAA !\u0011\t\t%a\u0012\u000e\u0005\u0005\r#\u0002BA#\u0003+\t\u0011\"\u001b8uKJt\u0017\r\\:\n\t\u0005%\u00131\t\u0002\u0015\u0003\u0012l\u0017N\\'fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0002+\u0005$W.\u001b8NKR\fG-\u0019;b\u001b\u0006t\u0017mZ3sA\u00059Q.\u001a;sS\u000e\u001cXCAA)!\u0011\t\u0019&a\u0017\u000e\u0005\u0005U#\u0002BA'\u0003/RA!!\u0017\u0002\u001e\u000511m\\7n_:LA!!\u0018\u0002V\t9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\u001b\rdwn]3e\u00072LWM\u001c;t+\t\t)\u0007\u0005\u0004\u0002h\u0005E\u0014QO\u0007\u0003\u0003SRA!a\u001b\u0002n\u00059Q.\u001e;bE2,'bAA8\u0005\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0014\u0011\u000e\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000fE\u0002J\u0003oJ1!!\u001f9\u0005Y\u0019E.^:uKJd\u0015N\\6BI6Lgn\u00117jK:$\u0018AD2m_N,Gm\u00117jK:$8\u000fI\u0001\u000bY&t7nQ8oM&<WCAAA!\rI\u00151Q\u0005\u0004\u0003\u000bC$!E\"mkN$XM\u001d'j].\u001cuN\u001c4jO\u0006qA.\u001b8l\u0007>tg-[4`I\u0015\fH\u0003BAF\u0003#\u00032!QAG\u0013\r\tyI\u0011\u0002\u0005+:LG\u000fC\u0005\u0002\u0014~\t\t\u00111\u0001\u0002\u0002\u0006\u0019\u0001\u0010J\u0019\u0002\u00171Lgn[\"p]\u001aLw\rI\u0001\fY&t7.T3ue&\u001c7/\u0006\u0002\u0002\u001cB\u0019\u0011*!(\n\u0007\u0005}\u0005H\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\u0018a\u00047j].lU\r\u001e:jGN|F%Z9\u0015\t\u0005-\u0015Q\u0015\u0005\n\u0003'\u0013\u0013\u0011!a\u0001\u00037\u000bA\u0002\\5oW6+GO]5dg\u0002\n1bY8o]6\u000bg.Y4feV\u0011\u0011Q\u0016\t\u0004\u0013\u0006=\u0016bAAYq\t\u00013\t\\;ti\u0016\u0014H*\u001b8l\t\u0016\u001cHoQ8o]\u0016\u001cG/[8o\u001b\u0006t\u0017mZ3s\u0003=\u0019wN\u001c8NC:\fw-\u001a:`I\u0015\fH\u0003BAF\u0003oC\u0011\"a%&\u0003\u0003\u0005\r!!,\u0002\u0019\r|gN\\'b]\u0006<WM\u001d\u0011\u0002\u0017I,Wn\u001c;f\u0003\u0012l\u0017N\\\u000b\u0003\u0003k\nqB]3n_R,\u0017\tZ7j]~#S-\u001d\u000b\u0005\u0003\u0017\u000b\u0019\rC\u0005\u0002\u0014\"\n\t\u00111\u0001\u0002v\u0005a!/Z7pi\u0016\fE-\\5oA\u0005)1/\u001a;VaR\u0011\u00111\u0012\u0015\u0004U\u00055\u0007\u0003BAh\u0003;l!!!5\u000b\t\u0005M\u0017Q[\u0001\u0004CBL'\u0002BAl\u00033\fqA[;qSR,'O\u0003\u0003\u0002\\\u0006\r\u0012!\u00026v]&$\u0018\u0002BAp\u0003#\u0014!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007fA\u0016\u0002fB!\u0011qZAt\u0013\u0011\tI/!5\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u0007;fgR\u001cuN\u001c8fGRLwN\\'pI\u0016|U\u000f\u001e2pk:$\u0007f\u0001\u0017\u0002pB!\u0011qZAy\u0013\u0011\t\u00190!5\u0003\tQ+7\u000f^\u0001\u001ai\u0016\u001cHoQ8o]\u0016\u001cG/[8o\u001b>$W-\u00138c_VtG\rK\u0002.\u0003_\fq\u0004^3tiB+'o]5ti\u0016tGoQ8o]\u0016\u001cG/[8o\r\u0006LG.\u001e:fQ\rq\u0013q^\u0001\u0010i\u0016\u001cHOU3d_:4\u0017nZ;sK\"\u001aq&a<\u0002\u0019Q,7\u000f\u001e'pO2+g/\u001a7)\u0007A\ny/\u0001\bwKJLg-\u001f'pO2+g/\u001a7\u0015\u0011\u0005-%\u0011\u0002B\u001e\u0005\u0017BqAa\u00032\u0001\u0004\u0011i!A\u0003dY\u0006T(\u0010\r\u0003\u0003\u0010\t%\u0002C\u0002B\t\u0005?\u0011)C\u0004\u0003\u0003\u0014\tm\u0001c\u0001B\u000b\u00056\u0011!q\u0003\u0006\u0004\u00053q\u0014A\u0002\u001fs_>$h(C\u0002\u0003\u001e\t\u000ba\u0001\u0015:fI\u00164\u0017\u0002\u0002B\u0011\u0005G\u0011Qa\u00117bgNT1A!\bC!\u0011\u00119C!\u000b\r\u0001\u0011a!1\u0006B\u0005\u0003\u0003\u0005\tQ!\u0001\u0003.\t\u0019q\fJ\u0019\u0012\t\t=\"Q\u0007\t\u0004\u0003\nE\u0012b\u0001B\u001a\u0005\n9aj\u001c;iS:<\u0007cA!\u00038%\u0019!\u0011\b\"\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003>E\u0002\rAa\u0010\u0002\u0011\u0005\u0004\b/\u001a8eKJ\u0004BA!\u0011\u0003H5\u0011!1\t\u0006\u0004\u0005\u000bb\u0014!B;uS2\u001c\u0018\u0002\u0002B%\u0005\u0007\u0012!\u0003T8h\u0007\u0006\u0004H/\u001e:f\u0003B\u0004XM\u001c3fe\"9!QJ\u0019A\u0002\t=\u0013aC7bq2{w\rT3wK2\u0004R!\u0011B)\u0005+J1Aa\u0015C\u0005\u0019y\u0005\u000f^5p]B!!q\u000bB1\u001b\t\u0011IF\u0003\u0003\u0003\\\tu\u0013!B3wK:$(\u0002\u0002B0\u0003G\tQa\u001d7gi)LAAa\u0019\u0003Z\t)A*\u001a<fY\u0006\u00112M]3bi\u0016\u0014%o\\6fe\u000e{gNZ5h)\u0005a\u0015AF:fiV\u00048i\u001c8oK\u000e$\u0018n\u001c8NC:\fw-\u001a:\u0015\t\u0005-%Q\u000e\u0005\b\u0005_\u001a\u0004\u0019\u0001B9\u00039\u0019wN\u001c8fGRLwN\\'pI\u0016\u00042!\u0013B:\u0013\r\u0011)\b\u000f\u0002\u000f\u0007>tg.Z2uS>tWj\u001c3f\u0003E\u0019'/Z1uKJ+Wn\u001c;f\u0003\u0012l\u0017N\u001c\u000b\u0007\u0003k\u0012YHa \t\u000f\tuD\u00071\u0001\u0002\u0002\u000611m\u001c8gS\u001eDqA!!5\u0001\u0004\ti+A\u0004nC:\fw-\u001a:\u0002\u0017I,g/\u001a:tK:{G-\u001a\u000b\u0007\u0005\u000f\u0013\u0019J!(\u0011\t\t%%qR\u0007\u0003\u0005\u0017SAA!$\u0002X\u00059a.\u001a;x_J\\\u0017\u0002\u0002BI\u0005\u0017\u00131BU3wKJ\u001cXMT8eK\"9!QS\u001bA\u0002\t]\u0015A\u00028pI\u0016LE\rE\u0002B\u00053K1Aa'C\u0005\rIe\u000e\u001e\u0005\n\u0005?+\u0004\u0013!a\u0001\u0005/\u000b\u0011B]3rk\u0016\u001cH/\u00133\u0002+I,g/\u001a:tK:{G-\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u0015\u0016\u0005\u0005/\u00139k\u000b\u0002\u0003*B!!1\u0016B[\u001b\t\u0011iK\u0003\u0003\u00030\nE\u0016!C;oG\",7m[3e\u0015\r\u0011\u0019LQ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\\\u0005[\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class ClusterLinkDestConnectionManagerTest {
    private final KafkaConfig brokerConfig = this.createBrokerConfig();
    private final String linkName;
    private final UUID linkId = UUID.randomUUID();
    private final String sourceClusterId;
    private final String destClusterId;
    private final ClusterLinkData linkData = new ClusterLinkData(this.linkName(), this.linkId(), (Option)new Some((Object)this.sourceClusterId()), (Option)None$.MODULE$, false);
    private final Properties linkProps = new Properties();
    private final KafkaController controller = (KafkaController)EasyMock.createNiceMock(KafkaController.class);
    private final ClusterLinkManager linkManager = (ClusterLinkManager)EasyMock.createNiceMock(ClusterLinkManager.class);
    private final MockAdminClient localAdmin = new MockAdminClient();
    private final NetworkClient networkClient = (NetworkClient)EasyMock.createNiceMock(NetworkClient.class);
    private final AdminMetadataManager adminMetadataManager = new AdminMetadataManager(new LogContext(), 100L, 10000L);
    private final Metrics metrics = new Metrics();
    private final ArrayBuffer<ClusterLinkAdminClient> closedClients = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
    private ClusterLinkConfig linkConfig;
    private ClusterLinkMetrics linkMetrics;
    private ClusterLinkDestConnectionManager connManager;
    private ClusterLinkAdminClient remoteAdmin;

    private KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    private String linkName() {
        return this.linkName;
    }

    private UUID linkId() {
        return this.linkId;
    }

    private String sourceClusterId() {
        return this.sourceClusterId;
    }

    private String destClusterId() {
        return this.destClusterId;
    }

    private ClusterLinkData linkData() {
        return this.linkData;
    }

    private Properties linkProps() {
        return this.linkProps;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private ClusterLinkManager linkManager() {
        return this.linkManager;
    }

    private MockAdminClient localAdmin() {
        return this.localAdmin;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    private AdminMetadataManager adminMetadataManager() {
        return this.adminMetadataManager;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private ArrayBuffer<ClusterLinkAdminClient> closedClients() {
        return this.closedClients;
    }

    private ClusterLinkConfig linkConfig() {
        return this.linkConfig;
    }

    private void linkConfig_$eq(ClusterLinkConfig x$1) {
        this.linkConfig = x$1;
    }

    private ClusterLinkMetrics linkMetrics() {
        return this.linkMetrics;
    }

    private void linkMetrics_$eq(ClusterLinkMetrics x$1) {
        this.linkMetrics = x$1;
    }

    private ClusterLinkDestConnectionManager connManager() {
        return this.connManager;
    }

    private void connManager_$eq(ClusterLinkDestConnectionManager x$1) {
        this.connManager = x$1;
    }

    private ClusterLinkAdminClient remoteAdmin() {
        return this.remoteAdmin;
    }

    private void remoteAdmin_$eq(ClusterLinkAdminClient x$1) {
        this.remoteAdmin = x$1;
    }

    @BeforeEach
    public void setUp() {
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.controller()});
    }

    @AfterEach
    public void tearDown() {
        if (this.connManager() != null) {
            this.connManager().shutdown();
        }
        this.metrics().close();
    }

    @Test
    public void testConnectionModeOutbound() {
        this.setupConnectionManager((ConnectionMode)ConnectionMode.Outbound$.MODULE$);
        Assertions.assertNull((Object)this.remoteAdmin());
        this.connManager().startup();
        Assertions.assertNull((Object)this.remoteAdmin());
        KafkaChannel channel = (KafkaChannel)EasyMock.createNiceMock(KafkaChannel.class);
        Assertions.assertThrows(InvalidRequestException.class, () -> this.connManager().processReverseConnection(channel, this.reverseNode(1, this.reverseNode$default$2())));
    }

    @Test
    public void testConnectionModeInbound() {
        this.setupConnectionManager((ConnectionMode)ConnectionMode.Inbound$.MODULE$);
        Assertions.assertNull((Object)this.remoteAdmin());
        this.connManager().startup();
        Assertions.assertNotNull((Object)this.remoteAdmin());
        Assertions.assertTrue((boolean)this.connManager().reverseConnectionProvider(this.networkClient(), (Option)new Some((Object)this.adminMetadataManager()), "").nonEmpty());
        KafkaChannel channel = (KafkaChannel)EasyMock.createNiceMock(KafkaChannel.class);
        ReverseNode node1 = this.reverseNode(1, -1);
        this.connManager().processReverseConnection(channel, node1);
        Assertions.assertEquals((int)1, (int)this.connManager().persistentConnectionCount());
        Assertions.assertEquals((int)1, (int)this.connManager().reverseConnectionCount());
        ReverseNode node2 = this.reverseNode(2, 5);
        Assertions.assertThrows(NetworkException.class, () -> this.connManager().processReverseConnection(channel, node2));
        Assertions.assertEquals((int)1, (int)this.connManager().persistentConnectionCount());
        Assertions.assertEquals((int)1, (int)this.connManager().reverseConnectionCount());
    }

    @Test
    public void testPersistentConnectionFailure() {
        this.setupConnectionManager((ConnectionMode)ConnectionMode.Inbound$.MODULE$);
        this.connManager().startup();
        KafkaChannel channel = (KafkaChannel)EasyMock.createNiceMock(KafkaChannel.class);
        channel.close();
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        EasyMock.replay((Object[])new Object[]{channel});
        ReverseNode node = this.reverseNode(1, -1);
        this.networkClient().reverseAndAdd((ReverseChannel)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andThrow((Throwable)new RuntimeException("Test exception")).once();
        EasyMock.replay((Object[])new Object[]{this.networkClient()});
        Assertions.assertThrows(RuntimeException.class, () -> this.connManager().processReverseConnection(channel, node));
    }

    @Test
    public void testReconfigure() {
        this.setupConnectionManager((ConnectionMode)ConnectionMode.Inbound$.MODULE$);
        this.connManager().startup();
        ClusterLinkAdminClient oldAdmin = this.remoteAdmin();
        this.linkProps().setProperty("metadata.max.age.ms", "1000");
        this.linkConfig_$eq(ClusterLinkConfig$.MODULE$.create((Map)this.linkProps()));
        this.connManager().reconfigure(this.linkConfig(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"metadata.max.age.ms"})));
        Assertions.assertEquals((Object)this.connManager().currentConfig().originals(), (Object)this.linkConfig().originals());
        Assertions.assertNotNull((Object)this.remoteAdmin());
        Assertions.assertNotSame((Object)oldAdmin, (Object)this.remoteAdmin());
        Assertions.assertEquals((Object)new .colon.colon((Object)oldAdmin, (List)Nil$.MODULE$), (Object)this.closedClients().toSeq());
    }

    @Test
    public void testLogLevel() {
        Class<ClusterLinkDestConnectionManager> clazz = ClusterLinkDestConnectionManager.class;
        Level oldLevel = LogCaptureAppender$.MODULE$.setClassLoggerLevel(clazz, Level.ALL);
        LogCaptureAppender appender = LogCaptureAppender$.MODULE$.createAndRegister();
        try {
            this.verifyLogLevel(clazz, appender, (Option<org.slf4j.event.Level>)None$.MODULE$);
            this.verifyLogLevel(clazz, appender, (Option<org.slf4j.event.Level>)new Some(null));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])org.slf4j.event.Level.values())).foreach((Function1 & Serializable & scala.Serializable)level -> {
                this.verifyLogLevel(clazz, appender, (Option<org.slf4j.event.Level>)new Some((Object)level));
                return BoxedUnit.UNIT;
            });
        }
        finally {
            LogCaptureAppender$.MODULE$.unregister(appender);
            LogCaptureAppender$.MODULE$.setClassLoggerLevel(clazz, oldLevel);
            appender.close();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void verifyLogLevel(Class<?> clazz, LogCaptureAppender appender, Option<org.slf4j.event.Level> maxLogLevel) {
        currentMaxLevel = new AtomicReference<V>();
        if (maxLogLevel instanceof Some) {
            var5_5 = new LogContext("[TEST] ", currentMaxLevel);
        } else if (None$.MODULE$.equals(maxLogLevel)) {
            var5_5 = new LogContext("[TEST] ");
        } else {
            throw new MatchError(maxLogLevel);
        }
        logger = var5_5.logger(clazz);
        var8_7 = false;
        var9_8 = null;
        if (!(maxLogLevel instanceof Some)) ** GOTO lbl-1000
        var8_7 = true;
        var9_8 = (Some)maxLogLevel;
        if ((org.slf4j.event.Level)var9_8.value() == null) {
            var4_9 = org.slf4j.event.Level.ERROR;
        } else if (var8_7) {
            var4_9 = (org.slf4j.event.Level)var9_8.value();
        } else if (None$.MODULE$.equals(maxLogLevel)) {
            var4_9 = org.slf4j.event.Level.ERROR;
        } else {
            throw new MatchError(maxLogLevel);
        }
        maxLogLevel.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$verifyLogLevel$1$adapted(java.util.concurrent.atomic.AtomicReference org.slf4j.event.Level ), (Lorg/slf4j/event/Level;)Ljava/lang/Object;)(currentMaxLevel));
        logger.trace("trace message");
        ClusterLinkDestConnectionManagerTest.assertLastLog$1(org.slf4j.event.Level.TRACE, "[TEST] trace message", appender, var4_9);
        logger.debug("debug message");
        ClusterLinkDestConnectionManagerTest.assertLastLog$1(org.slf4j.event.Level.DEBUG, "[TEST] debug message", appender, var4_9);
        logger.info("info message");
        ClusterLinkDestConnectionManagerTest.assertLastLog$1(org.slf4j.event.Level.INFO, "[TEST] info message", appender, var4_9);
        logger.warn("warn message");
        ClusterLinkDestConnectionManagerTest.assertLastLog$1(org.slf4j.event.Level.WARN, "[TEST] warn message", appender, var4_9);
        logger.error("error message");
        ClusterLinkDestConnectionManagerTest.assertLastLog$1(org.slf4j.event.Level.ERROR, "[TEST] error message", appender, var4_9);
    }

    private KafkaConfig createBrokerConfig() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    private void setupConnectionManager(ConnectionMode connectionMode) {
        this.linkProps().put(ClusterLinkConfig$.MODULE$.ConnectionModeProp(), connectionMode.name());
        if (ConnectionMode.Outbound$.MODULE$.equals(connectionMode)) {
            this.linkProps().put("bootstrap.servers", "localhost:123");
        }
        this.linkConfig_$eq(ClusterLinkConfig$.MODULE$.create((Map)this.linkProps()));
        this.linkMetrics_$eq(new ClusterLinkMetrics(this.linkName(), this.linkId(), (LinkMode)LinkMode.Destination$.MODULE$, this.linkManager(), (Option)None$.MODULE$, this.metrics(), (Option)None$.MODULE$));
        this.linkMetrics().startup();
        this.connManager_$eq(new ClusterLinkDestConnectionManager(this.linkData(), this.linkConfig(), this.destClusterId(), (Option)None$.MODULE$, this.linkMetrics(), (Function2 & Serializable & scala.Serializable)(config, manager) -> this.createRemoteAdmin((ClusterLinkConfig)config, (ClusterLinkDestConnectionManager)manager), (Option)new Some((Object)this.localAdmin()), this.controller(), this.brokerConfig(), (Time)new MockTime()));
    }

    private ClusterLinkAdminClient createRemoteAdmin(ClusterLinkConfig config, ClusterLinkDestConnectionManager manager) {
        Assertions.assertEquals((Object)this.linkConfig().originals(), (Object)config.originals());
        Assertions.assertSame((Object)this.connManager(), (Object)manager);
        this.remoteAdmin_$eq((ClusterLinkAdminClient)EasyMock.createNiceMock(ClusterLinkAdminClient.class));
        this.remoteAdmin().close();
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer(() -> {
            ClusterLinkDestConnectionManagerTest.$anonfun$createRemoteAdmin$1(this);
            return BoxedUnit.UNIT;
        }).anyTimes();
        EasyMock.expect((Object)this.remoteAdmin().networkClient()).andReturn((Object)this.networkClient()).anyTimes();
        EasyMock.expect((Object)this.remoteAdmin().metadataManager()).andReturn((Object)this.adminMetadataManager()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.remoteAdmin()});
        return this.remoteAdmin();
    }

    private ReverseNode reverseNode(int nodeId, int requestId) {
        return new ReverseNode(nodeId, nodeId, new StringBuilder(4).append("host").append(nodeId).toString(), 1234, this.linkId(), requestId, ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), KafkaPrincipal.ANONYMOUS);
    }

    private int reverseNode$default$2() {
        return -1;
    }

    private static final void assertLastLog$1(org.slf4j.event.Level logLevel, String expectedMessage, LogCaptureAppender appender$2, org.slf4j.event.Level maxLevel$1) {
        LoggingEvent event = (LoggingEvent)appender$2.getMessages().last();
        Assertions.assertEquals((Object)(maxLevel$1.toInt() < logLevel.toInt() ? maxLevel$1 : logLevel).name(), (Object)event.getLevel().toString());
        Assertions.assertEquals((Object)expectedMessage, (Object)event.getMessage());
    }

    public static final /* synthetic */ void $anonfun$createRemoteAdmin$1(ClusterLinkDestConnectionManagerTest $this) {
        $this.closedClients().$plus$eq((Object)$this.remoteAdmin());
    }

    public ClusterLinkDestConnectionManagerTest() {
        this.linkName = "testLink";
        this.sourceClusterId = "sourceCluster";
        this.destClusterId = "destCluster";
    }

    public static final /* synthetic */ Object $anonfun$verifyLogLevel$1$adapted(AtomicReference currentMaxLevel$1, org.slf4j.event.Level x$1) {
        currentMaxLevel$1.set(x$1);
        return BoxedUnit.UNIT;
    }
}

