/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import kafka.cluster.Partition;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.MetadataCache$;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDisabled;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFactory$;
import kafka.utils.TestUtils$;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.NewClusterLink;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterLinkDisabledException;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\f\u0019\u0001}AQA\n\u0001\u0005\u0002\u001dBqA\u000b\u0001C\u0002\u0013%1\u0006\u0003\u00049\u0001\u0001\u0006I\u0001\f\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019\t\u0005\u0001)A\u0005w!9!\t\u0001b\u0001\n\u0013\u0019\u0005B\u0002%\u0001A\u0003%A\tC\u0004J\u0001\t\u0007I\u0011\u0002&\t\rE\u0003\u0001\u0015!\u0003L\u0011\u001d\u0011\u0006A1A\u0005\nMCaa\u0016\u0001!\u0002\u0013!\u0006\"\u0003-\u0001\u0001\u0004\u0005\r\u0011\"\u0003Z\u0011%\t\u0007\u00011AA\u0002\u0013%!\rC\u0005i\u0001\u0001\u0007\t\u0011)Q\u00055\")\u0011\u000e\u0001C\u0001U\")a\u000f\u0001C\u0001U\")1\u0010\u0001C\u0001U\"1\u0011\u0011\u0001\u0001\u0005\u0002)Dq!!\u0002\u0001\t\u0013\t9\u0001C\u0004\u0002\u001a\u0001!I!a\u0007\t\u000f\u0005M\u0003\u0001\"\u0003\u0002V!9\u00111\f\u0001\u0005\n\u0005u#AF\"mkN$XM\u001d'j].4\u0015m\u0019;pef$Vm\u001d;\u000b\u0005eQ\u0012\u0001\u00027j].T!a\u0007\u000f\u0002\rM,'O^3s\u0015\u0005i\u0012!B6bM.\f7\u0001A\n\u0003\u0001\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001)!\tI\u0003!D\u0001\u0019\u0003\u001diW\r\u001e:jGN,\u0012\u0001\f\t\u0003[Yj\u0011A\f\u0006\u0003U=R!\u0001M\u0019\u0002\r\r|W.\\8o\u0015\ti\"G\u0003\u00024i\u00051\u0011\r]1dQ\u0016T\u0011!N\u0001\u0004_J<\u0017BA\u001c/\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\u0005i&lW-F\u0001<!\tat(D\u0001>\u0015\tqt&A\u0003vi&d7/\u0003\u0002A{\tAQj\\2l)&lW-A\u0003uS6,\u0007%\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0003\u0011\u0003\"!\u0012$\u000e\u0003iI!a\u0012\u000e\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\u0006y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%\u0001\u0005{W\u000ec\u0017.\u001a8u+\u0005Y\u0005C\u0001'P\u001b\u0005i%B\u0001(\u001d\u0003\tQ8.\u0003\u0002Q\u001b\ni1*\u00194lCj[7\t\\5f]R\f\u0011B_6DY&,g\u000e\u001e\u0011\u0002\u001b5,G/\u00193bi\u0006\u001c\u0015m\u00195f+\u0005!\u0006CA#V\u0013\t1&DA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.Z\u0001\u000f[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3!\u0003I\u0019G.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0016\u0003i\u0003\"a\u00170\u000f\u0005%b\u0016BA/\u0019\u0003I\u0019E.^:uKJd\u0015N\\6GC\u000e$xN]=\n\u0005}\u0003'a\u0003'j].l\u0015M\\1hKJT!!\u0018\r\u0002-\rdWo\u001d;fe2Kgn['b]\u0006<WM]0%KF$\"a\u00194\u0011\u0005\u0005\"\u0017BA3#\u0005\u0011)f.\u001b;\t\u000f\u001dl\u0011\u0011!a\u00015\u0006\u0019\u0001\u0010J\u0019\u0002'\rdWo\u001d;fe2Kgn['b]\u0006<WM\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0003\rD#a\u00047\u0011\u00055$X\"\u00018\u000b\u0005=\u0004\u0018aA1qS*\u0011\u0011O]\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u0019H'A\u0003kk:LG/\u0003\u0002v]\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D#\u0001\u0005=\u0011\u00055L\u0018B\u0001>o\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0014uKN$H*\u001b8l\u001b\u0006t\u0017mZ3s/&$\bn\u00117vgR,'\u000fT5oW\u0012K7/\u00192mK\u0012D#!E?\u0011\u00055t\u0018BA@o\u0005\u0011!Vm\u001d;\u0002OQ,7\u000f^!e[&tW*\u00198bO\u0016\u0014x+\u001b;i\u00072,8\u000f^3s\u0019&t7\u000eR5tC\ndW\r\u001a\u0015\u0003%u\f!c\u0019:fCR,'I]8lKJ\u001cuN\u001c4jOR!\u0011\u0011BA\b!\r)\u00151B\u0005\u0004\u0003\u001bQ\"aC&bM.\f7i\u001c8gS\u001eDq!!\u0005\u0014\u0001\u0004\t\u0019\"A\tf]\u0006\u0014G.Z\"mkN$XM\u001d'j].\u00042!IA\u000b\u0013\r\t9B\t\u0002\b\u0005>|G.Z1o\u0003%\u0019X\r^;q\u001b>\u001c7\u000eF\u0004d\u0003;\ti#!\u000f\t\u000f\u0005}A\u00031\u0001\u0002\"\u0005I\u0001/\u0019:uSRLwN\u001c\t\u0005\u0003G\tI#\u0004\u0002\u0002&)\u0019\u0011q\u0005\u000f\u0002\u000f\rdWo\u001d;fe&!\u00111FA\u0013\u0005%\u0001\u0016M\u001d;ji&|g\u000eC\u0004\u00020Q\u0001\r!!\r\u0002\u0005Q\u0004\b\u0003BA\u001a\u0003ki\u0011aL\u0005\u0004\u0003oy#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003w!\u0002\u0019AA\u001f\u0003\u0019a\u0017N\\6JIB)\u0011%a\u0010\u0002D%\u0019\u0011\u0011\t\u0012\u0003\r=\u0003H/[8o!\u0011\t)%a\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\nA!\u001e;jY*\u0011\u0011QJ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002R\u0005\u001d#\u0001B+V\u0013\u0012\u000b\u0001d\u0019:fCR,7\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0006t\u0017mZ3s)\rQ\u0016q\u000b\u0005\b\u00033*\u0002\u0019AA\u0005\u00031\u0011'o\\6fe\u000e{gNZ5h\u0003e1XM]5gs\u000ecWo\u001d;fe2Kgn\u001b#jg\u0006\u0014G.\u001a3\u0015\u0007\r\fy\u0006C\u0004\u0002bY\u0001\r!a\u0019\u0002\u0011I,hN\\1cY\u0016\u0004B!!\u001a\u0002l5\u0011\u0011q\r\u0006\u0004\u0003Sr\u0017\u0001\u00034v]\u000e$\u0018n\u001c8\n\t\u00055\u0014q\r\u0002\u000b\u000bb,7-\u001e;bE2,\u0007")
public class ClusterLinkFactoryTest {
    private final Metrics metrics = new Metrics();
    private final MockTime time = new MockTime();
    private final ReplicaManager replicaManager = (ReplicaManager)EasyMock.mock(ReplicaManager.class);
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private final MetadataCache metadataCache = MetadataCache$.MODULE$.zkMetadataCache(0, MetadataCache$.MODULE$.zkMetadataCache$default$2());
    private ClusterLinkFactory.LinkManager clusterLinkManager;

    private Metrics metrics() {
        return this.metrics;
    }

    private MockTime time() {
        return this.time;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    private void clusterLinkManager_$eq(ClusterLinkFactory.LinkManager x$1) {
        this.clusterLinkManager = x$1;
    }

    @BeforeEach
    public void setUp() {
        EasyMock.expect((Object)this.replicaManager().metadataCache()).andReturn((Object)this.metadataCache()).anyTimes();
        EasyMock.expect((Object)this.replicaManager().zkClient()).andReturn((Object)new Some((Object)this.zkClient())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
    }

    @AfterEach
    public void tearDown() {
        this.clusterLinkManager().shutdown();
        this.metrics().close();
    }

    @Test
    public void testLinkManagerWithClusterLinkDisabled() {
        String linkName = "testLink";
        UUID linkId = UUID.randomUUID();
        KafkaConfig brokerConfig = this.createBrokerConfig(false);
        this.clusterLinkManager_$eq(this.createClusterLinkManager(brokerConfig));
        Assertions.assertTrue((boolean)(this.clusterLinkManager() instanceof ClusterLinkDisabled.LinkManager));
        Assertions.assertTrue((boolean)(this.clusterLinkManager().admin() instanceof ClusterLinkDisabled.AdminManager));
        this.verifyClusterLinkDisabled(() -> this.clusterLinkManager().configEncoder());
        this.verifyClusterLinkDisabled(() -> this.clusterLinkManager().createClusterLink(new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false), ClusterLinkConfig$.MODULE$.create((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.empty()).asJava()), new Properties()));
        this.verifyClusterLinkDisabled(() -> this.clusterLinkManager().listClusterLinks());
        this.verifyClusterLinkDisabled(() -> this.clusterLinkManager().updateClusterLinkConfig(linkName, (Function1 & Serializable & scala.Serializable)props -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkFactoryTest.$anonfun$testLinkManagerWithClusterLinkDisabled$5(props))));
        this.verifyClusterLinkDisabled(() -> this.clusterLinkManager().deleteClusterLink(linkName, linkId));
        this.verifyClusterLinkDisabled(() -> this.clusterLinkManager().fetcherManager(linkId));
        this.verifyClusterLinkDisabled(() -> this.clusterLinkManager().clientManager(linkId));
        this.verifyClusterLinkDisabled(() -> this.clusterLinkManager().resolveLinkId(linkName));
        this.verifyClusterLinkDisabled(() -> this.clusterLinkManager().resolveLinkIdOrThrow(linkName));
        this.verifyClusterLinkDisabled(() -> this.clusterLinkManager().ensureLinkNameDoesntExist(linkName));
        Assertions.assertTrue((boolean)this.clusterLinkManager().controllerListener().isEmpty());
        this.clusterLinkManager().processClusterLinkChanges(linkId, new Properties());
        this.verifyClusterLinkDisabled(() -> this.clusterLinkManager().fetcherManager(linkId));
        TopicPartition tp0 = new TopicPartition("topic", 0);
        Partition partition0 = (Partition)EasyMock.createNiceMock(Partition.class);
        this.setupMock(partition0, tp0, (Option<UUID>)new Some((Object)linkId));
        this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0})));
        this.verifyClusterLinkDisabled(() -> this.clusterLinkManager().fetcherManager(linkId));
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = (LeaderAndIsrRequestData.LeaderAndIsrPartitionState)EasyMock.mock(LeaderAndIsrRequestData.LeaderAndIsrPartitionState.class);
        this.clusterLinkManager().removePartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)partitionState)})));
        this.clusterLinkManager().removePartitionsAndMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0})));
        this.clusterLinkManager().startup(null, null, null, null, null, (Option)None$.MODULE$);
        this.clusterLinkManager().shutdownIdleFetcherThreads();
        this.clusterLinkManager().shutdown();
    }

    @Test
    public void testAdminManagerWithClusterLinkDisabled() {
        String linkName = "testLink";
        KafkaConfig brokerConfig = this.createBrokerConfig(false);
        this.clusterLinkManager_$eq(this.createClusterLinkManager(brokerConfig));
        ClusterLinkFactory.AdminManager admin = this.clusterLinkManager().admin();
        Assertions.assertTrue((boolean)(this.clusterLinkManager().admin() instanceof ClusterLinkDisabled.AdminManager));
        NewClusterLink newClusterLink = new NewClusterLink(linkName, "cluster1", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)"localhost:1234")}))).asJava());
        this.verifyClusterLinkDisabled(() -> admin.createClusterLink(newClusterLink, (Option)None$.MODULE$, new ListenerName("EXTERNAL"), true, false, 10000, 1));
        this.verifyClusterLinkDisabled(() -> admin.deleteClusterLink(linkName, true, true, 1));
        this.verifyClusterLinkDisabled(() -> admin.listClusterLinks((Option)None$.MODULE$, false, 3));
        this.verifyClusterLinkDisabled(() -> admin.alterMirror("topic", AlterMirrorOp.PROMOTE, true, 3));
    }

    private KafkaConfig createBrokerConfig(boolean enableClusterLink) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), Boolean.toString(enableClusterLink));
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    private void setupMock(Partition partition, TopicPartition tp, Option<UUID> linkId) {
        EasyMock.reset((Object[])new Object[]{partition});
        EasyMock.expect((Object)partition.topicPartition()).andReturn((Object)tp).anyTimes();
        EasyMock.expect((Object)partition.getClusterLinkId()).andReturn(linkId).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)partition.isActiveLinkDestinationLeader())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)linkId.nonEmpty())).anyTimes();
        EasyMock.expect((Object)partition.getLinkedLeaderEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))).anyTimes();
        EasyMock.replay((Object[])new Object[]{partition});
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkFactory.LinkManager createClusterLinkManager(KafkaConfig brokerConfig) {
        void var2_2;
        ClusterLinkFactory.LinkManager manager = ClusterLinkFactory$.MODULE$.createLinkManager(brokerConfig, "clusterId", (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, this.zkClient(), this.metrics(), (Time)this.time(), ClusterLinkFactory$.MODULE$.createLinkManager$default$7());
        Endpoint brokerEndpoint = new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 1234);
        AuthorizerServerInfo serverInfo = (AuthorizerServerInfo)EasyMock.mock(AuthorizerServerInfo.class);
        EasyMock.expect((Object)serverInfo.interBrokerEndpoint()).andReturn((Object)brokerEndpoint).anyTimes();
        EasyMock.replay((Object[])new Object[]{serverInfo});
        manager.startup(serverInfo, null, null, null, null, (Option)None$.MODULE$);
        return var2_2;
    }

    private void verifyClusterLinkDisabled(Executable runnable) {
        Assertions.assertThrows(ClusterLinkDisabledException.class, (Executable)runnable);
    }

    public static final /* synthetic */ boolean $anonfun$testLinkManagerWithClusterLinkDisabled$5(Properties props) {
        return false;
    }
}

