/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import kafka.cluster.ClusterLinkState;
import kafka.cluster.IsrState;
import kafka.cluster.Partition;
import kafka.common.KafkaException;
import kafka.controller.KafkaController;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.FetcherPool;
import kafka.server.FetcherTag;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.MetadataCache$;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkConfigDefaults$;
import kafka.server.link.ClusterLinkDestConnectionManager;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFactory$;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkFetcherThread;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.FailedClusterLink$;
import kafka.server.link.FetchResponseSize;
import kafka.server.link.LinkMode;
import kafka.server.link.MirrorTopicConfigSyncRules$;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkState;
import kafka.utils.KafkaScheduler;
import kafka.utils.TestUtils$;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ClusterLinkExistsException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.test.TestUtils;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Eh\u0001\u0002\u0016,\u0001IBQ!\u000f\u0001\u0005\u0002iBq!\u0010\u0001C\u0002\u0013%a\b\u0003\u0004D\u0001\u0001\u0006Ia\u0010\u0005\b\t\u0002\u0011\r\u0011\"\u0003F\u0011\u0019\u0011\u0006\u0001)A\u0005\r\"91\u000b\u0001b\u0001\n\u0013!\u0006BB.\u0001A\u0003%Q\u000bC\u0004]\u0001\t\u0007I\u0011B/\t\r\u0005\u0004\u0001\u0015!\u0003_\u0011\u001d\u0011\u0007A1A\u0005\n\rDa!\u001b\u0001!\u0002\u0013!\u0007b\u00026\u0001\u0005\u0004%Ia\u001b\u0005\u0007e\u0002\u0001\u000b\u0011\u00027\t\u000fM\u0004!\u0019!C\u0005i\"1\u0001\u0010\u0001Q\u0001\nUD\u0011\"\u001f\u0001A\u0002\u0003\u0007I\u0011\u0002>\t\u0013y\u0004\u0001\u0019!a\u0001\n\u0013y\bBCA\u0006\u0001\u0001\u0007\t\u0011)Q\u0005w\"I\u0011Q\u0002\u0001C\u0002\u0013%\u0011q\u0002\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u0012!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0002bBA\"\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003\u001b\u0002A\u0011AA\u0016\u0011\u001d\t9\u0006\u0001C\u0001\u0003WAq!a\u0017\u0001\t\u0003\tY\u0003C\u0004\u0002`\u0001!\t!a\u000b\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002,!9\u00111\r\u0001\u0005\u0002\u0005-\u0002bBA3\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003O\u0002A\u0011AA\u0016\u0011\u001d\tI\u0007\u0001C\u0001\u0003WBq!!(\u0001\t\u0003\tY\u0003C\u0004\u0002\"\u0002!\t!a\u000b\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002,!9\u0011\u0011\u0016\u0001\u0005\u0002\u0005-\u0002bBAW\u0001\u0011\u0005\u00111\u0006\u0005\b\u0003c\u0003A\u0011BAZ\u0011\u001d\t)\f\u0001C\u0005\u0003oCq!!/\u0001\t\u0013\tY\fC\u0004\u0002D\u0002!I!!2\t\u000f\u0005-\b\u0001\"\u0003\u0002n\n12\t\\;ti\u0016\u0014H*\u001b8l\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002-[\u0005!A.\u001b8l\u0015\tqs&\u0001\u0004tKJ4XM\u001d\u0006\u0002a\u0005)1.\u00194lC\u000e\u00011C\u0001\u00014!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\u000f\t\u0003y\u0001i\u0011aK\u0001\rEJ|7.\u001a:D_:4\u0017nZ\u000b\u0002\u007fA\u0011\u0001)Q\u0007\u0002[%\u0011!)\f\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u0007ce>\\WM]\"p]\u001aLw\rI\u0001\b[\u0016$(/[2t+\u00051\u0005CA$Q\u001b\u0005A%B\u0001#J\u0015\tQ5*\u0001\u0004d_6lwN\u001c\u0006\u0003a1S!!\u0014(\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0015aA8sO&\u0011\u0011\u000b\u0013\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001\u0002;j[\u0016,\u0012!\u0016\t\u0003-fk\u0011a\u0016\u0006\u00031&\u000bQ!\u001e;jYNL!AW,\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\naB]3qY&\u001c\u0017-T1oC\u001e,'/F\u0001_!\t\u0001u,\u0003\u0002a[\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u0015\r|g\u000e\u001e:pY2,'/F\u0001e!\t)w-D\u0001g\u0015\t\u0011w&\u0003\u0002iM\ny1*\u00194lC\u000e{g\u000e\u001e:pY2,'/A\u0006d_:$(o\u001c7mKJ\u0004\u0013\u0001\u0003>l\u00072LWM\u001c;\u0016\u00031\u0004\"!\u001c9\u000e\u00039T!a\\\u0018\u0002\u0005i\\\u0017BA9o\u00055Y\u0015MZ6b5.\u001cE.[3oi\u0006I!p[\"mS\u0016tG\u000fI\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0016\u0003U\u0004\"\u0001\u0011<\n\u0005]l#!D'fi\u0006$\u0017\r^1DC\u000eDW-\u0001\bnKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0011\u0002%\rdWo\u001d;fe2Kgn['b]\u0006<WM]\u000b\u0002wB\u0011A\b`\u0005\u0003{.\u0012!c\u00117vgR,'\u000fT5oW6\u000bg.Y4fe\u000612\r\\;ti\u0016\u0014H*\u001b8l\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\u0005\u001d\u0001c\u0001\u001b\u0002\u0004%\u0019\u0011QA\u001b\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0013\t\u0012\u0011!a\u0001w\u0006\u0019\u0001\u0010J\u0019\u0002'\rdWo\u001d;fe2Kgn['b]\u0006<WM\u001d\u0011\u0002;Q|\u0007/[2D_:4\u0017nZ*z]\u000eLen\u00197vI\u0016$UMZ1vYR,\"!!\u0005\u0011\t\u0005M\u0011\u0011\u0005\b\u0005\u0003+\ti\u0002E\u0002\u0002\u0018Uj!!!\u0007\u000b\u0007\u0005m\u0011'\u0001\u0004=e>|GOP\u0005\u0004\u0003?)\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002$\u0005\u0015\"AB*ue&twMC\u0002\u0002 U\na\u0004^8qS\u000e\u001cuN\u001c4jONKhnY%oG2,H-\u001a#fM\u0006,H\u000e\u001e\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005\u0005\u0001fA\u000b\u00020A!\u0011\u0011GA \u001b\t\t\u0019D\u0003\u0003\u00026\u0005]\u0012aA1qS*!\u0011\u0011HA\u001e\u0003\u001dQW\u000f]5uKJT1!!\u0010O\u0003\u0015QWO\\5u\u0013\u0011\t\t%a\r\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\r1\u0012q\t\t\u0005\u0003c\tI%\u0003\u0003\u0002L\u0005M\"!C!gi\u0016\u0014X)Y2i\u0003A!Xm\u001d;DYV\u001cH/\u001a:MS:\\7\u000fK\u0002\u0018\u0003#\u0002B!!\r\u0002T%!\u0011QKA\u001a\u0005\u0011!Vm\u001d;\u0002\u001fQ,7\u000f\u001e*fG>tg-[4ve\u0016D3\u0001GA)\u0003\u001d\"Xm\u001d;U_BL7mQ8oM&<7+\u001f8d\u0013:\u001cG.\u001e3f\u0007>l\u0007/\u0019;jE&d\u0017\u000e^=)\u0007e\t\t&A\u0007WKJLg-\u001f#fM\u0006,H\u000e^\u0001\u001c-\u0016\u0014\u0018NZ=[\u0017\"\u000b7/T1mM>\u0014X.\u001a3D_:4\u0017nZ:\u00023Y+'/\u001b4z5.C\u0015m]+oW:|wO\\\"p]\u001aLwm]\u0001\u001c-\u0016\u0014\u0018NZ=[\u00176K7o]3t\u00032<\u0018-_:D_:4\u0017nZ:\u0002;Y+'/\u001b4z5.C\u0015m]%oI\u0016\u0004XM\u001c3f]R\u001cuN\u001c4jON\f\u0011c\u0019:fCR,7\t\\;ti\u0016\u0014H*\u001b8l)!\ti'a\u001f\u0002\u0000\u0005M\u0005\u0003BA8\u0003kr1\u0001PA9\u0013\r\t\u0019hK\u0001\u0013\u00072,8\u000f^3s\u0019&t7NR1di>\u0014\u00180\u0003\u0003\u0002x\u0005e$A\u0004$fi\u000eDWM]'b]\u0006<WM\u001d\u0006\u0004\u0003gZ\u0003bBA??\u0001\u0007\u0011\u0011C\u0001\tY&t7NT1nK\"9\u0011\u0011Q\u0010A\u0002\u0005\r\u0015A\u00027j].LE\r\u0005\u0003\u0002\u0006\u0006=UBAAD\u0015\u0011\tI)a#\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003\u001b\u000bAA[1wC&!\u0011\u0011SAD\u0005\u0011)V+\u0013#\t\u000f\u0005Uu\u00041\u0001\u0002\u0018\u0006\u00012\r\\;ti\u0016\u0014H*\u001b8l!J|\u0007o\u001d\t\u0005\u0003\u000b\u000bI*\u0003\u0003\u0002\u001c\u0006\u001d%A\u0003)s_B,'\u000f^5fg\u0006AB/Z:u\r\u0006LG.\u001a3BI\u0012\u001cE.^:uKJd\u0015N\\6)\u0007\u0001\n\t&\u0001\fuKN$(+Z2p]\u001aLw-\u001e:f\r\u0006LG.\u001e:fQ\r\t\u0013\u0011K\u0001\u0015i\u0016\u001cH\u000fR=oC6L7MR3uG\"\u001c\u0016N_3)\u0007\t\n\t&A\u0011uKN$8\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4SK\u0016t7M]=qi&|g\u000eK\u0002$\u0003#\n\u0001\u0005^3ti2+\u0017\rZ3s\u0003:$\u0017j\u001d:CK\u001a|'/\u001a'j].,\u0006\u000fZ1uK\"\u001aA%!\u0015\u0002%\r\u0014X-\u0019;f\u0005J|7.\u001a:D_:4\u0017n\u001a\u000b\u0002\u007f\u0005Q2\r\\;ti\u0016\u0014H*\u001b8l!\u0016\u00148/[:uK:$\bK]8qgV\u0011\u0011qS\u0001\u0012G2,8\u000f^3s\u0019&t7nQ8oM&<WCAA_!\ra\u0014qX\u0005\u0004\u0003\u0003\\#!E\"mkN$XM\u001d'j].\u001cuN\u001c4jO\u0006I1/\u001a;va6{7m\u001b\u000b\t\u0003\u0003\t9-a6\u0002d\"9\u0011\u0011\u001a\u0015A\u0002\u0005-\u0017!\u00039beRLG/[8o!\u0011\ti-a5\u000e\u0005\u0005='bAAi_\u000591\r\\;ti\u0016\u0014\u0018\u0002BAk\u0003\u001f\u0014\u0011\u0002U1si&$\u0018n\u001c8\t\u000f\u0005e\u0007\u00061\u0001\u0002\\\u0006\u0011A\u000f\u001d\t\u0005\u0003;\fy.D\u0001J\u0013\r\t\t/\u0013\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t\t\t\u000ba\u0001\u0003K\u0004R\u0001NAt\u0003\u0007K1!!;6\u0005\u0019y\u0005\u000f^5p]\u0006A2M]3bi\u0016\u001cE.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0015\u0007m\fy\u000fC\u0003>S\u0001\u0007q\b")
public class ClusterLinkManagerTest {
    private final KafkaConfig brokerConfig = this.createBrokerConfig();
    private final Metrics metrics = new Metrics();
    private final MockTime time = new MockTime();
    private final ReplicaManager replicaManager = (ReplicaManager)EasyMock.mock(ReplicaManager.class);
    private final KafkaController controller = (KafkaController)EasyMock.mock(KafkaController.class);
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private final MetadataCache metadataCache = MetadataCache$.MODULE$.zkMetadataCache(0, MetadataCache$.MODULE$.zkMetadataCache$default$2());
    private ClusterLinkManager clusterLinkManager;
    private final String topicConfigSyncIncludeDefault = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(ClusterLinkConfigDefaults$.MODULE$.TopicConfigSyncIncludeDefault()).asScala()).mkString(",");

    private KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private MockTime time() {
        return this.time;
    }

    private ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private MetadataCache metadataCache() {
        return this.metadataCache;
    }

    private ClusterLinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    private void clusterLinkManager_$eq(ClusterLinkManager x$1) {
        this.clusterLinkManager = x$1;
    }

    private String topicConfigSyncIncludeDefault() {
        return this.topicConfigSyncIncludeDefault;
    }

    @BeforeEach
    public void setUp() {
        EasyMock.expect((Object)this.replicaManager().metadataCache()).andReturn((Object)this.metadataCache()).anyTimes();
        EasyMock.expect((Object)this.replicaManager().zkClient()).andReturn((Object)new Some((Object)this.zkClient())).anyTimes();
        EasyMock.expect((Object)this.replicaManager().leaderPartitionsIterator()).andReturn((Object)Predef$.MODULE$.Set().empty().iterator()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.controller()});
        EasyMock.expect((Object)this.zkClient().getChildren("/cluster_links")).andReturn((Object)Nil$.MODULE$).anyTimes();
        EasyMock.expect((Object)this.zkClient().getClusterLinks(Predef$.MODULE$.Set().empty())).andReturn((Object)Predef$.MODULE$.Map().empty()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.clusterLinkManager_$eq(this.createClusterLinkManager(this.brokerConfig()));
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
    }

    @AfterEach
    public void tearDown() {
        this.clusterLinkManager().shutdown();
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClusterLinks() {
        String linkName = "testLink";
        UUID linkId = UUID.randomUUID();
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        String topic = "testTopic";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        Partition partition0 = (Partition)EasyMock.createNiceMock(Partition.class);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().fetcherManager(linkId));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().clientManager(linkId));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().resolveLinkId(linkName));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> this.clusterLinkManager().resolveLinkIdOrThrow(linkName), ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        this.clusterLinkManager().ensureLinkNameDoesntExist(linkName);
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)this.clusterLinkManager().listClusterLinks());
        this.setupMock(partition0, tp0, (Option<UUID>)None$.MODULE$);
        this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0})));
        this.setupMock(partition0, tp0, (Option<UUID>)new Some((Object)linkId));
        Assertions.assertEquals((int)0, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))));
        this.setupMock(partition0, tp0, (Option<UUID>)new Some((Object)linkId));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).times(1);
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.clusterLinkManager().createClusterLink(clusterLinkData, this.clusterLinkConfig(), this.clusterLinkPersistentProps());
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().fetcherManager(linkId));
        Assertions.assertNotEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().clientManager(linkId));
        Assertions.assertEquals((Object)new Some((Object)linkId), (Object)this.clusterLinkManager().resolveLinkId(linkName));
        Assertions.assertEquals((Object)new .colon.colon((Object)clusterLinkData, (List)Nil$.MODULE$), (Object)this.clusterLinkManager().listClusterLinks());
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)this.clusterLinkManager().fetcherManager(linkId).get();
        ClusterLinkClientManager clientManager = (ClusterLinkClientManager)this.clusterLinkManager().clientManager(linkId).get();
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.clusterLinkManager().createClusterLink(new ClusterLinkData(linkName, UUID.randomUUID(), (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false), this.clusterLinkConfig(), this.clusterLinkPersistentProps()), ClassTag$.MODULE$.apply(ClusterLinkExistsException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
        Assertions.assertEquals((int)1, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))));
        Assertions.assertTrue((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.time().milliseconds()), (String)"Topic not added to metadata");
        Assertions.assertTrue((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic not added to client manager");
        Assertions.assertFalse((boolean)fetcherManager.isEmpty(), (String)"Fetcher not recording active topic");
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = (LeaderAndIsrRequestData.LeaderAndIsrPartitionState)EasyMock.mock(LeaderAndIsrRequestData.LeaderAndIsrPartitionState.class);
        EasyMock.expect((Object)partitionState.clusterLinkId()).andReturn((Object)linkId.toString()).anyTimes();
        EasyMock.expect((Object)partitionState.clusterLinkTopicState()).andReturn((Object)"Mirror").anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)partitionState.linkedLeaderEpoch())).andReturn((Object)BoxesRunTime.boxToInteger((int)1)).anyTimes();
        EasyMock.expect((Object)partitionState.clusterLinkSourceTopicId()).andReturn((Object)Uuid.randomUuid()).anyTimes();
        EasyMock.replay((Object[])new Object[]{partitionState});
        this.clusterLinkManager().removePartitions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)partitionState)})));
        Assertions.assertTrue((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.time().milliseconds()), (String)"Topic removed from metadata");
        Assertions.assertFalse((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic not removed from client manager");
        EasyMock.reset((Object[])new Object[]{partitionState});
        EasyMock.expect((Object)partitionState.clusterLinkId()).andReturn(null).anyTimes();
        EasyMock.expect((Object)partitionState.clusterLinkSourceTopicId()).andReturn((Object)Uuid.randomUuid()).anyTimes();
        EasyMock.replay((Object[])new Object[]{partitionState});
        this.clusterLinkManager().removePartitions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)partitionState)})));
        Assertions.assertFalse((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.time().milliseconds()), (String)"Topic not removed from metadata");
        Assertions.assertFalse((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic should not be in client manager");
        EasyMock.reset((Object[])new Object[]{partitionState});
        EasyMock.expect((Object)partitionState.clusterLinkId()).andReturn((Object)linkId.toString()).anyTimes();
        EasyMock.expect((Object)partitionState.clusterLinkSourceTopicId()).andReturn((Object)Uuid.randomUuid()).anyTimes();
        EasyMock.expect((Object)partitionState.clusterLinkTopicState()).andReturn((Object)"FailedMirror").anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)partitionState.linkedLeaderEpoch())).andReturn((Object)BoxesRunTime.boxToInteger((int)-1)).anyTimes();
        EasyMock.replay((Object[])new Object[]{partitionState});
        Assertions.assertEquals((int)1, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))));
        this.clusterLinkManager().removePartitions((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition0), (Object)partitionState)})));
        Assertions.assertFalse((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.time().milliseconds()), (String)"Topic not removed from metadata for failed mirror");
        Assertions.assertFalse((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic should not be in client manager for failed mirror");
        TopicPartition tp1 = new TopicPartition(topic, 1);
        Partition partition1 = (Partition)EasyMock.createNiceMock(Partition.class);
        this.setupMock(partition1, tp1, (Option<UUID>)new Some((Object)linkId));
        Assertions.assertEquals((int)1, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition1}))));
        Assertions.assertTrue((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.time().milliseconds()), (String)"Topic not added to metadata");
        Assertions.assertFalse((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic should not be added to client manager");
        this.clusterLinkManager().removePartitionsAndMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})));
        Assertions.assertFalse((boolean)fetcherManager.currentMetadata().retainTopic(topic, false, this.time().milliseconds()), (String)"Topic not removed from metadata");
        Assertions.assertFalse((boolean)clientManager.getTopics().contains((Object)topic), (String)"Topic should not be in to client manager");
        Object object = this.clusterLinkManager().fetcherManager(linkId).get();
        Assertions.assertTrue((object != null && object.equals(fetcherManager) ? 1 : 0) != 0, (String)"Unexpected fetcher manager");
        Object object2 = this.clusterLinkManager().clientManager(linkId).get();
        Assertions.assertTrue((object2 != null && object2.equals(clientManager) ? 1 : 0) != 0, (String)"Unexpected client manager");
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        this.zkClient().setClusterLink(new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, true));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.clusterLinkManager().deleteClusterLink(linkName, linkId);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().resolveLinkId(linkName));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.clusterLinkManager().deleteClusterLink(linkName, linkId), ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinks$4(this, linkId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkManagerTest.$anonfun$testClusterLinks$5(linkId));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testReconfigure() {
        String linkName = "testLink";
        UUID linkId = UUID.randomUUID();
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.clusterLinkManager().updateClusterLinkConfig(linkName, (Function1 & Serializable & scala.Serializable)props -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManagerTest.$anonfun$testReconfigure$2(props))), ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).times(1);
        EasyMock.expect((Object)this.zkClient().getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{linkId})))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkId), (Object)new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false))}))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().fetcherManager(linkId));
        this.clusterLinkManager().createClusterLink(new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false), this.clusterLinkConfig(), this.clusterLinkPersistentProps());
        ClusterLinkFactory.FetcherManager fetcherManager = (ClusterLinkFactory.FetcherManager)this.clusterLinkManager().fetcherManager(linkId).get();
        Assertions.assertEquals(Collections.singletonList("localhost:1234"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "localhost:5678");
        this.clusterLinkManager().processClusterLinkChanges(linkId, newProps);
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(1);
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.ClusterLink(), linkId.toString())).andReturn((Object)newProps).times(1);
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.clusterLinkManager().updateClusterLinkConfig(linkName, (Function1 & Serializable & scala.Serializable)props -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManagerTest.$anonfun$testReconfigure$3(props)));
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(1);
        EasyMock.expect((Object)this.zkClient().getEntityConfigs(ConfigType$.MODULE$.ClusterLink(), linkId.toString())).andReturn((Object)newProps).times(1);
        EasyMock.expect((Object)this.zkClient().getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{linkId})))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkId), (Object)new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false))}))).times(1);
        Capture capturedProps = EasyMock.newCapture();
        this.zkClient().setOrCreateEntityConfigs((String)EasyMock.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)EasyMock.eq((Object)linkId.toString()), (Properties)EasyMock.capture((Capture)capturedProps));
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.clusterLinkManager().updateClusterLinkConfig(linkName, (Function1 & Serializable & scala.Serializable)props -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManagerTest.$anonfun$testReconfigure$4(props)));
        this.clusterLinkManager().processClusterLinkChanges(linkId, (Properties)capturedProps.getValue());
        Assertions.assertEquals(Collections.singletonList("localhost:1234"), (Object)fetcherManager.currentConfig().bootstrapServers());
    }

    @Test
    public void testTopicConfigSyncIncludeCompatibility() {
        this.VerifyDefault();
        this.VerifyZKHasMalformedConfigs();
        this.VerifyZKHasUnknownConfigs();
        this.VerifyZKMissesAlwaysConfigs();
        this.VerifyZKHasIndependentConfigs();
    }

    public void VerifyDefault() {
        String linkName = "test-default";
        UUID linkId = UUID.randomUUID();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "localhost:5678");
        this.clusterLinkManager().processClusterLinkChanges(linkId, newProps);
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(MirrorTopicConfigSyncRules$.MODULE$.SyncIncludeDefault()).asScala()).toSet(), (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
    }

    public void VerifyZKHasMalformedConfigs() {
        String linkName = "test-malformed";
        UUID linkId = UUID.randomUUID();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "localhost:5678");
        newProps.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), new StringBuilder(22).append(this.topicConfigSyncIncludeDefault()).append(" min.compaction.lag.ms").toString());
        this.clusterLinkManager().processClusterLinkChanges(linkId, newProps);
        Assertions.assertEquals(Collections.singletonList("localhost:1234"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(MirrorTopicConfigSyncRules$.MODULE$.SyncIncludeDefault()).asScala()).toSet(), (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
    }

    public void VerifyZKHasUnknownConfigs() {
        String linkName = "test-unknown";
        UUID linkId = UUID.randomUUID();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "localhost:5678");
        newProps.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), new StringBuilder(21).append(this.topicConfigSyncIncludeDefault()).append(",unknown.topic.config").toString());
        this.clusterLinkManager().processClusterLinkChanges(linkId, newProps);
        Assertions.assertEquals(Collections.singletonList("localhost:1234"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(MirrorTopicConfigSyncRules$.MODULE$.SyncIncludeDefault()).asScala()).toSet(), (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
    }

    public void VerifyZKMissesAlwaysConfigs() {
        String linkName = "test-always";
        UUID linkId = UUID.randomUUID();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        String topicConfigSyncIncludeOverride = LogConfig$.MODULE$.MinCompactionLagMsProp();
        newProps.put("bootstrap.servers", "localhost:5678");
        newProps.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), topicConfigSyncIncludeOverride);
        this.clusterLinkManager().processClusterLinkChanges(linkId, newProps);
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Assertions.assertEquals((Object)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LogConfig$.MODULE$.MinCompactionLagMsProp()}))), (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
    }

    public void VerifyZKHasIndependentConfigs() {
        String linkName = "test-independent";
        UUID linkId = UUID.randomUUID();
        ClusterLinkFactory.FetcherManager fetcherManager = this.createClusterLink(linkName, linkId, this.clusterLinkPersistentProps());
        Properties newProps = new Properties();
        String topicConfigSyncIncludeOverride = MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{LogConfig$.MODULE$.TierEnableProp()}))).mkString(",");
        newProps.put("bootstrap.servers", "localhost:5678");
        newProps.put(ClusterLinkConfig$.MODULE$.TopicConfigSyncIncludeProp(), topicConfigSyncIncludeOverride);
        this.clusterLinkManager().processClusterLinkChanges(linkId, newProps);
        Assertions.assertEquals(Collections.singletonList("localhost:5678"), (Object)fetcherManager.currentConfig().bootstrapServers());
        Assertions.assertEquals((Object)MirrorTopicConfigSyncRules$.MODULE$.AlwaysConfigs(), (Object)fetcherManager.currentConfig().topicConfigSyncRules().include());
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
    }

    public ClusterLinkFactory.FetcherManager createClusterLink(String linkName, UUID linkId, Properties clusterLinkProps) {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.clusterLinkManager().updateClusterLinkConfig(linkName, (Function1 & Serializable & scala.Serializable)props -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkManagerTest.$anonfun$createClusterLink$2(props))), ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).times(1);
        EasyMock.expect((Object)this.zkClient().getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{linkId})))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkId), (Object)new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false))}))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.clusterLinkManager().fetcherManager(linkId));
        this.clusterLinkManager().createClusterLink(new ClusterLinkData(linkName, linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false), this.clusterLinkConfig(), clusterLinkProps);
        return (ClusterLinkFactory.FetcherManager)this.clusterLinkManager().fetcherManager(linkId).get();
    }

    @Test
    public void testFailedAddClusterLink() {
        String linkName = "testLink";
        UUID linkId = UUID.randomUUID();
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        Assertions.assertTrue((boolean)this.clusterLinkManager().resolveLinkId(linkName).isEmpty());
        Assertions.assertTrue((boolean)this.clusterLinkManager().listClusterLinks().isEmpty());
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).times(1);
        this.zkClient().createClusterLink(clusterLinkData);
        EasyMock.expect((Object)BoxedUnit.UNIT).andThrow((Throwable)new RuntimeException("")).times(1);
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.clusterLinkManager().createClusterLink(clusterLinkData, this.clusterLinkConfig(), this.clusterLinkPersistentProps()), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("ClusterLinkManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
        Assertions.assertTrue((boolean)this.clusterLinkManager().resolveLinkId(linkName).isEmpty());
        Assertions.assertTrue((boolean)this.clusterLinkManager().listClusterLinks().isEmpty());
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).times(1);
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.clusterLinkManager().createClusterLink(clusterLinkData, this.clusterLinkConfig(), this.clusterLinkPersistentProps());
        Assertions.assertEquals((Object)new Some((Object)linkId), (Object)this.clusterLinkManager().resolveLinkId(linkName));
        Assertions.assertEquals((Object)new .colon.colon((Object)clusterLinkData, (List)Nil$.MODULE$), (Object)this.clusterLinkManager().listClusterLinks());
    }

    @Test
    public void testReconfigureFailure() {
        String linkName = "testLink";
        UUID linkId = UUID.randomUUID();
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        EasyMock.expect((Object)this.zkClient().getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{linkId})))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkId), (Object)clusterLinkData)}))).once();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        Properties newProps = new Properties();
        newProps.put("bootstrap.servers", "");
        this.clusterLinkManager().processClusterLinkChanges(linkId, newProps);
        Assertions.assertEquals((Object)FailedClusterLink$.MODULE$, (Object)this.clusterLinkManager().linkState(linkName));
    }

    @Test
    public void testDynamicFetchSize() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        FetchResponseSize defaultSize = new FetchResponseSize(Predef$.MODULE$.Integer2int(this.clusterLinkConfig().replicaFetchMaxBytes()), Predef$.MODULE$.Integer2int(this.clusterLinkConfig().replicaFetchResponseMaxBytes()));
        Assertions.assertEquals((Object)defaultSize, (Object)this.clusterLinkManager().fetchResponseSize(this.clusterLinkConfig()));
        UUID linkId = UUID.randomUUID();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.zkClient().clusterLinkExists(linkId))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).times(1);
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.clusterLinkManager().createClusterLink(new ClusterLinkData("link", linkId, (Option)None$.MODULE$, (Option)None$.MODULE$, false), this.clusterLinkConfig(), this.clusterLinkPersistentProps());
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)this.clusterLinkManager().fetcherManager(linkId).get();
        Assertions.assertEquals((int)0, (int)fetcherManager.fetcherThreadCount());
        this.verifyFetchSize$1(defaultSize, props);
        props.setProperty("confluent.cluster.link.fetch.response.total.bytes", "10000");
        this.verifyFetchSize$1(new FetchResponseSize(5000, 10000), props);
        props.setProperty("confluent.cluster.link.fetch.response.min.bytes", "6000");
        this.verifyFetchSize$1(new FetchResponseSize(6000, 10000), props);
        props.setProperty("confluent.cluster.link.fetch.response.total.bytes", Integer.toString(Integer.MAX_VALUE));
        this.verifyFetchSize$1(defaultSize, props);
        ClusterLinkFetcherThread thread = (ClusterLinkFetcherThread)EasyMock.createNiceMock(ClusterLinkFetcherThread.class);
        IntRef numThreads = IntRef.create((int)0);
        props.setProperty("confluent.cluster.link.fetch.response.total.bytes", Integer.toString(Predef$.MODULE$.Integer2int(this.clusterLinkConfig().replicaFetchResponseMaxBytes()) * 6));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> {
            ClusterLinkManagerTest.addFetcherThread$1(numThreads, fetcherManager, thread);
            this.verifyFetchSize$1(new FetchResponseSize(Predef$.MODULE$.Integer2int(this.clusterLinkConfig().replicaFetchMaxBytes()), Predef$.MODULE$.Integer2int(this.clusterLinkConfig().replicaFetchResponseMaxBytes())), props);
        });
        props.setProperty("confluent.cluster.link.fetch.response.total.bytes", "10000");
        props.setProperty("confluent.cluster.link.fetch.response.min.bytes", "1");
        this.verifyFetchSize$1(new FetchResponseSize(1000, 2000), props);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> ClusterLinkManagerTest.addFetcherThread$1(numThreads, fetcherManager, thread));
        this.verifyFetchSize$1(new FetchResponseSize(500, 1000), props);
        fetcherManager.fetcherThreadMap().clear();
        this.verifyFetchSize$1(new FetchResponseSize(5000, 10000), props);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClusterLinkConfigReencryption() {
        String linkName = "link1";
        UUID linkId = UUID.randomUUID();
        ObjectRef executor = ObjectRef.create(null);
        KafkaException testException = new KafkaException("Test exception");
        this.setupZkClient$1(linkId, linkName);
        this.zkClient().transformEntityConfigs((String)EasyMock.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)EasyMock.eq((Object)linkId.toString()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andThrow((Throwable)testException).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.recreateClusterLinkManager$1(Long.MAX_VALUE, executor);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$1(executor)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.setupZkClient$1(linkId, linkName);
        this.zkClient().transformEntityConfigs((String)EasyMock.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)EasyMock.eq((Object)linkId.toString()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.recreateClusterLinkManager$1(Long.MAX_VALUE, executor);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$3(executor)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.setupZkClient$1(linkId, linkName);
        this.zkClient().transformEntityConfigs((String)EasyMock.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)EasyMock.eq((Object)linkId.toString()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.recreateClusterLinkManager$1(30000L, executor);
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$5(executor)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.setupZkClient$1(linkId, linkName);
        this.zkClient().transformEntityConfigs((String)EasyMock.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)EasyMock.eq((Object)linkId.toString()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.recreateClusterLinkManager$1(1L, executor);
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$7(executor)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.setupZkClient$1(linkId, linkName);
        this.zkClient().transformEntityConfigs((String)EasyMock.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)EasyMock.eq((Object)linkId.toString()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        this.zkClient().transformEntityConfigs((String)EasyMock.eq((Object)ConfigType$.MODULE$.ClusterLink()), (String)EasyMock.eq((Object)linkId.toString()), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andThrow((Throwable)testException).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.recreateClusterLinkManager$1(1L, executor);
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$9(executor)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ClusterLinkManagerTest.$anonfun$testClusterLinkConfigReencryption$10());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testLeaderAndIsrBeforeLinkUpdate() {
        String linkName = "testLink";
        UUID linkId = UUID.randomUUID();
        String clusterId = "testClusterId";
        ClusterLinkData clusterLinkData = new ClusterLinkData(linkName, linkId, (Option)new Some((Object)clusterId), (Option)None$.MODULE$, false);
        String topic = "testTopic";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        Partition partition0 = (Partition)EasyMock.createNiceMock(Partition.class);
        this.setupMock(partition0, tp0, (Option<UUID>)new Some((Object)linkId));
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        EasyMock.expect((Object)this.replicaManager().metadataCache()).andReturn((Object)this.metadataCache()).anyTimes();
        EasyMock.expect((Object)this.replicaManager().zkClient()).andReturn((Object)new Some((Object)this.zkClient())).anyTimes();
        EasyMock.expect((Object)this.replicaManager().leaderPartitionsIterator()).andReturn((Object)((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))).iterator()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        Assertions.assertEquals((int)0, (int)this.clusterLinkManager().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0}))));
        ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)EasyMock.mock(ClusterLinkFetcherManager.class);
        fetcherManager.addLinkedFetcherForPartitions((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Partition[]{partition0})));
        EasyMock.expect((Object)BoxedUnit.UNIT).once();
        fetcherManager.shutdown();
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.replay((Object[])new Object[]{fetcherManager});
        ClusterLinkDestConnectionManager connectionManager = (ClusterLinkDestConnectionManager)EasyMock.mock(ClusterLinkDestConnectionManager.class);
        EasyMock.expect((Object)connectionManager.currentConfig()).andReturn((Object)this.clusterLinkConfig()).anyTimes();
        connectionManager.shutdown();
        EasyMock.expect((Object)BoxedUnit.UNIT).anyTimes();
        EasyMock.replay((Object[])new Object[]{connectionManager});
        ClusterLinkManager.Managers managers = new ClusterLinkManager.Managers((Option)new Some((Object)fetcherManager), (Option)None$.MODULE$, (ClusterLinkFactory.ConnectionManager)connectionManager, null);
        this.clusterLinkManager().commitAddClusterLink(clusterLinkData, managers, (LinkMode)LinkMode.Destination$.MODULE$);
        EasyMock.verify((Object[])new Object[]{fetcherManager});
    }

    private KafkaConfig createBrokerConfig() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        return KafkaConfig$.MODULE$.fromProps(props);
    }

    /*
     * WARNING - void declaration
     */
    private Properties clusterLinkPersistentProps() {
        void var1_1;
        Properties props = new Properties();
        props.put("bootstrap.servers", "localhost:1234");
        return var1_1;
    }

    private ClusterLinkConfig clusterLinkConfig() {
        return ClusterLinkConfig$.MODULE$.create((java.util.Map)this.clusterLinkPersistentProps());
    }

    private void setupMock(Partition partition, TopicPartition tp, Option<UUID> linkId) {
        EasyMock.reset((Object[])new Object[]{partition});
        EasyMock.expect((Object)partition.topicPartition()).andReturn((Object)tp).anyTimes();
        EasyMock.expect((Object)partition.getClusterLinkId()).andReturn(linkId).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)partition.isActiveLinkDestinationLeader())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)linkId.nonEmpty())).anyTimes();
        EasyMock.expect((Object)partition.getLinkedLeaderEpoch()).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1))).anyTimes();
        IsrState isrState = (IsrState)EasyMock.mock(IsrState.class);
        EasyMock.expect((Object)isrState.clusterLink()).andReturn((Object)linkId.map((Function1 & Serializable & scala.Serializable)id -> new ClusterLinkState(id, (TopicLinkState)TopicLinkMirror$.MODULE$, null))).anyTimes();
        EasyMock.replay((Object[])new Object[]{isrState});
        EasyMock.expect((Object)partition.isrState()).andReturn((Object)isrState).anyTimes();
        EasyMock.replay((Object[])new Object[]{partition});
    }

    private ClusterLinkManager createClusterLinkManager(KafkaConfig brokerConfig) {
        ClusterLinkFactory.LinkManager manager = ClusterLinkFactory$.MODULE$.createLinkManager(brokerConfig, "clusterId", (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, this.zkClient(), this.metrics(), (Time)this.time(), ClusterLinkFactory$.MODULE$.createLinkManager$default$7());
        Endpoint brokerEndpoint = new Endpoint("PLAINTEXT", SecurityProtocol.PLAINTEXT, "localhost", 1234);
        AuthorizerServerInfo serverInfo = (AuthorizerServerInfo)EasyMock.mock(AuthorizerServerInfo.class);
        EasyMock.expect((Object)serverInfo.interBrokerEndpoint()).andReturn((Object)brokerEndpoint).anyTimes();
        EasyMock.replay((Object[])new Object[]{serverInfo});
        manager.startup(serverInfo, this.replicaManager(), null, this.controller(), null, (Option)None$.MODULE$);
        return (ClusterLinkManager)manager;
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinks$4(ClusterLinkManagerTest $this, UUID linkId$1) {
        return $this.clusterLinkManager().fetcherManager(linkId$1).isEmpty() && $this.clusterLinkManager().clientManager(linkId$1).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testClusterLinks$5(UUID linkId$1) {
        return new StringBuilder(38).append("Linked fetcher/client for ").append(linkId$1).append(" not removed").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testReconfigure$2(Properties props) {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testReconfigure$3(Properties props) {
        props.put("bootstrap.servers", "localhost:1234");
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testReconfigure$4(Properties props) {
        props.put("bootstrap.servers", "localhost:1234");
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$createClusterLink$2(Properties props) {
        return false;
    }

    private final void verifyFetchSize$1(FetchResponseSize expectedSize, Properties props$1) {
        this.brokerConfig().updateCurrentConfig(KafkaConfig$.MODULE$.fromProps(props$1));
        this.clusterLinkManager().updateDynamicFetchSize();
        Assertions.assertEquals((Object)expectedSize, (Object)this.clusterLinkManager().fetchResponseSize(this.clusterLinkConfig()));
    }

    private static final void addFetcherThread$1(IntRef numThreads$1, ClusterLinkFetcherManager fetcherManager$1, ClusterLinkFetcherThread thread$1) {
        ++numThreads$1.elem;
        fetcherManager$1.fetcherThreadMap().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new FetcherTag(0, numThreads$1.elem, (FetcherPool)FetcherPool.Default$.MODULE$)), (Object)thread$1));
    }

    private final void setupZkClient$1(UUID linkId$2, String linkName$4) {
        EasyMock.reset((Object[])new Object[]{this.zkClient()});
        EasyMock.expect((Object)this.zkClient().getChildren("/cluster_links")).andReturn((Object)new .colon.colon((Object)linkId$2.toString(), (List)Nil$.MODULE$)).anyTimes();
        EasyMock.expect((Object)this.zkClient().getClusterLinks((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UUID[]{linkId$2})))).andReturn((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)linkId$2), (Object)new ClusterLinkData(linkName$4, linkId$2, (Option)None$.MODULE$, (Option)None$.MODULE$, false))}))).anyTimes();
    }

    private final void recreateClusterLinkManager$1(long oldSecretTtl, ObjectRef executor$1) {
        this.clusterLinkManager().shutdown();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, "localhost:1234", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.ClusterLinkEnableProp(), "true");
        props.put("confluent.password.encoder.old.secret.ttl.ms", Long.toString(oldSecretTtl));
        this.clusterLinkManager_$eq(this.createClusterLinkManager(KafkaConfig$.MODULE$.fromProps(props)));
        executor$1.elem = (ScheduledThreadPoolExecutor)TestUtils.fieldValue((Object)this.clusterLinkManager().scheduler(), KafkaScheduler.class, (String)"executor");
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigReencryption$1(ObjectRef executor$1) {
        return ((ScheduledThreadPoolExecutor)executor$1.elem).getTaskCount() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkConfigReencryption$2() {
        return "Retry not scheduled after failure";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigReencryption$3(ObjectRef executor$1) {
        return ((ScheduledThreadPoolExecutor)executor$1.elem).getTaskCount() == 0L;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkConfigReencryption$4() {
        return "Unnecessary retry scheduled";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigReencryption$5(ObjectRef executor$1) {
        return ((ScheduledThreadPoolExecutor)executor$1.elem).getTaskCount() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkConfigReencryption$6() {
        return "Old encoder delete not scheduled";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigReencryption$7(ObjectRef executor$1) {
        return ((ScheduledThreadPoolExecutor)executor$1.elem).getTaskCount() == 1L;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkConfigReencryption$8() {
        return "Unnecessary delete retry scheduled";
    }

    public static final /* synthetic */ boolean $anonfun$testClusterLinkConfigReencryption$9(ObjectRef executor$1) {
        return ((ScheduledThreadPoolExecutor)executor$1.elem).getTaskCount() > 1L;
    }

    public static final /* synthetic */ String $anonfun$testClusterLinkConfigReencryption$10() {
        return "Delete retry not scheduled";
    }
}

