/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.server.link.ActiveClusterLink$;
import kafka.server.link.ClusterLinkBrokerMetrics;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFetcherManager;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.LinkMode;
import kafka.server.link.TopicLinkFailedMirror$;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkPausedMirror$;
import kafka.server.link.TopicLinkPendingStoppedMirror$;
import kafka.server.link.TopicLinkStoppedMirror$;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001B\u0011#\u0001%BQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013%Q\u0007\u0003\u0004?\u0001\u0001\u0006IA\u000e\u0005\b\u007f\u0001\u0011\r\u0011\"\u00036\u0011\u0019\u0001\u0005\u0001)A\u0005m!9\u0011\t\u0001b\u0001\n\u0013\u0011\u0005BB(\u0001A\u0003%1\tC\u0004Q\u0001\t\u0007I\u0011B)\t\ru\u0003\u0001\u0015!\u0003S\u0011\u001dq\u0006A1A\u0005\n}Caa\u001a\u0001!\u0002\u0013\u0001\u0007b\u00025\u0001\u0005\u0004%I!\u001b\u0005\u0007]\u0002\u0001\u000b\u0011\u00026\t\u000f=\u0004!\u0019!C\u0005a\"1a\u0010\u0001Q\u0001\nED\u0001b \u0001C\u0002\u0013%\u0011\u0011\u0001\u0005\t\u00033\u0001\u0001\u0015!\u0003\u0002\u0004!I\u00111\u0004\u0001C\u0002\u0013%\u0011Q\u0004\u0005\t\u0003S\u0001\u0001\u0015!\u0003\u0002 !I\u00111\u0006\u0001C\u0002\u0013%\u0011Q\u0006\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u00020!I\u0011q\u0007\u0001C\u0002\u0013%\u0011\u0011\b\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0003\u0002<!I\u0011q\t\u0001C\u0002\u0013%\u0011\u0011\n\u0005\t\u0003#\u0002\u0001\u0015!\u0003\u0002L!9\u00111\u000b\u0001\u0005\u0002\u0005U\u0003bBA:\u0001\u0011\u0005\u0011Q\u000b\u0005\b\u0003{\u0002A\u0011AA+\u0011\u001d\t\t\t\u0001C\u0001\u0003+Bq!!\"\u0001\t\u0013\t9\tC\u0005\u0002\u000e\u0002\t\n\u0011\"\u0003\u0002\u0010\"9\u0011Q\u0015\u0001\u0005\n\u0005\u001d&AF\"mkN$XM\u001d'j].lU\r\u001e:jGN$Vm\u001d;\u000b\u0005\r\"\u0013\u0001\u00027j].T!!\n\u0014\u0002\rM,'O^3s\u0015\u00059\u0013!B6bM.\f7\u0001A\n\u0003\u0001)\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00013!\t\u0019\u0004!D\u0001#\u0003\u0019!XM\\1oiV\ta\u0007\u0005\u00028y5\t\u0001H\u0003\u0002:u\u0005!A.\u00198h\u0015\u0005Y\u0014\u0001\u00026bm\u0006L!!\u0010\u001d\u0003\rM#(/\u001b8h\u0003\u001d!XM\\1oi\u0002\nA\u0002^3oC:$\bK]3gSb\fQ\u0002^3oC:$\bK]3gSb\u0004\u0013\u0001\u00037j].$\u0015\r^1\u0016\u0003\r\u00032\u0001R$J\u001b\u0005)%B\u0001$-\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0011\u0016\u00131aU3r!\tQU*D\u0001L\u0015\tae%\u0001\u0002{W&\u0011aj\u0013\u0002\u0010\u00072,8\u000f^3s\u0019&t7\u000eR1uC\u0006IA.\u001b8l\t\u0006$\u0018\rI\u0001\u000eg>,(oY3U_BL7-\u00133\u0016\u0003I\u0003\"aU.\u000e\u0003QS!!\u0016,\u0002\r\r|W.\\8o\u0015\t9sK\u0003\u0002Y3\u00061\u0011\r]1dQ\u0016T\u0011AW\u0001\u0004_J<\u0017B\u0001/U\u0005\u0011)V/\u001b3\u0002\u001dM|WO]2f)>\u0004\u0018nY%eA\u0005Q\u0001/\u0019:uSRLwN\\:\u0016\u0003\u0001\u00042\u0001R$b!\u0011Y#\r\u001a3\n\u0005\rd#A\u0002+va2,'\u0007\u0005\u0002,K&\u0011a\r\f\u0002\u0004\u0013:$\u0018a\u00039beRLG/[8og\u0002\na\u0001]1vg\u0016$W#\u00016\u0011\u0007\u0011;5\u000e\u0005\u0002,Y&\u0011Q\u000e\f\u0002\b\u0005>|G.Z1o\u0003\u001d\u0001\u0018-^:fI\u0002\n\u0011\u0002\\5oW6{G-Z:\u0016\u0003E\u00042\u0001R$s%\u0011\u0019X\u000f_>\u0007\tQ\u0004\u0001A\u001d\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0003WYL!a\u001e\u0017\u0003\u000fA\u0013x\u000eZ;diB\u00111&_\u0005\u0003u2\u0012AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"a\r?\n\u0005u\u0014#\u0001\u0003'j].lu\u000eZ3\u0002\u00151Lgn['pI\u0016\u001c\b%\u0001\u0004u_BL7m]\u000b\u0003\u0003\u0007\u0001r!!\u0002\u0002\fY\ny!\u0004\u0002\u0002\b)\u0019\u0011\u0011B#\u0002\u0013%lW.\u001e;bE2,\u0017\u0002BA\u0007\u0003\u000f\u00111!T1q%\u0019\t\t\"\u001e=\u0002\u0014\u0019)A\u000f\u0001\u0001\u0002\u0010A\u00191'!\u0006\n\u0007\u0005]!EA\u000bDYV\u001cH/\u001a:MS:\\Gk\u001c9jGN#\u0018\r^3\u0002\u000fQ|\u0007/[2tA\u00059Q.\u001a;sS\u000e\u001cXCAA\u0010!\u0011\t\t#!\n\u000e\u0005\u0005\r\"bAA\u000e)&!\u0011qEA\u0012\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\b[\u0006t\u0017mZ3s+\t\ty\u0003E\u00024\u0003cI1!a\r#\u0005I\u0019E.^:uKJd\u0015N\\6NC:\fw-\u001a:\u0002\u00115\fg.Y4fe\u0002\n!bY8oiJ|G\u000e\\3s+\t\tY\u0004\u0005\u0003\u0002>\u0005\u0005SBAA \u0015\r\t9DJ\u0005\u0005\u0003\u0007\nyDA\bLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s\u0003-\u0019wN\u001c;s_2dWM\u001d\u0011\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/\u0006\u0002\u0002LA!\u0011QHA'\u0013\u0011\ty%a\u0010\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH/\u0001\nd_:$(o\u001c7mKJ\u001cuN\u001c;fqR\u0004\u0013\u0001\u0003;fCJ$un\u001e8\u0015\u0005\u0005]\u0003cA\u0016\u0002Z%\u0019\u00111\f\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u00045\u0005}\u0003\u0003BA1\u0003_j!!a\u0019\u000b\t\u0005\u0015\u0014qM\u0001\u0004CBL'\u0002BA5\u0003W\nqA[;qSR,'OC\u0002\u0002ne\u000bQA[;oSRLA!!\u001d\u0002d\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\fi\u0016\u001cH/T3ue&\u001c7\u000fK\u0002\u001c\u0003o\u0002B!!\u0019\u0002z%!\u00111PA2\u0005\u0011!Vm\u001d;\u0002-Q,7\u000f\u001e)bkN,G\rV8qS\u000elU\r\u001e:jGND3\u0001HA<\u0003\u0005\"Xm\u001d;D_:$(o\u001c7mKJlU\r\u001e:jGNL5oQ8oiJ|G\u000e\\3sQ\ri\u0012qO\u0001\ng\u0016$X\u000f]'pG.$B!a\u0016\u0002\n\"A\u00111\u0012\u0010\u0011\u0002\u0003\u00071.\u0001\u0007jg\u000e{g\u000e\u001e:pY2,'/A\ntKR,\b/T8dW\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0012*\u001a1.a%,\u0005\u0005U\u0005\u0003BAL\u0003Ck!!!'\u000b\t\u0005m\u0015QT\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a(-\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003G\u000bIJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!#Y:tKJ$X*\u001a;sS\u000e,\u0015/^1mgR1\u0011qKAU\u0003gCq!a+!\u0001\u0004\ti+\u0001\u0003oC6,\u0007cA*\u00020&\u0019\u0011\u0011\u0017+\u0003\u00155+GO]5d\u001d\u0006lW\rC\u0004\u00026\u0002\u0002\r!a.\u0002\u001b\u0015D\b/Z2uK\u00124\u0016\r\\;f!\rY\u0013\u0011X\u0005\u0004\u0003wc#A\u0002#pk\ndW\r")
public class ClusterLinkMetricsTest {
    private final String tenant;
    private final String tenantPrefix = new StringBuilder(1).append(this.tenant()).append("_").toString();
    private final Seq<ClusterLinkData> linkData = new .colon.colon((Object)new ClusterLinkData(new StringBuilder(11).append(this.tenantPrefix()).append("test-link-1").toString(), UUID.randomUUID(), (Option)None$.MODULE$, (Option)new Some((Object)this.tenantPrefix()), false), (List)new .colon.colon((Object)new ClusterLinkData("test-link-2", UUID.randomUUID(), (Option)None$.MODULE$, (Option)None$.MODULE$, false), (List)Nil$.MODULE$));
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final Seq<Tuple2<Object, Object>> partitions = new .colon.colon((Object)new Tuple2.mcII.sp(4, 1), (List)new .colon.colon((Object)new Tuple2.mcII.sp(6, 2), (List)Nil$.MODULE$));
    private final Seq<Object> paused = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}));
    private final Seq<Product> linkModes = new .colon.colon((Object)LinkMode.Destination$.MODULE$, (List)new .colon.colon((Object)LinkMode.Source$.MODULE$, (List)Nil$.MODULE$));
    private final scala.collection.immutable.Map<String, Product> topics = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)new ClusterLinkTopicState.Mirror(((ClusterLinkData)this.linkData().head()).linkName(), ((ClusterLinkData)this.linkData().head()).linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)new ClusterLinkTopicState.StoppedMirror(((ClusterLinkData)this.linkData().head()).linkName(), ((ClusterLinkData)this.linkData().head()).linkId(), this.sourceTopicId(), (Seq)List$.MODULE$.empty(), ClusterLinkTopicState.StoppedMirror$.MODULE$.apply$default$5())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)new ClusterLinkTopicState.FailedMirror(((ClusterLinkData)this.linkData().head()).linkName(), ((ClusterLinkData)this.linkData().head()).linkId(), this.sourceTopicId(), ClusterLinkTopicState.FailedMirror$.MODULE$.apply$default$4())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-4"), (Object)new ClusterLinkTopicState.Mirror(((ClusterLinkData)this.linkData().apply(1)).linkName(), ((ClusterLinkData)this.linkData().apply(1)).linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-5"), (Object)new ClusterLinkTopicState.Mirror(((ClusterLinkData)this.linkData().apply(1)).linkName(), ((ClusterLinkData)this.linkData().apply(1)).linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4()))}));
    private final Metrics metrics = new Metrics();
    private final ClusterLinkManager manager = (ClusterLinkManager)EasyMock.mock(ClusterLinkManager.class);
    private final KafkaController controller = (KafkaController)EasyMock.mock(KafkaController.class);
    private final ControllerContext controllerContext = (ControllerContext)EasyMock.mock(ControllerContext.class);

    private String tenant() {
        return this.tenant;
    }

    private String tenantPrefix() {
        return this.tenantPrefix;
    }

    private Seq<ClusterLinkData> linkData() {
        return this.linkData;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private Seq<Tuple2<Object, Object>> partitions() {
        return this.partitions;
    }

    private Seq<Object> paused() {
        return this.paused;
    }

    private Seq<Product> linkModes() {
        return this.linkModes;
    }

    private scala.collection.immutable.Map<String, Product> topics() {
        return this.topics;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private ClusterLinkManager manager() {
        return this.manager;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    @AfterEach
    public void tearDown() {
        this.metrics().close();
    }

    @Test
    public void testMetrics() {
        this.setupMock(this.setupMock$default$1());
        ClusterLinkBrokerMetrics brokerMetrics = new ClusterLinkBrokerMetrics(this.metrics());
        brokerMetrics.startup();
        Seq brokerSensors = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Sensor[]{brokerMetrics.linkedTopicPartitionAdditionSensor(), brokerMetrics.linkedLeaderEpochChangeSensor(), brokerMetrics.aclsAddedSensor(), brokerMetrics.aclsAddFailedSensor(), brokerMetrics.aclsDeletedSensor(), brokerMetrics.aclsDeleteFailedSensor(), brokerMetrics.consumerOffsetCommitSensor(), brokerMetrics.consumerOffsetCommitFailedSensor(), brokerMetrics.topicConfigUpdateSensor(), brokerMetrics.topicConfigUpdateFailedSensor(), brokerMetrics.sourceReverseConnectionCreatedSensor(), brokerMetrics.destReverseConnectionCreatedSensor(), brokerMetrics.sourceReverseConnectionClosedSensor(), brokerMetrics.destReverseConnectionClosedSensor(), brokerMetrics.sourceReverseConnectionFailedSensor()}));
        brokerSensors.foreach((Function1 & Serializable & scala.Serializable)s -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$1(this, s);
            return BoxedUnit.UNIT;
        });
        String linkName = ((ClusterLinkData)this.linkData().head()).linkName();
        ClusterLinkMetrics linkMetrics = new ClusterLinkMetrics(linkName, ((ClusterLinkData)this.linkData().head()).linkId(), (LinkMode)LinkMode.Source$.MODULE$, this.manager(), (Option)new Some((Object)brokerMetrics), this.metrics(), (Option)new Some((Object)this.tenant()));
        linkMetrics.startup();
        Seq sensors = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Sensor[]{linkMetrics.activeLinkCountSensor(), linkMetrics.throttleTimeSensor(), linkMetrics.linkedTopicPartitionAdditionSensor(), linkMetrics.linkedLeaderEpochChangeSensor(), linkMetrics.aclsAddedSensor(), linkMetrics.aclsAddFailedSensor(), linkMetrics.aclsDeletedSensor(), linkMetrics.aclsDeleteFailedSensor(), linkMetrics.consumerOffsetCommitSensor(), linkMetrics.consumerOffsetCommitFailedSensor(), linkMetrics.topicConfigUpdateSensor(), linkMetrics.topicConfigUpdateFailedSensor(), linkMetrics.linkSourceUnavailableSensor(), linkMetrics.reverseConnectionCreatedSensor(), linkMetrics.reverseConnectionClosedSensor(), linkMetrics.sourceReverseConnectionFailedSensor()}));
        sensors.foreach((Function1 & Serializable & scala.Serializable)s -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$2(this, s);
            return BoxedUnit.UNIT;
        });
        this.assertMetricEquals(linkMetrics.mirrorPartitionCountMetricName(), 4.0);
        linkMetrics.mirrorTopicCountMetricNames().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$3(this, x0$1);
            return BoxedUnit.UNIT;
        });
        linkMetrics.shutdown();
        sensors.foreach((Function1 & Serializable & scala.Serializable)s -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$4(this, s);
            return BoxedUnit.UNIT;
        });
        brokerSensors.foreach((Function1 & Serializable & scala.Serializable)s -> {
            ClusterLinkMetricsTest.$anonfun$testMetrics$5(this, s);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPausedTopicMetrics() {
        this.setupMock(this.setupMock$default$1());
        String linkName = ((ClusterLinkData)this.linkData().apply(1)).linkName();
        ClusterLinkMetrics linkMetrics = new ClusterLinkMetrics(linkName, ((ClusterLinkData)this.linkData().apply(1)).linkId(), (LinkMode)this.linkModes().apply(1), this.manager(), (Option)None$.MODULE$, this.metrics(), (Option)None$.MODULE$);
        linkMetrics.startup();
        this.assertMetricEquals((MetricName)((Tuple2)linkMetrics.linkCountMetricNames().head())._2(), 1.0);
        this.assertMetricEquals(linkMetrics.mirrorPartitionCountMetricName(), 6.0);
        linkMetrics.mirrorTopicCountMetricNames().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ClusterLinkMetricsTest.$anonfun$testPausedTopicMetrics$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
        linkMetrics.shutdown();
    }

    @Test
    public void testControllerMetricsIsController() {
        this.setupMock(this.setupMock$default$1());
        String linkName = ((ClusterLinkData)this.linkData().head()).linkName();
        ClusterLinkMetrics linkMetrics = new ClusterLinkMetrics(linkName, ((ClusterLinkData)this.linkData().head()).linkId(), (LinkMode)this.linkModes().head(), this.manager(), (Option)None$.MODULE$, this.metrics(), (Option)None$.MODULE$);
        linkMetrics.startup();
        this.assertMetricEquals((MetricName)((Tuple2)linkMetrics.linkCountMetricNames().head())._2(), 1.0);
        linkMetrics.shutdown();
    }

    private void setupMock(boolean isController) {
        EasyMock.reset((Object[])new Object[]{this.manager()});
        EasyMock.reset((Object[])new Object[]{this.controller()});
        EasyMock.reset((Object[])new Object[]{this.controllerContext()});
        ConcurrentHashMap linkedTopics = new ConcurrentHashMap();
        linkedTopics.putAll((Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(this.topics()).asJava());
        EasyMock.expect((Object)this.manager().listClusterLinks()).andReturn(this.linkData()).anyTimes();
        ((TraversableLike)this.partitions().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Tuple2 data = (Tuple2)x0$1._1();
            int index = x0$1._2$mcI$sp();
            ClusterLinkFetcherManager fetcherManager = (ClusterLinkFetcherManager)EasyMock.mock(ClusterLinkFetcherManager.class);
            EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fetcherManager.mirrorPartitionCount())).andReturn((Object)BoxesRunTime.boxToInteger((int)data._1$mcI$sp())).anyTimes();
            EasyMock.replay((Object[])new Object[]{fetcherManager});
            IExpectationSetters iExpectationSetters = EasyMock.expect((Object)this.manager().fetcherManager(((ClusterLinkData)this.linkData().apply(index)).linkId())).andReturn((Object)new Some((Object)fetcherManager)).anyTimes();
            return iExpectationSetters;
        }, Seq$.MODULE$.canBuildFrom());
        ((IterableLike)this.paused().zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            boolean paused = x0$2._1$mcZ$sp();
            int index = x0$2._2$mcI$sp();
            ClusterLinkConfig config = (ClusterLinkConfig)EasyMock.mock(ClusterLinkConfig.class);
            EasyMock.expect((Object)config.clusterLinkPaused()).andReturn((Object)Predef$.MODULE$.boolean2Boolean(paused)).anyTimes();
            EasyMock.replay((Object[])new Object[]{config});
            ClusterLinkClientManager clientManager = (ClusterLinkClientManager)EasyMock.mock(ClusterLinkClientManager.class);
            EasyMock.expect((Object)clientManager.currentConfig()).andReturn((Object)config).anyTimes();
            EasyMock.replay((Object[])new Object[]{clientManager});
            IExpectationSetters iExpectationSetters = EasyMock.expect((Object)this.manager().clientManager(((ClusterLinkData)this.linkData().apply(index)).linkId())).andReturn((Object)new Some((Object)clientManager)).anyTimes();
            return iExpectationSetters;
        });
        EasyMock.expect((Object)this.manager().controller()).andReturn((Object)this.controller()).anyTimes();
        this.linkData().foreach((Function1 & Serializable & scala.Serializable)data -> {
            EasyMock.expect((Object)this.manager().resolveLinkId(data.linkName())).andReturn((Object)new Some((Object)data.linkId())).anyTimes();
            return EasyMock.expect((Object)this.manager().linkState(data.linkName())).andReturn((Object)ActiveClusterLink$.MODULE$).anyTimes();
        });
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)isController)).anyTimes();
        EasyMock.expect((Object)this.controller().controllerContext()).andReturn((Object)this.controllerContext()).anyTimes();
        EasyMock.expect((Object)this.controllerContext().linkedTopics()).andReturn(CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(linkedTopics).asScala()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.manager()});
        EasyMock.replay((Object[])new Object[]{this.controller()});
        EasyMock.replay((Object[])new Object[]{this.controllerContext()});
    }

    private boolean setupMock$default$1() {
        return true;
    }

    private void assertMetricEquals(MetricName name, double expectedValue) {
        Option option = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(this.metrics().metrics()).asScala()).get((Object)name);
        if (option instanceof Some) {
            KafkaMetric metric = (KafkaMetric)((Some)option).value();
            Assertions.assertEquals((Object)BoxesRunTime.boxToDouble((double)expectedValue), (Object)metric.metricValue());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Metric ").append(name).append(" not found").toString());
            return;
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void $anonfun$testMetrics$1(ClusterLinkMetricsTest $this, Sensor s) {
        Assertions.assertNotNull((Object)s, (String)"Sensor should be initialized");
        Assertions.assertNotNull((Object)$this.metrics().sensor(s.name()), (String)new StringBuilder(22).append("Sensor ").append(s.name()).append(" not registered").toString());
    }

    public static final /* synthetic */ void $anonfun$testMetrics$2(ClusterLinkMetricsTest $this, Sensor s) {
        Assertions.assertNotNull((Object)s, (String)"Sensor should be initialized");
        Assertions.assertNotNull((Object)$this.metrics().sensor(s.name()), (String)new StringBuilder(22).append("Sensor ").append(s.name()).append(" not registered").toString());
    }

    public static final /* synthetic */ void $anonfun$testMetrics$3(ClusterLinkMetricsTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            boolean bl;
            String state = (String)x0$1._1();
            MetricName name = (MetricName)x0$1._2();
            String string = TopicLinkMirror$.MODULE$.name();
            if (!(string != null ? !string.equals(state) : state != null)) {
                bl = true;
            } else {
                String string2 = TopicLinkPausedMirror$.MODULE$.name();
                if (!(string2 != null ? !string2.equals(state) : state != null)) {
                    bl = false;
                } else {
                    String string3 = TopicLinkPendingStoppedMirror$.MODULE$.name();
                    if (!(string3 != null ? !string3.equals(state) : state != null)) {
                        bl = false;
                    } else {
                        String string4 = TopicLinkStoppedMirror$.MODULE$.name();
                        if (!(string4 != null ? !string4.equals(state) : state != null)) {
                            bl = true;
                        } else {
                            String string5 = TopicLinkFailedMirror$.MODULE$.name();
                            if (!(string5 != null ? !string5.equals(state) : state != null)) {
                                bl = true;
                            } else {
                                throw new AssertionError((Object)new StringBuilder(17).append("Unexpected state ").append(state).toString());
                            }
                        }
                    }
                }
            }
            $this.assertMetricEquals(name, (double)bl);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testMetrics$4(ClusterLinkMetricsTest $this, Sensor s) {
        Assertions.assertNull((Object)$this.metrics().getSensor(s.name()), (String)new StringBuilder(32).append("Sensor ").append(s.name()).append(" should not be registered").toString());
    }

    public static final /* synthetic */ void $anonfun$testMetrics$5(ClusterLinkMetricsTest $this, Sensor s) {
        Assertions.assertNotNull((Object)$this.metrics().sensor(s.name()), (String)new StringBuilder(34).append("Sensor ").append(s.name()).append(" should still be registered").toString());
    }

    public static final /* synthetic */ void $anonfun$testPausedTopicMetrics$1(ClusterLinkMetricsTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            int n;
            String state = (String)x0$1._1();
            MetricName name = (MetricName)x0$1._2();
            String string = TopicLinkMirror$.MODULE$.name();
            if (!(string != null ? !string.equals(state) : state != null)) {
                n = 2;
            } else {
                String string2 = TopicLinkPausedMirror$.MODULE$.name();
                if (!(string2 != null ? !string2.equals(state) : state != null)) {
                    n = 2;
                } else {
                    String string3 = TopicLinkPendingStoppedMirror$.MODULE$.name();
                    if (!(string3 != null ? !string3.equals(state) : state != null)) {
                        n = 0;
                    } else {
                        String string4 = TopicLinkStoppedMirror$.MODULE$.name();
                        if (!(string4 != null ? !string4.equals(state) : state != null)) {
                            n = 0;
                        } else {
                            String string5 = TopicLinkFailedMirror$.MODULE$.name();
                            if (!(string5 != null ? !string5.equals(state) : state != null)) {
                                n = 0;
                            } else {
                                throw new AssertionError((Object)new StringBuilder(17).append("Unexpected state ").append(state).toString());
                            }
                        }
                    }
                }
            }
            $this.assertMetricEquals(name, n);
            return;
        }
        throw new MatchError(null);
    }

    public ClusterLinkMetricsTest() {
        this.tenant = "test-tenant";
    }
}

