/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.server.link.ClusterLinkPauseMirrorTopics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.concurrent.TrieMap;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t-b\u0001\u0002\u00180\u0001YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013%!\t\u0003\u0004L\u0001\u0001\u0006Ia\u0011\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003N\u0011\u0019!\u0006\u0001)A\u0005\u001d\"9Q\u000b\u0001b\u0001\n\u00131\u0006B\u00022\u0001A\u0003%q\u000bC\u0004d\u0001\t\u0007I\u0011\u0002\"\t\r\u0011\u0004\u0001\u0015!\u0003D\u0011\u001d)\u0007A1A\u0005\n5CaA\u001a\u0001!\u0002\u0013q\u0005bB4\u0001\u0005\u0004%I\u0001\u001b\u0005\u0007Y\u0002\u0001\u000b\u0011B5\t\u000f5\u0004!\u0019!C\u0005]\"1a\u000f\u0001Q\u0001\n=Dqa\u001e\u0001C\u0002\u0013%\u0001\u0010\u0003\u0004\u007f\u0001\u0001\u0006I!\u001f\u0005\t\u007f\u0002\u0011\r\u0011\"\u0003\u0002\u0002!A\u0011\u0011\u0002\u0001!\u0002\u0013\t\u0019\u0001C\u0005\u0002\f\u0001\u0011\r\u0011\"\u0003\u0002\u000e!A\u0011Q\u0003\u0001!\u0002\u0013\ty\u0001C\u0004\u0002\u0018\u0001!\t!!\u0007\t\u000f\u0005]\u0002\u0001\"\u0001\u0002\u001a!9\u0011\u0011\t\u0001\u0005\u0002\u0005e\u0001bBA&\u0001\u0011\u0005\u0011\u0011\u0004\u0005\b\u0003\u001f\u0002A\u0011AA\r\u0011\u001d\t\u0019\u0006\u0001C\u0001\u00033Aq!a\u0016\u0001\t\u0003\tI\u0002C\u0004\u0002\\\u0001!\t!!\u0007\t\u000f\u0005}\u0003\u0001\"\u0003\u0002b!9\u0011Q\u000e\u0001\u0005\n\u0005e\u0001bBA8\u0001\u0011%\u0011\u0011\u0004\u0005\b\u0003c\u0002A\u0011BA:\u0011\u001d\tI\b\u0001C\u0005\u0003wBq!a \u0001\t\u0013\t\t\tC\u0004\u0002\f\u0002!I!!$\t\u000f\u0005u\u0005\u0001\"\u0003\u0002 \"9\u00111\u0015\u0001\u0005\n\u0005\u0015\u0006bBAU\u0001\u0011%\u00111\u0016\u0005\b\u0003_\u0003A\u0011BAY\u0011\u001d\t\u0019\r\u0001C\u0005\u0003\u000bDq!a3\u0001\t\u0013\ti\rC\u0004\u0002\\\u0002!I!!8\t\u000f\u0005m\b\u0001\"\u0003\u0002~\"9!q\u0003\u0001\u0005\n\te!\u0001I\"mkN$XM\u001d'j].\u0004\u0016-^:f\u001b&\u0014(o\u001c:U_BL7m\u001d+fgRT!\u0001M\u0019\u0002\t1Lgn\u001b\u0006\u0003eM\naa]3sm\u0016\u0014(\"\u0001\u001b\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u000e\t\u0003qmj\u0011!\u000f\u0006\u0002u\u0005)1oY1mC&\u0011A(\u000f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005y\u0004C\u0001!\u0001\u001b\u0005y\u0013\u0001\u00037j].t\u0015-\\3\u0016\u0003\r\u0003\"\u0001R%\u000e\u0003\u0015S!AR$\u0002\t1\fgn\u001a\u0006\u0002\u0011\u0006!!.\u0019<b\u0013\tQUI\u0001\u0004TiJLgnZ\u0001\nY&t7NT1nK\u0002\na\u0001\\5oW&#W#\u0001(\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E;\u0015\u0001B;uS2L!a\u0015)\u0003\tU+\u0016\nR\u0001\bY&t7.\u00133!\u00035\u0019x.\u001e:dKR{\u0007/[2JIV\tq\u000b\u0005\u0002YA6\t\u0011L\u0003\u0002[7\u000611m\\7n_:T!\u0001\u000e/\u000b\u0005us\u0016AB1qC\u000eDWMC\u0001`\u0003\ry'oZ\u0005\u0003Cf\u0013A!V;jI\u0006q1o\\;sG\u0016$v\u000e]5d\u0013\u0012\u0004\u0013!D8uQ\u0016\u0014H*\u001b8l\u001d\u0006lW-\u0001\bpi\",'\u000fT5oW:\u000bW.\u001a\u0011\u0002\u0017=$\b.\u001a:MS:\\\u0017\nZ\u0001\r_RDWM\u001d'j].LE\rI\u0001\ng\u000eDW\rZ;mKJ,\u0012!\u001b\t\u0003\u0001*L!a[\u0018\u0003)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\u0006C\u0012l\u0017N\\\u000b\u0002_B\u0011\u0001\u000f^\u0007\u0002c*\u0011QN\u001d\u0006\u0003gn\u000bqa\u00197jK:$8/\u0003\u0002vc\nq1i\u001c8gYV,g\u000e^!e[&t\u0017AB1e[&t\u0007%\u0001\u0006d_:$(o\u001c7mKJ,\u0012!\u001f\t\u0003url\u0011a\u001f\u0006\u0003oNJ!!`>\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJ\f1bY8oiJ|G\u000e\\3sA\u0005\t2m\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0016\u0005\u0005\r\u0001c\u0001>\u0002\u0006%\u0019\u0011qA>\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH/\u0001\nd_:$(o\u001c7mKJ\u001cuN\u001c;fqR\u0004\u0013!F7bqR{\u0007/[2t!\u0016\u0014\u0018\n^3sCRLwN\\\u000b\u0003\u0003\u001f\u00012\u0001OA\t\u0013\r\t\u0019\"\u000f\u0002\u0004\u0013:$\u0018AF7bqR{\u0007/[2t!\u0016\u0014\u0018\n^3sCRLwN\u001c\u0011\u0002\u000bM,G/\u00169\u0015\u0005\u0005m\u0001c\u0001\u001d\u0002\u001e%\u0019\u0011qD\u001d\u0003\tUs\u0017\u000e\u001e\u0015\u0004-\u0005\r\u0002\u0003BA\u0013\u0003gi!!a\n\u000b\t\u0005%\u00121F\u0001\u0004CBL'\u0002BA\u0017\u0003_\tqA[;qSR,'OC\u0002\u00022y\u000bQA[;oSRLA!!\u000e\u0002(\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3aFA\u001e!\u0011\t)#!\u0010\n\t\u0005}\u0012q\u0005\u0002\n\u0003\u001a$XM]#bG\"\f!\u0004^3tiB\u000bWo]3NSJ\u0014xN\u001d+pa&\u001c7/R7qifD3\u0001GA#!\u0011\t)#a\u0012\n\t\u0005%\u0013q\u0005\u0002\u0005)\u0016\u001cH/\u0001\u000euKN$\b+Y;tK6K'O]8s)>\u0004\u0018nY:QCV\u001cX\rK\u0002\u001a\u0003\u000b\nA\u0004^3tiB\u000bWo]3NSJ\u0014xN\u001d+pa&\u001c7/\u00168qCV\u001cX\rK\u0002\u001b\u0003\u000b\n!\u0005^3tiB\u000bWo]3NSJ\u0014xN\u001d+pa&\u001c7OT8u\u0007>tGO]8mY\u0016\u0014\bfA\u000e\u0002F\u0005\u0019C/Z:u!\u0006,8/Z'jeJ|'\u000fV8qS\u000e\u001c\b+Y;tK\u0016C8-\u001a9uS>t\u0007f\u0001\u000f\u0002F\u0005aB/Z:u!\u0006,8/Z'jeJ|'\u000fV8qS\u000e\u001c\u0018IY8si\u0016$\u0007fA\u000f\u0002F\u0005I1/\u001a;va6{7m\u001b\u000b\u0005\u00037\t\u0019\u0007C\u0004\u0002fy\u0001\r!a\u001a\u0002\u0019%\u001c8i\u001c8ue>dG.\u001a:\u0011\u0007a\nI'C\u0002\u0002le\u0012qAQ8pY\u0016\fg.\u0001\u0006sKBd\u0017-_'pG.\f!B^3sS\u001aLXj\\2l\u0003)!x\u000eT5oW:\u000bW.\u001a\u000b\u0004\u0007\u0006U\u0004bBA<C\u0001\u0007\u0011qM\u0001\bSN|E\u000f[3s\u0003!!x\u000eT5oW&#Gc\u0001(\u0002~!9\u0011q\u000f\u0012A\u0002\u0005\u001d\u0014aC1di&4Xm\u0015;bi\u0016$B!a!\u0002\nB\u0019\u0001)!\"\n\u0007\u0005\u001duFA\u000bDYV\u001cH/\u001a:MS:\\Gk\u001c9jGN#\u0018\r^3\t\u000f\u0005]4\u00051\u0001\u0002h\u0005Y\u0001/Y;tK\u0012\u001cF/\u0019;f))\t\u0019)a$\u0002\u0012\u0006U\u0015\u0011\u0014\u0005\b\u0003o\"\u0003\u0019AA4\u0011\u001d\t\u0019\n\na\u0001\u0003O\n\u0011\u0002\\5oW2+g/\u001a7\t\u000f\u0005]E\u00051\u0001\u0002h\u0005QAo\u001c9jG2+g/\u001a7\t\u000f\u0005mE\u00051\u0001\u0002h\u0005Iq/Y:GC&dW\rZ\u0001\fM\u0006LG.\u001a3Ti\u0006$X\r\u0006\u0003\u0002\u0004\u0006\u0005\u0006bBA<K\u0001\u0007\u0011qM\u0001\u0014a\u0016tG-\u001b8h'R|\u0007\u000f]3e'R\fG/\u001a\u000b\u0005\u0003\u0007\u000b9\u000bC\u0004\u0002x\u0019\u0002\r!a\u001a\u0002\u0019M$x\u000e\u001d9fIN#\u0018\r^3\u0015\t\u0005\r\u0015Q\u0016\u0005\b\u0003o:\u0003\u0019AA4\u0003QqWm\u001e)bkN,W*\u001b:s_J$v\u000e]5dgR!\u00111WA]!\r\u0001\u0015QW\u0005\u0004\u0003o{#\u0001H\"mkN$XM\u001d'j].\u0004\u0016-^:f\u001b&\u0014(o\u001c:U_BL7m\u001d\u0005\b\u0003wC\u0003\u0019AA_\u00031a\u0017N\\6JgB\u000bWo]3e!\u0015A\u0014qXA4\u0013\r\t\t-\u000f\u0002\n\rVt7\r^5p]B\nqA];o\u001f:\u001cW\r\u0006\u0003\u0002\u001c\u0005\u001d\u0007bBAeS\u0001\u0007\u00111W\u0001\u0005i\u0006\u001c8.A\u000boK^\u0004\u0016-^:f'V\u001c7-Z:t\rV$XO]3\u0015\u0005\u0005=\u0007#\u0002-\u0002R\u0006U\u0017bAAj3\nY1*\u00194lC\u001a+H/\u001e:f!\r!\u0015q[\u0005\u0004\u00033,%\u0001\u0002,pS\u0012\fQC\\3x!\u0006,8/\u001a$bS2,(/\u001a$viV\u0014X\r\u0006\u0003\u0002P\u0006}\u0007bBAqW\u0001\u0007\u00111]\u0001\u0003Kb\u0004B!!:\u0002v:!\u0011q]Ay\u001d\u0011\tI/a<\u000e\u0005\u0005-(bAAwk\u00051AH]8pizJ\u0011AO\u0005\u0004\u0003gL\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003o\fIPA\u0005UQJ|w/\u00192mK*\u0019\u00111_\u001d\u0002%\u0015D\b/Z2u\u0019&t7.\u001a3U_BL7m\u001d\u000b\u0005\u00037\ty\u0010C\u0004\u0003\u00021\u0002\rAa\u0001\u0002\u00191Lgn[3e)>\u0004\u0018nY:\u0011\u0011\t\u0015!Q\u0002B\n\u0003\u0007sAAa\u0002\u0003\nA\u0019\u0011\u0011^\u001d\n\u0007\t-\u0011(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u001f\u0011\tBA\u0002NCBT1Aa\u0003:!\u0011\u0011)A!\u0006\n\u0007)\u0013\t\"\u0001\nfqB,7\r\u001e)bkN,W*\u001b:s_J\u001cHCBA\u000e\u00057\u00119\u0003C\u0004\u0003\u001e5\u0002\rAa\b\u0002\rY\fG.^3t!!\u0011)A!\u0004\u0003\u0014\t\u0005\u0002#\u0002\u001d\u0003$\u0005\r\u0018b\u0001B\u0013s\t1q\n\u001d;j_:DqA!\u000b.\u0001\u0004\t9'\u0001\u0004f]\u0006\u0014G.\u001a")
public class ClusterLinkPauseMirrorTopicsTest {
    private final String linkName;
    private final UUID linkId = UUID.randomUUID();
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final String otherLinkName;
    private final UUID otherLinkId = UUID.randomUUID();
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final ConfluentAdmin admin = (ConfluentAdmin)EasyMock.mock(ConfluentAdmin.class);
    private final KafkaController controller = (KafkaController)EasyMock.mock(KafkaController.class);
    private final ControllerContext controllerContext = (ControllerContext)EasyMock.mock(ControllerContext.class);
    private final int maxTopicsPerIteration;

    private String linkName() {
        return this.linkName;
    }

    private UUID linkId() {
        return this.linkId;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private String otherLinkName() {
        return this.otherLinkName;
    }

    private UUID otherLinkId() {
        return this.otherLinkId;
    }

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConfluentAdmin admin() {
        return this.admin;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private int maxTopicsPerIteration() {
        return this.maxTopicsPerIteration;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
    }

    @Test
    public void testPauseMirrorTopicsEmpty() {
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)Predef$.MODULE$.Map().empty());
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)Predef$.MODULE$.Map().empty());
        this.replayMock();
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)isPaused -> {
            ClusterLinkPauseMirrorTopicsTest.$anonfun$testPauseMirrorTopicsEmpty$1(this, BoxesRunTime.unboxToBoolean((Object)isPaused));
            return BoxedUnit.UNIT;
        });
        this.verifyMock();
    }

    @Test
    public void testPauseMirrorTopicsPause() {
        scala.collection.immutable.Map linkedTopics = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"active"), (Object)this.activeState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic"), (Object)this.pausedState(false, false, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both"), (Object)this.pausedState(false, true, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic-failed"), (Object)this.pausedState(false, false, true, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link-failed"), (Object)this.pausedState(false, true, false, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both-failed"), (Object)this.pausedState(false, true, true, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failed"), (Object)this.failedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pending-stopped"), (Object)this.pendingStoppedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stopped"), (Object)this.stoppedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-active"), (Object)this.activeState(true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-paused-topic"), (Object)this.pausedState(true, false, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-paused-link"), (Object)this.pausedState(true, true, false, false))}));
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)linkedTopics);
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"active"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic-failed"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failed"), (Object)None$.MODULE$)}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)Predef$.MODULE$.Map().empty());
        this.replayMock();
        JFunction0.mcZ.sp & Serializable & scala.Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true;
        this.runOnce(new ClusterLinkPauseMirrorTopics(this.linkId(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.admin(), this.maxTopicsPerIteration(), 10, 10));
        this.verifyMock();
    }

    @Test
    public void testPauseMirrorTopicsUnpause() {
        scala.collection.immutable.Map linkedTopics = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"active"), (Object)this.activeState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic"), (Object)this.pausedState(false, false, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both"), (Object)this.pausedState(false, true, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-topic-failed"), (Object)this.pausedState(false, false, true, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link-failed"), (Object)this.pausedState(false, true, false, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both-failed"), (Object)this.pausedState(false, true, true, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"failed"), (Object)this.failedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pending-stopped"), (Object)this.pendingStoppedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stopped"), (Object)this.stoppedState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-active"), (Object)this.activeState(true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-paused-topic"), (Object)this.pausedState(true, false, true, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-paused-link"), (Object)this.pausedState(true, true, false, false))}));
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)linkedTopics);
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-link-failed"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paused-both-failed"), (Object)None$.MODULE$)}))), false);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)Predef$.MODULE$.Map().empty());
        this.replayMock();
        JFunction0.mcZ.sp & Serializable & scala.Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false;
        this.runOnce(new ClusterLinkPauseMirrorTopics(this.linkId(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.admin(), this.maxTopicsPerIteration(), 10, 10));
        this.verifyMock();
    }

    @Test
    public void testPauseMirrorTopicsNotController() {
        this.setupMock(false);
        this.replayMock();
        Function0 & Serializable & scala.Serializable newPauseMirrorTopics_linkIsPaused = (Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("unexpected");
        };
        this.runOnce(new ClusterLinkPauseMirrorTopics(this.linkId(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.admin(), this.maxTopicsPerIteration(), 10, 10));
        this.verifyMock();
    }

    @Test
    public void testPauseMirrorTopicsPauseException() {
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)this.activeState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)new Some((Object)new TimeoutException("")))}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)this.activeState(false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)None$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)new Some((Object)new TimeoutException("")))}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)None$.MODULE$)}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-1"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-2"), (Object)this.pausedState(false, true, false, false)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-3"), (Object)this.pausedState(false, true, false, false))}))));
        this.replayMock();
        JFunction0.mcZ.sp & Serializable & scala.Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true;
        this.runOnce(new ClusterLinkPauseMirrorTopics(this.linkId(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.admin(), this.maxTopicsPerIteration(), 10, 10));
        this.verifyMock();
    }

    @Test
    public void testPauseMirrorTopicsAborted() {
        this.setupMock(true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)new Some((Object)new TimeoutException("")))}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)this.activeState(false))}))));
        this.expectPauseMirrors((scala.collection.immutable.Map<String, Option<Throwable>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)new Some((Object)new TimeoutException("")))}))), true);
        this.expectLinkedTopics((scala.collection.immutable.Map<String, ClusterLinkTopicState>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic"), (Object)this.activeState(false))}))));
        this.replayMock();
        IntRef check = IntRef.create((int)0);
        JFunction0.mcZ.sp & Serializable & scala.Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            ++check$1.elem;
            return check$1.elem < 3;
        };
        this.runOnce(new ClusterLinkPauseMirrorTopics(this.linkId(), (Function0)newPauseMirrorTopics_linkIsPaused, this.scheduler(), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.admin(), this.maxTopicsPerIteration(), 10, 10));
        this.verifyMock();
    }

    private void setupMock(boolean isController) {
        EasyMock.reset((Object[])new Object[]{this.admin()});
        EasyMock.reset((Object[])new Object[]{this.controller()});
        EasyMock.reset((Object[])new Object[]{this.controllerContext()});
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)isController)).anyTimes();
        EasyMock.expect((Object)this.controller().controllerContext()).andReturn((Object)this.controllerContext()).anyTimes();
    }

    private void replayMock() {
        EasyMock.replay((Object[])new Object[]{this.admin()});
        EasyMock.replay((Object[])new Object[]{this.controller()});
        EasyMock.replay((Object[])new Object[]{this.controllerContext()});
    }

    private void verifyMock() {
        EasyMock.verify((Object[])new Object[]{this.admin()});
        EasyMock.verify((Object[])new Object[]{this.controller()});
        EasyMock.verify((Object[])new Object[]{this.controllerContext()});
    }

    private String toLinkName(boolean isOther) {
        if (isOther) {
            return this.otherLinkName();
        }
        return this.linkName();
    }

    private UUID toLinkId(boolean isOther) {
        if (isOther) {
            return this.otherLinkId();
        }
        return this.linkId();
    }

    private ClusterLinkTopicState activeState(boolean isOther) {
        return new ClusterLinkTopicState.Mirror(this.toLinkName(isOther), this.toLinkId(isOther), this.sourceTopicId(), 111111111L);
    }

    private ClusterLinkTopicState pausedState(boolean isOther, boolean linkLevel, boolean topicLevel, boolean wasFailed) {
        return new ClusterLinkTopicState.PausedMirror(this.toLinkName(isOther), this.toLinkId(isOther), this.sourceTopicId(), linkLevel, topicLevel, wasFailed, 22222222L);
    }

    private ClusterLinkTopicState failedState(boolean isOther) {
        return new ClusterLinkTopicState.FailedMirror(this.toLinkName(isOther), this.toLinkId(isOther), this.sourceTopicId(), 33333333L);
    }

    private ClusterLinkTopicState pendingStoppedState(boolean isOther) {
        return new ClusterLinkTopicState.PendingStoppedMirror(this.toLinkName(isOther), this.toLinkId(isOther), this.sourceTopicId(), false, 44444444L);
    }

    private ClusterLinkTopicState stoppedState(boolean isOther) {
        return new ClusterLinkTopicState.StoppedMirror(this.toLinkName(isOther), this.toLinkId(isOther), this.sourceTopicId(), (Seq)Nil$.MODULE$, 555555555L);
    }

    private ClusterLinkPauseMirrorTopics newPauseMirrorTopics(Function0<Object> linkIsPaused) {
        return new ClusterLinkPauseMirrorTopics(this.linkId(), linkIsPaused, this.scheduler(), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.admin(), this.maxTopicsPerIteration(), 10, 10);
    }

    private void runOnce(ClusterLinkPauseMirrorTopics task) {
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)task.runOnce().get(5L, TimeUnit.SECONDS)));
    }

    private KafkaFuture<Void> newPauseSuccessFuture() {
        return KafkaFuture.completedFuture(null);
    }

    /*
     * WARNING - void declaration
     */
    private KafkaFuture<Void> newPauseFailureFuture(Throwable ex) {
        void var2_2;
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally(ex);
        return var2_2;
    }

    private void expectLinkedTopics(scala.collection.immutable.Map<String, ClusterLinkTopicState> linkedTopics) {
        TrieMap map = new TrieMap();
        map.$plus$plus$eq(linkedTopics);
        EasyMock.expect((Object)this.controllerContext().linkedTopics()).andReturn((Object)map);
    }

    private void expectPauseMirrors(scala.collection.immutable.Map<String, Option<Throwable>> values, boolean enable) {
        AlterMirrorOp pauseOp = enable ? AlterMirrorOp.PAUSE_LINK : AlterMirrorOp.RESUME_LINK;
        scala.collection.immutable.Map ops = ((TraversableOnce)values.keys().map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)pauseOp), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map results = (scala.collection.immutable.Map)values.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String t = (String)x0$1._1();
                Option option = (Option)x0$1._2();
                if (option instanceof Some) {
                    Throwable ex = (Throwable)((Some)option).value();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), this.newPauseFailureFuture(ex));
                }
            }
            if (x0$1 == null) throw new MatchError(x0$1);
            String t = (String)x0$1._1();
            Option option = (Option)x0$1._2();
            if (!None$.MODULE$.equals(option)) throw new MatchError(x0$1);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t), this.newPauseSuccessFuture());
        }, Map$.MODULE$.canBuildFrom());
        EasyMock.expect((Object)this.admin().alterMirrors((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)ops).asJava()), (AlterMirrorsOptions)EasyMock.anyObject())).andReturn((Object)new AlterMirrorsResult((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)results).asJava()));
    }

    public static final /* synthetic */ void $anonfun$testPauseMirrorTopicsEmpty$1(ClusterLinkPauseMirrorTopicsTest $this, boolean isPaused) {
        JFunction0.mcZ.sp & Serializable & scala.Serializable newPauseMirrorTopics_linkIsPaused = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> isPaused;
        ClusterLinkPauseMirrorTopics clusterLinkPauseMirrorTopics = new ClusterLinkPauseMirrorTopics($this.linkId(), (Function0)newPauseMirrorTopics_linkIsPaused, $this.scheduler(), $this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.admin(), $this.maxTopicsPerIteration(), 10, 10);
        $this.runOnce(clusterLinkPauseMirrorTopics);
    }

    public ClusterLinkPauseMirrorTopicsTest() {
        this.linkName = "link-name";
        this.otherLinkName = "other-link-name";
        this.maxTopicsPerIteration = 5;
    }
}

