/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.controller.KafkaController;
import kafka.security.authorizer.AclEntry$;
import kafka.server.link.AclFiltersJson;
import kafka.server.link.AclJson$;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncAcls;
import kafka.server.link.LinkMode;
import kafka.utils.Implicits$;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeAclsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.Authorizer;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0015c\u0001B\u00193\u0001eBQ\u0001\u0011\u0001\u0005\u0002\u0005Cq\u0001\u0012\u0001C\u0002\u0013%Q\t\u0003\u0004J\u0001\u0001\u0006IA\u0012\u0005\b\u0015\u0002\u0011\r\u0011\"\u0003L\u0011\u0019A\u0006\u0001)A\u0005\u0019\"9\u0011\f\u0001b\u0001\n\u0013Q\u0006B\u00020\u0001A\u0003%1\fC\u0004`\u0001\t\u0007I\u0011\u00021\t\r\u001d\u0004\u0001\u0015!\u0003b\u0011\u001dA\u0007A1A\u0005\n%Daa\u001c\u0001!\u0002\u0013Q\u0007b\u00029\u0001\u0005\u0004%I!\u001d\u0005\u0007k\u0002\u0001\u000b\u0011\u0002:\t\u000fY\u0004!\u0019!C\u0005o\"9\u0011\u0011\u0003\u0001!\u0002\u0013A\b\"CA\n\u0001\t\u0007I\u0011AA\u000b\u0011!\ti\u0003\u0001Q\u0001\n\u0005]\u0001\"CA\u0018\u0001\t\u0007I\u0011AA\u000b\u0011!\t\t\u0004\u0001Q\u0001\n\u0005]\u0001\"CA\u001a\u0001\t\u0007I\u0011AA\u000b\u0011!\t)\u0004\u0001Q\u0001\n\u0005]\u0001bBA\u001c\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003/\u0002A\u0011AA\u001d\u0011\u001d\t\t\u0007\u0001C\u0005\u0003sAq!a\u0019\u0001\t\u0003\tI\u0004C\u0004\u0002n\u0001!\t!!\u000f\t\u000f\u0005E\u0004\u0001\"\u0001\u0002:!9\u0011Q\u000f\u0001\u0005\u0002\u0005e\u0002bBA=\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003{\u0002A\u0011AA\u001d\u0011\u001d\t\t\t\u0001C\u0001\u0003sAq!!\"\u0001\t\u0003\tI\u0004C\u0004\u0002\n\u0002!\t!!\u000f\t\u000f\u00055\u0005\u0001\"\u0001\u0002:!9\u0011\u0011\u0013\u0001\u0005\u0002\u0005e\u0002bBAK\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u00033\u0003A\u0011AA\u001d\u0011\u001d\ti\n\u0001C\u0001\u0003sAq!!)\u0001\t\u0003\tI\u0004C\u0004\u0002&\u0002!I!a*\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\"9\u0011\u0011\u001e\u0001\u0005\n\u0005-\bbBAx\u0001\u0011%\u0011\u0011\u001f\u0005\b\u0005#\u0001A\u0011\u0002B\n\u0011\u001d\u00119\u0002\u0001C\u0005\u00053AqA!\u000b\u0001\t\u0013\u0011Y\u0003C\u0004\u00030\u0001!IA!\r\t\u000f\t\r\u0003\u0001\"\u0003\u0002:\t92\t\\;ti\u0016\u0014H*\u001b8l'ft7-Q2mgR+7\u000f\u001e\u0006\u0003gQ\nA\u0001\\5oW*\u0011QGN\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003]\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001uA\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\"\u0011\u0005\r\u0003Q\"\u0001\u001a\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014X#\u0001$\u0011\u0005\r;\u0015B\u0001%3\u0005Q\u0019E.^:uKJd\u0015N\\6TG\",G-\u001e7fe\u0006Q1o\u00195fIVdWM\u001d\u0011\u0002\u000b\u0005$W.\u001b8\u0016\u00031\u0003\"!\u0014,\u000e\u00039S!AS(\u000b\u0005A\u000b\u0016aB2mS\u0016tGo\u001d\u0006\u0003oIS!a\u0015+\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0016aA8sO&\u0011qK\u0014\u0002\u000f\u0007>tg\r\\;f]R\fE-\\5o\u0003\u0019\tG-\\5oA\u0005i1\r\\5f]Rl\u0015M\\1hKJ,\u0012a\u0017\t\u0003\u0007rK!!\u0018\u001a\u00031\rcWo\u001d;fe2Kgn[\"mS\u0016tG/T1oC\u001e,'/\u0001\bdY&,g\u000e^'b]\u0006<WM\u001d\u0011\u0002\u0015\u0005,H\u000f[8sSj,'/F\u0001b!\t\u0011W-D\u0001d\u0015\tyFM\u0003\u00026#&\u0011am\u0019\u0002\u000b\u0003V$\bn\u001c:ju\u0016\u0014\u0018aC1vi\"|'/\u001b>fe\u0002\n!bY8oiJ|G\u000e\\3s+\u0005Q\u0007CA6n\u001b\u0005a'B\u000157\u0013\tqGNA\bLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s\u0003-\u0019wN\u001c;s_2dWM\u001d\u0011\u0002\u000f5,GO]5dgV\t!\u000f\u0005\u0002Dg&\u0011AO\r\u0002\u0013\u00072,8\u000f^3s\u0019&t7.T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003\u001d\t7\r\u001c'jgR,\u0012\u0001\u001f\t\u0005sz\f\t!D\u0001{\u0015\tYH0\u0001\u0003vi&d'\"A?\u0002\t)\fg/Y\u0005\u0003\u007fj\u0014A\u0001T5tiB!\u00111AA\u0007\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011aA1dY*\u0019\u00111B)\u0002\r\r|W.\\8o\u0013\u0011\ty!!\u0002\u0003\u0015\u0005\u001bGNQ5oI&tw-\u0001\u0005bG2d\u0015n\u001d;!\u0003mi\u0017n\u001a:bi\u0016|e.\u001a)sS:\u001c\u0017\u000e]1m\u0003\u000ed7OS:p]V\u0011\u0011q\u0003\t\u0005\u00033\t9C\u0004\u0003\u0002\u001c\u0005\r\u0002cAA\u000fy5\u0011\u0011q\u0004\u0006\u0004\u0003CA\u0014A\u0002\u001fs_>$h(C\u0002\u0002&q\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0015\u0003W\u0011aa\u0015;sS:<'bAA\u0013y\u0005aR.[4sCR,wJ\\3Qe&t7-\u001b9bY\u0006\u001bGn\u001d&t_:\u0004\u0013AE7jOJ\fG/Z!mY\u0006\u001bGn\u001d&t_:\f1#\\5he\u0006$X-\u00117m\u0003\u000ed7OS:p]\u0002\na#\\;mi&\u0004H.Z!dY\u001aKG\u000e^3sg*\u001bxN\\\u0001\u0018[VdG/\u001b9mK\u0006\u001bGNR5mi\u0016\u00148OS:p]\u0002\nQa]3u+B$\"!a\u000f\u0011\u0007m\ni$C\u0002\u0002@q\u0012A!\u00168ji\"\u001aa#a\u0011\u0011\t\u0005\u0015\u00131K\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u0005\u0019\u0011\r]5\u000b\t\u00055\u0013qJ\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\t\t\u0006V\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003+\n9E\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004/\u0005m\u0003\u0003BA#\u0003;JA!a\u0018\u0002H\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\ng\u0016$X\u000f]'pG.\f1\u0003^3ti\u0006\u001bGNR5mi\u0016\u0014X\u000b\u001d3bi\u0016D3!GA4!\u0011\t)%!\u001b\n\t\u0005-\u0014q\t\u0002\u0005)\u0016\u001cH/A\buKN$\u0018i\u00197BI\u0012LG/[8oQ\rQ\u0012qM\u0001-i\u0016\u001cH/Q2m\u0003\u0012$\u0017\u000e^5p]^KG\u000f['vYRL\u0007\u000f\\3BG2\u0014\u0015N\u001c3j]\u001e4\u0015\u000e\u001c;feND3aGA4\u0003\u0001\"Xm\u001d;O_J+\u0007/Z1uK\u0012,\u0006\u000fZ1uK^CWM\u001c(p\u0007\"\fgnZ3)\u0007q\t9'A\u001fuKN$hj\u001c*fa\u0016\fG/\u001a3Va\u0012\fG/Z,iK:tun\u00115b]\u001e,w+\u001b;i\u001bVdG/\u001b9mK\u0006\u001bGNQ5oI&twMR5mi\u0016\u00148\u000fK\u0002\u001e\u0003O\nq\u0002^3ti\u0006\u001bG\u000eR3mKRLwN\u001c\u0015\u0004=\u0005\u001d\u0014\u0001\f;fgR\f5\r\u001c#fY\u0016$\u0018n\u001c8XSRDW*\u001e7uSBdW-Q2m\u0005&tG-\u001b8h\r&dG/\u001a:tQ\ry\u0012qM\u0001\u001bi\u0016\u001cH/Q2m\u0003\u0012$\u0017\u000e^5p]\u0006sG\rR3mKRLwN\u001c\u0015\u0004A\u0005\u001d\u0014a\u000e;fgR\f5\r\\!eI&$\u0018n\u001c8B]\u0012$U\r\\3uS>tw+\u001b;i\u001bVdG/\u001b9mK\u0006\u001bGNQ5oI&twMR5mi\u0016\u00148\u000fK\u0002\"\u0003O\nQ\u0006^3ti:{W\t_2faRLwN\\:UQJ|wO\\%g+:\f'\r\\3U_\u001e+GoU8ve\u000e,\u0017i\u00197tQ\r\u0011\u0013qM\u00012i\u0016\u001cH/\u0012:s_J|e.Q2m\u0003\u0012$\u0017\u000e^5p]V\u0003H-\u0019;fg2{7-\u00197BG2\u001cV\r^\"peJ,7\r\u001e7zQ\r\u0019\u0013qM\u00012i\u0016\u001cH/\u0012:s_J|e.Q2m\t\u0016dW\r^5p]V\u0003H-\u0019;fg2{7-\u00197BG2\u001cV\r^\"peJ,7\r\u001e7zQ\r!\u0013qM\u00018i\u0016\u001cH/\u0012:s_J|e.Q2m\u0003\u0012$\u0017\u000e^5p]\u001a+H/\u001e:f+B$\u0017\r^3t\u0019>\u001c\u0017\r\\!dYN+GoQ8se\u0016\u001cG\u000f\\=)\u0007\u0015\n9'A\u001cuKN$XI\u001d:pe>s\u0017i\u00197EK2,G/[8o\rV$XO]3Va\u0012\fG/Z:M_\u000e\fG.Q2m\u001b\u0006\u00048i\u001c:sK\u000e$H.\u001f\u0015\u0004M\u0005\u001d\u0014!\u0006;fgR,%O]8s\u001f:\u001cv.\u001e:dK\u0006\u001bGn\u001d\u0015\u0004O\u0005\u001d\u0014AC1dY\nKg\u000eZ5oOR\u0001\u0012\u0011AAU\u0003s\u000bi,a2\u0002L\u0006=\u0017\u0011\u001c\u0005\b\u0003WC\u0003\u0019AAW\u00031\u0011Xm]8ve\u000e,G+\u001f9f!\u0011\ty+!.\u000e\u0005\u0005E&\u0002BAZ\u0003\u0013\t\u0001B]3t_V\u00148-Z\u0005\u0005\u0003o\u000b\tL\u0001\u0007SKN|WO]2f)f\u0004X\rC\u0004\u0002<\"\u0002\r!a\u0006\u0002\u0019I,7o\\;sG\u0016t\u0015-\\3\t\u000f\u0005}\u0006\u00061\u0001\u0002B\u0006Y\u0001/\u0019;uKJtG+\u001f9f!\u0011\ty+a1\n\t\u0005\u0015\u0017\u0011\u0017\u0002\f!\u0006$H/\u001a:o)f\u0004X\rC\u0004\u0002J\"\u0002\r!a\u0006\u0002\u001bA\u0014\u0018N\\2ja\u0006dg*Y7f\u0011\u001d\ti\r\u000ba\u0001\u0003/\t\u0001\u0002[8ti:\u000bW.\u001a\u0005\b\u0003#D\u0003\u0019AAj\u00031\t7\r\\(qKJ\fG/[8o!\u0011\t\u0019!!6\n\t\u0005]\u0017Q\u0001\u0002\r\u0003\u000edw\n]3sCRLwN\u001c\u0005\b\u00037D\u0003\u0019AAo\u00039\u0001XM]7jgNLwN\u001c+za\u0016\u0004B!a\u0001\u0002`&!\u0011\u0011]A\u0003\u0005E\t5\r\u001c)fe6L7o]5p]RK\b/Z\u0001\u000eC\u0012$\u0017i\u00197CS:$\u0017N\\4\u0015\u0007a\f9\u000fC\u0004\u0002\b%\u0002\r!!\u0001\u0002!I,Wn\u001c<f\u0003\u000ed')\u001b8eS:<Gc\u0001=\u0002n\"9\u0011q\u0001\u0016A\u0002\u0005\u0005\u0011!G1dY\u000e\u0013X-\u0019;j_:\u001cVoY2fgN\u0014Vm];miN$B!a=\u0003\bA!\u0011P`A{!\u0019\t90!@\u0003\u00025\u0011\u0011\u0011 \u0006\u0004\u0003wT\u0018AC2p]\u000e,(O]3oi&!\u0011q`A}\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\u0004E\n\r\u0011b\u0001B\u0003G\ny\u0011i\u00197De\u0016\fG/\u001a*fgVdG\u000fC\u0004\u0003\n-\u0002\rAa\u0003\u0002\u00079,X\u000eE\u0002<\u0005\u001bI1Aa\u0004=\u0005\rIe\u000e^\u0001\u001aC\u000ed7I]3bi&|gNR1jYV\u0014XMU3tk2$8\u000f\u0006\u0003\u0002t\nU\u0001b\u0002B\u0005Y\u0001\u0007!1B\u0001\u001aC\u000edG)\u001a7fi&|gnU;dG\u0016\u001c8OU3tk2$8\u000f\u0006\u0003\u0003\u001c\t\u0015\u0002\u0003B=\u007f\u0005;\u0001b!a>\u0002~\n}\u0001c\u00012\u0003\"%\u0019!1E2\u0003\u001f\u0005\u001bG\u000eR3mKR,'+Z:vYRDaAa\n.\u0001\u0004A\u0018a\u00033fY\u0016$X\rZ!dYN\f\u0011$Y2m\t\u0016dW\r^5p]\u001a\u000b\u0017\u000e\\;sKJ+7/\u001e7ugR!!1\u0004B\u0017\u0011\u0019\u00119C\fa\u0001q\u0006Ia.Z<D_:4\u0017n\u001a\u000b\u0005\u0005g\u0011I\u0004E\u0002D\u0005kI1Aa\u000e3\u0005E\u0019E.^:uKJd\u0015N\\6D_:4\u0017n\u001a\u0005\b\u0005wy\u0003\u0019\u0001B\u001f\u0003\u001d\u0019wN\u001c4jON\u0004\u0002\"!\u0007\u0003@\u0005]\u0011qC\u0005\u0005\u0005\u0003\nYCA\u0002NCB\f!B^3sS\u001aLXj\\2l\u0001")
public class ClusterLinkSyncAclsTest {
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final ConfluentAdmin admin = (ConfluentAdmin)EasyMock.createNiceMock(ConfluentAdmin.class);
    private final ClusterLinkClientManager clientManager = (ClusterLinkClientManager)EasyMock.createNiceMock(ClusterLinkClientManager.class);
    private final Authorizer authorizer = (Authorizer)EasyMock.createNiceMock(Authorizer.class);
    private final KafkaController controller = (KafkaController)EasyMock.createNiceMock(KafkaController.class);
    private final ClusterLinkMetrics metrics = new ClusterLinkMetrics("test-link", UUID.randomUUID(), (LinkMode)LinkMode.Destination$.MODULE$, (ClusterLinkManager)EasyMock.mock(ClusterLinkManager.class), (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$);
    private final java.util.List<AclBinding> aclList = new ArrayList<AclBinding>();
    private final String migrateOnePrincipalAclsJson = new StringOps(Predef$.MODULE$.augmentString("{\n      | \"aclFilters\": [{\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"any\",\n      |      \"patternType\": \"any\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"principal\": \"User:Bob\",\n      |     \"host\":\"*\",\n      |     \"operation\": \"any\",\n      |     \"permissionType\": \"any\"\n      |    }\n      |  }]\n      | }")).stripMargin();
    private final String migrateAllAclsJson = new StringOps(Predef$.MODULE$.augmentString("{\n      | \"aclFilters\": [{\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"any\",\n      |      \"patternType\": \"any\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"operation\": \"any\",\n      |     \"permissionType\": \"any\"\n      |    }\n      |  }]\n      | }")).stripMargin();
    private final String multipleAclFiltersJson = new StringOps(Predef$.MODULE$.augmentString("{\n      | \"aclFilters\": [{\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"topic\",\n      |      \"name\": \"foo\",\n      |      \"patternType\": \"literal\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"principal\": \"User:Bob\",\n      |     \"host\":\"*\",\n      |     \"operation\": \"read\",\n      |     \"permissionType\": \"allow\"\n      |    }\n      |  },\n      |  {\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"topic\",\n      |      \"name\": \"foo\",\n      |      \"patternType\": \"prefixed\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"principal\": \"User:Alice\",\n      |     \"host\":\"*\",\n      |     \"operation\": \"alter\",\n      |     \"permissionType\": \"allow\"\n      |    }\n      |  },\n      |  {\n      |  \"resourceFilter\": {\n      |      \"resourceType\": \"cluster\",\n      |      \"name\": \"*\",\n      |      \"patternType\": \"literal\"\n      |    },\n      |  \"accessFilter\": {\n      |     \"principal\": \"User:Mallory\",\n      |     \"host\":\"badhost\",\n      |     \"operation\": \"clusterAction\",\n      |     \"permissionType\": \"deny\"\n      |    }\n      |  }]\n      | }")).stripMargin();

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConfluentAdmin admin() {
        return this.admin;
    }

    private ClusterLinkClientManager clientManager() {
        return this.clientManager;
    }

    private Authorizer authorizer() {
        return this.authorizer;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private java.util.List<AclBinding> aclList() {
        return this.aclList;
    }

    public String migrateOnePrincipalAclsJson() {
        return this.migrateOnePrincipalAclsJson;
    }

    public String migrateAllAclsJson() {
        return this.migrateAllAclsJson;
    }

    public String multipleAclFiltersJson() {
        return this.multipleAclFiltersJson;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
        this.metrics().startup();
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
        this.metrics().shutdown();
    }

    private void setupMock() {
        EasyMock.reset((Object[])new Object[]{this.admin()});
        EasyMock.reset((Object[])new Object[]{this.clientManager()});
        EasyMock.reset((Object[])new Object[]{this.authorizer()});
        EasyMock.reset((Object[])new Object[]{this.controller()});
        EasyMock.expect((Object)this.clientManager().scheduler()).andReturn((Object)this.scheduler()).anyTimes();
        EasyMock.expect((Object)this.clientManager().getAdmin()).andReturn((Object)this.admin()).anyTimes();
    }

    @Test
    public void testAclFilterUpdate() {
        scala.collection.immutable.Set bobAclSet;
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        EasyMock.replay((Object[])new Object[]{this.controller()});
        AclBinding bobAcl = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.addAclBinding(bobAcl);
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        java.util.List<AclBinding> acls = this.addAclBinding(this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY));
        DescribeAclsResult fullDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(acls));
        DescribeAclsResult bobDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture((Object)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)bobAcl, (List)Nil$.MODULE$)).asJava()));
        EasyMock.expect((Object)this.admin().describeAcls((AclBindingFilter)AclJson$.MODULE$.toAclBindingFilters((AclFiltersJson)AclJson$.MODULE$.parse(this.migrateOnePrincipalAclsJson()).get()).last())).andReturn((Object)bobDescribeAclsResult).times(1);
        EasyMock.expect((Object)this.admin().describeAcls((AclBindingFilter)AclJson$.MODULE$.toAclBindingFilters((AclFiltersJson)AclJson$.MODULE$.parse(this.migrateAllAclsJson()).get()).last())).andReturn((Object)fullDescribeAclsResult).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.clientManager().getAuthorizer()).andReturn((Object)new Some((Object)this.authorizer())).times(2);
        EasyMock.expect((Object)this.authorizer().createAcls((AuthorizableRequestContext)EasyMock.eq(null), (java.util.List)EasyMock.notNull(), (Optional)EasyMock.eq(Optional.empty()))).andReturn(this.aclCreationSuccessResults(3)).times(2);
        EasyMock.replay((Object[])new Object[]{this.authorizer()});
        ClusterLinkConfig bobConfig = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateOnePrincipalAclsJson())}))));
        ClusterLinkConfig allConfig = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)bobConfig).times(2);
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)allConfig).times(1);
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.controller(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        scala.collection.immutable.Set set = bobAclSet = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)bobDescribeAclsResult.values().get()).asScala()).toSet();
        Set set2 = syncAclsTask.getCurrentAclSet();
        Predef$.MODULE$.assert(!(set != null ? !set.equals(set2) : set2 != null));
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)fullDescribeAclsResult.values().get()).asScala()).toSet(), (Object)syncAclsTask.getCurrentAclSet());
        this.verifyMock();
    }

    @Test
    public void testAclAddition() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(1);
        EasyMock.replay((Object[])new Object[]{this.controller()});
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        java.util.List<AclBinding> acls = this.addAclBinding(this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY));
        DescribeAclsResult describeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(acls));
        EasyMock.expect((Object)this.admin().describeAcls(AclBindingFilter.ANY)).andReturn((Object)describeAclsResult).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.clientManager().getAuthorizer()).andReturn((Object)new Some((Object)this.authorizer())).times(1);
        EasyMock.expect((Object)this.authorizer().createAcls((AuthorizableRequestContext)EasyMock.eq(null), (java.util.List)EasyMock.notNull(), (Optional)EasyMock.eq(Optional.empty()))).andReturn(this.aclCreationSuccessResults(3)).times(1);
        EasyMock.replay((Object[])new Object[]{this.authorizer()});
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.controller(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)describeAclsResult.values().get()).asScala()).toSet(), (Object)syncAclsTask.getCurrentAclSet());
    }

    @Test
    public void testAclAdditionWithMultipleAclBindingFilters() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(1);
        EasyMock.replay((Object[])new Object[]{this.controller()});
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = aclBinding1.toFilter();
        AclBindingFilter aclBindingFilter2 = aclBinding2.toFilter();
        AclBindingFilter aclBindingFilter3 = aclBinding3.toFilter();
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)describeAclsResult1).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter2)).andReturn((Object)describeAclsResult2).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter3)).andReturn((Object)describeAclsResult3).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.clientManager().getAuthorizer()).andReturn((Object)new Some((Object)this.authorizer())).times(1);
        EasyMock.expect((Object)this.authorizer().createAcls((AuthorizableRequestContext)EasyMock.eq(null), (java.util.List)EasyMock.notNull(), (Optional)EasyMock.eq(Optional.empty()))).andReturn(this.aclCreationSuccessResults(3)).times(1);
        EasyMock.replay((Object[])new Object[]{this.authorizer()});
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.controller(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        Assertions.assertEquals((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding1, aclBinding2, aclBinding3}))), (Object)syncAclsTask.getCurrentAclSet());
    }

    @Test
    public void testNoRepeatedUpdateWhenNoChange() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        EasyMock.replay((Object[])new Object[]{this.controller()});
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        java.util.List<AclBinding> acls = this.addAclBinding(this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY));
        DescribeAclsResult describeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(acls));
        EasyMock.expect((Object)this.admin().describeAcls(AclBindingFilter.ANY)).andReturn((Object)describeAclsResult).times(2);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.clientManager().getAuthorizer()).andReturn((Object)new Some((Object)this.authorizer())).times(2);
        EasyMock.expect((Object)this.authorizer().createAcls((AuthorizableRequestContext)EasyMock.eq(null), (java.util.List)EasyMock.notNull(), (Optional)EasyMock.eq(Optional.empty()))).andReturn(this.aclCreationSuccessResults(3)).times(1);
        EasyMock.replay((Object[])new Object[]{this.authorizer()});
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.controller(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)describeAclsResult.values().get()).asScala()).toSet(), (Object)syncAclsTask.getCurrentAclSet());
    }

    @Test
    public void testNoRepeatedUpdateWhenNoChangeWithMultipleAclBindingFilters() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        EasyMock.replay((Object[])new Object[]{this.controller()});
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = aclBinding1.toFilter();
        AclBindingFilter aclBindingFilter2 = aclBinding2.toFilter();
        AclBindingFilter aclBindingFilter3 = aclBinding3.toFilter();
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)describeAclsResult1).times(2);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter2)).andReturn((Object)describeAclsResult2).times(2);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter3)).andReturn((Object)describeAclsResult3).times(2);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.clientManager().getAuthorizer()).andReturn((Object)new Some((Object)this.authorizer())).times(2);
        EasyMock.expect((Object)this.authorizer().createAcls((AuthorizableRequestContext)EasyMock.eq(null), (java.util.List)EasyMock.notNull(), (Optional)EasyMock.eq(Optional.empty()))).andReturn(this.aclCreationSuccessResults(3)).times(1);
        EasyMock.replay((Object[])new Object[]{this.authorizer()});
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.controller(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        Assertions.assertEquals((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding1, aclBinding2, aclBinding3}))), (Object)syncAclsTask.getCurrentAclSet());
    }

    @Test
    public void testAclDeletion() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        EasyMock.replay((Object[])new Object[]{this.controller()});
        AclBinding aclToDelete = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.addAclBinding(aclToDelete);
        this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW));
        ArrayList<AclBinding> acls1 = new ArrayList<AclBinding>(this.addAclBinding(this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY)));
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(acls1));
        java.util.List<AclBinding> acls2 = this.removeAclBinding(aclToDelete);
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(acls2));
        EasyMock.expect((Object)this.admin().describeAcls(AclBindingFilter.ANY)).andReturn((Object)describeAclsResult1).times(1).andReturn((Object)describeAclsResult2).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.clientManager().getAuthorizer()).andReturn((Object)new Some((Object)this.authorizer())).times(2);
        EasyMock.expect((Object)this.authorizer().createAcls((AuthorizableRequestContext)EasyMock.eq(null), (java.util.List)EasyMock.notNull(), (Optional)EasyMock.eq(Optional.empty()))).andReturn(this.aclCreationSuccessResults(3)).times(1);
        AclBinding deletedAclBinding = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        EasyMock.expect((Object)this.authorizer().deleteAcls((AuthorizableRequestContext)EasyMock.eq(null), (java.util.List)EasyMock.notNull(), (Optional)EasyMock.eq(Optional.empty()))).andReturn(this.aclDeletionSuccessResults(Collections.singletonList(deletedAclBinding))).times(1);
        EasyMock.replay((Object[])new Object[]{this.authorizer()});
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.controller(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)describeAclsResult2.values().get()).asScala()).toSet(), (Object)syncAclsTask.getCurrentAclSet());
    }

    @Test
    public void testAclDeletionWithMultipleAclBindingFilters() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        EasyMock.replay((Object[])new Object[]{this.controller()});
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = aclBinding1.toFilter();
        AclBindingFilter aclBindingFilter2 = aclBinding2.toFilter();
        AclBindingFilter aclBindingFilter3 = aclBinding3.toFilter();
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        DescribeAclsResult deletedDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.emptyList()));
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)describeAclsResult1).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)deletedDescribeAclsResult).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter2)).andReturn((Object)describeAclsResult2).times(2);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter3)).andReturn((Object)describeAclsResult3).times(2);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.clientManager().getAuthorizer()).andReturn((Object)new Some((Object)this.authorizer())).times(2);
        EasyMock.expect((Object)this.authorizer().createAcls((AuthorizableRequestContext)EasyMock.eq(null), (java.util.List)EasyMock.notNull(), (Optional)EasyMock.eq(Optional.empty()))).andReturn(this.aclCreationSuccessResults(3)).times(1);
        EasyMock.expect((Object)this.authorizer().deleteAcls((AuthorizableRequestContext)EasyMock.eq(null), (java.util.List)EasyMock.notNull(), (Optional)EasyMock.eq(Optional.empty()))).andReturn(this.aclDeletionSuccessResults(Collections.singletonList(aclBinding1))).times(1);
        EasyMock.replay((Object[])new Object[]{this.authorizer()});
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.controller(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        Assertions.assertEquals((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding2, aclBinding3}))), (Object)syncAclsTask.getCurrentAclSet());
    }

    @Test
    public void testAclAdditionAndDeletion() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        EasyMock.replay((Object[])new Object[]{this.controller()});
        AclBinding aclToDelete = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        this.addAclBinding(aclToDelete);
        ArrayList<AclBinding> acls1 = new ArrayList<AclBinding>(this.addAclBinding(this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW)));
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(acls1));
        AclBinding addedAcl = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        this.addAclBinding(addedAcl);
        java.util.List<AclBinding> acls2 = this.removeAclBinding(aclToDelete);
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(acls2));
        EasyMock.expect((Object)this.admin().describeAcls(AclBindingFilter.ANY)).andReturn((Object)describeAclsResult1).times(1).andReturn((Object)describeAclsResult2).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.clientManager().getAuthorizer()).andReturn((Object)new Some((Object)this.authorizer())).times(2);
        EasyMock.expect((Object)this.authorizer().createAcls((AuthorizableRequestContext)EasyMock.eq(null), (java.util.List)EasyMock.notNull(), (Optional)EasyMock.eq(Optional.empty()))).andReturn(this.aclCreationSuccessResults(2)).times(1);
        java.util.List<AclBinding> createAclList2 = Collections.singletonList(addedAcl);
        EasyMock.expect((Object)this.authorizer().createAcls(null, createAclList2, Optional.empty())).andReturn(this.aclCreationSuccessResults(1)).times(1);
        AclBinding deletedAclBinding = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        java.util.List<AclBindingFilter> deleteAclList = Collections.singletonList(deletedAclBinding.toFilter());
        EasyMock.expect((Object)this.authorizer().deleteAcls(null, deleteAclList, Optional.empty())).andReturn(this.aclDeletionSuccessResults(Collections.singletonList(deletedAclBinding))).times(1);
        EasyMock.replay((Object[])new Object[]{this.authorizer()});
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.controller(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)describeAclsResult2.values().get()).asScala()).toSet(), (Object)syncAclsTask.getCurrentAclSet());
    }

    @Test
    public void testAclAdditionAndDeletionWithMultipleAclBindingFilters() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        EasyMock.replay((Object[])new Object[]{this.controller()});
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = aclBinding1.toFilter();
        AclBindingFilter aclBindingFilter2 = aclBinding2.toFilter();
        AclBindingFilter aclBindingFilter3 = aclBinding3.toFilter();
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        DescribeAclsResult emptyDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.emptyList()));
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)describeAclsResult1).times(1).andReturn((Object)emptyDescribeAclsResult).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter2)).andReturn((Object)describeAclsResult2).times(2);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter3)).andReturn((Object)emptyDescribeAclsResult).times(1).andReturn((Object)describeAclsResult3).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.clientManager().getAuthorizer()).andReturn((Object)new Some((Object)this.authorizer())).times(2);
        java.util.List<AclBinding> aclList3 = Collections.singletonList(aclBinding3);
        EasyMock.expect((Object)this.authorizer().createAcls((AuthorizableRequestContext)EasyMock.eq(null), (java.util.List)EasyMock.notNull(), (Optional)EasyMock.eq(Optional.empty()))).andReturn(this.aclCreationSuccessResults(2)).times(1);
        EasyMock.expect((Object)this.authorizer().deleteAcls(null, Collections.singletonList(aclBinding1.toFilter()), Optional.empty())).andReturn(this.aclDeletionSuccessResults(Collections.singletonList(aclBinding1))).times(1);
        EasyMock.expect((Object)this.authorizer().createAcls(null, aclList3, Optional.empty())).andReturn(this.aclCreationSuccessResults(1)).times(1);
        EasyMock.replay((Object[])new Object[]{this.authorizer()});
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.controller(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        Assertions.assertEquals((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding2, aclBinding3}))), (Object)syncAclsTask.getCurrentAclSet());
    }

    @Test
    public void testNoExceptionsThrownIfUnableToGetSourceAcls() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(1);
        EasyMock.replay((Object[])new Object[]{this.controller()});
        EasyMock.expect((Object)this.admin().describeAcls(AclBindingFilter.ANY)).andThrow((Throwable)new AuthorizationException("Unauthorized for DESCRIBE on Cluster"));
        EasyMock.replay((Object[])new Object[]{this.admin()});
        EasyMock.replay((Object[])new Object[]{this.authorizer()});
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.controller(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)syncAclsTask.getCurrentAclSet());
    }

    @Test
    public void testErrorOnAclAdditionUpdatesLocalAclSetCorrectly() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(1);
        EasyMock.replay((Object[])new Object[]{this.controller()});
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = aclBinding1.toFilter();
        AclBindingFilter aclBindingFilter2 = aclBinding2.toFilter();
        AclBindingFilter aclBindingFilter3 = aclBinding3.toFilter();
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)describeAclsResult1).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter2)).andReturn((Object)describeAclsResult2).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter3)).andReturn((Object)describeAclsResult3).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.clientManager().getAuthorizer()).andReturn((Object)new Some((Object)this.authorizer())).times(1);
        EasyMock.expect((Object)this.authorizer().createAcls((AuthorizableRequestContext)EasyMock.eq(null), (java.util.List)EasyMock.notNull(), (Optional)EasyMock.eq(Optional.empty()))).andThrow((Throwable)new AuthorizationException("Unable to create ACLs")).times(1);
        EasyMock.replay((Object[])new Object[]{this.authorizer()});
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.controller(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)syncAclsTask.getCurrentAclSet());
    }

    @Test
    public void testErrorOnAclDeletionUpdatesLocalAclSetCorrectly() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        EasyMock.replay((Object[])new Object[]{this.controller()});
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = aclBinding1.toFilter();
        AclBindingFilter aclBindingFilter2 = aclBinding2.toFilter();
        AclBindingFilter aclBindingFilter3 = aclBinding3.toFilter();
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        DescribeAclsResult deletedDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.emptyList()));
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)describeAclsResult1).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)deletedDescribeAclsResult).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter2)).andReturn((Object)describeAclsResult2).times(2);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter3)).andReturn((Object)describeAclsResult3).times(2);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.clientManager().getAuthorizer()).andReturn((Object)new Some((Object)this.authorizer())).times(2);
        EasyMock.expect((Object)this.authorizer().createAcls((AuthorizableRequestContext)EasyMock.eq(null), (java.util.List)EasyMock.notNull(), (Optional)EasyMock.eq(Optional.empty()))).andReturn(this.aclCreationSuccessResults(2)).times(1);
        EasyMock.expect((Object)this.authorizer().deleteAcls(null, Collections.singletonList(aclBinding1.toFilter()), Optional.empty())).andThrow((Throwable)new AuthorizationException("Unable to delete ACLs")).times(1);
        EasyMock.replay((Object[])new Object[]{this.authorizer()});
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.controller(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        Assertions.assertEquals((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding1, aclBinding2, aclBinding3}))), (Object)syncAclsTask.getCurrentAclSet());
    }

    @Test
    public void testErrorOnAclAdditionFutureUpdatesLocalAclSetCorrectly() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(1);
        EasyMock.replay((Object[])new Object[]{this.controller()});
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = aclBinding1.toFilter();
        AclBindingFilter aclBindingFilter2 = aclBinding2.toFilter();
        AclBindingFilter aclBindingFilter3 = aclBinding3.toFilter();
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)describeAclsResult1).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter2)).andReturn((Object)describeAclsResult2).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter3)).andReturn((Object)describeAclsResult3).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.clientManager().getAuthorizer()).andReturn((Object)new Some((Object)this.authorizer())).times(1);
        EasyMock.expect((Object)this.authorizer().createAcls((AuthorizableRequestContext)EasyMock.eq(null), (java.util.List)EasyMock.notNull(), (Optional)EasyMock.eq(Optional.empty()))).andReturn(this.aclCreationFailureResults(3)).times(1);
        EasyMock.replay((Object[])new Object[]{this.authorizer()});
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.controller(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)syncAclsTask.getCurrentAclSet());
    }

    @Test
    public void testErrorOnAclDeletionFutureUpdatesLocalAclMapCorrectly() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).times(2);
        EasyMock.replay((Object[])new Object[]{this.controller()});
        AclBinding aclBinding1 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.LITERAL, "User:Bob", AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AclBinding aclBinding2 = this.aclBinding(ResourceType.TOPIC, "foo", PatternType.PREFIXED, "User:Alice", AclEntry$.MODULE$.WildcardHost(), AclOperation.ALTER, AclPermissionType.ALLOW);
        AclBinding aclBinding3 = this.aclBinding(ResourceType.CLUSTER, "*", PatternType.LITERAL, "User:Mallory", "badhost", AclOperation.CLUSTER_ACTION, AclPermissionType.DENY);
        AclBindingFilter aclBindingFilter1 = aclBinding1.toFilter();
        AclBindingFilter aclBindingFilter2 = aclBinding2.toFilter();
        AclBindingFilter aclBindingFilter3 = aclBinding3.toFilter();
        DescribeAclsResult describeAclsResult1 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding1)));
        DescribeAclsResult describeAclsResult2 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding2)));
        DescribeAclsResult describeAclsResult3 = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.singletonList(aclBinding3)));
        DescribeAclsResult deletedDescribeAclsResult = new DescribeAclsResult(KafkaFuture.completedFuture(Collections.emptyList()));
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)describeAclsResult1).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter1)).andReturn((Object)deletedDescribeAclsResult).times(1);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter2)).andReturn((Object)describeAclsResult2).times(2);
        EasyMock.expect((Object)this.admin().describeAcls(aclBindingFilter3)).andReturn((Object)describeAclsResult3).times(2);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        EasyMock.expect((Object)this.clientManager().getAuthorizer()).andReturn((Object)new Some((Object)this.authorizer())).times(2);
        EasyMock.expect((Object)this.authorizer().createAcls((AuthorizableRequestContext)EasyMock.eq(null), (java.util.List)EasyMock.notNull(), (Optional)EasyMock.eq(Optional.empty()))).andReturn(this.aclCreationSuccessResults(3)).times(1);
        EasyMock.expect((Object)this.authorizer().deleteAcls(null, Collections.singletonList(aclBinding1.toFilter()), Optional.empty())).andReturn(this.aclDeletionFailureResults(Collections.singletonList(aclBinding1))).times(1);
        EasyMock.replay((Object[])new Object[]{this.authorizer()});
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.multipleAclFiltersJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.controller(), this.metrics());
        syncAclsTask.startup();
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        Assertions.assertEquals((Object)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclBinding[]{aclBinding1, aclBinding2, aclBinding3}))), (Object)syncAclsTask.getCurrentAclSet());
    }

    @Test
    public void testErrorOnSourceAcls() {
        this.setupMock();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{this.controller()});
        KafkaFutureImpl completedFuture = new KafkaFutureImpl();
        completedFuture.completeExceptionally((Throwable)new TimeoutException("Timed out getting source ACLs"));
        DescribeAclsResult describeAclsResult = new DescribeAclsResult((KafkaFuture)completedFuture);
        EasyMock.expect((Object)this.admin().describeAcls((AclBindingFilter)AclJson$.MODULE$.toAclBindingFilters((AclFiltersJson)AclJson$.MODULE$.parse(this.migrateAllAclsJson()).get()).last())).andReturn((Object)describeAclsResult).once();
        EasyMock.replay((Object[])new Object[]{this.admin()});
        ClusterLinkConfig config = this.newConfig((scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.AclFiltersProp()), (Object)this.migrateAllAclsJson())}))));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)config).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        ClusterLinkSyncAcls syncAclsTask = new ClusterLinkSyncAcls(this.clientManager(), this.controller(), this.metrics());
        syncAclsTask.startup();
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)syncAclsTask.runOnce().get(5L, TimeUnit.SECONDS)), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ClusterLinkSyncAclsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 857));
        EasyMock.verify((Object[])new Object[]{this.clientManager()});
        EasyMock.verify((Object[])new Object[]{this.controller()});
        EasyMock.verify((Object[])new Object[]{this.admin()});
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)syncAclsTask.getCurrentAclSet());
        Assertions.assertEquals((int)0, (int)syncAclsTask.currentTasksOutstanding());
    }

    private AclBinding aclBinding(ResourceType resourceType, String resourceName, PatternType patternType, String principalName, String hostName, AclOperation aclOperation, AclPermissionType permissionType) {
        ResourcePattern resourcePattern = new ResourcePattern(resourceType, resourceName, patternType);
        AccessControlEntry accessControlEntry = new AccessControlEntry(principalName, hostName, aclOperation, permissionType);
        return new AclBinding(resourcePattern, accessControlEntry);
    }

    private java.util.List<AclBinding> addAclBinding(AclBinding acl) {
        this.aclList().add(acl);
        return this.aclList();
    }

    private java.util.List<AclBinding> removeAclBinding(AclBinding acl) {
        this.aclList().remove(acl);
        return this.aclList();
    }

    /*
     * WARNING - void declaration
     */
    private java.util.List<CompletableFuture<AclCreateResult>> aclCreationSuccessResults(int num) {
        void var2_2;
        ArrayList successList = new ArrayList();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), num).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)_ -> successList.add(CompletableFuture.completedFuture(AclCreateResult.SUCCESS)));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private java.util.List<CompletableFuture<AclCreateResult>> aclCreationFailureResults(int num) {
        void var2_2;
        ArrayList failureList = new ArrayList();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), num).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)_ -> failureList.add(CompletableFuture.completedFuture(new AclCreateResult((ApiException)new AuthenticationException("Unable to authenticate")))));
        return var2_2;
    }

    private java.util.List<CompletableFuture<AclDeleteResult>> aclDeletionSuccessResults(java.util.List<AclBinding> deletedAcls) {
        ArrayList aclBindingDeleteResult = new ArrayList();
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(deletedAcls).asScala()).foreach((Function1 & Serializable & scala.Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncAclsTest.$anonfun$aclDeletionSuccessResults$1(aclBindingDeleteResult, acl)));
        return Collections.singletonList(CompletableFuture.completedFuture(new AclDeleteResult(aclBindingDeleteResult)));
    }

    private java.util.List<CompletableFuture<AclDeleteResult>> aclDeletionFailureResults(java.util.List<AclBinding> deletedAcls) {
        ArrayList aclBindingDeleteResult = new ArrayList();
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(deletedAcls).asScala()).foreach((Function1 & Serializable & scala.Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkSyncAclsTest.$anonfun$aclDeletionFailureResults$1(aclBindingDeleteResult, acl)));
        return Collections.singletonList(CompletableFuture.completedFuture(new AclDeleteResult(aclBindingDeleteResult)));
    }

    private ClusterLinkConfig newConfig(scala.collection.immutable.Map<String, String> configs) {
        Properties props = new Properties();
        Implicits$.MODULE$.PropertiesOps(props).$plus$plus$eq(configs);
        return ClusterLinkConfig$.MODULE$.create((Map)props);
    }

    private void verifyMock() {
        EasyMock.verify((Object[])new Object[]{this.clientManager()});
        EasyMock.verify((Object[])new Object[]{this.controller()});
        EasyMock.verify((Object[])new Object[]{this.admin()});
        EasyMock.verify((Object[])new Object[]{this.authorizer()});
    }

    public static final /* synthetic */ boolean $anonfun$aclDeletionSuccessResults$1(Collection aclBindingDeleteResult$1, AclBinding acl) {
        AclDeleteResult.AclBindingDeleteResult aclBinding = new AclDeleteResult.AclBindingDeleteResult(acl);
        return aclBindingDeleteResult$1.add(aclBinding);
    }

    public static final /* synthetic */ boolean $anonfun$aclDeletionFailureResults$1(Collection aclBindingDeleteResult$2, AclBinding acl) {
        AclDeleteResult.AclBindingDeleteResult aclBinding = new AclDeleteResult.AclBindingDeleteResult(acl, (ApiException)new AuthenticationException("Unable to authenticate"));
        return aclBindingDeleteResult$2.add(aclBinding);
    }
}

