/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFilter;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncOffsets;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.LinkMode;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsOptions;
import org.apache.kafka.clients.admin.ListConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\u0005d\u0001B)S\u0001eCQ\u0001\u0019\u0001\u0005\u0002\u0005Dq\u0001\u001a\u0001C\u0002\u0013%Q\r\u0003\u0004j\u0001\u0001\u0006IA\u001a\u0005\bU\u0002\u0011\r\u0011\"\u0003l\u0011\u0019I\b\u0001)A\u0005Y\"9!\u0010\u0001b\u0001\n\u0013Y\bBB@\u0001A\u0003%A\u0010C\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0003\u0002\u0004!A\u00111\u0002\u0001!\u0002\u0013\t)\u0001C\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0003\u0002\u0010!A\u0011\u0011\u0005\u0001!\u0002\u0013\t\t\u0002C\u0005\u0002$\u0001\u0011\r\u0011\"\u0003\u0002&!A\u00111\u0007\u0001!\u0002\u0013\t9\u0003C\u0005\u00026\u0001\u0011\r\u0011\"\u0003\u00028!A\u0011q\b\u0001!\u0002\u0013\tI\u0004C\u0005\u0002B\u0001\u0011\r\u0011\"\u0003\u0002D!A\u00111\n\u0001!\u0002\u0013\t)\u0005C\u0005\u0002N\u0001\u0011\r\u0011\"\u0003\u0002D!A\u0011q\n\u0001!\u0002\u0013\t)\u0005C\u0005\u0002R\u0001\u0011\r\u0011\"\u0003\u0002D!A\u00111\u000b\u0001!\u0002\u0013\t)\u0005C\u0005\u0002V\u0001\u0011\r\u0011\"\u0003\u0002D!A\u0011q\u000b\u0001!\u0002\u0013\t)\u0005C\u0005\u0002Z\u0001\u0011\r\u0011\"\u0003\u0002D!A\u00111\f\u0001!\u0002\u0013\t)\u0005C\u0005\u0002^\u0001\u0011\r\u0011\"\u0003\u0002`!A\u0011q\r\u0001!\u0002\u0013\t\t\u0007C\u0005\u0002j\u0001\u0011\r\u0011\"\u0003\u0002l!A\u0011\u0011\u0010\u0001!\u0002\u0013\ti\u0007C\u0005\u0002t\u0001\u0011\r\u0011\"\u0003\u0002|!A\u00111\u0011\u0001!\u0002\u0013\ti\bC\u0005\u0002\u0006\u0002\u0011\r\u0011\"\u0003\u0002\b\"A\u0011q\u0014\u0001!\u0002\u0013\tI\tC\u0005\u0002\"\u0002\u0011\r\u0011\"\u0003\u0002$\"A\u0011\u0011\u0017\u0001!\u0002\u0013\t)\u000bC\u0005\u00024\u0002\u0011\r\u0011\"\u0003\u00026\"A\u0011q\u0017\u0001!\u0002\u0013\tY\u000bC\u0004\u0002:\u0002!\t!a/\t\u000f\u0005e\u0007\u0001\"\u0001\u0002<\"9\u00111\u001d\u0001\u0005\u0002\u0005m\u0006bBAw\u0001\u0011\u0005\u00111\u0018\u0005\b\u0003c\u0004A\u0011AA^\u0011\u001d\t)\u0010\u0001C\u0001\u0003wCq!!?\u0001\t\u0003\tY\fC\u0004\u0002~\u0002!\t!a/\t\u000f\t\u0005\u0001\u0001\"\u0001\u0002<\"9!Q\u0001\u0001\u0005\u0002\u0005m\u0006b\u0002B\u0005\u0001\u0011\u0005\u00111\u0018\u0005\b\u0005\u001b\u0001A\u0011AA^\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0003wCqA!\u0006\u0001\t\u0003\tY\fC\u0004\u0003\u001a\u0001!\t!a/\t\u000f\tu\u0001\u0001\"\u0001\u0002<\"9!\u0011\u0005\u0001\u0005\u0002\u0005m\u0006b\u0002B\u0013\u0001\u0011\u0005\u00111\u0018\u0005\b\u0005S\u0001A\u0011AA^\u0011\u001d\u0011i\u0003\u0001C\u0001\u0003wCqA!\r\u0001\t\u0003\tY\fC\u0004\u00036\u0001!\t!a/\t\u000f\te\u0002\u0001\"\u0003\u0003<!9!1\n\u0001\u0005\n\t5\u0003b\u0002B*\u0001\u0011%!Q\u000b\u0005\b\u0005?\u0002A\u0011\u0002B1\u0011%\u0011I\bAI\u0001\n\u0013\u0011Y\bC\u0004\u0003\u0012\u0002!IAa%\t\u000f\t\u0015\u0006\u0001\"\u0003\u0003(\"9!q\u0019\u0001\u0005\n\t%\u0007b\u0002Bt\u0001\u0011%!\u0011\u001e\u0005\n\u0005k\u0004\u0011\u0013!C\u0005\u0005oDqAa?\u0001\t\u0013\u0011i\u0010C\u0004\u0004\b\u0001!Ia!\u0003\t\u000f\r5\u0001\u0001\"\u0003\u0004\u0010!I1Q\u0004\u0001\u0012\u0002\u0013%!1\u0010\u0005\b\u0007?\u0001A\u0011BB\u0011\u0011\u001d\u0019i\u0003\u0001C\u0005\u0007_Aqaa\u000f\u0001\t\u0013\u0019i\u0004C\u0004\u0004B\u0001!Iaa\u0011\t\u000f\r-\u0003\u0001\"\u0003\u0004N!I1\u0011\f\u0001\u0012\u0002\u0013%11\f\u0005\b\u0007?\u0002A\u0011BA^\u0005i\u0019E.^:uKJd\u0015N\\6Ts:\u001cwJ\u001a4tKR\u001cH+Z:u\u0015\t\u0019F+\u0001\u0003mS:\\'BA+W\u0003\u0019\u0019XM\u001d<fe*\tq+A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0006CA._\u001b\u0005a&\"A/\u0002\u000bM\u001c\u0017\r\\1\n\u0005}c&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002EB\u00111\rA\u0007\u0002%\u0006I1o\u00195fIVdWM]\u000b\u0002MB\u00111mZ\u0005\u0003QJ\u0013Ac\u00117vgR,'\u000fT5oWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005Y1o\\;sG\u0016\fE-\\5o+\u0005a\u0007CA7x\u001b\u0005q'BA8q\u0003\u0015\tG-\\5o\u0015\t\t(/A\u0004dY&,g\u000e^:\u000b\u0005]\u001b(B\u0001;v\u0003\u0019\t\u0007/Y2iK*\ta/A\u0002pe\u001eL!\u0001\u001f8\u0003\u001d\r{gN\u001a7vK:$\u0018\tZ7j]\u0006a1o\\;sG\u0016\fE-\\5oA\u000512o\\;sG\u0016\u001cE.^:uKJd\u0015N\\6BI6Lg.F\u0001}!\t\u0019W0\u0003\u0002\u007f%\n12\t\\;ti\u0016\u0014H*\u001b8l\u0003\u0012l\u0017N\\\"mS\u0016tG/A\ft_V\u00148-Z\"mkN$XM\u001d'j].\fE-\\5oA\u0005IA-Z:u\u0003\u0012l\u0017N\\\u000b\u0003\u0003\u000b\u00012!\\A\u0004\u0013\r\tIA\u001c\u0002\u0006\u0003\u0012l\u0017N\\\u0001\u000bI\u0016\u001cH/\u00113nS:\u0004\u0013A\u00027j].LE-\u0006\u0002\u0002\u0012A!\u00111CA\u000f\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011\u0001B;uS2T!!a\u0007\u0002\t)\fg/Y\u0005\u0005\u0003?\t)B\u0001\u0003V+&#\u0015a\u00027j].LE\rI\u0001\u000eg>,(oY3U_BL7-\u00133\u0016\u0005\u0005\u001d\u0002\u0003BA\u0015\u0003_i!!a\u000b\u000b\u0007\u00055\"/\u0001\u0004d_6lwN\\\u0005\u0005\u0003c\tYC\u0001\u0003Vk&$\u0017AD:pkJ\u001cW\rV8qS\u000eLE\rI\u0001\u000eG2LWM\u001c;NC:\fw-\u001a:\u0016\u0005\u0005e\u0002cA2\u0002<%\u0019\u0011Q\b*\u00031\rcWo\u001d;fe2Kgn[\"mS\u0016tG/T1oC\u001e,'/\u0001\bdY&,g\u000e^'b]\u0006<WM\u001d\u0011\u0002\u001dQ,7\u000f\u001e+pa&\u001c7\u000b^1uKV\u0011\u0011Q\t\t\u0004G\u0006\u001d\u0013bAA%%\n)2\t\\;ti\u0016\u0014H*\u001b8l)>\u0004\u0018nY*uCR,\u0017a\u0004;fgR$v\u000e]5d'R\fG/\u001a\u0011\u00023Q,7\u000f\u001e)f]\u0012LgnZ*u_B$v\u000e]5d'R\fG/Z\u0001\u001bi\u0016\u001cH\u000fU3oI&twm\u0015;paR{\u0007/[2Ti\u0006$X\rI\u0001\u0015i\u0016\u001cHOR1jY\u0016$Gk\u001c9jGN#\u0018\r^3\u0002+Q,7\u000f\u001e$bS2,G\rV8qS\u000e\u001cF/\u0019;fA\u0005)B/Z:u'R|\u0007\u000f]3e)>\u0004\u0018nY*uCR,\u0017A\u0006;fgR\u001cFo\u001c9qK\u0012$v\u000e]5d'R\fG/\u001a\u0011\u0002)Q,7\u000f\u001e)bkN,G\rV8qS\u000e\u001cF/\u0019;f\u0003U!Xm\u001d;QCV\u001cX\r\u001a+pa&\u001c7\u000b^1uK\u0002\nq!\\3ue&\u001c7/\u0006\u0002\u0002bA\u00191-a\u0019\n\u0007\u0005\u0015$K\u0001\nDYV\u001cH/\u001a:MS:\\W*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/\u0006\u0002\u0002nA!\u0011qNA;\u001b\t\t\tHC\u0002\u0002tY\u000b!bY8oiJ|G\u000e\\3s\u0013\u0011\t9(!\u001d\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH/\u0001\nd_:$(o\u001c7mKJ\u001cuN\u001c;fqR\u0004SCAA?!\u0011\ty'a \n\t\u0005\u0005\u0015\u0011\u000f\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\u0006Y1m\u001c8ue>dG.\u001a:!\u00039\tG\u000e\\8x\u00032dg)\u001b7uKJ,\"!!#\u0011\t\u0005-\u0015\u0011\u0014\b\u0005\u0003\u001b\u000b)\nE\u0002\u0002\u0010rk!!!%\u000b\u0007\u0005M\u0005,\u0001\u0004=e>|GOP\u0005\u0004\u0003/c\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001c\u0006u%AB*ue&twMC\u0002\u0002\u0018r\u000bq\"\u00197m_^\fE\u000e\u001c$jYR,'\u000fI\u0001\t]VdG\u000eT5tiV\u0011\u0011Q\u0015\t\u0007\u0003'\t9+a+\n\t\u0005%\u0016Q\u0003\u0002\u0005\u0019&\u001cH\u000f\u0005\u0003\u0002*\u00055\u0016\u0002BAX\u0003W\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\u0005ok2dG*[:uA\u0005\u0011A\u000f]\u000b\u0003\u0003W\u000b1\u0001\u001e9!\u0003\u0015\u0019X\r^+q)\t\ti\fE\u0002\\\u0003\u007fK1!!1]\u0005\u0011)f.\u001b;)\u0007\u0019\n)\r\u0005\u0003\u0002H\u0006UWBAAe\u0015\u0011\tY-!4\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002P\u0006E\u0017a\u00026va&$XM\u001d\u0006\u0004\u0003',\u0018!\u00026v]&$\u0018\u0002BAl\u0003\u0013\u0014!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007fA\u0014\u0002^B!\u0011qYAp\u0013\u0011\t\t/!3\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017A\u0005;fgRl\u0015n\u001a:bi\u0016|eMZ:fiND3\u0001KAt!\u0011\t9-!;\n\t\u0005-\u0018\u0011\u001a\u0002\u0005)\u0016\u001cH/\u0001\u0016uKN$Hi\\3t\u001d>$X*[4sCR,wJ\u001a4tKR\u001c\u0018J\u001a(pi\u0006\u001bG/\u001b<f\u001b&\u0014(o\u001c:)\u0007%\n9/A\u000fuKN$Hi\\3t\u001d>$(+\u001e8JM:{GoQ8oiJ|G\u000e\\3sQ\rQ\u0013q]\u0001$i\u0016\u001cH/T5he\u0006$Xm\u00144gg\u0016$8oV5uQ:{wI]8va\u001aKG\u000e^3sQ\rY\u0013q]\u0001\u001di\u0016\u001cHoQ;se\u0016tGo\u00144gg\u0016$8/\u0011:f+B$\u0017\r^3eQ\ra\u0013q]\u0001%i\u0016\u001cHOT8CCR\u001c\u0007.\u0012=dKB$\u0018n\u001c8IC:$G.\u001a3D_J\u0014Xm\u0019;ms\"\u001aQ&a:\u0002]Q,7\u000f^\"veJ,g\u000e^(gMN,Go]!sK:{G/\u00169eCR,Gm\u00148D_6l\u0017\u000e\u001e$bS2,(/\u001a\u0015\u0004]\u0005\u001d\u0018A\t;fgR4\u0015\u000e\u001c;feN<%o\\;q\u0019&\u001cH/\u001b8h/&$\b\u000eT5uKJ\fG\u000eK\u00020\u0003O\f1\u0005^3ti\u001aKG\u000e^3sg6+H\u000e^5qY\u0016<%o\\;qg^KG\u000f\u001b)sK\u001aL\u0007\u0010K\u00021\u0003O\f\u0001\u0004^3ti\u001aKG\u000e^3sg\u0016C8\r\\;eK\u0012<%o\\;qQ\r\t\u0014q]\u0001+i\u0016\u001cHOR5mi\u0016\u00148/T;mi&\u0004H.Z#yG2,H-\u001a3He>,\boV5uQB\u0013XMZ5yQ\r\u0011\u0014q]\u0001\u001ai\u0016\u001cHoQ1o+B$\u0017\r^3He>,\bOR5mi\u0016\u00148\u000fK\u00024\u0003O\f\u0011\u0005^3ti\u0012{Wm\u001d(piV\u0003H-\u0019;f+:\u001c\u0007.\u00198hK\u0012|eMZ:fiND3\u0001NAt\u0003%\"Xm\u001d;PY\u0012<%o\\;qg\u0006\u0013XMU3n_Z,GM\u0012:p[\u000e+(O]3oi>3gm]3ug\"\u001aQ'a:\u0002EQ,7\u000f\u001e#pKNtu\u000e^\"p[6LGOT8o\u001b&\u0014(o\u001c:fIR{\u0007/[2tQ\r1\u0014q]\u0001\u001ei\u0016\u001cHOT8He>,\b/Q;uQ>swJ\u001a4tKR\u001cu.\\7ji\"\u001aq'a:\u0002;Q,7\u000f\u001e(p)>\u0004\u0018nY!vi\"|en\u00144gg\u0016$8i\\7nSRD3\u0001OAt\u0003%\"Xm\u001d;NS\u001e\u0014\u0018\r^3UK:\fg\u000e^(gMN,Go],ji\"d\u0015\u000e^3sC24\u0015\u000e\u001c;fe\"\u001a\u0011(a:\u0002UQ,7\u000f^'jOJ\fG/\u001a+f]\u0006tGo\u00144gg\u0016$8oV5uQ^KG\u000eZ2be\u00124\u0015\u000e\u001c;fe\"\u001a!(a:\u0002UQ,7\u000f^'jOJ\fG/\u001a+f]\u0006tGo\u00144gg\u0016$8oV5uQB\u0013XMZ5yK\u00124\u0015\u000e\u001c;fe\"\u001a1(a:\u0002%Y,'/\u001b4z)\u0016t\u0017M\u001c;GS2$XM\u001d\u000b\u0007\u0003{\u0013iD!\u0011\t\u000f\t}B\b1\u0001\u0002\n\u0006)qM]8va\"9!1\t\u001fA\u0002\t\u0015\u0013A\u00024jYR,'\u000fE\u0002d\u0005\u000fJ1A!\u0013S\u0005E\u0019E.^:uKJd\u0015N\\6GS2$XM]\u0001\r_\u001a47/\u001a;GS2$XM\u001d\u000b\u0005\u0003\u0013\u0013y\u0005C\u0004\u0003Ru\u0002\rA!\u0012\u0002\u0017\u001d\u0014x.\u001e9GS2$XM]\u0001\u000bY&t7nQ8oM&<G\u0003\u0002B,\u0005;\u00022a\u0019B-\u0013\r\u0011YF\u0015\u0002\u0012\u00072,8\u000f^3s\u0019&t7nQ8oM&<\u0007b\u0002B&}\u0001\u0007\u0011\u0011R\u0001\tY&t7\u000eR1uCR!!1\rB8!\u0011\u0011)Ga\u001b\u000e\u0005\t\u001d$b\u0001B5-\u0006\u0011!p[\u0005\u0005\u0005[\u00129GA\bDYV\u001cH/\u001a:MS:\\G)\u0019;b\u0011%\u0011\th\u0010I\u0001\u0002\u0004\u0011\u0019(\u0001\u0007uK:\fg\u000e\u001e)sK\u001aL\u0007\u0010E\u0003\\\u0005k\nI)C\u0002\u0003xq\u0013aa\u00149uS>t\u0017A\u00057j].$\u0015\r^1%I\u00164\u0017-\u001e7uIE*\"A! +\t\tM$qP\u0016\u0003\u0005\u0003\u0003BAa!\u0003\u000e6\u0011!Q\u0011\u0006\u0005\u0005\u000f\u0013I)A\u0005v]\u000eDWmY6fI*\u0019!1\u0012/\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0010\n\u0015%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006qQn\\2l\u0019&\u001cHo\u0012:pkB\u001cH\u0003\u0002BK\u00057\u00032!\u001cBL\u0013\r\u0011IJ\u001c\u0002\u0019\u0019&\u001cHoQ8ogVlWM]$s_V\u00048OU3tk2$\bb\u0002BO\u0003\u0002\u0007!qT\u0001\u0007OJ|W\u000f]:\u0011\u000bm\u0013\t+!#\n\u0007\t\rFL\u0001\u0006=e\u0016\u0004X-\u0019;fIz\nq\"\\8dW2K7\u000f^(gMN,Go\u001d\u000b\u0005\u0005S\u0013y\u000bE\u0002n\u0005WK1A!,o\u0005ya\u0015n\u001d;D_:\u001cX/\\3s\u000fJ|W\u000f](gMN,Go\u001d*fgVdG\u000fC\u0004\u00032\n\u0003\rAa-\u0002\u001b=4gm]3u\u000b:$(/[3t!!\t\u0019B!.\u0002\n\ne\u0016\u0002\u0002B\\\u0003+\u00111!T1q!!\t\u0019B!.\u0002,\nm\u0006\u0003\u0002B_\u0005\u0007l!Aa0\u000b\u0007\t\u0005\u0007/\u0001\u0005d_:\u001cX/\\3s\u0013\u0011\u0011)Ma0\u0003#=3gm]3u\u0003:$W*\u001a;bI\u0006$\u0018-\u0001\rn_\u000e\\G*[:u\u001f\u001a47/\u001a;t\u000bb\u001cW\r\u001d;j_:$bA!+\u0003L\nu\u0007b\u0002BO\u0007\u0002\u0007!Q\u001a\t\u0007\u0005\u001f\u0014I.!#\u000f\t\tE'Q\u001b\b\u0005\u0003\u001f\u0013\u0019.C\u0001^\u0013\r\u00119\u000eX\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tIKa7\u000b\u0007\t]G\fC\u0004\u0003`\u000e\u0003\rA!9\u0002\u0013\u0015D8-\u001a9uS>t\u0007\u0003\u0002Bh\u0005GLAA!:\u0003\\\nIA\u000b\u001b:po\u0006\u0014G.Z\u0001\u0011[>\u001c7.\u00117uKJ|eMZ:fiN$BAa;\u0003rB\u0019QN!<\n\u0007\t=hNA\u0010BYR,'oQ8ogVlWM]$s_V\u0004xJ\u001a4tKR\u001c(+Z:vYRD\u0011Ba8E!\u0003\u0005\rAa=\u0011\u000bm\u0013)H!9\u000255|7m[!mi\u0016\u0014xJ\u001a4tKR\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\te(\u0006\u0002Bz\u0005\u007f\n1d]3ukB|E\u000eZ'pG.|eMZ:fiJ+7\u000f]8og\u0016\u001cHCBA_\u0005\u007f\u001c)\u0001C\u0004\u00032\u001a\u0003\ra!\u0001\u0011\u0011\u0005-51AAV\u0005wKAAa.\u0002\u001e\"9!Q\u0014$A\u0002\t}\u0015AE7pG.|E\u000e\u001a'jgR|eMZ:fiN$BA!+\u0004\f!9!\u0011W$A\u0002\r\u0005\u0011\u0001F:z]\u000e|eMZ:fiN\fe\u000e\u001a,fe&4\u0017\u0010\u0006\u0004\u0004\u0012\r]11\u0004\t\u0004G\u000eM\u0011bAB\u000b%\n12\t\\;ti\u0016\u0014H*\u001b8l'ft7m\u00144gg\u0016$8\u000fC\u0004\u0004\u001a!\u0003\rAa\u0016\u0002#\rdWo\u001d;fe2Kgn[\"p]\u001aLw\rC\u0005\u0003r!\u0003\n\u00111\u0001\u0003t\u0005q2/\u001f8d\u001f\u001a47/\u001a;t\u0003:$g+\u001a:jMf$C-\u001a4bk2$HEM\u0001\u0012_\u001a47/\u001a;B]\u0012lU\r^1eCR\fG\u0003\u0002B^\u0007GAqa!\nK\u0001\u0004\u00199#\u0001\u0004pM\u001a\u001cX\r\u001e\t\u00047\u000e%\u0012bAB\u00169\n!Aj\u001c8h\u0003Q\u0019wN\\:v[\u0016\u0014xI]8va2K7\u000f^5oOR!1\u0011GB\u001c!\ri71G\u0005\u0004\u0007kq'\u0001F\"p]N,X.\u001a:He>,\b\u000fT5ti&tw\rC\u0004\u0004:-\u0003\r!!#\u0002\t9\fW.Z\u0001\u001cg\u0016$X\u000f]'pG.d\u0015n\u001d;He>,\bo\u001d*fgB|gn]3\u0015\t\u0005u6q\b\u0005\b\u0005;c\u0005\u0019\u0001BP\u0003a\u0019X\r^;q\u001b>\u001c7n\u00144gg\u0016$(+Z:q_:\u001cXm\u001d\u000b\u0005\u0003{\u001b)\u0005C\u0004\u0004H5\u0003\ra!\u0013\u0002\u0011\u001d\u0014x.\u001e9NCB\u0004\u0002\"a#\u0004\u0004\u0005%%\u0011X\u0001\ng\u0016$X\u000f]'pG.$B!!0\u0004P!I1\u0011\u000b(\u0011\u0002\u0003\u000711K\u0001\rSN\u001cuN\u001c;s_2dWM\u001d\t\u00047\u000eU\u0013bAB,9\n9!i\\8mK\u0006t\u0017aE:fiV\u0004Xj\\2lI\u0011,g-Y;mi\u0012\nTCAB/U\u0011\u0019\u0019Fa \u0002\u0015Y,'/\u001b4z\u001b>\u001c7\u000e")
public class ClusterLinkSyncOffsetsTest {
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final ConfluentAdmin sourceAdmin = (ConfluentAdmin)EasyMock.mock(ConfluentAdmin.class);
    private final ClusterLinkAdminClient sourceClusterLinkAdmin = (ClusterLinkAdminClient)EasyMock.mock(ClusterLinkAdminClient.class);
    private final Admin destAdmin = (Admin)EasyMock.mock(Admin.class);
    private final UUID linkId = UUID.randomUUID();
    private final Uuid sourceTopicId = Uuid.randomUuid();
    private final ClusterLinkClientManager clientManager = (ClusterLinkClientManager)EasyMock.mock(ClusterLinkClientManager.class);
    private final ClusterLinkTopicState testTopicState = new ClusterLinkTopicState.Mirror("testLink", this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.Mirror$.MODULE$.apply$default$4());
    private final ClusterLinkTopicState testPendingStopTopicState = new ClusterLinkTopicState.PendingStoppedMirror("testLink", this.linkId(), this.sourceTopicId(), false, ClusterLinkTopicState.PendingStoppedMirror$.MODULE$.apply$default$5());
    private final ClusterLinkTopicState testFailedTopicState = new ClusterLinkTopicState.FailedMirror("testLink", this.linkId(), this.sourceTopicId(), ClusterLinkTopicState.FailedMirror$.MODULE$.apply$default$4());
    private final ClusterLinkTopicState testStoppedTopicState = new ClusterLinkTopicState.StoppedMirror("testLink", this.linkId(), this.sourceTopicId(), (Seq)Nil$.MODULE$, ClusterLinkTopicState.StoppedMirror$.MODULE$.apply$default$5());
    private final ClusterLinkTopicState testPausedTopicState = new ClusterLinkTopicState.PausedMirror("testLink", this.linkId(), this.sourceTopicId(), false, true, false, ClusterLinkTopicState.PausedMirror$.MODULE$.apply$default$7());
    private final ClusterLinkMetrics metrics = new ClusterLinkMetrics("test-link", this.linkId(), (LinkMode)LinkMode.Destination$.MODULE$, (ClusterLinkManager)EasyMock.mock(ClusterLinkManager.class), (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$);
    private final ControllerContext controllerContext = (ControllerContext)EasyMock.mock(ControllerContext.class);
    private final KafkaController controller = (KafkaController)EasyMock.mock(KafkaController.class);
    private final String allowAllFilter = this.offsetFilter(new ClusterLinkFilter("*", "LITERAL", "INCLUDE"));
    private final java.util.List<TopicPartition> nullList = null;
    private final TopicPartition tp = new TopicPartition("testTopic", 1);

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConfluentAdmin sourceAdmin() {
        return this.sourceAdmin;
    }

    private ClusterLinkAdminClient sourceClusterLinkAdmin() {
        return this.sourceClusterLinkAdmin;
    }

    private Admin destAdmin() {
        return this.destAdmin;
    }

    private UUID linkId() {
        return this.linkId;
    }

    private Uuid sourceTopicId() {
        return this.sourceTopicId;
    }

    private ClusterLinkClientManager clientManager() {
        return this.clientManager;
    }

    private ClusterLinkTopicState testTopicState() {
        return this.testTopicState;
    }

    private ClusterLinkTopicState testPendingStopTopicState() {
        return this.testPendingStopTopicState;
    }

    private ClusterLinkTopicState testFailedTopicState() {
        return this.testFailedTopicState;
    }

    private ClusterLinkTopicState testStoppedTopicState() {
        return this.testStoppedTopicState;
    }

    private ClusterLinkTopicState testPausedTopicState() {
        return this.testPausedTopicState;
    }

    private ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private KafkaController controller() {
        return this.controller;
    }

    private String allowAllFilter() {
        return this.allowAllFilter;
    }

    private java.util.List<TopicPartition> nullList() {
        return this.nullList;
    }

    private TopicPartition tp() {
        return this.tp;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
        this.metrics().startup();
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
        this.metrics().shutdown();
    }

    @Test
    public void testMigrateOffsets() {
        this.setupMock(this.setupMock$default$1());
        String groupName = "testGroup";
        this.setupMockListGroupsResponse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{groupName}));
        scala.collection.immutable.Map offsetEntries = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)this.offsetAndMetadata(1L))}));
        this.setupMockOffsetResponses((scala.collection.immutable.Map<String, java.util.Map<TopicPartition, OffsetAndMetadata>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)groupName), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava())}))));
        ClusterLinkConfig clusterLinkConfig = this.linkConfig(this.allowAllFilter());
        ClusterLinkSyncOffsets syncOffsets = this.syncOffsetsAndVerify(clusterLinkConfig, this.syncOffsetsAndVerify$default$2());
        Assertions.assertEquals((int)1, (int)syncOffsets.currentOffsets().size());
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)((MapLike)syncOffsets.currentOffsets().apply((Object)groupName)).apply((Object)this.tp())));
    }

    @Test
    public void testDoesNotMigrateOffsetsIfNotActiveMirror() {
        this.setupMock(this.setupMock$default$1());
        String topicPendingStopped = "testTopicPendingStopped";
        String topicFailed = "testTopicFailed";
        String topicPaused = "testTopicPaused";
        String topicStopped = "testTopicStopped";
        String group = "testGroup";
        this.setupMockListGroupsResponse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{group}));
        scala.collection.immutable.Map allOffsetEntries = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)this.offsetAndMetadata(1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topicPendingStopped, 1)), (Object)this.offsetAndMetadata(1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topicFailed, 1)), (Object)this.offsetAndMetadata(1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topicPaused, 1)), (Object)this.offsetAndMetadata(1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topicStopped, 1)), (Object)this.offsetAndMetadata(1L))}));
        scala.collection.immutable.Map expectedOffsetEntries = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)this.offsetAndMetadata(1L))}));
        ListConsumerGroupOffsetsResult listOffsetsResult = this.mockListOffsets((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)allOffsetEntries).asJava())}))).asJava());
        AlterConsumerGroupOffsetsResult alterOffsetsResult = this.mockAlterOffsets(this.mockAlterOffsets$default$1());
        EasyMock.expect((Object)this.sourceClusterLinkAdmin().listConsumerGroupOffsets((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), this.nullList())}))).asJava()), (ListConsumerGroupOffsetsOptions)EasyMock.isA(ListConsumerGroupOffsetsOptions.class))).andReturn((Object)listOffsetsResult).times(1);
        EasyMock.expect((Object)this.destAdmin().alterConsumerGroupOffsets(group, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)expectedOffsetEntries).asJava())).andReturn((Object)alterOffsetsResult).times(1);
        ClusterLinkConfig clusterLinkConfig = this.linkConfig(this.allowAllFilter());
        ClusterLinkSyncOffsets syncOffsets = this.syncOffsetsAndVerify(clusterLinkConfig, this.syncOffsetsAndVerify$default$2());
        Assertions.assertEquals((int)1, (int)syncOffsets.currentOffsets().size());
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)((MapLike)syncOffsets.currentOffsets().apply((Object)group)).apply((Object)this.tp())));
    }

    @Test
    public void testDoesNotRunIfNotController() {
        this.setupMock(false);
        ClusterLinkConfig clusterLinkConfig = this.linkConfig(this.allowAllFilter());
        this.syncOffsetsAndVerify(clusterLinkConfig, this.syncOffsetsAndVerify$default$2());
    }

    @Test
    public void testMigrateOffsetsWithNoGroupFilter() {
        this.setupMock(this.setupMock$default$1());
        ClusterLinkConfig clusterLinkConfig = ClusterLinkConfig$.MODULE$.create((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true")}))).asJava());
        this.syncOffsetsAndVerify(clusterLinkConfig, this.syncOffsetsAndVerify$default$2());
    }

    @Test
    public void testCurrentOffsetsAreUpdated() {
        this.setupMock(this.setupMock$default$1());
        String groupName = "testGroup";
        ClusterLinkConfig clusterLinkConfig = this.linkConfig(this.allowAllFilter());
        this.setupMockListGroupsResponse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{groupName}));
        scala.collection.immutable.Map offsetEntries = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)this.offsetAndMetadata(1L))}));
        this.setupMockOffsetResponses((scala.collection.immutable.Map<String, java.util.Map<TopicPartition, OffsetAndMetadata>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)groupName), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava())}))));
        ClusterLinkSyncOffsets syncOffsets = this.syncOffsetsAndVerify(clusterLinkConfig, this.syncOffsetsAndVerify$default$2());
        Assertions.assertEquals((int)1, (int)syncOffsets.currentOffsets().size());
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)((MapLike)syncOffsets.currentOffsets().apply((Object)groupName)).apply((Object)this.tp())));
    }

    @Test
    public void testNoBatchExceptionHandledCorrectly() {
        this.setupMock(this.setupMock$default$1());
        String group1 = "testGroup1";
        String group2 = "testGroup2";
        ClusterLinkConfig clusterLinkConfig = this.linkConfig(this.allowAllFilter());
        this.setupMockListGroupsResponse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{group1, group2}));
        EasyMock.expect((Object)this.sourceClusterLinkAdmin().listConsumerGroupOffsets((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group1), this.nullList()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group2), this.nullList())}))).asJava()), (ListConsumerGroupOffsetsOptions)EasyMock.isA(ListConsumerGroupOffsetsOptions.class))).andReturn((Object)this.mockListOffsetsException((List<String>)new .colon.colon((Object)group1, (List)new .colon.colon((Object)group2, (List)Nil$.MODULE$)), (Throwable)new OffsetFetchRequest.NoBatchedOffsetFetchRequestException("Unsupported operation"))).times(1);
        this.setupMockListGroupsResponse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{group1, group2}));
        scala.collection.immutable.Map offsetEntries = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test-topic", 1)), (Object)this.offsetAndMetadata(1L))}));
        this.setupOldMockOffsetResponses((scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)offsetEntries, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{group1, group2}));
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)clusterLinkConfig).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.sourceAdmin(), this.clientManager(), this.sourceClusterLinkAdmin(), this.destAdmin(), this.controller(), this.controllerContext()});
        ClusterLinkSyncOffsets syncOffsets = new ClusterLinkSyncOffsets(this.clientManager(), this.linkData(this.linkData$default$1()), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics());
        syncOffsets.runOnce().get(5L, TimeUnit.SECONDS);
        syncOffsets.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
    }

    @Test
    public void testCurrentOffsetsAreNotUpdatedOnCommitFailure() {
        this.setupMock(this.setupMock$default$1());
        String group = "testGroup";
        ClusterLinkConfig clusterLinkConfig = this.linkConfig(this.allowAllFilter());
        this.setupMockListGroupsResponse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{group}));
        scala.collection.immutable.Map offsetEntries = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)this.offsetAndMetadata(1L))}));
        ListConsumerGroupOffsetsResult listOffsetsResult = this.mockListOffsets((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava())}))).asJava());
        AlterConsumerGroupOffsetsResult alterOffsetsResult = this.mockAlterOffsets((Option<Throwable>)new Some((Object)new GroupAuthorizationException("not authorized")));
        EasyMock.expect((Object)this.sourceClusterLinkAdmin().listConsumerGroupOffsets((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), this.nullList())}))).asJava()), (ListConsumerGroupOffsetsOptions)EasyMock.isA(ListConsumerGroupOffsetsOptions.class))).andReturn((Object)listOffsetsResult).times(1);
        EasyMock.expect((Object)this.destAdmin().alterConsumerGroupOffsets(group, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava())).andReturn((Object)alterOffsetsResult).times(1);
        ClusterLinkSyncOffsets syncOffsets = this.syncOffsetsAndVerify(clusterLinkConfig, this.syncOffsetsAndVerify$default$2());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)syncOffsets.currentOffsets().toMap(Predef$.MODULE$.$conforms()));
    }

    @Test
    public void testFiltersGroupListingWithLiteral() {
        this.setupMock(this.setupMock$default$1());
        String validGroupName = "validGroup";
        String invalidGroupName = "invalidGroup";
        String allowOneFilter = this.offsetFilter(new ClusterLinkFilter(validGroupName, "LITERAL", "INCLUDE"));
        ClusterLinkConfig clusterLinkConfig = this.linkConfig(allowOneFilter);
        this.setupMockListGroupsResponse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{validGroupName, invalidGroupName}));
        scala.collection.immutable.Map offsetEntries = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)this.offsetAndMetadata(1L))}));
        this.setupMockOffsetResponses((scala.collection.immutable.Map<String, java.util.Map<TopicPartition, OffsetAndMetadata>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)validGroupName), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava())}))));
        ClusterLinkSyncOffsets syncOffsets = this.syncOffsetsAndVerify(clusterLinkConfig, this.syncOffsetsAndVerify$default$2());
        Assertions.assertEquals((int)1, (int)syncOffsets.currentOffsets().size());
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)((MapLike)syncOffsets.currentOffsets().apply((Object)validGroupName)).apply((Object)this.tp())));
    }

    @Test
    public void testFiltersMultipleGroupsWithPrefix() {
        this.setupMock(this.setupMock$default$1());
        String validGroupName = "validGroup";
        String validGroupName1 = "validGroup1";
        String invalidGroupName = "invalidGroup";
        String allowPrefixFilter = this.offsetFilter(new ClusterLinkFilter(validGroupName, "PREFIXED", "INCLUDE"));
        ClusterLinkConfig clusterLinkConfig = this.linkConfig(allowPrefixFilter);
        this.setupMockListGroupsResponse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{validGroupName, validGroupName1, invalidGroupName}));
        scala.collection.immutable.Map offsetEntries = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)this.offsetAndMetadata(1L))}));
        this.setupMockOffsetResponses((scala.collection.immutable.Map<String, java.util.Map<TopicPartition, OffsetAndMetadata>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)validGroupName), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)validGroupName1), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava())}))));
        ClusterLinkSyncOffsets syncOffsets = this.syncOffsetsAndVerify(clusterLinkConfig, this.syncOffsetsAndVerify$default$2());
        Assertions.assertEquals((int)2, (int)syncOffsets.currentOffsets().size());
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)((MapLike)syncOffsets.currentOffsets().apply((Object)validGroupName)).apply((Object)this.tp())));
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)((MapLike)syncOffsets.currentOffsets().apply((Object)validGroupName1)).apply((Object)this.tp())));
    }

    @Test
    public void testFiltersExcludedGroup() {
        this.setupMock(this.setupMock$default$1());
        String validGroupName = "validGroup";
        String validGroupName1 = "validGroup1";
        String invalidGroupName = "invalidGroup";
        String excludeFilter = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(332).append("\n         |{\n         |\"groupFilters\": [\n         |  {\n         |     \"name\": \"*\",\n         |     \"patternType\": \"LITERAL\",\n         |     \"filterType\": \"INCLUDE\"\n         |  },\n         |  {\n         |     \"name\": \"").append(invalidGroupName).append("\",\n         |     \"patternType\": \"LITERAL\",\n         |     \"filterType\": \"EXCLUDE\"\n         |  }\n         |]}\n      ").toString())).stripMargin();
        ClusterLinkConfig clusterLinkConfig = this.linkConfig(excludeFilter);
        this.setupMockListGroupsResponse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{validGroupName, validGroupName1, invalidGroupName}));
        scala.collection.immutable.Map offsetEntries = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)this.offsetAndMetadata(1L))}));
        this.setupMockOffsetResponses((scala.collection.immutable.Map<String, java.util.Map<TopicPartition, OffsetAndMetadata>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)validGroupName), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)validGroupName1), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava())}))));
        ClusterLinkSyncOffsets syncOffsets = this.syncOffsetsAndVerify(clusterLinkConfig, this.syncOffsetsAndVerify$default$2());
        Assertions.assertEquals((int)2, (int)syncOffsets.currentOffsets().size());
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)((MapLike)syncOffsets.currentOffsets().apply((Object)validGroupName)).apply((Object)this.tp())));
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)((MapLike)syncOffsets.currentOffsets().apply((Object)validGroupName1)).apply((Object)this.tp())));
    }

    @Test
    public void testFiltersMultipleExcludedGroupWithPrefix() {
        this.setupMock(this.setupMock$default$1());
        String validGroupName = "validGroup";
        String validGroupName1 = "validGroup1";
        String invalidGroupName = "invalidGroup";
        String invalidGroupName2 = "invalidGroup2";
        String excludeFilter = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(333).append("\n         |{\n         |\"groupFilters\": [\n         |  {\n         |     \"name\": \"*\",\n         |     \"patternType\": \"LITERAL\",\n         |     \"filterType\": \"INCLUDE\"\n         |  },\n         |  {\n         |     \"name\": \"").append(invalidGroupName).append("\",\n         |     \"patternType\": \"PREFIXED\",\n         |     \"filterType\": \"EXCLUDE\"\n         |  }\n         |]}\n      ").toString())).stripMargin();
        ClusterLinkConfig clusterLinkConfig = this.linkConfig(excludeFilter);
        this.setupMockListGroupsResponse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{validGroupName, validGroupName1, invalidGroupName, invalidGroupName2}));
        scala.collection.immutable.Map offsetEntries = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)this.offsetAndMetadata(1L))}));
        this.setupMockOffsetResponses((scala.collection.immutable.Map<String, java.util.Map<TopicPartition, OffsetAndMetadata>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)validGroupName), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)validGroupName1), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava())}))));
        ClusterLinkSyncOffsets syncOffsets = this.syncOffsetsAndVerify(clusterLinkConfig, this.syncOffsetsAndVerify$default$2());
        Assertions.assertEquals((int)2, (int)syncOffsets.currentOffsets().size());
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)((MapLike)syncOffsets.currentOffsets().apply((Object)validGroupName)).apply((Object)this.tp())));
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)((MapLike)syncOffsets.currentOffsets().apply((Object)validGroupName1)).apply((Object)this.tp())));
    }

    @Test
    public void testCanUpdateGroupFilters() {
        this.setupMock(this.setupMock$default$1());
        String validGroupName = "validGroup";
        String newGroupName = "newGroup";
        String origFilter = new StringOps(Predef$.MODULE$.augmentString("\n         |{\n         |\"groupFilters\": [\n         |  {\n         |     \"name\": \"validGroup\",\n         |     \"patternType\": \"LITERAL\",\n         |     \"filterType\": \"INCLUDE\"\n         |  }\n         |]}\n      ")).stripMargin();
        String updatedFilter = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(341).append("\n         |{\n         |\"groupFilters\": [\n         |  {\n         |     \"name\": \"validGroup\",\n         |     \"patternType\": \"LITERAL\",\n         |     \"filterType\": \"INCLUDE\"\n         |  },\n         |  {\n         |     \"name\": \"").append(newGroupName).append("\",\n         |     \"patternType\": \"LITERAL\",\n         |     \"filterType\": \"INCLUDE\"\n         |  }\n         |]}\n      ").toString())).stripMargin();
        ClusterLinkConfig origLinkConfig = this.linkConfig(origFilter);
        ClusterLinkConfig updatedLinkConfig = this.linkConfig(updatedFilter);
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)origLinkConfig).times(3);
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)updatedLinkConfig).times(1);
        this.setupMockListGroupsResponse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{validGroupName, newGroupName}));
        this.setupMockListGroupsResponse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{validGroupName, newGroupName}));
        scala.collection.immutable.Map offsetEntries = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)this.offsetAndMetadata(1L))}));
        this.setupMockOffsetResponses((scala.collection.immutable.Map<String, java.util.Map<TopicPartition, OffsetAndMetadata>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)validGroupName), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava())}))));
        this.setupMockOffsetResponses((scala.collection.immutable.Map<String, java.util.Map<TopicPartition, OffsetAndMetadata>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)validGroupName), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)newGroupName), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava())}))));
        EasyMock.replay((Object[])new Object[]{this.sourceAdmin(), this.clientManager(), this.destAdmin(), this.sourceClusterLinkAdmin(), this.controllerContext(), this.controller()});
        ClusterLinkSyncOffsets syncOffsets = new ClusterLinkSyncOffsets(this.clientManager(), this.linkData(this.linkData$default$1()), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics());
        syncOffsets.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)1, (int)syncOffsets.currentOffsets().size());
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)((MapLike)syncOffsets.currentOffsets().apply((Object)validGroupName)).apply((Object)this.tp())));
        syncOffsets.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)2, (int)syncOffsets.currentOffsets().size());
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)((MapLike)syncOffsets.currentOffsets().apply((Object)validGroupName)).apply((Object)this.tp())));
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)((MapLike)syncOffsets.currentOffsets().apply((Object)newGroupName)).apply((Object)this.tp())));
        this.verifyMock();
    }

    @Test
    public void testDoesNotUpdateUnchangedOffsets() {
        this.setupMock(this.setupMock$default$1());
        String groupName = "testGroup";
        ClusterLinkConfig clusterLinkConfig = this.linkConfig(this.allowAllFilter());
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)clusterLinkConfig).anyTimes();
        this.setupMockListGroupsResponse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{groupName}));
        scala.collection.immutable.Map offsetEntries = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)this.offsetAndMetadata(1L))}));
        ListConsumerGroupOffsetsResult listOffsetsResult = this.mockListOffsets((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)groupName), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava())}))).asJava());
        EasyMock.expect((Object)this.sourceClusterLinkAdmin().listConsumerGroupOffsets((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)groupName), this.nullList())}))).asJava()), (ListConsumerGroupOffsetsOptions)EasyMock.isA(ListConsumerGroupOffsetsOptions.class))).andReturn((Object)listOffsetsResult).times(1);
        EasyMock.replay((Object[])new Object[]{this.sourceAdmin(), this.clientManager(), this.destAdmin(), this.sourceClusterLinkAdmin(), this.controllerContext(), this.controller()});
        ClusterLinkSyncOffsets syncOffsets = new ClusterLinkSyncOffsets(this.clientManager(), this.linkData(this.linkData$default$1()), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics());
        syncOffsets.currentOffsets().clear();
        syncOffsets.currentOffsets().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)groupName), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)BoxesRunTime.boxToLong((long)1L))}))));
        syncOffsets.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)1, (int)syncOffsets.currentOffsets().size());
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)((MapLike)syncOffsets.currentOffsets().apply((Object)groupName)).apply((Object)this.tp())));
        this.verifyMock();
    }

    @Test
    public void testOldGroupsAreRemovedFromCurrentOffsets() {
        this.setupMock(this.setupMock$default$1());
        String groupName = "testGroup";
        String oldGroupName = "oldGroup";
        ClusterLinkConfig clusterLinkConfig = this.linkConfig(this.allowAllFilter());
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)clusterLinkConfig).anyTimes();
        this.setupMockListGroupsResponse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{groupName}));
        scala.collection.immutable.Map offsetEntries = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)this.offsetAndMetadata(1L))}));
        this.setupMockOffsetResponses((scala.collection.immutable.Map<String, java.util.Map<TopicPartition, OffsetAndMetadata>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)groupName), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava())}))));
        EasyMock.replay((Object[])new Object[]{this.sourceAdmin(), this.clientManager(), this.destAdmin(), this.sourceClusterLinkAdmin(), this.controllerContext(), this.controller()});
        ClusterLinkSyncOffsets syncOffsets = new ClusterLinkSyncOffsets(this.clientManager(), this.linkData(this.linkData$default$1()), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics());
        syncOffsets.currentOffsets().clear();
        syncOffsets.currentOffsets().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)oldGroupName), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)BoxesRunTime.boxToLong((long)1L))}))));
        syncOffsets.runOnce().get(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)1, (int)syncOffsets.currentOffsets().size());
        Assertions.assertFalse((boolean)syncOffsets.currentOffsets().contains((Object)oldGroupName));
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)((MapLike)syncOffsets.currentOffsets().apply((Object)groupName)).apply((Object)this.tp())));
        this.verifyMock();
    }

    @Test
    public void testDoesNotCommitNonMirroredTopics() {
        this.setupMock(this.setupMock$default$1());
        String nonMirroredTopic = "nonMirroredTopic";
        String groupName = "testGroup";
        ClusterLinkConfig clusterLinkConfig = this.linkConfig(this.allowAllFilter());
        this.setupMockListGroupsResponse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{groupName}));
        scala.collection.immutable.Map validOffsetEntries = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)this.offsetAndMetadata(1L))}));
        scala.collection.immutable.Map invalidOffsetEntries = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(nonMirroredTopic, 1)), (Object)this.offsetAndMetadata(1L))}));
        ListConsumerGroupOffsetsResult listConsumerGroupOffsetsResult = this.mockListOffsets((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)groupName), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)validOffsetEntries.$plus$plus((GenTraversableOnce)invalidOffsetEntries)).asJava())}))).asJava());
        AlterConsumerGroupOffsetsResult alterConsumerGroupOffsetsResult = this.mockAlterOffsets(this.mockAlterOffsets$default$1());
        EasyMock.expect((Object)this.sourceClusterLinkAdmin().listConsumerGroupOffsets((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)groupName), this.nullList())}))).asJava()), (ListConsumerGroupOffsetsOptions)EasyMock.isA(ListConsumerGroupOffsetsOptions.class))).andReturn((Object)listConsumerGroupOffsetsResult).times(1);
        EasyMock.expect((Object)this.destAdmin().alterConsumerGroupOffsets(groupName, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)validOffsetEntries).asJava())).andReturn((Object)alterConsumerGroupOffsetsResult);
        ClusterLinkSyncOffsets syncOffsets = this.syncOffsetsAndVerify(clusterLinkConfig, this.syncOffsetsAndVerify$default$2());
        Assertions.assertEquals((int)1, (int)syncOffsets.currentOffsets().size());
        Assertions.assertEquals((long)1L, (long)BoxesRunTime.unboxToLong((Object)((MapLike)syncOffsets.currentOffsets().apply((Object)groupName)).apply((Object)this.tp())));
    }

    @Test
    public void testNoGroupAuthOnOffsetCommit() {
        this.setupMock(this.setupMock$default$1());
        String groupName = "testGroup";
        ClusterLinkConfig clusterLinkConfig = this.linkConfig(this.allowAllFilter());
        this.setupMockListGroupsResponse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{groupName}));
        scala.collection.immutable.Map offsetEntries = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)this.offsetAndMetadata(1L))}));
        ListConsumerGroupOffsetsResult listConsumerGroupOffsetsResult = this.mockListOffsets((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)groupName), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava())}))).asJava());
        KafkaFutureImpl alterConsumerGroupOffsetsFuture = new KafkaFutureImpl();
        alterConsumerGroupOffsetsFuture.completeExceptionally((Throwable)new GroupAuthorizationException("no group auth"));
        AlterConsumerGroupOffsetsResult alterConsumerGroupOffsetsResult = (AlterConsumerGroupOffsetsResult)EasyMock.createMock(AlterConsumerGroupOffsetsResult.class);
        EasyMock.expect((Object)alterConsumerGroupOffsetsResult.all()).andReturn((Object)alterConsumerGroupOffsetsFuture).anyTimes();
        EasyMock.replay((Object[])new Object[]{alterConsumerGroupOffsetsResult});
        EasyMock.expect((Object)this.sourceClusterLinkAdmin().listConsumerGroupOffsets((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)groupName), this.nullList())}))).asJava()), (ListConsumerGroupOffsetsOptions)EasyMock.isA(ListConsumerGroupOffsetsOptions.class))).andReturn((Object)listConsumerGroupOffsetsResult).times(1);
        EasyMock.expect((Object)this.destAdmin().alterConsumerGroupOffsets(groupName, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava())).andReturn((Object)alterConsumerGroupOffsetsResult);
        this.syncOffsetsAndVerify(clusterLinkConfig, this.syncOffsetsAndVerify$default$2());
    }

    @Test
    public void testNoTopicAuthOnOffsetCommit() {
        this.setupMock(this.setupMock$default$1());
        String groupName = "testGroup";
        ClusterLinkConfig clusterLinkConfig = this.linkConfig(this.allowAllFilter());
        this.setupMockListGroupsResponse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{groupName}));
        scala.collection.immutable.Map offsetEntries = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)this.offsetAndMetadata(1L))}));
        ListConsumerGroupOffsetsResult listConsumerGroupOffsetsResult = this.mockListOffsets((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)groupName), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava())}))).asJava());
        KafkaFutureImpl alterConsumerGroupOffsetsFuture = new KafkaFutureImpl();
        alterConsumerGroupOffsetsFuture.completeExceptionally((Throwable)new TopicAuthorizationException("no topic auth"));
        AlterConsumerGroupOffsetsResult alterConsumerGroupOffsetsResult = (AlterConsumerGroupOffsetsResult)EasyMock.createMock(AlterConsumerGroupOffsetsResult.class);
        EasyMock.expect((Object)alterConsumerGroupOffsetsResult.all()).andReturn((Object)alterConsumerGroupOffsetsFuture).anyTimes();
        EasyMock.replay((Object[])new Object[]{alterConsumerGroupOffsetsResult});
        EasyMock.expect((Object)this.sourceClusterLinkAdmin().listConsumerGroupOffsets((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)groupName), this.nullList())}))).asJava()), (ListConsumerGroupOffsetsOptions)EasyMock.isA(ListConsumerGroupOffsetsOptions.class))).andReturn((Object)listConsumerGroupOffsetsResult).times(1);
        EasyMock.expect((Object)this.destAdmin().alterConsumerGroupOffsets(groupName, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava())).andReturn((Object)alterConsumerGroupOffsetsResult);
        this.syncOffsetsAndVerify(clusterLinkConfig, this.syncOffsetsAndVerify$default$2());
    }

    @Test
    public void testMigrateTenantOffsetsWithLiteralFilter() {
        this.verifyTenantFilter("testGroup", new ClusterLinkFilter("testGroup", "LITERAL", "INCLUDE"));
    }

    @Test
    public void testMigrateTenantOffsetsWithWildcardFilter() {
        this.verifyTenantFilter("testGroup", new ClusterLinkFilter("*", "LITERAL", "INCLUDE"));
    }

    @Test
    public void testMigrateTenantOffsetsWithPrefixedFilter() {
        this.verifyTenantFilter("testGroup", new ClusterLinkFilter("test", "PREFIXED", "INCLUDE"));
    }

    private void verifyTenantFilter(String group, ClusterLinkFilter filter) {
        this.setupMock(this.setupMock$default$1());
        String prefix = "destPrefix_";
        String prefixedGroup = new StringBuilder(0).append(prefix).append(group).toString();
        this.setupMockListGroupsResponse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{prefixedGroup}));
        scala.collection.immutable.Map offsetEntries = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.tp()), (Object)this.offsetAndMetadata(1L))}));
        this.setupMockOffsetResponses((scala.collection.immutable.Map<String, java.util.Map<TopicPartition, OffsetAndMetadata>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)prefixedGroup), CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava())}))));
        ClusterLinkConfig clusterLinkConfig = this.linkConfig(this.offsetFilter(filter));
        this.syncOffsetsAndVerify(clusterLinkConfig, (Option<String>)new Some((Object)prefix));
    }

    private String offsetFilter(ClusterLinkFilter groupFilter) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(165).append("\n       |{\n       |\"groupFilters\": [\n       |  {\n       |     \"name\": \"").append(groupFilter.name()).append("\",\n       |     \"patternType\": \"").append(groupFilter.patternType()).append("\",\n       |     \"filterType\": \"").append(groupFilter.filterType()).append("\"\n       |  }]\n       |}\n      ").toString())).stripMargin();
    }

    private ClusterLinkConfig linkConfig(String offsetFilter) {
        return ClusterLinkConfig$.MODULE$.create((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetSyncEnableProp()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ClusterLinkConfig$.MODULE$.ConsumerOffsetGroupFiltersProp()), (Object)offsetFilter)}))).asJava());
    }

    private ClusterLinkData linkData(Option<String> tenantPrefix) {
        return new ClusterLinkData("testLink", this.linkId(), (Option)None$.MODULE$, tenantPrefix, false);
    }

    private Option<String> linkData$default$1() {
        return None$.MODULE$;
    }

    private ListConsumerGroupsResult mockListGroups(Seq<String> groups) {
        List consumerGroups = ((TraversableOnce)groups.map((Function1 & Serializable & scala.Serializable)name -> this.consumerGroupListing((String)name), Seq$.MODULE$.canBuildFrom())).toList();
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)consumerGroups).asJava());
        ListConsumerGroupsResult result = (ListConsumerGroupsResult)EasyMock.createMock(ListConsumerGroupsResult.class);
        EasyMock.expect((Object)result.all()).andReturn((Object)future).anyTimes();
        EasyMock.replay((Object[])new Object[]{result});
        return result;
    }

    private ListConsumerGroupOffsetsResult mockListOffsets(java.util.Map<String, java.util.Map<TopicPartition, OffsetAndMetadata>> offsetEntries) {
        HashMap futureMap = new HashMap();
        offsetEntries.forEach((group, tpMap) -> {
            KafkaFutureImpl future = new KafkaFutureImpl();
            future.complete(tpMap);
            futureMap.put(group, future);
        });
        KafkaFutureImpl allFuture = new KafkaFutureImpl();
        allFuture.complete(offsetEntries);
        ListConsumerGroupOffsetsResult result = (ListConsumerGroupOffsetsResult)EasyMock.createMock(ListConsumerGroupOffsetsResult.class);
        EasyMock.expect((Object)result.groupIdsToPartitionsAndOffsetAndMetadata()).andReturn(futureMap).anyTimes();
        EasyMock.expect((Object)result.all()).andReturn((Object)allFuture).anyTimes();
        EasyMock.replay((Object[])new Object[]{result});
        return result;
    }

    private ListConsumerGroupOffsetsResult mockListOffsetsException(List<String> groups, Throwable exception) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.completeExceptionally(exception);
        HashMap futureMap = new HashMap();
        KafkaFutureImpl offsetMap = new KafkaFutureImpl();
        offsetMap.completeExceptionally(exception);
        groups.foreach((Function1 & Serializable & scala.Serializable)g -> (KafkaFuture)futureMap.put(g, offsetMap));
        ListConsumerGroupOffsetsResult result = (ListConsumerGroupOffsetsResult)EasyMock.createMock(ListConsumerGroupOffsetsResult.class);
        EasyMock.expect((Object)result.groupIdsToPartitionsAndOffsetAndMetadata()).andReturn(futureMap).anyTimes();
        EasyMock.expect((Object)result.all()).andReturn((Object)future).anyTimes();
        EasyMock.replay((Object[])new Object[]{result});
        return result;
    }

    private AlterConsumerGroupOffsetsResult mockAlterOffsets(Option<Throwable> exception) {
        KafkaFutureImpl future = new KafkaFutureImpl();
        if (exception instanceof Some) {
            Throwable e = (Throwable)((Some)exception).value();
            future.completeExceptionally(e);
        } else if (None$.MODULE$.equals(exception)) {
            future.complete(null);
        } else {
            throw new MatchError(exception);
        }
        AlterConsumerGroupOffsetsResult result = (AlterConsumerGroupOffsetsResult)EasyMock.createMock(AlterConsumerGroupOffsetsResult.class);
        EasyMock.expect((Object)result.all()).andReturn((Object)future).anyTimes();
        EasyMock.replay((Object[])new Object[]{result});
        return result;
    }

    private Option<Throwable> mockAlterOffsets$default$1() {
        return None$.MODULE$;
    }

    private void setupOldMockOffsetResponses(scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsetEntries, Seq<String> groups) {
        ListConsumerGroupOffsetsResult listOffsetsResult = this.mockOldListOffsets(offsetEntries);
        AlterConsumerGroupOffsetsResult alterOffsetsResult = this.mockAlterOffsets(this.mockAlterOffsets$default$1());
        groups.foreach((Function1 & Serializable & scala.Serializable)group -> {
            EasyMock.expect((Object)this.sourceAdmin().listConsumerGroupOffsets(group)).andReturn((Object)listOffsetsResult).times(1);
            return EasyMock.expect((Object)this.destAdmin().alterConsumerGroupOffsets(group, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)offsetEntries).asJava())).andReturn((Object)alterOffsetsResult).times(1);
        });
    }

    /*
     * WARNING - void declaration
     */
    private ListConsumerGroupOffsetsResult mockOldListOffsets(scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsetEntries) {
        void var3_3;
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(CollectionConverters$.MODULE$.mapAsJavaMapConverter(offsetEntries).asJava());
        ListConsumerGroupOffsetsResult result = (ListConsumerGroupOffsetsResult)EasyMock.createMock(ListConsumerGroupOffsetsResult.class);
        EasyMock.expect((Object)result.partitionsToOffsetAndMetadata()).andReturn((Object)future).anyTimes();
        EasyMock.replay((Object[])new Object[]{result});
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private ClusterLinkSyncOffsets syncOffsetsAndVerify(ClusterLinkConfig clusterLinkConfig, Option<String> tenantPrefix) {
        void var3_3;
        EasyMock.expect((Object)this.clientManager().currentConfig()).andReturn((Object)clusterLinkConfig).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.sourceAdmin(), this.clientManager(), this.sourceClusterLinkAdmin(), this.destAdmin(), this.controller(), this.controllerContext()});
        ClusterLinkSyncOffsets syncOffsets = new ClusterLinkSyncOffsets(this.clientManager(), this.linkData(tenantPrefix), this.controller(), (Function0 & Serializable & scala.Serializable)() -> this.destAdmin(), this.metrics());
        syncOffsets.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        return var3_3;
    }

    private Option<String> syncOffsetsAndVerify$default$2() {
        return None$.MODULE$;
    }

    private OffsetAndMetadata offsetAndMetadata(long offset) {
        return new OffsetAndMetadata(offset, Optional.empty(), "");
    }

    private ConsumerGroupListing consumerGroupListing(String name) {
        return new ConsumerGroupListing(name, true);
    }

    private void setupMockListGroupsResponse(Seq<String> groups) {
        ListConsumerGroupsResult listGroupsResult = this.mockListGroups(groups);
        EasyMock.expect((Object)this.sourceAdmin().listConsumerGroups()).andReturn((Object)listGroupsResult).times(1);
    }

    private void setupMockOffsetResponses(scala.collection.immutable.Map<String, java.util.Map<TopicPartition, OffsetAndMetadata>> groupMap) {
        Iterable groups = groupMap.keys();
        ListConsumerGroupOffsetsResult listOffsetsResult = this.mockListOffsets((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(groupMap).asJava());
        AlterConsumerGroupOffsetsResult alterOffsetsResult = this.mockAlterOffsets(this.mockAlterOffsets$default$1());
        java.util.Map requestMap = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)groups.map((Function1 & Serializable & scala.Serializable)g -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(g), this.nullList()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        EasyMock.expect((Object)this.sourceClusterLinkAdmin().listConsumerGroupOffsets((java.util.Map)EasyMock.eq((Object)requestMap), (ListConsumerGroupOffsetsOptions)EasyMock.isA(ListConsumerGroupOffsetsOptions.class))).andReturn((Object)listOffsetsResult).times(1);
        groups.foreach((Function1 & Serializable & scala.Serializable)group -> EasyMock.expect((Object)this.destAdmin().alterConsumerGroupOffsets(group, (java.util.Map)groupMap.apply(group))).andReturn((Object)alterOffsetsResult).times(1));
    }

    private void setupMock(boolean isController) {
        EasyMock.reset((Object[])new Object[]{this.sourceAdmin()});
        EasyMock.reset((Object[])new Object[]{this.clientManager()});
        EasyMock.reset((Object[])new Object[]{this.controllerContext()});
        EasyMock.reset((Object[])new Object[]{this.controller()});
        EasyMock.reset((Object[])new Object[]{this.sourceClusterLinkAdmin()});
        ConcurrentHashMap<String, ClusterLinkTopicState> linkedTopics = new ConcurrentHashMap<String, ClusterLinkTopicState>();
        linkedTopics.put("testTopic", this.testTopicState());
        linkedTopics.put("testTopicPendingStopped", this.testPendingStopTopicState());
        linkedTopics.put("testTopicFailed", this.testFailedTopicState());
        linkedTopics.put("testTopicPaused", this.testPausedTopicState());
        linkedTopics.put("testTopicStopped", this.testStoppedTopicState());
        EasyMock.expect((Object)this.clientManager().scheduler()).andReturn((Object)this.scheduler()).anyTimes();
        EasyMock.expect((Object)this.clientManager().getAdmin()).andReturn((Object)this.sourceAdmin()).anyTimes();
        EasyMock.expect((Object)this.clientManager().getClusterLinkAdminClient()).andReturn((Object)this.sourceClusterLinkAdmin()).anyTimes();
        EasyMock.expect((Object)this.controllerContext().linkedTopics()).andReturn(CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(linkedTopics).asScala()).anyTimes();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)this.controller().isActive())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)isController)).anyTimes();
        EasyMock.expect((Object)this.controller().controllerContext()).andReturn((Object)this.controllerContext()).anyTimes();
    }

    private boolean setupMock$default$1() {
        return true;
    }

    private void verifyMock() {
        EasyMock.verify((Object[])new Object[]{this.clientManager()});
        EasyMock.verify((Object[])new Object[]{this.sourceAdmin()});
        EasyMock.verify((Object[])new Object[]{this.controllerContext()});
        EasyMock.verify((Object[])new Object[]{this.controller()});
        EasyMock.verify((Object[])new Object[]{this.sourceClusterLinkAdmin()});
    }
}

