/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import kafka.server.ConfigType$;
import kafka.server.link.ClusterLinkAlterConfigPolicy;
import kafka.server.link.ClusterLinkClientManager;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkManager;
import kafka.server.link.ClusterLinkMetrics;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkSyncTopicsConfigs;
import kafka.server.link.LinkMode;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.zk.AdminZkClient;
import kafka.zk.ClusterLinkData;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ug\u0001\u0002\u0013&\u00011BQa\r\u0001\u0005\u0002QBqa\u000e\u0001C\u0002\u0013%\u0001\b\u0003\u0004=\u0001\u0001\u0006I!\u000f\u0005\b{\u0001\u0011\r\u0011\"\u0003?\u0011\u0019Y\u0005\u0001)A\u0005\u007f!9A\n\u0001b\u0001\n\u0013i\u0005B\u0002+\u0001A\u0003%a\nC\u0004V\u0001\t\u0007I\u0011\u0002,\t\ri\u0003\u0001\u0015!\u0003X\u0011\u001dY\u0006A1A\u0005\nqCa\u0001\u0019\u0001!\u0002\u0013i\u0006bB1\u0001\u0005\u0004%IA\u0019\u0005\u0007M\u0002\u0001\u000b\u0011B2\t\u000f\u001d\u0004!\u0019!C\u0005Q\"1A\u000e\u0001Q\u0001\n%Dq!\u001c\u0001C\u0002\u0013%a\u000e\u0003\u0004s\u0001\u0001\u0006Ia\u001c\u0005\u0006g\u0002!\t\u0001\u001e\u0005\u0007\u0003\u000f\u0001A\u0011\u0001;\t\r\u0005E\u0001\u0001\"\u0001u\u0011\u0019\tY\u0002\u0001C\u0001i\"1\u0011q\u0004\u0001\u0005\u0002QDa!a\t\u0001\t\u0003!\bBBA\u0014\u0001\u0011\u0005A\u000f\u0003\u0004\u0002,\u0001!\t\u0001\u001e\u0005\u0007\u0003_\u0001A\u0011\u0001;\t\r\u0005M\u0002\u0001\"\u0001u\u0011\u001d\t9\u0004\u0001C\u0005\u0003sA\u0011\"a\u001d\u0001#\u0003%I!!\u001e\t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\"9\u0011\u0011\u0015\u0001\u0005\n\u0005\r\u0006bBAS\u0001\u0011%\u0011q\u0015\u0005\n\u0003\u000f\u0004\u0011\u0013!C\u0005\u0003\u0013D\u0011\"!4\u0001#\u0003%I!a4\t\r\u0005M\u0007\u0001\"\u0003u\u0005\u0001\u001aE.^:uKJd\u0015N\\6Ts:\u001cGk\u001c9jGN\u001cuN\u001c4jON$Vm\u001d;\u000b\u0005\u0019:\u0013\u0001\u00027j].T!\u0001K\u0015\u0002\rM,'O^3s\u0015\u0005Q\u0013!B6bM.\f7\u0001A\n\u0003\u00015\u0002\"AL\u0019\u000e\u0003=R\u0011\u0001M\u0001\u0006g\u000e\fG.Y\u0005\u0003e=\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u00016!\t1\u0004!D\u0001&\u0003%\u00198\r[3ek2,'/F\u0001:!\t1$(\u0003\u0002<K\t!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!\u0003\u0015\tG-\\5o+\u0005y\u0004C\u0001!J\u001b\u0005\t%BA\u001fC\u0015\t\u0019E)A\u0004dY&,g\u000e^:\u000b\u0005)*%B\u0001$H\u0003\u0019\t\u0007/Y2iK*\t\u0001*A\u0002pe\u001eL!AS!\u0003\u001d\r{gN\u001a7vK:$\u0018\tZ7j]\u00061\u0011\rZ7j]\u0002\n\u0001B_6DY&,g\u000e^\u000b\u0002\u001dB\u0011qJU\u0007\u0002!*\u0011\u0011+K\u0001\u0003u.L!a\u0015)\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0003%Q8n\u00117jK:$\b%A\u0007bI6LgNW6DY&,g\u000e^\u000b\u0002/B\u0011q\nW\u0005\u00033B\u0013Q\"\u00113nS:T6n\u00117jK:$\u0018AD1e[&t'l[\"mS\u0016tG\u000fI\u0001\u000eG2LWM\u001c;NC:\fw-\u001a:\u0016\u0003u\u0003\"A\u000e0\n\u0005}+#\u0001G\"mkN$XM\u001d'j].\u001cE.[3oi6\u000bg.Y4fe\u0006q1\r\\5f]Rl\u0015M\\1hKJ\u0004\u0013aB7fiJL7m]\u000b\u0002GB\u0011a\u0007Z\u0005\u0003K\u0016\u0012!c\u00117vgR,'\u000fT5oW6+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0006mS:\\7i\u001c8gS\u001e,\u0012!\u001b\t\u0003m)L!a[\u0013\u0003#\rcWo\u001d;fe2Kgn[\"p]\u001aLw-A\u0006mS:\\7i\u001c8gS\u001e\u0004\u0013\u0001\u0006;pa&\u001c7i\u001c8gS\u001e\u001c\u0016P\\2Sk2,7/F\u0001p!\t1\u0004/\u0003\u0002rK\tQR*\u001b:s_J$v\u000e]5d\u0007>tg-[4Ts:\u001c'+\u001e7fg\u0006)Bo\u001c9jG\u000e{gNZ5h'ft7MU;mKN\u0004\u0013!B:fiV\u0003H#A;\u0011\u000592\u0018BA<0\u0005\u0011)f.\u001b;)\u0005II\bc\u0001>\u0002\u00045\t1P\u0003\u0002}{\u0006\u0019\u0011\r]5\u000b\u0005y|\u0018a\u00026va&$XM\u001d\u0006\u0004\u0003\u00039\u0015!\u00026v]&$\u0018bAA\u0003w\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0011Q,\u0017M\u001d#po:D3aEA\u0006!\rQ\u0018QB\u0005\u0004\u0003\u001fY(!C!gi\u0016\u0014X)Y2i\u0003E!Xm\u001d;Va\u0012\fG/Z\"p]\u001aLwm\u001d\u0015\u0004)\u0005U\u0001c\u0001>\u0002\u0018%\u0019\u0011\u0011D>\u0003\tQ+7\u000f^\u0001\u0014i\u0016\u001cHOT8Va\u0012\fG/Z\"p]\u001aLwm\u001d\u0015\u0004+\u0005U\u0011!\u000b;fgRtuNU3qK\u0006$X\r\u001a'pG\u0006dg)\u001a;dQ\u000e{gNZ5hg>sgj\\\"iC:<W\rK\u0002\u0017\u0003+\tA\u0004^3ti\u0016C8-\u001a9uS>tg)\u001a;dQ&twmQ8oM&<7\u000fK\u0002\u0018\u0003+\t!\u0004^3ti\u0016C8-\u001a9uS>t7i\u001c8gS\u001e\u001c(+Z:vYRD3\u0001GA\u000b\u0003A!Xm\u001d;DQ\u0006tw-\u001a+pa&\u001c7\u000fK\u0002\u001a\u0003+\t\u0001\u0005^3ti\u000ecWo\u001d;fe2Kgn[!mi\u0016\u00148i\u001c8gS\u001e\u0004v\u000e\\5ds\"\u001a!$!\u0006\u0002=Q,7\u000f^!mi\u0016\u00148i\u001c8gS\u001e\u0004v\u000e\\5dsZKw\u000e\\1uS>t\u0007fA\u000e\u0002\u0016\u0005ya/\u001a:jMf\u001cuN\u001c4jO6\u000b\u0007\u000fF\u0004v\u0003w\ty%!\u0017\t\u000f\u0005uB\u00041\u0001\u0002@\u0005)\u0001O]8qgB!\u0011\u0011IA&\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005\u001d\u0013\u0001B;uS2T!!!\u0013\u0002\t)\fg/Y\u0005\u0005\u0003\u001b\n\u0019E\u0001\u0006Qe>\u0004XM\u001d;jKNDq!!\u0015\u001d\u0001\u0004\t\u0019&A\tts:\u001cGk\u001c9jGN\u001cuN\u001c4jON\u00042ANA+\u0013\r\t9&\n\u0002\u001d\u00072,8\u000f^3s\u0019&t7nU=oGR{\u0007/[2t\u0007>tg-[4t\u0011%\tY\u0006\bI\u0001\u0002\u0004\ti&A\u0003u_BL7\r\u0005\u0003\u0002`\u00055d\u0002BA1\u0003S\u00022!a\u00190\u001b\t\t)GC\u0002\u0002h-\na\u0001\u0010:p_Rt\u0014bAA6_\u00051\u0001K]3eK\u001aLA!a\u001c\u0002r\t11\u000b\u001e:j]\u001eT1!a\u001b0\u0003e1XM]5gs\u000e{gNZ5h\u001b\u0006\u0004H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005]$\u0006BA/\u0003sZ#!a\u001f\u0011\t\u0005u\u0014qQ\u0007\u0003\u0003\u007fRA!!!\u0002\u0004\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000b{\u0013AC1o]>$\u0018\r^5p]&!\u0011\u0011RA@\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0012]\u0016<8i\u001c8gS\u001e\u0014Vm]8ve\u000e,G\u0003BAH\u0003?\u0003B!!%\u0002\u001c6\u0011\u00111\u0013\u0006\u0005\u0003+\u000b9*\u0001\u0004d_:4\u0017n\u001a\u0006\u0004\u00033#\u0015AB2p[6|g.\u0003\u0003\u0002\u001e\u0006M%AD\"p]\u001aLwMU3t_V\u00148-\u001a\u0005\b\u00037r\u0002\u0019AA/\u0003}qWm^\"mkN$XM\u001d'j].\u001c\u0016P\\2U_BL7m]\"p]\u001aLwm\u001d\u000b\u0003\u0003'\n\u0011b]3ukBlunY6\u0015\u000bU\fI+!1\t\u0013\u0005-\u0006\u0005%AA\u0002\u00055\u0016!E1mi\u0016\u00148i\u001c8gS\u001e\u0004v\u000e\\5dsB)a&a,\u00024&\u0019\u0011\u0011W\u0018\u0003\r=\u0003H/[8o!\u0011\t),!0\u000e\u0005\u0005]&\u0002BA]\u0003w\u000ba\u0001]8mS\u000eL(B\u0001\u0015E\u0013\u0011\ty,a.\u0003#\u0005cG/\u001a:D_:4\u0017n\u001a)pY&\u001c\u0017\u0010C\u0005\u0002D\u0002\u0002\n\u00111\u0001\u0002F\u0006aA/\u001a8b]R\u0004&/\u001a4jqB)a&a,\u0002^\u0005\u00192/\u001a;va6{7m\u001b\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u001a\u0016\u0005\u0003[\u000bI(A\ntKR,\b/T8dW\u0012\"WMZ1vYR$#'\u0006\u0002\u0002R*\"\u0011QYA=\u0003)1XM]5gs6{7m\u001b")
public class ClusterLinkSyncTopicsConfigsTest {
    private final ClusterLinkScheduler scheduler = new ClusterLinkScheduler();
    private final ConfluentAdmin admin = (ConfluentAdmin)EasyMock.mock(ConfluentAdmin.class);
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.mock(KafkaZkClient.class);
    private final AdminZkClient adminZkClient = (AdminZkClient)EasyMock.mock(AdminZkClient.class);
    private final ClusterLinkClientManager clientManager = (ClusterLinkClientManager)EasyMock.mock(ClusterLinkClientManager.class);
    private final ClusterLinkMetrics metrics = new ClusterLinkMetrics("test-link", UUID.randomUUID(), (LinkMode)LinkMode.Destination$.MODULE$, (ClusterLinkManager)EasyMock.mock(ClusterLinkManager.class), (Option)None$.MODULE$, new Metrics(), (Option)None$.MODULE$);
    private final ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((java.util.Map)new Properties(null){
        {
            this.put("bootstrap.servers", "localhost:2345");
        }
    });
    private final MirrorTopicConfigSyncRules topicConfigSyncRules = this.linkConfig().topicConfigSyncRules();

    private ClusterLinkScheduler scheduler() {
        return this.scheduler;
    }

    private ConfluentAdmin admin() {
        return this.admin;
    }

    private KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    private ClusterLinkClientManager clientManager() {
        return this.clientManager;
    }

    private ClusterLinkMetrics metrics() {
        return this.metrics;
    }

    private ClusterLinkConfig linkConfig() {
        return this.linkConfig;
    }

    private MirrorTopicConfigSyncRules topicConfigSyncRules() {
        return this.topicConfigSyncRules;
    }

    @BeforeEach
    public void setUp() {
        this.scheduler().startup();
        this.metrics().startup();
    }

    @AfterEach
    public void tearDown() {
        this.scheduler().shutdown();
        this.metrics().shutdown();
    }

    @Test
    public void testUpdateConfigs() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        String topic = "test-topic";
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).times(1);
        EasyMock.expect((Object)this.clientManager().topicConfigSyncRules()).andReturn((Object)this.topicConfigSyncRules()).times(1);
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = this.newConfigResource(topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        EasyMock.expect((Object)this.admin().describeConfigs((Collection)EasyMock.eq(describeConfigsArg))).andReturn((Object)describeConfigsResult).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "delete");
        curProps.put("unclean.leader.election.enable", "true");
        EasyMock.expect((Object)this.adminZkClient().fetchEntityConfig((String)EasyMock.eq((Object)ConfigType$.MODULE$.Topic()), (String)EasyMock.eq((Object)topic))).andReturn((Object)curProps).times(1);
        Properties newProps = new Properties();
        newProps.put("cleanup.policy", "compact");
        newProps.put("unclean.leader.election.enable", "true");
        this.adminZkClient().changeTopicConfig((String)EasyMock.eq((Object)topic), (Properties)EasyMock.eq((Object)newProps));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{this.adminZkClient()});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        newProps.remove("unclean.leader.election.enable");
        this.verifyConfigMap(newProps, syncTopicsConfigs, this.verifyConfigMap$default$3());
    }

    @Test
    public void testNoUpdateConfigs() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        String topic = "test-topic";
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).times(1);
        EasyMock.expect((Object)this.clientManager().topicConfigSyncRules()).andReturn((Object)this.topicConfigSyncRules()).times(1);
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = this.newConfigResource(topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        EasyMock.expect((Object)this.admin().describeConfigs((Collection)EasyMock.eq(describeConfigsArg))).andReturn((Object)describeConfigsResult).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "compact");
        EasyMock.expect((Object)this.adminZkClient().fetchEntityConfig((String)EasyMock.eq((Object)ConfigType$.MODULE$.Topic()), (String)EasyMock.eq((Object)topic))).andReturn((Object)curProps).times(1);
        EasyMock.replay((Object[])new Object[]{this.adminZkClient()});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        this.verifyConfigMap(curProps, syncTopicsConfigs, this.verifyConfigMap$default$3());
    }

    @Test
    public void testNoRepeatedLocalFetchConfigsOnNoChange() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        String topic = "test-topic";
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).times(2);
        EasyMock.expect((Object)this.clientManager().topicConfigSyncRules()).andReturn((Object)this.topicConfigSyncRules()).times(1);
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = this.newConfigResource(topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        EasyMock.expect((Object)this.admin().describeConfigs((Collection)EasyMock.eq(describeConfigsArg))).andReturn((Object)describeConfigsResult).times(2);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "compact");
        EasyMock.expect((Object)this.adminZkClient().fetchEntityConfig((String)EasyMock.eq((Object)ConfigType$.MODULE$.Topic()), (String)EasyMock.eq((Object)topic))).andReturn((Object)curProps).times(1);
        EasyMock.replay((Object[])new Object[]{this.adminZkClient()});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        this.verifyConfigMap(curProps, syncTopicsConfigs, this.verifyConfigMap$default$3());
    }

    @Test
    public void testExceptionFetchingConfigs() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        String topic = "test-topic";
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).times(1);
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        Set<ConfigResource> describeConfigsArg = Collections.singleton(this.newConfigResource(topic));
        EasyMock.expect((Object)this.admin().describeConfigs((Collection)EasyMock.eq(describeConfigsArg))).andThrow((Throwable)new TopicAuthorizationException("")).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        EasyMock.replay((Object[])new Object[]{this.adminZkClient()});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        Assertions.assertTrue((boolean)(((ExecutionException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS)), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("ClusterLinkSyncTopicsConfigsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 174))).getCause() instanceof TopicAuthorizationException));
        this.verifyMock();
    }

    @Test
    public void testExceptionConfigsResult() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        .colon.colon topics = new .colon.colon((Object)"test-topic-1", (List)new .colon.colon((Object)"test-topic-2", (List)new .colon.colon((Object)"test-topic-3", (List)Nil$.MODULE$)));
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)topics.toSet()).times(1);
        EasyMock.expect((Object)this.clientManager().topicConfigSyncRules()).andReturn((Object)this.topicConfigSyncRules()).times(2);
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        KafkaFutureImpl successConfig = new KafkaFutureImpl();
        successConfig.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        KafkaFutureImpl errorConfig = new KafkaFutureImpl();
        errorConfig.completeExceptionally((Throwable)new TopicAuthorizationException(""));
        List resources = (List)topics.map((Function1 & Serializable & scala.Serializable)topic -> this.newConfigResource((String)topic), List$.MODULE$.canBuildFrom());
        java.util.HashSet describeConfigsArg = new java.util.HashSet(3);
        resources.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)describeConfigsArg.add(x$1)));
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resources.apply(0)), (Object)successConfig), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resources.apply(1)), (Object)errorConfig), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resources.apply(2)), (Object)successConfig)}))).asJava()));
        EasyMock.expect((Object)this.admin().describeConfigs((Collection)EasyMock.eq(describeConfigsArg))).andReturn((Object)describeConfigsResult).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        Properties curProps = new Properties();
        curProps.put("cleanup.policy", "delete");
        EasyMock.expect((Object)this.adminZkClient().fetchEntityConfig((String)EasyMock.eq((Object)ConfigType$.MODULE$.Topic()), (String)EasyMock.eq((Object)topics.apply(0)))).andReturn((Object)curProps).times(1);
        EasyMock.expect((Object)this.adminZkClient().fetchEntityConfig((String)EasyMock.eq((Object)ConfigType$.MODULE$.Topic()), (String)EasyMock.eq((Object)topics.apply(2)))).andReturn((Object)curProps).times(1);
        Properties newProps = new Properties();
        newProps.put("cleanup.policy", "compact");
        this.adminZkClient().changeTopicConfig((String)EasyMock.eq((Object)topics.apply(0)), (Properties)EasyMock.eq((Object)newProps));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        this.adminZkClient().changeTopicConfig((String)EasyMock.eq((Object)topics.apply(2)), (Properties)EasyMock.eq((Object)newProps));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{this.adminZkClient()});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        this.verifyConfigMap(newProps, syncTopicsConfigs, "test-topic-1");
        this.verifyConfigMap(new Properties(), syncTopicsConfigs, "test-topic-2");
        this.verifyConfigMap(newProps, syncTopicsConfigs, "test-topic-3");
    }

    @Test
    public void testChangeTopics() {
        this.setupMock(this.setupMock$default$1(), this.setupMock$default$2());
        .colon.colon topics = new .colon.colon((Object)"test-topic-1", (List)new .colon.colon((Object)"test-topic-2", (List)Nil$.MODULE$));
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(0)}))).times(1);
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)topics.apply(1)}))).times(1);
        EasyMock.expect((Object)this.clientManager().topicConfigSyncRules()).andReturn((Object)this.topicConfigSyncRules()).times(2);
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        KafkaFutureImpl config1 = new KafkaFutureImpl();
        config1.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        KafkaFutureImpl config2 = new KafkaFutureImpl();
        config2.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("retention.ms", "1000000"), (List)Nil$.MODULE$)).asJavaCollection()));
        List resources = (List)topics.map((Function1 & Serializable & scala.Serializable)topic -> this.newConfigResource((String)topic), List$.MODULE$.canBuildFrom());
        Set<Object> describeConfigsArg1 = Collections.singleton(resources.apply(0));
        Set<Object> describeConfigsArg2 = Collections.singleton(resources.apply(1));
        DescribeConfigsResult describeConfigsResult1 = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resources.apply(0)), (Object)config1)}))).asJava()));
        DescribeConfigsResult describeConfigsResult2 = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(resources.apply(1)), (Object)config2)}))).asJava()));
        EasyMock.expect((Object)this.admin().describeConfigs((Collection)EasyMock.eq(describeConfigsArg1))).andReturn((Object)describeConfigsResult1).times(1);
        EasyMock.expect((Object)this.admin().describeConfigs((Collection)EasyMock.eq(describeConfigsArg2))).andReturn((Object)describeConfigsResult2).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        Properties curProps1 = new Properties();
        curProps1.put("cleanup.policy", "compact");
        Properties curProps2 = new Properties();
        curProps2.put("retention.ms", "1000000");
        EasyMock.expect((Object)this.adminZkClient().fetchEntityConfig((String)EasyMock.eq((Object)ConfigType$.MODULE$.Topic()), (String)EasyMock.eq((Object)topics.apply(0)))).andReturn((Object)curProps1).times(1);
        EasyMock.expect((Object)this.adminZkClient().fetchEntityConfig((String)EasyMock.eq((Object)ConfigType$.MODULE$.Topic()), (String)EasyMock.eq((Object)topics.apply(1)))).andReturn((Object)curProps2).times(1);
        EasyMock.replay((Object[])new Object[]{this.adminZkClient()});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
    }

    @Test
    public void testClusterLinkAlterConfigPolicy() {
        scala.collection.immutable.Map oldConfigs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"preallocate"), (Object)"true")}));
        scala.collection.immutable.Map newConfigs = Predef$.MODULE$.Map().empty();
        ClusterLinkAlterConfigPolicy policy = (ClusterLinkAlterConfigPolicy)EasyMock.mock(ClusterLinkAlterConfigPolicy.class);
        EasyMock.expect((Object)policy.clusterLinkRestrictTopicConfigs((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)oldConfigs).asJava()))).andReturn(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)newConfigs).asJava()).times(1);
        policy.clusterLinkValidateTopicConfigs((java.util.Map)EasyMock.eq((Object)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)newConfigs).asJava()));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{policy});
        this.setupMock((Option<AlterConfigPolicy>)new Some((Object)policy), (Option<String>)new Some((Object)"tenant_"));
        String topic = "test-topic";
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).times(1);
        EasyMock.expect((Object)this.clientManager().topicConfigSyncRules()).andReturn((Object)this.topicConfigSyncRules()).times(1);
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("preallocate", "true"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = this.newConfigResource(topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        EasyMock.expect((Object)this.admin().describeConfigs((Collection)EasyMock.eq(describeConfigsArg))).andReturn((Object)describeConfigsResult).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        Properties curProps = new Properties();
        curProps.put("preallocate", "true");
        EasyMock.expect((Object)this.adminZkClient().fetchEntityConfig((String)EasyMock.eq((Object)ConfigType$.MODULE$.Topic()), (String)EasyMock.eq((Object)topic))).andReturn((Object)curProps).times(1);
        Properties newProps = new Properties();
        this.adminZkClient().changeTopicConfig((String)EasyMock.eq((Object)topic), (Properties)EasyMock.eq((Object)newProps));
        EasyMock.expect((Object)BoxedUnit.UNIT).times(1);
        EasyMock.replay((Object[])new Object[]{this.adminZkClient()});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        EasyMock.verify((Object[])new Object[]{policy});
        this.verifyConfigMap(curProps, syncTopicsConfigs, this.verifyConfigMap$default$3());
    }

    @Test
    public void testAlterConfigPolicyViolation() {
        AlterConfigPolicy policy = new AlterConfigPolicy(null){

            public void configure(java.util.Map<String, ?> configs) {
            }

            public void close() {
            }

            public void validate(AlterConfigPolicy.RequestMetadata requestMetadata) {
                throw new PolicyViolationException("Violated!");
            }
        };
        this.setupMock((Option<AlterConfigPolicy>)new Some((Object)policy), this.setupMock$default$2());
        String topic = "test-topic";
        EasyMock.expect((Object)this.clientManager().getTopics()).andReturn((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).times(1);
        EasyMock.expect((Object)this.clientManager().topicConfigSyncRules()).andReturn((Object)this.topicConfigSyncRules()).times(1);
        EasyMock.replay((Object[])new Object[]{this.clientManager()});
        KafkaFutureImpl config = new KafkaFutureImpl();
        config.complete((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new ConfigEntry("cleanup.policy", "compact"), (List)Nil$.MODULE$)).asJavaCollection()));
        ConfigResource resource = this.newConfigResource(topic);
        Set<ConfigResource> describeConfigsArg = Collections.singleton(resource);
        DescribeConfigsResult describeConfigsResult = new DescribeConfigsResult(Collections.unmodifiableMap((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)resource), (Object)config)}))).asJava()));
        EasyMock.expect((Object)this.admin().describeConfigs((Collection)EasyMock.eq(describeConfigsArg))).andReturn((Object)describeConfigsResult).times(1);
        EasyMock.replay((Object[])new Object[]{this.admin()});
        Properties curProps = new Properties();
        EasyMock.expect((Object)this.adminZkClient().fetchEntityConfig((String)EasyMock.eq((Object)ConfigType$.MODULE$.Topic()), (String)EasyMock.eq((Object)topic))).andReturn((Object)curProps).times(1);
        EasyMock.replay((Object[])new Object[]{this.adminZkClient()});
        ClusterLinkSyncTopicsConfigs syncTopicsConfigs = this.newClusterLinkSyncTopicsConfigs();
        syncTopicsConfigs.runOnce().get(5L, TimeUnit.SECONDS);
        this.verifyMock();
        this.verifyConfigMap(curProps, syncTopicsConfigs, this.verifyConfigMap$default$3());
    }

    private void verifyConfigMap(Properties props, ClusterLinkSyncTopicsConfigs syncTopicsConfigs, String topic) {
        scala.collection.mutable.Map actualConfigMap = syncTopicsConfigs.currentConfigMap();
        if (!props.isEmpty()) {
            HashSet expectedConfigs = (HashSet)HashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
            props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> expectedConfigs.add((Object)new ConfigEntry((String)k, (String)v))));
            Assertions.assertEquals((Object)new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)expectedConfigs).asJavaCollection()), (Object)((Option)actualConfigMap.apply((Object)topic)).get());
            return;
        }
        Assertions.assertEquals((Object)None$.MODULE$, (Object)actualConfigMap.apply((Object)topic));
    }

    private String verifyConfigMap$default$3() {
        return "test-topic";
    }

    private ConfigResource newConfigResource(String topic) {
        return new ConfigResource(ConfigResource.Type.TOPIC, topic);
    }

    private ClusterLinkSyncTopicsConfigs newClusterLinkSyncTopicsConfigs() {
        return new ClusterLinkSyncTopicsConfigs(this.clientManager(), 100, this.metrics());
    }

    private void setupMock(Option<AlterConfigPolicy> alterConfigPolicy, Option<String> tenantPrefix) {
        EasyMock.reset((Object[])new Object[]{this.admin()});
        EasyMock.reset((Object[])new Object[]{this.adminZkClient()});
        EasyMock.reset((Object[])new Object[]{this.clientManager()});
        EasyMock.expect((Object)this.clientManager().scheduler()).andReturn((Object)this.scheduler()).anyTimes();
        EasyMock.expect((Object)this.clientManager().getAdmin()).andReturn((Object)this.admin()).anyTimes();
        EasyMock.expect((Object)this.clientManager().zkClient()).andReturn((Object)this.zkClient()).anyTimes();
        EasyMock.expect((Object)this.clientManager().adminZkClient()).andReturn((Object)this.adminZkClient()).anyTimes();
        EasyMock.expect((Object)this.clientManager().alterConfigPolicy()).andReturn(alterConfigPolicy).anyTimes();
        EasyMock.expect((Object)this.clientManager().linkData()).andReturn((Object)new ClusterLinkData("link-name", UUID.randomUUID(), (Option)None$.MODULE$, tenantPrefix, false)).anyTimes();
    }

    private Option<AlterConfigPolicy> setupMock$default$1() {
        return None$.MODULE$;
    }

    private Option<String> setupMock$default$2() {
        return None$.MODULE$;
    }

    private void verifyMock() {
        EasyMock.verify((Object[])new Object[]{this.clientManager()});
        EasyMock.verify((Object[])new Object[]{this.admin()});
        EasyMock.verify((Object[])new Object[]{this.adminZkClient()});
    }
}

