/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.log.LogConfig$;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkFilter;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.server.link.MirrorTopicConfigsDelegate;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.resource.PatternType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001B\r\u001b\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%Bq\u0001\f\u0001C\u0002\u0013\u0005Q\u0006\u0003\u00042\u0001\u0001\u0006IA\f\u0005\be\u0001\u0011\r\u0011\"\u00014\u0011\u00199\u0004\u0001)A\u0005i!)\u0001\b\u0001C\u0001s!)!\n\u0001C\u0001s!)A\n\u0001C\u0001s!)a\n\u0001C\u0001s!)\u0001\u000b\u0001C\u0001s!)!\u000b\u0001C\u0001s!)A\u000b\u0001C\u0001s!)a\u000b\u0001C\u0001s!)\u0001\f\u0001C\u0001s!)!\f\u0001C\u0001s!)A\f\u0001C\u0001s!)a\f\u0001C\u0001s!)\u0001\r\u0001C\u0001s!)!\r\u0001C\u0001s!)A\r\u0001C\u0001s!)a\r\u0001C\u0001s!)\u0001\u000e\u0001C\u0005S\"9\u00111\u0005\u0001\u0005\n\u0005\u0015\u0002bBA!\u0001\u0011%\u00111\t\u0002\u0015\u00072,8\u000f^3s\u0019&t7.\u0016;jYN$Vm\u001d;\u000b\u0005ma\u0012\u0001\u00027j].T!!\b\u0010\u0002\rM,'O^3s\u0015\u0005y\u0012!B6bM.\f7\u0001A\n\u0003\u0001\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001+!\tY\u0003!D\u0001\u001b\u0003)a\u0017N\\6D_:4\u0017nZ\u000b\u0002]A\u00111fL\u0005\u0003ai\u0011\u0011c\u00117vgR,'\u000fT5oW\u000e{gNZ5h\u0003-a\u0017N\\6D_:4\u0017n\u001a\u0011\u0002)Q|\u0007/[2D_:4\u0017nZ*z]\u000e\u0014V\u000f\\3t+\u0005!\u0004CA\u00166\u0013\t1$D\u0001\u000eNSJ\u0014xN\u001d+pa&\u001c7i\u001c8gS\u001e\u001c\u0016P\\2Sk2,7/A\u000bu_BL7mQ8oM&<7+\u001f8d%VdWm\u001d\u0011\u0002%Q,7\u000f\u001e,bY&$G*\u001b8l\u001d\u0006lWm\u001d\u000b\u0002uA\u00111eO\u0005\u0003y\u0011\u0012A!\u00168ji\"\u0012aA\u0010\t\u0003\u007f!k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b1!\u00199j\u0015\t\u0019E)A\u0004kkBLG/\u001a:\u000b\u0005\u00153\u0015!\u00026v]&$(\"A$\u0002\u0007=\u0014x-\u0003\u0002J\u0001\n!A+Z:u\u0003Q!Xm\u001d;J]Z\fG.\u001b3MS:\\g*Y7fg\"\u0012qAP\u0001\u0018i\u0016\u001cHOV1mS\u0012\fG/Z'jeJ|'\u000f\u0015:paND#\u0001\u0003 \u00029Q,7\u000f\u001e,bY&$\u0017\r^3NSJ\u0014xN\u001d)s_B\u001cX)\u001c9us\"\u0012\u0011BP\u0001\u001fi\u0016\u001cHOV1mS\u0012\fG/Z%om\u0006d\u0017\u000eZ'jeJ|'\u000f\u0015:paND#A\u0003 \u0002KQ,7\u000f\u001e,bY&$\u0017\r^3J]Z\fG.\u001b3NSJ\u0014xN\u001d)s_B\u001c8+\u001f8p]fl\u0007FA\u0006?\u0003M!Xm\u001d;J]&$X*\u001b:s_J\u0004&o\u001c9tQ\taa(\u0001\u0010uKN$\u0018J\\5u\u001b&\u0014(o\u001c:Qe>\u00048\u000fT8dC2\fEn^1zg\"\u0012QBP\u0001(i\u0016\u001cH/\u00138ji6K'O]8s!J|\u0007o]+oW:|wO\\\"p]\u001aLw-S4o_J,G\r\u000b\u0002\u000f}\u0005)B/Z:u+B$\u0017\r^3NSJ\u0014xN\u001d)s_B\u001c\bFA\b?\u0003%\"Xm\u001d;Va\u0012\fG/Z'jeJ|'\u000f\u0015:paN,fn\u001b8po:\u001cuN\u001c4jO&;gn\u001c:fI\"\u0012\u0001CP\u0001\u001fi\u0016\u001cHOU3t_24Xm\u0011:fCR,Gk\u001c9jGN#\u0018M\u001c3be\u0012D#!\u0005 \u00029Q,7\u000f\u001e*fg>dg/Z\"sK\u0006$X-T5se>\u0014Hk\u001c9jG\"\u0012!CP\u0001#i\u0016\u001cHOU3t_24Xm\u0011:fCR,W*\u001b:s_J$v\u000e]5d\u000bJ\u0014xN]:)\u0005Mq\u0014\u0001\b;fgR4\u0016\r\\5eCR,7I]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0003)y\n!\u0002^3ti\u001aKG\u000e^3sQ\t)b(\u0001\u0006nC.,7i\u001c8gS\u001e$\"A[;\u0011\u0005-\u001cX\"\u00017\u000b\u00055t\u0017!B1e[&t'BA8q\u0003\u001d\u0019G.[3oiNT!aH9\u000b\u0005I4\u0015AB1qC\u000eDW-\u0003\u0002uY\n11i\u001c8gS\u001eDQA\u001e\fA\u0002]\fq!\u001a8ue&,7\u000fE\u0003y\u0003\u0003\t9A\u0004\u0002z}:\u0011!0`\u0007\u0002w*\u0011A\u0010I\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015J!a \u0013\u0002\u000fA\f7m[1hK&!\u00111AA\u0003\u0005\r\u0019V-\u001d\u0006\u0003\u007f\u0012\u0002\u0012bIA\u0005\u0003\u001b\ti!!\b\n\u0007\u0005-AE\u0001\u0004UkBdWm\r\t\u0005\u0003\u001f\t9B\u0004\u0003\u0002\u0012\u0005M\u0001C\u0001>%\u0013\r\t)\u0002J\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00111\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005UA\u0005E\u0002$\u0003?I1!!\t%\u0005\u001d\u0011un\u001c7fC:\fa\"\\1lKB\u0013x\u000e]3si&,7\u000f\u0006\u0003\u0002(\u0005]\u0002\u0003BA\u0015\u0003gi!!a\u000b\u000b\t\u00055\u0012qF\u0001\u0005kRLGN\u0003\u0002\u00022\u0005!!.\u0019<b\u0013\u0011\t)$a\u000b\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0003\u0004w/\u0001\u0007\u0011\u0011\b\t\u0006q\u0006\u0005\u00111\b\t\bG\u0005u\u0012QBA\u0007\u0013\r\ty\u0004\n\u0002\u0007)V\u0004H.\u001a\u001a\u0002%5\f7.Z\"sK\u0006$\u0018M\u00197f)>\u0004\u0018n\u0019\u000b\u000b\u0003\u000b\ni&!\u0019\u0002l\u0005U\u0004\u0003BA$\u0003/rA!!\u0013\u0002T5\u0011\u00111\n\u0006\u0005\u0003\u001b\ny%A\u0004nKN\u001c\u0018mZ3\u000b\u0007\u0005E\u0003/\u0001\u0004d_6lwN\\\u0005\u0005\u0003+\nY%A\fDe\u0016\fG/\u001a+pa&\u001c7OU3rk\u0016\u001cH\u000fR1uC&!\u0011\u0011LA.\u00059\u0019%/Z1uC\ndW\rV8qS\u000eTA!!\u0016\u0002L!9\u0011q\f\rA\u0002\u00055\u0011\u0001\u00028b[\u0016Dq!a\u0019\u0019\u0001\u0004\t)'A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\t\u0004G\u0005\u001d\u0014bAA5I\t\u0019\u0011J\u001c;\t\u000f\u00055\u0004\u00041\u0001\u0002p\u0005AA.\u001b8l\u001d\u0006lW\rE\u0003$\u0003c\ni!C\u0002\u0002t\u0011\u0012aa\u00149uS>t\u0007bBA<1\u0001\u0007\u0011qN\u0001\f[&\u0014(o\u001c:U_BL7\r")
public class ClusterLinkUtilsTest {
    private final ClusterLinkConfig linkConfig = ClusterLinkConfig$.MODULE$.create((Map)new Properties(null){
        {
            this.put("bootstrap.servers", "localhost:2345");
        }
    });
    private final MirrorTopicConfigSyncRules topicConfigSyncRules = this.linkConfig().topicConfigSyncRules();

    public ClusterLinkConfig linkConfig() {
        return this.linkConfig;
    }

    public MirrorTopicConfigSyncRules topicConfigSyncRules() {
        return this.topicConfigSyncRules;
    }

    @Test
    public void testValidLinkNames() {
        ClusterLinkUtilsTest.assertValid$1("ABCXYZ.abcxyz-0123456789_");
        ClusterLinkUtilsTest.assertValid$1("...");
        ClusterLinkUtilsTest.assertValid$1("_.-");
        ClusterLinkUtilsTest.assertValid$1(new StringOps(Predef$.MODULE$.augmentString("0123456789")).$times(20));
    }

    @Test
    public void testInvalidLinkNames() {
        ClusterLinkUtilsTest.assertInvalid$1(null);
        ClusterLinkUtilsTest.assertInvalid$1("");
        ClusterLinkUtilsTest.assertInvalid$1(".");
        ClusterLinkUtilsTest.assertInvalid$1("..");
        ClusterLinkUtilsTest.assertInvalid$1("test/link");
        ClusterLinkUtilsTest.assertInvalid$1("test:link");
        ClusterLinkUtilsTest.assertInvalid$1("test\\link");
        ClusterLinkUtilsTest.assertInvalid$1("test\nlink");
        ClusterLinkUtilsTest.assertInvalid$1("test\tlink");
        ClusterLinkUtilsTest.assertInvalid$1(new StringOps(Predef$.MODULE$.augmentString("0123456789")).$times(30));
    }

    @Test
    public void testValidateMirrorProps() {
        Properties props = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageDownConversionEnableProp()), (Object)"true"), (List)Nil$.MODULE$));
        this.topicConfigSyncRules().validateMirrorPropsForTopicCreation("test", props);
    }

    @Test
    public void testValidateMirrorPropsEmpty() {
        this.topicConfigSyncRules().validateMirrorPropsForTopicCreation("test", new Properties());
    }

    @Test
    public void testValidateInvalidMirrorProps() {
        Properties props = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"compact"), (List)Nil$.MODULE$));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.topicConfigSyncRules().validateMirrorPropsForTopicCreation("test", props));
    }

    @Test
    public void testValidateInvalidMirrorPropsSynonym() {
        Properties props = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanupPolicyProp()), (Object)"compact"), (List)Nil$.MODULE$));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> this.topicConfigSyncRules().validateMirrorPropsForTopicCreation("test", props));
    }

    @Test
    public void testInitMirrorProps() {
        Config remoteConfig = this.makeConfig((Seq<Tuple3<String, String, Object>>)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.CleanupPolicyProp(), (Object)"compact", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)"10485760", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), (Object)"true", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.PreferTierFetchMsProp(), (Object)"100000", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.SegmentMsProp(), (Object)"100000", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.SegmentBytesProp(), (Object)"1048576", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$)))))));
        Properties localProps = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageDownConversionEnableProp()), (Object)"true"), (List)Nil$.MODULE$));
        Properties newLocalProps = new MirrorTopicConfigsDelegate(localProps, remoteConfig, this.topicConfigSyncRules()).initMirrorProps("test");
        Assertions.assertEquals((Object)this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageDownConversionEnableProp()), (Object)"true"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"compact"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)"10485760"), (List)Nil$.MODULE$)))), (Object)newLocalProps);
    }

    @Test
    public void testInitMirrorPropsLocalAlways() {
        Properties localProps = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"compact"), (List)Nil$.MODULE$));
        Assertions.assertThrows(InvalidConfigurationException.class, () -> new MirrorTopicConfigsDelegate(localProps, this.makeConfig((Seq<Tuple3<String, String, Object>>)Nil$.MODULE$), this.topicConfigSyncRules()).initMirrorProps("test"));
    }

    @Test
    public void testInitMirrorPropsUnknownConfigIgnored() {
        Config remoteConfig = this.makeConfig((Seq<Tuple3<String, String, Object>>)new .colon.colon((Object)new Tuple3((Object)"bad.config.key", (Object)"12345", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$));
        Properties localProps = new Properties();
        Assertions.assertTrue((boolean)new MirrorTopicConfigsDelegate(localProps, remoteConfig, this.topicConfigSyncRules()).initMirrorProps("test").isEmpty());
    }

    @Test
    public void testUpdateMirrorProps() {
        Config remoteConfig = this.makeConfig((Seq<Tuple3<String, String, Object>>)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.CleanupPolicyProp(), (Object)"compact", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)"10485760", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), (Object)"true", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.PreferTierFetchMsProp(), (Object)"100000", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.SegmentMsProp(), (Object)"100000", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.SegmentBytesProp(), (Object)"1048576", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)Nil$.MODULE$)))))));
        Properties localProps = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"delete"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)"524288"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageDownConversionEnableProp()), (Object)"true"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)"false"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentMsProp()), (Object)"200000"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentBytesProp()), (Object)"1048576"), (List)Nil$.MODULE$)))))));
        Properties expectedLocalProps = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"compact"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)"10485760"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.MessageDownConversionEnableProp()), (Object)"true"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)"false"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentMsProp()), (Object)"200000"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.SegmentBytesProp()), (Object)"1048576"), (List)Nil$.MODULE$)))))));
        Properties newLocalProps = new MirrorTopicConfigsDelegate(localProps, remoteConfig, this.topicConfigSyncRules()).updateMirrorProps("test");
        Assertions.assertEquals((Object)expectedLocalProps, (Object)newLocalProps);
    }

    @Test
    public void testUpdateMirrorPropsUnknownConfigIgnored() {
        Config remoteConfig = this.makeConfig((Seq<Tuple3<String, String, Object>>)new .colon.colon((Object)new Tuple3((Object)"bad.config.key", (Object)"12345", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$));
        Properties localProps = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"another.bad.config.key"), (Object)"23456"), (List)Nil$.MODULE$));
        Assertions.assertTrue((boolean)new MirrorTopicConfigsDelegate(localProps, remoteConfig, this.topicConfigSyncRules()).updateMirrorProps("test").isEmpty());
    }

    @Test
    public void testResolveCreateTopicStandard() {
        Properties configs = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)"true"), (List)Nil$.MODULE$));
        CreateTopicsRequestData.CreatableTopic topic = this.makeCreatableTopic("test-topic", 4, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        ClusterLinkUtils.ResolveCreateTopic result = ClusterLinkUtils$.MODULE$.resolveCreateTopic(topic, (Option)None$.MODULE$, configs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$);
        Assertions.assertEquals((Object)configs, (Object)result.configs());
        Assertions.assertTrue((boolean)result.topicState().isEmpty());
        Assertions.assertEquals((int)-1, (int)result.numPartitions());
    }

    @Test
    public void testResolveCreateMirrorTopic() {
        UUID linkId = UUID.randomUUID();
        Properties configs = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)"true"), (List)Nil$.MODULE$));
        Config remoteConfig = this.makeConfig((Seq<Tuple3<String, String, Object>>)new .colon.colon((Object)new Tuple3((Object)LogConfig$.MODULE$.CleanupPolicyProp(), (Object)"compact", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$));
        Properties expectedConfigs = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)"true"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"compact"), (List)Nil$.MODULE$)));
        ClusterLinkUtils.ResolveCreateTopic result1 = ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic("test-topic", -1, (Option<String>)new Some((Object)"link-name"), (Option<String>)new Some((Object)"test-topic")), (Option)new Some((Object)linkId), configs, true, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$);
        Assertions.assertEquals((Object)configs, (Object)result1.configs());
        Assertions.assertTrue((boolean)result1.topicState().isEmpty());
        Assertions.assertEquals((int)-1, (int)result1.numPartitions());
        Node node = new Node(0, "localhost", 9092);
        java.util.List nodeList = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)node, (List)Nil$.MODULE$)).asJava();
        .colon.colon partitionInfos = new .colon.colon((Object)new TopicPartitionInfo(0, node, nodeList, nodeList), (List)new .colon.colon((Object)new TopicPartitionInfo(1, node, nodeList, nodeList), (List)new .colon.colon((Object)new TopicPartitionInfo(2, node, nodeList, nodeList), (List)Nil$.MODULE$)));
        scala.collection.immutable.Set authorizedOperations = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ}));
        TopicDescription description = new TopicDescription("test-topic", false, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionInfos).asJava(), (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)authorizedOperations).asJava());
        CompletableFuture<ClusterLinkTopicInfo> future = new CompletableFuture<ClusterLinkTopicInfo>();
        future.complete(new ClusterLinkTopicInfo(description, remoteConfig));
        ClusterLinkUtils.ResolveCreateTopic result2 = ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic("test-topic", -1, (Option<String>)new Some((Object)"link-name"), (Option<String>)new Some((Object)"test-topic")), (Option)new Some((Object)linkId), configs, false, (Option)new Some((Object)this.linkConfig()), (Option)new Some(future));
        Assertions.assertEquals((Object)expectedConfigs, (Object)result2.configs());
        Assertions.assertTrue((boolean)(result2.topicState().get() instanceof ClusterLinkTopicState.Mirror));
        Assertions.assertEquals((Object)"link-name", (Object)((ClusterLinkTopicState)result2.topicState().get()).linkName());
        Assertions.assertEquals((int)3, (int)result2.numPartitions());
    }

    @Test
    public void testResolveCreateMirrorTopicErrors() {
        String topic = "test-topic";
        String linkName = "link-name";
        UUID linkId = UUID.randomUUID();
        Properties validConfigs = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.UncleanLeaderElectionEnableProp()), (Object)"true"), (List)Nil$.MODULE$));
        Properties invalidConfigs = this.makeProperties((Seq<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)LogConfig$.MODULE$.CleanupPolicyProp()), (Object)"compact"), (List)Nil$.MODULE$));
        Node node = new Node(0, "localhost", 9092);
        java.util.List nodeList = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)node, (List)Nil$.MODULE$)).asJava();
        .colon.colon partitionInfos = new .colon.colon((Object)new TopicPartitionInfo(0, node, nodeList, nodeList), (List)new .colon.colon((Object)new TopicPartitionInfo(1, node, nodeList, nodeList), (List)new .colon.colon((Object)new TopicPartitionInfo(2, node, nodeList, nodeList), (List)Nil$.MODULE$)));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)None$.MODULE$), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$), ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$), ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, 4, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$), ClassTag$.MODULE$.apply(InvalidRequestException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)"different-topic")), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$), ClassTag$.MODULE$.apply(UnsupportedVersionException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), invalidConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$), ClassTag$.MODULE$.apply(InvalidConfigurationException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> {
            CompletableFuture future = new CompletableFuture();
            return ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)new Some(future));
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 267));
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(new TimeoutException("timeout"));
            return ClusterLinkUtils$.MODULE$.resolveCreateTopic(this.makeCreatableTopic(topic, -1, (Option<String>)new Some((Object)linkName), (Option<String>)new Some((Object)topic)), (Option)new Some((Object)linkId), validConfigs, false, (Option)new Some((Object)this.linkConfig()), (Option)new Some(future));
        }, ClassTag$.MODULE$.apply(TimeoutException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        Assertions$.MODULE$.intercept(() -> ClusterLinkUtilsTest.$anonfun$testResolveCreateMirrorTopicErrors$9(this, (List)partitionInfos, topic, linkName, linkId, validConfigs), ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
        Assertions.assertEquals((Object)((ClusterLinkNotFoundException)Assertions$.MODULE$.intercept(() -> ClusterLinkUtilsTest.$anonfun$testResolveCreateMirrorTopicErrors$10(this, (List)partitionInfos, topic, linkName, validConfigs), ClassTag$.MODULE$.apply(ClusterLinkNotFoundException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288))).getMessage(), (Object)new StringBuilder(41).append("Cluster link with name '").append(linkName).append("' does not exist.").toString());
    }

    @Test
    public void testValidateCreatePartitions() {
        ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 3, true, (Option)None$.MODULE$);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 3, false, (Option)None$.MODULE$), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 2, false, (Option)new Some((Object)future)), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
        future.complete(BoxesRunTime.boxToInteger((int)3));
        ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 2, false, (Option)new Some(future));
        ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 3, false, (Option)new Some(future));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ClusterLinkUtils$.MODULE$.validateCreatePartitions("test-topic", 4, false, (Option)new Some((Object)future)), ClassTag$.MODULE$.apply(InvalidPartitionsException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 317));
    }

    @Test
    public void testFilter() {
        ClusterLinkFilterInfo fooLiteral = ClusterLinkUtilsTest.filterInfo$1("fooLiteral", PatternType.LITERAL, "include");
        ClusterLinkFilterInfo bar = ClusterLinkUtilsTest.filterInfo$1("bar", PatternType.PREFIXED, "include");
        ClusterLinkFilterInfo barExclude = ClusterLinkUtilsTest.filterInfo$1("barExclude", PatternType.PREFIXED, "exclude");
        ClusterLinkFilterInfo baz = ClusterLinkUtilsTest.filterInfo$1("baz", PatternType.PREFIXED, "include");
        ClusterLinkFilterInfo bazExclude = ClusterLinkUtilsTest.filterInfo$1("bazExclude", PatternType.LITERAL, "exclude");
        .colon.colon filters = new .colon.colon((Object)fooLiteral, (List)new .colon.colon((Object)bar, (List)new .colon.colon((Object)barExclude, (List)new .colon.colon((Object)baz, (List)new .colon.colon((Object)bazExclude, (List)Nil$.MODULE$)))));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1(Predef$.MODULE$.Set().empty(), (Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), (Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), (Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExcludeNot"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), (Seq)filters));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral, bar, barExclude})), (Object)((TraversableOnce)ClusterLinkUtils$.MODULE$.doFilter((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), (Seq)filters)._2()).toSet());
        Seq filters2 = (Seq)filters.$plus$plus((GenTraversableOnce)new .colon.colon((Object)ClusterLinkUtilsTest.filterInfo$1("*", PatternType.LITERAL, "include"), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1(Predef$.MODULE$.Set().empty(), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExcludeNot"})), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), filters2));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral, bar, barExclude})), (Object)((TraversableOnce)ClusterLinkUtils$.MODULE$.doFilter((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), filters2)._2()).toSet());
        Seq filters3 = (Seq)filters.$plus$plus((GenTraversableOnce)new .colon.colon((Object)ClusterLinkUtilsTest.filterInfo$1("*", PatternType.LITERAL, "exclude"), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1(Predef$.MODULE$.Set().empty(), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fooLiteral", "abc"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"bar", "barred", "barExclude", "barExcluded"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().empty(), (Object)ClusterLinkUtilsTest.filter$1((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"baz", "bazExclude", "bazExcludeNot"})), filters3));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ClusterLinkFilterInfo[]{fooLiteral, bar, barExclude})), (Object)((TraversableOnce)ClusterLinkUtils$.MODULE$.doFilter((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"abc", "baz", "bazExclude"})), filters3)._2()).toSet());
        Assertions.assertTrue((boolean)bar.matchesIncludeOrExclude("bar"));
        Assertions.assertTrue((boolean)bar.matchesIncludeOrExclude("barInclude"));
        Assertions.assertFalse((boolean)bar.matchesIncludeOrExclude("foo"));
        Assertions.assertTrue((boolean)barExclude.matchesIncludeOrExclude("barExclude"));
        Assertions.assertTrue((boolean)barExclude.matchesIncludeOrExclude("barExcluded"));
        Assertions.assertFalse((boolean)barExclude.matchesIncludeOrExclude("foo"));
    }

    private Config makeConfig(Seq<Tuple3<String, String, Object>> entries) {
        Seq configEntries = (Seq)entries.map((Function1 & Serializable & scala.Serializable)entry -> {
            ConfigEntry.ConfigSource source = BoxesRunTime.unboxToBoolean((Object)entry._3()) ? ConfigEntry.ConfigSource.DEFAULT_CONFIG : ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG;
            return new ConfigEntry((String)entry._1(), (String)entry._2(), source, false, false, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.empty()).asJava(), ConfigEntry.ConfigType.UNKNOWN, null);
        }, Seq$.MODULE$.canBuildFrom());
        return new Config(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)configEntries).asJavaCollection());
    }

    /*
     * WARNING - void declaration
     */
    private Properties makeProperties(Seq<Tuple2<String, String>> entries) {
        void var2_2;
        Properties props = new Properties();
        entries.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(name, value);
            return object;
        });
        return var2_2;
    }

    private CreateTopicsRequestData.CreatableTopic makeCreatableTopic(String name, int numPartitions, Option<String> linkName, Option<String> mirrorTopic) {
        return new CreateTopicsRequestData.CreatableTopic().setName(name).setNumPartitions(numPartitions).setReplicationFactor((short)3).setLinkName((String)linkName.orNull(Predef$.MODULE$.$conforms())).setMirrorTopic((String)mirrorTopic.orNull(Predef$.MODULE$.$conforms()));
    }

    private static final void assertValid$1(String linkName) {
        ClusterLinkUtils$.MODULE$.validateLinkName(linkName);
    }

    private static final void assertInvalid$1(String linkName) {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ClusterLinkUtils$.MODULE$.validateLinkName(linkName), ClassTag$.MODULE$.apply(InvalidClusterLinkException.class), new Position("ClusterLinkUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
    }

    public static final /* synthetic */ ClusterLinkUtils.ResolveCreateTopic $anonfun$testResolveCreateMirrorTopicErrors$9(ClusterLinkUtilsTest $this, List partitionInfos$1, String topic$1, String linkName$2, UUID linkId$1, Properties validConfigs$1) {
        TopicDescription description = new TopicDescription("test-topic", false, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionInfos$1).asJava());
        CompletableFuture<ClusterLinkTopicInfo> future = new CompletableFuture<ClusterLinkTopicInfo>();
        future.complete(new ClusterLinkTopicInfo(description, $this.makeConfig((Seq<Tuple3<String, String, Object>>)Nil$.MODULE$)));
        return ClusterLinkUtils$.MODULE$.resolveCreateTopic($this.makeCreatableTopic(topic$1, -1, (Option<String>)new Some((Object)linkName$2), (Option<String>)new Some((Object)topic$1)), (Option)new Some((Object)linkId$1), validConfigs$1, false, (Option)new Some((Object)$this.linkConfig()), (Option)new Some(future));
    }

    public static final /* synthetic */ ClusterLinkUtils.ResolveCreateTopic $anonfun$testResolveCreateMirrorTopicErrors$10(ClusterLinkUtilsTest $this, List partitionInfos$1, String topic$1, String linkName$2, Properties validConfigs$1) {
        scala.collection.immutable.Set authorizedOperations = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ}));
        TopicDescription description = new TopicDescription("test-topic", false, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionInfos$1).asJava(), (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)authorizedOperations).asJava());
        CompletableFuture<ClusterLinkTopicInfo> future = new CompletableFuture<ClusterLinkTopicInfo>();
        future.complete(new ClusterLinkTopicInfo(description, $this.makeConfig((Seq<Tuple3<String, String, Object>>)Nil$.MODULE$)));
        return ClusterLinkUtils$.MODULE$.resolveCreateTopic($this.makeCreatableTopic(topic$1, -1, (Option<String>)new Some((Object)linkName$2), (Option<String>)new Some((Object)topic$1)), (Option)None$.MODULE$, validConfigs$1, false, (Option)new Some((Object)$this.linkConfig()), (Option)new Some(future));
    }

    private static final ClusterLinkFilterInfo filterInfo$1(String name, PatternType patternType, String filterType) {
        return new ClusterLinkFilterInfo(name, patternType, filterType, new ClusterLinkFilter(name, patternType.name(), filterType));
    }

    private static final scala.collection.immutable.Set filter$1(scala.collection.immutable.Set items, Seq filters) {
        return (scala.collection.immutable.Set)ClusterLinkUtils$.MODULE$.doFilter(items, filters)._1();
    }
}

