/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\f\u0019\u0001uAQ\u0001\n\u0001\u0005\u0002\u0015Bq\u0001\u000b\u0001C\u0002\u0013%\u0011\u0006\u0003\u00046\u0001\u0001\u0006IA\u000b\u0005\bm\u0001\u0011\r\u0011\"\u00158\u0011\u0019q\u0004\u0001)A\u0005q!)q\b\u0001C!\u0001\")a\n\u0001C\u0001\u0001\")1\u000b\u0001C\u0001\u0001\")Q\u000b\u0001C\u0001\u0001\")q\u000b\u0001C\u0001\u0001\")\u0011\f\u0001C\u0001\u0001\")1\f\u0001C\u0001\u0001\")Q\f\u0001C\u0001\u0001\")q\f\u0001C\u0001\u0001\")\u0011\r\u0001C\u0001\u0001\")1\r\u0001C\u0005I\")!\u000e\u0001C\u0005W\"I\u00111\u0001\u0001\u0012\u0002\u0013%\u0011Q\u0001\u0005\b\u00037\u0001A\u0011BA\u000f\u0011%\tY\u0003AI\u0001\n\u0013\t)\u0001C\u0004\u0002.\u0001!I!a\f\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:\t)B+[3s\u0007>tg-[4ve\u0006$\u0018n\u001c8UKN$(BA\r\u001b\u0003\u0011!\u0018.\u001a:\u000b\u0003m\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001=A\u0011qDI\u0007\u0002A)\u0011\u0011EG\u0001\u0004CBL\u0017BA\u0012!\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001'!\t9\u0003!D\u0001\u0019\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012A\u000b\t\u0003WMj\u0011\u0001\f\u0006\u0003[9\naaY8n[>t'BA\u000e0\u0015\t\u0001\u0014'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002e\u0005\u0019qN]4\n\u0005Qb#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005A\u0004CA\u001d=\u001b\u0005Q$\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uR$aA%oi\u0006a!M]8lKJ\u001cu.\u001e8uA\u0005)1/\u001a;VaR\t\u0011\t\u0005\u0002:\u0005&\u00111I\u000f\u0002\u0005+:LG\u000f\u000b\u0002\u0007\u000bB\u0011a\tT\u0007\u0002\u000f*\u0011\u0011\u0005\u0013\u0006\u0003\u0013*\u000bqA[;qSR,'O\u0003\u0002Lc\u0005)!.\u001e8ji&\u0011Qj\u0012\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\r;fgR,e.\u00192mK\u000e{W\u000e]1di&|g.\u00114uKJ,e.\u00192mKRKWM]!u\u0005J|7.\u001a:MKZ,G\u000e\u000b\u0002\b!B\u0011a)U\u0005\u0003%\u001e\u0013A\u0001V3ti\u0006yC/Z:u\u000b:\f'\r\\3D_6\u0004\u0018m\u0019;j_:\fe\r^3s\u000b:\f'\r\\3US\u0016\u0014\u0018\t\u001e+pa&\u001cG*\u001a<fY\"\u0012\u0001\u0002U\u00015i\u0016\u001cHo\u0011:fCR,7i\\7qC\u000e$X\r\u001a+pa&\u001c\u0017I\u001a;fe\u0016s\u0017M\u00197f)&,'/\u0011;Ce>\\WM\u001d'fm\u0016d\u0007FA\u0005Q\u0003)\"Xm\u001d;F]\u0006\u0014G.\u001a+jKJ|enQ8na\u0006\u001cG/\u001a3U_BL7-S:O_R\fE\u000e\\8xK\u0012D#A\u0003)\u0002KQ,7\u000f\u001e#jg\u0006\u0014G.\u001a+jKJLgnZ,iK:\u001cV\r^!u)>\u0004\u0018n\u0019'fm\u0016d\u0007FA\u0006Q\u0003\u0019\"Xm\u001d;ESN\f'\r\\3US\u0016\u0014\u0018N\\4XQ\u0016t7+\u001a;Bi\n\u0013xn[3s\u0019\u00164X\r\u001c\u0015\u0003\u0019A\u000ba\u0007^3ti\u0016s\u0017M\u00197f\u0007>l\u0007/Y2uS>tw\u000b[3o)&,'OR3biV\u0014X-\u00128bE2,G-S:O_R\fE\u000e\\8xK\u0012D#!\u0004)\u0002yQ,7\u000f\u001e#jg\u0006\u0014G.\u001a+jKJ,Gm\u0015;pe\u0006<W-\u0011;Ce>\\WM\u001d'fm\u0016d\u0017I\u001a;fe\u0016s\u0017M\u00197j]\u001e\u001cF/\u0019;jG\u0006dG.\u001f\u0015\u0003\u001dA\u000bQ\b^3ti\u0012K7/\u00192mKRKWM]3e'R|'/Y4f\u0003R\u0014%o\\6fe2+g/\u001a7BMR,'/\u00128bE2Lgn\u001a#z]\u0006l\u0017nY1mYfD#a\u0004)\u0002KQ,7\u000f\u001e#jg\u0006\u0014G.\u001a+jKJ,Gm\u0015;pe\u0006<W-\u0011;Ce>\\WM\u001d'fm\u0016dGCA!f\u0011\u00151\u0007\u00031\u0001h\u0003QI7\u000fR=oC6L7-\u00197ms\u0016s\u0017M\u00197fIB\u0011\u0011\b[\u0005\u0003Sj\u0012qAQ8pY\u0016\fg.A\rhKR$\u0016.\u001a:F]\u0006\u0014G.\u001a\"s_.,'oQ8oM&<GC\u00017u!\ti'/D\u0001o\u0015\ty\u0007/A\u0003bI6LgN\u0003\u0002r]\u000591\r\\5f]R\u001c\u0018BA:o\u0005-\u0019uN\u001c4jO\u0016sGO]=\t\u000fU\f\u0002\u0013!a\u0001m\u0006QQM\u001c;jift\u0015-\\3\u0011\u0005]thB\u0001=}!\tI((D\u0001{\u0015\tYH$\u0001\u0004=e>|GOP\u0005\u0003{j\na\u0001\u0015:fI\u00164\u0017bA@\u0002\u0002\t11\u000b\u001e:j]\u001eT!! \u001e\u0002G\u001d,G\u000fV5fe\u0016s\u0017M\u00197f\u0005J|7.\u001a:D_:4\u0017n\u001a\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0001\u0016\u0004m\u0006%1FAA\u0006!\u0011\ti!a\u0006\u000e\u0005\u0005=!\u0002BA\t\u0003'\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005U!(\u0001\u0006b]:|G/\u0019;j_:LA!!\u0007\u0002\u0010\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00027\u0005dG/\u001a:US\u0016\u0014XI\\1cY\u0016\u0014%o\\6fe\u000e{gNZ5h)\u0019\ty\"!\n\u0002*A\u0019Q.!\t\n\u0007\u0005\rbN\u0001\nBYR,'oQ8oM&<7OU3tk2$\bBBA\u0014'\u0001\u0007a/A\u0005qe>\u0004h+\u00197vK\"9Qo\u0005I\u0001\u0002\u00041\u0018!J1mi\u0016\u0014H+[3s\u000b:\f'\r\\3Ce>\\WM]\"p]\u001aLw\r\n3fM\u0006,H\u000e\u001e\u00133\u0003A\tG\u000e^3s)>\u0004\u0018nY\"p]\u001aLw\r\u0006\u0004\u0002 \u0005E\u0012Q\u0007\u0005\u0007\u0003g)\u0002\u0019\u0001<\u0002\u000fA\u0014x\u000e]&fs\"1\u0011qE\u000bA\u0002Y\fQ\"Y:tKJ$\u0018J\u001c<bY&$GcA!\u0002<!9\u0011Q\b\fA\u0002\u0005}\u0011A\u0002:fgVdG\u000f")
public class TierConfigurationTest
extends IntegrationTestHarness {
    private final TopicPartition topicPartition;
    private final int brokerCount;

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    @BeforeEach
    public void setUp() {
    }

    @Test
    public void testEnableCompactionAfterEnableTierAtBrokerLevel() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        super.setUp();
        String x$1 = this.topicPartition().topic();
        int x$2 = 2;
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        this.createTopic(x$1, x$3, x$2, x$4);
        this.assertInvalid(this.alterTopicConfig(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            TierConfigurationTest.$anonfun$testEnableCompactionAfterEnableTierAtBrokerLevel$1(this, server);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testEnableCompactionAfterEnableTierAtTopicLevel() {
        super.setUp();
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.TierEnableProp(), "true");
        String x$1 = this.topicPartition().topic();
        int x$3 = 2;
        int x$4 = this.createTopic$default$2();
        this.createTopic(x$1, x$4, x$3, topicConfig);
        this.assertInvalid(this.alterTopicConfig(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            TierConfigurationTest.$anonfun$testEnableCompactionAfterEnableTierAtTopicLevel$1(this, server);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreateCompactedTopicAfterEnableTierAtBrokerLevel() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        super.setUp();
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        String x$1 = this.topicPartition().topic();
        int x$3 = 2;
        int x$4 = this.createTopic$default$2();
        this.createTopic(x$1, x$4, x$3, topicConfig);
        this.alterTopicConfig(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()).all().get(5L, TimeUnit.SECONDS);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            TierConfigurationTest.$anonfun$testCreateCompactedTopicAfterEnableTierAtBrokerLevel$1(this, server);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testEnableTierOnCompactedTopicIsNotAllowed() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        super.setUp();
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        String x$1 = this.topicPartition().topic();
        int x$3 = 2;
        int x$4 = this.createTopic$default$2();
        this.createTopic(x$1, x$4, x$3, topicConfig);
        this.alterTopicConfig(LogConfig$.MODULE$.TierEnableProp(), "true").all().get(5L, TimeUnit.SECONDS);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            TierConfigurationTest.$anonfun$testEnableTierOnCompactedTopicIsNotAllowed$1(this, server);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDisableTieringWhenSetAtTopicLevel() {
        super.setUp();
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.TierEnableProp(), "true");
        String x$1 = this.topicPartition().topic();
        int x$3 = 2;
        int x$4 = this.createTopic$default$2();
        this.createTopic(x$1, x$4, x$3, topicConfig);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtTopicLevel$1(this, server);
            return BoxedUnit.UNIT;
        });
        this.alterTopicConfig(LogConfig$.MODULE$.TierEnableProp(), "false").all().get(5L, TimeUnit.SECONDS);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtTopicLevel$2(this, server);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDisableTieringWhenSetAtBrokerLevel() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        super.setUp();
        String x$1 = this.topicPartition().topic();
        int x$2 = 2;
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        this.createTopic(x$1, x$3, x$2, x$4);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtBrokerLevel$1(this, server);
            return BoxedUnit.UNIT;
        });
        this.alterTopicConfig(LogConfig$.MODULE$.TierEnableProp(), "false").all().get(5L, TimeUnit.SECONDS);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtBrokerLevel$2(this, server);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testEnableCompactionWhenTierFeatureEnabledIsNotAllowed() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        super.setUp();
        this.createTopic(this.topicPartition().topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        this.assertInvalid(this.alterTopicConfig(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()));
    }

    @Test
    public void testDisableTieredStorageAtBrokerLevelAfterEnablingStatically() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        super.setUp();
        this.testDisableTieredStorageAtBrokerLevel(false);
    }

    @Test
    public void testDisableTieredStorageAtBrokerLevelAfterEnablingDynamically() {
        super.setUp();
        this.alterTierEnableBrokerConfig("true", this.alterTierEnableBrokerConfig$default$2()).all().get(5L, TimeUnit.SECONDS);
        this.testDisableTieredStorageAtBrokerLevel(true);
    }

    private void testDisableTieredStorageAtBrokerLevel(boolean isDynamicallyEnabled) {
        String x$1 = this.topicPartition().topic();
        int x$2 = 2;
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        this.createTopic(x$1, x$3, x$2, x$4);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$1(this, server);
            return BoxedUnit.UNIT;
        });
        int brokerToUpdate = ((KafkaServer)this.servers().head()).config().brokerId();
        this.alterTierEnableBrokerConfig("false", Integer.toString(brokerToUpdate)).all().get(5L, TimeUnit.SECONDS);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$4(this, brokerToUpdate, isDynamicallyEnabled, server);
            return BoxedUnit.UNIT;
        });
        this.alterTierEnableBrokerConfig("false", this.alterTierEnableBrokerConfig$default$2()).all().get(5L, TimeUnit.SECONDS);
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$7(this, server);
            return BoxedUnit.UNIT;
        });
        ConfigEntry tierEnableConfig = this.getTierEnableBrokerConfig(this.getTierEnableBrokerConfig$default$1());
        Assertions.assertFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(tierEnableConfig.value())).toBoolean());
        Assertions.assertEquals((Object)ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, (Object)tierEnableConfig.source());
    }

    private ConfigEntry getTierEnableBrokerConfig(String entityName) {
        ConfigEntry configEntry;
        try (ConfluentAdmin adminClient = this.createAdminClient(this.createAdminClient$default$1());){
            ConfigResource brokerConfigResource = new ConfigResource(ConfigResource.Type.BROKER, entityName.toString());
            configEntry = ((Config)((Map)adminClient.describeConfigs(Collections.singleton(brokerConfigResource)).all().get()).get(brokerConfigResource)).get(KafkaConfig$.MODULE$.TierEnableProp());
        }
        return configEntry;
    }

    private String getTierEnableBrokerConfig$default$1() {
        return "";
    }

    private AlterConfigsResult alterTierEnableBrokerConfig(String propValue, String entityName) {
        AlterConfigsResult alterConfigsResult;
        AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry(KafkaConfig$.MODULE$.TierEnableProp(), propValue), AlterConfigOp.OpType.SET);
        Map<ConfigResource, Set<AlterConfigOp>> toSetOnBroker = Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, entityName), Collections.singleton(alterConfigOp));
        try (ConfluentAdmin adminClient = this.createAdminClient(this.createAdminClient$default$1());){
            alterConfigsResult = adminClient.incrementalAlterConfigs(toSetOnBroker);
        }
        return alterConfigsResult;
    }

    private String alterTierEnableBrokerConfig$default$2() {
        return "";
    }

    private AlterConfigsResult alterTopicConfig(String propKey, String propValue) {
        AlterConfigsResult alterConfigsResult;
        AlterConfigOp alterConfigOp = new AlterConfigOp(new ConfigEntry(propKey, propValue), AlterConfigOp.OpType.SET);
        HashMap<ConfigResource, List<AlterConfigOp>> configs = new HashMap<ConfigResource, List<AlterConfigOp>>();
        configs.put(new ConfigResource(ConfigResource.Type.TOPIC, this.topicPartition().topic()), Collections.singletonList(alterConfigOp));
        try (ConfluentAdmin adminClient = this.createAdminClient(this.createAdminClient$default$1());){
            alterConfigsResult = adminClient.incrementalAlterConfigs(configs);
        }
        return alterConfigsResult;
    }

    private void assertInvalid(AlterConfigsResult result) {
        ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> result.all().get());
        Assertions.assertEquals(InvalidConfigurationException.class, exception.getCause().getClass());
    }

    public static final /* synthetic */ void $anonfun$testEnableCompactionAfterEnableTierAtBrokerLevel$1(TierConfigurationTest $this, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        TopicPartition x$5 = $this.topicPartition();
        boolean x$6 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$1.getLog(x$5, x$6).get()).tierPartitionState().isTieringEnabled());
    }

    public static final /* synthetic */ void $anonfun$testEnableCompactionAfterEnableTierAtTopicLevel$1(TierConfigurationTest $this, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        TopicPartition x$5 = $this.topicPartition();
        boolean x$6 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$1.getLog(x$5, x$6).get()).tierPartitionState().isTieringEnabled());
    }

    public static final /* synthetic */ void $anonfun$testCreateCompactedTopicAfterEnableTierAtBrokerLevel$1(TierConfigurationTest $this, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        TopicPartition x$5 = $this.topicPartition();
        boolean x$6 = qual$1.getLog$default$2();
        Assertions.assertFalse((boolean)((AbstractLog)qual$1.getLog(x$5, x$6).get()).tierPartitionState().isTieringEnabled());
    }

    public static final /* synthetic */ boolean $anonfun$testEnableTierOnCompactedTopicIsNotAllowed$2(TierConfigurationTest $this, KafkaServer server$1) {
        boolean x$6;
        TopicPartition x$5;
        LogManager qual$1 = server$1.logManager();
        return !((AbstractLog)qual$1.getLog(x$5 = $this.topicPartition(), x$6 = qual$1.getLog$default$2()).get()).tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testEnableTierOnCompactedTopicIsNotAllowed$3() {
        return "Timed out waiting for tiered storage to be disabled";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testEnableTierOnCompactedTopicIsNotAllowed$1(TierConfigurationTest $this, KafkaServer server) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 5000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierConfigurationTest.$anonfun$testEnableTierOnCompactedTopicIsNotAllowed$2($this, server)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierConfigurationTest.$anonfun$testEnableTierOnCompactedTopicIsNotAllowed$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$testDisableTieringWhenSetAtTopicLevel$1(TierConfigurationTest $this, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        TopicPartition x$5 = $this.topicPartition();
        boolean x$6 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$1.getLog(x$5, x$6).get()).tierPartitionState().isTieringEnabled());
    }

    public static final /* synthetic */ boolean $anonfun$testDisableTieringWhenSetAtTopicLevel$3(TierConfigurationTest $this, KafkaServer server$2) {
        boolean x$8;
        TopicPartition x$7;
        LogManager qual$2 = server$2.logManager();
        return !((AbstractLog)qual$2.getLog(x$7 = $this.topicPartition(), x$8 = qual$2.getLog$default$2()).get()).tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDisableTieringWhenSetAtTopicLevel$4() {
        return "Timed out waiting for tiered storage to be disabled";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDisableTieringWhenSetAtTopicLevel$2(TierConfigurationTest $this, KafkaServer server) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 5000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtTopicLevel$3($this, server)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtTopicLevel$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$testDisableTieringWhenSetAtBrokerLevel$1(TierConfigurationTest $this, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        TopicPartition x$5 = $this.topicPartition();
        boolean x$6 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$1.getLog(x$5, x$6).get()).tierPartitionState().isTieringEnabled());
    }

    public static final /* synthetic */ boolean $anonfun$testDisableTieringWhenSetAtBrokerLevel$3(TierConfigurationTest $this, KafkaServer server$3) {
        boolean x$8;
        TopicPartition x$7;
        LogManager qual$2 = server$3.logManager();
        return !((AbstractLog)qual$2.getLog(x$7 = $this.topicPartition(), x$8 = qual$2.getLog$default$2()).get()).tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDisableTieringWhenSetAtBrokerLevel$4() {
        return "Timed out waiting for tiered storage to be disabled";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDisableTieringWhenSetAtBrokerLevel$2(TierConfigurationTest $this, KafkaServer server) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 5000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtBrokerLevel$3($this, server)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierConfigurationTest.$anonfun$testDisableTieringWhenSetAtBrokerLevel$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDisableTieredStorageAtBrokerLevel$2(TierConfigurationTest $this, KafkaServer server$4) {
        LogManager qual$1 = server$4.logManager();
        TopicPartition x$5 = $this.topicPartition();
        boolean x$6 = qual$1.getLog$default$2();
        return ((AbstractLog)qual$1.getLog(x$5, x$6).get()).tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDisableTieredStorageAtBrokerLevel$3() {
        return "TierPartitionState#tieringEnabled flag set to false";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDisableTieredStorageAtBrokerLevel$1(TierConfigurationTest $this, KafkaServer server) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 5000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$2($this, server)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDisableTieredStorageAtBrokerLevel$5(TierConfigurationTest $this, KafkaServer server$5) {
        boolean x$8;
        TopicPartition x$7;
        LogManager qual$2 = server$5.logManager();
        return !((AbstractLog)qual$2.getLog(x$7 = $this.topicPartition(), x$8 = qual$2.getLog$default$2()).get()).tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDisableTieredStorageAtBrokerLevel$6() {
        return "TierPartitionState#tieringEnabled flag set to true";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDisableTieredStorageAtBrokerLevel$4(TierConfigurationTest $this, int brokerToUpdate$1, boolean isDynamicallyEnabled$1, KafkaServer server) {
        if (server.config().brokerId() == brokerToUpdate$1) {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = 5000L;
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$5($this, server)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$6());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            ConfigEntry tierEnableConfig = $this.getTierEnableBrokerConfig(Integer.toString(server.config().brokerId()));
            Assertions.assertFalse((boolean)new StringOps(Predef$.MODULE$.augmentString(tierEnableConfig.value())).toBoolean());
            Assertions.assertEquals((Object)ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG, (Object)tierEnableConfig.source());
            return;
        }
        LogManager qual$3 = server.logManager();
        TopicPartition x$9 = $this.topicPartition();
        boolean x$10 = qual$3.getLog$default$2();
        Assertions.assertTrue((boolean)((AbstractLog)qual$3.getLog(x$9, x$10).get()).tierPartitionState().isTieringEnabled());
        ConfigEntry tierEnableConfig = $this.getTierEnableBrokerConfig(Integer.toString(server.config().brokerId()));
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString(tierEnableConfig.value())).toBoolean());
        if (isDynamicallyEnabled$1) {
            Assertions.assertEquals((Object)ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, (Object)tierEnableConfig.source());
            return;
        }
        Assertions.assertEquals((Object)ConfigEntry.ConfigSource.STATIC_BROKER_CONFIG, (Object)tierEnableConfig.source());
    }

    public static final /* synthetic */ boolean $anonfun$testDisableTieredStorageAtBrokerLevel$8(TierConfigurationTest $this, KafkaServer server$6) {
        boolean x$12;
        TopicPartition x$11;
        LogManager qual$4 = server$6.logManager();
        return !((AbstractLog)qual$4.getLog(x$11 = $this.topicPartition(), x$12 = qual$4.getLog$default$2()).get()).tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDisableTieredStorageAtBrokerLevel$9() {
        return "TierPartitionState#tieringEnabled flag set to true";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testDisableTieredStorageAtBrokerLevel$7(TierConfigurationTest $this, KafkaServer server) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 5000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$8($this, server)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierConfigurationTest.$anonfun$testDisableTieredStorageAtBrokerLevel$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public TierConfigurationTest() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.topicPartition = new TopicPartition("foo", 0);
        this.brokerCount = 2;
    }
}

