/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogManager$;
import kafka.log.LogTestUtils$;
import kafka.server.BrokerTopicStats;
import kafka.server.HostedPartition;
import kafka.server.ReplicaManager;
import kafka.tier.AwaitingDeleteComplete$;
import kafka.tier.Config;
import kafka.tier.DeletedPartitionsChangeListener;
import kafka.tier.ImmigratedTierTopicPartition;
import kafka.tier.InProgressDeletion;
import kafka.tier.MaterializationComplete$;
import kafka.tier.MaterializingState$;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierPartitionDeleteComplete;
import kafka.tier.domain.TierPartitionDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicConsumer;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0015f\u0001B\u00193\u0001]BQA\u0010\u0001\u0005\u0002}BqA\u0011\u0001C\u0002\u0013%1\t\u0003\u0004K\u0001\u0001\u0006I\u0001\u0012\u0005\b\u0017\u0002\u0011\r\u0011\"\u0003M\u0011\u0019\u0019\u0006\u0001)A\u0005\u001b\"9A\u000b\u0001b\u0001\n\u0013)\u0006B\u0002/\u0001A\u0003%a\u000bC\u0004^\u0001\t\u0007I\u0011\u00020\t\r\t\u0004\u0001\u0015!\u0003`\u0011\u001d\u0019\u0007A1A\u0005\n\u0011Dq!!\u0004\u0001A\u0003%Q\rC\u0005\u0002\u0010\u0001\u0011\r\u0011\"\u0003\u0002\u0012!A\u0011\u0011\u0004\u0001!\u0002\u0013\t\u0019\u0002C\u0005\u0002\u001c\u0001\u0011\r\u0011\"\u0003\u0002\u001e!A\u0011q\u0006\u0001!\u0002\u0013\ty\u0002C\u0005\u00022\u0001\u0011\r\u0011\"\u0003\u0002\u001e!A\u00111\u0007\u0001!\u0002\u0013\ty\u0002C\u0005\u00026\u0001\u0011\r\u0011\"\u0003\u00028!A\u0011q\n\u0001!\u0002\u0013\tI\u0004C\u0004\u0002R\u0001!\t!a\u0015\t\u000f\u0005E\u0004\u0001\"\u0001\u0002T!9\u00111\u0010\u0001\u0005\u0002\u0005M\u0003bBAC\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003\u0013\u0003A\u0011AA*\u0011\u001d\ti\t\u0001C\u0001\u0003'Bq!!%\u0001\t\u0003\t\u0019\u0006C\u0004\u0002\u0016\u0002!\t!a\u0015\t\u000f\u0005e\u0005\u0001\"\u0001\u0002T!9\u0011Q\u0014\u0001\u0005\u0002\u0005M\u0003bBAQ\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003K\u0003A\u0011AA*\u0011\u001d\tI\u000b\u0001C\u0005\u0003WCq!!:\u0001\t\u0013\t9\u000fC\u0004\u0002l\u0002!I!!<\t\u000f\u0005E\b\u0001\"\u0003\u0002t\"9!Q\u0001\u0001\u0005\n\t\u001d\u0001\"\u0003B(\u0001E\u0005I\u0011\u0002B)\u0011%\u00119\u0007AI\u0001\n\u0013\u0011I\u0007C\u0005\u0003n\u0001\t\n\u0011\"\u0003\u0003p!I!1\u000f\u0001\u0012\u0002\u0013%!q\u000e\u0005\n\u0005k\u0002\u0011\u0013!C\u0005\u0005oB\u0011Ba\u001f\u0001#\u0003%IA! \t\u0013\t\u0005\u0005!%A\u0005\n\t\r\u0005\"\u0003BD\u0001E\u0005I\u0011\u0002BB\r\u0019\u0011I\t\u0001\u0003\u0003\f\"1a(\fC\u0001\u0005'Cq!!:.\t\u0003\u0012I\nC\u0004\u0003 6\"\tE!)\u0003IQKWM\u001d#fY\u0016$X\r\u001a)beRLG/[8og\u000e{wN\u001d3j]\u0006$xN\u001d+fgRT!a\r\u001b\u0002\tQLWM\u001d\u0006\u0002k\u0005)1.\u00194lC\u000e\u00011C\u0001\u00019!\tID(D\u0001;\u0015\u0005Y\u0014!B:dC2\f\u0017BA\u001f;\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u0011\t\u0003\u0003\u0002i\u0011AM\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\u0005!\u0005CA#I\u001b\u00051%BA$5\u0003\u0019\u0019XM\u001d<fe&\u0011\u0011J\u0012\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0013!\u0005;jKJ$v\u000e]5d\u0007>t7/^7feV\tQ\n\u0005\u0002O#6\tqJ\u0003\u0002Qe\u0005)Ao\u001c9jG&\u0011!k\u0014\u0002\u0012)&,'\u000fV8qS\u000e\u001cuN\\:v[\u0016\u0014\u0018A\u0005;jKJ$v\u000e]5d\u0007>t7/^7fe\u0002\nA\u0001^5nKV\ta\u000b\u0005\u0002X56\t\u0001L\u0003\u0002Zi\u0005)Q\u000f^5mg&\u00111\f\u0017\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005I1o\u00195fIVdWM]\u000b\u0002?B\u0011q\u000bY\u0005\u0003Cb\u0013Q\"T8dWN\u001b\u0007.\u001a3vY\u0016\u0014\u0018AC:dQ\u0016$W\u000f\\3sA\u0005iA/[3sK\u0012|%M[3diN,\u0012!\u001a\t\u0005M.l\u0007/D\u0001h\u0015\tA\u0017.A\u0004nkR\f'\r\\3\u000b\u0005)T\u0014AC2pY2,7\r^5p]&\u0011An\u001a\u0002\u0004\u001b\u0006\u0004\bCA!o\u0013\ty'G\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]B\u0019\u0011/\u001f?\u000f\u0005I<hBA:w\u001b\u0005!(BA;7\u0003\u0019a$o\\8u}%\t1(\u0003\u0002yu\u00059\u0001/Y2lC\u001e,\u0017B\u0001>|\u0005\u0011a\u0015n\u001d;\u000b\u0005aT\u0004cA?\u0002\b9\u0019a0a\u0001\u000e\u0003}T1!!\u00013\u0003\u0015\u0019Ho\u001c:f\u0013\r\t)a`\u0001\u0010)&,'o\u00142kK\u000e$8\u000b^8sK&!\u0011\u0011BA\u0006\u00059y%M[3di6+G/\u00193bi\u0006T1!!\u0002\u0000\u00039!\u0018.\u001a:fI>\u0013'.Z2ug\u0002\nA\u0004Z3mKR,G\rU1si&$\u0018n\u001c8t\u0007>|'\u000fZ5oCR|'/\u0006\u0002\u0002\u0014A\u0019\u0011)!\u0006\n\u0007\u0005]!G\u0001\u0011US\u0016\u0014H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:D_>\u0014H-\u001b8bi>\u0014\u0018!\b3fY\u0016$X\r\u001a)beRLG/[8og\u000e{wN\u001d3j]\u0006$xN\u001d\u0011\u0002\u0007\u0011L'/\u0006\u0002\u0002 A!\u0011\u0011EA\u0016\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012AA5p\u0015\t\tI#\u0001\u0003kCZ\f\u0017\u0002BA\u0017\u0003G\u0011AAR5mK\u0006!A-\u001b:!\u0003\u0019awn\u001a#je\u00069An\\4ESJ\u0004\u0013A\u0005;jKJ$v\u000e]5d!\u0006\u0014H/\u001b;j_:,\"!!\u000f\u0011\t\u0005m\u00121J\u0007\u0003\u0003{QA!a\u0010\u0002B\u000511m\\7n_:T1!NA\"\u0015\u0011\t)%a\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\tI%A\u0002pe\u001eLA!!\u0014\u0002>\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0005;jKJ$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013!B:fiV\u0004HCAA+!\rI\u0014qK\u0005\u0004\u00033R$\u0001B+oSRD3\u0001FA/!\u0011\ty&!\u001c\u000e\u0005\u0005\u0005$\u0002BA2\u0003K\n1!\u00199j\u0015\u0011\t9'!\u001b\u0002\u000f),\b/\u001b;fe*!\u00111NA$\u0003\u0015QWO\\5u\u0013\u0011\ty'!\u0019\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hm\\<oQ\r)\u0012Q\u000f\t\u0005\u0003?\n9(\u0003\u0003\u0002z\u0005\u0005$!C!gi\u0016\u0014X)Y2i\u0003Q!Xm\u001d;J]&$\u0018.\u0019;f\t\u0016dW\r^5p]\"\u001aa#a \u0011\t\u0005}\u0013\u0011Q\u0005\u0005\u0003\u0007\u000b\tG\u0001\u0003UKN$\u0018\u0001\u0006;fgR\u001cu.\u001c9mKR,G)\u001a7fi&|g\u000eK\u0002\u0018\u0003\u007f\n\u0001\u0004^3ti\n+w-\u001b8NCR,'/[1mSj\fG/[8oQ\rA\u0012qP\u0001\u0014i\u0016\u001cH\u000fR3mKR,\u0007+\u0019:uSRLwN\u001c\u0015\u00043\u0005}\u0014a\u0007;fgR$U\u000f\u001d7jG\u0006$X\rR3mKR,\u0017J\\5uS\u0006$X\rK\u0002\u001b\u0003\u007f\nq\u0006^3ti\u000e{G\u000e\\3di\u0012+G.\u001a;fIB\u000b'\u000f^5uS>t7oV5uQ>sG.\u001b8f!\u0006\u0014H/\u001b;j_:D3aGA@\u0003A\"Xm\u001d;D_2dWm\u0019;EK2,G/\u001a3QCJ$\u0018\u000e^5p]N<\u0016\u000e\u001e5PM\u001ad\u0017N\\3QCJ$\u0018\u000e^5p]\"\u001aA$a \u0002[Q,7\u000f^\"pY2,7\r\u001e#fY\u0016$X\r\u001a)beRLG/[8og^KG\u000f\u001b(p]\u0016\u0004\u0016M\u001d;ji&|g\u000eK\u0002\u001e\u0003\u007f\nA\u0007^3ti\u000e{G\u000e\\3di\u0012+G.\u001a;fIB\u000b'\u000f^5uS>t7oV5uQ\u0016k\u0017n\u001a:bi&|g\u000eR;sS:<'+Z1eQ\rq\u0012qP\u0001\u0014i\u0016\u001cHOU3d_:4\u0017nZ;sCRLwN\u001c\u0015\u0004?\u0005}\u0014!F5oSRL\u0017\r^3TK\u001elWM\u001c;Va2|\u0017\r\u001a\u000b\r\u0003[\u000bI,!0\u0002H\u0006]\u0017\u0011\u001d\t\u0005\u0003_\u000b),\u0004\u0002\u00022*!\u00111WA\u001f\u0003\u0019\u0011XmY8sI&!\u0011qWAY\u00055iU-\\8ssJ+7m\u001c:eg\"1\u00111\u0018\u0011A\u00025\f\u0001\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c8\t\u000f\u0005}\u0006\u00051\u0001\u0002B\u0006YA.Z1eKJ,\u0005o\\2i!\rI\u00141Y\u0005\u0004\u0003\u000bT$aA%oi\"9\u0011\u0011\u001a\u0011A\u0002\u0005-\u0017\u0001C8cU\u0016\u001cG/\u00133\u0011\t\u00055\u00171[\u0007\u0003\u0003\u001fTA!!5\u0002(\u0005!Q\u000f^5m\u0013\u0011\t).a4\u0003\tU+\u0016\n\u0012\u0005\b\u00033\u0004\u0003\u0019AAn\u0003)\u0011\u0017m]3PM\u001a\u001cX\r\u001e\t\u0004s\u0005u\u0017bAApu\t!Aj\u001c8h\u0011\u001d\t\u0019\u000f\ta\u0001\u00037\f\u0011\"\u001a8e\u001f\u001a47/\u001a;\u00023%t\u0017\u000e^5bi\u0016\u0004\u0016M\u001d;ji&|g\u000eR3mKRLwN\u001c\u000b\u0005\u0003[\u000bI\u000f\u0003\u0004\u0002<\u0006\u0002\r!\\\u0001\u001aG>l\u0007\u000f\\3uKB\u000b'\u000f^5uS>tG)\u001a7fi&|g\u000e\u0006\u0003\u0002.\u0006=\bBBA^E\u0001\u0007Q.A\u0007nK6|'/\u001f*fG>\u0014Hm\u001d\u000b\u0005\u0003[\u000b)\u0010C\u0004\u0002x\u000e\u0002\r!!?\u0002\u00115,G/\u00193bi\u0006\u0004B!a?\u0003\u00025\u0011\u0011Q \u0006\u0004\u0003\u007f\u0014\u0014A\u00023p[\u0006Lg.\u0003\u0003\u0003\u0004\u0005u(\u0001F!cgR\u0014\u0018m\u0019;US\u0016\u0014X*\u001a;bI\u0006$\u0018-A\u0005de\u0016\fG/\u001a'pOR!\"\u0011\u0002B\u000b\u0005/\u0011\tCa\u000b\u00030\tM\"1\bB$\u0005\u0017\u0002BAa\u0003\u0003\u00125\u0011!Q\u0002\u0006\u0004\u0005\u001f!\u0014a\u00017pO&!!1\u0003B\u0007\u0005-\t%m\u001d;sC\u000e$Hj\\4\t\u000f\u0005mA\u00051\u0001\u0002 !I!\u0011\u0004\u0013\u0011\u0002\u0003\u0007!1D\u0001\u0007G>tg-[4\u0011\t\t-!QD\u0005\u0005\u0005?\u0011iAA\u0005M_\u001e\u001cuN\u001c4jO\"I!1\u0005\u0013\u0011\u0002\u0003\u0007!QE\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN\u00042!\u0012B\u0014\u0013\r\u0011IC\u0012\u0002\u0011\u0005J|7.\u001a:U_BL7m\u0015;biND\u0011B!\f%!\u0003\u0005\r!a7\u0002\u001d1|wm\u0015;beR|eMZ:fi\"I!\u0011\u0007\u0013\u0011\u0002\u0003\u0007\u00111\\\u0001\u000ee\u0016\u001cwN^3ssB{\u0017N\u001c;\t\u0011u#\u0003\u0013!a\u0001\u0005k\u00012a\u0016B\u001c\u0013\r\u0011I\u0004\u0017\u0002\n'\u000eDW\rZ;mKJD\u0001\u0002\u0016\u0013\u0011\u0002\u0003\u0007!Q\b\t\u0005\u0005\u007f\u0011\u0019%\u0004\u0002\u0003B)\u0019\u0011,!\u0010\n\t\t\u0015#\u0011\t\u0002\u0005)&lW\rC\u0005\u0003J\u0011\u0002\n\u00111\u0001\u0002B\u0006IR.\u0019=Qe>$WoY3s\u0013\u0012,\u0005\u0010]5sCRLwN\\'t\u0011%\u0011i\u0005\nI\u0001\u0002\u0004\t\t-A\u0012qe>$WoY3s\u0013\u0012,\u0005\u0010]5sCRLwN\\\"iK\u000e\\\u0017J\u001c;feZ\fG.T:\u0002'\r\u0014X-\u0019;f\u0019><G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tM#\u0006\u0002B\u000e\u0005+Z#Aa\u0016\u0011\t\te#1M\u0007\u0003\u00057RAA!\u0018\u0003`\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005CR\u0014AC1o]>$\u0018\r^5p]&!!Q\rB.\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0014GJ,\u0017\r^3M_\u001e$C-\u001a4bk2$HeM\u000b\u0003\u0005WRCA!\n\u0003V\u0005\u00192M]3bi\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!\u0011\u000f\u0016\u0005\u00037\u0014)&A\nde\u0016\fG/\u001a'pO\u0012\"WMZ1vYR$S'A\nde\u0016\fG/\u001a'pO\u0012\"WMZ1vYR$c'\u0006\u0002\u0003z)\"!Q\u0007B+\u0003M\u0019'/Z1uK2{w\r\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011yH\u000b\u0003\u0003>\tU\u0013aE2sK\u0006$X\rT8hI\u0011,g-Y;mi\u0012BTC\u0001BCU\u0011\t\tM!\u0016\u0002'\r\u0014X-\u0019;f\u0019><G\u0005Z3gCVdG\u000fJ\u001d\u0003\u00111K7\u000f^3oKJ\u001cB!\f\u001d\u0003\u000eB\u0019\u0011Ia$\n\u0007\tE%GA\u0010EK2,G/\u001a3QCJ$\u0018\u000e^5p]N\u001c\u0005.\u00198hK2K7\u000f^3oKJ$\"A!&\u0011\u0007\t]U&D\u0001\u0001)\u0019\t)Fa'\u0003\u001e\"1\u00111X\u0018A\u00025DQaY\u0018A\u0002A\fQc\u001d;paB\u000b'\u000f^5uS>tG)\u001a7fi&|g\u000e\u0006\u0003\u0002V\t\r\u0006BBA^a\u0001\u0007Q\u000e")
public class TierDeletedPartitionsCoordinatorTest {
    private final ReplicaManager kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
    private final TierTopicConsumer kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer = (TierTopicConsumer)Mockito.mock(TierTopicConsumer.class);
    private final MockTime kafka$tier$TierDeletedPartitionsCoordinatorTest$$time = new MockTime();
    private final MockScheduler kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler = this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().scheduler();
    private final scala.collection.mutable.Map<TopicIdPartition, List<TierObjectStore.ObjectMetadata>> tieredObjects = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final TierDeletedPartitionsCoordinator deletedPartitionsCoordinator = new TierDeletedPartitionsCoordinator((Scheduler)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler(), this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager(), this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), 1L, 100, "foo", (Time)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time());
    private final File dir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.dir());
    private final TopicPartition tierTopicPartition = Log$.MODULE$.parseTopicPartitionName(this.logDir());

    public ReplicaManager kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager;
    }

    public TierTopicConsumer kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer;
    }

    public MockTime kafka$tier$TierDeletedPartitionsCoordinatorTest$$time() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time;
    }

    public MockScheduler kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler;
    }

    private scala.collection.mutable.Map<TopicIdPartition, List<TierObjectStore.ObjectMetadata>> tieredObjects() {
        return this.tieredObjects;
    }

    private TierDeletedPartitionsCoordinator deletedPartitionsCoordinator() {
        return this.deletedPartitionsCoordinator;
    }

    private File dir() {
        return this.dir;
    }

    private File logDir() {
        return this.logDir;
    }

    private TopicPartition tierTopicPartition() {
        return this.tierTopicPartition;
    }

    @BeforeEach
    public void setup() {
        this.deletedPartitionsCoordinator().registerListener((DeletedPartitionsChangeListener)new Listener());
    }

    @AfterEach
    public void teardown() {
        this.dir().delete();
    }

    @Test
    public void testInitiateDeletion() {
        scala.collection.immutable.Map deletedPartitionsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{new TopicIdPartition("foo-1", UUID.randomUUID(), 0), new TopicIdPartition("foo-2", UUID.randomUUID(), 2)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{new TopicIdPartition("foo-3", UUID.randomUUID(), 0)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$))}));
        deletedPartitionsMap.keySet().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)tierTopicPartitionId -> this.deletedPartitionsCoordinator().handleImmigration(tierTopicPartitionId));
        deletedPartitionsMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TierDeletedPartitionsCoordinatorTest.$anonfun$testInitiateDeletion$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
        scala.collection.mutable.Map immigratedPartitions = this.deletedPartitionsCoordinator().immigratedPartitions();
        Assertions.assertEquals((Object)deletedPartitionsMap, (Object)immigratedPartitions.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            int tierTopicPartitionId = x0$2._1$mcI$sp();
            ImmigratedTierTopicPartition immigratedPartition = (ImmigratedTierTopicPartition)x0$2._2();
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId), (Object)immigratedPartition.pendingDeletions().keySet());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(1, new TopicIdPartition("foo", UUID.randomUUID(), 0), 20L);
        Assertions.assertEquals((Object)deletedPartitionsMap, (Object)immigratedPartitions.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            int tierTopicPartitionId = x0$3._1$mcI$sp();
            ImmigratedTierTopicPartition immigratedPartition = (ImmigratedTierTopicPartition)x0$3._2();
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)tierTopicPartitionId), (Object)immigratedPartition.pendingDeletions().keySet());
            return tuple2;
        }, Map$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testCompleteDeletion() {
        TopicIdPartition foo_1 = new TopicIdPartition("foo-1", UUID.randomUUID(), 0);
        TopicIdPartition foo_2 = new TopicIdPartition("foo-2", UUID.randomUUID(), 2);
        TopicIdPartition foo_3 = new TopicIdPartition("foo-3", UUID.randomUUID(), 5);
        LongRef offset = LongRef.create((long)0L);
        scala.collection.immutable.Map deletedPartitionsMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo_1, foo_2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo_3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$))}));
        deletedPartitionsMap.keySet().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)tierTopicPartitionId -> this.deletedPartitionsCoordinator().handleImmigration(tierTopicPartitionId));
        deletedPartitionsMap.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TierDeletedPartitionsCoordinatorTest.$anonfun$testCompleteDeletion$2(this, offset, x0$1);
            return BoxedUnit.UNIT;
        });
        this.deletedPartitionsCoordinator().trackCompletePartitionDelete(0, foo_1);
        this.deletedPartitionsCoordinator().trackCompletePartitionDelete(3, foo_3);
        scala.collection.mutable.Map immigratedPartitions = this.deletedPartitionsCoordinator().immigratedPartitions();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo_2})), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)0))).pendingDeletions().keySet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)3))).pendingDeletions().keySet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)5))).pendingDeletions().keySet());
        Assertions.assertEquals((int)3, (int)immigratedPartitions.size());
        this.deletedPartitionsCoordinator().handleEmigration(0);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 5})), (Object)immigratedPartitions.keySet());
    }

    @Test
    public void testBeginMaterialization() {
        Tuple2 foo_1 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new TopicIdPartition("foo-1", UUID.randomUUID(), 0));
        Tuple2 foo_2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new TopicIdPartition("foo-2", UUID.randomUUID(), 2));
        Tuple2 foo_3 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)new TopicIdPartition("foo-3", UUID.randomUUID(), 2));
        Tuple2 foo_4 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)new TopicIdPartition("foo-4", UUID.randomUUID(), 5));
        this.deletedPartitionsCoordinator().handleImmigration(0);
        this.deletedPartitionsCoordinator().handleImmigration(3);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_1._1$mcI$sp(), (TopicIdPartition)foo_1._2(), 10L);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_2._1$mcI$sp(), (TopicIdPartition)foo_2._2(), 20L);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_4._1$mcI$sp(), (TopicIdPartition)foo_4._2(), 30L);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_1._1$mcI$sp(), (TopicIdPartition)foo_1._2(), 31L);
        this.deletedPartitionsCoordinator().maybeBeginMaterialization();
        scala.collection.mutable.Map immigratedPartitions = this.deletedPartitionsCoordinator().immigratedPartitions();
        Assertions.assertTrue((boolean)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_1._1$mcI$sp()))).inProgressDeletions().contains(foo_1._2()));
        Assertions.assertTrue((boolean)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_2._1$mcI$sp()))).inProgressDeletions().contains(foo_2._2()));
        Assertions.assertTrue((boolean)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_4._1$mcI$sp()))).inProgressDeletions().contains(foo_4._2()));
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)((TraversableOnce)immigratedPartitions.values().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)TierDeletedPartitionsCoordinatorTest.$anonfun$testBeginMaterialization$1(x$1)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_1._1$mcI$sp(), (TopicIdPartition)foo_1._2(), 32L);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_2._1$mcI$sp(), (TopicIdPartition)foo_2._2(), 34L);
        Assertions.assertEquals((int)0, (int)BoxesRunTime.unboxToInt((Object)((TraversableOnce)immigratedPartitions.values().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)TierDeletedPartitionsCoordinatorTest.$anonfun$testBeginMaterialization$2(x$2)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
        ((TierTopicConsumer)Mockito.verify((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), (VerificationMode)Mockito.times((int)1))).register((Map)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<Map<TopicIdPartition, TierTopicConsumer.ClientCtx>>(null, foo_1, foo_2, foo_4){
            private final Tuple2 foo_1$1;
            private final Tuple2 foo_2$1;
            private final Tuple2 foo_4$1;

            public boolean matches(Map<TopicIdPartition, TierTopicConsumer.ClientCtx> argument) {
                Object object = CollectionConverters$.MODULE$.asScalaSetConverter(argument.keySet()).asScala();
                GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{(TopicIdPartition)this.foo_1$1._2(), (TopicIdPartition)this.foo_2$1._2(), (TopicIdPartition)this.foo_4$1._2()}));
                return !(object != null ? !object.equals(genTraversable) : genTraversable != null);
            }
            {
                this.foo_1$1 = foo_1$1;
                this.foo_2$1 = foo_2$1;
                this.foo_4$1 = foo_4$1;
            }
        }));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer()});
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(foo_3._1$mcI$sp(), (TopicIdPartition)foo_3._2(), 100L);
        this.deletedPartitionsCoordinator().maybeBeginMaterialization();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{(TopicIdPartition)foo_3._2()})), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_3._1$mcI$sp()))).pendingDeletions().keySet());
        this.deletedPartitionsCoordinator().trackCompletePartitionDelete(foo_1._1$mcI$sp(), (TopicIdPartition)foo_1._2());
        this.deletedPartitionsCoordinator().trackCompletePartitionDelete(foo_2._1$mcI$sp(), (TopicIdPartition)foo_2._2());
        this.deletedPartitionsCoordinator().maybeBeginMaterialization();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{(TopicIdPartition)foo_3._2()})), (Object)((ImmigratedTierTopicPartition)immigratedPartitions.apply((Object)BoxesRunTime.boxToInteger((int)foo_3._1$mcI$sp()))).inProgressDeletions().keySet());
    }

    @Test
    public void testDeletePartition() {
        int tierTopicPartition = 1;
        TopicIdPartition deletedPartition_1 = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int deleteInitiateOffset_1 = 10;
        TopicIdPartition deletedPartition_2 = new TopicIdPartition("bar", UUID.randomUUID(), 0);
        int deleteInitiateOffset_2 = 20;
        IndexedSeq tieredSegments_1 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)i -> TierDeletedPartitionsCoordinatorTest.$anonfun$testDeletePartition$1(deletedPartition_1, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.tieredObjects().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)deletedPartition_1), (Object)tieredSegments_1.toList()));
        this.deletedPartitionsCoordinator().handleImmigration(tierTopicPartition);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartition, deletedPartition_1, (long)deleteInitiateOffset_1);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartition, deletedPartition_2, (long)deleteInitiateOffset_2);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{deletedPartition_1, deletedPartition_2})), (Object)((ImmigratedTierTopicPartition)this.deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition))).pendingDeletions().keySet());
        this.deletedPartitionsCoordinator().maybeBeginMaterialization();
        scala.collection.mutable.Map inProgressPartitions = ((ImmigratedTierTopicPartition)this.deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition))).inProgressDeletions();
        Assertions.assertEquals((int)2, (int)inProgressPartitions.size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{deletedPartition_1, deletedPartition_2})), (Object)inProgressPartitions.keySet());
        Assertions.assertEquals((Object)new .colon.colon((Object)MaterializingState$.MODULE$, (List)new .colon.colon((Object)MaterializingState$.MODULE$, (List)Nil$.MODULE$)), (Object)inProgressPartitions.values().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.currentState(), Iterable$.MODULE$.canBuildFrom()));
        Assertions.assertTrue((boolean)((ImmigratedTierTopicPartition)this.deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition))).pendingDeletions().isEmpty());
        LongRef offset = LongRef.create((long)0L);
        InProgressDeletion inProgress_1 = (InProgressDeletion)inProgressPartitions.apply((Object)deletedPartition_1);
        tieredSegments_1.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            OffsetAndEpoch stateOffsetAndEpoch = new OffsetAndEpoch(offset$2.elem, Optional.of(Predef$.MODULE$.int2Integer(0)));
            ++offset$2.elem;
            return inProgress_1.process((AbstractTierMetadata)new TierSegmentUploadInitiate(segment.topicIdPartition(), segment.tierEpoch(), segment.objectId(), segment.baseOffset(), segment.baseOffset() + 1L, 0L, 100, false, false, false, stateOffsetAndEpoch, TierObjectStore.OpaqueData.ZEROED), stateOffsetAndEpoch);
        });
        inProgress_1.process((AbstractTierMetadata)new TierPartitionDeleteInitiate(deletedPartition_1, 0, UUID.randomUUID()), new OffsetAndEpoch((long)deleteInitiateOffset_1, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Assertions.assertEquals((Object)MaterializationComplete$.MODULE$, (Object)inProgress_1.deletionState());
        this.deletedPartitionsCoordinator().maybeBeginDeletion();
        Assertions.assertEquals((Object)AwaitingDeleteComplete$.MODULE$, (Object)inProgress_1.deletionState());
        this.deletedPartitionsCoordinator().trackCompletePartitionDelete(tierTopicPartition, deletedPartition_1);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{deletedPartition_2})), (Object)inProgressPartitions.keySet());
        Assertions.assertEquals((Object)new .colon.colon((Object)MaterializingState$.MODULE$, (List)Nil$.MODULE$), (Object)inProgressPartitions.values().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.currentState(), Iterable$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testDuplicateDeleteInitiate() {
        int tierTopicPartition = 1;
        TopicIdPartition partition = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        int deleteInitiateOffset_1 = 10;
        int deleteCompleteOffset_1 = 15;
        int deleteInitiateOffset_2 = 20;
        IndexedSeq tieredSegments = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable & scala.Serializable)i -> TierDeletedPartitionsCoordinatorTest.$anonfun$testDuplicateDeleteInitiate$1(partition, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        this.tieredObjects().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)tieredSegments.toList()));
        this.deletedPartitionsCoordinator().handleImmigration(tierTopicPartition);
        this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartition, partition, (long)deleteInitiateOffset_2);
        this.deletedPartitionsCoordinator().maybeBeginMaterialization();
        InProgressDeletion inProgress = (InProgressDeletion)((ImmigratedTierTopicPartition)this.deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)tierTopicPartition))).inProgressDeletions().apply((Object)partition);
        LongRef offset = LongRef.create((long)0L);
        tieredSegments.foreach((Function1 & Serializable & scala.Serializable)segment -> {
            TierDeletedPartitionsCoordinatorTest.$anonfun$testDuplicateDeleteInitiate$2(offset, inProgress, segment);
            return BoxedUnit.UNIT;
        });
        Mockito.reset((Object[])new TierTopicConsumer[]{this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer()});
        inProgress.process((AbstractTierMetadata)new TierPartitionDeleteInitiate(partition, 0, UUID.randomUUID()), new OffsetAndEpoch((long)deleteInitiateOffset_1, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Assertions.assertEquals((Object)MaterializingState$.MODULE$, (Object)inProgress.deletionState());
        inProgress.process((AbstractTierMetadata)new TierPartitionDeleteComplete(partition, UUID.randomUUID()), new OffsetAndEpoch((long)deleteCompleteOffset_1, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Assertions.assertEquals((Object)MaterializingState$.MODULE$, (Object)inProgress.deletionState());
        ((TierTopicConsumer)Mockito.verify((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), (VerificationMode)Mockito.never())).deregister(partition);
        inProgress.process((AbstractTierMetadata)new TierPartitionDeleteInitiate(partition, 0, UUID.randomUUID()), new OffsetAndEpoch((long)deleteInitiateOffset_2, Optional.of(Predef$.MODULE$.int2Integer(0))));
        Assertions.assertEquals((Object)MaterializationComplete$.MODULE$, (Object)inProgress.deletionState());
        inProgress.process((AbstractTierMetadata)new TierPartitionDeleteComplete(partition, UUID.randomUUID()), new OffsetAndEpoch((long)(deleteInitiateOffset_2 + 1), Optional.of(Predef$.MODULE$.int2Integer(0))));
        ((TierTopicConsumer)Mockito.verify((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), (VerificationMode)Mockito.times((int)1))).deregister(partition);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCollectDeletedPartitionsWithOnlinePartition() {
        void var8_8;
        AbstractLog log = this.createLog(this.logDir(), this.createLog$default$2(), this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        int leaderEpoch = 0;
        this.deletedPartitionsCoordinator().handleImmigration(this.tierTopicPartition().partition());
        Mockito.when((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager().getPartition(this.tierTopicPartition())).thenReturn((Object)new HostedPartition.Online(partition));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        TopicIdPartition topicIdPartition_1 = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TopicIdPartition topicIdPartition_2 = new TopicIdPartition("bar", UUID.randomUUID(), 3);
        new .colon.colon((Object)this.initiateSegmentUpload(topicIdPartition_1, 0, UUID.randomUUID(), 0L, 100L), (List)new .colon.colon((Object)this.initiatePartitionDeletion(topicIdPartition_1), (List)new .colon.colon((Object)this.initiateSegmentUpload(topicIdPartition_2, 0, UUID.randomUUID(), 100L, 1000L), (List)new .colon.colon((Object)this.initiatePartitionDeletion(topicIdPartition_2), (List)new .colon.colon((Object)this.completePartitionDeletion(topicIdPartition_1), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)record -> log.appendAsLeader(record, leaderEpoch, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.updateHighWatermark(log.logEndOffset());
        ByteBuffer buffer = ByteBuffer.allocate(200);
        Tuple2 tuple2 = this.deletedPartitionsCoordinator().collectDeletedPartitions(this.tierTopicPartition(), 0L, buffer);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lastReadOffset = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)log.logEndOffset(), (long)var8_8);
        ImmigratedTierTopicPartition immigratedPartition = (ImmigratedTierTopicPartition)this.deletedPartitionsCoordinator().immigratedPartitions().apply((Object)BoxesRunTime.boxToInteger((int)this.tierTopicPartition().partition()));
        Assertions.assertEquals((Object)new .colon.colon((Object)topicIdPartition_2, (List)Nil$.MODULE$), (Object)immigratedPartition.pendingDeletions().keySet().toList());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCollectDeletedPartitionsWithOfflinePartition() {
        void var4_4;
        Mockito.when((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager().getPartition(this.tierTopicPartition())).thenReturn((Object)HostedPartition.Offline$.MODULE$);
        ByteBuffer buffer = ByteBuffer.allocate(200);
        int startOffset = 0;
        Tuple2 tuple2 = this.deletedPartitionsCoordinator().collectDeletedPartitions(this.tierTopicPartition(), (long)startOffset, buffer);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lastReadOffset = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)var4_4, (long)startOffset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCollectDeletedPartitionsWithNonePartition() {
        void var4_4;
        Mockito.when((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager().getPartition(this.tierTopicPartition())).thenReturn((Object)HostedPartition.None$.MODULE$);
        ByteBuffer buffer = ByteBuffer.allocate(200);
        int startOffset = 0;
        Tuple2 tuple2 = this.deletedPartitionsCoordinator().collectDeletedPartitions(this.tierTopicPartition(), (long)startOffset, buffer);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lastReadOffset = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)var4_4, (long)startOffset);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCollectDeletedPartitionsWithEmigrationDuringRead() {
        void var8_8;
        AbstractLog log = this.createLog(this.logDir(), this.createLog$default$2(), this.createLog$default$3(), this.createLog$default$4(), this.createLog$default$5(), this.createLog$default$6(), this.createLog$default$7(), this.createLog$default$8(), this.createLog$default$9());
        Partition partition = (Partition)Mockito.mock(Partition.class);
        int leaderEpoch = 0;
        this.deletedPartitionsCoordinator().handleImmigration(this.tierTopicPartition().partition());
        Mockito.when((Object)this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager().getPartition(this.tierTopicPartition())).thenReturn((Object)new HostedPartition.Online(partition));
        Mockito.when((Object)partition.localLogOrException()).thenReturn((Object)log);
        TopicIdPartition topicIdPartition_1 = new TopicIdPartition("foo", UUID.randomUUID(), 0);
        TopicIdPartition topicIdPartition_2 = new TopicIdPartition("bar", UUID.randomUUID(), 3);
        new .colon.colon((Object)this.initiateSegmentUpload(topicIdPartition_1, 0, UUID.randomUUID(), 0L, 100L), (List)new .colon.colon((Object)this.initiatePartitionDeletion(topicIdPartition_1), (List)new .colon.colon((Object)this.initiateSegmentUpload(topicIdPartition_2, 0, UUID.randomUUID(), 100L, 1000L), (List)new .colon.colon((Object)this.initiatePartitionDeletion(topicIdPartition_2), (List)new .colon.colon((Object)this.completePartitionDeletion(topicIdPartition_1), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)record -> log.appendAsLeader(record, leaderEpoch, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5()));
        log.updateHighWatermark(log.logEndOffset());
        this.deletedPartitionsCoordinator().handleEmigration(this.tierTopicPartition().partition());
        ByteBuffer buffer = ByteBuffer.allocate(200);
        Tuple2 tuple2 = this.deletedPartitionsCoordinator().collectDeletedPartitions(this.tierTopicPartition(), 0L, buffer);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long lastReadOffset = tuple2._1$mcJ$sp();
        Assertions.assertEquals((long)0L, (long)var8_8);
        Assertions.assertEquals((int)0, (int)this.deletedPartitionsCoordinator().immigratedPartitions().size());
    }

    @Test
    public void testReconfiguration() {
        ListBuffer heartbeats = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        int initialDelayMs = 100;
        ObjectRef config = ObjectRef.create((Object)new Config(200L, 100));
        TierDeletedPartitionsCoordinator coordinator = new TierDeletedPartitionsCoordinator(this, config, heartbeats){
            private final /* synthetic */ TierDeletedPartitionsCoordinatorTest $outer;
            private final ListBuffer heartbeats$1;

            public void heartbeat() {
                super.heartbeat();
                this.heartbeats$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)this.$outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().milliseconds()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.heartbeats$1 = heartbeats$1;
                super((Scheduler)$outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler(), $outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$replicaManager(), $outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$tierTopicConsumer(), ((Config)config$1.elem).intervalMs(), ((Config)config$1.elem).maxInprogressPartitions(), "foo", (Time)$outer.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time());
            }
        };
        coordinator.startup();
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(initialDelayMs);
        Assertions.assertEquals((int)1, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs());
        Assertions.assertEquals((int)2, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs() / 2L);
        Assertions.assertEquals((int)2, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs() / 2L + 1L);
        Assertions.assertEquals((int)3, (int)heartbeats.size());
        config.elem = new Config(10L, 100);
        coordinator.reconfigure((Config)config.elem);
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(1L);
        Assertions.assertEquals((int)4, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs());
        Assertions.assertEquals((int)5, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs() / 2L);
        Assertions.assertEquals((int)5, (int)heartbeats.size());
        this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time().sleep(((Config)config.elem).intervalMs() / 2L + 1L);
        Assertions.assertEquals((int)6, (int)heartbeats.size());
        coordinator.shutdown();
    }

    private MemoryRecords initiateSegmentUpload(TopicIdPartition topicIdPartition, int leaderEpoch, UUID objectId, long baseOffset, long endOffset) {
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, leaderEpoch, objectId, baseOffset, endOffset, 10L, 500, true, true, true, new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(0))), TierObjectStore.OpaqueData.ZEROED);
        return this.memoryRecords((AbstractTierMetadata)uploadInitiate);
    }

    private MemoryRecords initiatePartitionDeletion(TopicIdPartition topicIdPartition) {
        return this.memoryRecords((AbstractTierMetadata)new TierPartitionDeleteInitiate(topicIdPartition, 0, UUID.randomUUID()));
    }

    private MemoryRecords completePartitionDeletion(TopicIdPartition topicIdPartition) {
        return this.memoryRecords((AbstractTierMetadata)new TierPartitionDeleteComplete(topicIdPartition, UUID.randomUUID()));
    }

    private MemoryRecords memoryRecords(AbstractTierMetadata metadata) {
        return MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(0L, metadata.serializeKey(), metadata.serializeValue())});
    }

    private AbstractLog createLog(File dir, LogConfig config, BrokerTopicStats brokerTopicStats, long logStartOffset, long recoveryPoint, Scheduler scheduler, Time time, int maxProducerIdExpirationMs, int producerIdExpirationCheckIntervalMs) {
        return LogTestUtils$.MODULE$.createLog(dir, config, brokerTopicStats, scheduler, time, logStartOffset, recoveryPoint, maxProducerIdExpirationMs, producerIdExpirationCheckIntervalMs, LogTestUtils$.MODULE$.createLog$default$10(), LogTestUtils$.MODULE$.createLog$default$11(), LogTestUtils$.MODULE$.createLog$default$12(), LogTestUtils$.MODULE$.createLog$default$13(), LogTestUtils$.MODULE$.createLog$default$14(), LogTestUtils$.MODULE$.createLog$default$15());
    }

    private LogConfig createLog$default$2() {
        return LogTestUtils$.MODULE$.createLogConfig(LogTestUtils$.MODULE$.createLogConfig$default$1(), LogTestUtils$.MODULE$.createLogConfig$default$2(), LogTestUtils$.MODULE$.createLogConfig$default$3(), LogTestUtils$.MODULE$.createLogConfig$default$4(), LogTestUtils$.MODULE$.createLogConfig$default$5(), LogTestUtils$.MODULE$.createLogConfig$default$6(), LogTestUtils$.MODULE$.createLogConfig$default$7(), LogTestUtils$.MODULE$.createLogConfig$default$8(), LogTestUtils$.MODULE$.createLogConfig$default$9(), LogTestUtils$.MODULE$.createLogConfig$default$10(), LogTestUtils$.MODULE$.createLogConfig$default$11(), LogTestUtils$.MODULE$.createLogConfig$default$12(), LogTestUtils$.MODULE$.createLogConfig$default$13(), LogTestUtils$.MODULE$.createLogConfig$default$14(), LogTestUtils$.MODULE$.createLogConfig$default$15(), LogTestUtils$.MODULE$.createLogConfig$default$16());
    }

    private BrokerTopicStats createLog$default$3() {
        return new BrokerTopicStats();
    }

    private long createLog$default$4() {
        return 0L;
    }

    private long createLog$default$5() {
        return 0L;
    }

    private Scheduler createLog$default$6() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$scheduler();
    }

    private Time createLog$default$7() {
        return this.kafka$tier$TierDeletedPartitionsCoordinatorTest$$time();
    }

    private int createLog$default$8() {
        return 3600000;
    }

    private int createLog$default$9() {
        return LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
    }

    public static final /* synthetic */ void $anonfun$testInitiateDeletion$3(TierDeletedPartitionsCoordinatorTest $this, int tierTopicPartitionId$1, TopicIdPartition deletedPartition) {
        $this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartitionId$1, deletedPartition, 10L);
    }

    public static final /* synthetic */ void $anonfun$testInitiateDeletion$2(TierDeletedPartitionsCoordinatorTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            int tierTopicPartitionId = x0$1._1$mcI$sp();
            ((Set)x0$1._2()).foreach((Function1 & Serializable & scala.Serializable)deletedPartition -> {
                TierDeletedPartitionsCoordinatorTest.$anonfun$testInitiateDeletion$3($this, tierTopicPartitionId, deletedPartition);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testCompleteDeletion$3(TierDeletedPartitionsCoordinatorTest $this, int tierTopicPartitionId$2, LongRef offset$1, TopicIdPartition deletedPartition) {
        $this.deletedPartitionsCoordinator().trackInitiatePartitionDelete(tierTopicPartitionId$2, deletedPartition, offset$1.elem);
        ++offset$1.elem;
    }

    public static final /* synthetic */ void $anonfun$testCompleteDeletion$2(TierDeletedPartitionsCoordinatorTest $this, LongRef offset$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            int tierTopicPartitionId = x0$1._1$mcI$sp();
            ((Set)x0$1._2()).foreach((Function1 & Serializable & scala.Serializable)deletedPartition -> {
                TierDeletedPartitionsCoordinatorTest.$anonfun$testCompleteDeletion$3($this, tierTopicPartitionId, offset$1, deletedPartition);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$testBeginMaterialization$1(ImmigratedTierTopicPartition x$1) {
        return x$1.pendingDeletions().size();
    }

    public static final /* synthetic */ int $anonfun$testBeginMaterialization$2(ImmigratedTierTopicPartition x$2) {
        return x$2.pendingDeletions().size();
    }

    public static final /* synthetic */ TierObjectStore.ObjectMetadata $anonfun$testDeletePartition$1(TopicIdPartition deletedPartition_1$1, int i) {
        return new TierObjectStore.ObjectMetadata(deletedPartition_1$1, UUID.randomUUID(), 0, (long)i, false, false, false, TierObjectStore.OpaqueData.ZEROED);
    }

    public static final /* synthetic */ TierObjectStore.ObjectMetadata $anonfun$testDuplicateDeleteInitiate$1(TopicIdPartition partition$1, int i) {
        return new TierObjectStore.ObjectMetadata(partition$1, UUID.randomUUID(), 0, (long)i, false, false, false, TierObjectStore.OpaqueData.ZEROED);
    }

    public static final /* synthetic */ void $anonfun$testDuplicateDeleteInitiate$2(LongRef offset$3, InProgressDeletion inProgress$1, TierObjectStore.ObjectMetadata segment) {
        OffsetAndEpoch stateOffsetAndEpoch = new OffsetAndEpoch(offset$3.elem, Optional.of(Predef$.MODULE$.int2Integer(0)));
        inProgress$1.process((AbstractTierMetadata)new TierSegmentUploadInitiate(segment.topicIdPartition(), segment.tierEpoch(), segment.objectId(), segment.baseOffset(), segment.baseOffset() + 1L, 0L, 100, false, false, false, stateOffsetAndEpoch, TierObjectStore.OpaqueData.ZEROED), stateOffsetAndEpoch);
        ++offset$3.elem;
    }

    private class Listener
    implements DeletedPartitionsChangeListener {
        public void initiatePartitionDeletion(TopicIdPartition topicIdPartition, List<TierObjectStore.ObjectMetadata> tieredObjects) {
        }

        public void stopPartitionDeletion(TopicIdPartition topicIdPartition) {
        }

        public /* synthetic */ TierDeletedPartitionsCoordinatorTest kafka$tier$TierDeletedPartitionsCoordinatorTest$Listener$$$outer() {
            return TierDeletedPartitionsCoordinatorTest.this;
        }

        public Listener() {
            if (TierDeletedPartitionsCoordinatorTest.this == null) {
                throw null;
            }
        }
    }
}

