/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001B\u0010!\u0001\u0015BQA\r\u0001\u0005\u0002MBqA\u000e\u0001C\u0002\u0013\u0005q\u0007\u0003\u0004A\u0001\u0001\u0006I\u0001\u000f\u0005\b\u0003\u0002\u0011\r\u0011\"\u0001C\u0011\u0019a\u0005\u0001)A\u0005\u0007\"9Q\n\u0001b\u0001\n\u0003\u0011\u0005B\u0002(\u0001A\u0003%1\tC\u0004P\u0001\u0001\u0007I\u0011\u0001)\t\u000fu\u0003\u0001\u0019!C\u0001=\"1A\r\u0001Q!\nECq!\u001a\u0001A\u0002\u0013\u0005a\rC\u0004t\u0001\u0001\u0007I\u0011\u0001;\t\rY\u0004\u0001\u0015)\u0003h\u0011\u001d9\bA1A\u0005\u0002aDq!a\u0002\u0001A\u0003%\u0011\u0010C\u0004\u0002\n\u0001!\t%a\u0003\t\u000f\u0005\r\u0002\u0001\"\u0011\u0002\f!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0002bBA!\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003\u0017\u0002A\u0011BA'\u0011\u001d\tI\u0007\u0001C\u0005\u0003WBq!a\u001c\u0001\t\u0013\t\t\bC\u0004\u0002v\u0001!I!a\u001e\t\u000f\u0005m\u0004\u0001\"\u0003\u0002~!9\u0011Q\u0012\u0001\u0005\n\u0005=\u0005BBAS\u0001\u0011%a\rC\u0004\u0002(\u0002!I!!+\t\u000f\u0005-\u0006\u0001\"\u0003\u0002*\"9\u0011Q\u0016\u0001\u0005\n\u0005=\u0006\"CA`\u0001E\u0005I\u0011BAa\u0005u!\u0016.\u001a:Fa>\u001c\u0007n\u0015;bi\u0016\u0014V\r\u001d7jG\u0006$\u0018n\u001c8UKN$(BA\u0011#\u0003\u0011!\u0018.\u001a:\u000b\u0003\r\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001M1\u0002\"a\n\u0016\u000e\u0003!R!!\u000b\u0012\u0002\u0005i\\\u0017BA\u0016)\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tgB\u0011Q\u0006M\u0007\u0002])\u0011qFI\u0001\u0006kRLGn]\u0005\u0003c9\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002iA\u0011Q\u0007A\u0007\u0002A\u0005)Ao\u001c9jGV\t\u0001\b\u0005\u0002:}5\t!H\u0003\u0002<y\u0005!A.\u00198h\u0015\u0005i\u0014\u0001\u00026bm\u0006L!a\u0010\u001e\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005\u0019Qn]4\u0016\u0003\r\u00032\u0001R$J\u001b\u0005)%\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+%!B!se\u0006L\bC\u0001#K\u0013\tYUI\u0001\u0003CsR,\u0017\u0001B7tO\u0002\n\u0011\"\\:h\u0005&<w-\u001a:\u0002\u00155\u001cxMQ5hO\u0016\u0014\b%A\u0004ce>\\WM]:\u0016\u0003E\u00032AU+X\u001b\u0005\u0019&B\u0001+F\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003-N\u00131aU3r!\tA6,D\u0001Z\u0015\tQ&%\u0001\u0004tKJ4XM]\u0005\u00039f\u00131bS1gW\u0006\u001cVM\u001d<fe\u0006Y!M]8lKJ\u001cx\fJ3r)\ty&\r\u0005\u0002EA&\u0011\u0011-\u0012\u0002\u0005+:LG\u000fC\u0004d\u0013\u0005\u0005\t\u0019A)\u0002\u0007a$\u0013'\u0001\u0005ce>\\WM]:!\u0003!\u0001(o\u001c3vG\u0016\u0014X#A4\u0011\t!\f8iQ\u0007\u0002S*\u0011QM\u001b\u0006\u0003W2\fqa\u00197jK:$8O\u0003\u0002$[*\u0011an\\\u0001\u0007CB\f7\r[3\u000b\u0003A\f1a\u001c:h\u0013\t\u0011\u0018NA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM]\u0001\raJ|G-^2fe~#S-\u001d\u000b\u0003?VDqa\u0019\u0007\u0002\u0002\u0003\u0007q-A\u0005qe>$WoY3sA\u00051Q\r_5uK\u0012,\u0012!\u001f\t\u0004u\u0006\rQ\"A>\u000b\u0005ql\u0018AB1u_6L7M\u0003\u0002\u007f\u007f\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\u0005\u0005A(\u0001\u0003vi&d\u0017bAA\u0003w\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\fq!\u001a=ji\u0016$\u0007%A\u0003tKR,\u0006\u000fF\u0001`Q\r\u0001\u0012q\u0002\t\u0005\u0003#\ty\"\u0004\u0002\u0002\u0014)!\u0011QCA\f\u0003\r\t\u0007/\u001b\u0006\u0005\u00033\tY\"A\u0004kkBLG/\u001a:\u000b\u0007\u0005uq.A\u0003kk:LG/\u0003\u0003\u0002\"\u0005M!A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002\u0012\u0003O\u0001B!!\u0005\u0002*%!\u00111FA\n\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\tde\u0016\fG/Z!e[&t7\t\\5f]R$B!!\r\u0002>A!\u00111GA\u001d\u001b\t\t)DC\u0002\u00028)\fQ!\u00193nS:LA!a\u000f\u00026\tY\u0011\tZ7j]\u000ec\u0017.\u001a8u\u0011\u0019\tyD\u0005a\u0001#\u000691/\u001a:wKJ\u001c\u0018\u0001\n;fgR$\u0016.\u001a:Ti\u0006$XMU3ti>\u0014Xm\u00148MC\u001e<\u0017N\\4SKBd\u0017nY1)\u0007M\t)\u0005\u0005\u0003\u0002\u0012\u0005\u001d\u0013\u0002BA%\u0003'\u0011A\u0001V3ti\u00061q-\u001a;M_\u001e$b!a\u0014\u0002\\\u0005}\u0003\u0003BA)\u0003/j!!a\u0015\u000b\u0007\u0005U#%A\u0002m_\u001eLA!!\u0017\u0002T\tY\u0011IY:ue\u0006\u001cG\u000fT8h\u0011\u0019\ti\u0006\u0006a\u0001/\u00061!M]8lKJDq!!\u0019\u0015\u0001\u0004\t\u0019'A\u0005qCJ$\u0018\u000e^5p]B\u0019A)!\u001a\n\u0007\u0005\u001dTIA\u0002J]R\fAa\u001d;paR\u0019q,!\u001c\t\u000bi+\u0002\u0019A,\u0002\u000bM$\u0018M\u001d;\u0015\u0007}\u000b\u0019\bC\u0003[-\u0001\u0007q+\u0001\u0004c_Vt7-\u001a\u000b\u0004?\u0006e\u0004\"\u0002.\u0018\u0001\u00049\u0016AC3q_\u000eD7)Y2iKR!\u0011qPAF!\u0011\t\t)a\"\u000e\u0005\u0005\r%bAAC3\u0006)Q\r]8dQ&!\u0011\u0011RAB\u0005QaU-\u00193fe\u0016\u0003xn\u00195GS2,7)Y2iK\"1\u0011Q\f\rA\u0002]\u000b\u0001\"Y<bSRL5K\u0015\u000b\u0006?\u0006E\u0015\u0011\u0015\u0005\b\u0003'K\u0002\u0019AAK\u0003\t!\b\u000f\u0005\u0003\u0002\u0018\u0006uUBAAM\u0015\r\tY\n\\\u0001\u0007G>lWn\u001c8\n\t\u0005}\u0015\u0011\u0014\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\t\u0019+\u0007a\u0001\u0003G\n1B\\;n%\u0016\u0004H.[2bg\u0006q1M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014\u0018A\u00027fC\u0012,'/F\u0001X\u0003!1w\u000e\u001c7po\u0016\u0014\u0018\u0001D2sK\u0006$XM\u0011:pW\u0016\u0014H#B,\u00022\u0006U\u0006bBAZ;\u0001\u0007\u00111M\u0001\u0003S\u0012D\u0011\"a.\u001e!\u0003\u0005\r!!/\u00027\u0015t\u0017M\u00197f+:\u001cG.Z1o\u0019\u0016\fG-\u001a:FY\u0016\u001cG/[8o!\r!\u00151X\u0005\u0004\u0003{+%a\u0002\"p_2,\u0017M\\\u0001\u0017GJ,\u0017\r^3Ce>\\WM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0019\u0016\u0005\u0003s\u000b)m\u000b\u0002\u0002HB!\u0011\u0011ZAj\u001b\t\tYM\u0003\u0003\u0002N\u0006=\u0017!C;oG\",7m[3e\u0015\r\t\t.R\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAk\u0003\u0017\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class TierEpochStateReplicationTest
extends ZooKeeperTestHarness {
    private final String topic;
    private final byte[] msg = new byte[1000];
    private final byte[] msgBigger = new byte[10000];
    private Seq<KafkaServer> brokers = null;
    private KafkaProducer<byte[], byte[]> producer = null;
    private final AtomicBoolean exited = new AtomicBoolean(false);

    public String topic() {
        return this.topic;
    }

    public byte[] msg() {
        return this.msg;
    }

    public byte[] msgBigger() {
        return this.msgBigger;
    }

    public Seq<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp() {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.producer().close();
        TestUtils$.MODULE$.shutdownServers(this.brokers());
        super.tearDown();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    public AdminClient createAdminClient(Seq<KafkaServer> servers) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", TestUtils$.MODULE$.bootstrapServers(servers, ListenerName.normalised((String)"PLAINTEXT")));
        properties.put("request.timeout.ms", "20000");
        return AdminClient.create((Properties)properties);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTierStateRestoreOnLaggingReplica() {
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1 & Serializable & scala.Serializable)x$3 -> this.createBroker(BoxesRunTime.unboxToInt((Object)x$3), this.createBroker$default$2()), IndexedSeq$.MODULE$.canBuildFrom())));
        Properties properties = new Properties();
        properties.put("confluent.tier.enable", "true");
        properties.put("segment.bytes", "10000");
        properties.put("retention.bytes", "-1");
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers(), properties);
        KafkaServer leader = this.leader();
        KafkaServer follower = this.follower();
        this.producer_$eq(this.createProducer());
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        int epochBeforeLeaderBounce = BoxesRunTime.unboxToInt((Object)this.epochCache(leader).latestEpoch().get());
        this.bounce(leader);
        this.awaitISR(tp, 2);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$2(this, leader)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$4(leader)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        int epochAfterLeaderBounce = BoxesRunTime.unboxToInt((Object)this.epochCache(leader).latestEpoch().get());
        Assertions.assertTrue((epochAfterLeaderBounce > epochBeforeLeaderBounce ? 1 : 0) != 0);
        Assertions.assertEquals((Object)this.epochCache(leader).epochEntries(), (Object)this.epochCache(follower).epochEntries());
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)broker -> {
            TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$6(broker);
            return BoxedUnit.UNIT;
        });
        this.stop(follower);
        this.awaitISR(tp, 1);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 999).foreach((Function1 & Serializable & scala.Serializable)_ -> TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$9(this, BoxesRunTime.unboxToInt((Object)_)));
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$10(leader, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$11());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((BoxesRunTime.unboxToInt((Object)this.epochCache(leader).latestEpoch().get()) > epochAfterLeaderBounce ? 1 : 0) != 0);
        this.start(follower);
        this.awaitISR(tp, 2);
        Assertions.assertEquals((Object)this.epochCache(leader).epochEntries(), (Object)this.epochCache(follower).epochEntries());
    }

    private AbstractLog getLog(KafkaServer broker, int partition) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$1 = new TopicPartition(this.topic(), partition);
        boolean x$2 = qual$1.getLog$default$2();
        return (AbstractLog)qual$1.getLog(x$1, x$2).orNull(Predef$.MODULE$.$conforms());
    }

    private void stop(KafkaServer server) {
        server.shutdown();
        this.producer().close();
        this.producer_$eq(this.createProducer());
    }

    private void start(KafkaServer server) {
        server.startup();
        this.producer().close();
        this.producer_$eq(this.createProducer());
    }

    private void bounce(KafkaServer server) {
        server.shutdown();
        server.startup();
        this.producer().close();
        this.producer_$eq(this.createProducer());
    }

    private LeaderEpochFileCache epochCache(KafkaServer broker) {
        return (LeaderEpochFileCache)this.getLog(broker, 0).leaderEpochCache().get();
    }

    /*
     * WARNING - void declaration
     */
    private void awaitISR(TopicPartition tp, int numReplicas) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierEpochStateReplicationTest.$anonfun$awaitISR$1(this, tp, numReplicas)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierEpochStateReplicationTest.$anonfun$awaitISR$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private KafkaProducer<byte[], byte[]> createProducer() {
        return TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), -1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16());
    }

    private KafkaServer leader() {
        Assertions.assertEquals((int)2, (int)this.brokers().size());
        int leaderId = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic(), 0)).get());
        return (KafkaServer)this.brokers().find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TierEpochStateReplicationTest.$anonfun$leader$1(leaderId, x$4))).get();
    }

    private KafkaServer follower() {
        Assertions.assertEquals((int)2, (int)this.brokers().size());
        int leader = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic(), 0)).get());
        return (KafkaServer)this.brokers().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TierEpochStateReplicationTest.$anonfun$follower$1(leader, x$5))).get();
    }

    private KafkaServer createBroker(int id, boolean enableUncleanLeaderElection) {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(id, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        config.setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(enableUncleanLeaderElection));
        config.setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        config.setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        config.setProperty(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "2");
        config.setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
        config.setProperty(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        config.setProperty(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "10");
        config.setProperty(KafkaConfig$.MODULE$.LeaderImbalancePerBrokerPercentageProp(), "0");
        config.setProperty(KafkaConfig$.MODULE$.LeaderImbalanceCheckIntervalSecondsProp(), "10");
        return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
    }

    private boolean createBroker$default$2() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testTierStateRestoreOnLaggingReplica$2(TierEpochStateReplicationTest $this, KafkaServer leader$1) {
        KafkaServer kafkaServer = $this.leader();
        return !(kafkaServer != null ? !kafkaServer.equals(leader$1) : leader$1 != null);
    }

    public static final /* synthetic */ String $anonfun$testTierStateRestoreOnLaggingReplica$3() {
        return "Timed out waiting for preferred leader to be elected";
    }

    public static final /* synthetic */ boolean $anonfun$testTierStateRestoreOnLaggingReplica$4(KafkaServer leader$1) {
        return ((TierTopicManager)leader$1.tierTopicManagerOpt().get()).isReady();
    }

    public static final /* synthetic */ String $anonfun$testTierStateRestoreOnLaggingReplica$5() {
        return "Timed out waiting for tier topic manager to be ready";
    }

    public static final /* synthetic */ boolean $anonfun$testTierStateRestoreOnLaggingReplica$7(KafkaServer broker$1) {
        return ((TierTopicManager)broker$1.tierTopicManagerOpt().get()).isReady();
    }

    public static final /* synthetic */ String $anonfun$testTierStateRestoreOnLaggingReplica$8() {
        return "Timed out waiting for tier topic manager to be ready";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testTierStateRestoreOnLaggingReplica$6(KafkaServer broker) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$7(broker)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierEpochStateReplicationTest.$anonfun$testTierStateRestoreOnLaggingReplica$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ RecordMetadata $anonfun$testTierStateRestoreOnLaggingReplica$9(TierEpochStateReplicationTest $this, int _) {
        return (RecordMetadata)$this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)$this.msg())).get();
    }

    public static final /* synthetic */ boolean $anonfun$testTierStateRestoreOnLaggingReplica$10(KafkaServer leader$1, TopicPartition tp$1) {
        boolean x$2;
        LogManager qual$1 = leader$1.replicaManager().logManager();
        return ((AbstractLog)qual$1.getLog(tp$1, x$2 = qual$1.getLog$default$2()).get()).localLogStartOffset() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testTierStateRestoreOnLaggingReplica$11() {
        return "timed out waiting for segment tiering and hotset retention";
    }

    public static final /* synthetic */ boolean $anonfun$awaitISR$1(TierEpochStateReplicationTest $this, TopicPartition tp$2, int numReplicas$1) {
        return ((Partition)$this.leader().replicaManager().onlinePartition(tp$2).get()).inSyncReplicaIds().size() == numReplicas$1;
    }

    public static final /* synthetic */ String $anonfun$awaitISR$2() {
        return "Timed out waiting for replicas to join ISR";
    }

    public static final /* synthetic */ boolean $anonfun$leader$1(int leaderId$1, KafkaServer x$4) {
        return x$4.config().brokerId() == leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$follower$1(int leader$2, KafkaServer x$5) {
        return x$5.config().brokerId() != leader$2;
    }

    public TierEpochStateReplicationTest() {
        this.topic = "topic1";
    }
}

