/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.MergedLog;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.MemoryTracker;
import kafka.tier.fetcher.TierFetcher;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.tools.RecoveryTestUtils$;
import kafka.tier.tools.RecoveryUtils;
import kafka.tier.tools.TierMetadataComparator;
import kafka.tier.tools.TierPartitionStateFencingTrigger;
import kafka.tier.tools.TierPartitionStateRestoreTrigger;
import kafka.tier.tools.TierPartitionUnfreezeLogStartOffsetTrigger;
import kafka.tier.tools.common.FenceEventInfo;
import kafka.tier.tools.common.RestoreInfo;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\tma\u0001B\u000f\u001f\u0001\rBQA\u000b\u0001\u0005\u0002-BQA\f\u0001\u0005R=BQA\u000e\u0001\u0005\n]Bqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004F\u0001\u0001\u0006I!\u0010\u0005\b\r\u0002\u0011\r\u0011\"\u00030\u0011\u00199\u0005\u0001)A\u0005a!)\u0001\n\u0001C\u0005\u0013\"9\u0011\r\u0001b\u0001\n\u0003\u0011\u0007BB7\u0001A\u0003%1\rC\u0003o\u0001\u0011\u0005s\u0007C\u0003z\u0001\u0011\u0005s\u0007C\u0003\u007f\u0001\u0011\u0005q\u0007\u0003\u0004\u0002\b\u0001!\ta\u000e\u0005\b\u0003\u0017\u0001A\u0011BA\u0007\u0011\u001d\t9\u0007\u0001C\u0005\u0003SBq!a\u001f\u0001\t\u0013\ti\b\u0003\u0004\u0002|\u0001!\ta\u000e\u0005\u0007\u0003\u0013\u0003A\u0011A\u001c\t\r\u00055\u0005\u0001\"\u00018\u0011\u001d\t\t\n\u0001C\u0005\u0003'Cq!!(\u0001\t\u0013\ty\nC\u0004\u0002,\u0002!I!!,\t\u000f\u0005U\u0006\u0001\"\u0003\u00028\"9\u00111\u0018\u0001\u0005\n\u0005u\u0006bBAc\u0001\u0011%\u0011q\u0019\u0005\b\u0003W\u0004A\u0011BAw\u0011\u001d\u0011\t\u0002\u0001C\u0005\u0005'\u00111\u0004V5fe&sG/Z4sCRLwN\\#oIR{WI\u001c3UKN$(BA\u0010!\u0003\u0011!\u0018.\u001a:\u000b\u0003\u0005\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001IA\u0011Q\u0005K\u0007\u0002M)\u0011q\u0005I\u0001\u0004CBL\u0017BA\u0015'\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001-!\ti\u0003!D\u0001\u001f\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003A\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u00121!\u00138u\u00035\u0019wN\u001c4jOV\u0014X-T8dWR\t\u0001\b\u0005\u00022s%\u0011!H\r\u0002\u0005+:LG/A\u0003u_BL7-F\u0001>!\tq4)D\u0001@\u0015\t\u0001\u0015)\u0001\u0003mC:<'\"\u0001\"\u0002\t)\fg/Y\u0005\u0003\t~\u0012aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%\u0001\u0006qCJ$\u0018\u000e^5p]N\f1\u0002]1si&$\u0018n\u001c8tA\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t7/F\u0001K!\rY5K\u0016\b\u0003\u0019Fs!!\u0014)\u000e\u00039S!a\u0014\u0012\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0014B\u0001*3\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001V+\u0003\u0007M+\u0017O\u0003\u0002SeA\u0011qkX\u0007\u00021*\u0011\u0011LW\u0001\u0007G>lWn\u001c8\u000b\u0005\u0005Z&B\u0001/^\u0003\u0019\t\u0007/Y2iK*\ta,A\u0002pe\u001eL!\u0001\u0019-\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u00061Q\r_5uK\u0012,\u0012a\u0019\t\u0003I.l\u0011!\u001a\u0006\u0003M\u001e\fa!\u0019;p[&\u001c'B\u00015j\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003U\u0006\u000bA!\u001e;jY&\u0011A.\u001a\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u000f\u0015D\u0018\u000e^3eA\u0005)1/\u001a;Va\"\u00121\u0002\u001d\t\u0003c^l\u0011A\u001d\u0006\u0003OMT!\u0001^;\u0002\u000f),\b/\u001b;fe*\u0011a/X\u0001\u0006UVt\u0017\u000e^\u0005\u0003qJ\u0014!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007F\u0001\u0007|!\t\tH0\u0003\u0002~e\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0018i\u0016\u001cH/\u0011:dQ&4X-\u00118e)&,'OR3uG\"D3!DA\u0001!\r\t\u00181A\u0005\u0004\u0003\u000b\u0011(\u0001\u0002+fgR\f\u0001\u0005^3ti\u0006\u00138\r[5wK\u0006sG\r\u0015:fM\u0016\u0014(/\u001a3US\u0016\u0014h)\u001a;dQ\"\u001aa\"!\u0001\u00021Y\fG.\u001b3bi\u00164UM\\2f)>|GNU3tk2$8\u000fF\u00059\u0003\u001f\tI#!\u0013\u0002X!9\u0011\u0011C\bA\u0002\u0005M\u0011a\u00034f]\u000e,WI^3oiN\u0004b!!\u0006\u0002\u0018\u0005mQ\"A5\n\u0007\u0005e\u0011N\u0001\u0003MSN$\b\u0003BA\u000f\u0003Ki!!a\b\u000b\u0007e\u000b\tCC\u0002\u0002$y\tQ\u0001^8pYNLA!a\n\u0002 \tqa)\u001a8dK\u00163XM\u001c;J]\u001a|\u0007bBA\u0016\u001f\u0001\u0007\u0011QF\u0001\u0010iBLEm\u001d+p\u0005\u00164UM\\2fIBA\u0011qFA\u001c\u0003{\t\u0019E\u0004\u0003\u00022\u0005M\u0002CA'3\u0013\r\t)DM\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00121\b\u0002\u0004\u001b\u0006\u0004(bAA\u001beA\u0019Q&a\u0010\n\u0007\u0005\u0005cD\u0001\tU_BL7-\u00133QCJ$\u0018\u000e^5p]B\u0019\u0011'!\u0012\n\u0007\u0005\u001d#GA\u0004C_>dW-\u00198\t\u000f\u0005-s\u00021\u0001\u0002N\u0005\u0019An\\4\u0011\t\u0005=\u00131K\u0007\u0003\u0003#R1!a\u0013!\u0013\u0011\t)&!\u0015\u0003\u00135+'oZ3e\u0019><\u0007bBA-\u001f\u0001\u0007\u00111L\u0001\u0013i&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X\r\u0005\u0003\u0002^\u0005\rTBAA0\u0015\r\t\tGH\u0001\u0006gR\fG/Z\u0005\u0005\u0003K\nyF\u0001\nUS\u0016\u0014\b+\u0019:uSRLwN\\*uCR,\u0017a\u0007<bY&$\u0017\r^3SKN$xN]3U_>d7OU3tk2$8\u000fF\u00069\u0003W\ni'!\u001e\u0002x\u0005e\u0004bBA\t!\u0001\u0007\u00111\u0003\u0005\b\u0003_\u0002\u0002\u0019AA9\u0003E\u0011Xm\u001d;pe\u0016|U\u000f\u001e9vi*\u001bxN\u001c\t\u0005\u0003_\t\u0019(C\u0002E\u0003wAq!a\u000b\u0011\u0001\u0004\ti\u0003C\u0004\u0002LA\u0001\r!!\u0014\t\u000f\u0005e\u0003\u00031\u0001\u0002\\\u00059C/Z:u\u0003J\u001c\u0007.\u001b<f\u0003:$G+[3s\r\u0016$8\r\u001b$f]\u000e,\u0017I\u001c3SK\u000e|g/\u001a:z)\u0015A\u0014qPAB\u0011\u001d\t\t)\u0005a\u0001\u0003\u0007\n!#^:f%\u0016\u001cHo\u001c:f%\u0006<\u0018J\u001c9vi\"9\u0011QQ\tA\u0002\u0005\r\u0013A\u00074sK\u0016TX-T3sO\u0016$Gj\\4Ti\u0006\u0014Ho\u00144gg\u0016$\bf\u0001\n\u0002\u0002\u0005QD/Z:u\u0003J\u001c\u0007.\u001b<f\u0003:$G+[3s\r\u0016$8\r\u001b$f]\u000e,\u0017I\u001c3SK\u000e|g/\u001a:z/&$\bNU3ti>\u0014XMU1x\u0013:\u0004X\u000f\u001e\u0015\u0004'\u0005\u0005\u0011!\u0012;fgR\f%o\u00195jm\u0016\fe\u000e\u001a+jKJ4U\r^2i\r\u0016t7-Z!oIJ+7m\u001c<fef<\u0016\u000e\u001e5NKJ<W\r\u001a'pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e$s_j,g\u000eK\u0002\u0015\u0003\u0003\ta\u0002\u001d:pIV\u001cWMU3d_J$7\u000fF\u00039\u0003+\u000bI\n\u0003\u0004\u0002\u0018V\u0001\r\u0001M\u0001\t]\n\u000bGo\u00195fg\"1\u00111T\u000bA\u0002A\nqB]3d_J$7\u000fU3s\u0005\u0006$8\r[\u0001\u001bO\u0016$H*Z1eKJ4uN\u001d+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u000b\u0006a\u0005\u0005\u0016Q\u0015\u0005\u0007\u0003G3\u0002\u0019\u0001,\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011q\u0015\fA\u0002\u0005%\u0016\u0001\u00069beRLG/[8o)>dU-\u00193fe6\u000b\u0007\u000f\u0005\u0004\u00020\u0005]\u0002\u0007M\u0001\u0018o\u0006LG/\u00168uS2\u001cVmZ7f]R\u001cH+[3sK\u0012$R\u0001OAX\u0003gCa!!-\u0018\u0001\u0004\u0001\u0014AD7j]:+XnU3h[\u0016tGo\u001d\u0005\b\u0003O;\u0002\u0019AAU\u0003E\u0019\u0018.\\;mCR,'+\u001a;f]RLwN\u001c\u000b\u0004q\u0005e\u0006bBAT1\u0001\u0007\u0011\u0011V\u0001\u001cG>t7/^7f\u0003:$g+\u00197jI\u0006$X\rV5fe\u001a+Go\u00195\u0015\u000fa\ny,!1\u0002D\"9\u0011qU\rA\u0002\u0005%\u0006BBAL3\u0001\u0007\u0001\u0007\u0003\u0004\u0002\u001cf\u0001\r\u0001M\u0001\u0013oJLG/\u001a*fG>4XM]\"p]\u001aLw\r\u0006\u0005\u0002J\u0006U\u00171]At!\u0011\tY-!5\u000e\u0005\u00055'bAAh\u0003\u0006\u0011\u0011n\\\u0005\u0005\u0003'\fiM\u0001\u0003GS2,\u0007bBAl5\u0001\u0007\u0011\u0011\\\u0001\u0007g\u0016\u0014h/\u001a:\u0011\t\u0005m\u0017q\\\u0007\u0003\u0003;T1!a6!\u0013\u0011\t\t/!8\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\b\u0003KT\u0002\u0019AAe\u0003)9xN]6j]\u001e$\u0015N\u001d\u0005\b\u0003ST\u0002\u0019AAe\u0003E\u0011'o\\6fe^{'o\u001b3je2K7\u000f^\u0001&CN\u001cXM\u001d;US6,7\u000f^1na\u001a{'o\u00144gg\u0016$Hj\\8lkB\u001cuN\u001d:fGR$\u0012\u0002OAx\u0003c\u0014\u0019A!\u0004\t\r\u0005\r6\u00041\u0001W\u0011\u001d\t\u0019p\u0007a\u0001\u0003k\f\u0001bY8ogVlWM\u001d\t\t\u0003o\fy0!\u001d\u0002r5\u0011\u0011\u0011 \u0006\u0005\u0003g\fYPC\u0002\u0002~j\u000bqa\u00197jK:$8/\u0003\u0003\u0003\u0002\u0005e(!D&bM.\f7i\u001c8tk6,'\u000fC\u0004\u0003\u0006m\u0001\rAa\u0002\u0002\u0013QLW.Z:uC6\u0004\bcA\u0019\u0003\n%\u0019!1\u0002\u001a\u0003\t1{gn\u001a\u0005\b\u0005\u001fY\u0002\u0019\u0001B\u0004\u00039)\u0007\u0010]3di\u0016$wJ\u001a4tKR\fQ%Y:tKJ$H+[7fgR\fW\u000e\u001d$pe>3gm]3u\u0019>|7.\u001e9NSN\u001c\u0018N\\4\u0015\u000fa\u0012)Ba\u0006\u0003\u001a!1\u00111\u0015\u000fA\u0002YCq!a=\u001d\u0001\u0004\t)\u0010C\u0004\u0003\u0006q\u0001\rAa\u0002")
public class TierIntegrationEndToEndTest
extends IntegrationTestHarness {
    private final String topic;
    private final int partitions;
    private final AtomicBoolean exited;

    @Override
    public int brokerCount() {
        return 1;
    }

    private void configureMock() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierS3BucketProp(), "mybucket");
    }

    private String topic() {
        return this.topic;
    }

    private int partitions() {
        return this.partitions;
    }

    private Seq<TopicPartition> topicPartitions() {
        return (Seq)package$.MODULE$.Range().apply(0, this.partitions()).map((Function1 & Serializable & scala.Serializable)p -> TierIntegrationEndToEndTest.$anonfun$topicPartitions$1(this, BoxesRunTime.unboxToInt((Object)p)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp() {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp();
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    @Test
    public void testArchiveAndTierFetch() {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("confluent.tier.local.hotset.bytes", "5000");
        props.put("retention.bytes", "-1");
        scala.collection.immutable.Map<Object, Object> partitionToLeaderMap = this.createTopic(this.topic(), this.partitions(), 1, props);
        int nBatches = 100;
        int recordsPerBatch = 100;
        this.produceRecords(nBatches, recordsPerBatch);
        this.waitUntilSegmentsTiered(5, partitionToLeaderMap);
        this.simulateRetention(partitionToLeaderMap);
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch);
    }

    @Test
    public void testArchiveAndPreferredTierFetch() {
        Properties props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("retention.bytes", "-1");
        props.put("confluent.tier.local.hotset.ms", "-1");
        props.put("confluent.tier.local.hotset.bytes", "-1");
        props.put("confluent.prefer.tier.fetch.ms", "0");
        scala.collection.immutable.Map<Object, Object> partitionToLeaderMap = this.createTopic(this.topic(), this.partitions(), 1, props);
        int nBatches = 100;
        int recordsPerBatch = 100;
        this.produceRecords(nBatches, recordsPerBatch);
        this.waitUntilSegmentsTiered(5, partitionToLeaderMap);
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch);
    }

    /*
     * WARNING - void declaration
     */
    private void validateFenceToolResults(java.util.List<FenceEventInfo> fenceEvents, scala.collection.immutable.Map<TopicIdPartition, Object> tpIdsToBeFenced, MergedLog log, TierPartitionState tierPartitionState) {
        TopicIdPartition topicIdToBeFenced = (TopicIdPartition)((Tuple2)tpIdsToBeFenced.head())._1();
        boolean freezeMergedLogStartOffset = ((Tuple2)tpIdsToBeFenced.head())._2$mcZ$sp();
        Assertions.assertTrue((fenceEvents.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((new TopicIdPartition(fenceEvents.get(0).topic(), CoreUtils$.MODULE$.uuidFromBase64(fenceEvents.get((int)0).topicIdBase64), fenceEvents.get((int)0).partition).equals(topicIdToBeFenced) ? 1 : 0) != 0);
        Assertions.assertTrue((BoxesRunTime.equals((Object)fenceEvents.get((int)0).freezeMergedLogStartOffset, (Object)BoxesRunTime.boxToBoolean((boolean)freezeMergedLogStartOffset)) ? 1 : 0) != 0);
        if (freezeMergedLogStartOffset) {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierIntegrationEndToEndTest.$anonfun$validateFenceToolResults$1(tierPartitionState, log)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TierIntegrationEndToEndTest.$anonfun$validateFenceToolResults$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            return;
        }
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$validateFenceToolResults$3(tierPartitionState, log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationEndToEndTest.$anonfun$validateFenceToolResults$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void validateRestoreToolsResults(java.util.List<FenceEventInfo> fenceEvents, String restoreOutputJson, scala.collection.immutable.Map<TopicIdPartition, Object> tpIdsToBeFenced, MergedLog log, TierPartitionState tierPartitionState) {
        freezeMergedLogStartOffset = ((Tuple2)tpIdsToBeFenced.head())._2$mcZ$sp();
        restoreRawOutputList = RestoreInfo.RestoreRawOutput.readJsonFromFile((Path)Paths.get(restoreOutputJson, new String[0]));
        if (restoreRawOutputList.size() != 1) ** GOTO lbl-1000
        v0 = ((RestoreInfo.RestoreRawOutput)restoreRawOutputList.get((int)0)).input().fenceEventInfo().freezeMergedLogStartOffset;
        var8_8 = fenceEvents.get((int)0).freezeMergedLogStartOffset;
        if (!(v0 != null ? v0.equals(var8_8) == false : var8_8 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        Assertions.assertTrue((boolean)v1);
        if (freezeMergedLogStartOffset) {
            var11_9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            var9_10 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierIntegrationEndToEndTest.$anonfun$validateRestoreToolsResults$1(tierPartitionState, log)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TierIntegrationEndToEndTest.$anonfun$validateRestoreToolsResults$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            return;
        }
        var17_12 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        var15_13 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$validateRestoreToolsResults$3(tierPartitionState, log)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationEndToEndTest.$anonfun$validateRestoreToolsResults$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void testArchiveAndTierFetchFenceAndRecovery(boolean useRestoreRawInput, boolean freezeMergedLogStartOffset) {
        props = new Properties();
        props.put("confluent.tier.enable", "true");
        props.put("segment.bytes", "10000");
        props.put("confluent.tier.local.hotset.bytes", "5000");
        props.put("retention.bytes", "-1");
        partitionToLeaderMap = this.createTopic(this.topic(), this.partitions(), 1, props);
        nBatches = 100;
        recordsPerBatch = 100;
        this.produceRecords(nBatches, recordsPerBatch);
        this.waitUntilSegmentsTiered(5, partitionToLeaderMap);
        this.simulateRetention(partitionToLeaderMap);
        fenceTopicPartition = (TopicPartition)this.topicPartitions().head();
        leaderId = this.getLeaderForTopicPartition(fenceTopicPartition, partitionToLeaderMap);
        qual$1 = ((KafkaServer)this.serverForId(leaderId).get()).logManager();
        x$2 = qual$1.getLog$default$2();
        log = (AbstractLog)qual$1.getLog(fenceTopicPartition, x$2).get();
        tierPartitionState = (FileTierPartitionState)log.tierPartitionState();
        tpIdsToBeFenced = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tierPartitionState.topicIdPartition().get()), (Object)BoxesRunTime.boxToBoolean((boolean)freezeMergedLogStartOffset))}));
        topicIdPartitionsFile = TestUtils$.MODULE$.tempFile();
        RecoveryTestUtils$.MODULE$.writeFencingFile(topicIdPartitionsFile, (scala.collection.immutable.Map<TopicIdPartition, Object>)tpIdsToBeFenced);
        workingDir = TestUtils$.MODULE$.tempDir();
        brokerWorkdirList = TestUtils.tempDirectory((Path)workingDir.toPath(), null);
        recoveryConfFile = this.writeRecoverConfig((KafkaServer)this.servers().head(), workingDir, brokerWorkdirList);
        outputDir = TestUtils$.MODULE$.tempDir();
        fenceOutFile = new StringBuilder(18).append(outputDir.getAbsolutePath()).append("/fence-output.json").toString();
        TierPartitionStateFencingTrigger.main((String[])((String[])((Object[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"file-fence-target-partitions"), topicIdPartitionsFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"output.json"), fenceOutFile})));
        fenceEvents = FenceEventInfo.jsonToList((Path)Paths.get(fenceOutFile, new String[0]));
        this.validateFenceToolResults(fenceEvents, (scala.collection.immutable.Map<TopicIdPartition, Object>)tpIdsToBeFenced, (MergedLog)log, (TierPartitionState)tierPartitionState);
        tierPartitionState.flush();
        Assertions.assertTrue((boolean)brokerWorkdirList.mkdir());
        tpDir = Paths.get(brokerWorkdirList.getAbsolutePath(), new String[]{tierPartitionState.topicPartition().toString()}).toFile();
        tpDir.mkdir();
        flushedPath = Paths.get(tierPartitionState.flushedPath(), new String[0]);
        Files.copy(flushedPath, Paths.get(tpDir.getAbsolutePath(), new String[]{flushedPath.getFileName().toString()}), new CopyOption[0]);
        comparatorOutputJson = new StringBuilder(23).append(outputDir.getAbsolutePath()).append("/comparator-output.json").toString();
        TierMetadataComparator.main((String[])((String[])((Object[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"input.json"), fenceOutFile, RecoveryUtils.makeArgument((String)"output.json"), comparatorOutputJson})));
        comparatorOutput = RestoreInfo.RestoreComparatorInput.readJsonFromFile((Path)Paths.get(comparatorOutputJson, new String[0]));
        if (comparatorOutput.size() != 1) ** GOTO lbl-1000
        v0 = ((RestoreInfo.RestoreComparatorInput)comparatorOutput.get((int)0)).input().freezeMergedLogStartOffset;
        var25_25 = ((FenceEventInfo)fenceEvents.get((int)0)).freezeMergedLogStartOffset;
        if (!(v0 != null ? v0.equals(var25_25) == false : var25_25 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        Predef$.MODULE$.assert(v1);
        restoreOutputJson = new StringBuilder(20).append(outputDir.getAbsolutePath()).append("/restore-output.json").toString();
        if (useRestoreRawInput) {
            restoreComparatorInputList = RestoreInfo.RestoreComparatorInput.readJsonFromFile((Path)Paths.get(comparatorOutputJson, new String[0]));
            restoreRawInputList = (java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(restoreComparatorInputList).asScala()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testArchiveAndTierFetchFenceAndRecovery$1(kafka.tier.tools.common.RestoreInfo$RestoreComparatorInput ), (Lkafka/tier/tools/common/RestoreInfo$RestoreComparatorInput;)Lkafka/tier/tools/common/RestoreInfo$RestoreRawInput;)(), Buffer$.MODULE$.canBuildFrom())).asJava();
            restoreRawInputJson = new StringBuilder(23).append(outputDir.getAbsolutePath()).append("/restore-raw-input.json").toString();
            fos = new FileOutputStream(restoreRawInputJson);
            RestoreInfo.RestoreRawInput.writeJsonToFile((java.util.List)restoreRawInputList, (OutputStream)fos);
            fos.close();
            TierPartitionStateRestoreTrigger.main((String[])((String[])((Object[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"raw.json"), restoreRawInputJson, RecoveryUtils.makeArgument((String)"output.json"), restoreOutputJson})));
            this.validateRestoreToolsResults(fenceEvents, restoreOutputJson, (scala.collection.immutable.Map<TopicIdPartition, Object>)tpIdsToBeFenced, (MergedLog)log, (TierPartitionState)tierPartitionState);
        } else {
            TierPartitionStateRestoreTrigger.main((String[])((String[])((Object[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"comparator.json"), comparatorOutputJson, RecoveryUtils.makeArgument((String)"output.json"), restoreOutputJson})));
            if (freezeMergedLogStartOffset) {
                var36_31 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                var34_32 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                waitUntilTrue_startTime = System.currentTimeMillis();
                while (!TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$2(tierPartitionState, log)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$3());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            } else {
                var42_34 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                var40_35 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                waitUntilTrue_startTime = System.currentTimeMillis();
                while (!TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$4(tierPartitionState, log)) {
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$5());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            }
        }
        if (freezeMergedLogStartOffset && !useRestoreRawInput) {
            return;
        }
        if (freezeMergedLogStartOffset) {
            unfreezeOutputJson = new StringBuilder(29).append(outputDir.getAbsolutePath()).append("/unfreeze-trigger-output.json").toString();
            TierPartitionUnfreezeLogStartOffsetTrigger.main((String[])((String[])((Object[])new String[]{RecoveryUtils.makeArgument((String)"tier.config"), recoveryConfFile.getAbsolutePath(), RecoveryUtils.makeArgument((String)"restore.json"), restoreOutputJson, RecoveryUtils.makeArgument((String)"output.json"), unfreezeOutputJson})));
            var48_38 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            var46_39 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$6(tierPartitionState, log)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$7());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        this.consumeAndValidateTierFetch(partitionToLeaderMap, nBatches, recordsPerBatch);
        endOffset = tierPartitionState.endOffset();
        this.produceRecords(nBatches, recordsPerBatch);
        var54_42 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        var52_43 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$8(endOffset, tierPartitionState)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationEndToEndTest.$anonfun$testArchiveAndTierFetchFenceAndRecovery$9());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    @Test
    public void testArchiveAndTierFetchFenceAndRecovery() {
        this.testArchiveAndTierFetchFenceAndRecovery(false, false);
    }

    @Test
    public void testArchiveAndTierFetchFenceAndRecoveryWithRestoreRawInput() {
        this.testArchiveAndTierFetchFenceAndRecovery(true, false);
    }

    @Test
    public void testArchiveAndTierFetchFenceAndRecoveryWithMergedLogStartOffsetFrozen() {
        this.testArchiveAndTierFetchFenceAndRecovery(true, true);
    }

    private void produceRecords(int nBatches, int recordsPerBatch) {
        try (KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());){
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nBatches).foreach((Function1 & Serializable & scala.Serializable)b -> TierIntegrationEndToEndTest.$anonfun$produceRecords$1(this, recordsPerBatch, producer, BoxesRunTime.unboxToInt((Object)b)));
        }
    }

    private int getLeaderForTopicPartition(TopicPartition topicPartition, scala.collection.immutable.Map<Object, Object> partitionToLeaderMap) {
        return BoxesRunTime.unboxToInt((Object)partitionToLeaderMap.apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
    }

    private void waitUntilSegmentsTiered(int minNumSegments, scala.collection.immutable.Map<Object, Object> partitionToLeaderMap) {
        this.topicPartitions().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            TierIntegrationEndToEndTest.$anonfun$waitUntilSegmentsTiered$1(this, partitionToLeaderMap, minNumSegments, tp);
            return BoxedUnit.UNIT;
        });
    }

    private void simulateRetention(scala.collection.immutable.Map<Object, Object> partitionToLeaderMap) {
        this.topicPartitions().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            TierIntegrationEndToEndTest.$anonfun$simulateRetention$1(this, partitionToLeaderMap, tp);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void consumeAndValidateTierFetch(scala.collection.immutable.Map<Object, Object> partitionToLeaderMap, int nBatches, int recordsPerBatch) {
        void var31_27;
        void var17_17;
        void var27_24;
        void var23_21;
        void var19_18;
        TopicPartition topicPartition = (TopicPartition)this.topicPartitions().head();
        KafkaConsumer consumer = this.createConsumer(new StringDeserializer(), new StringDeserializer(), this.createConsumer$default$3(), this.createConsumer$default$4());
        java.util.List<TopicPartition> partitions = Collections.singletonList(topicPartition);
        consumer.assign(partitions);
        consumer.seekToBeginning(partitions);
        ArrayList valuesRead = new ArrayList();
        ArrayList timestampsOffsets = new ArrayList();
        while (valuesRead.size() != nBatches * recordsPerBatch) {
            consumer.poll(Duration.ofMillis(1000L)).forEach((Consumer)new Consumer<ConsumerRecord<String, String>>(null, valuesRead, timestampsOffsets){
                private final ArrayList valuesRead$1;
                private final ArrayList timestampsOffsets$1;

                public Consumer<ConsumerRecord<String, String>> andThen(Consumer<? super ConsumerRecord<String, String>> x$1) {
                    return Consumer.super.andThen(x$1);
                }

                public void accept(ConsumerRecord<String, String> r) {
                    this.valuesRead$1.add(BoxesRunTime.boxToInteger((int)Integer.parseInt((String)r.value())));
                    this.timestampsOffsets$1.add(new Tuple2.mcJJ.sp(r.timestamp(), r.offset()));
                }
                {
                    this.valuesRead$1 = valuesRead$1;
                    this.timestampsOffsets$1 = timestampsOffsets$1;
                }
            });
        }
        Assertions.assertEquals(new ArrayList((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.Range().apply(0, nBatches * recordsPerBatch)).asJava()), valuesRead);
        ((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(timestampsOffsets).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$2(this, timestampsOffsets, topicPartition, consumer, x$4);
            return BoxedUnit.UNIT;
        });
        this.assertTimestampForOffsetLookupCorrect(topicPartition, consumer, 0L, 0L);
        this.assertTimestampForOffsetLookupMissing(topicPartition, consumer, Long.MAX_VALUE);
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        int partitionsInErrorDuringArchivalCount = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks:type=TierTasks,name=NumPartitionsInErrorDuringArchival"), (String[])((Object[])new String[]{"Value"})).asList()).asScala()).map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToInteger((int)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$4(attr)), Buffer$.MODULE$.canBuildFrom())).head());
        Assertions.assertEquals((int)0, (int)partitionsInErrorDuringArchivalCount, (String)"tier archiver shows partitions in error state during archival");
        int partitionsInErrorDuringDeletionCount = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks:type=TierTasks,name=NumPartitionsInErrorDuringDeletion"), (String[])((Object[])new String[]{"Value"})).asList()).asScala()).map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToInteger((int)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$5(attr)), Buffer$.MODULE$.canBuildFrom())).head());
        Assertions.assertEquals((int)0, (int)partitionsInErrorDuringDeletionCount, (String)"tier deletion process shows partitions in error state during deletion");
        List memoryTrackerMetrics = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName("kafka.server:type=TierFetcherMemoryTracker"), (String[])((Object[])new String[]{"Leased", "PoolSize", "MaxLeaseLagMs"})).asList()).asScala()).map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$6(attr)), Buffer$.MODULE$.canBuildFrom())).toList();
        String bean = "kafka.server:type=TierFetcher";
        String[] attrs = (String[])((Object[])new String[]{"BytesFetchedTotal", "OffsetCacheHitRatio"});
        List list = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName(bean), attrs).asList()).asScala()).map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$7(attr)), Buffer$.MODULE$.canBuildFrom())).toList();
        Some some = List$.MODULE$.unapplySeq((Seq)list);
        if (some.isEmpty() || some.get() == null || ((LinearSeqOptimized)some.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)list);
        }
        double bytesFetchedTotal = BoxesRunTime.unboxToDouble((Object)((LinearSeqOptimized)some.get()).apply(0));
        double offsetCacheHitRatio = BoxesRunTime.unboxToDouble((Object)((LinearSeqOptimized)some.get()).apply(1));
        Assertions.assertEquals((double)1.0, (double)var19_18, (double)1.0E-6, (String)"offset cache should not have shown misses");
        List list2 = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName("kafka.server:type=TierTopicConsumer"), (String[])((Object[])new String[]{"HeartbeatMs"})).asList()).asScala()).map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$8(attr)), Buffer$.MODULE$.canBuildFrom())).toList();
        Some some2 = List$.MODULE$.unapplySeq((Seq)list2);
        if (some2.isEmpty() || some2.get() == null || ((LinearSeqOptimized)some2.get()).lengthCompare(1) != 0) {
            throw new MatchError((Object)list2);
        }
        double heartbeat = BoxesRunTime.unboxToDouble((Object)((LinearSeqOptimized)some2.get()).apply(0));
        Assertions.assertTrue((var23_21 < (double)2000 ? 1 : 0) != 0, (String)"tier topic consumer heartbeat is alive");
        List list3 = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks:type=TierTasks,name=HeartbeatMs"), (String[])((Object[])new String[]{"Value"})).asList()).asScala()).map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToLong((long)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$9(attr)), Buffer$.MODULE$.canBuildFrom())).toList();
        Some some3 = List$.MODULE$.unapplySeq((Seq)list3);
        if (some3.isEmpty() || some3.get() == null || ((LinearSeqOptimized)some3.get()).lengthCompare(1) != 0) {
            throw new MatchError((Object)list3);
        }
        long tierTasksHeartbeat = BoxesRunTime.unboxToLong((Object)((LinearSeqOptimized)some3.get()).apply(0));
        Assertions.assertTrue((var27_24 < 10000L ? 1 : 0) != 0, (String)"tier tasks heartbeat is alive");
        Assertions.assertTrue((var17_17 > (double)100 ? 1 : 0) != 0, (String)"tier fetch metric shows no data fetched from tiered storage");
        List list4 = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks.archive:type=TierArchiver,name=BytesPerSec"), (String[])((Object[])new String[]{"MeanRate"})).asList()).asScala()).map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$10(attr)), Buffer$.MODULE$.canBuildFrom())).toList();
        Some some4 = List$.MODULE$.unapplySeq((Seq)list4);
        if (some4.isEmpty() || some4.get() == null || ((LinearSeqOptimized)some4.get()).lengthCompare(1) != 0) {
            throw new MatchError((Object)list4);
        }
        double meanArchiveRate = BoxesRunTime.unboxToDouble((Object)((LinearSeqOptimized)some4.get()).apply(0));
        Assertions.assertTrue((var31_27 > (double)100 ? 1 : 0) != 0, (String)"tier archiver mean rate shows no data uploaded to tiered storage");
        Buffer partitionsStatusCounts = (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName("kafka.server:type=TierTopicConsumer"), (String[])((Object[])new String[]{"ImmigratingPartitions", "CatchupConsumerPartitions", "PrimaryConsumerPartitions", "ErrorPartitions", "NumListeners", "MaxListeningMs"})).asList()).asScala()).map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToDouble((double)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$11(attr)), Buffer$.MODULE$.canBuildFrom());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 1.0, 0.0, 0.0, 0.0})), (Object)partitionsStatusCounts, (String)"tier topic manager fully immigrated the partition and metric works");
        int partitionsInErrorCount = BoxesRunTime.unboxToInt((Object)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(mBeanServer.getAttributes(new ObjectName("kafka.tier.tasks:type=TierTasks,name=NumPartitionsInError"), (String[])((Object[])new String[]{"Value"})).asList()).asScala()).map((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToInteger((int)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$12(attr)), Buffer$.MODULE$.canBuildFrom())).head());
        Assertions.assertEquals((int)0, (int)partitionsInErrorCount, (String)"tier archiver shows no partitions in error state");
        Assertions.assertEquals((double)1.0, (double)var19_18, (double)1.0E-6, (String)"offset cache should not have shown misses");
        Assertions.assertTrue((var17_17 > (double)100 ? 1 : 0) != 0, (String)new StringBuilder(61).append("tier fetch metric shows no data fetched from tiered storage: ").append((double)var17_17).toString());
        Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)memoryTrackerMetrics.head()), (double)0.0, (double)0.0, (String)"expected all leased memory to be returned to the MemoryTracker");
        Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)memoryTrackerMetrics.apply(1)), (double)1048576.0, (double)0.0, (String)"expected all leased memory to be returned to the MemoryTracker");
        Assertions.assertEquals((double)BoxesRunTime.unboxToDouble((Object)memoryTrackerMetrics.last()), (double)0.0, (double)0.0, (String)"expected no value for oldestLease, since all leases should be reclaimed");
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$13(server);
            return BoxedUnit.UNIT;
        });
    }

    private File writeRecoverConfig(KafkaServer server, File workingDir, File brokerWorkdirList) {
        File recoveryConfFile = TestUtils$.MODULE$.tempFile();
        Properties props = Utils.mkProperties((Map)new HashMap<String, String>(this, workingDir, brokerWorkdirList){
            {
                this.put(KafkaConfig$.MODULE$.TierBackendProp(), "Mock");
                this.put("bootstrap.servers", $outer.brokerList());
                this.put("confluent.tier.recovery.working.dir", workingDir$1.getAbsolutePath());
                this.put("confluent.tier.recovery.validate", "false");
                this.put("confluent.tier.recovery.materialize", "true");
                this.put("confluent.tier.recovery.dump.events", "false");
                this.put("confluent.tier.recovery.broker.workdir.list", brokerWorkdirList$1.getAbsolutePath());
            }
        });
        props.putAll((Map<?, ?>)((Map)server.tieredStorageInterBrokerClientConfigsSupplier().get()));
        props.store(new PrintWriter(recoveryConfFile), "");
        return recoveryConfFile;
    }

    private void assertTimestampForOffsetLookupCorrect(TopicPartition topicPartition, KafkaConsumer<String, String> consumer, long timestamp, long expectedOffset) {
        HashMap<TopicPartition, Long> timestampsToSearch = new HashMap<TopicPartition, Long>();
        timestampsToSearch.put(topicPartition, Predef$.MODULE$.long2Long(timestamp));
        Assertions.assertEquals((long)((OffsetAndTimestamp)consumer.offsetsForTimes(timestampsToSearch).get(topicPartition)).offset(), (long)expectedOffset, (String)"timestamp should match offset read");
    }

    private void assertTimestampForOffsetLookupMissing(TopicPartition topicPartition, KafkaConsumer<String, String> consumer, long timestamp) {
        HashMap<TopicPartition, Long> timestampsToSearch = new HashMap<TopicPartition, Long>();
        timestampsToSearch.put(topicPartition, Predef$.MODULE$.long2Long(timestamp));
        Assertions.assertEquals(null, consumer.offsetsForTimes(timestampsToSearch).get(topicPartition), (String)"offset should not be returned");
    }

    public static final /* synthetic */ TopicPartition $anonfun$topicPartitions$1(TierIntegrationEndToEndTest $this, int p) {
        return new TopicPartition($this.topic(), p);
    }

    public static final /* synthetic */ boolean $anonfun$validateFenceToolResults$1(TierPartitionState tierPartitionState$1, MergedLog log$1) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$1.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.FROZEN_LOG_START_OFFSET;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && log$1.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$validateFenceToolResults$2() {
        return "timeout waiting for partition to be transitioned to the required status";
    }

    public static final /* synthetic */ boolean $anonfun$validateFenceToolResults$3(TierPartitionState tierPartitionState$1, MergedLog log$1) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$1.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ERROR;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && !log$1.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$validateFenceToolResults$4() {
        return "timeout waiting for partition to be transitioned to the required status";
    }

    public static final /* synthetic */ boolean $anonfun$validateRestoreToolsResults$1(TierPartitionState tierPartitionState$2, MergedLog log$2) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$2.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.FROZEN_LOG_START_OFFSET;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && log$2.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$validateRestoreToolsResults$2() {
        return "log and/or tier partition state is in unexpected status";
    }

    public static final /* synthetic */ boolean $anonfun$validateRestoreToolsResults$3(TierPartitionState tierPartitionState$2, MergedLog log$2) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$2.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && !log$2.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$validateRestoreToolsResults$4() {
        return "log and/or tier partition state is in unexpected status";
    }

    public static final /* synthetic */ RestoreInfo.RestoreRawInput $anonfun$testArchiveAndTierFetchFenceAndRecovery$1(RestoreInfo.RestoreComparatorInput restoreComparatorInput) {
        Assertions.assertTrue((boolean)restoreComparatorInput.choice().validationSuccess());
        return new RestoreInfo.RestoreRawInput(restoreComparatorInput.input(), restoreComparatorInput.choice().path());
    }

    public static final /* synthetic */ boolean $anonfun$testArchiveAndTierFetchFenceAndRecovery$2(FileTierPartitionState tierPartitionState$3, AbstractLog log$3) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$3.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.FROZEN_LOG_START_OFFSET;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && log$3.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$testArchiveAndTierFetchFenceAndRecovery$3() {
        return "log and/or tier partition state is in unexpected status";
    }

    public static final /* synthetic */ boolean $anonfun$testArchiveAndTierFetchFenceAndRecovery$4(FileTierPartitionState tierPartitionState$3, AbstractLog log$3) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$3.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && !log$3.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$testArchiveAndTierFetchFenceAndRecovery$5() {
        return "log and/or tier partition state is in unexpected status";
    }

    public static final /* synthetic */ boolean $anonfun$testArchiveAndTierFetchFenceAndRecovery$6(FileTierPartitionState tierPartitionState$3, AbstractLog log$3) {
        TierPartitionStatus tierPartitionStatus = tierPartitionState$3.status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null) && !log$3.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ String $anonfun$testArchiveAndTierFetchFenceAndRecovery$7() {
        return "timed out waiting for partition to be restored to ONLINE status";
    }

    public static final /* synthetic */ boolean $anonfun$testArchiveAndTierFetchFenceAndRecovery$8(long endOffset$1, FileTierPartitionState tierPartitionState$3) {
        return endOffset$1 < tierPartitionState$3.endOffset();
    }

    public static final /* synthetic */ String $anonfun$testArchiveAndTierFetchFenceAndRecovery$9() {
        return "timeout waiting for endOffset to advance after tiered partition has recovered and more records produced";
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceRecords$2(TierIntegrationEndToEndTest $this, int recordsPerBatch$1, int b$1, long timestamp$1, int i) {
        int m = recordsPerBatch$1 * b$1 + i;
        return new ProducerRecord($this.topic(), null, Predef$.MODULE$.long2Long(timestamp$1), (Object)"foo".getBytes(StandardCharsets.UTF_8), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)m)).getBytes(StandardCharsets.UTF_8));
    }

    public static final /* synthetic */ IndexedSeq $anonfun$produceRecords$1(TierIntegrationEndToEndTest $this, int recordsPerBatch$1, KafkaProducer producer$1, int b) {
        long timestamp = System.currentTimeMillis();
        return (IndexedSeq)((TraversableLike)((IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), recordsPerBatch$1).map((Function1 & Serializable & scala.Serializable)i -> TierIntegrationEndToEndTest.$anonfun$produceRecords$2($this, recordsPerBatch$1, b, timestamp, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> producer$1.send(x$1), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$3 -> (RecordMetadata)x$3.get(10L, TimeUnit.SECONDS), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilSegmentsTiered$2(TierPartitionState tierPartitionState$4, int minNumSegments$1) {
        return tierPartitionState$4.numSegments() > minNumSegments$1 && tierPartitionState$4.endOffset() == tierPartitionState$4.committedEndOffset();
    }

    public static final /* synthetic */ String $anonfun$waitUntilSegmentsTiered$3(int minNumSegments$1) {
        return new StringBuilder(61).append("timeout waiting for at least ").append(minNumSegments$1).append(" to be archived and materialized").toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitUntilSegmentsTiered$1(TierIntegrationEndToEndTest $this, scala.collection.immutable.Map partitionToLeaderMap$1, int minNumSegments$1, TopicPartition tp) {
        int leaderId = $this.getLeaderForTopicPartition(tp, (scala.collection.immutable.Map<Object, Object>)partitionToLeaderMap$1);
        LogManager qual$1 = ((KafkaServer)$this.serverForId(leaderId).get()).logManager();
        boolean x$2 = qual$1.getLog$default$2();
        TierPartitionState tierPartitionState = ((AbstractLog)qual$1.getLog(tp, x$2).get()).tierPartitionState();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationEndToEndTest.$anonfun$waitUntilSegmentsTiered$2(tierPartitionState, minNumSegments$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationEndToEndTest.$anonfun$waitUntilSegmentsTiered$3(minNumSegments$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ void $anonfun$simulateRetention$1(TierIntegrationEndToEndTest $this, scala.collection.immutable.Map partitionToLeaderMap$2, TopicPartition tp) {
        boolean x$2;
        int leaderId = $this.getLeaderForTopicPartition(tp, (scala.collection.immutable.Map<Object, Object>)partitionToLeaderMap$2);
        LogManager qual$1 = ((KafkaServer)$this.serverForId(leaderId).get()).replicaManager().logManager();
        Assertions.assertTrue((((AbstractLog)qual$1.getLog(tp, x$2 = qual$1.getLog$default$2()).get()).deleteOldSegments() > 0 ? 1 : 0) != 0, (String)"tiered segments should have been deleted");
    }

    public static final /* synthetic */ boolean $anonfun$consumeAndValidateTierFetch$3(long timestamp$2, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        boolean bl = x0$1._1$mcJ$sp() >= timestamp$2;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$consumeAndValidateTierFetch$2(TierIntegrationEndToEndTest $this, ArrayList timestampsOffsets$1, TopicPartition topicPartition$1, KafkaConsumer consumer$1, Tuple2 x$4) {
        if (x$4 != null) {
            long timestamp = x$4._1$mcJ$sp();
            long expectedOffset = ((Tuple2)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)timestampsOffsets$1).asScala()).find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationEndToEndTest.$anonfun$consumeAndValidateTierFetch$3(timestamp, x0$1))).get())._2$mcJ$sp();
            $this.assertTimestampForOffsetLookupCorrect(topicPartition$1, (KafkaConsumer<String, String>)consumer$1, timestamp, expectedOffset);
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$consumeAndValidateTierFetch$4(Attribute attr) {
        return BoxesRunTime.unboxToInt((Object)attr.getValue());
    }

    public static final /* synthetic */ int $anonfun$consumeAndValidateTierFetch$5(Attribute attr) {
        return BoxesRunTime.unboxToInt((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$consumeAndValidateTierFetch$6(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$consumeAndValidateTierFetch$7(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$consumeAndValidateTierFetch$8(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ long $anonfun$consumeAndValidateTierFetch$9(Attribute attr) {
        return BoxesRunTime.unboxToLong((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$consumeAndValidateTierFetch$10(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ double $anonfun$consumeAndValidateTierFetch$11(Attribute attr) {
        return BoxesRunTime.unboxToDouble((Object)attr.getValue());
    }

    public static final /* synthetic */ int $anonfun$consumeAndValidateTierFetch$12(Attribute attr) {
        return BoxesRunTime.unboxToInt((Object)attr.getValue());
    }

    public static final /* synthetic */ void $anonfun$consumeAndValidateTierFetch$13(KafkaServer server) {
        MemoryTracker memoryTracker = ((TierFetcher)server.tierFetcherOpt().get()).memoryTracker();
        Assertions.assertEquals((long)0L, (long)memoryTracker.leased(), (String)new StringBuilder(54).append("expected leased TierFetcher memory for broker ").append(server.config().brokerId()).append(" to be 0").toString());
    }

    public TierIntegrationEndToEndTest() {
        this.serverConfig().put(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "5");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierEnableProp(), "false");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "3");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "1");
        this.serverConfig().put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), Integer.toString(Integer.MAX_VALUE));
        this.serverConfig().put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), "0");
        this.serverConfig().put(KafkaConfig$.MODULE$.TierFetcherMemoryPoolSizeBytesProp(), Integer.toString(0x100000));
        this.configureMock();
        this.topic = "test_topic";
        this.partitions = 1;
        this.exited = new AtomicBoolean(false);
    }
}

