/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogManager$;
import kafka.log.LogOffsetsListener;
import kafka.log.LogTestUtils$;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogSegment;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.server.ReplicaManager;
import kafka.tier.TierDeletedPartitionsCoordinator;
import kafka.tier.TierIntegrationTest$;
import kafka.tier.TierReplicaManager;
import kafka.tier.TierTopicManagerCommitter;
import kafka.tier.client.MockConsumerSupplier;
import kafka.tier.client.MockProducerSupplier;
import kafka.tier.fetcher.TierStateFetcher;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreConfig;
import kafka.tier.tasks.TierTasks;
import kafka.tier.tasks.TierTasks$;
import kafka.tier.tasks.TierTasksConfig;
import kafka.tier.tasks.TierTasksConfig$;
import kafka.tier.tasks.archive.AfterUpload;
import kafka.tier.tasks.archive.ArchiveTask;
import kafka.tier.tasks.archive.BeforeLeader;
import kafka.tier.tasks.archive.BeforeUpload;
import kafka.tier.topic.TierTopic;
import kafka.tier.topic.TierTopicAppender;
import kafka.tier.topic.TierTopicConsumer;
import kafka.tier.topic.TierTopicManager;
import kafka.tier.topic.TierTopicManagerConfig;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.ZooKeeperTestHarness$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.easymock.EasyMock;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\ree\u0001B#G\u0001-CQA\u0015\u0001\u0005\u0002MCqA\u0016\u0001C\u0002\u0013%q\u000b\u0003\u0004_\u0001\u0001\u0006I\u0001\u0017\u0005\b?\u0002\u0011\r\u0011\"\u0001a\u0011\u0019y\u0007\u0001)A\u0005C\"9\u0001\u000f\u0001b\u0001\n\u0003\t\bB\u0002=\u0001A\u0003%!\u000fC\u0005z\u0001\u0001\u0007\t\u0019!C\u0001u\"Ia\u0010\u0001a\u0001\u0002\u0004%\ta \u0005\u000b\u0003\u0017\u0001\u0001\u0019!A!B\u0013Y\bbCA\u0007\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u001fA1\"!\b\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002 !Y\u00111\u0005\u0001A\u0002\u0003\u0005\u000b\u0015BA\t\u0011-\t)\u0003\u0001a\u0001\u0002\u0004%\t!a\n\t\u0017\u0005U\u0002\u00011AA\u0002\u0013\u0005\u0011q\u0007\u0005\f\u0003w\u0001\u0001\u0019!A!B\u0013\tI\u0003C\u0006\u0002>\u0001\u0001\r\u00111A\u0005\u0002\u0005}\u0002bCA'\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u001fB1\"a\u0015\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002B!Y\u0011Q\u000b\u0001A\u0002\u0003\u0007I\u0011AA,\u0011-\t)\u0007\u0001a\u0001\u0002\u0004%\t!a\u001a\t\u0017\u0005-\u0004\u00011A\u0001B\u0003&\u0011\u0011\f\u0005\f\u0003[\u0002\u0001\u0019!a\u0001\n\u0003\ty\u0007C\u0006\u0002~\u0001\u0001\r\u00111A\u0005\u0002\u0005}\u0004bCAB\u0001\u0001\u0007\t\u0011)Q\u0005\u0003cB\u0011\"!\"\u0001\u0001\u0004%\t!a\"\t\u0013\u0005=\u0005\u00011A\u0005\u0002\u0005E\u0005\u0002CAK\u0001\u0001\u0006K!!#\t\u0013\u0005]\u0005\u00011A\u0005\u0002\u0005e\u0005\"CAT\u0001\u0001\u0007I\u0011AAU\u0011!\ti\u000b\u0001Q!\n\u0005m\u0005bCAX\u0001\u0001\u0007\t\u0019!C\u0001\u0003cC1\"!5\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002T\"Y\u0011q\u001b\u0001A\u0002\u0003\u0005\u000b\u0015BAZ\u0011-\tI\u000e\u0001a\u0001\u0002\u0004%\t!a7\t\u0017\u0005\r\b\u00011AA\u0002\u0013\u0005\u0011Q\u001d\u0005\f\u0003S\u0004\u0001\u0019!A!B\u0013\ti\u000eC\u0006\u0002l\u0002\u0001\r\u00111A\u0005\u0002\u00055\bb\u0003B\u0004\u0001\u0001\u0007\t\u0019!C\u0001\u0005\u0013A1B!\u0004\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002p\"I!q\u0002\u0001C\u0002\u0013\u0005!\u0011\u0003\u0005\t\u00053\u0001\u0001\u0015!\u0003\u0003\u0014!I!1\u0004\u0001C\u0002\u0013\u0005!Q\u0004\u0005\t\u0005K\u0001\u0001\u0015!\u0003\u0003 !I!q\u0005\u0001C\u0002\u0013\u0005!\u0011\u0006\u0005\t\u0005w\u0001\u0001\u0015!\u0003\u0003,!9!Q\b\u0001\u0005\u0002\t}\u0002b\u0002B$\u0001\u0011\u0005!\u0011\n\u0005\n\u00053\u0002\u0011\u0013!C\u0001\u00057B\u0011B!\u001d\u0001#\u0003%\tAa\u0017\t\u000f\tM\u0004\u0001\"\u0001\u0003v!9!\u0011\u0013\u0001\u0005\u0002\tU\u0004b\u0002BN\u0001\u0011\u0005!Q\u000f\u0005\b\u0005K\u0003A\u0011\u0001B;\u0011\u001d\u0011I\u000b\u0001C\u0001\u0005kBqA!,\u0001\t\u0003\u0011)\bC\u0004\u00032\u0002!\tA!\u001e\t\u000f\tU\u0006\u0001\"\u0003\u00038\"I!q\u0019\u0001\u0012\u0002\u0013%!\u0011\u001a\u0005\b\u0005\u001b\u0004A\u0011\u0002Bh\u0011\u001d\u0011y\u000f\u0001C\u0005\u0005cDqaa\u0001\u0001\t\u0013\u0011)\bC\u0004\u0004\u0006\u0001!Iaa\u0002\t\u000f\r\u0005\u0002\u0001\"\u0003\u0004$!91q\u0005\u0001\u0005\n\r%\u0002bBB!\u0001\u0011%11\t\u0005\b\u0007_\u0002A\u0011BB9\u0011\u001d\u00199\b\u0001C\u0005\u0007s\u00121\u0003V5fe&sG/Z4sCRLwN\u001c+fgRT!a\u0012%\u0002\tQLWM\u001d\u0006\u0002\u0013\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001M!\ti\u0005+D\u0001O\u0015\u0005y\u0015!B:dC2\f\u0017BA)O\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u0016\t\u0003+\u0002i\u0011AR\u0001\t[>\u001c7\u000eV5nKV\t\u0001\f\u0005\u0002Z96\t!L\u0003\u0002\\\u0011\u0006)Q\u000f^5mg&\u0011QL\u0017\u0002\t\u001b>\u001c7\u000eV5nK\u0006IQn\\2l)&lW\rI\u0001\bY><G)\u001b:t+\u0005\t\u0007c\u00012hS6\t1M\u0003\u0002eK\u0006!Q\u000f^5m\u0015\u00051\u0017\u0001\u00026bm\u0006L!\u0001[2\u0003\u0013\u0005\u0013(/Y=MSN$\bC\u00016n\u001b\u0005Y'B\u00017f\u0003\u0011a\u0017M\\4\n\u00059\\'AB*ue&tw-\u0001\u0005m_\u001e$\u0015N]:!\u0003Y!\u0018.\u001a:U_BL7-T1oC\u001e,'oQ8oM&<W#\u0001:\u0011\u0005M4X\"\u0001;\u000b\u0005U4\u0015!\u0002;pa&\u001c\u0017BA<u\u0005Y!\u0016.\u001a:U_BL7-T1oC\u001e,'oQ8oM&<\u0017a\u0006;jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s\u0007>tg-[4!\u0003E!\u0018.\u001a:U_BL7mQ8ogVlWM]\u000b\u0002wB\u00111\u000f`\u0005\u0003{R\u0014\u0011\u0003V5feR{\u0007/[2D_:\u001cX/\\3s\u0003U!\u0018.\u001a:U_BL7mQ8ogVlWM]0%KF$B!!\u0001\u0002\bA\u0019Q*a\u0001\n\u0007\u0005\u0015aJ\u0001\u0003V]&$\b\u0002CA\u0005\u0013\u0005\u0005\t\u0019A>\u0002\u0007a$\u0013'\u0001\nuS\u0016\u0014Hk\u001c9jG\u000e{gn];nKJ\u0004\u0013!\u0005;jKJdunZ\"p[B|g.\u001a8ugV\u0011\u0011\u0011\u0003\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011q\u0003%\u0002\u00071|w-\u0003\u0003\u0002\u001c\u0005U!!\u0005+jKJdunZ\"p[B|g.\u001a8ug\u0006)B/[3s\u0019><7i\\7q_:,g\u000e^:`I\u0015\fH\u0003BA\u0001\u0003CA\u0011\"!\u0003\r\u0003\u0003\u0005\r!!\u0005\u0002%QLWM\u001d'pO\u000e{W\u000e]8oK:$8\u000fI\u0001\bi\u0016l\u0007\u000fR5s+\t\tI\u0003\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r\ty#Z\u0001\u0003S>LA!a\r\u0002.\t!a)\u001b7f\u0003-!X-\u001c9ESJ|F%Z9\u0015\t\u0005\u0005\u0011\u0011\b\u0005\n\u0003\u0013y\u0011\u0011!a\u0001\u0003S\t\u0001\u0002^3na\u0012K'\u000fI\u0001\ni&,'\u000fV1tWN,\"!!\u0011\u0011\t\u0005\r\u0013\u0011J\u0007\u0003\u0003\u000bR1!a\u0012G\u0003\u0015!\u0018m]6t\u0013\u0011\tY%!\u0012\u0003\u0013QKWM\u001d+bg.\u001c\u0018!\u0004;jKJ$\u0016m]6t?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\u0005E\u0003\"CA\u0005%\u0005\u0005\t\u0019AA!\u0003)!\u0018.\u001a:UCN\\7\u000fI\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\t\tI\u0006\u0005\u0003\u0002\\\u0005\u0005TBAA/\u0015\r\ty\u0006S\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005\r\u0014Q\f\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003I\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ|F%Z9\u0015\t\u0005\u0005\u0011\u0011\u000e\u0005\n\u0003\u0013)\u0012\u0011!a\u0001\u00033\nqB]3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\u0010i&,'o\u00142kK\u000e$8\u000b^8sKV\u0011\u0011\u0011\u000f\t\u0005\u0003g\nI(\u0004\u0002\u0002v)\u0019\u0011q\u000f$\u0002\u000bM$xN]3\n\t\u0005m\u0014Q\u000f\u0002\u001c\u001b>\u001c7.\u00138NK6|'/\u001f+jKJ|%M[3diN#xN]3\u0002'QLWM](cU\u0016\u001cGo\u0015;pe\u0016|F%Z9\u0015\t\u0005\u0005\u0011\u0011\u0011\u0005\n\u0003\u0013A\u0012\u0011!a\u0001\u0003c\n\u0001\u0003^5fe>\u0013'.Z2u'R|'/\u001a\u0011\u0002AQLWM\u001d#fY\u0016$X\r\u001a)beRLG/[8og\u000e{wN\u001d3j]\u0006$xN]\u000b\u0003\u0003\u0013\u00032!VAF\u0013\r\tiI\u0012\u0002!)&,'\u000fR3mKR,G\rU1si&$\u0018n\u001c8t\u0007>|'\u000fZ5oCR|'/\u0001\u0013uS\u0016\u0014H)\u001a7fi\u0016$\u0007+\u0019:uSRLwN\\:D_>\u0014H-\u001b8bi>\u0014x\fJ3r)\u0011\t\t!a%\t\u0013\u0005%1$!AA\u0002\u0005%\u0015!\t;jKJ$U\r\\3uK\u0012\u0004\u0016M\u001d;ji&|gn]\"p_J$\u0017N\\1u_J\u0004\u0013\u0001\u0005;jKJ\u001cF/\u0019;f\r\u0016$8\r[3s+\t\tY\n\u0005\u0003\u0002\u001e\u0006\rVBAAP\u0015\r\t\tKR\u0001\bM\u0016$8\r[3s\u0013\u0011\t)+a(\u0003!QKWM]*uCR,g)\u001a;dQ\u0016\u0014\u0018\u0001\u0006;jKJ\u001cF/\u0019;f\r\u0016$8\r[3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\u0005-\u0006\"CA\u0005=\u0005\u0005\t\u0019AAN\u0003E!\u0018.\u001a:Ti\u0006$XMR3uG\",'\u000fI\u0001\u0005Y><7/\u0006\u0002\u00024B1\u0011QWAc\u0003\u0017tA!a.\u0002B:!\u0011\u0011XA`\u001b\t\tYLC\u0002\u0002>*\u000ba\u0001\u0010:p_Rt\u0014\"A(\n\u0007\u0005\rg*A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0017\u0011\u001a\u0002\u0004'\u0016\f(bAAb\u001dB!\u00111CAg\u0013\u0011\ty-!\u0006\u0003\u00135+'oZ3e\u0019><\u0017\u0001\u00037pON|F%Z9\u0015\t\u0005\u0005\u0011Q\u001b\u0005\n\u0003\u0013\t\u0013\u0011!a\u0001\u0003g\u000bQ\u0001\\8hg\u0002\n\u0001\u0003^5feR{\u0007/[2NC:\fw-\u001a:\u0016\u0005\u0005u\u0007cA:\u0002`&\u0019\u0011\u0011\u001d;\u0003!QKWM\u001d+pa&\u001cW*\u00198bO\u0016\u0014\u0018\u0001\u0006;jKJ$v\u000e]5d\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\u0005\u001d\b\"CA\u0005I\u0005\u0005\t\u0019AAo\u0003E!\u0018.\u001a:U_BL7-T1oC\u001e,'\u000fI\u0001\u0011G>t7/^7feN+\b\u000f\u001d7jKJ,\"!a<\u0011\u0011\u0005E\u0018q_A~\u0003wl!!a=\u000b\u0007\u0005Uh)\u0001\u0004dY&,g\u000e^\u0005\u0005\u0003s\f\u0019P\u0001\u000bN_\u000e\\7i\u001c8tk6,'oU;qa2LWM\u001d\t\u0006\u001b\u0006u(\u0011A\u0005\u0004\u0003\u007ft%!B!se\u0006L\bcA'\u0003\u0004%\u0019!Q\u0001(\u0003\t\tKH/Z\u0001\u0015G>t7/^7feN+\b\u000f\u001d7jKJ|F%Z9\u0015\t\u0005\u0005!1\u0002\u0005\n\u0003\u00139\u0013\u0011!a\u0001\u0003_\f\u0011cY8ogVlWM]*vaBd\u0017.\u001a:!\u00035i\u0017\r_,bSR$\u0016.\\3NgV\u0011!1\u0003\t\u0004\u001b\nU\u0011b\u0001B\f\u001d\n\u0019\u0011J\u001c;\u0002\u001d5\f\u0007pV1jiRKW.Z'tA\u0005\u0011B/[3s%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\t\u0011y\u0002E\u0002V\u0005CI1Aa\tG\u0005I!\u0016.\u001a:SKBd\u0017nY1NC:\fw-\u001a:\u0002'QLWM\u001d*fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u00175\u0014U-\u00198TKJ4XM]\u000b\u0003\u0005W\u0001BA!\f\u000385\u0011!q\u0006\u0006\u0005\u0005c\u0011\u0019$\u0001\u0006nC:\fw-Z7f]RT!A!\u000e\u0002\u000b)\fg/\u0019=\n\t\te\"q\u0006\u0002\f\u001b\n+\u0017M\\*feZ,'/\u0001\u0007n\u0005\u0016\fgnU3sm\u0016\u0014\b%A\bdQ\u0016\u001c7n];n\u000b:\f'\r\\3e+\t\u0011\t\u0005E\u0002N\u0005\u0007J1A!\u0012O\u0005\u001d\u0011un\u001c7fC:\fQa]3ukB$b!!\u0001\u0003L\tU\u0003\"\u0003B'aA\u0005\t\u0019\u0001B(\u0003\u001dqW/\u001c'pON\u00042A\u001bB)\u0013\r\u0011\u0019f\u001b\u0002\b\u0013:$XmZ3s\u0011%\u00119\u0006\rI\u0001\u0002\u0004\u0011y%\u0001\nok6\f%o\u00195jm\u0016\u0014H\u000b\u001b:fC\u0012\u001c\u0018aD:fiV\u0004H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tu#\u0006\u0002B(\u0005?Z#A!\u0019\u0011\t\t\r$QN\u0007\u0003\u0005KRAAa\u001a\u0003j\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005Wr\u0015AC1o]>$\u0018\r^5p]&!!q\u000eB3\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0010g\u0016$X\u000f\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u00051!-\u001a4pe\u0016$\"!!\u0001)\u0007M\u0012I\b\u0005\u0003\u0003|\t5UB\u0001B?\u0015\u0011\u0011yH!!\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0003\u0004\n\u0015\u0015a\u00026va&$XM\u001d\u0006\u0005\u0005\u000f\u0013I)A\u0003kk:LGO\u0003\u0002\u0003\f\u0006\u0019qN]4\n\t\t=%Q\u0010\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$wn\u001e8)\u0007Q\u0012)\n\u0005\u0003\u0003|\t]\u0015\u0002\u0002BM\u0005{\u0012\u0011\"\u00114uKJ,\u0015m\u00195\u0002+Q,7\u000f^!sG\"Lg/\u001a:J[6LwM]1uK\"\u001aQGa(\u0011\t\tm$\u0011U\u0005\u0005\u0005G\u0013iH\u0001\u0003UKN$\u0018\u0001\t;fgR\f%o\u00195jm\u0016\u0014X\u000b\u001d7pC\u0012\fe\u000eZ'bi\u0016\u0014\u0018.\u00197ju\u0016D3A\u000eBP\u0003\u0005#Xm\u001d;Be\u000eD\u0017N^3s+Bdw.\u00193B]\u0012l\u0015\r^3sS\u0006d\u0017N_3XQ\u0016twK]5uK\"\u000b\u0007\u000f]3og\u00063G/\u001a:CK\u000e|W.\u001a'fC\u0012,'\u000fK\u00028\u0005?\u000ba\u0006^3ti\u0006\u00138\r[5wKJ,\u0006\u000f\\8bI^KG\u000f\u001b'j[&$X\rZ+qY>\fGmQ8oGV\u0014(/\u001a8ds\"\u001a\u0001Ha(\u0002)Q,7\u000f^!sG\"Lg/\u001a:U_R\fG\u000eT1hQ\rI$qT\u0001\u0013o\u0006LGOR8s\u00136l\u0017n\u001a:bi&|g\u000e\u0006\u0007\u0002\u0002\te&1\u0018B`\u0005\u0003\u0014\u0019\rC\u0004\u00020j\u0002\r!a-\t\u000f\tu&\b1\u0001\u0003\u0014\u0005YA.Z1eKJ,\u0005o\\2i\u0011\u001d\tiD\u000fa\u0001\u0003\u0003Bq!a;;\u0001\u0004\ty\u000fC\u0005\u0003Fj\u0002\n\u00111\u0001\u0003B\u0005a!-Z2p[\u0016dU-\u00193fe\u0006ar/Y5u\r>\u0014\u0018*\\7jOJ\fG/[8oI\u0011,g-Y;mi\u0012*TC\u0001BfU\u0011\u0011\tEa\u0018\u0002=\u0005\u00148\r[5wK\u0006sG-T1uKJL\u0017\r\\5{KVsG/\u001b7UeV,G\u0003CA\u0001\u0005#\u0014YN!<\t\u000f\tMG\b1\u0001\u0003V\u0006!\u0001O]3e!\u0015i%q\u001bB!\u0013\r\u0011IN\u0014\u0002\n\rVt7\r^5p]BBqA!8=\u0001\u0004\u0011y.A\u0002ng\u001e\u0004BA!9\u0003j:!!1\u001dBs!\r\tILT\u0005\u0004\u0005Ot\u0015A\u0002)sK\u0012,g-C\u0002o\u0005WT1Aa:O\u0011\u001d\tY\u000f\u0010a\u0001\u0003_\fAF^1mS\u0012\fG/\u001a)beRLG/[8o'R\fG/Z\"p]R\f\u0017N\\3e\u0013:|%M[3diN#xN]3\u0015\r\u0005\u0005!1\u001fB{\u0011\u001d\ti'\u0010a\u0001\u0003cBq!a,>\u0001\u0004\u00119\u0010\u0005\u0004\u00026\ne(Q`\u0005\u0005\u0005w\fIM\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u0011\t\u0019Ba@\n\t\r\u0005\u0011Q\u0003\u0002\f\u0003\n\u001cHO]1di2{w-A\ntKR,\b\u000fV5fe\u000e{W\u000e]8oK:$8/\u0001\u0006de\u0016\fG/\u001a'pON$\"b!\u0003\u0004\u0010\rM1QDB\u0010!\u0019\t)la\u0003\u0002L&!1QBAe\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\u0005\b\u0007#y\u0004\u0019\u0001B\n\u0003\u0005q\u0007bBB\u000b\u007f\u0001\u00071qC\u0001\nY><7i\u001c8gS\u001e\u0004B!a\u0005\u0004\u001a%!11DA\u000b\u0005%aunZ\"p]\u001aLw\rC\u0004\u0002&}\u0002\r!!\u000b\t\u000f\u00055q\b1\u0001\u0002\u0012\u0005\u0011Rn\\2l%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s)\u0011\tIf!\n\t\u000f\u0005=\u0006\t1\u0001\u0003x\u0006\u0011rO]5uKJ+7m\u001c:e\u0005\u0006$8\r[3t)1\t\taa\u000b\u0004.\r=2\u0011HB\u001f\u0011\u001d\t9\"\u0011a\u0001\u0005{DqA!0B\u0001\u0004\u0011\u0019\u0002C\u0004\u00042\u0005\u0003\raa\r\u0002\u0015\t\f7/Z(gMN,G\u000fE\u0002N\u0007kI1aa\u000eO\u0005\u0011auN\\4\t\u000f\rm\u0012\t1\u0001\u0003\u0014\u00059!-\u0019;dQ\u0016\u001c\bbBB \u0003\u0002\u0007!1C\u0001\u0010e\u0016\u001cwN\u001d3t!\u0016\u0014()\u0019;dQ\u0006i1M]3bi\u0016\u0014VmY8sIN$\"b!\u0012\u0004\\\r\u001d4\u0011NB6!\u0011\u00199ea\u0016\u000e\u0005\r%#\u0002BB&\u0007\u001b\naA]3d_J$'\u0002BB(\u0007#\naaY8n[>t'bA%\u0004T)!1Q\u000bBE\u0003\u0019\t\u0007/Y2iK&!1\u0011LB%\u00055iU-\\8ssJ+7m\u001c:eg\"91Q\f\"A\u0002\r}\u0013A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0007C\u001a\u0019'\u0004\u0002\u0004N%!1QMB'\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:DqA!0C\u0001\u0004\u0011\u0019\u0002C\u0004\u00042\t\u0003\raa\r\t\u000f\r5$\t1\u0001\u0003\u0014\u0005Qa.^7SK\u000e|'\u000fZ:\u0002\u00175,GO]5d-\u0006dW/\u001a\u000b\u0005\u0007g\u0019\u0019\bC\u0004\u0004v\r\u0003\rAa8\u0002\t9\fW.Z\u0001\u0013i&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X\r\u0006\u0003\u0004|\r\u001d\u0005\u0003BB?\u0007\u0007k!aa \u000b\u0007\r\u0005e)A\u0003ti\u0006$X-\u0003\u0003\u0004\u0006\u000e}$A\u0005+jKJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016Dqa!#E\u0001\u0004\u0019y&A\u0005qCJ$\u0018\u000e^5p]\":\u0001a!$\u0004\u0014\u000eU\u0005\u0003\u0002B>\u0007\u001fKAa!%\u0003~\t\u0019A+Y4\u0002\u000bY\fG.^3\"\u0005\r]\u0015aC5oi\u0016<'/\u0019;j_:\u0004")
public class TierIntegrationTest {
    private final MockTime mockTime = new MockTime();
    private final ArrayList<String> logDirs = new ArrayList<String>(Collections.singleton(TestUtils$.MODULE$.tempDir().getAbsolutePath()));
    private final TierTopicManagerConfig tierTopicManagerConfig = new TierTopicManagerConfig(() -> Collections.singletonMap("bootstrap.servers", "bootstrap"), null, 1, 1, 33, "cluster99", Predef$.MODULE$.long2Long(10L), Predef$.MODULE$.int2Integer(500), Predef$.MODULE$.int2Integer(500), this.logDirs());
    private TierTopicConsumer tierTopicConsumer;
    private TierLogComponents tierLogComponents;
    private File tempDir;
    private TierTasks tierTasks;
    private ReplicaManager replicaManager;
    private MockInMemoryTierObjectStore tierObjectStore;
    private TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator = (TierDeletedPartitionsCoordinator)Mockito.mock(TierDeletedPartitionsCoordinator.class);
    private TierStateFetcher tierStateFetcher = (TierStateFetcher)Mockito.mock(TierStateFetcher.class);
    private Seq<MergedLog> logs;
    private TierTopicManager tierTopicManager;
    private MockConsumerSupplier<byte[], byte[]> consumerSupplier;
    private final int maxWaitTimeMs;
    private final TierReplicaManager tierReplicaManager = new TierReplicaManager();
    private final MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();

    private MockTime mockTime() {
        return this.mockTime;
    }

    public ArrayList<String> logDirs() {
        return this.logDirs;
    }

    public TierTopicManagerConfig tierTopicManagerConfig() {
        return this.tierTopicManagerConfig;
    }

    public TierTopicConsumer tierTopicConsumer() {
        return this.tierTopicConsumer;
    }

    public void tierTopicConsumer_$eq(TierTopicConsumer x$1) {
        this.tierTopicConsumer = x$1;
    }

    public TierLogComponents tierLogComponents() {
        return this.tierLogComponents;
    }

    public void tierLogComponents_$eq(TierLogComponents x$1) {
        this.tierLogComponents = x$1;
    }

    public File tempDir() {
        return this.tempDir;
    }

    public void tempDir_$eq(File x$1) {
        this.tempDir = x$1;
    }

    public TierTasks tierTasks() {
        return this.tierTasks;
    }

    public void tierTasks_$eq(TierTasks x$1) {
        this.tierTasks = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public MockInMemoryTierObjectStore tierObjectStore() {
        return this.tierObjectStore;
    }

    public void tierObjectStore_$eq(MockInMemoryTierObjectStore x$1) {
        this.tierObjectStore = x$1;
    }

    public TierDeletedPartitionsCoordinator tierDeletedPartitionsCoordinator() {
        return this.tierDeletedPartitionsCoordinator;
    }

    public void tierDeletedPartitionsCoordinator_$eq(TierDeletedPartitionsCoordinator x$1) {
        this.tierDeletedPartitionsCoordinator = x$1;
    }

    public TierStateFetcher tierStateFetcher() {
        return this.tierStateFetcher;
    }

    public void tierStateFetcher_$eq(TierStateFetcher x$1) {
        this.tierStateFetcher = x$1;
    }

    public Seq<MergedLog> logs() {
        return this.logs;
    }

    public void logs_$eq(Seq<MergedLog> x$1) {
        this.logs = x$1;
    }

    public TierTopicManager tierTopicManager() {
        return this.tierTopicManager;
    }

    public void tierTopicManager_$eq(TierTopicManager x$1) {
        this.tierTopicManager = x$1;
    }

    public MockConsumerSupplier<byte[], byte[]> consumerSupplier() {
        return this.consumerSupplier;
    }

    public void consumerSupplier_$eq(MockConsumerSupplier<byte[], byte[]> x$1) {
        this.consumerSupplier = x$1;
    }

    public int maxWaitTimeMs() {
        return this.maxWaitTimeMs;
    }

    public TierReplicaManager tierReplicaManager() {
        return this.tierReplicaManager;
    }

    public MBeanServer mBeanServer() {
        return this.mBeanServer;
    }

    public boolean checksumEnabled() {
        return false;
    }

    public void setup(Integer numLogs, Integer numArchiverThreads) {
        this.tierObjectStore_$eq(new MockInMemoryTierObjectStore((Time)this.mockTime(), new TierObjectStoreConfig("cluster", Predef$.MODULE$.int2Integer(1))));
        this.setupTierComponents();
        int x$1 = 150;
        int x$2 = 1;
        int x$3 = 65536;
        boolean x$4 = true;
        long x$5 = LogTestUtils$.MODULE$.createLogConfig$default$1();
        long x$6 = LogTestUtils$.MODULE$.createLogConfig$default$3();
        long x$7 = LogTestUtils$.MODULE$.createLogConfig$default$4();
        long x$8 = LogTestUtils$.MODULE$.createLogConfig$default$5();
        String x$9 = LogTestUtils$.MODULE$.createLogConfig$default$6();
        int x$10 = LogTestUtils$.MODULE$.createLogConfig$default$9();
        String x$11 = LogTestUtils$.MODULE$.createLogConfig$default$10();
        long x$12 = LogTestUtils$.MODULE$.createLogConfig$default$11();
        long x$13 = LogTestUtils$.MODULE$.createLogConfig$default$13();
        long x$14 = LogTestUtils$.MODULE$.createLogConfig$default$14();
        int x$15 = LogTestUtils$.MODULE$.createLogConfig$default$15();
        long x$16 = LogTestUtils$.MODULE$.createLogConfig$default$16();
        LogConfig logConfig = LogTestUtils$.MODULE$.createLogConfig(x$5, x$1, x$6, x$7, x$8, x$9, x$3, x$2, x$10, x$11, x$12, x$4, x$13, x$14, x$15, x$16);
        File tempDir = TestUtils$.MODULE$.tempDir();
        IndexedSeq<MergedLog> logs = this.createLogs(Predef$.MODULE$.Integer2int(numLogs), logConfig, tempDir, this.tierLogComponents());
        ReplicaManager replicaManager = this.mockReplicaManager((Iterable<AbstractLog>)logs);
        int x$17 = Predef$.MODULE$.Integer2int(numArchiverThreads);
        int x$18 = 20;
        int x$19 = 20;
        int x$20 = 1;
        long x$21 = TierTasksConfig$.MODULE$.apply$default$3();
        long x$22 = TierTasksConfig$.MODULE$.apply$default$4();
        int x$23 = TierTasksConfig$.MODULE$.apply$default$5();
        TierTasks tierTasks = new TierTasks(new TierTasksConfig(x$17, x$20, x$21, x$22, x$23, x$18, x$19), replicaManager, this.tierReplicaManager(), this.tierDeletedPartitionsCoordinator(), (TierTopicAppender)this.tierTopicManager(), (TierObjectStore)this.tierObjectStore(), (Time)this.mockTime());
        this.tierTasks_$eq(tierTasks);
        this.replicaManager_$eq(replicaManager);
        this.logs_$eq((Seq<MergedLog>)logs);
        this.tempDir_$eq(tempDir);
    }

    public Integer setup$default$1() {
        return Predef$.MODULE$.int2Integer(2);
    }

    public Integer setup$default$2() {
        return Predef$.MODULE$.int2Integer(10);
    }

    @BeforeEach
    public void before() {
        ZooKeeperTestHarness$.MODULE$.verifyNoUnexpectedThreads("@Before");
    }

    @AfterEach
    public void teardown() {
        this.tierTasks().shutdown();
        this.tierTopicManager().shutdown();
        this.tierTopicConsumer().shutdown();
        ReplicaManager qual$1 = this.replicaManager();
        boolean x$12 = qual$1.shutdown$default$1();
        qual$1.shutdown(x$12);
        this.tierObjectStore().close();
        this.logs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(this.logDirs()).asScala()).foreach((Function1 & Serializable & scala.Serializable)path -> {
            TierIntegrationTest.$anonfun$teardown$2(path);
            return BoxedUnit.UNIT;
        });
        ZooKeeperTestHarness$.MODULE$.verifyNoUnexpectedThreads("@After");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testArchiverImmigrate() {
        this.setup(this.setup$default$1(), this.setup$default$2());
        this.tierTasks().start();
        this.waitForImmigration(this.logs(), 1, this.tierTasks(), this.consumerSupplier(), this.waitForImmigration$default$5());
        this.tierReplicaManager().becomeFollower(this.tierPartitionState(((MergedLog)this.logs().head()).topicPartition()));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 2000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$testArchiverImmigrate$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationTest.$anonfun$testArchiverImmigrate$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.tierReplicaManager().becomeLeader(this.tierPartitionState(((MergedLog)this.logs().head()).topicPartition()), 2);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 2000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$testArchiverImmigrate$4(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationTest.$anonfun$testArchiverImmigrate$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testArchiverUploadAndMaterialize() {
        void archiveAndMaterializeUntilTrue_consumerSupplier;
        void archiveAndMaterializeUntilTrue_consumerSupplier2;
        void archiveAndMaterializeUntilTrue_consumerSupplier3;
        this.setup(Predef$.MODULE$.int2Integer(10), this.setup$default$2());
        this.tierTasks().start();
        int numBatches = 6;
        int leaderEpoch = 1;
        this.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, leaderEpoch, 0L, numBatches, 4);
            return BoxedUnit.UNIT;
        });
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.consumerSupplier(), this.waitForImmigration$default$5());
        this.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$2(leaderEpoch, log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String string = "Should materialize segments";
        JFunction0.mcZ.sp & Serializable & scala.Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.logs().forall((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$4(log)));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = this.maxWaitTimeMs();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier3, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            void archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)((String)archiveAndMaterializeUntilTrue_msg));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        this.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$5(log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier2 = this.consumerSupplier();
        String string2 = "Should materialize segments";
        JFunction0.mcZ.sp & Serializable & scala.Serializable archiveAndMaterializeUntilTrue_pred2 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.logs().forall((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$7(log)));
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = this.maxWaitTimeMs();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier2, (Function0)archiveAndMaterializeUntilTrue_pred2)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            void archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime2 + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)((String)archiveAndMaterializeUntilTrue_msg));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        this.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$8(log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier3 = this.consumerSupplier();
        String string3 = "Should materialize segments";
        JFunction0.mcZ.sp & Serializable & scala.Serializable archiveAndMaterializeUntilTrue_pred3 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.logs().forall((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$10(log)));
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = this.maxWaitTimeMs();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred3)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            void archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime3 + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)((String)archiveAndMaterializeUntilTrue_msg));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        this.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverUploadAndMaterialize$11(log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader() {
        void archiveAndMaterializeUntilTrue_consumerSupplier;
        this.setup(Predef$.MODULE$.int2Integer(10), this.setup$default$2());
        this.tierTasks().start();
        int leaderEpoch = 1;
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.consumerSupplier(), this.waitForImmigration$default$5());
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
        this.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, leaderEpoch, 0L, 6, 4);
            return BoxedUnit.UNIT;
        });
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String archiveAndMaterializeUntilTrue_msg = "Should materialize segments";
        JFunction0.mcZ.sp & Serializable & scala.Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.logs().forall((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader$3(log)));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = this.maxWaitTimeMs();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            void archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)archiveAndMaterializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        this.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader$4(log);
            return BoxedUnit.UNIT;
        });
        this.validatePartitionStateContainedInObjectStore(this.tierObjectStore(), (Iterable<AbstractLog>)this.logs());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testArchiverUploadWithLimitedUploadConcurrency() {
        void archiveAndMaterializeUntilTrue_consumerSupplier;
        int maxConcurrentUploads = 2;
        int nLogs = 3;
        this.setup(Predef$.MODULE$.int2Integer(nLogs), Predef$.MODULE$.int2Integer(maxConcurrentUploads));
        this.tierTasks().start();
        int batches = 3;
        int recordsPerBatch = 4;
        int leaderEpoch = 1;
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.consumerSupplier(), this.waitForImmigration$default$5());
        this.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, leaderEpoch, 0L, batches, recordsPerBatch);
            return BoxedUnit.UNIT;
        });
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String string = "Expected all logs to eventually become tiered";
        JFunction0.mcZ.sp & Serializable & scala.Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.logs().forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadWithLimitedUploadConcurrency$3(x$3))) && this.logs().forall((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverUploadWithLimitedUploadConcurrency$4(log)));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = this.maxWaitTimeMs();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            void archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)((String)archiveAndMaterializeUntilTrue_msg));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
    }

    @Test
    public void testArchiverTotalLag() {
        int numLogs = 5;
        int batches = 6;
        int recordsPerBatch = 4;
        int leaderEpoch = 1;
        this.setup(Predef$.MODULE$.int2Integer(numLogs), this.setup$default$2());
        this.tierTasks().start();
        Assertions.assertEquals((long)0L, (long)this.totalLag$1());
        this.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            TierIntegrationTest.$anonfun$testArchiverTotalLag$5(this, leaderEpoch, log);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)0L, (long)this.totalLag$1());
        this.logs().foreach((Function1 & Serializable & scala.Serializable)log -> {
            this.writeRecordBatches((AbstractLog)log, leaderEpoch, 0L, batches, recordsPerBatch);
            return BoxedUnit.UNIT;
        });
        this.mockTime().sleep(TierTasks$.MODULE$.PERIODIC_LOG_LAG_MS() + 1);
        this.tierTasks().maybeLogTierArchiverLagInfo();
        Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.logs().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)TierIntegrationTest.$anonfun$testArchiverTotalLag$7(x$6)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), (long)this.totalLag$1());
        this.waitForImmigration(this.logs(), leaderEpoch, this.tierTasks(), this.consumerSupplier(), false);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), batches).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)archivedBatches -> this.awaitMaterializeBatchAndAssertLag$1(archivedBatches));
    }

    /*
     * WARNING - void declaration
     */
    private void waitForImmigration(Seq<MergedLog> logs, int leaderEpoch, TierTasks tierTasks, MockConsumerSupplier<byte[], byte[]> consumerSupplier, boolean becomeLeader) {
        if (becomeLeader) {
            logs.foreach((Function1 & Serializable & scala.Serializable)log -> {
                TierIntegrationTest.$anonfun$waitForImmigration$1(this, leaderEpoch, log);
                return BoxedUnit.UNIT;
            });
        }
        String string = "Expect leadership to materialize";
        JFunction0.mcZ.sp & Serializable & scala.Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> logs.forall((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$waitForImmigration$3(x$8)));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = this.maxWaitTimeMs();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            void archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                void archiveAndMaterializeUntilTrue_msg;
                Assertions.fail((String)((String)archiveAndMaterializeUntilTrue_msg));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$waitForImmigration$4(this, consumerSupplier, tierTasks, logs)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationTest.$anonfun$waitForImmigration$7(tierTasks));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private boolean waitForImmigration$default$5() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void archiveAndMaterializeUntilTrue(Function0<Object> pred, String msg, MockConsumerSupplier<byte[], byte[]> consumerSupplier) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = this.maxWaitTimeMs();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, consumerSupplier, pred)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private void validatePartitionStateContainedInObjectStore(MockInMemoryTierObjectStore tierObjectStore, Iterable<AbstractLog> logs) {
        logs.foreach((Function1 & Serializable & scala.Serializable)log -> {
            TierIntegrationTest.$anonfun$validatePartitionStateContainedInObjectStore$1(tierObjectStore, log);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private void setupTierComponents() {
        MockProducerSupplier producerSupplier = new MockProducerSupplier();
        this.consumerSupplier_$eq(new MockConsumerSupplier<byte[], byte[]>("primary", TierTopicManager.partitions((String)TierTopic.topicName((String)this.tierTopicManagerConfig().tierNamespace), (int)this.tierTopicManagerConfig().configuredNumPartitions), producerSupplier.producer()));
        Supplier<AdminZkClient> adminZkClientSupplier = new Supplier<AdminZkClient>(null){

            public AdminZkClient get() {
                return (AdminZkClient)Mockito.mock(AdminZkClient.class);
            }
        };
        this.tierTopicConsumer_$eq(new TierTopicConsumer(this.tierTopicManagerConfig(), this.consumerSupplier(), this.consumerSupplier(), new TierTopicManagerCommitter(this.tierTopicManagerConfig(), (LogDirFailureChannel)EasyMock.mock(LogDirFailureChannel.class)), this.tierStateFetcher(), Optional.empty(), (Time)this.mockTime()));
        this.tierTopicManager_$eq(new TierTopicManager(this.tierTopicManagerConfig(), this.tierTopicConsumer(), producerSupplier, (Supplier)adminZkClientSupplier));
        this.tierLogComponents_$eq(new TierLogComponents((Option)new Some((Object)this.tierTopicConsumer()), (Option)new Some((Object)this.tierObjectStore()), new TierPartitionStateFactory(true, this.checksumEnabled())));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$setupTierComponents$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierIntegrationTest.$anonfun$setupTierComponents$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private IndexedSeq<MergedLog> createLogs(int n, LogConfig logConfig, File tempDir, TierLogComponents tierLogComponents) {
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(n);
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).map((Function1 & Serializable & scala.Serializable)i -> TierIntegrationTest.$anonfun$createLogs$1(this, tempDir, logConfig, logDirFailureChannel, tierLogComponents, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    private ReplicaManager mockReplicaManager(Iterable<AbstractLog> logs) {
        void var2_2;
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getLog((TopicPartition)ArgumentMatchers.any(TopicPartition.class))).thenAnswer((Answer)new Answer<Option<AbstractLog>>(null, logs){
            private final Iterable logs$2;

            public Option<AbstractLog> answer(InvocationOnMock invocation) {
                TopicPartition target = (TopicPartition)invocation.getArgument(0);
                return this.logs$2.find((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToBoolean((boolean)$anon$2.$anonfun$answer$1(target, log)));
            }

            public static final /* synthetic */ boolean $anonfun$answer$1(TopicPartition target$1, AbstractLog log) {
                TopicPartition topicPartition = log.topicPartition();
                return !(topicPartition != null ? !topicPartition.equals(target$1) : target$1 != null);
            }
            {
                this.logs$2 = logs$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$answer$1$adapted(org.apache.kafka.common.TopicPartition kafka.log.AbstractLog )}, serializedLambda);
            }
        });
        Iterable partitions = (Iterable)logs.map((Function1 & Serializable & scala.Serializable)log -> {
            void var2_2;
            Partition partition = (Partition)Mockito.mock(Partition.class);
            Mockito.when((Object)partition.log()).thenReturn((Object)new Some(log));
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isUncleanLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
            Mockito.when((Object)replicaManager.getPartitionOrError(log.topicPartition())).thenReturn((Object)package$.MODULE$.Right().apply((Object)partition));
            return var2_2;
        }, Iterable$.MODULE$.canBuildFrom());
        Mockito.when((Object)replicaManager.leaderPartitionsIterator()).thenAnswer(x$10 -> partitions.iterator());
        return var2_2;
    }

    private void writeRecordBatches(AbstractLog log, int leaderEpoch, long baseOffset, int batches, int recordsPerBatch) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), batches).foreach((Function1 & Serializable & scala.Serializable)idx -> TierIntegrationTest.$anonfun$writeRecordBatches$1(this, log, leaderEpoch, baseOffset, recordsPerBatch, BoxesRunTime.unboxToInt((Object)idx)));
        log.flush();
        log.updateHighWatermark((long)(batches * recordsPerBatch));
    }

    private MemoryRecords createRecords(TopicPartition topicPartition, int leaderEpoch, long baseOffset, int numRecords) {
        scala.collection.immutable.IndexedSeq recList = (scala.collection.immutable.IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)x$11 -> TierIntegrationTest.$anonfun$createRecords$1(BoxesRunTime.unboxToInt((Object)x$11)), IndexedSeq$.MODULE$.canBuildFrom());
        byte x$3 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.records$default$3();
        long x$5 = TestUtils$.MODULE$.records$default$4();
        short x$6 = TestUtils$.MODULE$.records$default$5();
        int x$7 = TestUtils$.MODULE$.records$default$6();
        int x$8 = TestUtils$.MODULE$.records$default$8();
        MemoryRecords records = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)recList, x$3, x$4, x$5, x$6, x$7, baseOffset, x$8);
        ByteBuffer filtered = ByteBuffer.allocate(100 * numRecords);
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.setPartitionLeaderEpoch(leaderEpoch);
            return BoxedUnit.UNIT;
        });
        records.filterTo(topicPartition, new MemoryRecords.RecordFilter(null){

            public MemoryRecords.RecordFilter.BatchRetention checkBatchRetention(RecordBatch batch) {
                return MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY;
            }

            public boolean shouldRetainRecord(RecordBatch recordBatch, Record record) {
                return true;
            }
        }, filtered, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
        filtered.flip();
        return MemoryRecords.readableRecords((ByteBuffer)filtered);
    }

    private long metricValue(String name) {
        return BoxesRunTime.unboxToLong((Object)((Gauge)((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$metricValue$1(name, x$13)))).values().head()).value());
    }

    private TierPartitionState tierPartitionState(TopicPartition partition) {
        return (TierPartitionState)this.logs().find((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$tierPartitionState$1(partition, x$14))).map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.tierPartitionState()).get();
    }

    public static final /* synthetic */ void $anonfun$teardown$2(String path) {
        Utils.delete((File)new File(path));
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverImmigrate$2(Set x$2) {
        return x$2.size() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverImmigrate$1(TierIntegrationTest $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.tierTasks().archiverTaskQueue().withAllTasks((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverImmigrate$2(x$2))));
    }

    public static final /* synthetic */ String $anonfun$testArchiverImmigrate$3() {
        return "Archiver should process pending emigrations";
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverImmigrate$6(ArchiveTask task) {
        return task.state() instanceof BeforeUpload || task.state() instanceof AfterUpload;
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverImmigrate$4(TierIntegrationTest $this) {
        $this.consumerSupplier().moveRecordsFromProducer();
        $this.tierTopicConsumer().doWork();
        return BoxesRunTime.unboxToBoolean((Object)$this.tierTasks().archiverTaskQueue().withAllTasks((Function1 & Serializable & scala.Serializable)tasks -> BoxesRunTime.boxToBoolean((boolean)tasks.forall((Function1 & Serializable & scala.Serializable)task -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverImmigrate$6(task))))));
    }

    public static final /* synthetic */ String $anonfun$testArchiverImmigrate$7() {
        return "Archiver should process pending immigrations";
    }

    public static final /* synthetic */ void $anonfun$testArchiverUploadAndMaterialize$2(int leaderEpoch$1, MergedLog log) {
        Assertions.assertEquals((int)log.tierPartitionState().tierEpoch(), (int)leaderEpoch$1, (String)new StringBuilder(43).append("topic manager should materialize entry for ").append(log.topicPartition()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadAndMaterialize$4(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() >= 1;
    }

    public static final /* synthetic */ void $anonfun$testArchiverUploadAndMaterialize$5(MergedLog log) {
        Assertions.assertEquals((long)0L, (long)((TierLogSegment)log.tierPartitionState().metadata(0L).get()).baseOffset(), (String)"batch 1: segment should be materialized with correct offset relationship");
        Assertions.assertTrue((log.tierPartitionState().committedEndOffset() >= 3L ? 1 : 0) != 0, (String)"batch 1: segment should be materialized with correct end offset");
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadAndMaterialize$7(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() >= 2 && tierPartitionState.committedEndOffset() == tierPartitionState.endOffset();
    }

    public static final /* synthetic */ void $anonfun$testArchiverUploadAndMaterialize$8(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        Assertions.assertEquals((long)4L, (long)((TierLogSegment)tierPartitionState.metadata(6L).get()).baseOffset(), (String)"batch 2: segment should be materialized with correct offset relationship");
        Assertions.assertTrue((tierPartitionState.committedEndOffset() >= 7L ? 1 : 0) != 0, (String)"batch 2: segment should be materialized with correct end offset");
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadAndMaterialize$10(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() >= 3 && tierPartitionState.committedEndOffset() == tierPartitionState.endOffset();
    }

    public static final /* synthetic */ void $anonfun$testArchiverUploadAndMaterialize$11(MergedLog log) {
        Assertions.assertEquals((long)8L, (long)((TierLogSegment)log.tierPartitionState().metadata(10L).get()).baseOffset(), (String)"batch 3: segment should be materialized with correct offset relationship");
        Assertions.assertTrue((log.tierPartitionState().committedEndOffset() >= 11L ? 1 : 0) != 0, (String)"batch 3: segment should be materialized with correct end offset");
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader$3(MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() > 0 && tierPartitionState.committedEndOffset() == tierPartitionState.endOffset();
    }

    public static final /* synthetic */ void $anonfun$testArchiverUploadAndMaterializeWhenWriteHappensAfterBecomeLeader$4(MergedLog log) {
        Assertions.assertEquals((long)0L, (long)((TierLogSegment)log.tierPartitionState().metadata(0L).get()).baseOffset(), (String)"Segment should be materialized with correct offset relationship");
        Assertions.assertTrue((log.tierPartitionState().committedEndOffset() >= 3L ? 1 : 0) != 0, (String)"Segment should be materialized with correct end offset");
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadWithLimitedUploadConcurrency$3(MergedLog x$3) {
        return x$3.tierableLogSegments().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverUploadWithLimitedUploadConcurrency$4(MergedLog log) {
        return log.tieredLogSegments().nonEmpty();
    }

    private final long totalLag$1() {
        return this.metricValue("TotalLag");
    }

    public static final /* synthetic */ boolean $anonfun$testArchiverTotalLag$2(int archivedBatches$1, MergedLog log) {
        TierPartitionState tierPartitionState = log.tierPartitionState();
        tierPartitionState.flush();
        return tierPartitionState.numSegments() >= archivedBatches$1 && tierPartitionState.committedEndOffset() == tierPartitionState.endOffset();
    }

    public static final /* synthetic */ int $anonfun$testArchiverTotalLag$3(MergedLog x$4) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)x$4.tierableLogSegments().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    private final void awaitMaterializeBatchAndAssertLag$1(int archivedBatches) {
        void archiveAndMaterializeUntilTrue_consumerSupplier;
        MockConsumerSupplier<byte[], byte[]> mockConsumerSupplier = this.consumerSupplier();
        String archiveAndMaterializeUntilTrue_msg = new StringBuilder(49).append("Should materialize segments for batch ").append(archivedBatches).append(" or greater").toString();
        JFunction0.mcZ.sp & Serializable & scala.Serializable archiveAndMaterializeUntilTrue_pred = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.logs().forall((Function1 & Serializable & scala.Serializable)log -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$testArchiverTotalLag$2(archivedBatches, log)));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = this.maxWaitTimeMs();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long archiveAndMaterializeUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierIntegrationTest.$anonfun$archiveAndMaterializeUntilTrue$1(this, (MockConsumerSupplier)archiveAndMaterializeUntilTrue_consumerSupplier, (Function0)archiveAndMaterializeUntilTrue_pred)) {
            void archiveAndMaterializeUntilTrue_waitUntilTrue_pause;
            void archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > archiveAndMaterializeUntilTrue_waitUntilTrue_startTime + archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)archiveAndMaterializeUntilTrue_msg);
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)archiveAndMaterializeUntilTrue_waitUntilTrue_waitTimeMs), (long)archiveAndMaterializeUntilTrue_waitUntilTrue_pause));
        }
        this.mockTime().sleep(TierTasks$.MODULE$.PERIODIC_LOG_LAG_MS() + 1);
        this.tierTasks().maybeLogTierArchiverLagInfo();
        Assertions.assertEquals((long)BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.logs().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)TierIntegrationTest.$anonfun$testArchiverTotalLag$3(x$4)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)), (long)this.totalLag$1());
    }

    public static final /* synthetic */ void $anonfun$testArchiverTotalLag$5(TierIntegrationTest $this, int leaderEpoch$4, MergedLog log) {
        log.assignTopicId(Uuid.randomUuid(), log.assignTopicId$default$2());
        $this.tierReplicaManager().becomeLeader(log.tierPartitionState(), leaderEpoch$4);
    }

    public static final /* synthetic */ int $anonfun$testArchiverTotalLag$7(MergedLog x$6) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)x$6.tierableLogSegments().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$waitForImmigration$1(TierIntegrationTest $this, int leaderEpoch$5, MergedLog log) {
        log.assignTopicId(Uuid.randomUuid(), log.assignTopicId$default$2());
        $this.tierReplicaManager().becomeLeader(log.tierPartitionState(), leaderEpoch$5);
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$3(MergedLog x$8) {
        TierPartitionStatus tierPartitionStatus = x$8.tierPartitionState().status();
        TierPartitionStatus tierPartitionStatus2 = TierPartitionStatus.ONLINE;
        return !(tierPartitionStatus != null ? !tierPartitionStatus.equals(tierPartitionStatus2) : tierPartitionStatus2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$6(ArchiveTask x$9) {
        return x$9.state() instanceof BeforeLeader;
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$5(Seq logs$1, Set tasks) {
        return tasks.size() == logs$1.size() && !tasks.forall((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$waitForImmigration$6(x$9)));
    }

    public static final /* synthetic */ boolean $anonfun$waitForImmigration$4(TierIntegrationTest $this, MockConsumerSupplier consumerSupplier$1, TierTasks tierTasks$1, Seq logs$1) {
        consumerSupplier$1.moveRecordsFromProducer();
        $this.tierTopicConsumer().doWork();
        return BoxesRunTime.unboxToBoolean((Object)tierTasks$1.archiverTaskQueue().withAllTasks((Function1 & Serializable & scala.Serializable)tasks -> BoxesRunTime.boxToBoolean((boolean)TierIntegrationTest.$anonfun$waitForImmigration$5(logs$1, tasks))));
    }

    public static final /* synthetic */ String $anonfun$waitForImmigration$7(TierTasks tierTasks$1) {
        return new StringBuilder(28).append("Expect zero BeforeLeader in ").append(tierTasks$1.archiverTaskQueue()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$archiveAndMaterializeUntilTrue$1(TierIntegrationTest $this, MockConsumerSupplier consumerSupplier$2, Function0 pred$1) {
        consumerSupplier$2.moveRecordsFromProducer();
        $this.tierTopicConsumer().doWork();
        return pred$1.apply$mcZ$sp();
    }

    public static final /* synthetic */ void $anonfun$validatePartitionStateContainedInObjectStore$2(MockInMemoryTierObjectStore tierObjectStore$1, TierLogSegment tierSegment) {
        Assertions.assertNotNull((Object)tierObjectStore$1.getObject((TierObjectStore.ObjectStoreMetadata)tierSegment.metadata(), TierObjectStore.FileType.SEGMENT, Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1000)));
    }

    public static final /* synthetic */ void $anonfun$validatePartitionStateContainedInObjectStore$1(MockInMemoryTierObjectStore tierObjectStore$1, AbstractLog log) {
        ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(log.tierPartitionState().segments()).asScala()).foreach((Function1 & Serializable & scala.Serializable)tierSegment -> {
            TierIntegrationTest.$anonfun$validatePartitionStateContainedInObjectStore$2(tierObjectStore$1, tierSegment);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$setupTierComponents$1(TierIntegrationTest $this) {
        $this.tierTopicManager().tryBecomeReady(false);
        return $this.tierTopicManager().isReady();
    }

    public static final /* synthetic */ String $anonfun$setupTierComponents$2() {
        return "Timed out waiting for TierTopicManager to be ready";
    }

    public static final /* synthetic */ MergedLog $anonfun$createLogs$1(TierIntegrationTest $this, File tempDir$1, LogConfig logConfig$1, LogDirFailureChannel logDirFailureChannel$1, TierLogComponents tierLogComponents$1, int i) {
        File logDir = tempDir$1.toPath().resolve(new StringBuilder(12).append("tierlogtest-").append(i).toString()).toFile();
        logDir.mkdir();
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = $this.mockTime().scheduler();
        BrokerTopicStats x$6 = new BrokerTopicStats();
        Metrics x$7 = new Metrics();
        MockTime x$8 = $this.mockTime();
        int x$9 = 3600000;
        int x$10 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        boolean x$13 = true;
        boolean x$14 = true;
        None$ x$15 = None$.MODULE$;
        None$ x$16 = None$.MODULE$;
        LogOffsetsListener x$17 = MergedLog$.MODULE$.apply$default$16();
        return MergedLog$.MODULE$.apply(logDir, logConfig$1, x$3, x$4, (Scheduler)x$5, x$6, x$7, (Time)x$8, x$9, x$10, logDirFailureChannel$1, tierLogComponents$1, x$13, (Option)x$15, x$14, x$17, (Option)x$16);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$writeRecordBatches$1(TierIntegrationTest $this, AbstractLog log$1, int leaderEpoch$6, long baseOffset$1, int recordsPerBatch$3, int idx) {
        MemoryRecords records = $this.createRecords(log$1.topicPartition(), leaderEpoch$6, baseOffset$1 + (long)(idx * recordsPerBatch$3), recordsPerBatch$3);
        return log$1.appendAsFollower(records);
    }

    public static final /* synthetic */ SimpleRecord $anonfun$createRecords$1(int x$11) {
        return new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes());
    }

    public static final /* synthetic */ boolean $anonfun$metricValue$1(String name$1, Tuple2 x$13) {
        String string = ((MetricName)x$13._1()).getName();
        return !(string != null ? !string.equals(name$1) : name$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$tierPartitionState$1(TopicPartition partition$1, MergedLog x$14) {
        TopicPartition topicPartition = x$14.topicPartition();
        return !(topicPartition != null ? !topicPartition.equals(partition$1) : partition$1 != null);
    }

    public TierIntegrationTest() {
        this.maxWaitTimeMs = 20000;
    }
}

