/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\u0005ud\u0001B\r\u001b\u0001}AQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013%\u0011\u0007\u0003\u00049\u0001\u0001\u0006IA\r\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019\u0019\u0005\u0001)A\u0005w!9A\t\u0001b\u0001\n\u0013\t\u0004BB#\u0001A\u0003%!\u0007C\u0005G\u0001\u0001\u0007\t\u0019!C\u0005\u000f\"I1\f\u0001a\u0001\u0002\u0004%I\u0001\u0018\u0005\nE\u0002\u0001\r\u0011!Q!\n!C\u0011b\u0013\u0001A\u0002\u0003\u0007I\u0011B$\t\u0013\r\u0004\u0001\u0019!a\u0001\n\u0013!\u0007\"\u00034\u0001\u0001\u0004\u0005\t\u0015)\u0003I\u0011%9\u0007\u00011AA\u0002\u0013%\u0001\u000eC\u0005o\u0001\u0001\u0007\t\u0019!C\u0005_\"I\u0011\u000f\u0001a\u0001\u0002\u0003\u0006K!\u001b\u0005\u0006e\u0002!\t&\r\u0005\u0006g\u0002!\t\u0005\u001e\u0005\b\u0003\u000f\u0001A\u0011IA\u0005\u0011\u001d\ty\u0002\u0001C!\u0003\u0013Aq!!\u000b\u0001\t\u0013\tY\u0003C\u0004\u0002<\u0001!I!!\u0010\t\u000f\u0005m\u0003\u0001\"\u0003\u0002^!9\u0011Q\r\u0001\u0005\u0002\u0005%!\u0001\t+jKJ\u0004&o\u001c3vG\u0016\u00148\u000b^1uKJ+\u0007\u000f\\5dCRLwN\u001c+fgRT!a\u0007\u000f\u0002\tQLWM\u001d\u0006\u0002;\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001!MA\u0011\u0011\u0005J\u0007\u0002E)\u00111\u0005H\u0001\u0004CBL\u0017BA\u0013#\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\bCA\u0014+\u001b\u0005A#BA\u0015\u001d\u0003\u0015)H/\u001b7t\u0013\tY\u0003FA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005q\u0003CA\u0018\u0001\u001b\u0005Q\u0012\u0001D:fO6,g\u000e\u001e\"zi\u0016\u001cX#\u0001\u001a\u0011\u0005M2T\"\u0001\u001b\u000b\u0003U\nQa]2bY\u0006L!a\u000e\u001b\u0003\u0007%sG/A\u0007tK\u001elWM\u001c;CsR,7\u000fI\u0001\ni>\u0004\u0018n\u0019(b[\u0016,\u0012a\u000f\t\u0003y\u0005k\u0011!\u0010\u0006\u0003}}\nA\u0001\\1oO*\t\u0001)\u0001\u0003kCZ\f\u0017B\u0001\">\u0005\u0019\u0019FO]5oO\u0006QAo\u001c9jG:\u000bW.\u001a\u0011\u0002#I,\u0007\u000f\\5dCRLwN\u001c$bGR|'/\u0001\nsKBd\u0017nY1uS>tg)Y2u_J\u0004\u0013aD8oKNDw\u000e\u001e)s_\u0012,8-\u001a:\u0016\u0003!\u0003B!S*V+6\t!J\u0003\u0002L\u0019\u0006A\u0001O]8ek\u000e,'O\u0003\u0002N\u001d\u000691\r\\5f]R\u001c(BA\u000fP\u0015\t\u0001\u0016+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002%\u0006\u0019qN]4\n\u0005QS%!D&bM.\f\u0007K]8ek\u000e,'\u000fE\u00024-bK!a\u0016\u001b\u0003\u000b\u0005\u0013(/Y=\u0011\u0005MJ\u0016B\u0001.5\u0005\u0011\u0011\u0015\u0010^3\u0002'=tWm\u001d5piB\u0013x\u000eZ;dKJ|F%Z9\u0015\u0005u\u0003\u0007CA\u001a_\u0013\tyFG\u0001\u0003V]&$\bbB1\n\u0003\u0003\u0005\r\u0001S\u0001\u0004q\u0012\n\u0014\u0001E8oKNDw\u000e\u001e)s_\u0012,8-\u001a:!\u00031\u0001(o\u001c3vG\u0016\u0014x\fJ3r)\tiV\rC\u0004b\u0019\u0005\u0005\t\u0019\u0001%\u0002\u0013A\u0014x\u000eZ;dKJ\u0004\u0013\u0001C2p]N,X.\u001a:\u0016\u0003%\u0004BA\u001b7V+6\t1N\u0003\u0002h\u0019&\u0011Qn\u001b\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\u0002\u0019\r|gn];nKJ|F%Z9\u0015\u0005u\u0003\bbB1\u0010\u0003\u0003\u0005\r![\u0001\nG>t7/^7fe\u0002\n1B\u0019:pW\u0016\u00148i\\;oi\u0006iQn\u001c3jMf\u001cuN\u001c4jON$\"!X;\t\u000bY\u0014\u0002\u0019A<\u0002\u000bA\u0014x\u000e]:\u0011\u0007a\\X0D\u0001z\u0015\tQH'\u0001\u0006d_2dWm\u0019;j_:L!\u0001`=\u0003\u0007M+\u0017\u000fE\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003y\u0014\u0001B;uS2L1!!\u0002\u0000\u0005)\u0001&o\u001c9feRLWm]\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002;\"\u001a1#!\u0004\u0011\t\u0005=\u00111D\u0007\u0003\u0003#Q1aIA\n\u0015\u0011\t)\"a\u0006\u0002\u000f),\b/\u001b;fe*\u0019\u0011\u0011D)\u0002\u000b),h.\u001b;\n\t\u0005u\u0011\u0011\u0003\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8)\u0007Q\t\u0019\u0003\u0005\u0003\u0002\u0010\u0005\u0015\u0012\u0002BA\u0014\u0003#\u0011\u0011\"\u00114uKJ,\u0015m\u00195\u0002\u0019A\u0014x\u000eZ;dK\nKH/Z:\u0015\r\u00055\u00121GA\u001c!\rI\u0015qF\u0005\u0004\u0003cQ%A\u0004*fG>\u0014H-T3uC\u0012\fG/\u0019\u0005\u0007\u0003k)\u0002\u0019\u0001%\u0002\tA\u0014x\u000e\u001a\u0005\u0007\u0003s)\u0002\u0019\u0001\u001a\u0002\u00119,XNQ=uKN\fa\u0001\\3bI\u0016\u0014H\u0003BA \u0003\u0017\u0002B!!\u0011\u0002H5\u0011\u00111\t\u0006\u0004\u0003\u000bb\u0012AB:feZ,'/\u0003\u0003\u0002J\u0005\r#aC&bM.\f7+\u001a:wKJDq!!\u0014\u0017\u0001\u0004\ty%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005E\u0013qK\u0007\u0003\u0003'R1!!\u0016O\u0003\u0019\u0019w.\\7p]&!\u0011\u0011LA*\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\f\u0001\"Y<bSRL5K\u0015\u000b\u0006;\u0006}\u0013\u0011\r\u0005\b\u0003\u001b:\u0002\u0019AA(\u0011\u0019\t\u0019g\u0006a\u0001e\u0005AQ\r\u001f9fGR,G-A\u0017uKN$\bK]8ek\u000e,'o\u0015;bi\u0016\u0014Vm\u001d;pe\u0006$\u0018n\u001c8Ge>lG+[3sK\u0012\u001cFo\u001c:bO\u0016D3\u0001GA5!\u0011\ty!a\u001b\n\t\u00055\u0014\u0011\u0003\u0002\u0005)\u0016\u001cH\u000fK\u0004\u0001\u0003c\n9(!\u001f\u0011\t\u0005=\u00111O\u0005\u0005\u0003k\n\tBA\u0002UC\u001e\fQA^1mk\u0016\f#!a\u001f\u0002\u0017%tG/Z4sCRLwN\u001c")
public class TierProducerStateReplicationTest
extends IntegrationTestHarness {
    private final int segmentBytes;
    private final String topicName;
    private final int replicationFactor = this.brokerCount();
    private KafkaProducer<byte[], byte[]> oneshotProducer;
    private KafkaProducer<byte[], byte[]> producer;
    private KafkaConsumer<byte[], byte[]> consumer;

    private int segmentBytes() {
        return this.segmentBytes;
    }

    private String topicName() {
        return this.topicName;
    }

    private int replicationFactor() {
        return this.replicationFactor;
    }

    private KafkaProducer<byte[], byte[]> oneshotProducer() {
        return this.oneshotProducer;
    }

    private void oneshotProducer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.oneshotProducer = x$1;
    }

    private KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    private void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    private KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    private void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    @Override
    public int brokerCount() {
        return 3;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        props.foreach((Function1 & Serializable & scala.Serializable)p -> {
            p.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
            p.put(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
            p.put(KafkaConfig$.MODULE$.TierEnableProp(), "true");
            p.put(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
            p.put(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "3");
            p.put(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "1");
            p.put(KafkaConfig$.MODULE$.TierLocalHotsetBytesProp(), Integer.toString(this.segmentBytes() * 2));
            p.put(KafkaConfig$.MODULE$.LogSegmentBytesProp(), Integer.toString(this.segmentBytes()));
            return p.put(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "500");
        });
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        Properties topicProps = new Properties();
        topicProps.put("confluent.tier.enable", "true");
        topicProps.put("retention.bytes", "-1");
        topicProps.put("min.insync.replicas", "2");
        String x$1 = this.topicName();
        int x$2 = this.replicationFactor();
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        this.createTopic(x$1, x$3, x$2, x$4);
        Properties producerProps = new Properties();
        producerProps.put("enable.idempotence", "true");
        this.oneshotProducer_$eq(this.createProducer(new ByteArraySerializer(), new ByteArraySerializer(), producerProps));
        this.producer_$eq(this.createProducer(new ByteArraySerializer(), new ByteArraySerializer(), producerProps));
        this.consumer_$eq(this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.producer().flush();
        this.producer().close();
        this.oneshotProducer().flush();
        this.oneshotProducer().close();
        this.consumer().close();
    }

    private RecordMetadata produceBytes(KafkaProducer<byte[], byte[]> prod, int numBytes) {
        byte[] bytes = TestUtils$.MODULE$.randomBytes(numBytes);
        return (RecordMetadata)prod.send(new ProducerRecord(this.topicName(), Predef$.MODULE$.int2Integer(0), null, (Object)bytes)).get();
    }

    private KafkaServer leader(TopicPartition topicPartition) {
        int leaderId = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(topicPartition).get());
        return (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TierProducerStateReplicationTest.$anonfun$leader$1(leaderId, x$1)))).head();
    }

    /*
     * WARNING - void declaration
     */
    private void awaitISR(TopicPartition topicPartition, int expected) {
        long l = 1000L;
        long l2 = 120000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierProducerStateReplicationTest.$anonfun$awaitISR$1(this, topicPartition, expected)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierProducerStateReplicationTest.$anonfun$awaitISR$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testProducerStateRestorationFromTieredStorage() {
        void var5_8;
        void var4_7;
        TopicPartition topicPartition = new TopicPartition(this.topicName(), 0);
        long l = 1000L;
        long l2 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierProducerStateReplicationTest.$anonfun$testProducerStateRestorationFromTieredStorage$1(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierProducerStateReplicationTest.$anonfun$testProducerStateRestorationFromTieredStorage$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int killedBroker = this.killRandomBroker();
        this.awaitISR(topicPartition, this.replicationFactor() - 1);
        this.produceBytes(this.oneshotProducer(), 512);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 30).foreach((Function1 & Serializable & scala.Serializable)_ -> this.produceBytes(this.producer(), 512));
        Tuple2 tuple2 = this.servers().partition((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TierProducerStateReplicationTest.$anonfun$testProducerStateRestorationFromTieredStorage$5(killedBroker, x$3)));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer deadServers = (Buffer)tuple2._1();
        Buffer livingServers = (Buffer)tuple2._2();
        void deadServers2 = var4_7;
        void livingServers2 = var5_8;
        KafkaServer deadServer = (KafkaServer)deadServers2.head();
        long l3 = 1000L;
        long l4 = 300000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!((Buffer)livingServers2).forall((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)TierProducerStateReplicationTest.$anonfun$testProducerStateRestorationFromTieredStorage$7(topicPartition$2, broker)))) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierProducerStateReplicationTest.$anonfun$testProducerStateRestorationFromTieredStorage$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)((AbstractLog)deadServer.replicaManager().getLog(topicPartition).get()).producerStateManager().activeProducers().isEmpty(), (String)"expected the shutdown server to have no active producers");
        Assertions.assertTrue((boolean)livingServers2.forall((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TierProducerStateReplicationTest.$anonfun$testProducerStateRestorationFromTieredStorage$9(topicPartition, x$5))), (String)"expected the active brokers to both have materialized some producer state");
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.awaitISR(topicPartition, this.replicationFactor());
        Assertions.assertEquals((int)this.servers().size(), (int)this.replicationFactor());
        long l5 = 1000L;
        long l6 = 300000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!TierProducerStateReplicationTest.$anonfun$testProducerStateRestorationFromTieredStorage$10(this, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierProducerStateReplicationTest.$anonfun$testProducerStateRestorationFromTieredStorage$13());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Buffer activeProducersAcrossBrokers = (Buffer)this.servers().map((Function1 & Serializable & scala.Serializable)broker -> ((AbstractLog)broker.replicaManager().getLog(topicPartition).get()).producerStateManager().activeProducers().keys().toSet(), Buffer$.MODULE$.canBuildFrom());
        activeProducersAcrossBrokers.foreach((Function1 & Serializable & scala.Serializable)s -> {
            TierProducerStateReplicationTest.$anonfun$testProducerStateRestorationFromTieredStorage$15(activeProducersAcrossBrokers, s);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$leader$1(int leaderId$1, KafkaServer x$1) {
        return x$1.config().brokerId() == leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$awaitISR$1(TierProducerStateReplicationTest $this, TopicPartition topicPartition$1, int expected$1) {
        return ((Partition)$this.leader(topicPartition$1).replicaManager().onlinePartition(topicPartition$1).get()).inSyncReplicaIds().size() == expected$1;
    }

    public static final /* synthetic */ String $anonfun$awaitISR$2() {
        return "timed out waiting for replicas to join the ISR";
    }

    public static final /* synthetic */ boolean $anonfun$testProducerStateRestorationFromTieredStorage$2(KafkaServer x$2) {
        return ((TierTopicManager)x$2.tierTopicManagerOpt().get()).isReady();
    }

    public static final /* synthetic */ boolean $anonfun$testProducerStateRestorationFromTieredStorage$1(TierProducerStateReplicationTest $this) {
        return $this.servers().forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TierProducerStateReplicationTest.$anonfun$testProducerStateRestorationFromTieredStorage$2(x$2)));
    }

    public static final /* synthetic */ String $anonfun$testProducerStateRestorationFromTieredStorage$3() {
        return "Wait until the tier topic manager is ready for all brokers";
    }

    public static final /* synthetic */ boolean $anonfun$testProducerStateRestorationFromTieredStorage$5(int killedBroker$1, KafkaServer x$3) {
        return x$3.config().brokerId() == killedBroker$1;
    }

    public static final /* synthetic */ boolean $anonfun$testProducerStateRestorationFromTieredStorage$7(TopicPartition topicPartition$2, KafkaServer broker) {
        boolean x$2;
        LogManager qual$1 = broker.replicaManager().logManager();
        return ((AbstractLog)qual$1.getLog(topicPartition$2, x$2 = qual$1.getLog$default$2()).get()).localLogStartOffset() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testProducerStateRestorationFromTieredStorage$8() {
        return "expected to tier some segments and advance the local log start offset";
    }

    public static final /* synthetic */ boolean $anonfun$testProducerStateRestorationFromTieredStorage$9(TopicPartition topicPartition$2, KafkaServer x$5) {
        return ((AbstractLog)x$5.replicaManager().getLog(topicPartition$2).get()).producerStateManager().activeProducers().nonEmpty();
    }

    public static final /* synthetic */ long $anonfun$testProducerStateRestorationFromTieredStorage$11(TopicPartition topicPartition$2, KafkaServer x$6) {
        return ((AbstractLog)x$6.replicaManager().getLog(topicPartition$2).get()).localLogEndOffset();
    }

    public static final /* synthetic */ boolean $anonfun$testProducerStateRestorationFromTieredStorage$10(TierProducerStateReplicationTest $this, TopicPartition topicPartition$2) {
        Buffer endOffsets = (Buffer)$this.servers().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)TierProducerStateReplicationTest.$anonfun$testProducerStateRestorationFromTieredStorage$11(topicPartition$2, x$6)), Buffer$.MODULE$.canBuildFrom());
        return endOffsets.forall((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$7 -> x$7 == BoxesRunTime.unboxToLong((Object)endOffsets.head()));
    }

    public static final /* synthetic */ String $anonfun$testProducerStateRestorationFromTieredStorage$13() {
        return "expected all brokers to have matching end offsets";
    }

    public static final /* synthetic */ void $anonfun$testProducerStateRestorationFromTieredStorage$15(Buffer activeProducersAcrossBrokers$1, Set s) {
        Assertions.assertEquals((Object)activeProducersAcrossBrokers$1.head(), (Object)s, (String)"expected the set of active producers for all brokers to be the same");
    }

    public TierProducerStateReplicationTest() {
        this.segmentBytes = 1024;
        this.topicName = "topic";
    }
}

