/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.IntegrationTestHarness;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.TierLogSegment;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.tier.state.TierPartitionState;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001\u0002\t\u0012\u0001YAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013%!\u0005\u0003\u0004,\u0001\u0001\u0006Ia\t\u0005\bY\u0001\u0011\r\u0011\"\u0003.\u0011\u0019!\u0004\u0001)A\u0005]!9Q\u0007\u0001b\u0001\n\u0013i\u0003B\u0002\u001c\u0001A\u0003%a\u0006C\u00038\u0001\u0011ES\u0006C\u00049\u0001\t\u0007I\u0011A\u001d\t\r\u0011\u0003\u0001\u0015!\u0003;\u0011\u0015)\u0005\u0001\"\u0011G\u0011\u00151\u0006\u0001\"\u0011G\u0011\u0015Y\u0006\u0001\"\u0001G\u0011\u0015\u0001\u0007\u0001\"\u0003b\u0011\u0015a\b\u0001\"\u0003~\u0005q!\u0016.\u001a:SKR,g\u000e^5p]&sG/Z4sCRLwN\u001c+fgRT!AE\n\u0002\tQLWM\u001d\u0006\u0002)\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0018!\tA2$D\u0001\u001a\u0015\tQ2#A\u0002ba&L!\u0001H\r\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#A\u0010\u0011\u0005\u0001\u0002Q\"A\t\u0002\u000bQ|\u0007/[2\u0016\u0003\r\u0002\"\u0001J\u0015\u000e\u0003\u0015R!AJ\u0014\u0002\t1\fgn\u001a\u0006\u0002Q\u0005!!.\u0019<b\u0013\tQSE\u0001\u0004TiJLgnZ\u0001\u0007i>\u0004\u0018n\u0019\u0011\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t+\u0005q\u0003CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$aA%oi\u0006qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0013a\u00038v[J+\u0007\u000f\\5dCN\fAB\\;n%\u0016\u0004H.[2bg\u0002\n1B\u0019:pW\u0016\u00148i\\;oi\u00061Q\r_5uK\u0012,\u0012A\u000f\t\u0003w\tk\u0011\u0001\u0010\u0006\u0003{y\na!\u0019;p[&\u001c'BA A\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u0003\u001e\nA!\u001e;jY&\u00111\t\u0010\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u000f\u0015D\u0018\u000e^3eA\u0005)1/\u001a;VaR\tq\t\u0005\u00020\u0011&\u0011\u0011\n\r\u0002\u0005+:LG\u000f\u000b\u0002\f\u0017B\u0011A\nV\u0007\u0002\u001b*\u0011!D\u0014\u0006\u0003\u001fB\u000bqA[;qSR,'O\u0003\u0002R%\u0006)!.\u001e8ji*\t1+A\u0002pe\u001eL!!V'\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\ta\u0001\f\u0005\u0002M3&\u0011!,\u0014\u0002\n\u0003\u001a$XM]#bG\"\f!\u0003^3ti\n\u000b7/[2SKR,g\u000e^5p]\"\u0012Q\"\u0018\t\u0003\u0019zK!aX'\u0003\tQ+7\u000f^\u0001\u001bo\u0006LG/\u00168uS2,\u0015/^1m\u001f:\fE\u000e\u001c\"s_.,'o\u001d\u000b\u0004\u000f\n\u0004\b\"B2\u000f\u0001\u0004!\u0017!C2p[B,H/\u001a$o!\u0011ySmZ7\n\u0005\u0019\u0004$!\u0003$v]\u000e$\u0018n\u001c82!\tA7.D\u0001j\u0015\tQ7#\u0001\u0004tKJ4XM]\u0005\u0003Y&\u00141bS1gW\u0006\u001cVM\u001d<feB\u0011AE\\\u0005\u0003_\u0016\u0012aa\u00142kK\u000e$\b\"B9\u000f\u0001\u0004\u0011\u0018aA7tOB\u00111O\u001f\b\u0003ib\u0004\"!\u001e\u0019\u000e\u0003YT!a^\u000b\u0002\rq\u0012xn\u001c;?\u0013\tI\b'\u0001\u0004Qe\u0016$WMZ\u0005\u0003UmT!!\u001f\u0019\u0002\u0011\u0005<\u0018-\u001b;J'J#ba\u0012@\u0002\u0014\u0005U\u0001BB@\u0010\u0001\u0004\t\t!\u0001\u0002uaB!\u00111AA\b\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011AB2p[6|gNC\u0002\u0015\u0003\u0017Q1!!\u0004S\u0003\u0019\t\u0007/Y2iK&!\u0011\u0011CA\u0003\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:DQ!N\bA\u00029Ba!a\u0006\u0010\u0001\u00049\u0017A\u00027fC\u0012,'\u000f")
public class TierRetentionIntegrationTest
extends IntegrationTestHarness {
    private final String topic;
    private final int numPartitions;
    private final int numReplicas;
    private final AtomicBoolean exited;

    private String topic() {
        return this.topic;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private int numReplicas() {
        return this.numReplicas;
    }

    @Override
    public int brokerCount() {
        return 3;
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp() {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp();
        this.createTopic(this.topic(), this.numPartitions(), this.numReplicas(), this.createTopic$default$4());
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBasicRetention() {
        int bytesSent;
        TopicPartition topicPartition = new TopicPartition(this.topic(), 0);
        ProducerRecord record = new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
        int recordSize = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])record.key())).size() + new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])record.value())).size();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        PartitionInfo partitionInfo = (PartitionInfo)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TierRetentionIntegrationTest.$anonfun$testBasicRetention$1(x$3))).get();
        int leaderBrokerId = partitionInfo.leader().id();
        int[] followers = (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas())).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> x$5 != leaderBrokerId);
        KafkaServer leader = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TierRetentionIntegrationTest.$anonfun$testBasicRetention$4(leaderBrokerId, x$6))).get();
        for (bytesSent = 0; bytesSent < 1100; bytesSent += recordSize) {
            producer.send(record).get();
        }
        LogManager qual$1 = leader.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(topicPartition, x$2).get();
        TierPartitionState tierPartitionState = log.tierPartitionState();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierRetentionIntegrationTest.$anonfun$testBasicRetention$5(tierPartitionState)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierRetentionIntegrationTest.$anonfun$testBasicRetention$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierRetentionIntegrationTest.$anonfun$testBasicRetention$7(tierPartitionState)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierRetentionIntegrationTest.$anonfun$testBasicRetention$8());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertTrue((boolean)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(tierPartitionState.segments()).asScala()).nonEmpty());
        Assertions.assertEquals((long)0L, (long)log.logStartOffset());
        Assertions.assertEquals((long)0L, (long)((TierLogSegment)((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(tierPartitionState.segments()).asScala()).next()).baseOffset());
        this.awaitISR(topicPartition, this.numReplicas(), leader);
        this.killBroker(followers[0]);
        while (bytesSent < 20000) {
            producer.send(record).get();
            bytesSent += recordSize;
        }
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            TierRetentionIntegrationTest.$anonfun$testBasicRetention$9(this, topicPartition, server);
            return BoxedUnit.UNIT;
        });
        this.killBroker(followers[1]);
        while (bytesSent < 40000) {
            producer.send(record).get();
            bytesSent += recordSize;
        }
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.awaitISR(topicPartition, this.numReplicas(), leader);
        Function1 & Serializable & scala.Serializable waitUntilEqualOnAllBrokers_computeFn = (Function1 & Serializable & scala.Serializable)server -> {
            LogManager qual$3 = server.logManager();
            boolean x$6 = qual$3.getLog$default$2();
            return Long.toString(((AbstractLog)qual$3.getLog(topicPartition, x$6).get()).logStartOffset());
        };
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilEqualOnAllBrokers_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierRetentionIntegrationTest.$anonfun$waitUntilEqualOnAllBrokers$1(this, waitUntilEqualOnAllBrokers_computeFn)) {
            void waitUntilEqualOnAllBrokers_waitUntilTrue_pause;
            void waitUntilEqualOnAllBrokers_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilEqualOnAllBrokers_waitUntilTrue_startTime + waitUntilEqualOnAllBrokers_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierRetentionIntegrationTest.$anonfun$waitUntilEqualOnAllBrokers$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilEqualOnAllBrokers_waitUntilTrue_waitTimeMs), (long)waitUntilEqualOnAllBrokers_waitUntilTrue_pause));
        }
        Function1 & Serializable & scala.Serializable waitUntilEqualOnAllBrokers_computeFn2 = (Function1 & Serializable & scala.Serializable)server -> {
            LogManager qual$4 = server.logManager();
            boolean x$8 = qual$4.getLog$default$2();
            return Long.toString(((AbstractLog)qual$4.getLog(topicPartition, x$8).get()).logEndOffset());
        };
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilEqualOnAllBrokers_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TierRetentionIntegrationTest.$anonfun$waitUntilEqualOnAllBrokers$1(this, waitUntilEqualOnAllBrokers_computeFn2)) {
            void waitUntilEqualOnAllBrokers_waitUntilTrue_pause;
            void waitUntilEqualOnAllBrokers_waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilEqualOnAllBrokers_waitUntilTrue_startTime2 + waitUntilEqualOnAllBrokers_waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierRetentionIntegrationTest.$anonfun$waitUntilEqualOnAllBrokers$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilEqualOnAllBrokers_waitUntilTrue_waitTimeMs), (long)waitUntilEqualOnAllBrokers_waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void waitUntilEqualOnAllBrokers(Function1<KafkaServer, Object> computeFn, String msg) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierRetentionIntegrationTest.$anonfun$waitUntilEqualOnAllBrokers$1(this, computeFn)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierRetentionIntegrationTest.$anonfun$waitUntilEqualOnAllBrokers$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void awaitISR(TopicPartition tp, int numReplicas, KafkaServer leader) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierRetentionIntegrationTest.$anonfun$awaitISR$1(leader, tp, numReplicas)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierRetentionIntegrationTest.$anonfun$awaitISR$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testBasicRetention$1(PartitionInfo x$3) {
        return x$3.partition() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testBasicRetention$4(int leaderBrokerId$1, KafkaServer x$6) {
        return x$6.config().brokerId() == leaderBrokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testBasicRetention$5(TierPartitionState tierPartitionState$1) {
        return tierPartitionState$1.totalSize() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testBasicRetention$6() {
        return "Timed out waiting for segments to be tiered";
    }

    public static final /* synthetic */ boolean $anonfun$testBasicRetention$7(TierPartitionState tierPartitionState$1) {
        return tierPartitionState$1.committedEndOffset() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testBasicRetention$8() {
        return "Timed out waiting for tier partition state to be flushed";
    }

    public static final /* synthetic */ boolean $anonfun$testBasicRetention$10(AbstractLog log$1) {
        return log$1.logStartOffset() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testBasicRetention$11() {
        return "Timed out waiting for retention to kick in";
    }

    public static final /* synthetic */ boolean $anonfun$testBasicRetention$12(TierPartitionState tierPartitionState$2) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(tierPartitionState$2.segments()).asScala()).toList().headOption().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.baseOffset())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)) > 0L;
    }

    public static final /* synthetic */ String $anonfun$testBasicRetention$15() {
        return "Timed out waiting for tiered segment to be deleted";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testBasicRetention$9(TierRetentionIntegrationTest $this, TopicPartition topicPartition$1, KafkaServer server) {
        if ($this.alive()[$this.servers().indexOf((Object)server)]) {
            LogManager qual$2 = server.logManager();
            boolean x$4 = qual$2.getLog$default$2();
            AbstractLog log = (AbstractLog)qual$2.getLog(topicPartition$1, x$4).get();
            TierPartitionState tierPartitionState = log.tierPartitionState();
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierRetentionIntegrationTest.$anonfun$testBasicRetention$10(log)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TierRetentionIntegrationTest.$anonfun$testBasicRetention$11());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!TierRetentionIntegrationTest.$anonfun$testBasicRetention$12(tierPartitionState)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TierRetentionIntegrationTest.$anonfun$testBasicRetention$15());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$waitUntilEqualOnAllBrokers$1(TierRetentionIntegrationTest $this, Function1 computeFn$1) {
        return ((TraversableOnce)$this.servers().map((Function1 & Serializable & scala.Serializable)server -> computeFn$1.apply(server), Buffer$.MODULE$.canBuildFrom())).toSet().size() == 1;
    }

    public static final /* synthetic */ String $anonfun$waitUntilEqualOnAllBrokers$3() {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$awaitISR$1(KafkaServer leader$1, TopicPartition tp$1, int numReplicas$1) {
        return ((Partition)leader$1.replicaManager().onlinePartition(tp$1).get()).inSyncReplicaIds().size() == numReplicas$1;
    }

    public static final /* synthetic */ String $anonfun$awaitISR$2() {
        return "Timed out waiting for replicas to join ISR";
    }

    public TierRetentionIntegrationTest() {
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierFencedSegmentDeleteDelayMsProp(), "5");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "10000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogSegmentBytesProp(), "1000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogCleanupIntervalMsProp(), "10");
        this.topic = "foo";
        this.numPartitions = 1;
        this.numReplicas = 3;
        this.exited = new AtomicBoolean(false);
    }
}

