/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import kafka.log.AbstractLog;
import kafka.log.LogSegment;
import kafka.server.KafkaServer;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.TierObjectStore;
import kafka.tier.topic.TierTopicManager;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.BufferSupplier;
import org.junit.jupiter.api.Assertions;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class TierTestUtils$ {
    public static TierTestUtils$ MODULE$;
    private OffsetAndEpoch _tierTopicOffsetAndEpoch;

    static {
        new TierTestUtils$();
    }

    private OffsetAndEpoch _tierTopicOffsetAndEpoch() {
        return this._tierTopicOffsetAndEpoch;
    }

    private void _tierTopicOffsetAndEpoch_$eq(OffsetAndEpoch x$1) {
        this._tierTopicOffsetAndEpoch = x$1;
    }

    public synchronized OffsetAndEpoch currentOffsetAndEpoch() {
        return this._tierTopicOffsetAndEpoch();
    }

    public synchronized void setTierTopicOffsetAndEpoch(OffsetAndEpoch offsetAndEpoch) {
        this._tierTopicOffsetAndEpoch_$eq(offsetAndEpoch);
    }

    public synchronized OffsetAndEpoch nextTierTopicOffsetAndEpoch() {
        OffsetAndEpoch nextOffsetAndEpoch = new OffsetAndEpoch(this._tierTopicOffsetAndEpoch().offset() + 1L, this._tierTopicOffsetAndEpoch().epoch());
        this._tierTopicOffsetAndEpoch_$eq(nextOffsetAndEpoch);
        return this._tierTopicOffsetAndEpoch();
    }

    public synchronized void initTierTopicOffset() {
        this._tierTopicOffsetAndEpoch_$eq(new OffsetAndEpoch(-1L, Optional.empty()));
    }

    public void ensureTierable(AbstractLog log, long tierEndOffset, TopicPartition topicPartition, int leaderEpoch) {
        LogSegment activeSegment = log.activeSegment();
        if (activeSegment.baseOffset() <= tierEndOffset && activeSegment.readNextOffset() > tierEndOffset) {
            log.roll((Option)None$.MODULE$);
        }
        if (tierEndOffset == log.logEndOffset()) {
            log.appendAsFollower(this.createRecords(5, topicPartition, log.logEndOffset(), leaderEpoch));
        }
        log.flush();
        if (log.highWatermark() <= tierEndOffset) {
            log.updateHighWatermark(tierEndOffset + 1L);
        }
        Assertions.assertTrue((BoxesRunTime.unboxToLong((Object)log.firstUnstableOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Long.MAX_VALUE)) > tierEndOffset ? 1 : 0) != 0);
    }

    public int ensureTierable$default$4() {
        return 0;
    }

    public MemoryRecords createRecords(int n, TopicPartition partition, long baseOffset, int leaderEpoch) {
        IndexedSeq recList = (IndexedSeq)package$.MODULE$.Range().apply(0, n).map((Function1 & Serializable & scala.Serializable)x$1 -> TierTestUtils$.$anonfun$createRecords$1(BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom());
        byte x$3 = TestUtils$.MODULE$.records$default$2();
        CompressionType x$4 = TestUtils$.MODULE$.records$default$3();
        long x$5 = TestUtils$.MODULE$.records$default$4();
        short x$6 = TestUtils$.MODULE$.records$default$5();
        int x$7 = TestUtils$.MODULE$.records$default$6();
        int x$8 = TestUtils$.MODULE$.records$default$8();
        MemoryRecords records = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)recList, x$3, x$4, x$5, x$6, x$7, baseOffset, x$8);
        ByteBuffer filtered = ByteBuffer.allocate(100 * n);
        ((IterableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.setPartitionLeaderEpoch(leaderEpoch);
            return BoxedUnit.UNIT;
        });
        records.filterTo(partition, new MemoryRecords.RecordFilter(){

            public MemoryRecords.RecordFilter.BatchRetention checkBatchRetention(RecordBatch batch) {
                return MemoryRecords.RecordFilter.BatchRetention.DELETE_EMPTY;
            }

            public boolean shouldRetainRecord(RecordBatch recordBatch, Record record) {
                return true;
            }
        }, filtered, Integer.MAX_VALUE, BufferSupplier.NO_CACHING);
        filtered.flip();
        return MemoryRecords.readableRecords((ByteBuffer)filtered);
    }

    /*
     * WARNING - void declaration
     */
    public void awaitTierTopicPartition(KafkaServer broker, Integer partition) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTestUtils$.$anonfun$awaitTierTopicPartition$1(broker, partition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTestUtils$.$anonfun$awaitTierTopicPartition$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public CompletableFuture<TierPartitionState.AppendResult> uploadWithMetadata(TierTopicManager tierTopicManager, TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, long startOffset, long endOffset, long maxTimestamp, long lastModifiedTime, int size, boolean hasAbortedTxnIndex, boolean hasEpochState, boolean hasProducerState, OffsetAndEpoch validity, TierObjectStore.OpaqueData opaqueData) {
        TierPartitionState.AppendResult result;
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, tierEpoch, objectId, startOffset, endOffset, maxTimestamp, size, hasEpochState, hasAbortedTxnIndex, hasProducerState, validity, opaqueData);
        TierPartitionState.AppendResult appendResult = result = (TierPartitionState.AppendResult)tierTopicManager.addMetadata((AbstractTierMetadata)uploadInitiate).get();
        TierPartitionState.AppendResult appendResult2 = TierPartitionState.AppendResult.ACCEPTED;
        if (appendResult == null ? appendResult2 != null : !appendResult.equals(appendResult2)) {
            return CompletableFuture.completedFuture(result);
        }
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(uploadInitiate);
        return tierTopicManager.addMetadata((AbstractTierMetadata)uploadComplete);
    }

    public TierPartitionState.AppendResult uploadWithMetadata(TierPartitionState tierPartitionState, TopicIdPartition topicIdPartition, int tierEpoch, UUID objectId, long startOffset, long endOffset, long maxTimestamp, long lastModifiedTime, int size, boolean hasAbortedTxnIndex, boolean hasEpochState, boolean hasProducerState, OffsetAndEpoch validity, TierObjectStore.OpaqueData opaqueData) {
        TierPartitionState.AppendResult result;
        TierSegmentUploadInitiate uploadInitiate = new TierSegmentUploadInitiate(topicIdPartition, tierEpoch, objectId, startOffset, endOffset, maxTimestamp, size, hasEpochState, hasAbortedTxnIndex, hasProducerState, validity, opaqueData);
        TierPartitionState.AppendResult appendResult = result = tierPartitionState.append((AbstractTierMetadata)uploadInitiate, this.nextTierTopicOffsetAndEpoch());
        TierPartitionState.AppendResult appendResult2 = TierPartitionState.AppendResult.ACCEPTED;
        if (appendResult == null ? appendResult2 != null : !appendResult.equals(appendResult2)) {
            return result;
        }
        TierSegmentUploadComplete uploadComplete = new TierSegmentUploadComplete(uploadInitiate);
        return tierPartitionState.append((AbstractTierMetadata)uploadComplete, this.nextTierTopicOffsetAndEpoch());
    }

    public long uploadWithMetadata$default$7() {
        return 0L;
    }

    public long uploadWithMetadata$default$8() {
        return 0L;
    }

    public int uploadWithMetadata$default$9() {
        return 100;
    }

    public boolean uploadWithMetadata$default$10() {
        return false;
    }

    public boolean uploadWithMetadata$default$11() {
        return false;
    }

    public boolean uploadWithMetadata$default$12() {
        return false;
    }

    public OffsetAndEpoch uploadWithMetadata$default$13() {
        return OffsetAndEpoch.EMPTY;
    }

    public TierObjectStore.OpaqueData uploadWithMetadata$default$14() {
        return TierObjectStore.OpaqueData.ZEROED;
    }

    public TopicIdPartition randomTopicIdPartition(int partition) {
        UUID topicId = UUID.randomUUID();
        String topicName = TestUtils$.MODULE$.tempTopic();
        return new TopicIdPartition(topicName, topicId, partition);
    }

    public Set<TopicIdPartition> randomTopicIdPartitions(int numTopicUpperBound, int numPartitionUpperBound) {
        ObjectRef topicPartitions = ObjectRef.create((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)));
        int numTopics = TestUtils$.MODULE$.random().nextInt(numTopicUpperBound) + 1;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTopics).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            int numPartitions = TestUtils$.MODULE$.random().nextInt(numPartitionUpperBound) + 1;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPartitions).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
                topicPartitions$1.elem = (Set)((Set)topicPartitions$1.elem).$plus((Object)MODULE$.randomTopicIdPartition(partition));
            });
        });
        return (Set)topicPartitions.elem;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$createRecords$1(int x$1) {
        return new SimpleRecord(System.currentTimeMillis(), "key".getBytes(), "value".getBytes());
    }

    public static final /* synthetic */ boolean $anonfun$awaitTierTopicPartition$1(KafkaServer broker$1, Integer partition$1) {
        return broker$1.replicaManager().onlinePartition(new TopicPartition("_confluent-tier-state", Predef$.MODULE$.Integer2int(partition$1))).isDefined();
    }

    public static final /* synthetic */ String $anonfun$awaitTierTopicPartition$2() {
        return "Timed out waiting for replicas to join ISR";
    }

    private TierTestUtils$() {
        MODULE$ = this;
        this._tierTopicOffsetAndEpoch = new OffsetAndEpoch(-1L, Optional.empty());
    }
}

