/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.IntegrationTestHarness;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.tier.TopicIdPartition;
import kafka.tier.state.TierPartitionState;
import kafka.tier.store.MockInMemoryTierObjectStore;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001y3AAD\b\u0001)!)1\u0004\u0001C\u00019!)q\u0004\u0001C)A!9q\u0005\u0001b\u0001\n\u0013A\u0003BB\u0019\u0001A\u0003%\u0011\u0006C\u00043\u0001\t\u0007I\u0011\u0002\u0011\t\rM\u0002\u0001\u0015!\u0003\"\u0011\u001d!\u0004A1A\u0005\n\u0001Ba!\u000e\u0001!\u0002\u0013\t\u0003b\u0002\u001c\u0001\u0005\u0004%Ia\u000e\u0005\u0007\u0005\u0002\u0001\u000b\u0011\u0002\u001d\t\u000b\r\u0003A\u0011\t#\t\u000bQ\u0003A\u0011\t#\t\u000be\u0003A\u0011\u0001#\u0003AQKWM\u001d+pa&\u001cG)\u001a7fi&|g.\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003!E\tA\u0001^5fe*\t!#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001)\u0002C\u0001\f\u001a\u001b\u00059\"B\u0001\r\u0012\u0003\r\t\u0007/[\u0005\u00035]\u0011a#\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003=\t1B\u0019:pW\u0016\u00148i\\;oiV\t\u0011\u0005\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13EA\u0002J]R\fQ\u0001^8qS\u000e,\u0012!\u000b\t\u0003U=j\u0011a\u000b\u0006\u0003Y5\nA\u0001\\1oO*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019,\u0005\u0019\u0019FO]5oO\u00061Ao\u001c9jG\u0002\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\u0018A\u00048v[B\u000b'\u000f^5uS>t7\u000fI\u0001\f]Vl'+\u001a9mS\u000e\f7/\u0001\u0007ok6\u0014V\r\u001d7jG\u0006\u001c\b%\u0001\u0004fq&$X\rZ\u000b\u0002qA\u0011\u0011\bQ\u0007\u0002u)\u00111\bP\u0001\u0007CR|W.[2\u000b\u0005ur\u0014AC2p]\u000e,(O]3oi*\u0011q(L\u0001\u0005kRLG.\u0003\u0002Bu\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:\fq!\u001a=ji\u0016$\u0007%A\u0003tKR,\u0006\u000fF\u0001F!\t\u0011c)\u0003\u0002HG\t!QK\\5uQ\tY\u0011\n\u0005\u0002K%6\t1J\u0003\u0002\u0019\u0019*\u0011QJT\u0001\bUV\u0004\u0018\u000e^3s\u0015\ty\u0005+A\u0003kk:LGOC\u0001R\u0003\ry'oZ\u0005\u0003'.\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007F\u0001\u0007W!\tQu+\u0003\u0002Y\u0017\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0012i\u0016\u001cH\u000fV8qS\u000e$U\r\\3uS>t\u0007FA\u0007\\!\tQE,\u0003\u0002^\u0017\n!A+Z:u\u0001")
public class TierTopicDeletionIntegrationTest
extends IntegrationTestHarness {
    private final String topic;
    private final int numPartitions;
    private final int numReplicas;
    private final AtomicBoolean exited = new AtomicBoolean(false);

    @Override
    public int brokerCount() {
        return 3;
    }

    private String topic() {
        return this.topic;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private int numReplicas() {
        return this.numReplicas;
    }

    private AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp() {
        Exit.setExitProcedure((x$1, x$2) -> this.exited().set(true));
        super.setUp();
        this.createTopic(this.topic(), this.numPartitions(), this.numReplicas(), this.createTopic$default$4());
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        Assertions.assertFalse((boolean)this.exited().get());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicDeletion() {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).map((Function1 & Serializable & scala.Serializable)i -> TierTopicDeletionIntegrationTest.$anonfun$testTopicDeletion$1(this, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        int recordSize = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])((ProducerRecord)records.head()).key())).size() + new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])((ProducerRecord)records.head()).value())).size();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        for (int bytesSent = 0; bytesSent < 200; bytesSent += recordSize) {
            records.foreach((Function1 & Serializable & scala.Serializable)record -> (RecordMetadata)producer.send(record).get());
        }
        MockInMemoryTierObjectStore mockObjectStore = (MockInMemoryTierObjectStore)((KafkaBroker)this.servers().head()).tierObjectStoreOpt().get();
        ObjectRef topicId = ObjectRef.create(null);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            TopicPartition topicPartition = new TopicPartition(this.topic(), i);
            int leaderBrokerId = ((PartitionInfo)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(producer.partitionsFor(this.topic())).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TierTopicDeletionIntegrationTest.$anonfun$testTopicDeletion$4(i, x$3))).get()).leader().id();
            LogManager qual$1 = ((KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TierTopicDeletionIntegrationTest.$anonfun$testTopicDeletion$5(leaderBrokerId, x$4))).get()).logManager();
            boolean x$2 = qual$1.getLog$default$2();
            TierPartitionState tierPartitionState = ((AbstractLog)qual$1.getLog(topicPartition, x$2).get()).tierPartitionState();
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TierTopicDeletionIntegrationTest.$anonfun$testTopicDeletion$6(tierPartitionState)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TierTopicDeletionIntegrationTest.$anonfun$testTopicDeletion$7());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!TierTopicDeletionIntegrationTest.$anonfun$testTopicDeletion$8(tierPartitionState)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)TierTopicDeletionIntegrationTest.$anonfun$testTopicDeletion$9());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            topicId$1.elem = CoreUtils$.MODULE$.uuidToBase64(((TopicIdPartition)tierPartitionState.topicIdPartition().get()).topicId());
        });
        Assertions.assertTrue((TierTopicDeletionIntegrationTest.numObjects$1(mockObjectStore, topicId) >= this.numPartitions() ? 1 : 0) != 0);
        this.createAdminClient(this.createAdminClient$default$1()).deleteTopics(Collections.singleton(this.topic())).all().get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TierTopicDeletionIntegrationTest.$anonfun$testTopicDeletion$11(mockObjectStore, topicId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TierTopicDeletionIntegrationTest.$anonfun$testTopicDeletion$12());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ ProducerRecord $anonfun$testTopicDeletion$1(TierTopicDeletionIntegrationTest $this, int i) {
        return new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(i), (Object)"key".getBytes(), (Object)"value".getBytes());
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletion$4(int i$1, PartitionInfo x$3) {
        return x$3.partition() == i$1;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletion$5(int leaderBrokerId$1, KafkaServer x$4) {
        return x$4.config().brokerId() == leaderBrokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletion$6(TierPartitionState tierPartitionState$1) {
        return tierPartitionState$1.totalSize() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletion$7() {
        return "Timed out waiting for segments to be tiered";
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletion$8(TierPartitionState tierPartitionState$1) {
        return tierPartitionState$1.committedEndOffset() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletion$9() {
        return "Timed out waiting for tier partition state to be flushed";
    }

    private static final int numObjects$1(MockInMemoryTierObjectStore mockObjectStore$1, ObjectRef topicId$1) {
        return ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(mockObjectStore$1.getStoredKeys()).asScala()).count((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains((String)topicId$1.elem)));
    }

    public static final /* synthetic */ boolean $anonfun$testTopicDeletion$11(MockInMemoryTierObjectStore mockObjectStore$1, ObjectRef topicId$1) {
        return TierTopicDeletionIntegrationTest.numObjects$1(mockObjectStore$1, topicId$1) == 0;
    }

    public static final /* synthetic */ String $anonfun$testTopicDeletion$12() {
        return "Timed out waiting for all objects to be deleted";
    }

    public TierTopicDeletionIntegrationTest() {
        this.topic = "foo";
        this.numPartitions = 4;
        this.numReplicas = 2;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierFeatureProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierEnableProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierMetadataNumPartitionsProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierMetadataReplicationFactorProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierBackendProp(), "mock");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierTopicDeleteCheckIntervalMsProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TierPartitionStateCommitIntervalProp(), "10");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "10000");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogSegmentBytesProp(), "1000");
        Predef$.MODULE$.locally(this.serverConfig().setProperty(KafkaConfig$.MODULE$.LogFlushSchedulerIntervalMsProp(), "10"));
    }
}

