/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.fetcher;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.CancellationException;
import kafka.log.AbortedTxn;
import kafka.log.Log$;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.fetcher.TierAbortedTxnReader;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.Matchers$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000193A!\u0003\u0006\u0001#!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0005;!)Q\u0007\u0001C\u0001m!)A\t\u0001C\u0001m!)a\t\u0001C\u0001m!)\u0001\n\u0001C\u0001m!)!\n\u0001C\u0001m!)A\n\u0001C\u0001m\tAB+[3s\u0003\n|'\u000f^3e)bt'+Z1eKJ$Vm\u001d;\u000b\u0005-a\u0011a\u00024fi\u000eDWM\u001d\u0006\u0003\u001b9\tA\u0001^5fe*\tq\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00025A\u00111\u0004A\u0007\u0002\u0015\u0005I!o\\;oIR\u0013\u0018\u000e\u001d\u000b\u0003=\u0005\u0002\"aE\u0010\n\u0005\u0001\"\"\u0001B+oSRDQA\t\u0002A\u0002\r\n1\"\u00192peR,G\r\u0016=ogB\u0019A\u0005L\u0018\u000f\u0005\u0015RcB\u0001\u0014*\u001b\u00059#B\u0001\u0015\u0011\u0003\u0019a$o\\8u}%\tQ#\u0003\u0002,)\u00059\u0001/Y2lC\u001e,\u0017BA\u0017/\u0005\r\u0019V-\u001d\u0006\u0003WQ\u0001\"\u0001M\u001a\u000e\u0003ER!A\r\b\u0002\u00071|w-\u0003\u00025c\tQ\u0011IY8si\u0016$G\u000b\u001f8\u00021Q,7\u000f\u001e*pk:$GK]5q\u0003\n|'\u000f^3e)bt7\u000fF\u0001\u001fQ\t\u0019\u0001\b\u0005\u0002:\u00056\t!H\u0003\u0002<y\u0005\u0019\u0011\r]5\u000b\u0005ur\u0014a\u00026va&$XM\u001d\u0006\u0003\u007f\u0001\u000bQA[;oSRT\u0011!Q\u0001\u0004_J<\u0017BA\";\u0005\u0011!Vm\u001d;\u0002AQ,7\u000f^*fe&\fG.\u001b>f\t>,7OT8u\u001b>$\u0017NZ=NCJ\\WM\u001d\u0015\u0003\ta\n1\u0003^3tiN+Wm[(gMN,GOU1oO\u0016D#!\u0002\u001d\u0002IQ,7\u000f^*fK.|eMZ:fiJ\u000bgnZ3Pm\u0016\u0014H.\u00199qS:<\u0017IY8siND#A\u0002\u001d\u0002)Q,7\u000f^!c_J$X\r\u001a+y]N\u0014\u0016M\\4fQ\t9\u0001(\u0001\ruKN$8)\u00198dK2d\u0017\r^5p]\"\u000bg\u000e\u001a7j]\u001eD#\u0001\u0003\u001d")
public class TierAbortedTxnReaderTest {
    private void roundTrip(Seq<AbortedTxn> abortedTxns) {
        Option option = Log$.MODULE$.serializeAbortedTransactions(abortedTxns);
        if (option instanceof Some) {
            ByteBuffer serialized = (ByteBuffer)((Some)option).value();
            ByteBufferInputStream inputStream = new ByteBufferInputStream(serialized);
            java.util.List parsedAbortedTxns = TierAbortedTxnReader.readInto((CancellationContext)CancellationContext.newContext(), (InputStream)inputStream, (long)0L, (long)Long.MAX_VALUE);
            Assertions.assertEquals(abortedTxns, (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(parsedAbortedTxns).asScala());
            return;
        }
        if (None$.MODULE$.equals(option)) {
            if (abortedTxns.nonEmpty()) {
                BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"expected some aborted transactions to be deserialized");
                return;
            }
        } else {
            throw new MatchError((Object)option);
        }
    }

    @Test
    public void testRoundTripAbortedTxns() {
        this.roundTrip((Seq<AbortedTxn>)Nil$.MODULE$);
        this.roundTrip((Seq<AbortedTxn>)new .colon.colon((Object)new AbortedTxn(1L, 2L, 3L, 4L), (List)Nil$.MODULE$));
        this.roundTrip((Seq<AbortedTxn>)new .colon.colon((Object)new AbortedTxn(0L, 0L, 0L, 0L), (List)Nil$.MODULE$));
        this.roundTrip((Seq<AbortedTxn>)new .colon.colon((Object)new AbortedTxn(0L, 0L, 0L, 0L), (List)new .colon.colon((Object)new AbortedTxn(1L, 1L, 1L, 1L), (List)Nil$.MODULE$)));
    }

    @Test
    public void testSerializeDoesNotModifyMarker() {
        AbortedTxn abortedTxn = new AbortedTxn(1L, 1L, 1L, 1L);
        Log$.MODULE$.serializeAbortedTransactions((Seq)new .colon.colon((Object)abortedTxn, (List)Nil$.MODULE$));
        Assertions.assertEquals((int)0, (int)abortedTxn.buffer().position());
        Assertions.assertEquals((long)1L, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)1L, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)1L, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)1L, (long)abortedTxn.lastStableOffset());
    }

    @Test
    public void testSeekOffsetRange() {
        CancellationContext ctx = CancellationContext.newContext();
        ByteBuffer serialized = (ByteBuffer)Log$.MODULE$.serializeAbortedTransactions((Seq)new .colon.colon((Object)new AbortedTxn(0L, 3L, 10L, 0L), (List)new .colon.colon((Object)new AbortedTxn(0L, 15L, 20L, 0L), (List)new .colon.colon((Object)new AbortedTxn(0L, 30L, 50L, 0L), (List)Nil$.MODULE$)))).get();
        Assertions.assertEquals((Object)new .colon.colon((Object)new AbortedTxn(0L, 3L, 10L, 0L), (List)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(TierAbortedTxnReader.readInto((CancellationContext)ctx, (InputStream)new ByteBufferInputStream(serialized), (long)0L, (long)5L)).asScala(), (String)"expected to find a single aborted transaction marker");
        serialized.position(0);
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(TierAbortedTxnReader.readInto((CancellationContext)ctx, (InputStream)new ByteBufferInputStream(serialized), (long)0L, (long)1L)).asScala(), (String)"expected to find zero aborted transaction markers");
        serialized.position(0);
        Assertions.assertEquals((Object)new .colon.colon((Object)new AbortedTxn(0L, 15L, 20L, 0L), (List)new .colon.colon((Object)new AbortedTxn(0L, 30L, 50L, 0L), (List)Nil$.MODULE$)), (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(TierAbortedTxnReader.readInto((CancellationContext)ctx, (InputStream)new ByteBufferInputStream(serialized), (long)11L, (long)35L)).asScala(), (String)"expected to find two aborted transaction markers");
        serialized.position(0);
        Assertions.assertEquals((Object)new .colon.colon((Object)new AbortedTxn(0L, 3L, 10L, 0L), (List)new .colon.colon((Object)new AbortedTxn(0L, 15L, 20L, 0L), (List)Nil$.MODULE$)), (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(TierAbortedTxnReader.readInto((CancellationContext)ctx, (InputStream)new ByteBufferInputStream(serialized), (long)0L, (long)16L)).asScala(), (String)"expected to find two aborted transaction markers");
        serialized.position(0);
        Assertions.assertEquals((Object)new .colon.colon((Object)new AbortedTxn(0L, 3L, 10L, 0L), (List)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(TierAbortedTxnReader.readInto((CancellationContext)ctx, (InputStream)new ByteBufferInputStream(serialized), (long)0L, (long)3L)).asScala(), (String)"expected to find adjacent aborted transaction markers");
        serialized.position(0);
        Assertions.assertEquals((Object)new .colon.colon((Object)new AbortedTxn(0L, 3L, 10L, 0L), (List)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(TierAbortedTxnReader.readInto((CancellationContext)ctx, (InputStream)new ByteBufferInputStream(serialized), (long)3L, (long)10L)).asScala(), (String)"expected to find fully overlapped aborted transaction markers");
        serialized.position(0);
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(TierAbortedTxnReader.readInto((CancellationContext)ctx, (InputStream)new ByteBufferInputStream(serialized), (long)100L, (long)150L)).asScala(), (String)"expected to find zero aborted transaction markers");
    }

    @Test
    public void testSeekOffsetRangeOverlappingAborts() {
        CancellationContext ctx = CancellationContext.newContext();
        ByteBuffer serialized = (ByteBuffer)Log$.MODULE$.serializeAbortedTransactions((Seq)new .colon.colon((Object)new AbortedTxn(3L, 1999L, 2000L, 0L), (List)new .colon.colon((Object)new AbortedTxn(1L, 1246L, 2000L, 0L), (List)Nil$.MODULE$))).get();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(1L, 1246L, 2000L, 0L)})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(TierAbortedTxnReader.readInto((CancellationContext)ctx, (InputStream)new ByteBufferInputStream(serialized), (long)0L, (long)1776L)).asScala()).toSet());
        ByteBuffer serialized2 = (ByteBuffer)Log$.MODULE$.serializeAbortedTransactions((Seq)new .colon.colon((Object)new AbortedTxn(1L, 1L, 1180L, 0L), (List)Nil$.MODULE$)).get();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbortedTxn[]{new AbortedTxn(1L, 1L, 1180L, 0L)})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(TierAbortedTxnReader.readInto((CancellationContext)ctx, (InputStream)new ByteBufferInputStream(serialized2), (long)0L, (long)1L)).asScala()).toSet());
    }

    @Test
    public void testAbortedTxnsRange() {
        Assertions.assertTrue((boolean)TierAbortedTxnReader.abortedTxnInRange((long)0L, (long)10L, (AbortedTxn)new AbortedTxn(0L, 0L, 5L, 0L)));
        Assertions.assertTrue((boolean)TierAbortedTxnReader.abortedTxnInRange((long)5L, (long)10L, (AbortedTxn)new AbortedTxn(0L, 0L, 25L, 0L)));
        Assertions.assertFalse((boolean)TierAbortedTxnReader.abortedTxnInRange((long)0L, (long)2L, (AbortedTxn)new AbortedTxn(0L, 3L, 5L, 0L)));
        Assertions.assertFalse((boolean)TierAbortedTxnReader.abortedTxnInRange((long)20L, (long)30L, (AbortedTxn)new AbortedTxn(0L, 3L, 5L, 0L)));
    }

    @Test
    public void testCancellationHandling() {
        CancellationContext ctx = CancellationContext.newContext();
        ByteBuffer serialized = (ByteBuffer)Log$.MODULE$.serializeAbortedTransactions((Seq)new .colon.colon((Object)new AbortedTxn(3L, 1999L, 2000L, 0L), (List)new .colon.colon((Object)new AbortedTxn(1L, 1246L, 2000L, 0L), (List)Nil$.MODULE$))).get();
        ByteBufferInputStream inputStream = new ByteBufferInputStream(serialized);
        ctx.cancel();
        Matchers$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> TierAbortedTxnReader.readInto((CancellationContext)ctx, (InputStream)inputStream, (long)0L, (long)10000L), ClassTag$.MODULE$.apply(CancellationException.class), new Position("TierAbortedTxnReaderTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
    }
}

