/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.TierLogSegment;
import kafka.server.KafkaBroker;
import kafka.server.KafkaServer;
import kafka.tier.state.BaseTierStateTest;
import kafka.tier.store.TierObjectStore;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DeleteTopicsResult;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00013AAC\u0006\u0001%!)q\u0003\u0001C\u00011!)!\u0004\u0001C!7!)!\u0005\u0001C\u0001G!)A\u0007\u0001C\u0001G!)a\u0007\u0001C\u0001G!)\u0001\b\u0001C\u0001G!)!\b\u0001C\u0001G!)A\b\u0001C\u0001G!)a\b\u0001C\u0001G\t1B)[:bE2,G+[3s'R|'/Y4f)\u0016\u001cHO\u0003\u0002\r\u001b\u0005)1\u000f^1uK*\u0011abD\u0001\u0005i&,'OC\u0001\u0011\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\n\u0011\u0005Q)R\"A\u0006\n\u0005YY!!\u0005\"bg\u0016$\u0016.\u001a:Ti\u0006$X\rV3ti\u00061A(\u001b8jiz\"\u0012!\u0007\t\u0003)\u0001\t1B\u0019:pW\u0016\u00148i\\;oiV\tA\u0004\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcDA\u0002J]R\f\u0011\u0006^3ti\u001a+Go\u00195SKF,Xm\u001d;XSRDG+[3sK\u0012\u001cFo\u001c:bO\u0016$\u0015n]1cY\u0016$G#\u0001\u0013\u0011\u0005u)\u0013B\u0001\u0014\u001f\u0005\u0011)f.\u001b;)\u0005\rA\u0003CA\u00153\u001b\u0005Q#BA\u0016-\u0003\r\t\u0007/\u001b\u0006\u0003[9\nqA[;qSR,'O\u0003\u00020a\u0005)!.\u001e8ji*\t\u0011'A\u0002pe\u001eL!a\r\u0016\u0003\tQ+7\u000f^\u0001+i\u0016\u001cH/\u00113e\u001d\u0016<(+\u001a9mS\u000e\fw+\u001b;i)&,'/\u001a3Ti>\u0014\u0018mZ3ESN\f'\r\\3eQ\t!\u0001&\u0001\u0015uKN$(+\u001a9mS\u000e\fG/[8o/&$\b\u000eV5fe\u0016$7\u000b^8sC\u001e,G)[:bE2,G\r\u000b\u0002\u0006Q\u0005AC/Z:u\t\u0016dW\r^3U_BL7mV5uQRKWM]3e'R|'/Y4f\t&\u001c\u0018M\u00197fI\"\u0012a\u0001K\u0001*i\u0016\u001cH\u000fT8h%\u0016$XM\u001c;j_:<\u0016\u000e\u001e5US\u0016\u0014X\rZ*u_J\fw-\u001a#jg\u0006\u0014G.\u001a3)\u0005\u001dA\u0013\u0001\u0011;fgRdun\u001a*fi\u0016tG/[8o\u0003\u001a$XM\u001d+jKJ,G\rR1uC&\u001bH)\u001a7fi\u0016$\u0017I\u001c3US\u0016\u0014X\rZ*u_J\fw-\u001a#jg\u0006\u0014G.\u001a3)\u0005!A\u0013a\r;fgR$U\r\\3uS>tG+Y:l'R\fG/Z'bG\"Lg.Z,iK:$\u0016.\u001a:Ti>\u0014\u0018mZ3ESN\f'\r\\3eQ\tI\u0001\u0006")
public class DisableTierStorageTest
extends BaseTierStateTest {
    @Override
    public int brokerCount() {
        return 5;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchRequestWithTieredStorageDisabled() {
        void var3_3;
        void var2_2;
        Tuple2<Object, Object> tuple2 = this.createTopicAndGetReplicas();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int replica1 = tuple2._1$mcI$sp();
        int replica2 = tuple2._2$mcI$sp();
        this.appendMessagesAndWaitUntilTieredAndSynced((int)var2_2, (int)var3_3);
        this.waitForHotSetRetentionToKickIn((List<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{var2_2, var3_3})));
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fetch with tier enabled");
        this.fetchTieredAndLocalDataAndValidate((int)var2_2, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var3_3)));
        this.changeTopicConfig("confluent.tier.enable", "false", this.changeTopicConfig$default$3());
        AbstractLog leaderLog = (AbstractLog)((KafkaServer)this.serverForId((int)var2_2).get()).replicaManager().getLog(this.topicPartition()).get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testFetchRequestWithTieredStorageDisabled$2(leaderLog)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testFetchRequestWithTieredStorageDisabled$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fetch with tier disabled");
        this.fetchTieredAndLocalDataAndValidate((int)var2_2, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var3_3)));
        this.switchLeader((int)var2_2, (int)var3_3);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fetch with tier disabled and new leader elected");
        this.fetchTieredAndLocalDataAndValidate((int)var3_3, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var2_2)));
        this.switchLeader((int)var3_3, (int)var2_2);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fetch with tier disabled and new leader elected (that has since been rolled)");
        this.fetchTieredAndLocalDataAndValidate((int)var2_2, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)var3_3)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddNewReplicaWithTieredStorageDisabled() {
        void var2_2;
        Tuple2<Object, Object> tuple2 = this.createTopicAndGetReplicas();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int replica1 = tuple2._1$mcI$sp();
        this.appendMessagesToLeaderAndWaitUntilTiered((int)var2_2, this.appendMessagesToLeaderAndWaitUntilTiered$default$2());
        AbstractLog log = (AbstractLog)((KafkaServer)this.serverForId((int)var2_2).get()).replicaManager().getLog(this.topicPartition()).get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testAddNewReplicaWithTieredStorageDisabled$1(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testAddNewReplicaWithTieredStorageDisabled$2(log));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int replica3 = this.addReplicaToAssignment((int)var2_2);
        this.waitForReplicaToGetInSync((int)var2_2, replica3);
        this.changeTopicConfig("confluent.tier.enable", "false", this.changeTopicConfig$default$3());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testAddNewReplicaWithTieredStorageDisabled$3(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testAddNewReplicaWithTieredStorageDisabled$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int replica4 = this.addReplicaToAssignment((int)var2_2);
        this.waitForReplicaToGetInSync((int)var2_2, replica4);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReplicationWithTieredStorageDisabled() {
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int replica1 = BoxesRunTime.unboxToInt((Object)this.createTopic(this.topicName(), 1, 3, this.props()).apply((Object)BoxesRunTime.boxToInteger((int)this.topicPartition().partition())));
        Seq followers = (Seq)((KafkaServer)this.serverForId(replica1).get()).replicaManager().getPartitionOrException(this.topicPartition()).assignmentState().replicas().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 != replica1);
        followers.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)follower -> ((KafkaServer)this.serverForId(follower).get()).shutdown());
        this.appendMessagesToLeaderAndWaitUntilTiered(replica1, this.appendMessagesToLeaderAndWaitUntilTiered$default$2());
        AbstractLog log = (AbstractLog)((KafkaServer)this.serverForId(replica1).get()).replicaManager().getLog(this.topicPartition()).get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testReplicationWithTieredStorageDisabled$3(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testReplicationWithTieredStorageDisabled$4(log));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((KafkaServer)this.serverForId(BoxesRunTime.unboxToInt((Object)followers.head())).get()).startup();
        this.waitForReplicaToGetInSync(replica1, BoxesRunTime.unboxToInt((Object)followers.head()));
        this.changeTopicConfig("confluent.tier.enable", "false", this.changeTopicConfig$default$3());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testReplicationWithTieredStorageDisabled$5(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testReplicationWithTieredStorageDisabled$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ((KafkaServer)this.serverForId(BoxesRunTime.unboxToInt((Object)followers.apply(1))).get()).startup();
        this.waitForReplicaToGetInSync(replica1, BoxesRunTime.unboxToInt((Object)followers.apply(1)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteTopicWithTieredStorageDisabled() {
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        String topic1 = "foo";
        String topic2 = "bar";
        int topic1LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(topic1, 1, 1, this.props()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        AbstractLog topic1Log = (AbstractLog)((KafkaServer)this.serverForId(topic1LeaderId).get()).replicaManager().getLog(new TopicPartition(topic1, 0)).get();
        int topic2LeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(topic2, 1, 1, this.props()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        AbstractLog topic2Log = (AbstractLog)((KafkaServer)this.serverForId(topic2LeaderId).get()).replicaManager().getLog(new TopicPartition(topic2, 0)).get();
        int numMessages = 100;
        IntRef totalMessages1 = IntRef.create((int)0);
        while (topic1Log.numberOfSegments() <= 3) {
            TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers().toSeq(), topic1, numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            totalMessages1.elem += numMessages;
        }
        IntRef totalMessages2 = IntRef.create((int)0);
        while (topic2Log.numberOfSegments() <= 3) {
            TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers().toSeq(), topic2, numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            totalMessages2.elem += numMessages;
        }
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testDeleteTopicWithTieredStorageDisabled$1(this, topic1Log, totalMessages1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testDeleteTopicWithTieredStorageDisabled$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testDeleteTopicWithTieredStorageDisabled$3(this, topic2Log, totalMessages2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testDeleteTopicWithTieredStorageDisabled$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        List<TierLogSegment> tieredSegments1 = this.tierLogSegments(topic1Log);
        List<TierLogSegment> tieredSegments2 = this.tierLogSegments(topic2Log);
        ConfluentAdmin adminClient = this.createAdminClient(this.createAdminClient$default$1());
        DeleteTopicsResult future1 = adminClient.deleteTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)topic1, (List)Nil$.MODULE$)).asJavaCollection());
        this.changeTopicConfig("confluent.tier.enable", "false", topic2);
        long l5 = 200L;
        long l6 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testDeleteTopicWithTieredStorageDisabled$5(topic2Log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testDeleteTopicWithTieredStorageDisabled$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        DeleteTopicsResult future2 = adminClient.deleteTopics(CollectionConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)topic2, (List)Nil$.MODULE$)).asJavaCollection());
        future1.all().get(30000L, TimeUnit.MILLISECONDS);
        future2.all().get(30000L, TimeUnit.MILLISECONDS);
        TierObjectStore objStore = (TierObjectStore)((KafkaBroker)this.serverForId(topic1LeaderId).get()).tierObjectStoreOpt().get();
        this.verifyTieredSegmentsDeleted(topic1, objStore, tieredSegments1);
        this.verifyTieredSegmentsDeleted(topic2, objStore, tieredSegments2);
    }

    @Test
    public void testLogRetentionWithTieredStorageDisabled() {
        int numMessages = 100;
        ObjectRef topic = ObjectRef.create((Object)"");
        ((TraversableLike)new .colon.colon((Object)"false", (List)new .colon.colon((Object)"true", (List)Nil$.MODULE$)).zipWithIndex(List$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$2(this, topic, numMessages, x$3);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled() {
        int numMessages = 100;
        int leaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(this.topicName(), 1, 1, this.props()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        LogManager qual$1 = ((KafkaServer)this.serverForId(leaderId).get()).getLogManager();
        TopicPartition x$1 = new TopicPartition(this.topicName(), 0);
        boolean x$2 = qual$1.getLog$default$2();
        AbstractLog log = (AbstractLog)qual$1.getLog(x$1, x$2).get();
        while (log.numberOfSegments() < 4) {
            TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers().toSeq(), this.topicName(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        }
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$1(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        this.changeTopicConfig("confluent.tier.enable", "false", this.topicName());
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$3(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long currentNumMessages = log.logEndOffset();
        long lastTieredOffset = log.tierPartitionState().endOffset();
        String desiredRetentionSizeBytes = Long.toString(log.size());
        while (log.logEndOffset() < currentNumMessages * 3L) {
            TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers().toSeq(), this.topicName(), numMessages, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        }
        List segmentsNotTiered = log.localLogSegments(lastTieredOffset + 1L, log.logEndOffset()).toList();
        this.changeTopicConfig("retention.bytes", desiredRetentionSizeBytes, this.topicName());
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$5(log, segmentsNotTiered)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l7 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l8 = 30000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime4 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$7(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime4 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$8(log));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long l9 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l10 = 60000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime5 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$9(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime5 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$10());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeletionTaskStateMachineWhenTierStorageDisabled() {
        this.props().put("retention.bytes", "-1");
        this.props().put("retention.ms", "-1");
        TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        int leaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(this.topicPartition().topic(), 1, 1, this.props()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        AbstractLog log = (AbstractLog)((KafkaServer)this.serverForId(leaderId).get()).replicaManager().getLog(this.topicPartition()).get();
        TierObjectStore objStore = (TierObjectStore)((KafkaBroker)this.serverForId(leaderId).get()).tierObjectStoreOpt().get();
        this.appendMessagesToLeaderAndWaitUntilTiered(leaderId, this.appendMessagesToLeaderAndWaitUntilTiered$default$2());
        this.changeTopicConfig("confluent.tier.enable", "false", this.changeTopicConfig$default$3());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 10000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$1(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        List<TierLogSegment> tieredSegments = this.tierLogSegments(log);
        this.changeTopicConfig("retention.ms", "100", this.changeTopicConfig$default$3());
        this.verifyTieredSegmentsDeleted(this.topicPartition().topic(), objStore, tieredSegments);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 10000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DisableTierStorageTest.$anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$3(log)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)DisableTierStorageTest.$anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testFetchRequestWithTieredStorageDisabled$2(AbstractLog leaderLog$1) {
        return !leaderLog$1.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testFetchRequestWithTieredStorageDisabled$3() {
        return "Timed out waiting for tiered storage to be turned off";
    }

    public static final /* synthetic */ boolean $anonfun$testAddNewReplicaWithTieredStorageDisabled$1(AbstractLog log$1) {
        return log$1.logStartOffset() < log$1.localLogStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testAddNewReplicaWithTieredStorageDisabled$2(AbstractLog log$1) {
        return new StringBuilder(88).append("Timed out waiting for hot set retention to kick in logStartOffset: ").append(log$1.logStartOffset()).append(" localLogStartOffset ").append(log$1.localLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testAddNewReplicaWithTieredStorageDisabled$3(AbstractLog log$1) {
        return !log$1.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testAddNewReplicaWithTieredStorageDisabled$4() {
        return "Timed out waiting for tiered storage to be turned off";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicationWithTieredStorageDisabled$3(AbstractLog log$2) {
        return log$2.logStartOffset() < log$2.localLogStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testReplicationWithTieredStorageDisabled$4(AbstractLog log$2) {
        return new StringBuilder(88).append("Timed out waiting for hot set retention to kick in logStartOffset: ").append(log$2.logStartOffset()).append(" localLogStartOffset ").append(log$2.localLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicationWithTieredStorageDisabled$5(AbstractLog log$2) {
        return !log$2.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testReplicationWithTieredStorageDisabled$6() {
        return "Timed out waiting for tiered storage to be turned off";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicWithTieredStorageDisabled$1(DisableTierStorageTest $this, AbstractLog topic1Log$1, IntRef totalMessages1$1) {
        return topic1Log$1.logEndOffset() == (long)totalMessages1$1.elem && $this.tierLogSegments(topic1Log$1).size() >= topic1Log$1.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicWithTieredStorageDisabled$2() {
        return "Timeout waiting for all messages to be written and tiered";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicWithTieredStorageDisabled$3(DisableTierStorageTest $this, AbstractLog topic2Log$1, IntRef totalMessages2$1) {
        return topic2Log$1.logEndOffset() == (long)totalMessages2$1.elem && $this.tierLogSegments(topic2Log$1).size() >= topic2Log$1.numberOfSegments() - 1;
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicWithTieredStorageDisabled$4() {
        return "Timeout waiting for all messages to be written and tiered";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicWithTieredStorageDisabled$5(AbstractLog topic2Log$1) {
        return !topic2Log$1.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDeleteTopicWithTieredStorageDisabled$6() {
        return "Timed out waiting for tiered storage to be turned off";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionWithTieredStorageDisabled$4(Partition partition$1) {
        return ((AbstractLog)partition$1.log().get()).tierPartitionState().numSegments() >= ((AbstractLog)partition$1.log().get()).numberOfSegments() - 1 && ((AbstractLog)partition$1.log().get()).localLogStartOffset() > Predef$.MODULE$.Long2long((Long)((AbstractLog)partition$1.log().get()).tierPartitionState().startOffset().get());
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionWithTieredStorageDisabled$5() {
        return "Timed out waiting for segments to be tiered and deleted from local storage";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionWithTieredStorageDisabled$6(Partition partition$1) {
        return !((AbstractLog)partition$1.log().get()).tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionWithTieredStorageDisabled$7() {
        return "Timed out waiting for tiering to disable";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionWithTieredStorageDisabled$8(LongRef expectedLogStartOffset$1, Partition partition$1) {
        return expectedLogStartOffset$1.elem == partition$1.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionWithTieredStorageDisabled$9(Partition partition$1, LongRef expectedLogStartOffset$1) {
        return new StringBuilder(46).append("Unexpected log start offset: ").append(partition$1.logStartOffset()).append(" Expected value: ").append(expectedLogStartOffset$1.elem).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testLogRetentionWithTieredStorageDisabled$2(DisableTierStorageTest $this, ObjectRef topic$1, int numMessages$1, Tuple2 x$3) {
        if (x$3 != null) {
            long retentionSizeBytes;
            String configVal = (String)x$3._1();
            int index = x$3._2$mcI$sp();
            $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Testing topic created with config.TierEnable = ").append(configVal).toString());
            $this.props().put("confluent.tier.enable", configVal);
            topic$1.elem = new StringBuilder(1).append($this.topicName()).append("-").append(index).toString();
            int leaderId = BoxesRunTime.unboxToInt((Object)$this.createTopic((String)topic$1.elem, 1, 1, $this.props()).apply((Object)BoxesRunTime.boxToInteger((int)0)));
            Partition partition = ((KafkaServer)$this.serverForId(leaderId).get()).replicaManager().getPartitionOrException(new TopicPartition((String)topic$1.elem, 0));
            while (((AbstractLog)partition.log().get()).numberOfSegments() < 4) {
                TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)$this.servers().toSeq(), (String)topic$1.elem, numMessages$1, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
            }
            LongRef expectedLogStartOffset = LongRef.create((long)0L);
            String string = configVal;
            String string2 = "true";
            if (string != null && string.equals(string2)) {
                long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l2 = 30000L;
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$4(partition)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$5());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                $this.changeTopicConfig("confluent.tier.enable", "false", (String)topic$1.elem);
                long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l4 = 30000L;
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime2 = System.currentTimeMillis();
                while (!DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$6(partition)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$7());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                List<TierLogSegment> tieredSegments = $this.tierLogSegments((AbstractLog)partition.log().get());
                retentionSizeBytes = ((AbstractLog)partition.log().get()).size() - (long)(((TierLogSegment)tieredSegments.head()).size() + 1);
                expectedLogStartOffset.elem = ((TierLogSegment)tieredSegments.apply(1)).baseOffset();
            } else {
                retentionSizeBytes = ((AbstractLog)partition.log().get()).size() - (long)(((LogSegment)((AbstractLog)partition.log().get()).localLogSegments().head()).size() + 1);
                expectedLogStartOffset.elem = ((LogSegment)((AbstractLog)partition.log().get()).localLogSegments().toList().apply(1)).baseOffset();
            }
            $this.changeTopicConfig("retention.bytes", Long.toString(retentionSizeBytes), (String)topic$1.elem);
            long l = 10L;
            long l5 = 60000L;
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$8(expectedLogStartOffset, partition)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)DisableTierStorageTest.$anonfun$testLogRetentionWithTieredStorageDisabled$9(partition, expectedLogStartOffset));
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$1(AbstractLog log$3) {
        return log$3.tierPartitionState().numSegments() >= log$3.numberOfSegments() - 1 && log$3.localLogStartOffset() > Predef$.MODULE$.Long2long((Long)log$3.tierPartitionState().startOffset().get());
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$2() {
        return "Timed out waiting for segments to be tiered and deleted from local storage";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$3(AbstractLog log$3) {
        return !log$3.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$4() {
        return "Timed out waiting for tiering to disable";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$5(AbstractLog log$3, List segmentsNotTiered$1) {
        return log$3.logStartOffset() >= ((LogSegment)segmentsNotTiered$1.apply(1)).baseOffset();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$6() {
        return "Timed out waiting for retention to delete some local segments";
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$7(AbstractLog log$3) {
        return log$3.localLogStartOffset() == log$3.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$8(AbstractLog log$3) {
        return new StringBuilder(39).append("LogStartOffset ").append(log$3.logStartOffset()).append(" != localLogStartOffset ").append(log$3.localLogStartOffset()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$9(AbstractLog log$3) {
        return !log$3.tierPartitionState().startOffset().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testLogRetentionAfterTieredDataIsDeletedAndTieredStorageDisabled$10() {
        return "FirstTieredOffset is defined after all tiered segments are deleted";
    }

    public static final /* synthetic */ boolean $anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$1(AbstractLog log$4) {
        return !log$4.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ String $anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$2() {
        return "Timed out waiting for tiered storage to be turned off";
    }

    public static final /* synthetic */ boolean $anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$3(AbstractLog log$4) {
        return log$4.tierPartitionState().numSegments() == 0;
    }

    public static final /* synthetic */ String $anonfun$testDeletionTaskStateMachineWhenTierStorageDisabled$4() {
        return "Timed out waiting for all tiered segments to delete";
    }
}

