/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Properties;
import java.util.UUID;
import kafka.server.KafkaConfig$;
import kafka.tier.TierTestUtils$;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.state.ChecksumMigration;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.FileTierPartitionStateTest;
import kafka.tier.state.Header;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionStatus;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.checksum.Algorithm;
import kafka.utils.checksum.CheckedFileIO;
import org.apache.kafka.common.config.ConfigException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u000194A!\u0003\u0006\u0001#!)a\u0003\u0001C\u0001/!)\u0011\u0004\u0001C!5!)\u0011\u0005\u0001C\u0005E!)!\t\u0001C\u0001\u0007\")\u0011\u000b\u0001C\u0001\u0007\")1\u000b\u0001C\u0005)\")!\u000e\u0001C\u0001\u0007\")A\u000e\u0001C\u0001\u0007\n)c)\u001b7f)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$Xm\u00115fG.\u001cX/\\7fIR+7\u000f\u001e\u0006\u0003\u00171\tQa\u001d;bi\u0016T!!\u0004\b\u0002\tQLWM\u001d\u0006\u0002\u001f\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\u000b\u0013\t)\"B\u0001\u000eGS2,G+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u00021A\u00111\u0003A\u0001\u0010G\",7m[:v[\u0016s\u0017M\u00197fIV\t1\u0004\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SDA\u0004C_>dW-\u00198\u00027\r|W\u000e]1sKRKWM]*uCR,g)\u001b7fg\"+G\u000e]3s)!\u0019c\u0005M\u001b;yy\u0002\u0005C\u0001\u000f%\u0013\t)SD\u0001\u0003V]&$\b\"B\u0014\u0004\u0001\u0004A\u0013\u0001D8mI\u0006cwm\u001c:ji\"l\u0007CA\u0015/\u001b\u0005Q#BA\u0016-\u0003!\u0019\u0007.Z2lgVl'BA\u0017\u000f\u0003\u0015)H/\u001b7t\u0013\ty#FA\u0005BY\u001e|'/\u001b;i[\")\u0011g\u0001a\u0001e\u0005aq\u000e\u001c3US\u0016\u0014X\t]8dQB\u0011AdM\u0005\u0003iu\u00111!\u00138u\u0011\u001514\u00011\u00018\u00031yG\u000eZ#oI>3gm]3u!\ta\u0002(\u0003\u0002:;\t!Aj\u001c8h\u0011\u0015Y4\u00011\u0001)\u00031qWm^!mO>\u0014\u0018\u000e\u001e5n\u0011\u0015i4\u00011\u00013\u00031qWm\u001e+jKJ,\u0005o\\2i\u0011\u0015y4\u00011\u00018\u00031qWm^#oI>3gm]3u\u0011\u0015\t5\u00011\u0001\u001c\u0003\u0019\u0011Xm];mi\u0006IB/Z:u\u0007>l\u0007/\u0019:f)&,'o\u0015;bi\u00164\u0015\u000e\\3t)\u0005\u0019\u0003F\u0001\u0003F!\t1u*D\u0001H\u0015\tA\u0015*A\u0002ba&T!AS&\u0002\u000f),\b/\u001b;fe*\u0011A*T\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u001d\u0006\u0019qN]4\n\u0005A;%\u0001\u0002+fgR\fa\u0002^3tiB\u0013x\u000e]3si&,7\u000f\u000b\u0002\u0006\u000b\u0006Q\u0001O]8qKJ$\u0018.Z:\u0015\u0005Uk\u0006C\u0001,\\\u001b\u00059&B\u0001-Z\u0003\u0011)H/\u001b7\u000b\u0003i\u000bAA[1wC&\u0011Al\u0016\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"\u00020\u0007\u0001\u0004y\u0016AD2iK\u000e\\7/^7D_:4\u0017n\u001a\t\u0003A\u001et!!Y3\u0011\u0005\tlR\"A2\u000b\u0005\u0011\u0004\u0012A\u0002\u001fs_>$h(\u0003\u0002g;\u00051\u0001K]3eK\u001aL!\u0001[5\u0003\rM#(/\u001b8h\u0015\t1W$\u0001\u0011sK\u0006$wK]5uK\"+\u0017\rZ3s\u001f:d\u0017pV5uQ6KwM]1uS>t\u0007FA\u0004F\u0003Q!Xm\u001d;WC2LG-\u0019;f\u0007\",7m[:v[\"\u0012\u0001\"\u0012")
public class FileTierPartitionStateChecksummedTest
extends FileTierPartitionStateTest {
    @Override
    public boolean checksumEnabled() {
        return true;
    }

    private void compareTierStateFilesHelper(Algorithm oldAlgorithm, int oldTierEpoch, long oldEndOffset, Algorithm newAlgorithm, int newTierEpoch, long newEndOffset, boolean result) {
        Path oldPath = new File(new StringBuilder(8).append("testFile").append(oldAlgorithm.suffix).toString()).toPath();
        Path newPath = new File(new StringBuilder(8).append("testFile").append(newAlgorithm.suffix).toString()).toPath();
        this.writeHeader$1(oldPath, oldAlgorithm, oldTierEpoch, oldEndOffset);
        this.writeHeader$1(newPath, newAlgorithm, newTierEpoch, newEndOffset);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)result), (Object)BoxesRunTime.boxToBoolean((boolean)ChecksumMigration.compareTierStateFiles((Path)oldPath, (Path)newPath)));
        Files.delete(oldPath);
        Files.delete(newPath);
    }

    @Test
    public void testCompareTierStateFiles() {
        this.checkDifferentAlgorithmCombinations$1(3, 10L, 5, 20L, true);
        this.checkDifferentAlgorithmCombinations$1(3, 10L, 3, 20L, true);
        this.checkDifferentAlgorithmCombinations$1(5, 30L, 3, 20L, false);
    }

    @Test
    public void testProperties() {
        Assertions.assertThrows(ConfigException.class, () -> KafkaConfig$.MODULE$.fromProps(this.properties("none, tierstate")));
        Assertions.assertThrows(ConfigException.class, () -> KafkaConfig$.MODULE$.fromProps(this.properties("all, tierstate")));
        Assertions.assertThrows(ConfigException.class, () -> KafkaConfig$.MODULE$.fromProps(this.properties("all, none")));
        java.util.List checksumFiles = KafkaConfig$.MODULE$.fromProps(this.properties("tierstate")).checksumEnabledFiles();
        Assertions.assertEquals((int)1, (int)checksumFiles.size());
        Assertions.assertTrue((boolean)checksumFiles.contains("tierstate"));
    }

    /*
     * WARNING - void declaration
     */
    private Properties properties(String checksumConfig) {
        void var2_2;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "somewhere", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put("confluent.checksum.enabled.files", checksumConfig);
        return var2_2;
    }

    @Test
    public void readWriteHeaderOnlyWithMigration() {
        Path flushedPath = Paths.get(this.state().flushedPath(), new String[0]);
        Path adlerChecksumPath = CheckedFileIO.validPath((Algorithm)Algorithm.ADLER, (Path)flushedPath);
        Path nonChecksumPath = CheckedFileIO.validPath((Algorithm)Algorithm.NO_CHECKSUM, (Path)flushedPath);
        Assertions.assertTrue((boolean)Files.exists(adlerChecksumPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.notExists(nonChecksumPath, new LinkOption[0]));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 9, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((int)9, (int)this.state().tierEpoch());
        this.state().close();
        FileTierPartitionState reopenedState = (FileTierPartitionState)this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler(), Predef$.MODULE$.boolean2Boolean(true));
        Assertions.assertTrue((boolean)Files.exists(adlerChecksumPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.notExists(nonChecksumPath, new LinkOption[0]));
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)9, (int)reopenedState.tierEpoch());
        reopenedState.close();
        reopenedState = (FileTierPartitionState)this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler(), Predef$.MODULE$.boolean2Boolean(false));
        Assertions.assertTrue((boolean)Files.notExists(adlerChecksumPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.exists(nonChecksumPath, new LinkOption[0]));
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)9, (int)reopenedState.tierEpoch());
        reopenedState.close();
        reopenedState = (FileTierPartitionState)this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler(), Predef$.MODULE$.boolean2Boolean(true));
        Assertions.assertTrue((boolean)Files.exists(adlerChecksumPath, new LinkOption[0]));
        Assertions.assertTrue((boolean)Files.notExists(nonChecksumPath, new LinkOption[0]));
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)9, (int)reopenedState.tierEpoch());
        reopenedState.close();
    }

    @Test
    public void testValidateChecksum() {
        Assertions.assertTrue((boolean)this.state().validateChecksum());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertTrue((boolean)this.state().validateChecksum());
        int numSegments = 200;
        int epoch = 0;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        IntRef size = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.uploadInitateAndComplete(epoch, UUID.randomUUID(), i * 2, i * 2 + 1, 100);
            size$1.elem += i;
        });
        Assertions.assertTrue((boolean)this.state().validateChecksum());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertTrue((boolean)this.state().validateChecksum());
    }

    private static final short superBlockLen$1(Algorithm algorithm) {
        Algorithm algorithm2 = algorithm;
        Algorithm algorithm3 = Algorithm.ADLER;
        if (!(algorithm2 != null ? !algorithm2.equals(algorithm3) : algorithm3 != null)) {
            return 512;
        }
        return 0;
    }

    private final Header header$1(int tierEpoch, long endOffset) {
        return new Header(this.tpid().topicId(), this.state().version(), tierEpoch, TierPartitionStatus.INIT, -1L, endOffset, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY);
    }

    private final void writeHeader$1(Path path, Algorithm algorithm, int tierEpoch, long endOffset) {
        short superBlockLength = FileTierPartitionStateChecksummedTest.superBlockLen$1(algorithm);
        Files.deleteIfExists(path);
        CheckedFileIO.create((Path)path, (Algorithm)algorithm, (short)superBlockLength);
        CheckedFileIO channel = CheckedFileIO.open((Path)path, (boolean)true, (OpenOption[])new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE});
        FileTierPartitionState.writeHeader((CheckedFileIO)channel, (Header)this.header$1(tierEpoch, endOffset));
        channel.flush();
        Assertions.assertEquals((int)tierEpoch, (int)((Header)FileTierPartitionState.readHeader((CheckedFileIO)channel).get()).tierEpoch());
        channel.close();
    }

    private final void checkDifferentAlgorithmCombinations$1(int oldTierEpoch, long oldEndOffset, int newTierEpoch, long newEndOffset, boolean result) {
        new .colon.colon((Object)new Tuple2((Object)Algorithm.ADLER, (Object)Algorithm.NO_CHECKSUM), (List)new .colon.colon((Object)new Tuple2((Object)Algorithm.NO_CHECKSUM, (Object)Algorithm.ADLER), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)algo -> {
            this.compareTierStateFilesHelper((Algorithm)algo._1(), oldTierEpoch, oldEndOffset, (Algorithm)algo._2(), newTierEpoch, newEndOffset, result);
            return BoxedUnit.UNIT;
        });
    }
}

