/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import com.google.flatbuffers.FlatBufferBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.TierLogSegment;
import kafka.server.LogDirFailureChannel;
import kafka.tier.TierTestUtils$;
import kafka.tier.TopicIdPartition;
import kafka.tier.domain.AbstractTierMetadata;
import kafka.tier.domain.AbstractTierSegmentMetadata;
import kafka.tier.domain.TierObjectMetadata;
import kafka.tier.domain.TierPartitionFence;
import kafka.tier.domain.TierPartitionForceRestore;
import kafka.tier.domain.TierPartitionUnfreezeLogStartOffset;
import kafka.tier.domain.TierSegmentDeleteComplete;
import kafka.tier.domain.TierSegmentDeleteInitiate;
import kafka.tier.domain.TierSegmentUploadComplete;
import kafka.tier.domain.TierSegmentUploadInitiate;
import kafka.tier.domain.TierTopicInitLeader;
import kafka.tier.serdes.TierPartitionStateEntry;
import kafka.tier.serdes.UUID;
import kafka.tier.state.FileTierPartitionIterator;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.SegmentState;
import kafka.tier.state.TierPartitionState;
import kafka.tier.state.TierPartitionStateFactory;
import kafka.tier.state.TierPartitionStatus;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tools.DumpTierPartitionState;
import kafka.utils.CheckedFileIOTestUtils$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.checksum.Algorithm;
import kafka.utils.checksum.CheckedFileIO;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenSetLike;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.VolatileIntRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\u0015f\u0001\u00023f\u00011DQa\u001d\u0001\u0005\u0002QDQa\u001e\u0001\u0005\u0002aDq\u0001 \u0001C\u0002\u0013\u0005Q\u0010C\u0004\u0002\u000e\u0001\u0001\u000b\u0011\u0002@\t\u0013\u0005=\u0001A1A\u0005\u0002\u0005E\u0001\u0002CA\r\u0001\u0001\u0006I!a\u0005\t\u0013\u0005m\u0001A1A\u0005\u0002\u0005u\u0001\u0002CA\u0013\u0001\u0001\u0006I!a\b\t\u0013\u0005\u001d\u0002A1A\u0005\u0002\u0005%\u0002\u0002CA\u001e\u0001\u0001\u0006I!a\u000b\t\u0013\u0005u\u0002A1A\u0005\u0002\u0005%\u0002\u0002CA \u0001\u0001\u0006I!a\u000b\t\u0013\u0005\u0005\u0003A1A\u0005\u0002\u0005\r\u0003\u0002CA.\u0001\u0001\u0006I!!\u0012\t\u0013\u0005u\u0003A1A\u0005\u0002\u0005}\u0003\u0002CA5\u0001\u0001\u0006I!!\u0019\t\u0013\u0005-\u0004A1A\u0005\u0002\u00055\u0004\u0002CA>\u0001\u0001\u0006I!a\u001c\t\u0013\u0005u\u0004A1A\u0005\u0002\u0005}\u0004\u0002CAE\u0001\u0001\u0006I!!!\t\u0011\u0019\u0004!\u0019!C\u0001\u0003\u0017C\u0001\"a%\u0001A\u0003%\u0011Q\u0012\u0005\n\u0003+\u0003!\u0019!C\u0001\u0003/C\u0001\"!*\u0001A\u0003%\u0011\u0011\u0014\u0005\b\u0003O\u0003A\u0011AAU\u0011\u001d\t9\r\u0001C\u0001\u0003SCq!!5\u0001\t\u0003\tI\u000bC\u0004\u0002\\\u0002!\t!!+\t\u000f\u0005}\u0007\u0001\"\u0001\u0002*\"9\u00111\u001d\u0001\u0005\u0002\u0005%\u0006bBAt\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0003W\u0004A\u0011AAU\u0011\u001d\ty\u000f\u0001C\u0001\u0003SCq!a=\u0001\t\u0003\tI\u000bC\u0004\u0002x\u0002!\t!!+\t\u000f\u0005m\b\u0001\"\u0001\u0002*\"9\u0011q \u0001\u0005\u0002\u0005%\u0006b\u0002B\u0002\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0005\u000f\u0001A\u0011AAU\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0003SCqAa\u0004\u0001\t\u0003\tI\u000bC\u0004\u0003\u0014\u0001!\t!!+\t\u000f\t]\u0001\u0001\"\u0001\u0002*\"9!1\u0004\u0001\u0005\u0002\u0005%\u0006b\u0002B\u0010\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0005G\u0001A\u0011AAU\u0011\u001d\u00119\u0003\u0001C\u0001\u0003SCqAa\u000b\u0001\t\u0003\tI\u000bC\u0004\u00030\u0001!\t!!+\t\u000f\tM\u0002\u0001\"\u0001\u0002*\"9!q\u0007\u0001\u0005\u0002\u0005%\u0006b\u0002B\u001e\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0005\u007f\u0001A\u0011AAU\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u0003SCqAa\u0012\u0001\t\u0003\tI\u000bC\u0004\u0003L\u0001!\t!!+\t\u000f\t=\u0003\u0001\"\u0001\u0002*\"9!1\u000b\u0001\u0005\u0002\u0005%\u0006b\u0002B,\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u00057\u0002A\u0011AAU\u0011\u001d\u0011y\u0006\u0001C\u0001\u0003SCqAa\u0019\u0001\t\u0003\tI\u000bC\u0004\u0003h\u0001!\t!!+\t\u000f\t-\u0004\u0001\"\u0001\u0002*\"9!q\u000e\u0001\u0005\u0002\u0005%\u0006b\u0002B:\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0005o\u0002A\u0011AAU\u0011\u001d\u0011Y\b\u0001C\u0001\u0003SCqAa \u0001\t\u0003\tI\u000bC\u0004\u0003\u0004\u0002!\t!!+\t\u000f\t\u001d\u0005\u0001\"\u0001\u0002*\"9!1\u0012\u0001\u0005\u0002\u0005%\u0006b\u0002BH\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0005'\u0003A\u0011AAU\u0011\u001d\u00119\n\u0001C\u0001\u0003SCqAa'\u0001\t\u0003\tI\u000bC\u0004\u0003 \u0002!\t!!+\t\u000f\t\r\u0006\u0001\"\u0001\u0002*\"9!q\u0015\u0001\u0005\u0002\u0005%\u0006b\u0002BV\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0005_\u0003A\u0011AAU\u0011\u001d\u0011\u0019\f\u0001C\u0001\u0003SCqAa.\u0001\t\u0003\tI\u000bC\u0004\u0003<\u0002!\t!!+\t\u000f\t}\u0006\u0001\"\u0001\u0002*\"9!1\u0019\u0001\u0005\u0002\u0005%\u0006b\u0002Bd\u0001\u0011\u0005\u0011\u0011\u0016\u0005\b\u0005\u0017\u0004A\u0011AAU\u0011\u001d\u0011y\r\u0001C\u0001\u0003SCqAa5\u0001\t\u0003\tI\u000bC\u0004\u0003X\u0002!\t!!+\t\u000f\tm\u0007\u0001\"\u0003\u0003^\"9!Q\u001d\u0001\u0005\u0002\t\u001d\bbBB\u000b\u0001\u0011%1q\u0003\u0005\b\u0007;\u0001A\u0011BB\u0010\u0011\u001d\u0019i\u0002\u0001C\u0005\u0007KBqaa\u001e\u0001\t\u0003\tI\u000bC\u0004\u0004|\u0001!Ia! \t\u000f\r\u001d\u0005\u0001\"\u0003\u0004\n\nQb)\u001b7f)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$X\rV3ti*\u0011amZ\u0001\u0006gR\fG/\u001a\u0006\u0003Q&\fA\u0001^5fe*\t!.A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001i\u0007C\u00018r\u001b\u0005y'\"\u00019\u0002\u000bM\u001c\u0017\r\\1\n\u0005I|'AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002kB\u0011a\u000fA\u0007\u0002K\u0006y1\r[3dWN,X.\u00128bE2,G-F\u0001z!\tq'0\u0003\u0002|_\n9!i\\8mK\u0006t\u0017!E2iK\u000e\\7/^7BY\u001e|'/\u001b;i[V\ta\u0010E\u0002\u0000\u0003\u0013i!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\tG\",7m[:v[*\u0019\u0011qA5\u0002\u000bU$\u0018\u000e\\:\n\t\u0005-\u0011\u0011\u0001\u0002\n\u00032<wN]5uQ6\f!c\u00195fG.\u001cX/\\!mO>\u0014\u0018\u000e\u001e5nA\u0005\u00012/\u001e9fe\ncwnY6MK:<G\u000f[\u000b\u0003\u0003'\u00012A\\A\u000b\u0013\r\t9b\u001c\u0002\u0006'\"|'\u000f^\u0001\u0012gV\u0004XM\u001d\"m_\u000e\\G*\u001a8hi\"\u0004\u0013a\u00024bGR|'/_\u000b\u0003\u0003?\u00012A^A\u0011\u0013\r\t\u0019#\u001a\u0002\u001a)&,'\u000fU1si&$\u0018n\u001c8Ti\u0006$XMR1di>\u0014\u00180\u0001\u0005gC\u000e$xN]=!\u0003%\u0001\u0018M]3oi\u0012K'/\u0006\u0002\u0002,A!\u0011QFA\u001c\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012AA5p\u0015\t\t)$\u0001\u0003kCZ\f\u0017\u0002BA\u001d\u0003_\u0011AAR5mK\u0006Q\u0001/\u0019:f]R$\u0015N\u001d\u0011\u0002\u0007\u0011L'/\u0001\u0003eSJ\u0004\u0013A\u0001;q+\t\t)\u0005\u0005\u0003\u0002H\u0005]SBAA%\u0015\u0011\tY%!\u0014\u0002\r\r|W.\\8o\u0015\rQ\u0017q\n\u0006\u0005\u0003#\n\u0019&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003+\n1a\u001c:h\u0013\u0011\tI&!\u0013\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0019A\u000f\u001d\u0011\u0002\tQ\u0004\u0018\u000eZ\u000b\u0003\u0003C\u0002B!a\u0019\u0002f5\tq-C\u0002\u0002h\u001d\u0014\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0002\u000bQ\u0004\u0018\u000e\u001a\u0011\u0002)1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3m+\t\ty\u0007\u0005\u0003\u0002r\u0005]TBAA:\u0015\r\t)([\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005e\u00141\u000f\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0002+1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3mA\u0005!A/[7f+\t\t\t\t\u0005\u0003\u0002\u0004\u0006\u0015UBAA\u0003\u0013\u0011\t9)!\u0002\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002*\"!!$\u0011\u0007Y\fy)C\u0002\u0002\u0012\u0016\u0014aCR5mKRKWM\u001d)beRLG/[8o'R\fG/Z\u0001\u0007gR\fG/\u001a\u0011\u0002\u00131|wmQ8oM&<WCAAM!\u0011\tY*!)\u000e\u0005\u0005u%bAAPS\u0006\u0019An\\4\n\t\u0005\r\u0016Q\u0014\u0002\n\u0019><7i\u001c8gS\u001e\f!\u0002\\8h\u0007>tg-[4!\u0003\u0015\u0019X\r^;q)\t\tY\u000bE\u0002o\u0003[K1!a,p\u0005\u0011)f.\u001b;)\u0007e\t\u0019\f\u0005\u0003\u00026\u0006\rWBAA\\\u0015\u0011\tI,a/\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002>\u0006}\u0016a\u00026va&$XM\u001d\u0006\u0005\u0003\u0003\f\u0019&A\u0003kk:LG/\u0003\u0003\u0002F\u0006]&A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1sI><h\u000eK\u0002\u001b\u0003\u0017\u0004B!!.\u0002N&!\u0011qZA\\\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0015uKN$hi\u001c:dKJ+7\u000f^8sK2{wm\u0015;beR|eMZ:fiV\u001bXM]#se>\u00148\u000fK\u0002\u001c\u0003+\u0004B!!.\u0002X&!\u0011\u0011\\A\\\u0005\u0011!Vm\u001d;\u0002SQ,7\u000f^+oMJ,WM_3M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;Fm\u0016tG/V:fe\u0016\u0013(o\u001c:tQ\ra\u0012Q[\u0001;i\u0016\u001cH\u000fV8qS\u000e<\u0016\u000e\u001e5US\u0016\u0014H)[:bE2,G\rR8fg:{G\u000fS1wKRKWM\u001d)beRLG/[8o'R\fG/\u001a$jY\u0016D3!HAk\u0003M\u0011X-\u00193Xe&$X\rS3bI\u0016\u0014xJ\u001c7zQ\rq\u0012Q[\u0001\u0018i\u0016\u001cH\u000f\u0015:fm&|Wo](gMN,G/\u0012<f]RD3aHAk\u0003m!Xm\u001d;BaB,g\u000eZ#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8`c!\u001a\u0001%!6\u00027Q,7\u000f^!qa\u0016tG-\u00129pG\"4\u0016\r\\5eCRLwN\\03Q\r\t\u0013Q[\u0001\u0018i\u0016\u001cHo\u00144gg\u0016$\u0018j]%oGJ,W.\u001a8uK\u0012D3AIAk\u0003a\u0019XM]5bY&TX\rR3tKJL\u0017\r\\5{KR+7\u000f\u001e\u0015\u0004G\u0005U\u0017AD:fO6,g\u000e^$baR+7\u000f\u001e\u0015\u0004I\u0005U\u0017AE:fO6,g\u000e^(wKJd\u0017\r\u001d+fgRD3!JAk\u0003=)\b\u000fZ1uK\u0016\u0003xn\u00195UKN$\bf\u0001\u0014\u0002V\u0006\u0019R\u000f\u001d3bi\u0016,e\u000eZ(gMN,G\u000fV3ti\"\u001aq%!6\u0002+\u0019dWo\u001d5Bm\u0006LG.\u00192jY&$\u0018\u0010V3ti\"\u001a\u0001&!6\u0002AQ,7\u000f\u001e*f_B,gNR5mK\u00063G/\u001a:WKJ\u001c\u0018n\u001c8DQ\u0006tw-\u001a\u0015\u0004S\u0005U\u0017\u0001\n;fgR|enZ8j]\u001e,\u0006\u000f\\8bI:{GOV5tS\ndW\rV8SK\u0006$WM]:)\u0007)\n).\u0001\u0013uKN$X*\u001a;bI\u0006$\u0018MU3bIJ+G/\u001e:ogZ\u000bG.\u001b3TK\u001elWM\u001c;tQ\rY\u0013Q[\u0001.i\u0016\u001cH/T;mi&\u0004H.Z%oSRL\u0017\r^3t'\u000e\fgN\\3e\u0007>\u0014(/Z2uYf|eNU3m_\u0006$\u0007f\u0001\u0017\u0002V\u0006aB/Z:u+Bdw.\u00193Bi2{w/\u001a:Fa>\u001c\u0007NR3oG\u0016$\u0007fA\u0017\u0002V\u0006iB/Z:u+Bdw.\u00193Bi\"Kw\r[3s\u000bB|7\r\u001b$bS2,G\rK\u0002/\u0003+\fQ\u0004^3ti\u0012+G.\u001a;f\u0003RD\u0015n\u001a5fe\u0016\u0003xn\u00195GC&dW\r\u001a\u0015\u0004_\u0005U\u0017a\u0006;fgR|enZ8j]\u001e,\u0006\u000f\\8bI\u001a+gnY3eQ\r\u0001\u0014Q[\u0001)i\u0016\u001cHo\u00148h_&tw-\u00169m_\u0006$g)\u001a8dK\u0012\fe\r^3s\u0019\u0016\fG-\u001a:DQ\u0006tw-\u001a\u0015\u0004c\u0005U\u0017!\t;fgR4UM\\2fIN+w-\\3oi\"\u000bg\u000e\u001a7j]\u001e|eNU3pa\u0016t\u0007f\u0001\u001a\u0002V\u0006\u0019C/Z:u\r\u0016t7-\u001a3TK\u001elWM\u001c;IC:$G.\u001b8h\u001f:$U\r\\3uS>t\u0007fA\u001a\u0002V\u0006\u0011B/Z:u\t\u0016dW\r^3TK\u001elWM\u001c;tQ\r!\u0014Q[\u0001\u001ei\u0016\u001cH\u000fR3mKR,7+Z4nK:$8oV5uQ>3XM\u001d7ba\"\u001aQ'!6\u0002OQ,7\u000f^#oI>3gm]3u\u0013N$&/Y2lK\u00124uN\u001d#fY\u0016$XmU3h[\u0016tGo\u001d\u0015\u0004m\u0005U\u0017a\u000e;fgR,e\u000eZ(gMN,G/S:Ue\u0006\u001c7.\u001a3G_J\u001cVmZ7f]R\u001ch)\u001a8dK\u0012|e\u000eR3mKR,\u0017J\\5uS\u0006$X\rK\u00028\u0003+\fa\u0003^3ti6\u000bG/\u001a:jC2L'0\u001a3PM\u001a\u001cX\r\u001e\u0015\u0004q\u0005U\u0017a\r;fgR\fE\u000e\\8xK\u0012$&/\u00198tSRLwN\\+qY>\fG-\u00138ji&\fG/\u001a+p\t\u0016dW\r^3J]&$\u0018.\u0019;fQ\rI\u0014Q[\u00010i\u0016\u001cH/\u00137mK\u001e\fG\u000e\u0016:b]NLG/[8o\u0013:LG\u000fT3bI\u0016\u0014Hk\\+qY>\fGmQ8na2,G/\u001a\u0015\u0004u\u0005U\u0017a\f;fgRLE\u000e\\3hC2$&/\u00198tSRLwN\\%oSRdU-\u00193feR{G)\u001a7fi\u0016Le.\u001b;jCR,\u0007fA\u001e\u0002V\u0006yC/Z:u\u00132dWmZ1m)J\fgn]5uS>t\u0017J\\5u\u0019\u0016\fG-\u001a:U_\u0012+G.\u001a;f\u0007>l\u0007\u000f\\3uK\"\u001aA(!6\u0002gQ,7\u000f^%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]V\u0003Hn\\1e\u0013:LG/[1uKR{G)\u001a7fi\u0016\u001cu.\u001c9mKR,\u0007fA\u001f\u0002V\u0006\tD/Z:u\u00132dWmZ1m)J\fgn]5uS>tW\u000b\u001d7pC\u0012\u001cu.\u001c9mKR,G)\u001a7fi\u0016\u001cu.\u001c9mKR,\u0007f\u0001 \u0002V\u0006!C/Z:u'R\fG/Z+qI\u0006$XMR1jYV\u0014XMR3oG&tw-\u00128bE2,G\rK\u0002@\u0003+\fq\u0007^3tiN#\u0018\r^3Va\u0012\fG/\u001a$bS2,(/\u001a$f]\u000eLgn\u001a$mkNDW*Z2iC:L7/\\0WS\u0006\u0014\u0015\rZ#wK:$\bf\u0001!\u0002V\u0006\u0011E/Z:u'R\fG/Z+qI\u0006$XMR1jYV\u0014XMR3oG&twM\u00127vg\"lUm\u00195b]&\u001cXn\u0018,jCB\u000b'\u000f^5uS>tg)\u001a8dK\u00163XM\u001c;)\u0007\u0005\u000b).A\u001buKN$8\u000b^1uKV\u0003H-\u0019;f\r\u0006LG.\u001e:f\r\u0016t7-\u001b8h\r2,8\u000f[0EkJLgnZ!cg\u0016tG\u000fS3bI\u0016\u0014\bf\u0001\"\u0002V\u0006\u0011C/Z:u\u0013\u0012,W\u000e]8uK:\u001c\u0017\u0010R3mKR,\u0017I\u001a;fe\u000e{W\u000e\u001d7fi\u0016D3aQAk\u0003q!Xm\u001d;JI\u0016l\u0007o\u001c;f]\u000eLH)\u001a7bs\u0016$G)\u001a7fi\u0016D3\u0001RAk\u0003=\"Xm\u001d;Ti\u0006$XMU3ti>\u0014XmQ8na2,G/Z:UCJ<W\r^(cU\u0016\u001cG/\u00133MSN$XM\\3sQ\r)\u0015Q[\u0001\u001ei\u0016\u001cHo\u0015;bi\u0016\u0014Vm\u001d;pe\u00164UO\\2uS>t\u0017\r\\5us\"\u001aa)!6\u0002IQ,7\u000f^*uCR,'+Z:u_J,g)\u001a8dS:<7\u000b^1mK6+G/\u00193bi\u0006D3aRAk\u0003=\"Xm\u001d;FeJ|'o\u0015;bi\u0016\u0014Vm\u001d;pe\u0016,\u0006\u000f\\8bIN\u000bW.Z*fO6,g\u000e^*b[\u0016,\u0005o\\2iQ\rA\u0015Q[\u0001%i\u0016\u001cHOR3oG\u0016\u001cuN\u001c;j]V,G-\u00169m_\u0006$\u0017I\u001a;feJ+7\u000f^8sK\"\u001a\u0011*!6\u0002SQ,7\u000f^*uCR,'+Z:u_J,7)Y;tS:<GK];oG\u0006$X-\u00118e%\u0016\f\u0007\u000f\u001d7zQ\rQ\u0015Q[\u0001\u001fi\u0016\u001cHo\u0015;bi\u0016\u0014Vm\u001d;pe\u0016l\u0015n\u001a:bi\u00164VM]:j_:D3aSAk\u0003\u0019\"Xm\u001d;Ti\u0006$XMU3ti>\u0014Xm\u00117pg\u0016\u001cH*[:uK:,'o]#bO\u0016\u0014H.\u001f\u0015\u0004\u0019\u0006U\u0017A\n;fgR\u001cF/\u0019;f%\u0016\u001cHo\u001c:f\t\u0016d\u0017-_3e\u00072|7/Z(o\u001f2$7\u000b^1uK\"\u001aQ*!6\u0002CQ,7\u000f^%eK6\u0004x\u000e^3oGf\u001c\u0016.\\;mi\u0006tWm\\;t\t\u0016dW\r^3)\u00079\u000b).A\ruKN$\u0018\nZ3na>$XM\u001c;f]\u000eLh)\u001a8dS:<\u0007fA(\u0002V\u0006AC/Z:u\u001b\u0006$XM]5bY&T\u0018\r^5p]&s\u0017\u000e^5bY&T\u0018\r^5p]R\u0013\u0018mY6fe\"\u001a\u0001+!6\u0002cQ,7\u000f^'bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8MSN$XM\\3s)\u0006\u0014x-\u001a;PM\u001a\u001cX\r^\"p[BdW\r^5p]\"\u001a\u0011+!6\u0002[Q,7\u000f^'bi\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8MSN$XM\\3s\u001f\nTWm\u0019;JI\u000e{W\u000e\u001d7fi&|g\u000eK\u0002S\u0003+\f\u0011\u0007^3ti6\u000bG/\u001a:jC2L'0\u0019;j_:d\u0015n\u001d;f]\u0016\u0014xJ\u00196fGRLE\rR3mKR,GmU3h[\u0016tG\u000fK\u0002T\u0003+\f\u0001\b^3tiB\u0013XM^5pkNl\u0015\r^3sS\u0006d\u0017N_1uS>tG+\u0019:hKR|eMZ3ti2K7\u000f^3oKJ\u001c\u0015M\\2fY2,G\rK\u0002U\u0003+\f!\b^3tiB\u0013XM^5pkNl\u0015\r^3sS\u0006d\u0017N_1uS>tG+\u0019:hKR|%M[3di&#G*[:uK:,'oQ1oG\u0016dG.\u001a3)\u0007U\u000b).A\u0013uKN$X*\u0019;fe&\fG.\u001b>bi&|g\u000eT5ti\u0016tWM]!gi\u0016\u00148\t\\8tK\"\u001aa+!6\u0002\u007fQ,7\u000f^#oC\ndW\rV5feN#xN]1hK^KG\u000f[%om\u0006d\u0017\u000e\u001a$jY\u0016$\u0006N]8xg.\u000bgm[1Ti>\u0014\u0018mZ3Fq\u000e,\u0007\u000f^5p]\"\u001aq+!6\u0002aQ,7\u000f^*fO6,g\u000e^'fi\u0006$\u0017\r^1EK2,G/\u001a3Qe\u0016\u001cW\rZ5oO\u001a+hn\u0019;j_:\fG.\u001b;zQ\rA\u0016Q[\u0001!i\u0016\u001cH\u000f\u0015:fm&|Wo]'fi\u0006$\u0017\r^1CK\u001a|'/Z(gMN,G\u000fK\u0002Z\u0003+\f\u0001\u0004^3ti\u001a{G\u000e\\8xKJ\u0014Vm\u001d;pe\u0016\u0004v.\u001b8uQ\rQ\u0016Q[\u0001%i\u0016\u001cHOR3oG\u0016$W\u000b\u001d7pC\u00124u\u000e\u001c7po\u0016$')_(qCF,X\rR1uC\"\u001a1,!6\u0002%\r,(O]3oiN#\u0018\r^3PM\u001a\u001cX\r\u001e\u000b\u0003\u0005?\u00042A\u001eBq\u0013\r\u0011\u0019/\u001a\u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i\u0003a)\b\u000f\\8bI&s\u0017\u000e^1uK\u0006sGmQ8na2,G/\u001a\u000b\r\u0003W\u0013IOa=\u0004\u0004\r51\u0011\u0003\u0005\b\u0005Wl\u0006\u0019\u0001Bw\u0003\u0015)\u0007o\\2i!\rq'q^\u0005\u0004\u0005c|'aA%oi\"9!Q_/A\u0002\t]\u0018\u0001C8cU\u0016\u001cG/\u00133\u0011\t\te(q`\u0007\u0003\u0005wTAA!@\u00024\u0005!Q\u000f^5m\u0013\u0011\u0019\tAa?\u0003\tU+\u0016\n\u0012\u0005\b\u0007\u000bi\u0006\u0019AB\u0004\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\u0011\u00079\u001cI!C\u0002\u0004\f=\u0014A\u0001T8oO\"91qB/A\u0002\r\u001d\u0011!C3oI>3gm]3u\u0011\u001d\u0019\u0019\"\u0018a\u0001\u0005[\fAa]5{K\u0006IB-\u001a7fi\u0016Le.\u001b;jCR,\u0017I\u001c3D_6\u0004H.\u001a;f)\u0019\tYk!\u0007\u0004\u001c!9!1\u001e0A\u0002\t5\bb\u0002B{=\u0002\u0007!q_\u0001\u0014i\u0016\u001cH\u000fR;qY&\u001c\u0017\r^3BaB,g\u000e\u001a\u000b\t\u0003W\u001b\tc!\r\u0004B!911E0A\u0002\r\u0015\u0012\u0001C7fi\u0006$\u0017\r^1\u0011\t\r\u001d2QF\u0007\u0003\u0007SQ1aa\u000bh\u0003\u0019!w.\\1j]&!1qFB\u0015\u0005Q\t%m\u001d;sC\u000e$H+[3s\u001b\u0016$\u0018\rZ1uC\"911G0A\u0002\rU\u0012a\u00059sKZLw.^:Ue\u0006t7/\u001b;j_:\u001c\bCBB\u001c\u0007{\u0019)#\u0004\u0002\u0004:)\u001911H8\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004@\re\"aA*fc\"911I0A\u0002\r\u0015\u0013\u0001C3ya\u0016\u001cG/\u001a3\u0011\t\r\u001d3q\f\b\u0005\u0007\u0013\u001aYF\u0004\u0003\u0004L\rec\u0002BB'\u0007/rAaa\u0014\u0004V5\u00111\u0011\u000b\u0006\u0004\u0007'Z\u0017A\u0002\u001fs_>$h(C\u0001k\u0013\tA\u0017.\u0003\u0002gO&\u00191QL3\u0002%QKWM\u001d)beRLG/[8o'R\fG/Z\u0005\u0005\u0007C\u001a\u0019G\u0001\u0007BaB,g\u000e\u001a*fgVdGOC\u0002\u0004^\u0015$\"\"a+\u0004h\rE41OB;\u0011\u001d\u0019I\u0007\u0019a\u0001\u0007W\n\u0001B\\3x'R\fG/\u001a\t\u0004m\u000e5\u0014bAB8K\n\u0011B+[3s!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u0011\u001d\u0019\u0019\u0003\u0019a\u0001\u0007KAqaa\ra\u0001\u0004\u0019)\u0004C\u0004\u0004D\u0001\u0004\ra!\u0012\u0002EQ,7\u000f^%uKJ\fGo\u001c:ES\u001a4WM]3oi6+G/\u00193bi\u0006\u001c\u0016N_3tQ\r\t\u0017Q[\u0001\u001dm\u0006d\u0017\u000eZ1uK\u000e{gn]8mK\u0012+X\u000e]3e\u000b:$(/[3t)\u0019\tYka \u0004\u0004\"91\u0011\u00112A\u0002\u0005-\u0012\u0001\u00049beRLG/[8o\t&\u0014\bbBBCE\u0002\u0007!Q^\u0001\f]Vl7+Z4nK:$8/A\u0016dQ\u0016\u001c7.\u00138wC2LGMR5mK.\u000bgm[1Ti>\u0014\u0018mZ3Fq\u000e,\u0007\u000f^5p]>s\u0017J\\5u)!\tYka#\u0004\u0010\u000eE\u0005bBBGG\u0002\u0007\u00111F\u0001\bE\u0006\u001cX\rR5s\u0011\u001d\t\te\u0019a\u0001\u0003\u000bBqaa%d\u0001\u0004\u0019)*\u0001\u0003qCRD\u0007\u0003BBL\u0007?sAa!'\u0004\u001cB\u00191qJ8\n\u0007\ruu.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0007C\u001b\u0019K\u0001\u0004TiJLgn\u001a\u0006\u0004\u0007;{\u0007")
public class FileTierPartitionStateTest {
    private final Algorithm checksumAlgorithm = this.checksumEnabled() ? Algorithm.ADLER : Algorithm.NO_CHECKSUM;
    private final short superBlockLength = (short)(this.checksumEnabled() ? 512 : 0);
    private final TierPartitionStateFactory factory = new TierPartitionStateFactory(true, this.checksumEnabled());
    private final File parentDir = TestUtils$.MODULE$.tempDir();
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.parentDir());
    private final TopicPartition tp = Log$.MODULE$.parseTopicPartitionName(this.dir());
    private final TopicIdPartition tpid = new TopicIdPartition(this.tp().topic(), java.util.UUID.randomUUID(), this.tp().partition());
    private final LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(5);
    private final MockTime time = new MockTime();
    private final FileTierPartitionState state = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled());
    private final LogConfig logConfig = (LogConfig)Mockito.mock(LogConfig.class);

    public boolean checksumEnabled() {
        return false;
    }

    public Algorithm checksumAlgorithm() {
        return this.checksumAlgorithm;
    }

    public short superBlockLength() {
        return this.superBlockLength;
    }

    public TierPartitionStateFactory factory() {
        return this.factory;
    }

    public File parentDir() {
        return this.parentDir;
    }

    public File dir() {
        return this.dir;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public TopicIdPartition tpid() {
        return this.tpid;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public MockTime time() {
        return this.time;
    }

    public FileTierPartitionState state() {
        return this.state;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    @BeforeEach
    public void setup() {
        this.state().setTopicId(this.tpid().topicId());
        this.state().setTieredPartitionRecoveryWorkflowCb(op -> {
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ debug_this = testUtils$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(FileTierPartitionStateTest.$anonfun$setup$2(this, op)));
                return;
            }
        });
        this.state().beginCatchup();
        this.state().onCatchUpComplete();
        Mockito.when((Object)this.logConfig().tierEnable()).thenReturn((Object)Predef$.MODULE$.boolean2Boolean(true));
        TierTestUtils$.MODULE$.initTierTopicOffset();
    }

    @AfterEach
    public void teardown() {
        this.state().close();
        this.dir().delete();
        this.parentDir().delete();
    }

    @Test
    public void testForceRestoreLogStartOffsetUserErrors() {
        this.state().flush();
        ByteBuffer savedFTPS = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(this.state().flushedPath(), new String[0]));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierPartitionFence(this.tpid(), java.util.UUID.randomUUID(), false), new OffsetAndEpoch(90L, Optional.of(Predef$.MODULE$.int2Integer(1)))));
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        TierPartitionForceRestore restoreEvent = new TierPartitionForceRestore(this.tpid(), java.util.UUID.randomUUID(), 0L, 100L, OffsetAndEpoch.EMPTY, "hash", Predef$.MODULE$.boolean2Boolean(true));
        Assertions.assertEquals((Object)TierPartitionState.RestoreResult.FAILED, (Object)this.state().forceRestoreState(restoreEvent, savedFTPS, TierPartitionStatus.ONLINE, new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(1)))));
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        restoreEvent = new TierPartitionForceRestore(this.tpid(), java.util.UUID.randomUUID(), 0L, 100L, OffsetAndEpoch.EMPTY, "hash", Predef$.MODULE$.boolean2Boolean(false));
        Assertions.assertEquals((Object)TierPartitionState.RestoreResult.SUCCEEDED, (Object)this.state().forceRestoreState(restoreEvent, savedFTPS, TierPartitionStatus.ONLINE, new OffsetAndEpoch(110L, Optional.of(Predef$.MODULE$.int2Integer(1)))));
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
        restoreEvent = new TierPartitionForceRestore(this.tpid(), java.util.UUID.randomUUID(), 0L, 100L, OffsetAndEpoch.EMPTY, "hash", Predef$.MODULE$.boolean2Boolean(true));
        Assertions.assertEquals((Object)TierPartitionState.RestoreResult.FAILED, (Object)this.state().forceRestoreState(restoreEvent, savedFTPS, TierPartitionStatus.ONLINE, new OffsetAndEpoch(120L, Optional.of(Predef$.MODULE$.int2Integer(1)))));
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
        restoreEvent = new TierPartitionForceRestore(this.tpid(), java.util.UUID.randomUUID(), 0L, 100L, OffsetAndEpoch.EMPTY, "hash", Predef$.MODULE$.boolean2Boolean(false));
        Assertions.assertEquals((Object)TierPartitionState.RestoreResult.FAILED, (Object)this.state().forceRestoreState(restoreEvent, savedFTPS, TierPartitionStatus.ONLINE, new OffsetAndEpoch(130L, Optional.of(Predef$.MODULE$.int2Integer(1)))));
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
    }

    @Test
    public void testUnfreezeLogStartOffsetEventUserErrors() {
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
        TierPartitionUnfreezeLogStartOffset unfreezeEvent = new TierPartitionUnfreezeLogStartOffset(this.tpid(), java.util.UUID.randomUUID());
        Assertions.assertEquals((Object)TierPartitionState.RestoreResult.FAILED, (Object)this.state().processUnfreezeLogStartOffset(unfreezeEvent, TierPartitionStatus.ONLINE, new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(1)))));
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierPartitionFence(this.tpid(), java.util.UUID.randomUUID(), false), new OffsetAndEpoch(110L, Optional.of(Predef$.MODULE$.int2Integer(1)))));
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        unfreezeEvent = new TierPartitionUnfreezeLogStartOffset(this.tpid(), java.util.UUID.randomUUID());
        Assertions.assertEquals((Object)TierPartitionState.RestoreResult.FAILED, (Object)this.state().processUnfreezeLogStartOffset(unfreezeEvent, TierPartitionStatus.ONLINE, new OffsetAndEpoch(120L, Optional.of(Predef$.MODULE$.int2Integer(1)))));
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
    }

    @Test
    public void testTopicWithTierDisabledDoesNotHaveTierPartitionStateFile() {
        File dir2 = TestUtils$.MODULE$.randomPartitionLogDir(this.parentDir());
        TopicPartition tp2 = Log$.MODULE$.parseTopicPartitionName(dir2);
        FileTierPartitionState fp = new FileTierPartitionState(dir2, this.logDirFailureChannel(), tp2, false, (Scheduler)this.time().scheduler(), this.checksumEnabled());
        Path flushedFilePath = FileTierPartitionState.flushedFilePath((String)fp.basePath(), (Algorithm)this.checksumAlgorithm());
        Assertions.assertFalse((boolean)Files.exists(flushedFilePath, new LinkOption[0]));
        fp.setTopicId(java.util.UUID.randomUUID());
        Assertions.assertFalse((boolean)Files.exists(flushedFilePath, new LinkOption[0]));
        FileTierPartitionState fp2 = new FileTierPartitionState(dir2, this.logDirFailureChannel(), tp2, false, (Scheduler)this.time().scheduler(), this.checksumEnabled());
        Assertions.assertFalse((boolean)Files.exists(FileTierPartitionState.flushedFilePath((String)fp2.basePath(), (Algorithm)this.checksumAlgorithm()), new LinkOption[0]));
        fp.setTieringEnabled();
        Assertions.assertTrue((boolean)Files.exists(flushedFilePath, new LinkOption[0]));
        fp.close();
        fp2.close();
        dir2.delete();
    }

    @Test
    public void readWriteHeaderOnly() {
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 9, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((int)9, (int)this.state().tierEpoch());
        this.state().close();
        FileTierPartitionState reopenedState = (FileTierPartitionState)this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler());
        Assertions.assertFalse((boolean)reopenedState.dirty());
        Assertions.assertEquals((int)9, (int)reopenedState.tierEpoch());
        reopenedState.close();
    }

    @Test
    public void testPreviousOffsetEvent() {
        TierTopicInitLeader initLeaderEvent = new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)initLeaderEvent, new OffsetAndEpoch(2L, Optional.of(Predef$.MODULE$.int2Integer(2)))));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, (Object)this.state().append((AbstractTierMetadata)initLeaderEvent, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(2)))));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, (Object)this.state().append((AbstractTierMetadata)initLeaderEvent, new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(0)))));
    }

    @Test
    public void testAppendEpochValidation_1() {
        TierTopicInitLeader initLeader_1 = new TierTopicInitLeader(this.tpid(), 1, java.util.UUID.randomUUID(), 0);
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(1)));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)initLeader_1, offsetAndEpoch));
        offsetAndEpoch = new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(5)));
        TierTopicInitLeader initLeader_2 = new TierTopicInitLeader(this.tpid(), 5, java.util.UUID.randomUUID(), 1);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)initLeader_2, offsetAndEpoch));
        Assertions.assertEquals((Object)offsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        TierTopicInitLeader initLeader_3 = new TierTopicInitLeader(this.tpid(), 7, java.util.UUID.randomUUID(), 2);
        OffsetAndEpoch errorOffsetAndEpoch = new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(6)));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)initLeader_3, errorOffsetAndEpoch));
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        Assertions.assertEquals((Object)offsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
    }

    @Test
    public void testAppendEpochValidation_2() {
        TierTopicInitLeader initLeader_1 = new TierTopicInitLeader(this.tpid(), 1, java.util.UUID.randomUUID(), 0);
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(1)));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)initLeader_1, offsetAndEpoch));
        offsetAndEpoch = new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(5)));
        TierTopicInitLeader initLeader_2 = new TierTopicInitLeader(this.tpid(), 5, java.util.UUID.randomUUID(), 1);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)initLeader_2, offsetAndEpoch));
        Assertions.assertEquals((Object)offsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        TierTopicInitLeader initLeader_3 = new TierTopicInitLeader(this.tpid(), 7, java.util.UUID.randomUUID(), 2);
        OffsetAndEpoch errorOffsetAndEpoch = new OffsetAndEpoch(200L, Optional.of(Predef$.MODULE$.int2Integer(4)));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)initLeader_3, errorOffsetAndEpoch));
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        Assertions.assertEquals((Object)offsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
    }

    @Test
    public void testOffsetIsIncremented() {
        TierTopicInitLeader initLeaderEvent = new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0);
        TierTopicInitLeader newInitLeaderEvent = new TierTopicInitLeader(this.tpid(), 1, java.util.UUID.randomUUID(), 0);
        OffsetAndEpoch offsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)initLeaderEvent, offsetAndEpoch));
        Assertions.assertEquals((Object)offsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch(), (String)"Last consumed offset mismatch");
        offsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)newInitLeaderEvent, offsetAndEpoch));
        Assertions.assertEquals((Object)offsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch(), (String)"Last consumed offset mismatch");
    }

    @Test
    public void serializeDeserializeTest() {
        int numSegments = 200;
        LongRef currentSegments = LongRef.create((long)0L);
        int epoch = 0;
        ObjectRef baseOffsetToOpaqueData = ObjectRef.create((Object)((Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)));
        String path = this.state().flushedPath();
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        IntRef size = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            java.util.UUID objectId = java.util.UUID.randomUUID();
            OffsetAndEpoch uploadStateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
            TierObjectStore.OpaqueData opaqueData = i % 2 == 2 ? TierObjectStore.OpaqueData.ZEROED : TierObjectStore.OpaqueData.fromLongArray((long[])new long[]{java.util.UUID.randomUUID().getLeastSignificantBits(), 0L, 0L, 0L});
            long baseOffset = (long)i * 2L;
            baseOffsetToOpaqueData$1.elem = ((Map)baseOffsetToOpaqueData$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)baseOffset)), (Object)opaqueData));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId, baseOffset, baseOffset + 1L, 100L, i, false, false, false, uploadStateOffset, opaqueData), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, objectId, uploadStateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            size$1.elem += i;
            ++currentSegments$1.elem;
        });
        Assertions.assertTrue((boolean)this.state().flush());
        ObjectRef segments = ObjectRef.create((Object)this.state().segments());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            long startOffset = (long)i * 2L;
            Assertions.assertEquals((long)startOffset, (long)((TierLogSegment)((java.util.Iterator)segments$1.elem).next()).baseOffset());
            TierLogSegment tierLogSegment = (TierLogSegment)this.state().metadata(startOffset).get();
            Assertions.assertEquals((long)startOffset, (long)tierLogSegment.baseOffset());
            Assertions.assertEquals((Object)((Map)baseOffsetToOpaqueData$1.elem).get((Object)BoxesRunTime.boxToLong((long)tierLogSegment.baseOffset())), (Object)new Some((Object)tierLogSegment.metadata().opaqueData()));
        });
        Assertions.assertFalse((boolean)((java.util.Iterator)segments.elem).hasNext());
        Assertions.assertEquals((long)currentSegments.elem, (long)this.state().numSegments());
        Assertions.assertEquals((long)size.elem, (long)this.state().totalSize());
        Assertions.assertEquals((long)0L, (Long)((Long)this.state().startOffset().get()));
        Assertions.assertEquals((long)(currentSegments.elem * 2L - 1L), (long)this.state().committedEndOffset());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(numSegments), numSegments * 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            java.util.UUID objectId = java.util.UUID.randomUUID();
            OffsetAndEpoch uploadStateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
            TierObjectStore.OpaqueData opaqueData = i % 2 == 2 ? TierObjectStore.OpaqueData.ZEROED : TierObjectStore.OpaqueData.fromLongArray((long[])new long[]{java.util.UUID.randomUUID().getLeastSignificantBits(), 0L, 0L, 0L});
            long baseOffset = (long)i * 2L;
            baseOffsetToOpaqueData$1.elem = ((Map)baseOffsetToOpaqueData$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)baseOffset)), (Object)opaqueData));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId, baseOffset, baseOffset + 1L, 100L, i, false, false, false, uploadStateOffset, opaqueData), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, objectId, uploadStateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            size$1.elem += i;
            ++currentSegments$1.elem;
        });
        Assertions.assertTrue((boolean)this.state().flush());
        segments.elem = this.state().segments();
        new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)currentSegments.elem)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)i -> {
            long startOffset = i * 2L;
            Assertions.assertEquals((long)startOffset, (long)((TierLogSegment)((java.util.Iterator)segments$1.elem).next()).baseOffset());
            TierLogSegment tierLogSegment = (TierLogSegment)this.state().metadata(startOffset).get();
            Assertions.assertEquals((long)startOffset, (long)tierLogSegment.baseOffset());
            Assertions.assertEquals((Object)((Map)baseOffsetToOpaqueData$1.elem).get((Object)BoxesRunTime.boxToLong((long)tierLogSegment.baseOffset())), (Object)new Some((Object)tierLogSegment.metadata().opaqueData()));
        });
        Assertions.assertFalse((boolean)((java.util.Iterator)segments.elem).hasNext());
        Assertions.assertEquals((long)currentSegments.elem, (long)this.state().numSegments());
        Assertions.assertEquals((long)size.elem, (long)this.state().totalSize());
        Assertions.assertEquals((long)0L, (Long)((Long)this.state().startOffset().get()));
        Assertions.assertEquals((long)(currentSegments.elem * 2L - 1L), (long)this.state().committedEndOffset());
        this.state().close();
        this.checkInvalidFileKafkaStorageExceptionOnInit(this.dir(), this.tp(), path);
    }

    @Test
    public void segmentGapTest() {
        int epoch = 0;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        java.util.UUID objectId1 = java.util.UUID.randomUUID();
        OffsetAndEpoch uploadStateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId1, 0L, 50L, 100L, 0, false, false, false, uploadStateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, objectId1, uploadStateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        OffsetAndEpoch uploadStateOffset2 = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        java.util.UUID objectId2 = java.util.UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId2, 75L, 150L, 100L, 0, false, false, false, uploadStateOffset2, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, objectId2, uploadStateOffset2), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((Object)objectId1, (Object)((TierLogSegment)this.state().metadata(50L).get()).objectId());
        Assertions.assertEquals((Object)objectId2, (Object)((TierLogSegment)this.state().metadata(51L).get()).objectId());
        Assertions.assertFalse((boolean)this.state().metadata(151L).isPresent());
        this.state().close();
    }

    @Test
    public void segmentOverlapTest() {
        int epoch = 0;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        java.util.UUID objectId1 = java.util.UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 50L, 0);
        java.util.UUID objectId2 = java.util.UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId2, 25L, 150L, 0);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((Object)objectId1, (Object)((TierLogSegment)this.state().metadata(24L).get()).objectId());
        Assertions.assertEquals((Object)objectId1, (Object)((TierLogSegment)this.state().metadata(25L).get()).objectId());
        Assertions.assertEquals((Object)objectId1, (Object)((TierLogSegment)this.state().metadata(50L).get()).objectId());
        Assertions.assertEquals((Object)objectId2, (Object)((TierLogSegment)this.state().metadata(51L).get()).objectId());
        Assertions.assertFalse((boolean)this.state().metadata(151L).isPresent());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch, objectId1, this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), epoch, objectId1, this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch, objectId2, this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), epoch, objectId2, this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)150L, (long)this.state().endOffset());
        Assertions.assertEquals((long)150L, (long)this.state().committedEndOffset());
        java.util.UUID objectId3 = java.util.UUID.randomUUID();
        OffsetAndEpoch uploadStateOffset3 = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId3, 75L, 175L, 100L, 0, false, false, false, uploadStateOffset3, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, objectId3, uploadStateOffset3), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)151L, (long)((TierLogSegment)this.state().metadata(150L).get()).baseOffset());
        Assertions.assertEquals((long)75L, (long)((TierLogSegment)this.state().metadata(50L).get()).metadata().baseOffset(), (String)"virtualized offset handling is incorrect for object store metadata that is used to build the key");
        Assertions.assertEquals((Object)objectId3, (Object)((TierLogSegment)this.state().metadata(151L).get()).objectId());
        Assertions.assertEquals((Object)objectId3, (Object)((TierLogSegment)this.state().metadata(175L).get()).objectId());
        Assertions.assertFalse((boolean)this.state().metadata(176L).isPresent());
        this.state().close();
        TierPartitionState reopenedState = this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler());
        Assertions.assertEquals((long)175L, (long)reopenedState.endOffset());
        Assertions.assertEquals((long)175L, (long)reopenedState.committedEndOffset());
        Assertions.assertTrue((boolean)reopenedState.metadata(74L).isPresent());
        Assertions.assertEquals((Object)objectId3, (Object)((TierLogSegment)reopenedState.metadata(75L).get()).objectId());
        Assertions.assertEquals((Object)objectId3, (Object)((TierLogSegment)reopenedState.metadata(175L).get()).objectId());
        Assertions.assertFalse((boolean)reopenedState.metadata(176L).isPresent());
        reopenedState.close();
    }

    @Test
    public void updateEpochTest() {
        int n = 200;
        int epoch = 0;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        IntRef size = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.uploadInitateAndComplete(0, java.util.UUID.randomUUID(), i * 2, i * 2 + 1, i);
            size$2.elem += i;
        });
        this.state().flush();
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch + 1, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        this.state().close();
        TierPartitionState reopenedState = this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler());
        Assertions.assertEquals((int)1, (int)reopenedState.tierEpoch());
        Assertions.assertEquals((long)size.elem, (long)reopenedState.totalSize());
        reopenedState.close();
    }

    @Test
    public void updateEndOffsetTest() {
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.uploadInitateAndComplete(0, java.util.UUID.randomUUID(), 0L, 100L, 100);
        Assertions.assertEquals((long)100L, (long)this.state().endOffset());
        Assertions.assertEquals((long)-1L, (long)this.state().committedEndOffset());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).size());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)100L, (long)this.state().endOffset());
        Assertions.assertEquals((long)100L, (long)this.state().committedEndOffset());
        TierPartitionState reopenedState = this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler());
        Assertions.assertEquals((long)100L, (long)reopenedState.endOffset());
        Assertions.assertEquals((long)100L, (long)reopenedState.committedEndOffset());
        reopenedState.close();
    }

    @Test
    public void flushAvailabilityTest() {
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.uploadInitateAndComplete(0, java.util.UUID.randomUUID(), 0L, 100L, 100);
        Assertions.assertEquals((long)100L, (long)this.state().endOffset());
        Assertions.assertEquals((long)-1L, (long)this.state().committedEndOffset());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).size());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)100L, (long)this.state().endOffset());
        Assertions.assertEquals((long)100L, (long)this.state().committedEndOffset());
        this.uploadInitateAndComplete(0, java.util.UUID.randomUUID(), 100L, 200L, 100);
        Assertions.assertEquals((long)0L, (Long)((Long)this.state().startOffset().get()));
        Assertions.assertEquals((long)100L, (long)this.state().committedEndOffset());
        Assertions.assertEquals((long)200L, (long)this.state().endOffset());
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)0L, (Long)((Long)this.state().startOffset().get()));
        Assertions.assertEquals((long)200L, (long)this.state().committedEndOffset());
        int numSegments = ((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).size();
        this.state().close();
        this.validateConsoleDumpedEntries(this.dir(), numSegments);
    }

    @Test
    public void testReopenFileAfterVersionChange() {
        int numSegments = 200;
        int epoch = 0;
        byte initialVersion = this.state().version();
        long expectedEndOffset = 2 * numSegments - 1;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        IntRef size = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.uploadInitateAndComplete(epoch, java.util.UUID.randomUUID(), i * 2, i * 2 + 1, 100);
            size$3.elem += i;
        });
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((int)numSegments, (int)this.state().numSegments());
        Assertions.assertEquals((long)expectedEndOffset, (long)this.state().endOffset());
        Assertions.assertEquals((long)expectedEndOffset, (long)this.state().committedEndOffset());
        this.state().close();
        byte upgradedVersion = (byte)(initialVersion + 1);
        FileTierPartitionState upgradedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, upgradedVersion, (Scheduler)this.time().scheduler(), this.checksumEnabled());
        Assertions.assertEquals((byte)upgradedVersion, (byte)upgradedState.version());
        Assertions.assertEquals((int)numSegments, (int)upgradedState.numSegments());
        Assertions.assertEquals((long)expectedEndOffset, (long)upgradedState.endOffset());
        Assertions.assertEquals((long)expectedEndOffset, (long)upgradedState.committedEndOffset());
        upgradedState.close();
    }

    @Test
    public void testOngoingUploadNotVisibleToReaders() {
        int numSegments = 20;
        int epoch = 0;
        LongRef offset = LongRef.create((long)0L);
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.uploadInitateAndComplete(epoch, java.util.UUID.randomUUID(), offset$1.elem, offset$1.elem + 1L, 100);
            ++offset$1.elem;
        });
        Assertions.assertEquals((long)offset.elem, (long)this.state().endOffset());
        Assertions.assertEquals((int)numSegments, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).size());
        java.util.UUID inProgressObjectId = java.util.UUID.randomUUID();
        OffsetAndEpoch inProgressStateOffset = this.currentStateOffset();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, inProgressObjectId, offset.elem, offset.elem + 1L, 100L, 100, false, false, false, inProgressStateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)offset.elem, (long)this.state().endOffset());
        Assertions.assertEquals((int)numSegments, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).size());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, inProgressObjectId, this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)(offset.elem + 1L), (long)this.state().endOffset());
        Assertions.assertEquals((int)(numSegments + 1), (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).size());
    }

    @Test
    public void testMetadataReadReturnsValidSegments() {
        int epoch = 0;
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.uploadInitateAndComplete(epoch, java.util.UUID.randomUUID(), 0L, 100L, 100);
        java.util.UUID fencedObjectId = java.util.UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, fencedObjectId, 101L, 200L, 100L, 100, false, false, false, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        java.util.UUID expectedObjectId = java.util.UUID.randomUUID();
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), ++epoch, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        this.uploadInitateAndComplete(epoch, expectedObjectId, 150L, 200L, 100);
        Assertions.assertEquals((int)2, (int)this.state().numSegments());
        Assertions.assertEquals((int)1, (int)this.state().fencedSegments().size());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch, fencedObjectId, this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((int)2, (int)this.state().numSegments());
        Assertions.assertEquals((int)0, (int)this.state().fencedSegments().size());
        Assertions.assertTrue((boolean)this.state().metadata(149L).isPresent());
        Assertions.assertEquals((Object)expectedObjectId, (Object)((TierLogSegment)this.state().metadata(149L).get()).objectId());
    }

    @Test
    public void testMultipleInitiatesScannedCorrectlyOnReload() {
        int epoch = 0;
        int offset = 0;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, java.util.UUID.randomUUID(), (long)offset, (long)(offset + 1), 100L, 100, false, false, false, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), ++epoch, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, java.util.UUID.randomUUID(), (long)(++offset), (long)(offset + 1), 100L, 100, false, false, false, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), ++epoch, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        List initialFenced = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.state().fencedSegments()).asScala()).toList();
        Assertions.assertEquals((int)2, (int)initialFenced.length());
        this.state().close();
        FileTierPartitionState state2 = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled());
        Assertions.assertFalse((boolean)state2.dirty());
        Assertions.assertFalse((boolean)state2.setTopicId(this.tpid().topicId()));
        List afterReloadFenced = ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(state2.fencedSegments()).asScala()).toList();
        Assertions.assertEquals((Object)initialFenced, (Object)afterReloadFenced);
    }

    @Test
    public void testUploadAtLowerEpochFenced() {
        int numSegments = 20;
        IntRef epoch = IntRef.create((int)0);
        IntRef offset = IntRef.create((int)0);
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch.elem, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.uploadInitateAndComplete(epoch$4.elem, java.util.UUID.randomUUID(), offset$2.elem, offset$2.elem + 1, 100);
            ++offset$2.elem;
        });
        epoch.elem = 1;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch.elem, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.uploadInitateAndComplete(epoch$4.elem, java.util.UUID.randomUUID(), offset$2.elem, offset$2.elem + 1, 100);
            ++offset$2.elem;
        });
        java.util.UUID fencedObjectId = java.util.UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch.elem - 1, fencedObjectId, (long)offset.elem, (long)(offset.elem + 1), 100L, 100, false, false, false, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((int)0, (int)this.state().fencedSegments().size());
        Assertions.assertEquals((int)(numSegments * 2), (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).size());
        this.state().close();
        Assertions.assertFalse((boolean)reopenedState.dirty());
        try (FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled());){
            Assertions.assertEquals((int)0, (int)reopenedState.fencedSegments().size());
            Assertions.assertEquals((int)(numSegments * 2), (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(reopenedState.segments()).asScala()).size());
        }
    }

    @Test
    public void testUploadAtHigherEpochFailed() {
        int epoch = 0;
        int offset = 0;
        OffsetAndEpoch nextOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 0), nextOffsetAndEpoch);
        OffsetAndEpoch stateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        java.util.UUID objectId = java.util.UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId, (long)offset, (long)(offset + 1), 100L, 100, false, false, false, stateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        nextOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, objectId, stateOffset), nextOffsetAndEpoch));
        Assertions.assertEquals((int)0, (int)this.state().fencedSegments().size());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).size());
        Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        OffsetAndEpoch stateOffsetBeforeFail = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        OffsetAndEpoch errorTierTopicOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), ++epoch, java.util.UUID.randomUUID(), (long)(++offset), (long)(offset + 1), 100L, 100, false, false, false, stateOffsetBeforeFail, TierObjectStore.OpaqueData.ZEROED), errorTierTopicOffsetAndEpoch));
        Assertions.assertEquals((Object)errorTierTopicOffsetAndEpoch, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 0), errorTierTopicOffsetAndEpoch));
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        Assertions.assertEquals((int)0, (int)this.state().fencedSegments().size());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).size());
        Assertions.assertEquals((Object)errorTierTopicOffsetAndEpoch, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
    }

    @Test
    public void testDeleteAtHigherEpochFailed() {
        int epoch = 0;
        int offset = 0;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        java.util.UUID objectId = java.util.UUID.randomUUID();
        OffsetAndEpoch stateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId, (long)offset, (long)(offset + 1), 100L, 100, false, false, false, stateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        OffsetAndEpoch nextTierTopicOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, objectId, stateOffset), nextTierTopicOffsetAndEpoch));
        Assertions.assertEquals((int)0, (int)this.state().fencedSegments().size());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).size());
        Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        Assertions.assertEquals((Object)nextTierTopicOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        OffsetAndEpoch stateOffsetForFail = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        OffsetAndEpoch errorTierTopicOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), ++epoch, objectId, stateOffsetForFail), errorTierTopicOffsetAndEpoch));
        Assertions.assertEquals((Object)nextTierTopicOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        Assertions.assertEquals((Object)errorTierTopicOffsetAndEpoch, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 0), errorTierTopicOffsetAndEpoch));
        Assertions.assertEquals((Object)nextTierTopicOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((int)0, (int)this.state().fencedSegments().size());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).size());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        Assertions.assertEquals((Object)errorTierTopicOffsetAndEpoch, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
    }

    @Test
    public void testOngoingUploadFenced() {
        int numSegments = 20;
        int epoch = 0;
        IntRef offset = IntRef.create((int)0);
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.uploadInitateAndComplete(epoch, java.util.UUID.randomUUID(), offset$3.elem, offset$3.elem + 1, 100);
            ++offset$3.elem;
        });
        ListBuffer abortedObjectIds = new ListBuffer();
        int numAbortedSegments = 5;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numAbortedSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            abortedObjectIds.$plus$eq((Object)java.util.UUID.randomUUID());
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, (java.util.UUID)abortedObjectIds.last(), (long)offset$3.elem, (long)(offset$3.elem + 1), 100L, 100, false, false, false, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        });
        java.util.UUID ongoingUpload = java.util.UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, ongoingUpload, (long)offset.elem, (long)(offset.elem + 1), 100L, 100, false, false, false, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((int)numAbortedSegments, (int)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.state().fencedSegments()).asScala()).size());
        Assertions.assertEquals((Object)abortedObjectIds.toSet(), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.state().fencedSegments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.objectId(), Iterable$.MODULE$.canBuildFrom())).toSet());
        Assertions.assertEquals((int)numSegments, (int)this.state().numSegments());
        this.state().close();
        Assertions.assertFalse((boolean)reopenedState.dirty());
        try (FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled());){
            Assertions.assertEquals((int)numAbortedSegments, (int)reopenedState.fencedSegments().size());
            Assertions.assertEquals((Object)abortedObjectIds.toSet(), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(reopenedState.fencedSegments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.objectId(), Iterable$.MODULE$.canBuildFrom())).toSet());
            Assertions.assertEquals((int)numSegments, (int)reopenedState.numSegments());
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)reopenedState.append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, ongoingUpload, this.state().lastLocalMaterializedSrcOffsetAndEpoch()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            Assertions.assertEquals((Object)ongoingUpload, (Object)((TierLogSegment)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(reopenedState.segments()).asScala()).toList().last()).metadata().objectId());
        }
    }

    @Test
    public void testOngoingUploadFencedAfterLeaderChange() {
        int numSegments = 20;
        IntRef epoch = IntRef.create((int)0);
        IntRef offset = IntRef.create((int)0);
        IndexedSeq objectIds = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).map((Function1 & Serializable & scala.Serializable)_ -> FileTierPartitionStateTest.$anonfun$testOngoingUploadFencedAfterLeaderChange$1(BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch.elem, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.uploadInitateAndComplete(epoch$6.elem, (java.util.UUID)objectIds.apply(i), offset$4.elem, offset$4.elem + 1, 100);
            ++offset$4.elem;
        });
        java.util.UUID abortedObjectId = java.util.UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch.elem, abortedObjectId, (long)offset.elem, (long)(offset.elem + 1), 100L, 100, false, false, false, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch.elem, (java.util.UUID)objectIds.apply(0), this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        epoch.elem = 1;
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch.elem, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((int)2, (int)this.state().fencedSegments().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new java.util.UUID[]{abortedObjectId, (java.util.UUID)objectIds.apply(0)})), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.state().fencedSegments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.objectId(), Iterable$.MODULE$.canBuildFrom())).toSet());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch.elem - 1, abortedObjectId, this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    @Test
    public void testFencedSegmentHandlingOnReopen() {
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        java.util.UUID abortedObjectId = java.util.UUID.randomUUID();
        OffsetAndEpoch initialUploadStateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, abortedObjectId, 0L, 1L, 100L, 100, false, false, false, initialUploadStateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 1, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((Object)((TierLogSegment)this.state().fencedSegments().stream().findFirst().get()).objectId(), (Object)abortedObjectId);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FENCED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), 0, abortedObjectId, initialUploadStateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        java.util.UUID completedObjectId = java.util.UUID.randomUUID();
        OffsetAndEpoch overlappingStateOffset = this.currentStateOffset();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 1, completedObjectId, 0L, 1L, 100L, 100, false, false, false, overlappingStateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), 1, abortedObjectId, this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), 1, completedObjectId, overlappingStateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Collection fencedBefore = this.state().fencedSegments();
        Assertions.assertEquals((int)0, (int)fencedBefore.size());
        Assertions.assertEquals((Object)completedObjectId, (Object)((TierLogSegment)this.state().metadata(0L).get()).objectId());
        this.state().close();
        Assertions.assertFalse((boolean)reopenedState.dirty());
        try (FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled());){
            Assertions.assertArrayEquals((Object[])fencedBefore.toArray(), (Object[])reopenedState.fencedSegments().toArray());
            Assertions.assertTrue((boolean)reopenedState.metadata(0L).isPresent());
            Assertions.assertEquals((Object)completedObjectId, (Object)((TierLogSegment)reopenedState.metadata(0L).get()).objectId());
        }
    }

    @Test
    public void testFencedSegmentHandlingOnDeletion() {
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        java.util.UUID abortedObjectId = java.util.UUID.randomUUID();
        OffsetAndEpoch abortedStateOffset = this.currentStateOffset();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, abortedObjectId, 0L, 1L, 100L, 100, false, false, false, abortedStateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 1, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        java.util.UUID completedObjectId = java.util.UUID.randomUUID();
        this.uploadInitateAndComplete(1, completedObjectId, 0L, 1L, 100);
        Assertions.assertEquals((Object)completedObjectId, (Object)((TierLogSegment)this.state().metadata(0L).get()).objectId());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), 1, abortedObjectId, this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)completedObjectId, (Object)((TierLogSegment)this.state().metadata(0L).get()).objectId());
    }

    @Test
    public void testDeleteSegments() {
        int numSegments = 20;
        int epoch = 0;
        IntRef offset = IntRef.create((int)0);
        ListBuffer objectIds = new ListBuffer();
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach((Function1 & Serializable & scala.Serializable)i -> FileTierPartitionStateTest.$anonfun$testDeleteSegments$1(this, epoch, offset, objectIds, BoxesRunTime.unboxToInt((Object)i)));
        int numSegmentsToDelete = 5;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegmentsToDelete).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch, (java.util.UUID)objectIds.apply(i), this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), epoch, (java.util.UUID)objectIds.apply(i), this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        });
        ListBuffer validObjectIds = (ListBuffer)objectIds.takeRight(numSegments - numSegmentsToDelete);
        List foundObjectIds = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.metadata().objectId()).toList();
        Assertions.assertEquals((int)validObjectIds.size(), (int)this.state().numSegments());
        Assertions.assertEquals((Object)validObjectIds, (Object)foundObjectIds);
    }

    @Test
    public void testDeleteSegmentsWithOverlap() {
        int numSegments = 20;
        int epoch = 0;
        IntRef offset = IntRef.create((int)0);
        ListBuffer objectIds = new ListBuffer();
        ListBuffer endOffsets = new ListBuffer();
        IntRef size = IntRef.create((int)0);
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            java.util.UUID objectId = java.util.UUID.randomUUID();
            this.uploadInitateAndComplete(epoch, objectId, offset$6.elem, offset$6.elem + 10, i);
            objectIds.$plus$eq((Object)objectId);
            endOffsets.$plus$eq((Object)BoxesRunTime.boxToLong((long)(offset$6.elem + 10)));
            offset$6.elem += 5;
            size$4.elem += i;
        });
        int numSegmentsToDelete = 5;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegmentsToDelete).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch, (java.util.UUID)objectIds.apply(i), this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), epoch, (java.util.UUID)objectIds.apply(i), this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            size$4.elem -= i;
        });
        ListBuffer validObjectIds = (ListBuffer)objectIds.takeRight(numSegments - numSegmentsToDelete);
        List foundObjectIds = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.metadata().objectId()).toList();
        Assertions.assertEquals((int)validObjectIds.size(), (int)this.state().numSegments());
        Assertions.assertEquals((Object)validObjectIds, (Object)foundObjectIds);
        ListBuffer validEndOffsets = (ListBuffer)endOffsets.takeRight(numSegments - numSegmentsToDelete);
        List foundEndOffsets = ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(this.state().segments()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.endOffset())).toList();
        Assertions.assertEquals((Object)validEndOffsets, (Object)foundEndOffsets);
        Assertions.assertEquals((long)size.elem, (long)this.state().totalSize());
        this.state().close();
        Assertions.assertFalse((boolean)reopenedState.dirty());
        try (FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled());){
            Assertions.assertEquals((long)size.elem, (long)reopenedState.totalSize());
        }
    }

    @Test
    public void testEndOffsetIsTrackedForDeleteSegments() {
        int numSegments = 20;
        IntRef epoch = IntRef.create((int)0);
        IntRef offset = IntRef.create((int)0);
        ListBuffer objectIds = new ListBuffer();
        LongRef endOffset = LongRef.create((long)0L);
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch.elem, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            java.util.UUID objectId = java.util.UUID.randomUUID();
            this.uploadInitateAndComplete(epoch$9.elem, objectId, offset$7.elem, offset$7.elem + 10, 1);
            objectIds.$plus$eq((Object)objectId);
            endOffset$1.elem = offset$7.elem + 10;
            offset$7.elem += 5;
        });
        ObjectRef currentState = ObjectRef.create((Object)this.state());
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numSegments / 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)((FileTierPartitionState)currentState$1.elem).append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch$9.elem, (java.util.UUID)objectIds.apply(i), this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
                this.maybeIncrementEpochAndValidateTierState$1((FileTierPartitionState)currentState$1.elem, true, endOffset$1.elem, numSegments - (i + 1), epoch);
                currentState$1.elem = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled());
            });
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(numSegments / 2), numSegments).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)((FileTierPartitionState)currentState$1.elem).append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch$9.elem, (java.util.UUID)objectIds.apply(i), this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
                this.maybeIncrementEpochAndValidateTierState$1((FileTierPartitionState)currentState$1.elem, false, endOffset$1.elem, numSegments - (i + 1), epoch);
                currentState$1.elem = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled());
                Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)((FileTierPartitionState)currentState$1.elem).append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), epoch$9.elem, (java.util.UUID)objectIds.apply(i), this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
                this.maybeIncrementEpochAndValidateTierState$1((FileTierPartitionState)currentState$1.elem, false, endOffset$1.elem, numSegments - (i + 1), epoch);
                currentState$1.elem = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled());
            });
        }
        finally {
            ((FileTierPartitionState)currentState.elem).close();
        }
    }

    @Test
    public void testEndOffsetIsTrackedForSegmentsFencedOnDeleteInitiate() {
        int epoch = 0;
        long offset = 0L;
        java.util.UUID objectId = java.util.UUID.randomUUID();
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        this.uploadInitateAndComplete(epoch, objectId, offset, offset + 10L, 1);
        long endOffset = offset + 10L;
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch, objectId, this.currentStateOffset()), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        objectId = java.util.UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId, offset += 5L, offset + 10L, 100L, 1, false, false, false, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        epoch = 1;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 1), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((int)2, (int)this.state().fencedSegments().size());
        Assertions.assertEquals((long)endOffset, (long)this.state().endOffset(), (String)"FileTierPartitionState endOffset runtime value");
        Assertions.assertEquals((long)0L, (long)this.state().totalSize(), (String)"FileTierPartitionState totalSize runtime value");
        this.state().close();
        Assertions.assertFalse((boolean)reopenedState.dirty());
        try (FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled());){
            Assertions.assertEquals((int)2, (int)reopenedState.fencedSegments().size(), (String)reopenedState.toString());
            Assertions.assertEquals((long)endOffset, (long)reopenedState.endOffset(), (String)"FileTierPartitionState endOffset materialized value");
            Assertions.assertEquals((long)0L, (long)reopenedState.totalSize(), (String)"FileTierPartitionState totalSize materialized value");
        }
    }

    @Test
    public void testMaterializedOffset() {
        Assertions.assertEquals((Object)new OffsetAndEpoch(-1L, Optional.empty()), (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)new OffsetAndEpoch(-1L, Optional.empty()), (Object)this.state().lastFlushedSrcOffsetAndEpoch());
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(100L, Optional.of(Predef$.MODULE$.int2Integer(3)));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0), offsetAndEpoch);
        Assertions.assertEquals((Object)offsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0), new OffsetAndEpoch(98L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        Assertions.assertEquals((Object)offsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        this.state().close();
        FileTierPartitionState restartState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled());
        Assertions.assertEquals((Object)offsetAndEpoch, (Object)restartState.lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)new OffsetAndEpoch(-1L, Optional.empty()), (Object)this.state().lastFlushedSrcOffsetAndEpoch());
    }

    @Test
    public void testAllowedTransitionUploadInitiateToDeleteInitiate() {
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        java.util.UUID objectId = java.util.UUID.randomUUID();
        OffsetAndEpoch stateOffset = this.currentStateOffset();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId, 0L, 10L, 100L, 100, false, false, false, stateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), 0, objectId, stateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
    }

    @Test
    public void testIllegalTransitionInitLeaderToUploadComplete() {
        OffsetAndEpoch nextOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0), nextOffsetAndEpoch));
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
        Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        OffsetAndEpoch stateOffset = this.currentStateOffset();
        OffsetAndEpoch errorOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), 0, java.util.UUID.randomUUID(), stateOffset), errorOffsetAndEpoch));
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
    }

    @Test
    public void testIllegalTransitionInitLeaderToDeleteInitiate() {
        OffsetAndEpoch nextOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0), nextOffsetAndEpoch));
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
        Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        OffsetAndEpoch stateOffset = this.currentStateOffset();
        OffsetAndEpoch errorOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), 0, java.util.UUID.randomUUID(), stateOffset), errorOffsetAndEpoch));
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
    }

    @Test
    public void testIllegalTransitionInitLeaderToDeleteComplete() {
        OffsetAndEpoch nextOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0), nextOffsetAndEpoch));
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
        Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        OffsetAndEpoch stateOffset = this.currentStateOffset();
        OffsetAndEpoch errorOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), 0, java.util.UUID.randomUUID(), stateOffset), errorOffsetAndEpoch));
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
    }

    @Test
    public void testIllegalTransitionUploadInitiateToDeleteComplete() {
        OffsetAndEpoch nextOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0), nextOffsetAndEpoch));
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        java.util.UUID objectId = java.util.UUID.randomUUID();
        OffsetAndEpoch stateOffset = this.currentStateOffset();
        nextOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId, 0L, 10L, 100L, 100, false, false, false, stateOffset, TierObjectStore.OpaqueData.ZEROED), nextOffsetAndEpoch));
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        OffsetAndEpoch errorOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), 0, objectId, stateOffset), errorOffsetAndEpoch));
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
    }

    @Test
    public void testIllegalTransitionUploadCompleteDeleteComplete() {
        OffsetAndEpoch nextOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0), nextOffsetAndEpoch));
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        java.util.UUID objectId = java.util.UUID.randomUUID();
        OffsetAndEpoch stateOffset = this.currentStateOffset();
        nextOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId, 0L, 10L, 100L, 100, false, false, false, stateOffset, TierObjectStore.OpaqueData.ZEROED), nextOffsetAndEpoch));
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        nextOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), 0, objectId, stateOffset), nextOffsetAndEpoch));
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        OffsetAndEpoch stateOffsetBeforeFence = this.currentStateOffset();
        OffsetAndEpoch errorOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), 0, objectId, stateOffsetBeforeFence), errorOffsetAndEpoch));
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
    }

    @Test
    public void testStateUpdateFailureFencingEnabled() {
        java.util.UUID objectId = java.util.UUID.randomUUID();
        OffsetAndEpoch nextOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, objectId, 0), nextOffsetAndEpoch));
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        OffsetAndEpoch stateOffset = this.currentStateOffset();
        OffsetAndEpoch errorOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), 0, objectId, stateOffset), errorOffsetAndEpoch));
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        OffsetAndEpoch stateOffset2 = this.currentStateOffset();
        OffsetAndEpoch nextErrorOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId, 0L, 10L, 100L, 100, false, false, false, stateOffset2, TierObjectStore.OpaqueData.ZEROED), nextErrorOffsetAndEpoch));
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
    }

    @Test
    public void testStateUpdateFailureFencingFlushMechanism_ViaBadEvent() {
        java.util.UUID objectId1 = java.util.UUID.randomUUID();
        OffsetAndEpoch nextOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        int tierEpoch = 0;
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), tierEpoch, objectId1, 0), nextOffsetAndEpoch));
        int endOffsetBeforeFencing = 10;
        java.util.UUID objectId2 = java.util.UUID.randomUUID();
        OffsetAndEpoch stateOffsetUpload1 = this.currentStateOffset();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, 0L, (long)endOffsetBeforeFencing, 100L, 100, false, false, false, stateOffsetUpload1, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        OffsetAndEpoch nextOffsetAndEpochBeforeFencing = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), 0, objectId2, stateOffsetUpload1), nextOffsetAndEpochBeforeFencing));
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
        Assertions.assertEquals((Object)nextOffsetAndEpochBeforeFencing, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        Assertions.assertTrue((boolean)this.state().flush());
        CheckedFileIO channelFlushedBeforeFencing = CheckedFileIO.open((Path)FileTierPartitionState.flushedFilePath((String)this.state().basePath(), (Algorithm)this.checksumAlgorithm()), (OpenOption[])new OpenOption[]{StandardOpenOption.READ});
        Assertions.assertTrue((channelFlushedBeforeFencing.size() > 0L ? 1 : 0) != 0);
        Optional headerFlushedBeforeFencing = FileTierPartitionState.readHeader((CheckedFileIO)channelFlushedBeforeFencing);
        Assertions.assertTrue((boolean)headerFlushedBeforeFencing.isPresent());
        Assertions.assertEquals((Object)((Header)headerFlushedBeforeFencing.get()).status(), (Object)TierPartitionStatus.ONLINE);
        ByteBuffer serializedStateFlushedBeforeFencing = ByteBuffer.allocate(10000);
        channelFlushedBeforeFencing.read(serializedStateFlushedBeforeFencing, 0L);
        channelFlushedBeforeFencing.close();
        java.util.UUID objectId3 = java.util.UUID.randomUUID();
        nextOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        OffsetAndEpoch stateOffsetUpload2 = this.currentStateOffset();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId3, (long)(endOffsetBeforeFencing + 1), (long)(endOffsetBeforeFencing + 10), 100L, 100, false, false, false, stateOffsetUpload2, TierObjectStore.OpaqueData.ZEROED), nextOffsetAndEpoch));
        nextOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), 0, objectId3, stateOffsetUpload2), nextOffsetAndEpoch));
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        FileChannel channelMutableBeforeFencing = FileChannel.open(FileTierPartitionState.mutableFilePath((String)this.state().basePath(), (Algorithm)this.checksumAlgorithm()), StandardOpenOption.READ);
        Assertions.assertTrue((channelMutableBeforeFencing.size() > 0L ? 1 : 0) != 0);
        ByteBuffer stateMutableBeforeFencing = ByteBuffer.allocate(10000);
        channelMutableBeforeFencing.read(stateMutableBeforeFencing, this.superBlockLength());
        channelMutableBeforeFencing.close();
        OffsetAndEpoch errorOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        java.util.UUID objectId4 = java.util.UUID.randomUUID();
        OffsetAndEpoch stateOffsetUpload3 = this.currentStateOffset();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), 0, objectId4, stateOffsetUpload3), errorOffsetAndEpoch));
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        OffsetAndEpoch stateOffsetUpload4 = this.currentStateOffset();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId4, (long)(endOffsetBeforeFencing + 11), (long)(endOffsetBeforeFencing + 20), 100L, 100, false, false, false, stateOffsetUpload4, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        Assertions.assertTrue((boolean)this.state().flush());
        CheckedFileIO channelFlushedAfterFencing = CheckedFileIO.open((Path)FileTierPartitionState.flushedFilePath((String)this.state().basePath(), (Algorithm)this.checksumAlgorithm()), (OpenOption[])new OpenOption[]{StandardOpenOption.READ});
        Assertions.assertTrue((channelFlushedAfterFencing.size() > 0L ? 1 : 0) != 0);
        Optional headerFlushedAfterFencing = FileTierPartitionState.readHeader((CheckedFileIO)channelFlushedAfterFencing);
        Assertions.assertTrue((boolean)headerFlushedAfterFencing.isPresent());
        Assertions.assertEquals((Object)new Header(this.tpid().topicId(), this.state().version(), tierEpoch, TierPartitionStatus.ERROR, 0L, 10L, OffsetAndEpoch.EMPTY, nextOffsetAndEpochBeforeFencing, errorOffsetAndEpoch, OffsetAndEpoch.EMPTY), headerFlushedAfterFencing.get());
        ByteBuffer serializedStateFlushedAfterFencing = ByteBuffer.allocate(10000);
        channelFlushedAfterFencing.read(serializedStateFlushedAfterFencing, 0L);
        channelFlushedAfterFencing.close();
        Assertions.assertEquals((Object)serializedStateFlushedBeforeFencing, (Object)serializedStateFlushedAfterFencing);
        FileChannel channelErrorAfterFencing = FileChannel.open(FileTierPartitionState.errorFilePath((String)this.state().basePath(), (Algorithm)this.checksumAlgorithm()), StandardOpenOption.READ);
        Assertions.assertTrue((channelErrorAfterFencing.size() > 0L ? 1 : 0) != 0);
        ByteBuffer stateErrorAfterFencing = ByteBuffer.allocate(10000);
        channelErrorAfterFencing.read(stateErrorAfterFencing, this.superBlockLength());
        Assertions.assertEquals((Object)stateMutableBeforeFencing, (Object)stateErrorAfterFencing);
        this.state().close();
        FileTierPartitionState newState = (FileTierPartitionState)this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler());
        Assertions.assertEquals((Object)newState.lastFlushedErrorOffsetAndEpoch(), (Object)errorOffsetAndEpoch);
        newState.close();
        channelErrorAfterFencing.close();
    }

    @Test
    public void testStateUpdateFailureFencingFlushMechanism_ViaPartitionFenceEvent() {
        java.util.UUID objectId1 = java.util.UUID.randomUUID();
        OffsetAndEpoch nextOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        int tierEpoch = 0;
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), tierEpoch, objectId1, 0), nextOffsetAndEpoch));
        int endOffsetBeforeFencing = 10;
        java.util.UUID objectId2 = java.util.UUID.randomUUID();
        OffsetAndEpoch stateOffsetUpload1 = this.currentStateOffset();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, 0L, (long)endOffsetBeforeFencing, 100L, 100, false, false, false, stateOffsetUpload1, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        OffsetAndEpoch nextOffsetAndEpochBeforeFencing = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), 0, objectId2, stateOffsetUpload1), nextOffsetAndEpochBeforeFencing));
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
        Assertions.assertEquals((Object)nextOffsetAndEpochBeforeFencing, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        Assertions.assertTrue((boolean)this.state().flush());
        CheckedFileIO channelMutableBeforeFencing = CheckedFileIO.open((Path)FileTierPartitionState.mutableFilePath((String)this.state().basePath(), (Algorithm)this.checksumAlgorithm()), (OpenOption[])new OpenOption[]{StandardOpenOption.READ});
        Assertions.assertTrue((channelMutableBeforeFencing.size() > 0L ? 1 : 0) != 0);
        ByteBuffer serializedStateMutableBeforeFencing = ByteBuffer.allocate(10000);
        channelMutableBeforeFencing.read(serializedStateMutableBeforeFencing, 0L);
        channelMutableBeforeFencing.close();
        OffsetAndEpoch errorOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        java.util.UUID objectId3 = java.util.UUID.randomUUID();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierPartitionFence(this.tpid(), objectId3, false), errorOffsetAndEpoch));
        Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        OffsetAndEpoch stateOffsetUpload2 = this.currentStateOffset();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, java.util.UUID.randomUUID(), (long)(endOffsetBeforeFencing + 1), (long)(endOffsetBeforeFencing + 10), 100L, 100, false, false, false, stateOffsetUpload2, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        Assertions.assertTrue((boolean)this.state().flush());
        CheckedFileIO channelFlushedAfterFencing = CheckedFileIO.open((Path)FileTierPartitionState.flushedFilePath((String)this.state().basePath(), (Algorithm)this.checksumAlgorithm()), (OpenOption[])new OpenOption[]{StandardOpenOption.READ});
        Assertions.assertTrue((channelFlushedAfterFencing.size() > 0L ? 1 : 0) != 0);
        Optional headerFlushedAfterFencing = FileTierPartitionState.readHeader((CheckedFileIO)channelFlushedAfterFencing);
        Assertions.assertTrue((boolean)headerFlushedAfterFencing.isPresent());
        Assertions.assertEquals((Object)new Header(this.tpid().topicId(), this.state().version(), tierEpoch, TierPartitionStatus.ERROR, 0L, 10L, OffsetAndEpoch.EMPTY, errorOffsetAndEpoch, errorOffsetAndEpoch, OffsetAndEpoch.EMPTY), headerFlushedAfterFencing.get());
        ByteBuffer serializedStateFlushedAfterFencing = ByteBuffer.allocate(10000);
        channelFlushedAfterFencing.read(serializedStateFlushedAfterFencing, 0L);
        channelFlushedAfterFencing.close();
        Assertions.assertEquals((Object)serializedStateMutableBeforeFencing, (Object)serializedStateFlushedAfterFencing);
        this.state().close();
        FileTierPartitionState newState = (FileTierPartitionState)this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler());
        Assertions.assertEquals((Object)newState.lastFlushedErrorOffsetAndEpoch(), (Object)errorOffsetAndEpoch);
        newState.close();
    }

    @Test
    public void testStateUpdateFailureFencingFlush_DuringAbsentHeader() {
        java.util.UUID objectId = java.util.UUID.randomUUID();
        OffsetAndEpoch nextOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, objectId, 0), nextOffsetAndEpoch));
        Assertions.assertEquals((Object)TierPartitionStatus.ONLINE, (Object)this.state().status());
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        Assertions.assertTrue((boolean)this.state().flush());
        CheckedFileIO channelMutableBeforeFencing = CheckedFileIO.open((Path)FileTierPartitionState.mutableFilePath((String)this.state().basePath(), (Algorithm)this.checksumAlgorithm()), (OpenOption[])new OpenOption[]{StandardOpenOption.READ});
        Assertions.assertTrue((channelMutableBeforeFencing.size() > 0L ? 1 : 0) != 0);
        ByteBuffer stateMutableBeforeFencing = ByteBuffer.allocate(10000);
        channelMutableBeforeFencing.read(stateMutableBeforeFencing, 0L);
        channelMutableBeforeFencing.close();
        OffsetAndEpoch errorOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        OffsetAndEpoch stateOffsetUpload1 = this.currentStateOffset();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), 0, objectId, stateOffsetUpload1), errorOffsetAndEpoch));
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), 0, objectId, 0L, 10L, 100L, 100, false, false, false, stateOffsetUpload1, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)nextOffsetAndEpoch, (Object)this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionStatus.ERROR, (Object)this.state().status());
        Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)this.state().lastFlushedErrorOffsetAndEpoch());
        Files.delete(FileTierPartitionState.flushedFilePath((String)this.state().basePath(), (Algorithm)this.checksumAlgorithm()));
        Assertions.assertTrue((boolean)this.state().flush());
        CheckedFileIO channelFlushedAfterFencing = CheckedFileIO.open((Path)FileTierPartitionState.flushedFilePath((String)this.state().basePath(), (Algorithm)this.checksumAlgorithm()), (OpenOption[])new OpenOption[]{StandardOpenOption.READ});
        Assertions.assertTrue((channelFlushedAfterFencing.size() > 0L ? 1 : 0) != 0);
        Optional headerFlushedAfterFencing = FileTierPartitionState.readHeader((CheckedFileIO)channelFlushedAfterFencing);
        Assertions.assertTrue((boolean)headerFlushedAfterFencing.isPresent());
        Assertions.assertEquals((Object)new Header(this.tpid().topicId(), this.state().version(), -1, TierPartitionStatus.ERROR, -1L, -1L, new OffsetAndEpoch(-1L, Optional.empty()), new OffsetAndEpoch(-1L, Optional.empty()), new OffsetAndEpoch(-1L, Optional.empty()), errorOffsetAndEpoch), headerFlushedAfterFencing.get());
    }

    @Test
    public void testIdempotencyDeleteAfterComplete() {
        TierTopicInitLeader initLeader = new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0);
        java.util.UUID objectId1 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate1 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, 0L, 10L, 100L, 100, false, false, false, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(1))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete1 = new TierSegmentUploadComplete(this.tpid(), 0, objectId1, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        TierSegmentDeleteInitiate deleteInitiate1 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId1, new OffsetAndEpoch(2L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        TierSegmentDeleteComplete deleteComplete1 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId1, new OffsetAndEpoch(2L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        java.util.UUID objectId2 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, 10L, 20L, 100L, 100, false, false, false, new OffsetAndEpoch(5L, Optional.of(Predef$.MODULE$.int2Integer(1))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete2 = new TierSegmentUploadComplete(this.tpid(), 0, objectId2, new OffsetAndEpoch(5L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        TierSegmentDeleteInitiate deleteInitiate2 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId2, new OffsetAndEpoch(5L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        TierSegmentDeleteComplete deleteComplete2 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId2, new OffsetAndEpoch(5L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        this.testDuplicateAppend((AbstractTierMetadata)initLeader, (Seq<AbstractTierMetadata>)Nil$.MODULE$, TierPartitionState.AppendResult.ACCEPTED);
        ListBuffer currentTransitions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractTierSegmentMetadata[]{uploadInitiate1, uploadComplete1, deleteInitiate1, deleteComplete1, uploadInitiate2, uploadComplete2, deleteInitiate2, deleteComplete2}))).foreach((Function1 & Serializable & scala.Serializable)transition -> {
            this.testDuplicateAppend((AbstractTierMetadata)transition, (Seq<AbstractTierMetadata>)currentTransitions, TierPartitionState.AppendResult.ACCEPTED);
            return currentTransitions.$plus$eq(transition);
        });
    }

    @Test
    public void testIdempotencyDelayedDelete() {
        TierTopicInitLeader initLeader = new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0);
        java.util.UUID objectId1 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate1 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, 0L, 10L, 100L, 100, false, false, false, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(3))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete1 = new TierSegmentUploadComplete(this.tpid(), 0, objectId1, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        TierSegmentDeleteInitiate deleteInitiate1 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId1, new OffsetAndEpoch(3L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        TierSegmentDeleteComplete deleteComplete1 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId1, new OffsetAndEpoch(3L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        java.util.UUID objectId2 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, 10L, 20L, 100L, 100, false, false, false, new OffsetAndEpoch(4L, Optional.of(Predef$.MODULE$.int2Integer(3))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete2 = new TierSegmentUploadComplete(this.tpid(), 0, objectId2, new OffsetAndEpoch(4L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        TierSegmentDeleteInitiate deleteInitiate2 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId2, new OffsetAndEpoch(6L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        TierSegmentDeleteComplete deleteComplete2 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId2, new OffsetAndEpoch(6L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        this.testDuplicateAppend((AbstractTierMetadata)initLeader, (Seq<AbstractTierMetadata>)Nil$.MODULE$, TierPartitionState.AppendResult.ACCEPTED);
        ListBuffer currentTransitions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractTierSegmentMetadata[]{uploadInitiate1, uploadComplete1, uploadInitiate2, uploadComplete2, deleteInitiate1, deleteComplete1, deleteInitiate2, deleteComplete2}))).foreach((Function1 & Serializable & scala.Serializable)transition -> {
            this.testDuplicateAppend((AbstractTierMetadata)transition, (Seq<AbstractTierMetadata>)currentTransitions, TierPartitionState.AppendResult.ACCEPTED);
            return currentTransitions.$plus$eq(transition);
        });
    }

    @Test
    public void testStateRestoreCompletesTargetObjectIdListener() {
        TierTopicInitLeader initLeader = new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0);
        java.util.UUID objectId1 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate1 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, 0L, 10L, 100L, 100, false, false, false, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(3))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete1 = new TierSegmentUploadComplete(this.tpid(), 0, objectId1, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        java.util.UUID objectId2 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, 10L, 20L, 100L, 100, false, false, false, new OffsetAndEpoch(4L, Optional.of(Predef$.MODULE$.int2Integer(3))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete2 = new TierSegmentUploadComplete(this.tpid(), 0, objectId2, new OffsetAndEpoch(5L, Optional.of(Predef$.MODULE$.int2Integer(5))));
        this.testDuplicateAppend((AbstractTierMetadata)initLeader, (Seq<AbstractTierMetadata>)Nil$.MODULE$, TierPartitionState.AppendResult.ACCEPTED);
        ListBuffer currentTransitions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        new .colon.colon((Object)uploadInitiate1, (List)new .colon.colon((Object)uploadComplete1, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)transition -> {
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)transition, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            return currentTransitions.$plus$eq(transition);
        });
        Assertions.assertTrue((boolean)this.state().materializeUptoObjectIdAndRestoreEpoch(uploadInitiate1.endOffset() + 1L, uploadInitiate1.objectId(), -1).isDone());
        new .colon.colon((Object)uploadInitiate2, (List)new .colon.colon((Object)uploadComplete2, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)transition -> {
            Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)transition, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
            return currentTransitions.$plus$eq(transition);
        });
        CompletableFuture listener = this.state().materializeUptoObjectIdAndRestoreEpoch(uploadInitiate2.endOffset() + 1L, uploadInitiate2.objectId(), 1);
        Assertions.assertFalse((boolean)listener.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierPartitionFence(this.tpid(), java.util.UUID.randomUUID(), false), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)this.state().flush());
        Optional restorableStart = this.state().startOffset();
        long restorableEnd = this.state().endOffset();
        OffsetAndEpoch restorableValidity = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        ByteBuffer originalBytes = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(this.state().flushedPath(), new String[0]));
        TierPartitionForceRestore recoveryMetadata = new TierPartitionForceRestore(this.tpid(), java.util.UUID.randomUUID(), Predef$.MODULE$.Long2long(restorableStart.orElse(Predef$.MODULE$.long2Long(-1L))), restorableEnd, restorableValidity, "hash", Predef$.MODULE$.boolean2Boolean(false));
        OffsetAndEpoch nextOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Optional<Integer> newEpoch = nextOffsetAndEpoch.epoch().isPresent() ? Optional.of(BoxesRunTime.boxToInteger((int)(Predef$.MODULE$.Integer2int((Integer)nextOffsetAndEpoch.epoch().get()) + 1))) : Optional.of(BoxesRunTime.boxToInteger((int)1));
        OffsetAndEpoch restoreEpoch = new OffsetAndEpoch(nextOffsetAndEpoch.offset(), newEpoch.map(x -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)x))));
        Assertions.assertEquals((Object)TierPartitionState.RestoreResult.SUCCEEDED, (Object)this.state().processRestoreEvents((AbstractTierMetadata)recoveryMetadata, Optional.of(originalBytes), TierPartitionStatus.ONLINE, restoreEpoch));
        Assertions.assertTrue((boolean)listener.isCompletedExceptionally());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToInteger((int)1)), (Object)this.state().restoreOffsetAndEpoch().epoch());
        Assertions.assertTrue((boolean)this.state().materializeUptoObjectIdAndRestoreEpoch(uploadInitiate2.endOffset() + 1L, uploadInitiate2.objectId(), 1).isDone());
    }

    @Test
    public void testStateRestoreFunctionality() {
        TierTopicInitLeader initLeader = new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0);
        java.util.UUID objectId1 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate1 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, 0L, 10L, 100L, 100, false, false, false, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(3))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete1 = new TierSegmentUploadComplete(this.tpid(), 0, objectId1, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        TierSegmentDeleteInitiate deleteInitiate1 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId1, new OffsetAndEpoch(3L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        TierSegmentDeleteComplete deleteComplete1 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId1, new OffsetAndEpoch(3L, Optional.of(Predef$.MODULE$.int2Integer(3))));
        java.util.UUID objectId2 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, 10L, 20L, 100L, 100, false, false, false, new OffsetAndEpoch(4L, Optional.of(Predef$.MODULE$.int2Integer(3))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete2 = new TierSegmentUploadComplete(this.tpid(), 0, objectId2, new OffsetAndEpoch(5L, Optional.of(Predef$.MODULE$.int2Integer(5))));
        TierSegmentDeleteInitiate deleteInitiate2 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId2, new OffsetAndEpoch(6L, Optional.of(Predef$.MODULE$.int2Integer(5))));
        TierSegmentDeleteComplete deleteComplete2 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId2, new OffsetAndEpoch(6L, Optional.of(Predef$.MODULE$.int2Integer(5))));
        this.testDuplicateAppend((AbstractTierMetadata)initLeader, (Seq<AbstractTierMetadata>)Nil$.MODULE$, TierPartitionState.AppendResult.ACCEPTED);
        ListBuffer currentTransitions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractTierSegmentMetadata[]{uploadInitiate1, uploadComplete1, uploadInitiate2, uploadComplete2, deleteInitiate1, deleteComplete1, deleteInitiate2, deleteComplete2}))).foreach((Function1 & Serializable & scala.Serializable)transition -> {
            this.testDuplicateAppend((AbstractTierMetadata)transition, (Seq<AbstractTierMetadata>)currentTransitions, TierPartitionState.AppendResult.ACCEPTED);
            return currentTransitions.$plus$eq(transition);
        });
        Assertions.assertTrue((boolean)this.state().flush());
        Optional restorableStart = this.state().startOffset();
        long restorableEnd = this.state().endOffset();
        OffsetAndEpoch restorableValidity = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        this.state().close();
        ByteBuffer originalBytes = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(this.state().flushedPath(), new String[0]));
        File newDir = TestUtils$.MODULE$.randomPartitionLogDir(TestUtils$.MODULE$.tempDir());
        FileTierPartitionState newState = (FileTierPartitionState)this.factory().initState(newDir, this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler());
        newState.setTopicId(this.tpid().topicId());
        newState.setTieredPartitionRecoveryWorkflowCb(op -> {
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ debug_this = testUtils$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(FileTierPartitionStateTest.$anonfun$testStateRestoreFunctionality$3(op, newState)));
                return;
            }
        });
        newState.beginCatchup();
        newState.onCatchUpComplete();
        this.testDuplicateAppend((TierPartitionState)newState, (AbstractTierMetadata)initLeader, (Seq<AbstractTierMetadata>)Nil$.MODULE$, TierPartitionState.AppendResult.ACCEPTED);
        ListBuffer newTransitions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        new .colon.colon((Object)uploadInitiate1, (List)new .colon.colon((Object)uploadComplete1, (List)new .colon.colon((Object)uploadInitiate2, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)transition -> {
            this.testDuplicateAppend((TierPartitionState)newState, (AbstractTierMetadata)transition, (Seq<AbstractTierMetadata>)newTransitions, TierPartitionState.AppendResult.ACCEPTED);
            return newTransitions.$plus$eq(transition);
        });
        Assertions.assertTrue((boolean)newState.flush());
        TierPartitionFence fenceMetadata = new TierPartitionFence(this.tpid(), java.util.UUID.randomUUID(), false);
        OffsetAndEpoch fenceOffset = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)newState.append((AbstractTierMetadata)fenceMetadata, fenceOffset));
        TierPartitionForceRestore recoveryMetadata = new TierPartitionForceRestore(this.tpid(), java.util.UUID.randomUUID(), Predef$.MODULE$.Long2long(restorableStart.orElse(Predef$.MODULE$.long2Long(-1L))), restorableEnd, restorableValidity, "hash", Predef$.MODULE$.boolean2Boolean(false));
        Assertions.assertEquals((Object)TierPartitionState.RestoreResult.SUCCEEDED, (Object)newState.processRestoreEvents((AbstractTierMetadata)recoveryMetadata, Optional.of(originalBytes), TierPartitionStatus.ONLINE, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.RestoreResult.FAILED, (Object)newState.processRestoreEvents((AbstractTierMetadata)new TierPartitionForceRestore(this.tpid(), java.util.UUID.randomUUID(), Predef$.MODULE$.Long2long(restorableStart.orElse(Predef$.MODULE$.long2Long(-1L))), restorableEnd, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch(), "hash", Predef$.MODULE$.boolean2Boolean(false)), Optional.of(originalBytes), TierPartitionStatus.ONLINE, new OffsetAndEpoch(0L, Optional.empty())));
        Assertions.assertEquals((Object)TierPartitionState.RestoreResult.FAILED, (Object)newState.processRestoreEvents((AbstractTierMetadata)new TierPartitionForceRestore(this.tpid(), java.util.UUID.randomUUID(), Predef$.MODULE$.Long2long(restorableStart.orElse(Predef$.MODULE$.long2Long(-1L))), restorableEnd, fenceOffset, "hash", Predef$.MODULE$.boolean2Boolean(false)), Optional.of(originalBytes), TierPartitionStatus.ONLINE, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)restorableEnd, (long)newState.endOffset());
        java.util.UUID objectId3 = java.util.UUID.randomUUID();
        OffsetAndEpoch upload3stateOffset = newState.lastLocalMaterializedSrcOffsetAndEpoch();
        TierSegmentUploadInitiate uploadInitiate3 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId3, 21L, 50L, 100L, 100, false, false, false, upload3stateOffset, TierObjectStore.OpaqueData.ZEROED);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)newState.append((AbstractTierMetadata)uploadInitiate3, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        TierSegmentUploadComplete uploadComplete3 = new TierSegmentUploadComplete(this.tpid(), 0, objectId3, upload3stateOffset);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)newState.append((AbstractTierMetadata)uploadComplete3, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)50L, (long)newState.endOffset());
        newState.close();
        FileTierPartitionState reopenedNewState = (FileTierPartitionState)this.factory().initState(newDir, this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler());
        Assertions.assertEquals((long)50L, (long)reopenedNewState.endOffset());
        reopenedNewState.close();
    }

    @Test
    public void testStateRestoreFencingStaleMetadata() {
        TierTopicInitLeader initLeader = new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0);
        java.util.UUID objectId1 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate1 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, 0L, 10L, 100L, 100, false, false, false, new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(1))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete1 = new TierSegmentUploadComplete(this.tpid(), 0, objectId1, new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        java.util.UUID objectId2 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, 10L, 20L, 100L, 100, false, false, false, new OffsetAndEpoch(2L, Optional.of(Predef$.MODULE$.int2Integer(1))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete2 = new TierSegmentUploadComplete(this.tpid(), 0, objectId2, new OffsetAndEpoch(2L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        new .colon.colon((Object)initLeader, (List)new .colon.colon((Object)uploadInitiate1, (List)new .colon.colon((Object)uploadComplete1, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)transition -> {
            FileTierPartitionStateTest.$anonfun$testStateRestoreFencingStaleMetadata$1(this, transition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)0L, (Long)((Long)this.state().startOffset().get()));
        Assertions.assertEquals((long)10L, (long)this.state().endOffset());
        Long restorableStart = this.state().startOffset().orElse(Predef$.MODULE$.long2Long(-1L));
        long restorableEnd = this.state().endOffset();
        ByteBuffer restorableBytes = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(this.state().flushedPath(), new String[0]));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)uploadInitiate2, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)uploadComplete2, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)0L, (Long)((Long)this.state().startOffset().get()));
        Assertions.assertEquals((long)20L, (long)this.state().endOffset());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)this.state().append((AbstractTierMetadata)new TierPartitionFence(this.tpid(), java.util.UUID.randomUUID(), false), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        OffsetAndEpoch fenceOffset = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        TierPartitionForceRestore recoveryMetadata = new TierPartitionForceRestore(this.tpid(), java.util.UUID.randomUUID(), Predef$.MODULE$.Long2long(restorableStart), restorableEnd, fenceOffset, "hash", Predef$.MODULE$.boolean2Boolean(false));
        this.state().processRestoreEvents((AbstractTierMetadata)recoveryMetadata, Optional.of(restorableBytes), TierPartitionStatus.ONLINE, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((long)0L, (Long)((Long)this.state().startOffset().get()));
        Assertions.assertEquals((long)10L, (long)this.state().endOffset());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.RESTORE_FENCED, (Object)this.state().append((AbstractTierMetadata)uploadInitiate2, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)0L, (Long)((Long)this.state().startOffset().get()));
        Assertions.assertEquals((long)10L, (long)this.state().endOffset());
    }

    @Test
    public void testErrorStateRestoreUploadSameSegmentSameEpoch() {
        TierTopicInitLeader initLeader = new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0);
        java.util.UUID objectId1 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate1 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, 0L, 10L, 100L, 100, false, false, false, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(1))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete1 = new TierSegmentUploadComplete(this.tpid(), 0, objectId1, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        java.util.UUID objectId2 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, 10L, 20L, 100L, 100, false, false, false, new OffsetAndEpoch(4L, Optional.of(Predef$.MODULE$.int2Integer(1))), TierObjectStore.OpaqueData.ZEROED);
        new .colon.colon((Object)initLeader, (List)new .colon.colon((Object)uploadInitiate1, (List)new .colon.colon((Object)uploadComplete1, (List)new .colon.colon((Object)uploadInitiate2, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)transition -> {
            FileTierPartitionStateTest.$anonfun$testErrorStateRestoreUploadSameSegmentSameEpoch$1(this, transition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)0L, (Long)((Long)this.state().startOffset().get()));
        Assertions.assertEquals((long)10L, (long)this.state().endOffset());
        Assertions.assertEquals((int)0, (int)this.state().fencedSegments().size(), (String)"upload 2 should not be fenced yet");
        Long restorableStart = this.state().startOffset().orElse(Predef$.MODULE$.long2Long(-1L));
        long restorableEnd = this.state().endOffset();
        ByteBuffer restorableBytes = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(this.state().flushedPath(), new String[0]));
        this.state().close();
        File newDir = TestUtils$.MODULE$.randomPartitionLogDir(TestUtils$.MODULE$.tempDir());
        FileTierPartitionState newState = (FileTierPartitionState)this.factory().initState(newDir, this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler());
        newState.setTopicId(this.tpid().topicId());
        newState.setTieredPartitionRecoveryWorkflowCb(op -> {
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ debug_this = testUtils$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(FileTierPartitionStateTest.$anonfun$testErrorStateRestoreUploadSameSegmentSameEpoch$3(op, newState)));
                return;
            }
        });
        newState.beginCatchup();
        newState.onCatchUpComplete();
        TierPartitionFence fenceMetadata = new TierPartitionFence(this.tpid(), java.util.UUID.randomUUID(), false);
        OffsetAndEpoch fenceOffset = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)newState.append((AbstractTierMetadata)fenceMetadata, fenceOffset));
        TierPartitionForceRestore recoveryMetadata = new TierPartitionForceRestore(this.tpid(), java.util.UUID.randomUUID(), Predef$.MODULE$.Long2long(restorableStart), restorableEnd, fenceOffset, "hash", Predef$.MODULE$.boolean2Boolean(false));
        Assertions.assertEquals((Object)TierPartitionState.RestoreResult.SUCCEEDED, (Object)newState.processRestoreEvents((AbstractTierMetadata)recoveryMetadata, Optional.of(restorableBytes), TierPartitionStatus.ONLINE, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)0L, (Long)((Long)newState.startOffset().get()));
        Assertions.assertEquals((long)10L, (long)newState.endOffset());
        Assertions.assertEquals((Object)TierTestUtils$.MODULE$.currentOffsetAndEpoch(), (Object)newState.restoreOffsetAndEpoch());
        java.util.UUID objectId3 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2v2 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId3, 10L, 20L, 100L, 100, false, false, false, new OffsetAndEpoch(7L, Optional.of(Predef$.MODULE$.int2Integer(1))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete2v2 = new TierSegmentUploadComplete(this.tpid(), 0, objectId3, new OffsetAndEpoch(7L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        new .colon.colon((Object)uploadInitiate2v2, (List)new .colon.colon((Object)uploadComplete2v2, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)transition -> {
            FileTierPartitionStateTest.$anonfun$testErrorStateRestoreUploadSameSegmentSameEpoch$4(newState, transition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)1, (int)newState.fencedSegments().size(), (String)"object 2 should be fenced after recovery");
        Assertions.assertEquals((Object)objectId2, (Object)((TierLogSegment)newState.fencedSegments().iterator().next()).objectId(), (String)"aborted upload before recovery should have been fenced");
        Assertions.assertEquals((int)0, (int)newState.tierEpoch());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)0L)), (Object)newState.startOffset());
        Assertions.assertEquals((long)20L, (long)newState.endOffset());
        Assertions.assertTrue((boolean)newState.flush());
        newState.close();
    }

    @Test
    public void testFenceContinuedUploadAfterRestore() {
        TierTopicInitLeader initLeader = new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0);
        java.util.UUID objectId1 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate1 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, 0L, 10L, 100L, 100, false, false, false, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(1))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete1 = new TierSegmentUploadComplete(this.tpid(), 0, objectId1, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        java.util.UUID objectId2 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, 10L, 20L, 100L, 100, false, false, false, new OffsetAndEpoch(4L, Optional.of(Predef$.MODULE$.int2Integer(1))), TierObjectStore.OpaqueData.ZEROED);
        new .colon.colon((Object)initLeader, (List)new .colon.colon((Object)uploadInitiate1, (List)new .colon.colon((Object)uploadComplete1, (List)new .colon.colon((Object)uploadInitiate2, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)transition -> {
            FileTierPartitionStateTest.$anonfun$testFenceContinuedUploadAfterRestore$1(this, transition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)0L, (Long)((Long)this.state().startOffset().get()));
        Assertions.assertEquals((long)10L, (long)this.state().endOffset());
        Assertions.assertEquals((int)0, (int)this.state().fencedSegments().size(), (String)"upload 2 should not be fenced yet");
        Long restorableStart = this.state().startOffset().orElse(Predef$.MODULE$.long2Long(-1L));
        long restorableEnd = this.state().endOffset();
        ByteBuffer restorableBytes = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(this.state().flushedPath(), new String[0]));
        this.state().close();
        File newDir = TestUtils$.MODULE$.randomPartitionLogDir(TestUtils$.MODULE$.tempDir());
        FileTierPartitionState newState = (FileTierPartitionState)this.factory().initState(newDir, this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler());
        newState.setTopicId(this.tpid().topicId());
        newState.setTieredPartitionRecoveryWorkflowCb(op -> {
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ debug_this = testUtils$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(FileTierPartitionStateTest.$anonfun$testFenceContinuedUploadAfterRestore$3(op, newState)));
                return;
            }
        });
        newState.beginCatchup();
        newState.onCatchUpComplete();
        TierPartitionFence fenceMetadata = new TierPartitionFence(this.tpid(), java.util.UUID.randomUUID(), false);
        OffsetAndEpoch fenceOffset = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)newState.append((AbstractTierMetadata)fenceMetadata, fenceOffset));
        TierPartitionForceRestore recoveryMetadata = new TierPartitionForceRestore(this.tpid(), java.util.UUID.randomUUID(), Predef$.MODULE$.Long2long(restorableStart), restorableEnd, fenceOffset, "hash", Predef$.MODULE$.boolean2Boolean(false));
        newState.processRestoreEvents((AbstractTierMetadata)recoveryMetadata, Optional.of(restorableBytes), TierPartitionStatus.ONLINE, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((long)0L, (Long)((Long)newState.startOffset().get()));
        Assertions.assertEquals((long)10L, (long)newState.endOffset());
        Assertions.assertEquals((Object)TierTestUtils$.MODULE$.currentOffsetAndEpoch(), (Object)newState.restoreOffsetAndEpoch());
        TierSegmentUploadComplete uploadComplete2 = new TierSegmentUploadComplete(this.tpid(), 0, objectId2, new OffsetAndEpoch(3L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        new .colon.colon((Object)uploadComplete2, (List)Nil$.MODULE$).foreach((Function1 & Serializable & scala.Serializable)transition -> {
            FileTierPartitionStateTest.$anonfun$testFenceContinuedUploadAfterRestore$4(newState, transition);
            return BoxedUnit.UNIT;
        });
        java.util.UUID objectId3 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2v2 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId3, 10L, 20L, 100L, 100, false, false, false, new OffsetAndEpoch(7L, Optional.of(Predef$.MODULE$.int2Integer(1))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete2v2 = new TierSegmentUploadComplete(this.tpid(), 0, objectId3, new OffsetAndEpoch(7L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        new .colon.colon((Object)uploadInitiate2v2, (List)new .colon.colon((Object)uploadComplete2v2, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)transition -> {
            FileTierPartitionStateTest.$anonfun$testFenceContinuedUploadAfterRestore$5(newState, transition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)1, (int)newState.fencedSegments().size(), (String)"object 2 should be fenced after new upload");
        Assertions.assertEquals((Object)objectId2, (Object)((TierLogSegment)newState.fencedSegments().iterator().next()).objectId(), (String)"aborted upload before recovery should have been fenced");
        Assertions.assertEquals((int)0, (int)newState.tierEpoch());
        Assertions.assertEquals(Optional.of(BoxesRunTime.boxToLong((long)0L)), (Object)newState.startOffset());
        Assertions.assertEquals((long)20L, (long)newState.endOffset());
        Assertions.assertTrue((boolean)newState.flush());
        newState.close();
    }

    @Test
    public void testStateRestoreCausingTruncateAndReapply() {
        TierTopicInitLeader initLeader = new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0);
        java.util.UUID objectId1 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate1 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, 0L, 10L, 100L, 100, false, false, false, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(1))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete1 = new TierSegmentUploadComplete(this.tpid(), 0, objectId1, new OffsetAndEpoch(1L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        TierSegmentDeleteInitiate deleteInitiate1 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId1, new OffsetAndEpoch(3L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        TierSegmentDeleteComplete deleteComplete1 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId1, new OffsetAndEpoch(3L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        java.util.UUID objectId2 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, 10L, 20L, 100L, 100, false, false, false, new OffsetAndEpoch(4L, Optional.of(Predef$.MODULE$.int2Integer(1))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete2 = new TierSegmentUploadComplete(this.tpid(), 0, objectId2, new OffsetAndEpoch(4L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        TierSegmentDeleteInitiate deleteInitiate2 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId2, new OffsetAndEpoch(6L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        TierSegmentDeleteComplete deleteComplete2 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId2, new OffsetAndEpoch(6L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        new .colon.colon((Object)initLeader, (List)new .colon.colon((Object)uploadInitiate1, (List)new .colon.colon((Object)uploadComplete1, (List)new .colon.colon((Object)uploadInitiate2, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)transition -> {
            FileTierPartitionStateTest.$anonfun$testStateRestoreCausingTruncateAndReapply$1(this, transition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((long)0L, (Long)((Long)this.state().startOffset().get()));
        Assertions.assertEquals((long)10L, (long)this.state().endOffset());
        Long restorableStart = this.state().startOffset().orElse(Predef$.MODULE$.long2Long(-1L));
        long restorableEnd = this.state().endOffset();
        ByteBuffer restorableBytes = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(this.state().flushedPath(), new String[0]));
        this.state().close();
        File newDir = TestUtils$.MODULE$.randomPartitionLogDir(TestUtils$.MODULE$.tempDir());
        FileTierPartitionState newState = (FileTierPartitionState)this.factory().initState(newDir, this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler());
        newState.setTopicId(this.tpid().topicId());
        newState.setTieredPartitionRecoveryWorkflowCb(op -> {
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ debug_this = testUtils$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(FileTierPartitionStateTest.$anonfun$testStateRestoreCausingTruncateAndReapply$3(op, newState)));
                return;
            }
        });
        newState.beginCatchup();
        newState.onCatchUpComplete();
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractTierMetadata[]{initLeader, uploadInitiate1, uploadComplete1, uploadInitiate2, uploadComplete2, deleteInitiate1, deleteComplete1, deleteInitiate2, deleteComplete2}))).foreach((Function1 & Serializable & scala.Serializable)transition -> {
            FileTierPartitionStateTest.$anonfun$testStateRestoreCausingTruncateAndReapply$4(newState, transition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)newState.flush());
        Assertions.assertFalse((boolean)newState.startOffset().isPresent());
        Assertions.assertEquals((long)20L, (long)newState.endOffset());
        TierPartitionFence fenceMetadata = new TierPartitionFence(this.tpid(), java.util.UUID.randomUUID(), false);
        OffsetAndEpoch fenceOffset = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)newState.append((AbstractTierMetadata)fenceMetadata, fenceOffset));
        TierPartitionForceRestore recoveryMetadata = new TierPartitionForceRestore(this.tpid(), java.util.UUID.randomUUID(), Predef$.MODULE$.Long2long(restorableStart), restorableEnd, fenceOffset, "hash", Predef$.MODULE$.boolean2Boolean(false));
        newState.processRestoreEvents((AbstractTierMetadata)recoveryMetadata, Optional.of(restorableBytes), TierPartitionStatus.ONLINE, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((long)0L, (Long)((Long)newState.startOffset().get()));
        Assertions.assertEquals((long)10L, (long)newState.endOffset());
        Assertions.assertEquals((Object)TierTestUtils$.MODULE$.currentOffsetAndEpoch(), (Object)newState.restoreOffsetAndEpoch());
        new .colon.colon((Object)uploadComplete2, (List)new .colon.colon((Object)deleteInitiate1, (List)new .colon.colon((Object)deleteComplete1, (List)new .colon.colon((Object)deleteInitiate2, (List)new .colon.colon((Object)deleteComplete2, (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)transition -> {
            FileTierPartitionStateTest.$anonfun$testStateRestoreCausingTruncateAndReapply$5(newState, transition);
            return BoxedUnit.UNIT;
        });
        java.util.UUID objectId3 = java.util.UUID.randomUUID();
        OffsetAndEpoch afterRestoreStateOffset = newState.lastLocalMaterializedSrcOffsetAndEpoch();
        TierSegmentDeleteInitiate deleteInitiate1redo = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId1, afterRestoreStateOffset);
        TierSegmentDeleteComplete deleteComplete1redo = new TierSegmentDeleteComplete(this.tpid(), 0, objectId1, afterRestoreStateOffset);
        TierSegmentUploadInitiate uploadInitiate3 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId3, 10L, 20L, 100L, 100, false, false, false, new OffsetAndEpoch(afterRestoreStateOffset.offset() + 2L, afterRestoreStateOffset.epoch()), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete3 = new TierSegmentUploadComplete(this.tpid(), 0, objectId3, new OffsetAndEpoch(afterRestoreStateOffset.offset() + 2L, afterRestoreStateOffset.epoch()));
        TierSegmentDeleteInitiate deleteInitiate3 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId3, new OffsetAndEpoch(afterRestoreStateOffset.offset() + 4L, afterRestoreStateOffset.epoch()));
        TierSegmentDeleteComplete deleteComplete3 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId3, new OffsetAndEpoch(afterRestoreStateOffset.offset() + 4L, afterRestoreStateOffset.epoch()));
        new .colon.colon((Object)deleteInitiate1redo, (List)new .colon.colon((Object)deleteComplete1redo, (List)new .colon.colon((Object)uploadInitiate3, (List)new .colon.colon((Object)uploadComplete3, (List)new .colon.colon((Object)deleteInitiate3, (List)new .colon.colon((Object)deleteComplete3, (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable & scala.Serializable)transition -> {
            FileTierPartitionStateTest.$anonfun$testStateRestoreCausingTruncateAndReapply$6(newState, transition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)newState.startOffset().isPresent());
        Assertions.assertEquals((long)20L, (long)newState.endOffset());
        Assertions.assertTrue((boolean)newState.flush());
        newState.close();
    }

    @Test
    public void testStateRestoreMigrateVersion() {
        int originalVersion = 5;
        FileTierPartitionState state1 = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (byte)originalVersion, (Scheduler)this.time().scheduler(), this.checksumEnabled());
        state1.setTopicId(this.tpid().topicId());
        state1.beginCatchup();
        state1.onCatchUpComplete();
        TierTopicInitLeader initLeader = new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)state1.append((AbstractTierMetadata)initLeader, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        TierPartitionFence fenceMetadata = new TierPartitionFence(this.tpid(), java.util.UUID.randomUUID(), false);
        OffsetAndEpoch fenceOffset = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)state1.append((AbstractTierMetadata)fenceMetadata, fenceOffset));
        Assertions.assertTrue((boolean)state1.flush());
        Long restorableStart = this.state().startOffset().orElse(Predef$.MODULE$.long2Long(-1L));
        long restorableEnd = this.state().endOffset();
        ByteBuffer restorableBytes = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(this.state().flushedPath(), new String[0]));
        state1.close();
        TierPartitionForceRestore recoveryMetadata = new TierPartitionForceRestore(this.tpid(), java.util.UUID.randomUUID(), Predef$.MODULE$.Long2long(restorableStart), restorableEnd, fenceOffset, "hash", Predef$.MODULE$.boolean2Boolean(false));
        FileTierPartitionState state2 = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled());
        state2.setTieredPartitionRecoveryWorkflowCb(op -> Predef$.MODULE$.println((Object)new StringBuilder(26).append("Received RecoveryOp: ").append(op).append(" for ").append(state2.topicIdPartition().get()).toString()));
        Assertions.assertNotEquals((int)originalVersion, (int)state2.version());
        Assertions.assertEquals((Object)TierPartitionState.RestoreResult.SUCCEEDED, (Object)state2.processRestoreEvents((AbstractTierMetadata)recoveryMetadata, Optional.of(restorableBytes), TierPartitionStatus.ONLINE, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertNotEquals((int)originalVersion, (int)state2.version());
        state2.close();
    }

    @Test
    public void testStateRestoreClosesListenersEagerly() {
        TierTopicInitLeader initLeader = new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0);
        java.util.UUID objectId1 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate1 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, 0L, 10L, 100L, 100, false, false, false, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete1 = new TierSegmentUploadComplete(this.tpid(), 0, objectId1, this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        java.util.UUID objectId2 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, 10L, 20L, 100L, 100, false, false, false, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete2 = new TierSegmentUploadComplete(this.tpid(), 0, objectId2, this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)initLeader, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        new .colon.colon((Object)uploadInitiate1, (List)new .colon.colon((Object)uploadComplete1, (List)new .colon.colon((Object)uploadInitiate2, (List)new .colon.colon((Object)uploadComplete2, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)event -> {
            FileTierPartitionStateTest.$anonfun$testStateRestoreClosesListenersEagerly$1(this, event);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.state().flush());
        Optional restorableStart = this.state().startOffset();
        long restorableEnd = this.state().endOffset();
        OffsetAndEpoch restorableValidity = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        this.state().close();
        ByteBuffer targetStateBytes = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(this.state().flushedPath(), new String[0]));
        File newDir = TestUtils$.MODULE$.randomPartitionLogDir(TestUtils$.MODULE$.tempDir());
        FileTierPartitionState newState = (FileTierPartitionState)this.factory().initState(newDir, this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler());
        newState.setTopicId(this.tpid().topicId());
        newState.setTieredPartitionRecoveryWorkflowCb(op -> {
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ debug_this = testUtils$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(FileTierPartitionStateTest.$anonfun$testStateRestoreClosesListenersEagerly$3(op, newState)));
                return;
            }
        });
        newState.beginCatchup();
        newState.onCatchUpComplete();
        AtomicBoolean initListenerThrown = new AtomicBoolean(false);
        newState.trackMetadataInitialization(Integer.MAX_VALUE).whenComplete((x$7, ex) -> initListenerThrown.set(ex != null));
        CompletableFuture leaderEpochListener = newState.materializeUptoLeaderEpoch(Integer.MAX_VALUE);
        CompletableFuture replicationListenerOffset = newState.materializeUptoOffset(Long.MAX_VALUE);
        CompletableFuture replicationListenerObjectId = newState.materializeUptoObjectIdAndRestoreEpoch(Long.MAX_VALUE, java.util.UUID.randomUUID(), -1);
        Assertions.assertFalse((boolean)initListenerThrown.get());
        Assertions.assertFalse((boolean)leaderEpochListener.isDone());
        Assertions.assertFalse((boolean)replicationListenerOffset.isDone());
        Assertions.assertFalse((boolean)replicationListenerObjectId.isDone());
        TierPartitionFence fenceMetadata = new TierPartitionFence(this.tpid(), java.util.UUID.randomUUID(), false);
        OffsetAndEpoch fenceOffset = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)newState.append((AbstractTierMetadata)fenceMetadata, fenceOffset));
        TierPartitionForceRestore recoveryMetadata = new TierPartitionForceRestore(this.tpid(), java.util.UUID.randomUUID(), Predef$.MODULE$.Long2long(restorableStart.orElse(Predef$.MODULE$.long2Long(-1L))), restorableEnd, restorableValidity, "hash", Predef$.MODULE$.boolean2Boolean(false));
        Assertions.assertEquals((Object)TierPartitionState.RestoreResult.SUCCEEDED, (Object)newState.processRestoreEvents((AbstractTierMetadata)recoveryMetadata, Optional.of(targetStateBytes), TierPartitionStatus.ONLINE, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)initListenerThrown.get());
        Assertions.assertTrue((boolean)leaderEpochListener.isCompletedExceptionally());
        Assertions.assertTrue((boolean)replicationListenerOffset.isCompletedExceptionally());
        Assertions.assertTrue((boolean)replicationListenerObjectId.isCompletedExceptionally());
    }

    @Test
    public void testStateRestoreDelayedCloseOnOldState() {
        TierTopicInitLeader initLeader = new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0);
        java.util.UUID objectId1 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate1 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, 0L, 10L, 100L, 100, false, false, false, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete1 = new TierSegmentUploadComplete(this.tpid(), 0, objectId1, this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        java.util.UUID objectId2 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, 10L, 20L, 100L, 100, false, false, false, this.state().lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete2 = new TierSegmentUploadComplete(this.tpid(), 0, objectId2, this.state().lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)initLeader, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        new .colon.colon((Object)uploadInitiate1, (List)new .colon.colon((Object)uploadComplete1, (List)new .colon.colon((Object)uploadInitiate2, (List)new .colon.colon((Object)uploadComplete2, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)event -> {
            FileTierPartitionStateTest.$anonfun$testStateRestoreDelayedCloseOnOldState$1(this, event);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.state().flush());
        Optional restorableStart = this.state().startOffset();
        long restorableEnd = this.state().endOffset();
        OffsetAndEpoch restorableValidity = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        this.state().close();
        ByteBuffer targetStateBytes = CheckedFileIOTestUtils$.MODULE$.readAllBytes(Paths.get(this.state().flushedPath(), new String[0]));
        File newDir = TestUtils$.MODULE$.randomPartitionLogDir(TestUtils$.MODULE$.tempDir());
        FileTierPartitionState newState = (FileTierPartitionState)this.factory().initState(newDir, this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler());
        newState.setTopicId(this.tpid().topicId());
        newState.setTieredPartitionRecoveryWorkflowCb(op -> {
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ debug_this = testUtils$;
            if (debug_this.logger().underlying().isDebugEnabled()) {
                debug_this.logger().underlying().debug(debug_this.msgWithLogIdent(FileTierPartitionStateTest.$anonfun$testStateRestoreDelayedCloseOnOldState$3(op, newState)));
                return;
            }
        });
        newState.beginCatchup();
        newState.onCatchUpComplete();
        java.util.UUID objectId3 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate3 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId3, 20L, 30L, 100L, 100, false, false, false, newState.lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete3 = new TierSegmentUploadComplete(this.tpid(), 0, objectId3, newState.lastLocalMaterializedSrcOffsetAndEpoch());
        java.util.UUID objectId4 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate4 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId4, 30L, 40L, 100L, 100, false, false, false, newState.lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete4 = new TierSegmentUploadComplete(this.tpid(), 0, objectId4, newState.lastLocalMaterializedSrcOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)newState.append((AbstractTierMetadata)initLeader, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        new .colon.colon((Object)uploadInitiate3, (List)new .colon.colon((Object)uploadComplete3, (List)new .colon.colon((Object)uploadInitiate4, (List)new .colon.colon((Object)uploadComplete4, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)event -> {
            FileTierPartitionStateTest.$anonfun$testStateRestoreDelayedCloseOnOldState$4(newState, event);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)newState.flush());
        TierPartitionFence fenceMetadata = new TierPartitionFence(this.tpid(), java.util.UUID.randomUUID(), false);
        OffsetAndEpoch fenceOffset = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.FAILED, (Object)newState.append((AbstractTierMetadata)fenceMetadata, fenceOffset));
        java.util.Iterator oldStateIterator1 = newState.segments();
        java.util.Iterator oldStateIterator2 = newState.segments();
        TierPartitionForceRestore recoveryMetadata = new TierPartitionForceRestore(this.tpid(), java.util.UUID.randomUUID(), Predef$.MODULE$.Long2long(restorableStart.orElse(Predef$.MODULE$.long2Long(-1L))), restorableEnd, restorableValidity, "hash", Predef$.MODULE$.boolean2Boolean(false));
        Assertions.assertEquals((Object)TierPartitionState.RestoreResult.SUCCEEDED, (Object)newState.processRestoreEvents((AbstractTierMetadata)recoveryMetadata, Optional.of(targetStateBytes), TierPartitionStatus.ONLINE, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        int oldStateCount = 0;
        Set oldStateObjectIds = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new java.util.UUID[]{objectId3, objectId4}));
        while (oldStateIterator1.hasNext()) {
            TierLogSegment tierSegment = (TierLogSegment)oldStateIterator1.next();
            Assertions.assertTrue((boolean)oldStateObjectIds.contains((Object)tierSegment.metadata().objectId()));
            oldStateObjectIds = (Set)oldStateObjectIds.$minus((Object)tierSegment.metadata().objectId());
            ++oldStateCount;
        }
        Assertions.assertEquals((int)2, (int)oldStateCount);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)oldStateObjectIds.isEmpty()));
        Assertions.assertTrue((boolean)oldStateIterator2.hasNext());
        TierLogSegment tierSegment = (TierLogSegment)oldStateIterator2.next();
        Assertions.assertTrue((boolean)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new java.util.UUID[]{objectId3, objectId4}))).contains((Object)tierSegment.metadata().objectId()));
        this.time().sleep(3600001L);
        int newStateMetadataCount = 0;
        Set newStateObjectIds = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new java.util.UUID[]{objectId1, objectId2}));
        java.util.Iterator newStateIterator = newState.segments();
        while (newStateIterator.hasNext()) {
            TierLogSegment tierSegment2 = (TierLogSegment)newStateIterator.next();
            Assertions.assertTrue((boolean)newStateObjectIds.contains((Object)tierSegment2.metadata().objectId()));
            newStateObjectIds = (Set)newStateObjectIds.$minus((Object)tierSegment2.metadata().objectId());
            ++newStateMetadataCount;
        }
        Assertions.assertEquals((int)2, (int)newStateMetadataCount);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToBoolean((boolean)newStateObjectIds.isEmpty()));
        java.util.UUID objectId5 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate5 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId5, 40L, 50L, 100L, 100, false, false, false, newState.lastLocalMaterializedSrcOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete5 = new TierSegmentUploadComplete(this.tpid(), 0, objectId5, newState.lastLocalMaterializedSrcOffsetAndEpoch());
        new .colon.colon((Object)uploadInitiate5, (List)new .colon.colon((Object)uploadComplete5, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)event -> {
            FileTierPartitionStateTest.$anonfun$testStateRestoreDelayedCloseOnOldState$5(newState, event);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)newState.flush());
    }

    @Test
    public void testIdempotencySimultaneousDelete() {
        TierTopicInitLeader initLeader = new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0);
        java.util.UUID objectId1 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate1 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, 0L, 10L, 100L, 100, false, false, false, new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(1))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete1 = new TierSegmentUploadComplete(this.tpid(), 0, objectId1, new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        TierSegmentDeleteInitiate deleteInitiate1 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId1, new OffsetAndEpoch(2L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        TierSegmentDeleteComplete deleteComplete1 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId1, new OffsetAndEpoch(2L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        java.util.UUID objectId2 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId2, 10L, 20L, 100L, 100, false, false, false, new OffsetAndEpoch(4L, Optional.of(Predef$.MODULE$.int2Integer(1))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete2 = new TierSegmentUploadComplete(this.tpid(), 0, objectId2, new OffsetAndEpoch(4L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        TierSegmentDeleteInitiate deleteInitiate2 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId2, new OffsetAndEpoch(6L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        TierSegmentDeleteComplete deleteComplete2 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId2, new OffsetAndEpoch(6L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        this.testDuplicateAppend((AbstractTierMetadata)initLeader, (Seq<AbstractTierMetadata>)Nil$.MODULE$, TierPartitionState.AppendResult.ACCEPTED);
        ListBuffer currentTransitions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractTierSegmentMetadata[]{uploadInitiate1, uploadComplete1, uploadInitiate2, uploadComplete2, deleteInitiate1, deleteInitiate2, deleteComplete1, deleteComplete2}))).foreach((Function1 & Serializable & scala.Serializable)transition -> {
            this.testDuplicateAppend((AbstractTierMetadata)transition, (Seq<AbstractTierMetadata>)currentTransitions, TierPartitionState.AppendResult.ACCEPTED);
            return currentTransitions.$plus$eq(transition);
        });
    }

    @Test
    public void testIdempotentencyFencing() {
        TierTopicInitLeader initLeader1 = new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0);
        java.util.UUID objectId1 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate1 = new TierSegmentUploadInitiate(this.tpid(), 0, objectId1, 0L, 10L, 100L, 100, false, false, false, new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(1))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete1 = new TierSegmentUploadComplete(this.tpid(), 0, objectId1, new OffsetAndEpoch(0L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        TierSegmentDeleteInitiate deleteInitiate1 = new TierSegmentDeleteInitiate(this.tpid(), 0, objectId1, new OffsetAndEpoch(2L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        TierSegmentDeleteComplete deleteComplete1 = new TierSegmentDeleteComplete(this.tpid(), 0, objectId1, new OffsetAndEpoch(2L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        TierTopicInitLeader initLeader2 = new TierTopicInitLeader(this.tpid(), 1, java.util.UUID.randomUUID(), 0);
        java.util.UUID fencedUploadId = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate fencedUploadInitiate = new TierSegmentUploadInitiate(this.tpid(), 0, fencedUploadId, 10L, 20L, 100L, 100, false, false, false, new OffsetAndEpoch(5L, Optional.of(Predef$.MODULE$.int2Integer(1))), TierObjectStore.OpaqueData.ZEROED);
        java.util.UUID objectId2 = java.util.UUID.randomUUID();
        TierSegmentUploadInitiate uploadInitiate2 = new TierSegmentUploadInitiate(this.tpid(), 1, objectId2, 10L, 20L, 100L, 100, false, false, false, new OffsetAndEpoch(6L, Optional.of(Predef$.MODULE$.int2Integer(1))), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete2 = new TierSegmentUploadComplete(this.tpid(), 1, objectId2, new OffsetAndEpoch(6L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        TierSegmentDeleteInitiate deleteInitiate2 = new TierSegmentDeleteInitiate(this.tpid(), 1, objectId2, new OffsetAndEpoch(8L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        TierSegmentDeleteComplete deleteComplete2 = new TierSegmentDeleteComplete(this.tpid(), 1, objectId2, new OffsetAndEpoch(8L, Optional.of(Predef$.MODULE$.int2Integer(1))));
        this.testDuplicateAppend((AbstractTierMetadata)initLeader1, (Seq<AbstractTierMetadata>)Nil$.MODULE$, TierPartitionState.AppendResult.ACCEPTED);
        ListBuffer currentTransitions = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        new .colon.colon((Object)uploadInitiate1, (List)new .colon.colon((Object)uploadComplete1, (List)new .colon.colon((Object)deleteInitiate1, (List)new .colon.colon((Object)deleteComplete1, (List)new .colon.colon((Object)initLeader2, (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)transition -> {
            this.testDuplicateAppend((AbstractTierMetadata)transition, (Seq<AbstractTierMetadata>)currentTransitions, TierPartitionState.AppendResult.ACCEPTED);
            return currentTransitions.$plus$eq(transition);
        });
        this.testDuplicateAppend((AbstractTierMetadata)fencedUploadInitiate, (Seq<AbstractTierMetadata>)currentTransitions, TierPartitionState.AppendResult.FENCED);
        currentTransitions.$plus$eq((Object)fencedUploadInitiate);
        new .colon.colon((Object)uploadInitiate2, (List)new .colon.colon((Object)uploadComplete2, (List)new .colon.colon((Object)deleteInitiate2, (List)new .colon.colon((Object)deleteComplete2, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)transition -> {
            this.testDuplicateAppend((AbstractTierMetadata)transition, (Seq<AbstractTierMetadata>)currentTransitions, TierPartitionState.AppendResult.ACCEPTED);
            return currentTransitions.$plus$eq(transition);
        });
    }

    @Test
    public void testMaterializationInitializationTracker() {
        VolatileIntRef test = VolatileIntRef.create((int)0);
        int epoch = 0;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        this.state().trackMetadataInitialization(epoch).thenAccept(success -> {
            test$1.elem = 1;
        });
        Assertions.assertEquals((int)test.elem, (int)1);
        this.state().trackMetadataInitialization(epoch + 2).thenAccept(success -> {
            test$1.elem = 5;
        });
        Assertions.assertEquals((int)test.elem, (int)1);
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch + 1, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((int)test.elem, (int)1);
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch + 2, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((int)test.elem, (int)5);
        this.state().trackMetadataInitialization(epoch + 3).thenAccept(success -> {
            test$1.elem = 6;
        });
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> this.state().trackMetadataInitialization(epoch + 4).thenAccept(success -> {
            test$1.elem = 5;
        }), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("FileTierPartitionStateTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2210));
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch + 3, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((int)test.elem, (int)6);
        this.state().trackMetadataInitialization(epoch + 4).whenComplete((success, ex) -> {
            if (Predef$.MODULE$.Boolean2boolean(success) && ex == null) {
                test$1.elem = 7;
                return;
            }
            test$1.elem = -1;
        });
        this.state().close();
        Assertions.assertEquals((int)test.elem, (int)-1);
    }

    @Test
    public void testMaterializationListenerTargetOffsetCompletion() {
        int epoch = 3;
        TreeSet<Long> baseOffsets = new TreeSet<Long>();
        int numOffsetsInSegment = 49;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        IntRef baseOffset = IntRef.create((int)0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            int endOffset = baseOffset$1.elem + numOffsetsInSegment;
            this.uploadInitateAndComplete(epoch, java.util.UUID.randomUUID(), baseOffset$1.elem, endOffset, 100);
            baseOffsets.add(BoxesRunTime.boxToLong((long)baseOffset$1.elem));
            baseOffset$1.elem = endOffset + 1;
        });
        java.util.UUID lastObjectId = java.util.UUID.randomUUID();
        OffsetAndEpoch lastObjectStateOffset = this.currentStateOffset();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, lastObjectId, (long)baseOffset.elem, (long)(baseOffset.elem + 49), 100L, 100, false, false, false, lastObjectStateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)(BoxesRunTime.unboxToLong(baseOffsets.last()) + (long)numOffsetsInSegment), (long)this.state().endOffset());
        Assertions.assertEquals((long)-1L, (long)this.state().committedEndOffset());
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)baseOffsets.floor(BoxesRunTime.boxToLong((long)49L))), (long)((TierLogSegment)this.state().materializeUptoOffset((long)49).get(0L, TimeUnit.MILLISECONDS)).baseOffset());
        Assertions.assertEquals((long)(BoxesRunTime.unboxToLong(baseOffsets.last()) + (long)numOffsetsInSegment), (long)this.state().committedEndOffset());
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)baseOffsets.floor(BoxesRunTime.boxToLong((long)50L))), (long)((TierLogSegment)this.state().materializeUptoOffset((long)50).get(0L, TimeUnit.MILLISECONDS)).baseOffset());
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)baseOffsets.floor(BoxesRunTime.boxToLong((long)155L))), (long)((TierLogSegment)this.state().materializeUptoOffset((long)155).get(0L, TimeUnit.MILLISECONDS)).baseOffset());
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)baseOffsets.floor(BoxesRunTime.boxToLong((long)199L))), (long)((TierLogSegment)this.state().materializeUptoOffset((long)199).get(0L, TimeUnit.MILLISECONDS)).baseOffset());
        Assertions.assertEquals((long)0L, (long)this.state().materializationLag());
        CompletableFuture promise = this.state().materializeUptoOffset((long)200);
        Assertions.assertFalse((boolean)promise.isDone());
        Assertions.assertEquals((long)1L, (long)this.state().materializationLag());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, lastObjectId, lastObjectStateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)promise.isDone());
        Assertions.assertEquals((long)200L, (long)((TierLogSegment)promise.get()).baseOffset());
        Assertions.assertEquals((Object)lastObjectId, (Object)((TierLogSegment)promise.get()).objectId());
        Assertions.assertEquals((long)(200 + numOffsetsInSegment), (long)this.state().committedEndOffset());
        Assertions.assertEquals((long)0L, (long)this.state().materializationLag());
        Assertions.assertFalse((boolean)this.state().materializeUptoOffset((long)500).isDone());
        Assertions.assertEquals((long)251L, (long)this.state().materializationLag());
    }

    @Test
    public void testMaterializationListenerObjectIdCompletion() {
        int epoch = 3;
        TreeMap baseOffsetToObjectIds = new TreeMap();
        int numOffsetsInSegment = 49;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        IntRef baseOffset = IntRef.create((int)0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            int endOffset = baseOffset$2.elem + numOffsetsInSegment;
            java.util.UUID objectId = java.util.UUID.randomUUID();
            this.uploadInitateAndComplete(epoch, objectId, baseOffset$2.elem, endOffset, 100);
            baseOffsetToObjectIds.put(BoxesRunTime.boxToLong((long)baseOffset$2.elem), objectId);
            baseOffset$2.elem = endOffset + 1;
        });
        java.util.UUID lastObjectId = java.util.UUID.randomUUID();
        OffsetAndEpoch lastObjectStateOffset = this.currentStateOffset();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, lastObjectId, (long)baseOffset.elem, (long)(baseOffset.elem + 49), 100L, 100, false, false, false, lastObjectStateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)(BoxesRunTime.unboxToLong(baseOffsetToObjectIds.lastKey()) + (long)numOffsetsInSegment), (long)this.state().endOffset());
        Assertions.assertEquals((long)-1L, (long)this.state().committedEndOffset());
        this.verifyListener$1(49L, baseOffsetToObjectIds);
        Assertions.assertEquals((long)(BoxesRunTime.unboxToLong(baseOffsetToObjectIds.lastKey()) + (long)numOffsetsInSegment), (long)this.state().committedEndOffset());
        this.verifyListener$1(50L, baseOffsetToObjectIds);
        this.verifyListener$1(155L, baseOffsetToObjectIds);
        this.verifyListener$1(199L, baseOffsetToObjectIds);
        Assertions.assertEquals((long)199L, (long)this.state().committedEndOffset());
        Assertions.assertEquals((long)0L, (long)this.state().materializationLag());
        java.util.UUID newObjectId = java.util.UUID.randomUUID();
        CompletableFuture promise = this.state().materializeUptoObjectIdAndRestoreEpoch((long)250, newObjectId, -1);
        Assertions.assertFalse((boolean)promise.isDone());
        Assertions.assertEquals((long)51L, (long)this.state().materializationLag());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, lastObjectId, lastObjectStateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertFalse((boolean)promise.isDone());
        baseOffset.elem = baseOffset.elem + numOffsetsInSegment + 1;
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, newObjectId, (long)baseOffset.elem, (long)(baseOffset.elem + 49), 100L, 100, false, false, false, this.currentStateOffset(), TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)249L, (long)this.state().endOffset());
        Assertions.assertFalse((boolean)promise.isDone());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, newObjectId, lastObjectStateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((long)299L, (long)this.state().endOffset());
        Assertions.assertEquals((Object)newObjectId, (Object)((TierLogSegment)promise.get()).objectId());
        Assertions.assertEquals((long)250L, (long)((TierLogSegment)promise.get()).baseOffset());
        Assertions.assertEquals((long)0L, (long)this.state().materializationLag());
        Assertions.assertFalse((boolean)this.state().materializeUptoObjectIdAndRestoreEpoch((long)500, java.util.UUID.randomUUID(), -1).isDone());
        Assertions.assertEquals((long)201L, (long)this.state().materializationLag());
    }

    @Test
    public void testMaterializationListenerObjectIdDeletedSegment() {
        int epoch = 1;
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        java.util.UUID targetObjectId = java.util.UUID.randomUUID();
        this.uploadInitateAndComplete(epoch, targetObjectId, 0L, 49L, 100);
        this.deleteInitiateAndComplete(epoch, targetObjectId);
        CompletableFuture promise = this.state().materializeUptoObjectIdAndRestoreEpoch(50L, targetObjectId, -1);
        Assertions.assertFalse((boolean)promise.isDone());
        this.uploadInitateAndComplete(epoch, java.util.UUID.randomUUID(), 50L, 99L, 100);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> (TierLogSegment)promise.get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("FileTierPartitionStateTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2377));
        CompletableFuture promise2 = this.state().materializeUptoObjectIdAndRestoreEpoch(50L, targetObjectId, -1);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> (TierLogSegment)promise2.get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("FileTierPartitionStateTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2384));
    }

    @Test
    public void testPreviousMaterializationTargetOffestListenerCancelled() {
        CompletableFuture promise_1 = this.state().materializeUptoOffset(200L);
        Assertions.assertFalse((boolean)promise_1.isDone());
        Assertions.assertFalse((boolean)this.state().materializeUptoOffset(400L).isDone());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> {
            try {
                return promise_1.get(0L, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("FileTierPartitionStateTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2397));
    }

    @Test
    public void testPreviousMaterializationTargetObjectIdListenerCancelled() {
        CompletableFuture promise_1 = this.state().materializeUptoObjectIdAndRestoreEpoch(200L, java.util.UUID.randomUUID(), -1);
        Assertions.assertFalse((boolean)promise_1.isDone());
        Assertions.assertFalse((boolean)this.state().materializeUptoObjectIdAndRestoreEpoch(200L, java.util.UUID.randomUUID(), -1).isDone());
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> {
            try {
                return promise_1.get(0L, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
        }, ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("FileTierPartitionStateTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2414));
    }

    @Test
    public void testMaterializationListenerAfterClose() {
        this.state().close();
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> (TierLogSegment)this.state().materializeUptoOffset(200L).get(0L, TimeUnit.MILLISECONDS), ClassTag$.MODULE$.apply(Exception.class), new Position("FileTierPartitionStateTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2426));
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> (TierLogSegment)this.state().materializeUptoObjectIdAndRestoreEpoch(200L, java.util.UUID.nameUUIDFromBytes((byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte())), 10).get(0L, TimeUnit.MILLISECONDS), ClassTag$.MODULE$.apply(Exception.class), new Position("FileTierPartitionStateTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2429));
    }

    @Test
    public void testEnableTierStorageWithInvalidFileThrowsKafkaStorageException() {
        File dir2 = TestUtils$.MODULE$.randomPartitionLogDir(this.parentDir());
        TopicPartition tp2 = Log$.MODULE$.parseTopicPartitionName(dir2);
        TopicIdPartition topicIdPartition = new TopicIdPartition(tp2.topic(), java.util.UUID.randomUUID(), tp2.partition());
        FileTierPartitionState fp = new FileTierPartitionState(dir2, this.logDirFailureChannel(), tp2, false, (Scheduler)this.time().scheduler(), this.checksumEnabled());
        CheckedFileIO channel = CheckedFileIO.openOrCreate((Path)FileTierPartitionState.flushedFilePath((String)fp.basePath(), (Algorithm)this.checksumAlgorithm()), (Algorithm)this.checksumAlgorithm(), (short)this.superBlockLength(), (OpenOption[])new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE});
        Header header = new Header(topicIdPartition.topicId(), fp.version(), -1, TierPartitionStatus.INIT, -1L, -1L, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY, OffsetAndEpoch.EMPTY);
        short sizePrefix = (short)header.payloadBuffer().remaining();
        ByteBuffer sizeBuf = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
        sizeBuf.putShort(sizePrefix);
        sizeBuf.flip();
        channel.write(sizeBuf, 0L);
        channel.write(header.payloadBuffer(), 2L);
        ByteBuffer buf = ByteBuffer.allocate(9).order(ByteOrder.LITTLE_ENDIAN);
        buf.putShort((short)80);
        buf.putInt(1);
        buf.flip();
        channel.write(buf, channel.size());
        channel.close();
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> fp.setTieringEnabled(), ClassTag$.MODULE$.apply(KafkaStorageException.class), new Position("FileTierPartitionStateTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2464));
        Assertions.assertEquals((Object)fp.dir().getParent(), (Object)this.logDirFailureChannel().takeNextOfflineLogDir());
        Assertions.assertTrue((boolean)Files.exists(FileTierPartitionState.errorFilePath((String)fp.basePath(), (Algorithm)this.checksumAlgorithm()), new LinkOption[0]));
        Assertions.assertFalse((boolean)fp.status().isOpenForWrite());
        fp.close();
        dir2.delete();
    }

    @Test
    public void testSegmentMetadataDeletedPrecedingFunctionality() {
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        java.util.UUID objectId1 = java.util.UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 0L, 50L, 10);
        java.util.UUID objectId2 = java.util.UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId2, 25L, 150L, 20);
        Assertions.assertTrue((boolean)this.state().flush());
        java.util.UUID objectId3 = java.util.UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId3, 70L, 250L, 30);
        Assertions.assertTrue((boolean)this.state().flush());
        this.deleteInitiateAndComplete(0, objectId1);
        this.deleteInitiateAndComplete(0, objectId2);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((Object)((SegmentState)this.state().previousMetadataBeforeOffset(151L).get()).objectId(), (Object)objectId2);
        Seq metadataList = ((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(this.state().segmentInMemoryMetadataRange(0L, 250L)).asScala()).toSeq();
        Assertions.assertEquals((int)2, (int)metadataList.size());
        SegmentState deleted = (SegmentState)metadataList.head();
        Assertions.assertEquals((long)51L, (long)deleted.baseOffset());
        Assertions.assertEquals((int)20, (int)deleted.size());
        Assertions.assertEquals((long)100L, (long)deleted.maxTimestamp());
        Assertions.assertEquals((Object)TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE, (Object)deleted.state());
        SegmentState remaining = (SegmentState)metadataList.apply(1);
        Assertions.assertEquals((long)151L, (long)remaining.baseOffset());
        Assertions.assertEquals((int)30, (int)remaining.size());
        Assertions.assertEquals((long)100L, (long)remaining.maxTimestamp());
        Assertions.assertEquals((Object)TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, (Object)remaining.state());
        Optional immediatePriorDeleted = this.state().previousMetadataBeforeOffset(151L);
        Assertions.assertTrue((boolean)immediatePriorDeleted.isPresent());
        Assertions.assertEquals((long)51L, (long)((SegmentState)immediatePriorDeleted.get()).baseOffset());
        Assertions.assertEquals((int)1, (int)this.state().segmentInMemoryMetadataRange(151L, 250L).size(), (String)"segmentInMemoryRange should have excluded deleted segment due to start of range");
        Assertions.assertEquals((int)2, (int)this.state().segmentInMemoryMetadataRange(150L, 250L).size(), (String)"segmentInMemoryRange should have included deleted segment due to start of range");
        this.state().close();
        FileTierPartitionState reopenedState = (FileTierPartitionState)this.factory().initState(this.dir(), this.tp(), this.logConfig(), this.logDirFailureChannel(), (Scheduler)this.time().scheduler());
        Seq metadataList2 = ((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(reopenedState.segmentInMemoryMetadataRange(0L, 250L)).asScala()).toSeq();
        Assertions.assertEquals((int)2, (int)metadataList2.size());
        SegmentState deleted2 = (SegmentState)metadataList2.head();
        Assertions.assertEquals((long)25L, (long)deleted2.baseOffset());
        Assertions.assertEquals((int)20, (int)deleted2.size());
        Assertions.assertEquals((long)100L, (long)deleted2.maxTimestamp());
        Assertions.assertEquals((Object)TierObjectMetadata.State.SEGMENT_DELETE_COMPLETE, (Object)deleted2.state());
        SegmentState remaining2 = (SegmentState)metadataList.apply(1);
        Assertions.assertEquals((long)151L, (long)remaining2.baseOffset());
        Assertions.assertEquals((int)30, (int)remaining2.size());
        Assertions.assertEquals((long)100L, (long)remaining2.maxTimestamp());
        Assertions.assertEquals((Object)TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, (Object)remaining2.state());
        Optional immediatePriorDeleted2 = reopenedState.previousMetadataBeforeOffset(151L);
        Assertions.assertTrue((boolean)immediatePriorDeleted2.isPresent());
        Assertions.assertEquals((long)25L, (long)((SegmentState)immediatePriorDeleted2.get()).baseOffset());
        OffsetAndEpoch stateOffset = reopenedState.lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)reopenedState.append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), 0, objectId3, stateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)reopenedState.append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), 0, objectId3, stateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertTrue((boolean)reopenedState.flush());
        Assertions.assertEquals((int)1, (int)reopenedState.segmentInMemoryMetadataRange(0L, 250L).size());
        Optional immediatePriorDeleted3 = reopenedState.previousMetadataBeforeOffset(251L);
        Assertions.assertTrue((boolean)immediatePriorDeleted3.isPresent());
        Assertions.assertEquals((long)70L, (long)((SegmentState)immediatePriorDeleted3.get()).baseOffset());
        reopenedState.close();
    }

    @Test
    public void testPreviousMetadataBeforeOffset() {
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        java.util.UUID objectId1 = java.util.UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 1L, 50L, 10);
        java.util.UUID objectId2 = java.util.UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId2, 25L, 150L, 20);
        Assertions.assertTrue((boolean)this.state().flush());
        java.util.UUID objectId3 = java.util.UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId3, 70L, 250L, 30);
        Assertions.assertTrue((boolean)this.state().flush());
        this.deleteInitiateAndComplete(0, objectId1);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals(Optional.empty(), (Object)this.state().previousMetadataBeforeOffset(48L));
        Assertions.assertEquals((int)10, (int)((SegmentState)this.state().previousMetadataBeforeOffset(55L).get()).size());
        Assertions.assertEquals((int)20, (int)((SegmentState)this.state().previousMetadataBeforeOffset(151L).get()).size());
        Assertions.assertEquals((int)10, (int)((SegmentState)this.state().previousMetadataBeforeOffset(150L).get()).size());
        Assertions.assertEquals((int)30, (int)((SegmentState)this.state().previousMetadataBeforeOffset(2000L).get()).size());
    }

    @Test
    public void testFollowerRestorePoint() {
        this.state().append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        java.util.UUID objectId1 = java.util.UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId1, 1L, 50L, 10);
        java.util.UUID objectId2 = java.util.UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId2, 25L, 150L, 20);
        Assertions.assertTrue((boolean)this.state().flush());
        java.util.UUID objectId3 = java.util.UUID.randomUUID();
        this.uploadInitateAndComplete(0, objectId3, 70L, 250L, 30);
        Assertions.assertTrue((boolean)this.state().flush());
        this.deleteInitiateAndComplete(0, objectId1);
        Assertions.assertTrue((boolean)this.state().flush());
        Assertions.assertEquals((Object)objectId1, this.state().followerRestorePoint(48L).targetObjectId().get());
        Assertions.assertEquals((Object)objectId2, this.state().followerRestorePoint(150L).targetObjectId().get());
        Assertions.assertEquals((Object)objectId2, this.state().followerRestorePoint(151L).targetObjectId().get());
        Assertions.assertEquals((Object)objectId3, this.state().followerRestorePoint(240L).targetObjectId().get());
        Assertions.assertEquals((Object)objectId3, this.state().followerRestorePoint(2000L).targetObjectId().get());
    }

    @Test
    public void testFencedUploadFollowedByOpaqueData() {
        TierTopicInitLeader initLeader = new TierTopicInitLeader(this.tpid(), 0, java.util.UUID.randomUUID(), 0);
        TierSegmentUploadInitiate uploadInit1 = new TierSegmentUploadInitiate(this.tpid(), 0, java.util.UUID.randomUUID(), 1213L, 2912L, 8493L, 3021, true, false, true, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch(), TierObjectStore.OpaqueData.ZEROED);
        TierSegmentUploadComplete uploadComplete1 = new TierSegmentUploadComplete(this.tpid(), 0, uploadInit1.objectId(), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        TierSegmentUploadInitiate uploadInit2 = new TierSegmentUploadInitiate(this.tpid(), 0, java.util.UUID.randomUUID(), 5969L, 15088L, 4525L, 3974, false, false, true, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch(), TierObjectStore.OpaqueData.fromLongArray((long[])new long[]{1L, 2L, 3L, 4L}));
        TierSegmentUploadComplete uploadComplete2 = new TierSegmentUploadComplete(this.tpid(), 0, uploadInit2.objectId(), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        .colon.colon metadata = new .colon.colon((Object)initLeader, (List)new .colon.colon((Object)uploadInit1, (List)new .colon.colon((Object)uploadComplete1, (List)new .colon.colon((Object)uploadInit2, (List)new .colon.colon((Object)uploadComplete2, (List)Nil$.MODULE$)))));
        IntRef offset = IntRef.create((int)0);
        metadata.foreach((Function1 & Serializable & scala.Serializable)m -> {
            FileTierPartitionStateTest.$anonfun$testFencedUploadFollowedByOpaqueData$1(this, offset, m);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)this.state().numSegments(), (int)2);
        this.state().flush();
        this.state().close();
        FileTierPartitionState reopened = new FileTierPartitionState(this.dir(), null, this.tp(), true, null, this.checksumEnabled());
        Assertions.assertFalse((boolean)reopened.dirty());
        Assertions.assertEquals((int)reopened.numSegments(), (int)2);
    }

    private OffsetAndEpoch currentStateOffset() {
        return this.state().lastLocalMaterializedSrcOffsetAndEpoch();
    }

    public void uploadInitateAndComplete(int epoch, java.util.UUID objectId, long startOffset, long endOffset, int size) {
        OffsetAndEpoch stateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadInitiate(this.tpid(), epoch, objectId, startOffset, endOffset, 100L, size, false, false, false, stateOffset, TierObjectStore.OpaqueData.ZEROED), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentUploadComplete(this.tpid(), epoch, objectId, stateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    private void deleteInitiateAndComplete(int epoch, java.util.UUID objectId) {
        OffsetAndEpoch stateOffset = this.state().lastLocalMaterializedSrcOffsetAndEpoch();
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteInitiate(this.tpid(), epoch, objectId, stateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)this.state().append((AbstractTierMetadata)new TierSegmentDeleteComplete(this.tpid(), epoch, objectId, stateOffset), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    private void testDuplicateAppend(AbstractTierMetadata metadata, Seq<AbstractTierMetadata> previousTransitions, TierPartitionState.AppendResult expected) {
        this.testDuplicateAppend((TierPartitionState)this.state(), metadata, previousTransitions, expected);
    }

    private void testDuplicateAppend(TierPartitionState newState, AbstractTierMetadata metadata2, Seq<AbstractTierMetadata> previousTransitions, TierPartitionState.AppendResult expected) {
        OffsetAndEpoch nextOffsetAndEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        Assertions.assertEquals((Object)expected, (Object)newState.append(metadata2, nextOffsetAndEpoch), (String)metadata2.toString());
        previousTransitions.foreach((Function1 & Serializable & scala.Serializable)metadata -> {
            FileTierPartitionStateTest.$anonfun$testDuplicateAppend$1(newState, metadata);
            return BoxedUnit.UNIT;
        });
        java.util.Iterator segments = newState.segments();
        Collection fencedSegments = newState.fencedSegments();
        long size = newState.totalSize();
        Assertions.assertEquals((Object)expected, (Object)newState.append(metadata2, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
        Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(segments).asScala()).toList(), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaIteratorConverter(newState.segments()).asScala()).toList());
        Assertions.assertEquals((Object)fencedSegments, (Object)newState.fencedSegments());
        Assertions.assertEquals((long)size, (long)newState.totalSize());
    }

    @Test
    public void testIteratorDifferentMetadataSizes() {
        FlatBufferBuilder builder = new FlatBufferBuilder(96).forceDefaults(false);
        java.util.UUID origObjectId = java.util.UUID.randomUUID();
        TierPartitionStateEntry.startTierPartitionStateEntry((FlatBufferBuilder)builder);
        TierPartitionStateEntry.addVersion((FlatBufferBuilder)builder, (byte)1);
        TierPartitionStateEntry.addTierEpoch((FlatBufferBuilder)builder, (int)0);
        int objectIdOffset = UUID.createUUID((FlatBufferBuilder)builder, (long)origObjectId.getMostSignificantBits(), (long)origObjectId.getLeastSignificantBits());
        TierPartitionStateEntry.addObjectId((FlatBufferBuilder)builder, (int)objectIdOffset);
        TierPartitionStateEntry.addBaseOffset((FlatBufferBuilder)builder, (long)0L);
        TierPartitionStateEntry.addEndOffsetDelta((FlatBufferBuilder)builder, (int)100);
        TierPartitionStateEntry.addMaxTimestamp((FlatBufferBuilder)builder, (long)201L);
        TierPartitionStateEntry.addSize((FlatBufferBuilder)builder, (int)501);
        TierPartitionStateEntry.addState((FlatBufferBuilder)builder, (byte)TierObjectMetadata.State.SEGMENT_UPLOAD_INITIATE.id());
        TierPartitionStateEntry.addHasEpochState((FlatBufferBuilder)builder, (boolean)true);
        TierPartitionStateEntry.addHasAbortedTxns((FlatBufferBuilder)builder, (boolean)false);
        int entryId = TierPartitionStateEntry.endTierPartitionStateEntry((FlatBufferBuilder)builder);
        builder.finish(entryId);
        TierPartitionStateEntry oldMetadata = TierPartitionStateEntry.getRootAsTierPartitionStateEntry((ByteBuffer)builder.dataBuffer());
        short oldMetadataSize = (short)oldMetadata.getByteBuffer().remaining();
        TierObjectMetadata wrappedOldMetadata = new TierObjectMetadata(this.tpid(), oldMetadata);
        java.util.UUID newMetadataObjectId = java.util.UUID.randomUUID();
        TierObjectMetadata newMetadataType = new TierObjectMetadata(this.tpid(), 1, newMetadataObjectId, 100L, 200L, 300L, 400, TierObjectMetadata.State.SEGMENT_UPLOAD_COMPLETE, false, true, false, TierObjectStore.OpaqueData.ZEROED);
        ByteBuffer lengthBuffer = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
        Path path = Paths.get(new StringBuilder(15).append(this.parentDir().toString()).append("/test.tierstate").append(this.checksumAlgorithm().suffix).toString(), new String[0]);
        CheckedFileIO.create((Path)path, (Algorithm)this.checksumAlgorithm(), (short)this.superBlockLength());
        try (CheckedFileIO channel = CheckedFileIO.open((Path)path, (OpenOption[])new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE});){
            lengthBuffer.putShort(oldMetadataSize);
            lengthBuffer.flip();
            channel.write(lengthBuffer);
            channel.write(oldMetadata.getByteBuffer().duplicate());
            lengthBuffer.clear();
            lengthBuffer.putShort((short)newMetadataType.payloadSize());
            lengthBuffer.flip();
            channel.write(lengthBuffer);
            channel.write(newMetadataType.payloadBuffer().duplicate());
            channel.flush();
            FileTierPartitionIterator iterator = new FileTierPartitionIterator(this.tpid(), channel, 0L);
            Assertions.assertTrue((boolean)iterator.hasNext());
            TierObjectMetadata metadata1 = (TierObjectMetadata)iterator.next();
            Assertions.assertEquals((long)oldMetadata.baseOffset(), (long)metadata1.baseOffset());
            Assertions.assertEquals((int)oldMetadata.size(), (int)metadata1.size());
            Assertions.assertEquals((int)oldMetadataSize, (int)metadata1.payloadSize());
            Assertions.assertEquals((Object)wrappedOldMetadata, (Object)metadata1);
            Assertions.assertTrue((boolean)iterator.hasNext());
            TierObjectMetadata metadata2 = (TierObjectMetadata)iterator.next();
            Assertions.assertEquals((long)newMetadataType.baseOffset(), (long)metadata2.baseOffset());
            Assertions.assertEquals((int)newMetadataType.size(), (int)metadata2.size());
            Assertions.assertEquals((int)newMetadataType.payloadSize(), (int)metadata2.payloadSize());
            Assertions.assertEquals((Object)newMetadataType, (Object)metadata2);
        }
    }

    private void validateConsoleDumpedEntries(File partitionDir, int numSegments) {
        PrintStream sysOut = System.out;
        ByteArrayOutputStream contents = new ByteArrayOutputStream();
        System.setOut(new PrintStream(contents));
        try {
            String[] args = new String[]{partitionDir.getAbsolutePath()};
            DumpTierPartitionState.main((String[])args);
        }
        finally {
            System.setOut(sysOut);
        }
        String[] lines = contents.toString().split("\n");
        int headerLines = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).count((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.startsWith("Header")));
        Assertions.assertEquals((int)1, (int)headerLines);
        int numLines = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).count((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.startsWith("TierObjectMetadata")));
        Assertions.assertEquals((int)numSegments, (int)numLines);
    }

    private void checkInvalidFileKafkaStorageExceptionOnInit(File baseDir, TopicPartition tp, String path) {
        CheckedFileIO channel = CheckedFileIO.open((Path)Paths.get(path, new String[0]), (OpenOption[])new OpenOption[]{StandardOpenOption.READ, StandardOpenOption.WRITE});
        ByteBuffer buf = ByteBuffer.allocate(9).order(ByteOrder.LITTLE_ENDIAN);
        buf.putShort((short)80);
        buf.putInt(1);
        buf.flip();
        channel.position(channel.size());
        channel.write(buf);
        channel.close();
        LogDirFailureChannel logDirFailureChannelLocal = new LogDirFailureChannel(5);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> new FileTierPartitionState(baseDir, logDirFailureChannelLocal, tp, true, (Scheduler)this.time().scheduler(), this.checksumEnabled()), ClassTag$.MODULE$.apply(KafkaStorageException.class), new Position("FileTierPartitionStateTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2803));
        Assertions.assertEquals((Object)baseDir.getParent(), (Object)logDirFailureChannelLocal.takeNextOfflineLogDir());
    }

    public static final /* synthetic */ String $anonfun$setup$2(FileTierPartitionStateTest $this, TierPartitionState.RecoveryOperation op$1) {
        return new StringBuilder(26).append("Received RecoveryOp: ").append(op$1).append(" for ").append($this.state().topicIdPartition().get()).toString();
    }

    public static final /* synthetic */ java.util.UUID $anonfun$testOngoingUploadFencedAfterLeaderChange$1(int _) {
        return java.util.UUID.randomUUID();
    }

    public static final /* synthetic */ ListBuffer $anonfun$testDeleteSegments$1(FileTierPartitionStateTest $this, int epoch$7, IntRef offset$5, ListBuffer objectIds$2, int i) {
        java.util.UUID objectId = java.util.UUID.randomUUID();
        $this.uploadInitateAndComplete(epoch$7, objectId, offset$5.elem, offset$5.elem, i);
        ++offset$5.elem;
        return objectIds$2.$plus$eq((Object)objectId);
    }

    private final void maybeIncrementEpochAndValidateTierState$1(FileTierPartitionState state, boolean isLeader, long expectedEndOffset, long expectedSize, IntRef epoch$9) {
        Assertions.assertEquals((long)expectedEndOffset, (long)state.endOffset(), (String)"FileTierPartitionState endOffset at run time");
        Assertions.assertEquals((long)expectedSize, (long)state.totalSize(), (String)"FileTierPartitionState totalSize at run time");
        if (isLeader) {
            ++epoch$9.elem;
            state.append((AbstractTierMetadata)new TierTopicInitLeader(this.tpid(), epoch$9.elem, java.util.UUID.randomUUID(), 0), TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        }
        state.close();
        Assertions.assertFalse((boolean)reopenedState.dirty());
        try (FileTierPartitionState reopenedState = new FileTierPartitionState(this.dir(), this.logDirFailureChannel(), this.tp(), true, (Scheduler)this.time().scheduler(), this.checksumEnabled());){
            Assertions.assertEquals((long)expectedEndOffset, (long)reopenedState.endOffset(), (String)"FileTierPartitionState endOffset materialized value");
            Assertions.assertEquals((long)expectedSize, (long)reopenedState.totalSize(), (String)"FileTierPartitionState totalSize materialized value");
        }
    }

    public static final /* synthetic */ String $anonfun$testStateRestoreFunctionality$3(TierPartitionState.RecoveryOperation op$2, FileTierPartitionState newState$1) {
        return new StringBuilder(26).append("Received RecoveryOp: ").append(op$2).append(" for ").append(newState$1.topicIdPartition().get()).toString();
    }

    public static final /* synthetic */ void $anonfun$testStateRestoreFencingStaleMetadata$1(FileTierPartitionStateTest $this, AbstractTierMetadata transition) {
        OffsetAndEpoch nextEpoch = TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch();
        TierPartitionState.AppendResult result = $this.state().append(transition, nextEpoch);
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)result);
    }

    public static final /* synthetic */ void $anonfun$testErrorStateRestoreUploadSameSegmentSameEpoch$1(FileTierPartitionStateTest $this, AbstractTierMetadata transition) {
        TierPartitionState.AppendResult result = $this.state().append(transition, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)result);
    }

    public static final /* synthetic */ String $anonfun$testErrorStateRestoreUploadSameSegmentSameEpoch$3(TierPartitionState.RecoveryOperation op$3, FileTierPartitionState newState$2) {
        return new StringBuilder(26).append("Received RecoveryOp: ").append(op$3).append(" for ").append(newState$2.topicIdPartition().get()).toString();
    }

    public static final /* synthetic */ void $anonfun$testErrorStateRestoreUploadSameSegmentSameEpoch$4(FileTierPartitionState newState$2, AbstractTierSegmentMetadata transition) {
        TierPartitionState.AppendResult result = newState$2.append((AbstractTierMetadata)transition, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)result);
    }

    public static final /* synthetic */ void $anonfun$testFenceContinuedUploadAfterRestore$1(FileTierPartitionStateTest $this, AbstractTierMetadata transition) {
        TierPartitionState.AppendResult result = $this.state().append(transition, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)result);
    }

    public static final /* synthetic */ String $anonfun$testFenceContinuedUploadAfterRestore$3(TierPartitionState.RecoveryOperation op$4, FileTierPartitionState newState$3) {
        return new StringBuilder(26).append("Received RecoveryOp: ").append(op$4).append(" for ").append(newState$3.topicIdPartition().get()).toString();
    }

    public static final /* synthetic */ void $anonfun$testFenceContinuedUploadAfterRestore$4(FileTierPartitionState newState$3, TierSegmentUploadComplete transition) {
        TierPartitionState.AppendResult result = newState$3.append((AbstractTierMetadata)transition, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.RESTORE_FENCED, (Object)result);
    }

    public static final /* synthetic */ void $anonfun$testFenceContinuedUploadAfterRestore$5(FileTierPartitionState newState$3, AbstractTierSegmentMetadata transition) {
        TierPartitionState.AppendResult result = newState$3.append((AbstractTierMetadata)transition, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)result);
    }

    public static final /* synthetic */ void $anonfun$testStateRestoreCausingTruncateAndReapply$1(FileTierPartitionStateTest $this, AbstractTierMetadata transition) {
        TierPartitionState.AppendResult result = $this.state().append(transition, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)result);
    }

    public static final /* synthetic */ String $anonfun$testStateRestoreCausingTruncateAndReapply$3(TierPartitionState.RecoveryOperation op$5, FileTierPartitionState newState$4) {
        return new StringBuilder(26).append("Received RecoveryOp: ").append(op$5).append(" for ").append(newState$4.topicIdPartition().get()).toString();
    }

    public static final /* synthetic */ void $anonfun$testStateRestoreCausingTruncateAndReapply$4(FileTierPartitionState newState$4, AbstractTierMetadata transition) {
        TierPartitionState.AppendResult result = newState$4.append(transition, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)result);
    }

    public static final /* synthetic */ void $anonfun$testStateRestoreCausingTruncateAndReapply$5(FileTierPartitionState newState$4, AbstractTierSegmentMetadata transition) {
        TierPartitionState.AppendResult result = newState$4.append((AbstractTierMetadata)transition, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.RESTORE_FENCED, (Object)result);
    }

    public static final /* synthetic */ void $anonfun$testStateRestoreCausingTruncateAndReapply$6(FileTierPartitionState newState$4, AbstractTierSegmentMetadata transition) {
        TierPartitionState.AppendResult result = newState$4.append((AbstractTierMetadata)transition, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)result);
    }

    public static final /* synthetic */ void $anonfun$testStateRestoreClosesListenersEagerly$1(FileTierPartitionStateTest $this, AbstractTierSegmentMetadata event) {
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)$this.state().append((AbstractTierMetadata)event, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    public static final /* synthetic */ String $anonfun$testStateRestoreClosesListenersEagerly$3(TierPartitionState.RecoveryOperation op$6, FileTierPartitionState newState$5) {
        return new StringBuilder(26).append("Received RecoveryOp: ").append(op$6).append(" for ").append(newState$5.topicIdPartition().get()).toString();
    }

    public static final /* synthetic */ void $anonfun$testStateRestoreDelayedCloseOnOldState$1(FileTierPartitionStateTest $this, AbstractTierSegmentMetadata event) {
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)$this.state().append((AbstractTierMetadata)event, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    public static final /* synthetic */ String $anonfun$testStateRestoreDelayedCloseOnOldState$3(TierPartitionState.RecoveryOperation op$7, FileTierPartitionState newState$6) {
        return new StringBuilder(26).append("Received RecoveryOp: ").append(op$7).append(" for ").append(newState$6.topicIdPartition().get()).toString();
    }

    public static final /* synthetic */ void $anonfun$testStateRestoreDelayedCloseOnOldState$4(FileTierPartitionState newState$6, AbstractTierSegmentMetadata event) {
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)newState$6.append((AbstractTierMetadata)event, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    public static final /* synthetic */ void $anonfun$testStateRestoreDelayedCloseOnOldState$5(FileTierPartitionState newState$6, AbstractTierSegmentMetadata event) {
        Assertions.assertEquals((Object)TierPartitionState.AppendResult.ACCEPTED, (Object)newState$6.append((AbstractTierMetadata)event, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch()));
    }

    private final void verifyListener$1(long targetOffset, TreeMap baseOffsetToObjectIds$1) {
        Map.Entry expected = baseOffsetToObjectIds$1.floorEntry(BoxesRunTime.boxToLong((long)targetOffset));
        Assertions.assertEquals((long)BoxesRunTime.unboxToLong((Object)expected.getKey()), (long)((TierLogSegment)this.state().materializeUptoObjectIdAndRestoreEpoch(targetOffset, (java.util.UUID)expected.getValue(), -1).get(0L, TimeUnit.MILLISECONDS)).baseOffset());
    }

    public static final /* synthetic */ void $anonfun$testFencedUploadFollowedByOpaqueData$1(FileTierPartitionStateTest $this, IntRef offset$8, AbstractTierMetadata m) {
        Assertions.assertEquals((Object)$this.state().appendUnhandled(m, new OffsetAndEpoch((long)offset$8.elem, Optional.empty())), (Object)TierPartitionState.AppendResult.ACCEPTED);
        ++offset$8.elem;
    }

    public static final /* synthetic */ void $anonfun$testDuplicateAppend$1(TierPartitionState newState$7, AbstractTierMetadata metadata) {
        TierPartitionState.AppendResult result = newState$7.append(metadata, TierTestUtils$.MODULE$.nextTierTopicOffsetAndEpoch());
        Assertions.assertTrue((boolean)((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TierPartitionState.AppendResult[]{TierPartitionState.AppendResult.FENCED, TierPartitionState.AppendResult.ACCEPTED}))).apply((Object)result));
    }
}

