/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.state;

import com.google.flatbuffers.FlatBufferBuilder;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.serdes.MaterializationTrackingInfo;
import kafka.tier.serdes.TierPartitionStateHeader;
import kafka.tier.state.Header;
import kafka.tier.state.OffsetAndEpoch;
import kafka.tier.state.TierPartitionStatus;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001!2Aa\u0001\u0003\u0001\u0017!)!\u0003\u0001C\u0001'!)a\u0003\u0001C\u0001/\tQ\u0001*Z1eKJ$Vm\u001d;\u000b\u0005\u00151\u0011!B:uCR,'BA\u0004\t\u0003\u0011!\u0018.\u001a:\u000b\u0003%\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u000b\u0011\u0005U\u0001Q\"\u0001\u0003\u0002-Q,7\u000f\u001e*fC\u0012DU-\u00193feZ+'o]5p]N$\u0012\u0001\u0007\t\u0003\u001beI!A\u0007\b\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005q\u0001\"!\b\u0014\u000e\u0003yQ!a\b\u0011\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\"E\u00059!.\u001e9ji\u0016\u0014(BA\u0012%\u0003\u0015QWO\\5u\u0015\u0005)\u0013aA8sO&\u0011qE\b\u0002\u0005)\u0016\u001cH\u000f")
public class HeaderTest {
    @Test
    public void testReadHeaderVersions() {
        if (6 != 6) {
            throw new Exception("FileTierPartitionState version has been bumped.Please ensure the readability of all versions, including any new fields, and then bump testedVersion.");
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)version -> {
            UUID topicId = UUID.randomUUID();
            int epoch = 0;
            TierPartitionStatus status = TierPartitionStatus.INIT;
            int endOffset = 100;
            OffsetAndEpoch localMaterializedOffsetAndEpoch = new OffsetAndEpoch(50L, Optional.of(Predef$.MODULE$.int2Integer(5)));
            OffsetAndEpoch globalMaterializedOffset = new OffsetAndEpoch(20L, Optional.of(Predef$.MODULE$.int2Integer(2)));
            OffsetAndEpoch errorOffsetAndEpoch = new OffsetAndEpoch(30L, Optional.of(Predef$.MODULE$.int2Integer(2)));
            OffsetAndEpoch restoreOffsetAndEpoch = new OffsetAndEpoch(35L, Optional.of(Predef$.MODULE$.int2Integer(3)));
            FlatBufferBuilder builder = new FlatBufferBuilder(100).forceDefaults(true);
            int materializedInfo = MaterializationTrackingInfo.createMaterializationTrackingInfo((FlatBufferBuilder)builder, (long)globalMaterializedOffset.offset(), (long)localMaterializedOffsetAndEpoch.offset(), (int)Predef$.MODULE$.Integer2int((Integer)globalMaterializedOffset.epoch().get()), (int)Predef$.MODULE$.Integer2int((Integer)localMaterializedOffsetAndEpoch.epoch().get()));
            TierPartitionStateHeader.startTierPartitionStateHeader((FlatBufferBuilder)builder);
            if (version >= 0) {
                int topicIdOffset = kafka.tier.serdes.UUID.createUUID((FlatBufferBuilder)builder, (long)topicId.getMostSignificantBits(), (long)topicId.getLeastSignificantBits());
                TierPartitionStateHeader.addTopicId((FlatBufferBuilder)builder, (int)topicIdOffset);
                TierPartitionStateHeader.addTierEpoch((FlatBufferBuilder)builder, (int)epoch);
                TierPartitionStateHeader.addVersion((FlatBufferBuilder)builder, (byte)((byte)version));
                TierPartitionStateHeader.addStatus((FlatBufferBuilder)builder, (byte)TierPartitionStatus.toByte((TierPartitionStatus)status));
            }
            if (version >= 1) {
                TierPartitionStateHeader.addEndOffset((FlatBufferBuilder)builder, (long)endOffset);
            }
            if (version >= 2) {
                TierPartitionStateHeader.addMaterializationInfo((FlatBufferBuilder)builder, (int)materializedInfo);
            }
            if (version >= 5) {
                int errorOffsetAndEpochId = kafka.tier.serdes.OffsetAndEpoch.createOffsetAndEpoch((FlatBufferBuilder)builder, (long)errorOffsetAndEpoch.offset(), (int)Predef$.MODULE$.Integer2int(errorOffsetAndEpoch.epoch().orElse(Predef$.MODULE$.int2Integer(-1))));
                TierPartitionStateHeader.addErrorOffsetAndEpoch((FlatBufferBuilder)builder, (int)errorOffsetAndEpochId);
            }
            if (version >= 6) {
                int restoreOffsetAndEpochId = kafka.tier.serdes.OffsetAndEpoch.createOffsetAndEpoch((FlatBufferBuilder)builder, (long)restoreOffsetAndEpoch.offset(), (int)Predef$.MODULE$.Integer2int(restoreOffsetAndEpoch.epoch().orElse(Predef$.MODULE$.int2Integer(-1))));
                TierPartitionStateHeader.addRestoreOffsetAndEpoch((FlatBufferBuilder)builder, (int)restoreOffsetAndEpochId);
            }
            int entryId = TierPartitionStateHeader.endTierPartitionStateHeader((FlatBufferBuilder)builder);
            builder.finish(entryId);
            Header header = new Header(TierPartitionStateHeader.getRootAsTierPartitionStateHeader((ByteBuffer)builder.dataBuffer()));
            Assertions.assertEquals((int)version, (int)header.version());
            Assertions.assertEquals((Object)topicId, (Object)header.topicId());
            Assertions.assertEquals((int)epoch, (int)header.tierEpoch());
            Assertions.assertEquals((Object)status, (Object)header.status());
            if (version >= 2) {
                Assertions.assertEquals((Object)localMaterializedOffsetAndEpoch, (Object)header.localMaterializedOffsetAndEpoch());
                Assertions.assertEquals((Object)globalMaterializedOffset, (Object)header.globalMaterializedOffsetAndEpoch());
            } else {
                Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)header.localMaterializedOffsetAndEpoch());
                Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)header.globalMaterializedOffsetAndEpoch());
            }
            if (version >= 5) {
                Assertions.assertEquals((Object)errorOffsetAndEpoch, (Object)header.errorOffsetAndEpoch());
            } else {
                Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)header.errorOffsetAndEpoch());
            }
            if (version >= 6) {
                Assertions.assertEquals((Object)restoreOffsetAndEpoch, (Object)header.restoreOffsetAndEpoch());
                return;
            }
            Assertions.assertEquals((Object)OffsetAndEpoch.EMPTY, (Object)header.restoreOffsetAndEpoch());
        });
    }
}

