/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.google.cloud.ReadChannel;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.crypto.tink.Aead;
import com.google.crypto.tink.KeyTemplate;
import com.google.crypto.tink.KeyTemplates;
import com.google.crypto.tink.KeysetHandle;
import com.google.crypto.tink.aead.AeadConfig;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.GcsTierObjectStore;
import kafka.tier.store.GcsTierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.encryption.EncryptionKeyManager;
import kafka.tier.store.encryption.KeyContext;
import kafka.tier.store.encryption.KeySha;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001B\u0011#\u0001%BQ\u0001\r\u0001\u0005\u0002EBq\u0001\u000e\u0001C\u0002\u0013\u0005Q\u0007\u0003\u0004=\u0001\u0001\u0006IA\u000e\u0005\b{\u0001\u0011\r\u0011\"\u0001?\u0011\u0019Q\u0005\u0001)A\u0005\u007f!91\n\u0001b\u0001\n\u0003a\u0005B\u0002)\u0001A\u0003%Q\nC\u0004R\u0001\t\u0007I\u0011\u0001*\t\rY\u0003\u0001\u0015!\u0003T\u0011\u001d9\u0006A1A\u0005\u0002aCa!\u001b\u0001!\u0002\u0013I\u0006b\u00026\u0001\u0005\u0004%\ta\u001b\u0005\u0007i\u0002\u0001\u000b\u0011\u00027\t\u000fU\u0004!\u0019!C\u0001m\"1Q\u0010\u0001Q\u0001\n]DqA \u0001C\u0002\u0013\u0005q\u0010\u0003\u0005\u0002\u0012\u0001\u0001\u000b\u0011BA\u0001\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003+Aq!a\u000e\u0001\t\u0003\t)\u0002C\u0004\u0002B\u0001!\t!!\u0006\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002\u0016!9\u0011\u0011\n\u0001\u0005\u0002\u0005U\u0001bBA'\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003#\u0002A\u0011AA\u000b\u0011\u001d\t)\u0006\u0001C\u0001\u0003+Aq!!\u0017\u0001\t\u0003\t)\u0002C\u0004\u0002^\u0001!\t!!\u0006\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002\u0016!9\u0011Q\r\u0001\u0005\u0002\u0005U\u0001bBA5\u0001\u0011\u0005\u00111\u000e\u0005\b\u0003/\u0003A\u0011AAM\u0011\u001d\t\t\u000b\u0001C\u0001\u0003+\u0011acR2t)&,'o\u00142kK\u000e$8\u000b^8sKR+7\u000f\u001e\u0006\u0003G\u0011\nQa\u001d;pe\u0016T!!\n\u0014\u0002\tQLWM\u001d\u0006\u0002O\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\r\t\u0003g\u0001i\u0011AI\u0001\t[>\u001c7\u000eV5nKV\ta\u0007\u0005\u00028u5\t\u0001H\u0003\u0002:M\u0005)Q\u000f^5mg&\u00111\b\u000f\u0002\t\u001b>\u001c7\u000eV5nK\u0006IQn\\2l)&lW\rI\u0001\bgR|'/Y4f+\u0005y\u0004C\u0001!I\u001b\u0005\t%BA\u001fC\u0015\t\u0019E)A\u0003dY>,HM\u0003\u0002F\r\u00061qm\\8hY\u0016T\u0011aR\u0001\u0004G>l\u0017BA%B\u0005\u001d\u0019Fo\u001c:bO\u0016\f\u0001b\u001d;pe\u0006<W\rI\u0001\u0007EV\u001c7.\u001a;\u0016\u00035\u0003\"\u0001\u0011(\n\u0005=\u000b%A\u0002\"vG.,G/A\u0004ck\u000e\\W\r\u001e\u0011\u0002\r\r|gNZ5h+\u0005\u0019\u0006CA\u001aU\u0013\t)&E\u0001\rHGN$\u0016.\u001a:PE*,7\r^*u_J,7i\u001c8gS\u001e\fqaY8oM&<\u0007%\u0001\u0005nKR\fG-\u0019;b+\u0005I\u0006C\u0001.g\u001d\tYFM\u0004\u0002]G:\u0011QL\u0019\b\u0003=\u0006l\u0011a\u0018\u0006\u0003A\"\na\u0001\u0010:p_Rt\u0014\"A\u0014\n\u0005\u00152\u0013BA\u0012%\u0013\t)'%A\bUS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u0013\t9\u0007N\u0001\bPE*,7\r^'fi\u0006$\u0017\r^1\u000b\u0005\u0015\u0014\u0013!C7fi\u0006$\u0017\r^1!\u0003!!Xm\u001d;GS2,W#\u00017\u0011\u00055\u0014X\"\u00018\u000b\u0005=\u0004\u0018AA5p\u0015\u0005\t\u0018\u0001\u00026bm\u0006L!a\u001d8\u0003\t\u0019KG.Z\u0001\ni\u0016\u001cHOR5mK\u0002\n!A\u00192\u0016\u0003]\u0004\"\u0001_>\u000e\u0003eT!A\u001f9\u0002\u00079Lw.\u0003\u0002}s\nQ!)\u001f;f\u0005V4g-\u001a:\u0002\u0007\t\u0014\u0007%A\u0005nCN$XM]&fsV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\ti!\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003\u0011!\u0018N\\6\u000b\u0007\u0005-A)\u0001\u0004def\u0004Ho\\\u0005\u0005\u0003\u001f\t)A\u0001\u0003BK\u0006$\u0017AC7bgR,'oS3zA\u0005)1/\u001a;vaR\u0011\u0011q\u0003\t\u0004W\u0005e\u0011bAA\u000eY\t!QK\\5uQ\r\u0011\u0012q\u0004\t\u0005\u0003C\t\u0019$\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003\r\t\u0007/\u001b\u0006\u0005\u0003S\tY#A\u0004kkBLG/\u001a:\u000b\t\u00055\u0012qF\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003c\t1a\u001c:h\u0013\u0011\t)$a\t\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0007uKN$8+\u001b8hY\u0016\u0004V\u000f\u001e\u0015\u0004'\u0005m\u0002\u0003BA\u0011\u0003{IA!a\u0010\u0002$\t!A+Z:u\u0003\u001d!Xm\u001d;D%\u000eC3\u0001FA\u001e\u0003q!Xm\u001d;TS:<G.\u001a)vi^KG\u000f[!c_J$X\r\u001a+y]ND3!FA\u001e\u0003\u0011\"Xm\u001d;TS:<G.\u001a)viB\u0013x\u000eZ;dKJ\u001cF/\u0019;f\u000bB|7\r[*uCR,\u0007f\u0001\f\u0002<\u0005!B/Z:u\t\u0016dW\r^3BY2\u001cVoY2fgND3aFA\u001e\u0003\u0001\"Xm\u001d;EK2,G/Z*p[\u00164\u0015-\u001b7fI\u001e+G/\u0012=dKB$\u0018n\u001c8)\u0007a\tY$\u0001\u0012uKN$H)\u001a7fi\u0016\u001cv.\\3GC&dW\rZ$fi:{W\t_2faRLwN\u001c\u0015\u00043\u0005m\u0012A\r;fgR,en\u0019:zaR,GMR3uG\"<\u0016\u000e\u001e5O_\u0016s7M]=qi&|gnS3z\u001b\u0006t\u0017mZ3s)\"\u0014xn^:)\u0007i\tY$A\u001duKN$xiY:US\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f\u0007>t7\u000f\u001e:vGR$\u0006N]8xg^KG\u000f[%om\u0006d\u0017\u000eZ&fs\u000e{gNZ5hQ\rY\u00121H\u0001+i\u0016\u001cH\u000f\u0015:faB+HoU3h[\u0016tGoV5uQ\u0016s7M]=qi&|gnS3z\u001b\u0006t\u0017mZ3sQ\ra\u00121H\u0001.i\u0016\u001cH\u000f\u0015:faB+HoU3h[\u0016tGoV5uQ>,H/\u00128def\u0004H/[8o\u0017\u0016LX*\u00198bO\u0016\u0014\bfA\u000f\u0002<\u0005\u0001D/Z:u\u000b:\u001c'/\u001f9uK\u0012\u001cVmZ7f]R\u0014V-\u00193Vg\u0016\u001cXI\\2ssB$\u0018n\u001c8LKfl\u0015M\\1hKJ$B!a\u0006\u0002n!9\u0011q\u000e\u0010A\u0002\u0005E\u0014\u0001\u00034jY\u0016$\u0018\u0010]3\u0011\u0007i\u000b\u0019(C\u0002\u0002v!\u0014\u0001BR5mKRK\b/\u001a\u0015\b=\u0005e\u0014\u0011RAF!\u0011\tY(!\"\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000b\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0005\u0003\u0007\u000b9#\u0001\u0004qCJ\fWn]\u0005\u0005\u0003\u000f\u000biH\u0001\u0006F]Vl7k\\;sG\u0016\fQA^1mk\u0016\u001c#!!\u001d)\u0007y\ty\t\u0005\u0003\u0002\u0012\u0006MUBAAA\u0013\u0011\t)*!!\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/A\u0010uKN$XI\\2ssB$X\r\u001a*fC\u0012\u0014VM\u001a:fg\",7oQ1dQ\u0016$B!a\u0006\u0002\u001c\"9\u0011qN\u0010A\u0002\u0005E\u0004fB\u0010\u0002z\u0005%\u00151\u0012\u0015\u0004?\u0005=\u0015!\u0005;fgR,en\u0019:zaR,G\rU;ug\"\u001a\u0001%a\u000f")
public class GcsTierObjectStoreTest {
    private final MockTime mockTime = new MockTime();
    private final Storage storage = (Storage)Mockito.mock(Storage.class);
    private final Bucket bucket = (Bucket)Mockito.mock(Bucket.class);
    private final GcsTierObjectStoreConfig config = GcsTierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"prefix", (String)"region", (Integer)Predef$.MODULE$.int2Integer(10240), (String)"path", null, null);
    private final TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, TierObjectStore.OpaqueData.ZEROED);
    private final File testFile = TestUtils$.MODULE$.tempFile();
    private final ByteBuffer bb = ByteBuffer.allocate(0);
    private final Aead masterKey;

    public MockTime mockTime() {
        return this.mockTime;
    }

    public Storage storage() {
        return this.storage;
    }

    public Bucket bucket() {
        return this.bucket;
    }

    public GcsTierObjectStoreConfig config() {
        return this.config;
    }

    public TierObjectStore.ObjectMetadata metadata() {
        return this.metadata;
    }

    public File testFile() {
        return this.testFile;
    }

    public ByteBuffer bb() {
        return this.bb;
    }

    public Aead masterKey() {
        return this.masterKey;
    }

    @BeforeEach
    public void setup() {
        Mockito.when((Object)this.storage().get(ArgumentMatchers.anyString(), new Storage.BucketGetOption[]{(Storage.BucketGetOption)ArgumentMatchers.any(Storage.BucketGetOption.class)})).thenReturn((Object)this.bucket());
        Mockito.when((Object)this.storage().writer((BlobInfo)ArgumentMatchers.any(BlobInfo.class), new Storage.BlobWriteOption[0])).thenReturn(Mockito.mock(WriteChannel.class));
        Mockito.when((Object)this.storage().writer((BlobInfo)ArgumentMatchers.any(BlobInfo.class), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)ArgumentMatchers.any(Storage.BlobWriteOption.class)})).thenReturn(Mockito.mock(WriteChannel.class));
        Mockito.when((Object)this.bucket().getLocation()).thenReturn((Object)"REGION");
    }

    @Test
    public void testSinglePut() {
        new GcsTierObjectStore(this.storage(), null, this.config()).putSegment(this.metadata(), this.testFile(), this.testFile(), this.testFile(), Optional.empty(), Optional.empty(), Optional.empty());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)3))).writer((BlobInfo)ArgumentMatchers.any(BlobInfo.class), new Storage.BlobWriteOption[0]);
    }

    @Test
    public void testCRC() {
        ByteBuffer al = ByteBuffer.allocate(5);
        al.put((byte)1);
        al.flip();
        Assertions.assertEquals((Object)"oBbQUg==", (Object)GcsTierObjectStore.crc32c((ByteBuffer)al));
    }

    @Test
    public void testSinglePutWithAbortedTxns() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config());
        ArgumentCaptor capturedBlobInfos = ArgumentCaptor.forClass(BlobInfo.class);
        ArgumentCaptor capturedOption = ArgumentCaptor.forClass(Storage.BlobWriteOption.class);
        objectStore.putSegment(this.metadata(), this.testFile(), this.testFile(), this.testFile(), Optional.empty(), Optional.of(this.bb()), Optional.empty());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)4))).writer((BlobInfo)capturedBlobInfos.capture(), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)capturedOption.capture()});
        List captureds = ((TraversableOnce)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(capturedBlobInfos.getAllValues()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1, Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getCrc32c(), Buffer$.MODULE$.canBuildFrom())).toList();
        Assertions.assertEquals((Object)new .colon.colon(null, (List)new .colon.colon(null, (List)new .colon.colon(null, (List)new .colon.colon((Object)"AAAAAA==", (List)Nil$.MODULE$)))), (Object)captureds);
        Assertions.assertEquals((Object)Storage.BlobWriteOption.crc32cMatch(), (Object)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(capturedOption.getAllValues()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3, Buffer$.MODULE$.canBuildFrom())).head());
    }

    @Test
    public void testSinglePutProducerStateEpochState() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config());
        ArgumentCaptor capturedBlobInfos = ArgumentCaptor.forClass(BlobInfo.class);
        ArgumentCaptor capturedOption = ArgumentCaptor.forClass(Storage.BlobWriteOption.class);
        objectStore.putSegment(this.metadata(), this.testFile(), this.testFile(), this.testFile(), Optional.of(this.testFile()), Optional.empty(), Optional.of(this.bb()));
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)5))).writer((BlobInfo)capturedBlobInfos.capture(), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)capturedOption.capture()});
        List captureds = ((TraversableOnce)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(capturedBlobInfos.getAllValues()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4, Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getCrc32c(), Buffer$.MODULE$.canBuildFrom())).toList();
        Assertions.assertEquals((Object)new .colon.colon(null, (List)new .colon.colon(null, (List)new .colon.colon(null, (List)new .colon.colon(null, (List)new .colon.colon((Object)"AAAAAA==", (List)Nil$.MODULE$))))), (Object)captureds);
        Assertions.assertEquals((Object)Storage.BlobWriteOption.crc32cMatch(), (Object)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(capturedOption.getAllValues()).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6, Buffer$.MODULE$.canBuildFrom())).head());
    }

    @Test
    public void testDeleteAllSuccess() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config());
        ArrayList<Boolean> deleteResult = new ArrayList<Boolean>();
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        Mockito.when((Object)this.storage().delete((Iterable)ArgumentMatchers.any(ArrayList.class))).thenReturn(deleteResult);
        objectStore.deleteSegment(this.metadata());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)0))).get((BlobId)ArgumentMatchers.any(BlobId.class));
    }

    @Test
    public void testDeleteSomeFailedGetException() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config());
        ArrayList<Boolean> deleteResult = new ArrayList<Boolean>();
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(false));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        Mockito.when((Object)this.storage().delete((Iterable)ArgumentMatchers.any(ArrayList.class))).thenReturn(deleteResult);
        Blob blob = (Blob)Mockito.mock(Blob.class);
        Mockito.when((Object)this.storage().get((BlobId)ArgumentMatchers.any(BlobId.class))).thenReturn((Object)blob);
        try {
            objectStore.deleteSegment(this.metadata());
        }
        catch (TierObjectStoreRetriableException tierObjectStoreRetriableException) {
            ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).get((BlobId)ArgumentMatchers.any(BlobId.class));
            ((BlobInfo)Mockito.verify((Object)blob, (VerificationMode)Mockito.atLeastOnce())).getBlobId();
            return;
        }
        Assertions.fail((String)"TierObjectStoreRetriableException should have been thrown when attempting to delete segments");
    }

    @Test
    public void testDeleteSomeFailedGetNoException() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config());
        ArrayList<Boolean> deleteResult = new ArrayList<Boolean>();
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(true));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(false));
        deleteResult.add(Predef$.MODULE$.boolean2Boolean(false));
        Mockito.when((Object)this.storage().delete((Iterable)ArgumentMatchers.any(ArrayList.class))).thenReturn(deleteResult);
        Mockito.when((Object)this.storage().get((BlobId)ArgumentMatchers.any(BlobId.class))).thenReturn(null);
        objectStore.deleteSegment(this.metadata());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)2))).get((BlobId)ArgumentMatchers.any(BlobId.class));
    }

    @Test
    public void testEncryptedFetchWithNoEncryptionKeyManagerThrows() {
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), null, this.config());
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, TierObjectStore.OpaqueData.fromByteArray((byte[])"foo".getBytes()));
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> objectStore.getObject((TierObjectStore.ObjectStoreMetadata)metadata, TierObjectStore.FileType.SEGMENT));
    }

    @Test
    public void testGcsTierObjectStoreConstructThrowsWithInvalidKeyConfig() {
        GcsTierObjectStoreConfig config = GcsTierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"prefix", (String)"region", (Integer)Predef$.MODULE$.int2Integer(10240), (String)"path", (String)"invalid", (Duration)Duration.ofSeconds(30L));
        Assertions.assertThrows(TierObjectStoreFatalException.class, () -> new GcsTierObjectStore((Time)this.mockTime(), null, config));
    }

    @Test
    public void testPrepPutSegmentWithEncryptionKeyManager() {
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)this.mockTime(), null, this.masterKey(), Duration.ofSeconds(30L));
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), encryptionKeyManager, this.config());
        TierObjectStore.OpaqueData opaqueData1 = objectStore.prepPutSegment();
        TierObjectStore.OpaqueData opaqueData2 = objectStore.prepPutSegment();
        Assertions.assertTrue((boolean)Arrays.equals(opaqueData1.intoByteArray(), opaqueData2.intoByteArray()));
        this.mockTime().sleep(31000L);
        Assertions.assertFalse((boolean)Arrays.equals(opaqueData1.intoByteArray(), objectStore.prepPutSegment().intoByteArray()));
    }

    @Test
    public void testPrepPutSegmentWithoutEncryptionKeyManager() {
        Assertions.assertTrue((boolean)Arrays.equals(new GcsTierObjectStore(this.storage(), null, this.config()).prepPutSegment().intoByteArray(), TierObjectStore.OpaqueData.ZEROED.intoByteArray()));
    }

    @ParameterizedTest
    @EnumSource(value=TierObjectStore.FileType.class)
    public void testEncryptedSegmentReadUsesEncryptionKeyManager(TierObjectStore.FileType filetype) {
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)this.mockTime(), null, this.masterKey(), Duration.ofSeconds(30L));
        KeySha keySha = encryptionKeyManager.activeKeySha();
        TierObjectStore.OpaqueData opaqueData = TierObjectStore.OpaqueData.fromByteArray((byte[])keySha.toRawBytes());
        KeyContext expectedKeyContext = encryptionKeyManager.keyContext(keySha);
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), encryptionKeyManager, this.config());
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, opaqueData);
        ReadChannel reader = (ReadChannel)Mockito.mock(ReadChannel.class);
        Mockito.when((Object)this.storage().reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.any()})).thenReturn((Object)reader).thenReturn((Object)reader);
        objectStore.getObject((TierObjectStore.ObjectStoreMetadata)metadata, filetype);
        if (filetype.equals((Object)TierObjectStore.FileType.SEGMENT)) {
            ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.eq((Object)Storage.BlobSourceOption.decryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded()))});
            return;
        }
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.never())).reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.eq((Object)Storage.BlobSourceOption.decryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded()))});
    }

    @ParameterizedTest
    @EnumSource(value=TierObjectStore.FileType.class)
    public void testEncryptedReadRefreshesCache(TierObjectStore.FileType filetype) {
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)this.mockTime(), null, this.masterKey(), Duration.ofSeconds(30L));
        KeySha keySha = encryptionKeyManager.activeKeySha();
        TierObjectStore.OpaqueData opaqueData = TierObjectStore.OpaqueData.fromByteArray((byte[])keySha.toRawBytes());
        KeyContext expectedKeyContext = encryptionKeyManager.keyContext(keySha);
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), encryptionKeyManager, this.config());
        encryptionKeyManager.clear();
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, opaqueData);
        Blob blob = (Blob)Mockito.mock(Blob.class);
        Mockito.when((Object)this.storage().get((BlobId)ArgumentMatchers.any(), new Storage.BlobGetOption[]{(Storage.BlobGetOption)ArgumentMatchers.eq((Object)Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.METADATA}))})).thenReturn((Object)blob);
        Mockito.when((Object)blob.getMetadata()).thenReturn((Object)expectedKeyContext.metadata);
        ReadChannel reader = (ReadChannel)Mockito.mock(ReadChannel.class);
        Mockito.when((Object)this.storage().reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.any()})).thenReturn((Object)reader).thenReturn((Object)reader);
        objectStore.getObject((TierObjectStore.ObjectStoreMetadata)metadata, filetype);
        if (filetype.equals((Object)TierObjectStore.FileType.SEGMENT)) {
            ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.eq((Object)Storage.BlobSourceOption.decryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded()))});
            ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).get((BlobId)ArgumentMatchers.any(), new Storage.BlobGetOption[]{(Storage.BlobGetOption)ArgumentMatchers.eq((Object)Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.METADATA}))});
            return;
        }
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.never())).reader((BlobId)ArgumentMatchers.any(), new Storage.BlobSourceOption[]{(Storage.BlobSourceOption)ArgumentMatchers.eq((Object)Storage.BlobSourceOption.decryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded()))});
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.never())).get((BlobId)ArgumentMatchers.any(), new Storage.BlobGetOption[]{(Storage.BlobGetOption)ArgumentMatchers.eq((Object)Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.METADATA}))});
    }

    @Test
    public void testEncryptedPuts() {
        EncryptionKeyManager encryptionKeyManager = new EncryptionKeyManager((Time)this.mockTime(), null, this.masterKey(), Duration.ofSeconds(30L));
        KeySha keySha = encryptionKeyManager.activeKeySha();
        TierObjectStore.OpaqueData opaqueData = TierObjectStore.OpaqueData.fromByteArray((byte[])keySha.toRawBytes());
        KeyContext expectedKeyContext = encryptionKeyManager.keyContext(keySha);
        GcsTierObjectStore objectStore = new GcsTierObjectStore(this.storage(), encryptionKeyManager, this.config());
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, opaqueData);
        objectStore.putSegment(metadata, this.testFile(), this.testFile(), this.testFile(), Optional.empty(), Optional.empty(), Optional.empty());
        ((Storage)Mockito.verify((Object)this.storage(), (VerificationMode)Mockito.times((int)1))).writer((BlobInfo)ArgumentMatchers.any(), new Storage.BlobWriteOption[]{(Storage.BlobWriteOption)ArgumentMatchers.eq((Object)Storage.BlobWriteOption.encryptionKey((String)expectedKeyContext.cleartextDataKey.base64Encoded()))});
    }

    public GcsTierObjectStoreTest() {
        AeadConfig.register();
        this.masterKey = (Aead)KeysetHandle.generateNew((KeyTemplate)KeyTemplates.get((String)"AES256_GCM_RAW")).getPrimitive(Aead.class);
    }
}

