/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tier.store.S3TierObjectStoreConfig;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Test;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Matchers$;
import org.scalatest.enablers.Aggregating$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.GenTraversable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u2AAC\u0006\u0001%!)\u0011\u0004\u0001C\u00015!)Q\u0004\u0001C\u0001=!)q\u0006\u0001C\u0001=!)\u0011\u0007\u0001C\u0001=!)1\u0007\u0001C\u0001=!)Q\u0007\u0001C\u0001=!)q\u0007\u0001C\u0001=!)\u0011\b\u0001C\u0001=!)1\b\u0001C\u0001=\tY2k\r+jKJ|%M[3diN#xN]3D_:4\u0017n\u001a+fgRT!\u0001D\u0007\u0002\u000bM$xN]3\u000b\u00059y\u0011\u0001\u0002;jKJT\u0011\u0001E\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\u0003\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003-\tQ\u0003^3tiZ\u000bG.\u001b3D_:4\u0017n\u001a(p\u0003V$\b\u000eF\u0001 !\t!\u0002%\u0003\u0002\"+\t!QK\\5uQ\t\u00111\u0005\u0005\u0002%[5\tQE\u0003\u0002'O\u0005\u0019\u0011\r]5\u000b\u0005!J\u0013a\u00026va&$XM\u001d\u0006\u0003U-\nQA[;oSRT\u0011\u0001L\u0001\u0004_J<\u0017B\u0001\u0018&\u0005\u0011!Vm\u001d;\u0002/Q,7\u000f\u001e,bY&$7i\u001c8gS\u001e<\u0016\u000e\u001e5BkRD\u0007FA\u0002$\u0003m!Xm\u001d;WC2LGmQ8oM&<w+\u001b;i\u000b:$\u0007o\\5oi\"\u0012AaI\u0001\u001ai\u0016\u001cH/\u00138wC2LGmQ8oM&<gj\u001c*fO&|g\u000e\u000b\u0002\u0006G\u0005iA/Z:u+N,'/Q4f]RD#AB\u0012\u0002!Q,7\u000f\u001e+jKJ\u001c6\u000f\u001c,bY&$\u0007FA\u0004$\u0003q!Xm\u001d;US\u0016\u00148k\u001d7J]Z\fG.\u001b3UeV\u001cHo\u0015;pe\u0016D#\u0001C\u0012\u00025Q,7\u000f\u001e+jKJ\u001c6\u000f\\%om\u0006d\u0017\u000eZ&fsN#xN]3)\u0005%\u0019\u0003")
public class S3TierObjectStoreConfigTest {
    @Test
    public void testValidConfigNoAuth() {
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.TierS3BucketProp(), "bucket");
        props.put(KafkaConfig$.MODULE$.TierS3RegionProp(), "region");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        S3TierObjectStoreConfig s3Config = new S3TierObjectStoreConfig(Optional.of("clusterid"), kafkaConfig);
        Predef$.MODULE$.assert(!s3Config.s3CredFilePath.isPresent());
    }

    @Test
    public void testValidConfigWithAuth() {
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.TierS3BucketProp(), "bucket");
        props.put(KafkaConfig$.MODULE$.TierS3RegionProp(), "region");
        props.put(KafkaConfig$.MODULE$.TierS3CredFilePathProp(), "file/path");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        S3TierObjectStoreConfig s3Config = new S3TierObjectStoreConfig(Optional.of("clusterid"), kafkaConfig);
        Predef$.MODULE$.assert(s3Config.s3CredFilePath.isPresent());
    }

    @Test
    public void testValidConfigWithEndpoint() {
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.TierS3BucketProp(), "bucket");
        props.put(KafkaConfig$.MODULE$.TierS3RegionProp(), "region");
        props.put(KafkaConfig$.MODULE$.TierS3EndpointOverrideProp(), "endpoint");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        S3TierObjectStoreConfig s3Config = new S3TierObjectStoreConfig(Optional.of("clusterid"), kafkaConfig);
        Predef$.MODULE$.assert(s3Config.s3EndpointOverride.isPresent());
    }

    @Test
    public void testInvalidConfigNoRegion() {
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.TierS3BucketProp(), "bucket");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> new S3TierObjectStoreConfig(Optional.of("clusterid"), kafkaConfig), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("S3TierObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
    }

    @Test
    public void testUserAgent() {
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.TierS3BucketProp(), "bucket");
        props.put(KafkaConfig$.MODULE$.TierS3RegionProp(), "region");
        props.put(KafkaConfig$.MODULE$.TierS3UserAgentPrefix(), "myuseragent");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Matchers$.MODULE$.convertToAnyShouldWrapper((Object)new S3TierObjectStoreConfig(Optional.of("clusterid"), (KafkaConfig)kafkaConfig).s3UserAgentPrefix, new Position("S3TierObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64), Prettifier$.MODULE$.default()).shouldBe((Object)"myuseragent");
    }

    @Test
    public void testTierSslValid() {
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.TierS3BucketProp(), "bucket");
        props.put(KafkaConfig$.MODULE$.TierS3RegionProp(), "region");
        props.put(KafkaConfig$.MODULE$.TierS3SslProtocolProp(), "TLSv1.2");
        props.put(KafkaConfig$.MODULE$.TierS3SslEnabledProtocolsProp(), "TLSv1.2,TLSv1.3");
        props.put(KafkaConfig$.MODULE$.TierS3SslTrustStoreLocationProp(), "/tmp/truststore");
        props.put(KafkaConfig$.MODULE$.TierS3SslTrustStorePasswordProp(), "trustStorePassword");
        props.put(KafkaConfig$.MODULE$.TierS3SslTrustStoreTypeProp(), "JKS");
        props.put(KafkaConfig$.MODULE$.TierS3SslKeyStoreLocationProp(), "/tmp/keystore");
        props.put(KafkaConfig$.MODULE$.TierS3SslKeyStorePasswordProp(), "keyStorePassword");
        props.put(KafkaConfig$.MODULE$.TierS3SslKeyStoreTypeProp(), "JKS");
        props.put(KafkaConfig$.MODULE$.TierS3SslKeyPasswordProp(), "keyPassword");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        S3TierObjectStoreConfig s3Config = new S3TierObjectStoreConfig(Optional.of("clusterid"), kafkaConfig);
        Matchers$.MODULE$.convertToAnyShouldWrapper((Object)s3Config.s3SslProtocol, new Position("S3TierObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83), Prettifier$.MODULE$.default()).shouldBe((Object)"TLSv1.2");
        Matchers$.MODULE$.convertToAnyShouldWrapper((Object)s3Config.s3SslEnabledProtocols, new Position("S3TierObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84), Prettifier$.MODULE$.default()).should(Matchers$.MODULE$.contain()).theSameElementsAs((GenTraversable)new .colon.colon((Object)"TLSv1.2", (List)new .colon.colon((Object)"TLSv1.3", (List)Nil$.MODULE$)), Aggregating$.MODULE$.aggregatingNatureOfJavaCollection(Equality$.MODULE$.default()));
        Matchers$.MODULE$.convertToAnyShouldWrapper(s3Config.s3SslTrustStoreLocation.get(), new Position("S3TierObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85), Prettifier$.MODULE$.default()).shouldBe((Object)"/tmp/truststore");
        Matchers$.MODULE$.convertToAnyShouldWrapper((Object)((Password)s3Config.s3SslTrustStorePassword.get()).value(), new Position("S3TierObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86), Prettifier$.MODULE$.default()).shouldBe((Object)"trustStorePassword");
        Matchers$.MODULE$.convertToAnyShouldWrapper(s3Config.s3SslTrustStoreType.get(), new Position("S3TierObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87), Prettifier$.MODULE$.default()).shouldBe((Object)"JKS");
        Matchers$.MODULE$.convertToAnyShouldWrapper(s3Config.s3SslKeyStoreLocation.get(), new Position("S3TierObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 88), Prettifier$.MODULE$.default()).shouldBe((Object)"/tmp/keystore");
        Matchers$.MODULE$.convertToAnyShouldWrapper((Object)((Password)s3Config.s3SslKeyStorePassword.get()).value(), new Position("S3TierObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89), Prettifier$.MODULE$.default()).shouldBe((Object)"keyStorePassword");
        Matchers$.MODULE$.convertToAnyShouldWrapper(s3Config.s3SslKeyStoreType.get(), new Position("S3TierObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90), Prettifier$.MODULE$.default()).shouldBe((Object)"JKS");
        Matchers$.MODULE$.convertToAnyShouldWrapper((Object)((Password)s3Config.s3SslKeyPassword.get()).value(), new Position("S3TierObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91), Prettifier$.MODULE$.default()).shouldBe((Object)"keyPassword");
    }

    @Test
    public void testTierSslInvalidTrustStore() {
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.TierS3BucketProp(), "bucket");
        props.put(KafkaConfig$.MODULE$.TierS3RegionProp(), "region");
        props.put(KafkaConfig$.MODULE$.TierS3SslTrustStoreLocationProp(), "/tmp/file");
        props.put(KafkaConfig$.MODULE$.TierS3SslTrustStorePasswordProp(), "trustStorePassword");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> new S3TierObjectStoreConfig(Optional.of("clusterid"), kafkaConfig), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("S3TierObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
    }

    @Test
    public void testTierSslInvalidKeyStore() {
        int x$1 = 0;
        String x$2 = "127.0.0.1:1";
        int x$3 = -1;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.TierS3BucketProp(), "bucket");
        props.put(KafkaConfig$.MODULE$.TierS3RegionProp(), "region");
        props.put(KafkaConfig$.MODULE$.TierS3SslKeyStoreLocationProp(), "/tmp/file");
        props.put(KafkaConfig$.MODULE$.TierS3SslKeyStorePasswordProp(), "keyStorePassword");
        props.put(KafkaConfig$.MODULE$.TierS3SslKeyPasswordProp(), "keyPassword");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable & scala.Serializable)() -> new S3TierObjectStoreConfig(Optional.of("clusterid"), kafkaConfig), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("S3TierObjectStoreConfigTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
    }
}

