/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.store;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AbstractPutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.UUID;
import kafka.tier.TopicIdPartition;
import kafka.tier.store.S3TierObjectStore;
import kafka.tier.store.S3TierObjectStoreConfig;
import kafka.tier.store.TierObjectStore;
import org.apache.kafka.common.config.SslConfigs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E2AAB\u0004\u0001\u001d!)Q\u0003\u0001C\u0001-!)\u0011\u0004\u0001C\u00015!)1\u0006\u0001C\u00015!)Q\u0006\u0001C\u00015!)q\u0006\u0001C\u00015\t)2k\r+jKJ|%M[3diN#xN]3UKN$(B\u0001\u0005\n\u0003\u0015\u0019Ho\u001c:f\u0015\tQ1\"\u0001\u0003uS\u0016\u0014(\"\u0001\u0007\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0004\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u00059\u0011a\u000e;fgR$\u0006.\u0019;Qe>\u0004XM]#se>\u0014\u0018j\u001d*fiV\u0014h.\u001a3G_JLenY8se\u0016\u001cGOU3hS>t7+\u001a;uS:<7\u000fF\u0001\u001c!\t\u0001B$\u0003\u0002\u001e#\t!QK\\5uQ\t\u0011q\u0004\u0005\u0002!S5\t\u0011E\u0003\u0002#G\u0005\u0019\u0011\r]5\u000b\u0005\u0011*\u0013a\u00026va&$XM\u001d\u0006\u0003M\u001d\nQA[;oSRT\u0011\u0001K\u0001\u0004_J<\u0017B\u0001\u0016\"\u0005\u0011!Vm\u001d;\u0002\u001bQ,7\u000f^*j]\u001edW\rU;uQ\t\u0019q$\u0001\u000fuKN$8+\u001b8hY\u0016\u0004V\u000f^,ji\"\f%m\u001c:uK\u0012$\u0006P\\:)\u0005\u0011y\u0012\u0001\n;fgR\u001c\u0016N\\4mKB+H\u000f\u0015:pIV\u001cWM]*uCR,W\t]8dQN#\u0018\r^3)\u0005\u0015y\u0002")
public class S3TierObjectStoreTest {
    @Test
    public void testThatProperErrorIsReturnedForIncorrectRegionSettings() {
        Assertions.assertEquals((Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            S3TierObjectStoreConfig config = S3TierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"invalid-region", (String)"credFilePath", (String)"endpoint", (String)"signer", (String)"sseAlgorithm", (String)"", (Integer)Predef$.MODULE$.int2Integer(0), (String)"", (String)"", (Boolean)Predef$.MODULE$.boolean2Boolean(false), (String)"myuserprefix", (String)SslConfigs.DEFAULT_SSL_PROTOCOL, (String)SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS, null, null, null, null, null, null, null);
            new S3TierObjectStore(config);
        })).getMessage(), (Object)"Configured confluent.tier.s3.region 'invalid-region' is not known");
        Assertions.assertEquals((Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            S3TierObjectStoreConfig config = S3TierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"", (String)"credFilePath", (String)"endpoint", (String)"signer", (String)"sseAlgorithm", (String)"", (Integer)Predef$.MODULE$.int2Integer(0), (String)"", (String)"", (Boolean)Predef$.MODULE$.boolean2Boolean(false), (String)"myuserprefix", (String)SslConfigs.DEFAULT_SSL_PROTOCOL, (String)SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS, null, null, null, null, null, null, null);
            new S3TierObjectStore(config);
        })).getMessage(), (Object)"Configured confluent.tier.s3.region '' is not known");
        Assertions.assertEquals((Object)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> {
            S3TierObjectStoreConfig config = S3TierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", null, (String)"credFilePath", (String)"endpoint", (String)"signer", (String)"sseAlgorithm", (String)"", (Integer)Predef$.MODULE$.int2Integer(0), (String)"", (String)"", (Boolean)Predef$.MODULE$.boolean2Boolean(false), (String)"myuserprefix", (String)SslConfigs.DEFAULT_SSL_PROTOCOL, (String)SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS, null, null, null, null, null, null, null);
            new S3TierObjectStore(config);
        })).getMessage(), (Object)"Configured confluent.tier.s3.region 'null' is not known");
    }

    @Test
    public void testSinglePut() {
        int segmentSize = 100;
        AmazonS3 client = (AmazonS3)Mockito.mock(AmazonS3.class);
        Mockito.when((Object)client.getBucketLocation("bucket")).thenReturn((Object)"region");
        S3TierObjectStoreConfig config = S3TierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"region", (String)"credFilePath", (String)"endpoint", (String)"signer", (String)"sseAlgorithm", (String)"", (Integer)Predef$.MODULE$.int2Integer(0), (String)"", (String)"", (Boolean)Predef$.MODULE$.boolean2Boolean(false), (String)"myuserprefix", (String)SslConfigs.DEFAULT_SSL_PROTOCOL, (String)SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS, null, null, null, null, null, null, null);
        S3TierObjectStore objectStore = new S3TierObjectStore(client, config);
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, false, false, false, TierObjectStore.OpaqueData.ZEROED);
        File segmentData = (File)Mockito.mock(File.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)segmentData.length())).thenReturn((Object)BoxesRunTime.boxToLong((long)segmentSize));
        objectStore.putSegment(metadata, segmentData, null, null, Optional.empty(), Optional.empty(), Optional.empty());
        ((AmazonS3)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)3))).putObject((PutObjectRequest)ArgumentMatchers.any());
    }

    @Test
    public void testSinglePutWithAbortedTxns() {
        int segmentSize = 100;
        AmazonS3 client = (AmazonS3)Mockito.mock(AmazonS3.class);
        Mockito.when((Object)client.getBucketLocation("bucket")).thenReturn((Object)"region");
        S3TierObjectStoreConfig config = S3TierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"region", (String)"credFilePath", (String)"endpoint", (String)"signer", (String)"sseAlgorithm", (String)"", (Integer)Predef$.MODULE$.int2Integer(0), (String)"", (String)"", (Boolean)Predef$.MODULE$.boolean2Boolean(false), (String)"myuserprefix", (String)SslConfigs.DEFAULT_SSL_PROTOCOL, (String)SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS, null, null, null, null, null, null, null);
        S3TierObjectStore objectStore = new S3TierObjectStore(client, config);
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, true, false, false, TierObjectStore.OpaqueData.ZEROED);
        File segmentData = (File)Mockito.mock(File.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)segmentData.length())).thenReturn((Object)BoxesRunTime.boxToLong((long)segmentSize));
        objectStore.putSegment(metadata, segmentData, null, null, Optional.empty(), Optional.of(ByteBuffer.allocate(0)), Optional.empty());
        ((AmazonS3)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)4))).putObject((PutObjectRequest)ArgumentMatchers.any());
    }

    @Test
    public void testSinglePutProducerStateEpochState() {
        int segmentSize = 100;
        AmazonS3 client = (AmazonS3)Mockito.mock(AmazonS3.class);
        Mockito.when((Object)client.getBucketLocation("bucket")).thenReturn((Object)"region");
        S3TierObjectStoreConfig config = S3TierObjectStoreConfig.createWithEmptyClusterIdBrokerId((String)"bucket", (String)"region", (String)"credFilePath", (String)"endpoint", (String)"signer", (String)"sseAlgorithm", (String)"", (Integer)Predef$.MODULE$.int2Integer(0), (String)"", (String)"", (Boolean)Predef$.MODULE$.boolean2Boolean(false), (String)"myuserprefix", (String)SslConfigs.DEFAULT_SSL_PROTOCOL, (String)SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS, null, null, null, null, null, null, null);
        S3TierObjectStore objectStore = new S3TierObjectStore(client, config);
        TierObjectStore.ObjectMetadata metadata = new TierObjectStore.ObjectMetadata(new TopicIdPartition("foo", UUID.randomUUID(), 0), UUID.randomUUID(), 0, 0L, true, true, true, TierObjectStore.OpaqueData.ZEROED);
        File segmentData = (File)Mockito.mock(File.class);
        ArgumentCaptor captor = ArgumentCaptor.forClass(PutObjectRequest.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)segmentData.length())).thenReturn((Object)BoxesRunTime.boxToLong((long)segmentSize));
        int producerIndexLength = 100;
        ByteBuffer producerIndexBuf = ByteBuffer.allocate(producerIndexLength);
        producerIndexBuf.limit(producerIndexLength);
        int epochLength = 100;
        ByteBuffer epochBuf = ByteBuffer.allocate(epochLength);
        epochBuf.limit(epochLength);
        objectStore.putSegment(metadata, segmentData, null, null, Optional.of(segmentData), Optional.of(producerIndexBuf), Optional.of(epochBuf));
        ((AmazonS3)Mockito.verify((Object)client, (VerificationMode)Mockito.times((int)6))).putObject((PutObjectRequest)captor.capture());
        Assertions.assertEquals((long)producerIndexLength, (long)((AbstractPutObjectRequest)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(captor.getAllValues()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1, Buffer$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)S3TierObjectStoreTest.$anonfun$testSinglePutProducerStateEpochState$2(x$2))).get()).getMetadata().getContentLength());
    }

    public static final /* synthetic */ boolean $anonfun$testSinglePutProducerStateEpochState$2(PutObjectRequest x$2) {
        return x$2.getKey().contains(".transaction-index");
    }
}

